C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdparm(nt,f1,f2,f3,f4,dtmsec,jt0,t0,tmax,
     1                  mutemin,mutemax,lerr)
C
      parameter    (pi=3.1415926)
      integer      lerr
c
      ierror=0
      call argi4('-lenmute',lenmute,-99999,-99999)
      if (lenmute .eq. -99999) lenmute = 10*dtmsec
c
      call argr4('-t0',t0,0.,0.)
      call argr4('-f1',f1,3.,3.)
      call argr4('-f2',f2,8.,8.)
      call argr4('-f3',f3,50.,50.)
      call argr4('-f4',f4,60.,60.)
      jt0=nint(t0/dtmsec)
      mutemin=nint(-float(lenmute)/dtmsec)
      mutemax=0  
      tmax=nt*dtmsec
      if(f1 .gt. f2 .or. f2 .gt. f3 .or. f3 .gt. f4) then
         write(lerr,*) ' filter points must be in ascending order:'
         write(lerr,*) ' f1<f2<f3<f4'
         write(lerr,*) ' f1 = ',f1
         write(lerr,*) ' f2 = ',f2
         write(lerr,*) ' f3 = ',f3
         write(lerr,*) ' f4 = ',f4
         ierror=ierror+1
      endif 
      if(t0 .lt. 0. .or. t0 .gt. tmax) then       
         write(lerr,*) 'error in input parameters detected in rdparm!'
         write(lerr,*) 'origin time (-t0) must fall between'//
     1                     '  0. and tmax'
         write(lerr,*) 't0   = ',t0,' msec'
         write(lerr,*) 'tmax = ',tmax,' msec'
         write(lerr,*)
         ierror=ierror+1
      endif
      if(ierror .gt. 0) then
         write(lerr,*)'program aborted in rdparm due to input errrors'
         write(lerr,*)
         stop 7666
      endif
c
      return
      end
