C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C   ROUTINE:       LAIP                                                 00000100
C   ROUTINE TYPE:  MAIN                                                 00000200
C   PURPOSE:  LAND LINE INDEXING WITH WEATHERING STATICS COMPUTATION    00000300
C   AUTHOR:  DOUGLAS BODDY                                              00000400
C   DATE WRITTEN:  AUGUST 1985                                          00000500
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00000600
C                                                                       00000700
C   MODIFICATION HISTORY:   07/15/86   E. JOHNSON                       00000800
C                           ADDED OAC CHECK (GETD AND GETTAB)           00000900
C                           ADDED SHOT POINT/MILE IN LINE HEADER        00001000
C                                                                       00001100
C                           06/08/86   J. VINSON                        00001200
C                           CHANGED TO ALWAYS CALCULATE DEPTH OF SHOT   00001300
C                           AND UPHOLE TIME ARRAYS                      00001400
C                                                                       00001500
C     INPUT CARD DESCRIPTION -                                          00001600
C                                                                       00001700
C       1LAIP CARD -  (A)=ALPHANUMERIC FIELDS                           00001800
C         CC  1    I*2    NMCRD    MUST BE  1                           00001900
C         CC  2- 5 I*4(A) IDCRD    MUST BE "LAIP"                       00002000
C         CC  6-10 I*4    NLOC     NUMBER OF GROUPS IN THE LINE         00002100
C         CC 11-15 I*4    NREC     NUMBER OF RECORDS                    00002200
C         CC 16                    NOT USED                             00002300
C         CC 17-20 I*4    NTPR     NUMBER OF TRACES PER RECORD          00002400
C         CC 21-25 R*4    XGRINT   GROUP INTERVAL                       00002500
C         CC 26-30 R*4    CRSE     CONSTANT REFERENCE SURFACE           00002600
C                  R*8(A) CHCRSE   CHARACTER REPRESENTATION OF 'CRSE'   00002700
C         CC 31-35 R*4    REPVEL   CONSTANT REPLACEMENT VELOCITY        00002800
C         CC 36-37                 NOT USED                             00002900
C         CC 38-40 R*4    SHTMOV   NORMAL SHOT MOVE-UP                  00003000
C         CC 41                    NOT USED                             00003100
C         CC 42-45 R*4    SPINC    NORMAL SHOTPOINT NUMBER INCREMENT    00003200
C         CC 46                    NOT USED                             00003300
C         CC 47    I*2    INDMOD   INDEXING METHOD                      00003400
C         CC 48                    NOT USED                             00003500
C         CC 49    I*2    METENG   UNITS FLAG (METRIC/ENGLISH)          00003600
C         CC 50                    NOT USED                             00003700
C         CC 51    I*2    MODEPR   PROCESSING MODE                      00003800
C         CC 52                    NOT USED                             00003900
C         CC 53-54 R*4    TERVAL   INTERVAL                             00004000
C         CC 55                    NOT USED                             00004100
C         CC 56    I*2    ISYS     PRINTOUT FLAG                        00004200
C         CC 57-68                 NOT USED                             00004300
C         CC 69-75 R*8(A) JOBNO1   JOB NUMBER                           00004400
C         CC 76    I*2    IPLDIR   PLOT DIRECTION                       00004500
C         CC 77    I*2    PLTFLG(1) DISPLAY FLAG - ELEVATION            00004600
C         CC 78    I*2    PLTFLG(2) DISPLAY FLAG - STACKING             00004700
C         CC 79    I*2    PLTFLG(3) DISPLAY FLAG - TRAVERSE             00004800
C         CC 80    I*2    PLTFLG(4) DISPLAY FLAG - WEATHERING           00004900
C                                                                       00005000
C       2LAIP CARD -  (A)=ALPHANUMERIC FIELDS                           00005100
C         CC  1    I*2    NMCRD    MUST BE  2                           00005200
C         CC  2- 5 I*4(A) IDCRD    MUST BE "LAIP"                       00005300
C         CC  6    I*2(A) IEQUIP   EQUIPMENT CODE                       00005400
C         CC  7                    NOT USED                             00005500
C         CC  8-10 I*4(A) IOAC     OPERATIONS ACTIVITY CODE             00005600
C         CC 11-14 I*4(A) LINE     LINE NUMBER                          00005700
C         CC 15-19                 NOT USED                             00005800
C         CC 20-23 I*2    IFOLD    NUMBER OF TRACES PER CDP             00005900
C         CC 24    I*2    ITYPE    TYPE OF SORTING TO BE PERFORMED      00006000
C                                  (0=NO CHANGE, 1=LARGE ARROWHEAD,     00006100
C                                   2=ECHELON - MAX TO MIN RANGE)       00006200
C         CC 25-30 R*8(A) CREW     CREW ID                              00006300
C         CC 31    I*2(A) DATTYP   DATA TYPE                            00006400
C                                  (C=CURRENT SHOOTING,R=REVIEW,T=TRACE)00006500
C         CC 32-33 I*2(A) DTS      AMOCO DIG TRUCK SYS                  00006600
C         CC 34-68                 NOT USED                             00006700
C         CC 69-75 R*8(A) JOBNO    JOB NUMBER                           00006800
C         CC 76                    NOT USED                             00006900
C         CC 77    I*2(A) NORS                                          00007000
C         CC 78-79 I*2    ANGDEV                                        00007100
C         CC 80    I*2(A) EORW                                          00007200
C         CC 77-80 I*4(A) NSANEW                                        00007300
C                                                                       00007400
C       1GPAR CARD -  (A)=ALPHANUMERIC FIELDS                           00007500
C         CC  1    I*2    NMCRD    MUST BE  1                           00007600
C         CC  2- 5 I*4(A) IDCRD    MUST BE "GPAR"                       00007700
C         CC  6-10 I*4    IGNDX    GROUP INDEX                          00007800
C         CC 11-15 R*4    ELEV     ELEVATION                            00007900
C                  R*8    CHELEV   CHARACTER REPRESENTATION OF 'ELEV'   00008000
C         CC 16    I*2    ICOFLG   COORDINATE FLAG                      00008100
C         CC 17-36                 COORDINATES:                         00008200
C         CC 17-26 R*4    XCOOR       X COORDINATE                      00008300
C         CC 27-36 R*4    YCOOR       Y COORDINATE                      00008400
C         CC 37-56                 WEATHERING:                          00008500
C         CC 37-41 R*4    THICK1      LAYER 1 THICKNESS                 00008600
C                  R*8(A) CHTHK1      CHAR. REPRESENTATION OF 'THICK1'  00008700
C         CC 42-46 R*4    VEL1        LAYER 1 VELOCITY                  00008800
C         CC 47-51 R*4    THICK2      LAYER 2 THICKNESS                 00008900
C                  R*8(A) CHTHK2      CHAR. REPRESENTATION OF 'THICK2'  00009000
C         CC 52-56 R*4    VEL2        LAYER 2 VELOCITY                  00009100
C         CC 57-66                 REGIONAL REFERENCE SURFACE:          00009200
C         CC 57-61 R*4    RGELEV      ELEVATION                         00009300
C                  R*8(A) CHRGEL      CHAR. REPRESENTATION OF 'RGELEV'  00009400
C         CC 62-66 R*4    RGRVEL      REPLACEMENT VELOCITY              00009500
C         CC 67-68                 NOT USED                             00009600
C         CC 69-75 R*8(A) JOBNO    JOB NUMBER                           00009700
C         CC 76-80                 NOT USED                             00009800
C                                                                       00009900
C       2GPAR CARD -  (A)=ALPHANUMERIC FIELDS                           00010000
C         CC  1    I*2    NMCRD    MUST BE  2                           00010100
C         CC  2- 5 I*4(A) IDCRD    MUST BE "GPAR"                       00010200
C         CC  6-10 I*4    IGNDX2   GROUP INDEX                          00010300
C         CC 11-36                 NOT USED                             00010400
C         CC 37-41 R*4    THICK3   LAYER 3 THICKNESS                    00010500
C                  R*8(A) CHTHK3      CHAR. REPRESENTATION OF 'THICK3'  00010600
C         CC 42-46 R*4    VEL3     LAYER 3 VELOCITY                     00010700
C         CC 47-68                 NOT USED                             00010800
C         CC 69-75 R*8(A) JOBNO    JOB NUMBER                           00010900
C         CC 76-80                 NOT USED                             00011000
C                                                                       00011100
C       1SPAR CARD -  (A)=ALPHANUMERIC FIELDS                           00011200
C         CC  1    I*2    NMCRD    MUST BE  1                           00011300
C         CC  2- 5 I*4(A) IDCRD    MUST BE "SPAR"                       00011400
C         CC  6-11 R*4    ZLSLOC   SOURCE LOCATION                      00011500
C                                                                       00011600
C         CC 12-39                 TRACE LOCATIONS:                     00011700
C         CC 12-21                    END OF SPREAD LOCATIONS:          00011800
C         CC 12-16 I*4    LOCTRA         LOCATION TRACE 1               00011900
C         CC 17-21 I*4    LOCTRB         LOCATION TRACE N               00012000
C                                                                       00012100
C         CC 22-39                    SPLIT-SPREAD LOCATIONS:           00012200
C         CC 22-25 I*4    LTBG           LAST TRACE BEFORE GAP          00012300
C         CC 26-30 I*4    LCLTBG         LOCATION                       00012400
C         CC 31-34 I*4    IFTAG          FIRST TRACE AFTER GAP          00012500
C         CC 35-39 I*4    LCFTAG         LOCATION                       00012600
C                                                                       00012700
C         CC 40-48                 SHOT-OFFSET-PARAMETERS:              00012800
C         CC 40-44 R*4    OFFDIS      OFFSET DISTANCE                   00012900
C         CC 45-48 R*4    OFFANG      ANGLE OF OFFSET                   00013000
C                                                                       00013100
C         CC 49-53 I*4    ISPNN    SHOTPOINT NUMBER - NUMERIC PORTION   00013200
C         CC 54    I*2(A) ISPNA    SHOTPOINT NUMBER - ALPHA PORTION     00013300
C                                                                       00013400
C         CC 55-64                 UPHOLE PARAMETERS:                   00013500
C         CC 55-58 R*4    HOLDEP      HOLE DEPTH                        00013600
C                  I*4(A) IHOLCH      CHARACTER REPRESENTATION OF HOLDEP00013700
C         CC 59-61 R*4    UPTIME      UPHOLE TIME                       00013800
C                  I*4(A) ITIMCH      CHARACTER REPRESENTATION OF UPTIME00013900
C         CC 62-64 R*4    UPHOFF      UPHOLE GEOPHONE OFFSET            00014000
C                                                                       00014100
C         CC 65-68 I*2    IBSCOR   BULK STATIC CORRECTION               00014200
C         CC 69-75 R*8(A) JOBNO    JOB NUMBER                           00014300
C         CC 76-80 I*4    LRI      RECORD INDEX                         00014400
C                                                                       00014500
C       8TDIS CARD -  (A)=ALPHANUMERIC FIELDS                           00014600
C         CC  1    I*2    NMCRD    MUST BE  8                           00014700
C         CC  2- 5 I*4(A) IDCRD    MUST BE "TDIS"                       00014800
C         CC  6-68                 TRACE DISTANCE PAIRS                 00014900
C         CC  6- 9 I*2    KTR(1)                                        00015000
C         CC 10-14 R*4    ZDIST(1)                                      00015100
C         CC 15-18 I*2    KTR(2)                                        00015200
C         CC 19-23 R*4    ZDIST(2)                                      00015300
C         CC 24-27 I*2    KTR(3)                                        00015400
C         CC 28-32 R*4    ZDIST(3)                                      00015500
C         CC 33-36 I*2    KTR(4)                                        00015600
C         CC 37-41 R*4    ZDIST(4)                                      00015700
C         CC 42-45 I*2    KTR(5)                                        00015800
C         CC 46-50 R*4    ZDIST(5)                                      00015900
C         CC 51-54 I*2    KTR(6)                                        00016000
C         CC 55-59 R*4    ZDIST(6)                                      00016100
C         CC 60-63 I*2    KTR(7)                                        00016200
C         CC 64-68 R*4    ZDIST(7)                                      00016300
C         CC 69-75 R*8(A) JOBNO    JOB NUMBER                           00016400
C         CC 76-80 I*4    KRI      RECORD INDEX                         00016500
C                                                                       00016600
C       1GROM, 1GRIN, 1TROM, 1TRIN CARDS (A)=ALPHANUMERIC FIELDS        00016700
C         CC  1    I*2    NMCRD    MUST BE  1                           00016800
C         CC  2- 5 I*4(A) IDCRD    MUST BE "GROM", "GRIN", "TROM", "TRIN00016900
C                                  -------------------------------------00017000
C         CC  6-10 I*4             FROM G.I.(GROM,GRIN) TRACE(TROM,TRIN)00017100
C         CC 11-15 I*4               TO G.I.(GROM,GRIN) TRACE(TROM,TRIN)00017200
C         CC 16-20 I*4             FROM R.I.                            00017300
C         CC 21-25 I*4               TO R.I.                            00017400
C                                  -------------------------------------00017500
C         CC 26-30 I*4                                                  00017600
C         CC 31-35 I*4                        SAME AS ABOVE             00017700
C         CC 36-40 I*4                                                  00017800
C         CC 41-45 I*4                                                  00017900
C                                  -------------------------------------00018000
C         CC 46-50 I*4                                                  00018100
C         CC 51-55 I*4                        SAME AS ABOVE             00018200
C         CC 56-60 I*4                                                  00018300
C         CC 61-65 I*4                                                  00018400
C                                  -------------------------------------00018500
C         CC 66-68                 NOT USED                             00018600
C         CC 69-75 R*8(A)          JOB NUMBER                           00018700
C         CC 76-80                 NOT USED                             00018800
C                                                                       00018900
C***********************************************************************00019000
C***********************************************************************00019100
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
C                                                                       00019200
      DOUBLE PRECISION RAD,JOBNO1                                       00019300
C                                                                       00019400
      character*4   TDIS,SPAR,idcrd
	integer otap
cmam  INTEGER   TDIS,SPAR,OTAP                                          00019500
C                                                                       00019600
      INTEGER*2 KTR(7)                                                  00019700
      INTEGER*2 PLTFLG(4)                                               00019800
      INTEGER*2 MODEPR                                                  00019900
      INTEGER*2 METENG                                                  00020000
      INTEGER*2 IFOLD                                                   00020100
      INTEGER*2 IBSCOR                                                  00020200
      INTEGER*2 ISYS
	integer ibflag
cmam  INTEGER*2 IBFLAG,ISYS                                             00020300
C                                                                       00020400
cmam  LOGICAL*1 MOVFL1/.FALSE./                                         00020500
cmam  LOGICAL*1 SPLTFL/.FALSE./                                         00020600
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00020700
cmam  LOGICAL*1 PRNT,PLOT,FLGO,INTERA                                   00020800
      LOGICAL MOVFL1
      LOGICAL SPLTFL
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL PRNT,PLOT,FLGO,INTERA
c
c added flag (saveperm) to not override PrRcNm and PrTrNm
c   3/18/97 - jev
c
      LOGICAL SAVEPERM
C                                                                       00020900
      DIMENSION ZDIST(7)                                                00021000
      DIMENSION ARRAY(30)                                               00021100
      character*4 ITITLE(17), name
cmam  DIMENSION ITITLE(17)                                              00021200
cmam  LOGICAL*1 JPRTY(2)/'0','0'/                                       00021300
cmam  LOGICAL*1 IRDC(3)                                                 00021400
cmam  LOGICAL JPRTY(2)/'0','0'/
      LOGICAL IRDC(3)
      DIMENSION IPMBUF(25)                                              00021500
      INTEGER*2 IPMBF2(50)                                              00021600
      INTEGER*2 IUNIT                                                   00021700
      INTEGER*4 RDC                                                     00021800
      LOGICAL IPMBF1(100)
cmam  LOGICAL*1 IPMBF1(100)                                             00021900
      EQUIVALENCE (IPMBUF(1),IPMBF2(1),IPMBF1(1))                       00022000
      EQUIVALENCE (IRDC(1),RDC)                                         00022100
C                                                                       00022200
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................

      COMMON /PLTCOM/ ICODE,NUMDEV,ILINE,IPRTY,
     $                XXADD,YYADD,XPLT1,FONTUN,XLIBR,                   00022900
     $                THKMAX,XSTATN,DSN,PRNT,PLOT,FLGO,INTERA,igscod
C                                                                       00023100
C=======================================================================00023200
	character*4 card
C
#include <f77/pid.h>
      character   ntape*100, otape*100, cardin*100
        logical query
        integer argis
C=======================================================================00023200
C                                                                       00023800
      DATA ITITLE/'    ','  LA','ND L','INE ','INDE','XING',            00023900
     $            ' WIT','H WE','ATHE','RING',' STA','TICS',            00024000
     $            ' COM','PUTA','TION','    ','    '/                   00024100
	data name/'LAIP'/
	data movfl1/.false./,spltfl/.false./
      DATA IRECP/0/                                                     00024200
      DATA MAXTRC/8192/                                                 00024300
      DATA ICR/99/
cmam  DATA ICR/5/                                                       00024400
      DATA JCC/0/                                                       00024500
      DATA IPLT1/51/,IPLT2/52/                                          00024600
cmam  DATA IUNSCP/LERR/,IUNSCF/57/
      DATA IUNSCP/53/,IUNSCF/57/                                        00024700
C=======================================================================00024800
      DATA NTAP/7/,OTAP/8/                                              00025200
cc       check for help flag
 
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
         call help1()
         stop
      endif
cc
cmam  FONTUN = 11                                                       00025300
cmam  CALL PARM (IPMBUF)                                                00025400
cmam  IGSCOD = IPMBUF(1)                                                00025500
cmam  IUNIT = IPMBF2(3)                                                 00025600
cmam  JPRTY(2) = IPMBF1(7)                                              00025700
cmam  CALL MOVE (1,IPRTY,JPRTY,2)                                       00025800
cmam  RDC = IPMBUF(3)                                                   00025900
C=======================================================================00026300
      INOMUN = 46                                                       00026400
      IDSK2 = 54                                                        00026500
      IDSK1 = 58                                                        00026600
cmam  XLIBR = 59.                                                       00026700
      IPR = LERR
cmam  IPR = 6                                                           00026800
#include <f77/open.h>
C                                                                       00026900
      CALL GAMOCO (ITITLE,1,IPR)                                        00027000
      call argstr ('-N', ntape, ' ', ' ')
      call argstr ('-O', otape, ' ', ' ')
      call argstr ('-C',cardin, ' ', ' ')
C *------------------------------------------------------------------* C
C *  If ntape specified, open it, otherwise set lui to standard
C *  input (= pipe in)
C *------------------------------------------------------------------* C
      if (ntape.ne.' ')then
        call getln (ntap , ntape, 'r', 0)
      else
        ntap = 0
      endif
       if (ntap .lt. 0) then
         write (LERR,*) 'Could not open input ',ntape
         call ccexit(100)
      endif
C *------------------------------------------------------------------* C
C *  If otape specified, open it, otherwise set luo to standard
C *  output (= pipe out)
C *------------------------------------------------------------------* C
      if (otape.ne.' ')then
        call getln (otap, otape, 'w', 1)
      else
        otap = 1
      endif
 
      open (unit = IDSK1, form = 'formatted',
     1      status = 'scratch', access = 'sequential')
      open (unit = IDSK2, form = 'unformatted',
     1      status = 'scratch', access = 'sequential')
 
      if (cardin(1:1) .ne. ' ') then
         open (unit=ICR, file= cardin, status='old',
     1         form='formatted',access='sequential')
      else
         write(LERR,*)'No card input file name given -- FATAL'
         write(LERR,*)'Use -C[] on command line to input file name'
         stop 911
      endif

C                                                                       00027100
      CALL SETUP (JOBNO1,ARRAY,ZDIST,SHTMOV,TERVAL,IRDC,                00027200
     $            IDCRD,ICR,NTAP,NREC,LINE,IOAC,N,                      00027300
     $            IFSP,IRECP,MAXTRC,NUMLAY,                             00027400
     $            KTR,SPINC,IBSCOR,IFOLD,MODEPR,IBFLAG,                 00027500
     $            ISYS,METENG,PLTFLG,                                   00027600
     $            MOVFL1,SPLTFL,*100)                                   00027700
cmam $            MOVFL1,SPLTFL,&100)                                   00027700
C                                                                       00027800
C
C added saveperm flag to save permanent rec indec and trc index from
c       input data set
C
      saveperm = .false.
      saveperm = (argis('-saveperm') .gt. 0)
c
      CALL PLTSET (PLTFLG,MODEPR,IPLT1,IPLT2,NUMLAY,JCC,                00027900
     *             IUNIT)                                               00028000
C                                                                       00028100
C     +------------------------------------------+                      00028200
C     |            OUTPUT LINE HEADER            |                      00028300
C     +------------------------------------------+                      00028400
C                                                                       00028500
cmam  CALL LBOPEN (OTAP)                                                00028600
	call savhlh(ibuf4,n,nout)
	n = nout
      CALL WRTAPE (OTAP,IBUF4,N)                                        00028700
C                                                                       00028800
C     +------------------------------------------+                      00028900
C     |            PROCESS THE TRACES            |                      00029000
C     +------------------------------------------+                      00029100
C                                                                       00029200
      CALL GO4IT       (ZDIST,SHTMOV,TERVAL,                            00029300
     $                  IDCRD,NTAP,OTAP,IUNSCP,IUNSCF,NREC,NUMDEV,      00029400
     $                  IFSP,IRECP,MAXTRC,LINE,IOAC,                    00029500
     $                  KTR,SPINC,IBSCOR,ISYS,                          00029600
     $                  MODEPR,IBFLAG,METENG,PLTFLG,                    00029700
     $                  MOVFL1,SPLTFL,SAVEPERM)                         00029800
C                                                                       00029900
      IF (PRNT) CALL PRNTIT (PLTFLG,SHTMOV,METENG,MODEPR,               00030000
     $                       ARRAY,SPINC)                               00030100
      IF (PLOT) CALL PLOTIT (PLTFLG,SHTMOV,METENG,MODEPR,SPINC)         00030200
C                                                                       00030300
	if(pltflg(2).ne.0) call stkcht(ipr,iunscp,icc,ibuf4)
 100  CALL LBCLOS (NTAP)                                                00030400
C=======================================================================00030500
cmam  ENDFILE IUNSCF                                                    00031100
C                                                                       00031200
C     +------------------------------------------+                      00031300
C     |   OUTPUT INFO TO STACKING CHART ROUTINE  |                      00031400
C     +------------------------------------------+                      00031500
C                                                                       00031600
C=======================================================================00031800
      IF (PLTFLG(2).NE.3) GO TO 110                                     00032100
      JCC = 1                                                           00032200
C=======================================================================00032400
C=======================================================================00032500
C                                                                       00032600
      REWIND IDSK1                                                      00032700
      WRITE (IDSK1,103) IOAC,LINE,JOBNO1,IRECP,NLOC,IFOLD,MOVFL1        00032800
 103  FORMAT (          A3,  A4,  A8,    I6,   I6,  I6,   L1)           00032900
C=======================================================================00033000
      ICC = JCC                                                         00033800
C=======================================================================00034000
c 110	call flush(lerr)
  110	close(lerr)
c 110 continue
      CALL CCEXIT (ICC)                                                 00034100
c110  CALL CCEXIT (ICC)                                                 00034100
      END                                                               00034200
C  ROUTINE:       SETUP                                                 00034300
C  ROUTINE TYPE:  SUBROUTINE                                            00034400
C  PURPOSE:  READ INPUT CARDS, SETUP TABLES, ETC.                       00034500
C  AUTHOR:  DOUGLAS BODDY                                               00034600
C  DATE WRITTEN:  AUGUST 1985                                           00034700
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00034800
C                                                                       00034900
      SUBROUTINE SETUP (JOBNO1,ARRAY,ZDIST,SHTMOV,TERVAL,IRDC,          00035000
     $                  IDCRD,ICR,NTAP,NREC,LINE,IOAC,N,                00035100
     $                  IFSP,IRECP,MAXTRC,NUMLAY,                       00035200
     $                  KTR,SPINC,IBSCOR,IFOLD,MODEPR,IBFLAG,           00035300
     $                  ISYS,METENG,PLTFLG,                             00035400
     $                  MOVFL1,SPLTFL,*)                                00035500
C                                                                       00035600
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
ccc
cmam  DOUBLE PRECISION CREW,JOBNO1,JOBNO                                00035700
cmam  DOUBLE PRECISION CHCRSE,CHRGEL,CHELEV,CRDTYP                      00035800
cmam  DOUBLE PRECISION CHTHK1,CHTHK2,CHTHK3                             00035900
	character*4 card,idcrd,line,nsanew,chyco1,chyco2,chyco3
	character*5 chcrse,chelev,chthk1,chthk2,chrgel,chthk3,crdtyp
	character*2 dts,angdeg
cmam	character*3 ivac
	character*1 iequip,dattyp,nors,eorw
	character*6 crew
	character*7 jobno1, jobno
    	character*80 kard
      character*8 BLANK8
	character*4 blank4
cmam  DOUBLE PRECISION BLANK8                                           00036000
      DOUBLE PRECISION PI
cmam  DOUBLE PRECISION PI/3.14159265358979323846D+00/                   00036100
      DOUBLE PRECISION RAD                                              00036200
C                                                                       00036300
      character*4   GPAR,TDIS,SPAR,laip
cmam  INTEGER   GPAR,TDIS,SPAR                                          00036400
cmam  INTEGER   ERRMES(10)/' ** ','ERRO','R DE','TECT','ED B','Y SU',   00036500
      character*4 ERRMES(10)
cmam  INTEGER   HLHARR(17)/'LAIP',' (IN','DEXI','NG A',                 00036700
      character*4   HLHARR(17)
      INTEGER   HLHLEN(3),HLHELM(3)
C                                                                       00037200
      INTEGER*2 LINHD2(3000)                                            00037300
      INTEGER*2 KTR(7),NMCRD,IBSCOR,IFOLD,MODEPR
	integer ibflag
cmam  INTEGER*2 KTR(7),NMCRD,IBSCOR,IFOLD,MODEPR,IBFLAG                 00037400
      INTEGER*2 PLTFLG(4),METENG,ISYS                                   00037500
      INTEGER*2 ANGDEV
cmam  INTEGER*2 NORS,EORW,ANGDEV                                        00037600
      INTEGER*2 INDMOD,IPLDIR                                           00037700
cmam  INTEGER*2 IX,ITYPE,DATTYP                                         00037800
cmam  INTEGER*2 IEQUIP,DTS                                              00037900
      INTEGER*2 ITYPE
      INTEGER*2 ICOFLG,JCOFLG                                           00038000
      REAL*4    RBUF ( 1500 )                                           00038100
C                                                                       00038200
      LOGICAL ERRFL1
      LOGICAL MOVFL1,SPLTFL
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL REFFL1,REFFL2
      LOGICAL LAIPF2
      LOGICAL TAPFLG
      character*1 LINHD1(6000)
cmam  LOGICAL LINHD1(6000)                                            00038900
C                                                                       00039000
      DIMENSION ZDIST(7)                                                00039100
      DIMENSION ARRAY(30)                                               00039200
      DIMENSION LINHD4(1500)                                            00039300
	character*4 Z0
	character*5 blank5
	integer jspbuf(1)
	real    xbuff(1)
	pointer(kspbuf,jspbuf),(kbuff,xbuff)
C                                                                       00039400
C=======================================================================00039500
C=======================================================================00040300
      EQUIVALENCE (BLANK8,BLANK4,blank5)
cmam  EQUIVALENCE (BLANK8,BLANK4)                                       00040400
      EQUIVALENCE (LINHD4(1),LINHD2(1),LINHD1(1),IBUF4(1), RBUF(1))     00040500
C                                                                       00040600
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00041200
    	equivalence (card(1),kard)
      data PI/3.14159265358979323846D+00/
      data ERRMES/' ** ','ERRO','R DE','TECT','ED B','Y SU',
     $                     'BROU','TINE',' SET','UP: '/                 00036600
      data HLHARR/'LAIP',' (IN','DEXI','NG A',
     $                            'ND S','TATI','CS) ',                 00036800
     $                     'LAIP',' (IN','DEXI','NG O','NLY)',          00036900
     $                     'LAIP',' (ST','ATIC','S ON','LY) '/          00037000
      data HLHLEN/27,20,19/,HLHELM/1,8,13/
      data ERRFL1/.FALSE./
      data REFFL1/.FALSE./,REFFL2/.FALSE./
      data LAIPF2/.FALSE./
      data TAPFLG/.FALSE./
      DATA BLANK8/'        '/                                           00041300
      DATA LAIP/'LAIP'/,GPAR/'GPAR'/                                    00041400
      DATA UPHTIM/0.0/                                                  00041500
      DATA ICGRP/0/                                                     00041600
      DATA IGNDX/0/                                                     00041700
      DATA XCOOR/0.0/,YCOOR/0.0/                                        00041800
      DATA Z0/'   0'/                                                   00041900
      DATA M1/1/,M2/4/                                                  00042000
C                                                                       00042100
cmam  CALL LBOPEN (NTAP)                                                00042200
C                                                                       00042300
      N = 0                                                             00042400
      CALL RTAPE (NTAP,LINHD4,N)                                        00042500
      IF (N.GT.0) GO TO 30                                              00042600
      TAPFLG = .TRUE.                                                   00042700
      WRITE (IPR,10) ERRMES                                             00042800
 10   FORMAT ('0** M0100',10A4/                                         00042900
     $ 13X,'END OF FILE READING INPUT LINE HEADER')                     00043000
      ICC = 100                                                         00043100
C                                                                       00043200
 30 	call saver(linhd4,'NumTrc',MAXTRC,0)
      READ (ICR,120,END=480) CARD,NMCRD,IDCRD,JOBNO1,M                  00043300
c30   READ (ICR,120,END=480) CARD,NMCRD,IDCRD,JOBNO1,M                  00043300
      IF (ICC.NE.0) GO TO 100                                           00043400
      IF (M.LT.0.OR.M.GT.2) GO TO 40                                    00043500
      M1 = HLHELM(M+1)                                                  00043600
      M2 = HLHLEN(M+1)                                                  00043700
 40   CALL HLHprt (LINHD4,N,HLHARR(M1),M2,LERR)
c40   CALL HLH (LINHD4,N,HLHARR(M1),M2)                                 00043800
cmam  CALL NACCT (LAIP,LINHD4,1.0)                                      00043900
C                                                                       00044000
      CALL TAPCHK                                                       00044100
C                                                                       00044200
C     +------------------------------------------+                      00044300
C     |           READ 1LAIP CARD                |                      00044400
C     +------------------------------------------+                      00044500
C                                                                       00044600
 100  CALL WRCARD (CARD,1,IPR)                                          00044700
 120  FORMAT (20A4,T1,I1,A4,T69,A7,T51,I1)                              00044800
C                                                                       00044900
      IF (NMCRD.EQ.1.AND.IDCRD.EQ.LAIP) GO TO 150                       00045000
      WRITE (IPR,130) ERRMES                                            00045100
 130  FORMAT ('0** M0110',10A4/                                         00045200
     $ 13X,'FIRST CARD MUST BE A "1LAIP" CARD')                         00045300
      ICC = 100                                                         00045400
      GO TO 400                                                         00045500
C                                                                       00045600
C     +------------------------------------------+                      00045700
C     |         DECODE 1LAIP CARD                |                      00045800
C     +------------------------------------------+                      00045900
C                                                                       00046000
 150  CONTINUE                                                          00046100
C=======================================================================00046200
cmam  CALL STRING (CARD,80)                                             00046800
cmam  READ (99,200)     NLOC,NREC,NTPR,XGRINT,CRSE,REPVEL,SHTMOV,       00046900
      READ (kard,200)     NLOC,NREC,NTPR,XGRINT,CRSE,REPVEL,SHTMOV,
     $                  SPINC,INDMOD,METENG,MODEPR,TERVAL,ISYS,         00047000
     $                  IPLDIR,(PLTFLG(I),I=1,4), CHCRSE                00047100
C=======================================================================00047200
C=======================================================================00047300
 200  FORMAT          (5X,I5,I5,1X,I4,F5.0,F5.0,F5.0,2X,F3.0,           00047400
     $                 1X,F4.0,1X,I1,1X,I1,1X,I1,1X,F2.2,1X,I1,12X,     00047500
     $                 7X,5I1,T26,A5)                                   00047600
C                                                                       00047700
      IF (TERVAL.EQ.0.0) TERVAL = 0.25                                  00047800
      IF (JOBNO1.NE.'       ') GO TO 300
cmam  IF (JOBNO1.NE.BLANK8) GO TO 300                                   00047900
      WRITE (IPR,250)
cmam  WRITE (IPR,250) ERRMES                                            00048000
 250  FORMAT ('0** M0120','WARNING:',
c250  FORMAT ('0** M0120',10A4/                                         00048100
     $ 5X,'JOB NUMBER ON "1LAIP" CARD IS BLANK')
cmam $ 13X,'JOB NUMBER ON "1LAIP" CARD CANNOT BE BLANK')                00048200
cmam  ICC = 100                                                         00048300
C                                                                       00048400
 300  IF (CHCRSE.EQ.BLANK5) REFFL1 = .TRUE.
      IF (REPVEL.EQ.0.0) REFFL2 = .TRUE.                                00048600
      IF (SHTMOV.EQ.0.0) SHTMOV = 1.0                                   00048700
      IF (SPINC.EQ.0.0) SPINC = 1.0                                     00048800
C                                                                       00048900
C     +------------------------------------------+                      00049000
C     |     CHECK PARAMETERS ON 1LAIP CARD       |                      00049100
C     +------------------------------------------+                      00049200
C                                                                       00049300
      CALL       LAIP1C (NLOC,NREC,NTPR,MAXTRC,XGRINT,MODEPR,           00049400
     $                   CRSE,REPVEL,SHTMOV,ICC,DPI,                    00049500
     $                   MOVFL1,INDMOD,SPINC,METENG,                    00049600
     $                   IPLDIR,PLTFLG,ISYS,IPR)                        00049700
C                                                                       00049800
C     +------------------------------------------+                      00049900
C     |           READ 2LAIP CARD                |                      00050000
C     +------------------------------------------+                      00050100
C                                                                       00050200
 400  READ (ICR,410,END=480) CARD,NMCRD,IDCRD,                          00050300
     $                       IEQUIP,IOAC,LINE,IFOLD,ITYPE,CREW,DATTYP,  00050400
     $                       DTS,JOBNO,NORS,ANGDEG,EORW,NSANEW          00050500
 410  FORMAT (20A4,T1,I1,A4,                                            00050600
     $        A1,1X,A3,A4,5X,I4,I1,A6,A1,                               00050700
     $        A2, T69,A7,1X,A1,A2,A1,T77,A4)                            00050800
C                                                                       00050900
      IF (NMCRD.EQ.2.AND.IDCRD.EQ.LAIP) GO TO 500                       00051000
      IF (MODEPR.NE.2) GO TO 450                                        00051100
      IF (NMCRD.NE.1.OR.IDCRD.NE.GPAR) GO TO 450                        00051200
      LAIPF2 = .TRUE.                                                   00051300
      GO TO 520                                                         00051400
C                                                                       00051500
 450  IF (ICC.NE.0) CALL WRCARD (CARD,2,IPR)                            00051600
      CALL WRCARD (CARD,3,IPR)                                          00051700
      WRITE (IPR,460) ERRMES                                            00051800
 460  FORMAT ('0** M0130',10A4/                                         00051900
     $ 13X,'SECOND CARD MUST BE A "2LAIP" CARD')                        00052000
      IF (MODEPR.EQ.2) WRITE (IPR,470)                                  00052100
 470  FORMAT (13X,'OR A "1GPAR" CARD ',                                 00052200
     $       '("2LAIP" OPTIONAL FOR PROCESSING MODE 2)')                00052300
      ICC = 100                                                         00052400
      GO TO 520                                                         00052500
C                                                                       00052600
 480  WRITE (IPR,490) ERRMES                                            00052700
 490  FORMAT ('0** M0140',10A4/                                         00052800
     $ 13X,'END OF DATA ATTEMPTING TO READ "1LAIP" OR "2LAIP" CARD')    00052900
      ICC = 100                                                         00053000
      GO TO 9750                                                        00053100
C                                                                       00053200
 500  IF (ICC.NE.0) CALL WRCARD (CARD,2,IPR)                            00053300
      CALL WRCARD (CARD,3,IPR)                                          00053400
C                                                                       00053500
C     +------------------------------------------+                      00053600
C     |     CHECK PARAMETERS ON 2LAIP CARD       |                      00053700
C     +------------------------------------------+                      00053800
C                                                                       00053900
      CALL       LAIP2C (ICC,IEQUIP,IOAC,LINE,IFOLD,ITYPE,IRDC,         00054000
     $                   DATTYP,EORW,NORS,ANGDEV,IPR)                   00054100
C                                                                       00054200
 520  IF (NTPR.NE.0) GO TO 540                                          00054300
cmam  NTPR = LINHD4(13)                                                 00054400
    	call saver(linhd4,'NumTrc',ntpr,0)
      IF (NTPR.GT.0 .AND. NTPR.LE.MAXTRC) GO TO 540                     00054500
      IF (TAPFLG) GO TO 540                                             00054600
      WRITE (IPR,530) ERRMES,MAXTRC                                     00054700
 530  FORMAT ('0** M0150',10A4/                                         00054800
     $ 13X,'NUMBER OF TRACES PER RECORD ON INPUT TAPE IS NOT WITHIN ',  00054900
     $     'PROGRAM LIMITS'/                                            00055000
     $ 13X,'NUMBER MUST BE POSITIVE AND LESS THAN OR EQUAL TO ',I5)     00055100
      ICC = 100                                                         00055200
C                                                                       00055300
 540  IF (NREC.GT.0) GO TO 560                                          00055400
cmam  NREC = LINHD4(14)                                                 00055500
	call saver(linhd4,'NumRec',nrec,0)
      IF (NREC.GT.0) GO TO 560                                          00055600
      IF (TAPFLG) GO TO 560                                             00055700
      WRITE (IPR,550) ERRMES                                            00055800
 550  FORMAT ('0** M0160',10A4/                                         00055900
     $ 13X,'NUMBER OF RECORDS ON INPUT TAPE IS NOT GREATER THAN ZERO')  00056000
      ICC = 100                                                         00056100
C                                                                       00056200
 560  IF (ICC.NE.0) GO TO 9750                                          00056300
C                                                                       00056400
C     +------------------------------------------+                      00056500
C     |        PRINT INPUT CARD PARAMETERS       |                      00056600
C     +------------------------------------------+                      00056700
C                                                                       00056800
      CALL PRMPRT (NLOC,MODEPR,NREC,NTPR,XGRINT,INDMOD,PLTFLG,          00056900
     $             SHTMOV,SPINC,METENG,IPLDIR,TERVAL,ISYS,IPR)          00057000
C                                                                       00057100
C*****MULTIPLY BY 2 SINCE TABLE IS IN GROUPS OF 0.5 INTERVAL            00057200
      TERVAL = TERVAL * 2.                                              00057300
      IF (MODEPR.EQ.2) GO TO 565                                        00057400
C                                                                       00057500
C     +--------------------------------------------+                    00057600
C     |  GET STORAGE TO STORE SHOT POINT BUFFER    |                    00057700
C     +--------------------------------------------+                    00057800
C                                                                       00057900
C=======================================================================00058000
cmam  IWANT = NLOC * 8                                                  00058600
cmam  CALL ALLOCS (ISPBUF,INDXSP,IWANT,IAVAIL,IADD)                     00058700
cmam  INDXSP = INDXSP / 4 + 1                                           00058800
cmam  IWANT = NLOC * 2                                                  00058900
	iwant = nloc*2*SZSMPD
	call galloc(kspbuf,iwant,errcd,abort)
	if(errcd.ne.0) then
           write(LERR,*) 'ERROR: '
           write(LERR,*) 'Unable to allocate workspace for ISPBUF'
           write(LERR,*) 'FATAL'
cmam  IF (IAVAIL.GT.0) GO TO 563                                        00059000
C=======================================================================00059100
C=======================================================================00059200
      WRITE (IPR,562) ERRMES                                            00059300
 562  FORMAT ('0** M0170',10A4/                                         00059400
     $ 13X,'INSUFFICIENT STORAGE AVAILABLE TO STORE ',                  00059500
     $     'SHOT POINT NUMBERS IN CORE.'/                               00059600
     $ 13X,'EITHER DECREASE THE NUMBER OF LOCATIONS ON LINE OR'/        00059700
     $ 13X,'IBM: INCREASE REGION OVERRIDE'/                             00059800
     $ 13X,'PERKIN-ELMER: USE DISK OPTION: EXEC LAIP,DISK=YES'/         00059900
     $ 13X,'WARNING: DISK OPTION IS VERY SLOW'/                         00060000
     $ 13X,'P.E. 8/32 USERS MAKE SURE DEFAULT REGION IN YOUR PROC '/    00060100
     $ 13X,'IS LARGE ENOUGH TO USE ALL AVAILABLE CORE')                 00060200
      ICC = 100                                                         00060300
      GO TO 9750                                                        00060400
	endif
C                                                                       00060500
cmam...........fill ISPBUF array with zeroes
 563	indxsp = kspbuf
      call vfill(0.0,jspbuf,1,nloc*2)
c563  CALL MOVE (0,ISPBUF(INDXSP),0,IWANT*4)                            00060600
cmam  INDXSP = INDXSP - 1                                               00060700
C                                                                       00060800
C     +--------------------------------------------+                    00060900
C     |        GET STORAGE TO STORE GI BUFFER      |                    00061000
C     |  STORAGE WILL BE EITHER ON DISK OR IN CORE |                    00061100
C     |  DEPENDING ON WHAT IS RECEIVED VIA GSPARM. |                    00061200
C     |  (IBM WILL ALWAYS BE IN CORE)              |                    00061300
C     |  THEN FILL THE BUFFER OR DISK STORAGE WITH |                    00061400
C     |  'MISSING' VALUES.                         |                    00061500
C     +--------------------------------------------+                    00061600
C                                                                       00061700
 565  CONTINUE                                                          00061800
C=======================================================================00061900
cmam  IWANT = NLOC * 60                                                 00063800
cmam  CALL ALLOCS (BUFF,INDXBF,IWANT,IAVAIL,IADD)                       00063900
cmam  INDXBF = INDXBF / 4 + 1                                           00064000
cmam  IWANT = NLOC * 15                                                 00064100
cmam  IF (IAVAIL.GT.0) GO TO 580                                        00064200
	iwant = nloc*15*SZSMPD
	call galloc(kbuff,iwant,errcd,abort)
	if(errcd.ne.0) then
           write(LERR,*) 'ERROR: '
           write(LERR,*) 'Unable to allocate workspace for BUFF'
           write(LERR,*) 'FATAL'
      WRITE (IPR,575) ERRMES,NLOC                                       00064300
 575  FORMAT ('0** M0180',10A4/                                         00064400
     $ 13X,'INSUFFICIENT STORAGE AVAILABLE TO STORE INFORMATION ',      00064500
     $     'FOR ',I6,' LOCATIONS IN CORE'/                              00064600
     $ 13X,'EITHER DECREASE THE NUMBER OF LOCATIONS ON LINE OR'/        00064700
     $ 13X,'IBM: INCREASE REGION OVERRIDE')                             00064800
C=======================================================================00064900
C=======================================================================00065000
      ICC = 100                                                         00065100
      GO TO 9750                                                        00065200
	endif
C                                                                       00065300
c580  BUFF(INDXBF) = ZMISS                                              00065400
 580	indxbf = kbuff
cmam............fill BUFF array with ZMISS value
	call vfill(zmiss,xbuff,1,nloc*15)
c.c.c.c.c.c.c.c.c.call vfill(zmiss,buff,1,nloc*15)
cmam  CALL MOVE (1,BUFF(INDXBF+1),BUFF(INDXBF),IWANT*4-4)               00065500
cmam  INDXBF = INDXBF - 1                                               00065600
C                                                                       00065700
 585  IWCOD = 1                                                         00065800
      IF (LAIPF2) GO TO 592                                             00065900
C                                                                       00066000
C     +------------------------------------------+                      00066100
C     |        READ 1GPAR OR 2GPAR CARD          |                      00066200
C     +------------------------------------------+                      00066300
C                                                                       00066400
 590	continue
      READ (ICR,591,END=610) CARD,NMCRD,IDCRD,JOBNO                     00066500
c590  READ (ICR,591,END=610) CARD,NMCRD,IDCRD,JOBNO                     00066500
 591  FORMAT (20A4,T1,I1,A4,T69,A7)
c590  READ (ICR,120,END=610) CARD,NMCRD,IDCRD,JOBNO                     00066500
      IF (IDCRD.NE.GPAR) GO TO 600                                      00066600
 592  CALL WRCARD (CARD,IWCOD,IPR)                                      00066700
      IWCOD = 3                                                         00066800
      IF (NMCRD.EQ.1) GO TO 625                                         00066900
      IF (NMCRD.EQ.2) GO TO 1000                                        00067000
      WRITE (IPR,595) ERRMES                                            00067100
 595  FORMAT ('0** M0190',10A4/                                         00067200
     $ 13X,'"GPAR" CARD IS NOT A "1GPAR" OR "2GPAR" CARD')              00067300
      ICC = 100                                                         00067400
      IWCOD = 1                                                         00067500
      GO TO 590                                                         00067600
C                                                                       00067700
 600  IF (IDCRD .EQ. SPAR .OR. IDCRD.EQ.TDIS) GO TO 1300                00067800
      CALL WRCARD (CARD,IWCOD,IPR)                                      00067900
      WRITE (IPR,605) ERRMES                                            00068000
 605  FORMAT ('0** M0210',10A4/                                         00068100
     $ 13X,'CARD ID IS NOT ONE WHICH WAS EXPECTED'/                     00068200
     $ 13X,'CARDS MUST BE IN THIS ORDER:'/                              00068300
     $ 18X,'1LAIP'/18X,'2LAIP'/                                         00068400
     $ 18X,'(1GPAR, 2GPAR)  2GPAR IS OPTIONAL'/                         00068500
     $ 18X,'(1SPAR, 8TDIS)'/                                            00068600
     $ 18X,'(1GROM, 1GRIN, 1TROM, 1TRIN)'/                              00068700
     $ 18X,'1FLDH (OPTIONAL)')                                          00068800
      ICC = 100                                                         00068900
      IWCOD = 1                                                         00069000
      GO TO 590                                                         00069100
C                                                                       00069200
 610  WRITE (IPR,615) ERRMES                                            00069300
 615  FORMAT ('0** M0220',10A4/                                         00069400
     $ 13X,'END OF FILE ENCOUNTERED READING INPUT CARDS PRIOR TO ALL ', 00069500
     $     'REQUIRED CARDS BEING INPUT')                                00069600
      ICC = 100                                                         00069700
      GO TO 9750                                                        00069800
C                                                                       00069900
 625  IGNDXO = IGNDX                                                    00070000
      YCOORS = YCOOR                                                    00070100
C=======================================================================00070200
cmam  CALL STRING (CARD,80)                                             00070800
cmam  READ (99,630)     IGNDX,ELEV,ICOFLG,XCOOR,YCOOR,                  00070900
      READ (kard,630)     IGNDX,ELEV,ICOFLG,XCOOR,YCOOR,
     $                  THICK1,VEL1,THICK2,VEL2,RGELEV,RGRVEL,          00071000
     $                  CHELEV,CHYCO1,CHYCO2,CHYCO3,CHTHK1,CHTHK2,CHRGEL00071100
C=======================================================================00071200
C=======================================================================00071300
 630  FORMAT           (5X,I5,F5.0,I1,2F10.0,                           00071400
     $                  6F5.0,                                          00071500
     $                  T11,A5,T27,2A4,A2,T37,A5,T47,A5,T57,A5)         00071600
C                                                                       00071700
      IF (ICGRP .NE. 0) GO TO 750                                       00071800
C                                                                       00071900
C     +------------------------------------------+                      00072000
C     | CHECKS AND DEFAULTS FOR FIRST 1GPAR CARD |                      00072100
C     +------------------------------------------+                      00072200
C                                                                       00072300
      IGNDXS = IGNDX                                                    00072400
      IGNDX1 = IGNDX                                                    00072500
      XCOOR1 = XCOOR                                                    00072600
      INX1ST = IGNDXS - 1                                               00072700
      LASLOC = IGNDX + NLOC - 1                                         00072800
      IF (CHTHK1.NE.BLANK5) ST1FLG = .TRUE.
cmam  IF (CHTHK1.NE.BLANK8) ST1FLG = .TRUE.                             00072900
      IF (YCOOR.EQ.0.0) CHYCO1 = Z0                                     00073000
C                                                                       00073100
      IF (IGNDX .GT. 0.0) GO TO 650                                     00073200
      WRITE (IPR,640) ERRMES                                            00073300
 640  FORMAT ('0** M0230',10A4/                                         00073400
     $ 13X,'GROUP INDEX ON FIRST "1GPAR" CARD IS NOT GREATER THAN ZERO')00073500
      ICC = 100                                                         00073600
      IWCOD = 1                                                         00073700
C                                                                       00073800
 650  JCOFLG = ICOFLG                                                   00073900
      IF (ICOFLG.EQ.0.OR.ICOFLG.EQ.1) GO TO 800                         00074000
      WRITE (IPR,660) ERRMES                                            00074100
 660  FORMAT ('0** M0240',10A4/                                         00074200
     $ 13X,'COORDINATE FLAG ON "1GPAR" CARD IS NOT BLANK, 0, OR 1')     00074300
      ICC = 100                                                         00074400
      IWCOD = 1                                                         00074500
C                                                                       00074600
      GO TO 800                                                         00074700
C                                                                       00074800
C     +------------------------------------------+                      00074900
C     | CHECK AND DEFAULTS FOR SECOND THRU LAST  |                      00075000
C     | 1GPAR CARD (IF THERE ARE MORE THAN ONE)  |                      00075100
C     +------------------------------------------+                      00075200
C                                                                       00075300
 750  IF (IGNDX .GT. IGNDXO) GO TO 765                                  00075400
      WRITE (IPR,760) ERRMES                                            00075500
 760  FORMAT ('0** M0250',10A4/                                         00075600
     $ 13X,'GROUP INDEX ON "1GPAR" CARD IS NOT GREATER THAN THE ',      00075700
     $     'GROUP INDEX ON THE PREVIOUS "1GPAR" CARD')                  00075800
      ICC = 100                                                         00075900
      IWCOD = 1                                                         00076000
C                                                                       00076100
 765  IF (XCOOR.NE.0.0) GO TO 775                                       00076200
      IF (JCOFLG.NE.0) GO TO 770                                        00076300
C     XCOOR = ZMISS                                                     00076400
      XCOOR = XCOORS + XGRINT * (IGNDX - IGNDXO)                        00076500
      IGNDXB = IGNDX                                                    00076600
      GO TO 790                                                         00076700
C                                                                       00076800
 770  XCOOR = XCOORS + XGRINT * (IGNDX - IGNDXO)                        00076900
      YCOOR = YCOORS + YCOOR                                            00077000
      GO TO 800                                                         00077100
C                                                                       00077200
 775  IF (JCOFLG.EQ.0) GO TO 780                                        00077300
      XCOOR = XCOORS + XCOOR                                            00077400
      YCOOR = YCOORS + YCOOR                                            00077500
      GO TO 800                                                         00077600
C                                                                       00077700
 780  IGNDX1 = IGNDX                                                    00077800
      XCOOR1 = XCOOR                                                    00077900
C                                                                       00078000
 790  IF (YCOOR.NE.0.0) GO TO 800                                       00078100
      IF (CHYCO3.NE.BLANK4) GO TO 800                                   00078200
      IF (CHYCO2.NE.BLANK4 .OR. CHYCO1.NE.BLANK4) GO TO 800             00078300
      YCOOR = YCOORS                                                    00078400
      GO TO 800                                                         00078500
C                                                                       00078600
C     +------------------------------------------+                      00078700
C     |         CHECKS ON ALL 1GPAR CARDS        |                      00078800
C     +------------------------------------------+                      00078900
C                                                                       00079000
 800  XCOORS = XCOOR                                                    00079100
      IF (IGNDX .LE. LASLOC) GO TO 810                                  00079200
      WRITE (IPR,805) ERRMES,NLOC,IGNDXS,LASLOC                         00079300
 805  FORMAT ('0** M0260',10A4/                                         00079400
     $ 13X,'GROUP INDEX ON "1GPAR" CARD IS TOO LARGE'/                  00079500
     $ 13X,'NUMBER OF LOCATIONS FROM "1LAIP" CARD IS',I6/               00079600
     $ 13X,'SINCE GROUP INDEX ON FIRST "1GPAR" CARD WAS',I6/            00079700
     $ 13X,'THE MAXIMUM GROUP INDEX ALLOWED IS',I6)                     00079800
      ICC = 100                                                         00079900
      IWCOD = 1                                                         00080000
      IGNDX = LASLOC                                                    00080100
C                                                                       00080200
 810  IF (.NOT.REFFL1) GO TO 820                                        00080300
      IF (RGELEV.GE.0.0) GO TO 825                                      00080400
      WRITE (IPR,815) ERRMES                                            00080500
 815  FORMAT ('0** M0270',10A4/                                         00080600
     $ 13X,'REFERENCE PLANE ELEVATION IS NEGATIVE')                     00080700
      ICC = 100                                                         00080800
      IWCOD = 1                                                         00080900
      GO TO 825                                                         00081000
C                                                                       00081100
 820  RGELEV = CRSE                                                     00081200
      CHRGEL = CHCRSE                                                   00081300
C                                                                       00081400
 825  IF (.NOT.REFFL2) GO TO 840                                        00081500
      IF (RGRVEL.GE.0.0) GO TO 850                                      00081600
      IF (MODEPR.EQ.1) GO TO 850                                        00081700
      WRITE (IPR,830) ERRMES                                            00081800
 830  FORMAT ('0** M0280',10A4/                                         00081900
     $ 13X,'REFERENCE PLANE REPLACEMENT VELOCITY IS NEGATIVE')          00082000
      ICC = 100                                                         00082100
      IWCOD = 1                                                         00082200
      GO TO 850                                                         00082300
C                                                                       00082400
 840  RGRVEL = REPVEL                                                   00082500
C                                                                       00082600
 850  IF (.NOT.ST1FLG) GO TO 930                                        00082700
      IF (THICK1.GE.0.0 .AND. VEL1.GE.0.0) GO TO 900                    00082800
      IF (MODEPR.EQ.1) GO TO 900                                        00082900
      WRITE (IPR,880) ERRMES                                            00083000
 880  FORMAT ('0** M0290',10A4/                                         00083100
     $ 13X,'THICKNESS AND VELOCITY FOR LAYER 1 MUST BOTH ',             00083200
     $     'BE NON-NEGATIVE')                                           00083300
      ICC = 100                                                         00083400
      IWCOD = 1                                                         00083500
C                                                                       00083600
 900  IF (CHTHK2.NE.BLANK5) ST2FLG = .TRUE.
c900  IF (CHTHK2.NE.BLANK8) ST2FLG = .TRUE.                             00083700
      IF (MODEPR.EQ.1) GO TO 950                                        00083800
      IF (THICK2.LT.0.0 .OR. VEL2.LT.0.0) GO TO 910                     00083900
      GO TO 950                                                         00084000
C                                                                       00084100
 910  WRITE (IPR,920) ERRMES                                            00084200
 920  FORMAT ('0** M0300',10A4/                                         00084300
     $ 13X,'THICKNESS AND VELOCITY FOR LAYER 2 MUST BOTH ',             00084400
     $     'BE NON-NEGATIVE')                                           00084500
      ICC = 100                                                         00084600
      IWCOD = 1                                                         00084700
      GO TO 950                                                         00084800
C                                                                       00084900
 930  IF (CHTHK2.EQ.BLANK5) GO TO 950
c930  IF (CHTHK2.EQ.BLANK8) GO TO 950                                   00085000
      IF (MODEPR.EQ.1) GO TO 950                                        00085100
      WRITE (IPR,940) ERRMES                                            00085200
 940  FORMAT ('0** M0310',10A4/                                         00085300
     $ 13X,'WEATHERING DATA IS NOT PERMITTED FOR LAYER 2'/              00085400
     $ 13X,'UNLESS WEATHERING DATA FOR LAYER 1 IS GIVEN ',              00085500
     $     '(ON FIRST "1GPAR" CARD)')                                   00085600
      ICC = 100                                                         00085700
      IWCOD = 1                                                         00085800
      ST2FLG = .FALSE.                                                  00085900
C                                                                       00086000
 950  ICGRP = 1                                                         00086100
      IF (ICC.EQ.0)                                                     00086200
     $ CALL UPDAT1 (CHTHK1,CHTHK2,IGNDX,ELEV,CHELEV,XCOOR,YCOOR,        00086300
     $              THICK1,VEL1,THICK2,VEL2,RGELEV,CHRGEL,RGRVEL)       00086400
      GO TO 590                                                         00086500
C                                                                       00086600
C     +------------------------------------------+                      00086700
C     |         CHECKS ON 2GPAR CARD             |                      00086800
C     +------------------------------------------+                      00086900
C                                                                       00087000
 1000 IF (ICGRP.EQ.1) GO TO 1020                                        00087100
      WRITE (IPR,1010) ERRMES                                           00087200
 1010 FORMAT ('0** M0320',10A4/                                         00087300
     $ 13X,'THERE MUST BE A "1GPAR" CARD PRECEDING EACH "2GPAR" CARD')  00087400
      ICC = 100                                                         00087500
      IWCOD = 1                                                         00087600
      GO TO 1060                                                        00087700
C                                                                       00087800
 1020 CONTINUE                                                          00087900
C=======================================================================00088000
cmam  CALL STRING (CARD,80)                                             00088400
cmam  READ (99,1030)     IGNDX2,THICK3,VEL3,CHTHK3                      00088500
      READ (kard,1030)     IGNDX2,THICK3,VEL3,CHTHK3
C=======================================================================00088600
C=======================================================================00088700
 1030 FORMAT (5X,I5,26X,2F5.0,T37,A5)                                   00088800
C                                                                       00088900
      IF (IGNDX2.EQ.IGNDX) GO TO 1060                                   00089000
      WRITE (IPR,1050) ERRMES                                           00089100
 1050 FORMAT ('0** M0330',10A4/                                         00089200
     $ 13X,'GROUP INDEX ON "2GPAR" DOES NOT MATCH THE GROUP INDEX ON ', 00089300
     $     'THE PREVIOUS "1GPAR" CARD')                                 00089400
      ICC = 100                                                         00089500
      IWCOD = 1                                                         00089600
C                                                                       00089700
 1060 IF (THICK3.GE.0.0 .AND. VEL3.GE.0.0) GO TO 1100                   00089800
      IF (MODEPR.EQ.1) GO TO 1100                                       00089900
      WRITE (IPR,1070) ERRMES                                           00090000
 1070 FORMAT ('0** M0340',10A4/                                         00090100
     $ 13X,'LAYER 3 ELEVATION AND VELOCITY MUST BOTH BE NON-NEGATIVE')  00090200
      ICC = 100                                                         00090300
      IWCOD = 1                                                         00090400
C                                                                       00090500
 1100 IF (ST1FLG) GO TO 1120                                            00090600
      IF (THICK3.EQ.0.0) GO TO 1150                                     00090700
      IF (MODEPR.EQ.1) GO TO 1150                                       00090800
      WRITE (IPR,1110) ERRMES                                           00090900
 1110 FORMAT ('0** M0350',10A4/                                         00091000
     $ 13X,'LAYER 3 CAN ONLY BE USED ',                                 00091100
     $     'WHEN LAYER 1 AND LAYER 2 WEATHERING DATA IS GIVEN')         00091200
      ICC = 100                                                         00091300
      IWCOD = 1                                                         00091400
      GO TO 1150                                                        00091500
C                                                                       00091600
 1120 IF (THICK3.NE.0.0) ST3FLG = .TRUE.                                00091700
C                                                                       00091800
 1150 ICGRP = 2                                                         00091900
      IF (ICC.EQ.0) CALL UPDAT2 (IGNDX2,THICK3,VEL3)                    00092000
      GO TO 590                                                         00092100
C                                                                       00092200
C     +------------------------------------------+                      00092300
C     |      INTERPOLATE FOR MISSING VALUES      |                      00092400
C     |      FOR FIELDS UPDATED BY GPAR CARDS    |                      00092500
C     +------------------------------------------+                      00092600
C                                                                       00092700
 1300 IF (ICC.NE.0) GO TO 9750                                          00092800
      IF (ST3FLG.AND.ST1FLG.AND. .NOT.ST2FLG) GO TO 1310                00092900
      GO TO 1330                                                        00093000
C                                                                       00093100
 1310 WRITE (IPR,1320) ERRMES                                           00093200
 1320 FORMAT ('0** M0360',10A4/                                         00093300
     $ 13X,'DATA WAS SUPPLIED FOR LAYER 1 AND LAYER 3 BUT NO LAYER 2 ', 00093400
     $     'WEATHERING DATA WAS SUPPLIED ANYWHERE ON THE LINE')         00093500
      ICC = 100                                                         00093600
      IWCOD = 1                                                         00093700
      GO TO 9750                                                        00093800
C                                                                       00093900
 1330 IF (JCOFLG.NE.0 .OR. XCOOR1.EQ.XCOORS) GO TO 1350                 00094000
      XCOOR = XCOOR1 + XGRINT * (IGNDXB - IGNDX1)                       00094100
      CALL BUFSTR (IGNDXB-INX1ST,3,XCOOR)                               00094200
 1350 CALL INTBUF (MODEPR,1,ERRFL1)                                     00094300
      IF (ICC.NE.0) GO TO 9750                                          00094400
      RAD = PI / 180.0D+00                                              00094500
C                                                                       00094600
C     +------------------------------------------+                      00094700
C     |    FIRST PASS OF 1SPAR AND 8TDIS CARDS   |                      00094800
C     |    WRITE CARDS TO DISK.                  |                      00094900
C     +------------------------------------------+                      00095000
C                                                                       00095100
      CALL PASS1       (ARRAY,SHTMOV,NMCRD,IDCRD,ICR,ICGRP,IWCOD,       00095200
     $                  ZDIST,KTR,IFHCRD,NSPN,                          00095300
     $                  MODEPR,SPINC,UPHTIM,ZLOC1,SPLTFL)               00095400
      IF (ICC.NE.0) GO TO 9750                                          00095500
C                                                                       00095600
      NUMLAY = 0                                                        00095700
      IF (ST1FLG) NUMLAY = 1                                            00095800
      IF (ST2FLG) NUMLAY = 2                                            00095900
      IF (ST3FLG) NUMLAY = 3                                            00096000
      WRITE (IPR,1370) NUMLAY                                           00096100
 1370 FORMAT ('0',16X,'WEATHERING DATA FOR',I2,                         00096200
     $                ' LAYER(S) HAS BEEN INPUT'/)                      00096300
C                                                                       00096400
C     +------------------------------------------+                      00096500
C     |      INTERPOLATE FOR MISSING VALUES      |                      00096600
C     |      FOR FIELDS UPDATED BY SPAR CARDS    |                      00096700
C     +------------------------------------------+                      00096800
C                                                                       00096900
      CALL INTBUF (MODEPR,2,ERRFL1)                                     00097000
      IF (ICC.NE.0) GO TO 9750                                          00097100
C                                                                       00097200
C     +------------------------------------------+                      00097300
C     |      CALCULATE GROUP CORRECTION          |                      00097400
C     |      AND PUT IN TABLE.                   |                      00097500
C     +------------------------------------------+                      00097600
C                                                                       00097700
      IF (MODEPR.NE.1) CALL UPDAT4                                      00097800
C                                                                       00097900
      IF (MODEPR.EQ.2) GO TO 1400                                       00098000
C                                                                       00098100
C     +------------------------------------------+                      00098200
C     |    SECOND PASS OF 1SPAR CARDS.           |                      00098300
C     |    CALCULATE MAX/MIN STATICS.            |                      00098400
C     |    (IF MODE 2, CALCULATE LATER)          |                      00098500
C     +------------------------------------------+                      00098600
C                                                                       00098700
      CALL PASS2       (SHTMOV,SPINC,                                   00098800
     $                  MODEPR,SPLTFL)                                  00098900
C                                                                       00099000
      IF (MODEPR.NE.1) REWIND IDSK2                                     00099100
C                                                                       00099200
 1400 IF (ICC.NE.0) GO TO 9750                                          00099300
C                                                                       00099400
C     +------------------------------------------+                      00099500
C     |   STUFF INFORMATION FROM INPUT CARDS     |                      00099600
C     |   INTO LINE HEADER.                      |                      00099700
C     |   WRITE NEW LINE HEADER TO OUTPUT TAPE.  |                      00099800
C     +------------------------------------------+                      00099900
C                                                                       00100000
      CALL INSHDR       (IEQUIP,CREW,DATTYP,DTS,                        00100100
     $                   IOAC,LINE,JOBNO1,NREC,ITYPE,IFOLD,NSPN,        00100200
     $                   NSANEW,METENG,SPINC,ZLOC1,MODEPR,DPI,          00100300
     $                   SHTMOV,IPLDIR,IFSP,IBFLAG,MOVFL1,LAIPF2)       00100400
      IF (IFHCRD.NE.1) GO TO 2100                                       00100500
      CALL FLDH (CRDTYP,ARRAY,LINHD1,LINHD2,ICR,IPR,N,*2100,*9750)
cmam  CALL FLDH (CRDTYP,ARRAY,LINHD1,LINHD2,ICR,IPR,N,&2100,&9750)      00100600
      WRITE (IPR,2090)                                                  00100700
 2090 FORMAT ('0** M0370 ** WARNING FROM SUBROUTINE SETUP:'/            00100800
     $ 13X,'A NON-FLDH INPUT CARD EXISTS AFTER A "1FLDH"'/              00100900
     $ 13X,'NO CARDS SHOULD BE INPUT AFTER THE "1FLDH" CARDS')          00101000
C                                                                       00101100
 2100 RETURN                                                            00101200
 9750 RETURN 1                                                          00101300
      END                                                               00101400
C=======================================================================00105600
C  ROUTINE:       TAPCHK                                                00105700
C  ROUTINE TYPE:  SUBROUTINE                                            00105800
C  PURPOSE:  CHECK FOR VALIDITY OF FIELDS IN LINE HEADER                00105900
C  AUTHOR:  DOUGLAS BODDY                                               00106000
C  DATE WRITTEN:  AUGUST 1985                                           00106100
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00106200
C                                                                       00106300
      SUBROUTINE TAPCHK                                                 00106400
C                                                                       00106500
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
cmam
      DOUBLE PRECISION RAD                                              00106600
C                                                                       00106700
      INTEGER   LINHD4(64)                                              00106800
C                                                                       00106900
      INTEGER*2 LINHD2(128)                                             00107000
cmam.........integer*2 kfor
	character*4 card, TDIS, SPAR
C                                                                       00107100
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00107200
C                                                                       00107300
      EQUIVALENCE (LINHD4(1),LINHD2(1),IBUF4(1))                        00107400
C                                                                       00107500
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00108100
      DATA MAXSM1/12000/,MAXSM3/6000/                                   00108200
C                                                                       00108300
cmam  IFOR = LINHD2(33)                                                 00108400
	call saver(LINHD2,'Format',kfor,0)
	ifor = kfor
cmam  IF (IFOR .EQ. 1 .OR. IFOR.EQ.3) GO TO 20                          00108500
cmam  WRITE (IPR,10)                                                    00108600
c10   FORMAT ('0** M0510 ** ERROR DETECTED BY SUBROUTINE TAPCHK:'/      00108700
cmam $ 13X,'INPUT TAPE IS NOT FORMAT 1 OR 3')                           00108800
cmam  ICC = 100                                                         00108900
C                                                                       00109000
c20   MAXSAM = MAXSM1                                                   00109100
cmam  IF (LINHD2(33).EQ.3) MAXSAM = MAXSM3                              00109200
	MAXSAM = MAXSM3
cmam  NSAMPS = LINHD4(16)                                               00109300
	call saver(LINHD4,'NumSmp',nsamps,0)
      IF (NSAMPS.LE.MAXSAM) GO TO 100                                   00109400
      WRITE (IPR,30) MAXSAM
cmam  WRITE (IPR,30) MAXSM1,MAXSM3                                      00109500
 30   FORMAT ('0** M0520 ** ERROR DETECTED BY SUBROUTINE TAPCHK:'/      00109600
     $ 13X,'NUMBER OF SAMPLES PER TRACE ON INPUT TAPE IS NOT WITHIN ',  00109700
     $     'PROGRAM LIMIT of ', i5)
cmam $     'PROGRAM LIMIT'/                                             00109800
cmam $ 13X,'LIMITS ARE ',I5,' FOR FORMAT 1 AND ',I5,' FOR FORMAT 3')    00109900
      ICC = 100                                                         00110000
C                                                                       00110100
 100  RETURN                                                            00110200
      END                                                               00110300
C  ROUTINE:       LAIP1C                                                00110400
C  ROUTINE TYPE:  SUBROUTINE                                            00110500
C  PURPOSE:  CHECK PARAMETERS ON 1LAIP CARD                             00110600
C  AUTHOR:  DOUGLAS BODDY                                               00110700
C  DATE WRITTEN:  AUGUST 1985                                           00110800
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00110900
C                                                                       00111000
      SUBROUTINE LAIP1C (NLOC,NREC,NTPR,MAXTRC,XGRINT,MODEPR,           00111100
     $                   CRSE,REPVEL,SHTMOV,ICC,DPI,                    00111200
     $                   MOVFL1,INDMOD,SPINC,METENG,                    00111300
     $                   IPLDIR,PLTFLG,ISYS,IPR)                        00111400
C                                                                       00111500
      INTEGER*2 MODEPR,METENG,INDMOD,IPLDIR,ISYS,PLTFLG(4)              00111600
C                                                                       00111700
      LOGICAL MOVFL1
cmam  LOGICAL*1 MOVFL1                                                  00111800
C                                                                       00111900
      IF (NLOC.GT.0) GO TO 60                                           00112000
      WRITE (IPR,50)                                                    00112100
 50   FORMAT ('0** M1110 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00112200
     $ 13X,'NUMBER OF GROUPS (ON "1LAIP" CARD) MUST BE POSITIVE')       00112300
      ICC = 100                                                         00112400
C                                                                       00112500
 60   IF (NREC.GE.0) GO TO 80                                           00112600
      WRITE (IPR,70)                                                    00112700
 70   FORMAT ('0** M1120 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00112800
     $ 13X,'NUMBER OF RECORDS (ON "1LAIP" CARD)'/                       00112900
     $ 13X,'MUST BE POSITIVE (OR BLANK OR ZERO FOR DEFAULT)')           00113000
      ICC = 100                                                         00113100
C                                                                       00113200
 80   IF (NTPR.GE.0 .AND. NTPR.LE.MAXTRC) GO TO 100                     00113300
      WRITE (IPR,90) MAXTRC                                             00113400
 90   FORMAT ('0** M1130 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00113500
     $ 13X,'NUMBER OF TRACES PER RECORD (ON "1LAIP" CARD)'/             00113600
     $ 13X,'MUST BE POSITIVE AND NOT GREATER THAN PROGRAM LIMIT OF',I6/ 00113700
     $ 13X,'(OR BLANK OR ZERO FOR DEFAULT)')                            00113800
      ICC = 100                                                         00113900
C                                                                       00114000
 100  IF (XGRINT.GT.0.0.AND.XGRINT.LE.9999. .OR.MODEPR.EQ.2) GO TO 120  00114100
      WRITE (IPR,110)                                                   00114200
 110  FORMAT ('0** M1140 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00114300
     $ 13X,'GROUP INTERVAL (ON "1LAIP" CARD)'/                          00114400
     $ 13X,'MUST BE POSITIVE AND NOT GREATER THAN 9999')                00114500
      ICC = 100                                                         00114600
C                                                                       00114700
 120  IF (MODEPR.EQ.1) GO TO 140                                        00114800
      IF (CRSE.GE.0.0 .AND. REPVEL.GE.0.0) GO TO 140                    00114900
      WRITE (IPR,130)                                                   00115000
 130  FORMAT ('0** M1150 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00115100
     $ 13X,'NEITHER CONSTANT REFERENCE PLANE ELEVATION NOR ',           00115200
     $     'REPLACEMENT VELOCITY CAN BE NEGATIVE')                      00115300
      ICC = 100                                                         00115400
C                                                                       00115500
 140  IF (SHTMOV*2.0 .EQ. AINT(SHTMOV*2.0)) GO TO 150                   00115600
      WRITE (IPR,145)                                                   00115700
 145  FORMAT ('0** M1160 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00115800
     $ 13X,'NORMAL SHOT MOVE-UP ON "1LAIP" CARD'/                       00115900
     $ 13X,'IS NOT AN INTEGER MULTIPLE OF 0.5')                         00116000
      ICC = 100                                                         00116100
C                                                                       00116200
 150  IF (SPINC*2.0 .EQ. AINT(SPINC*2.0)) GO TO 160                     00116300
      WRITE (IPR,155)                                                   00116400
 155  FORMAT ('0** M1160 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00116500
     $ 13X,'NORMAL SHOT LABEL INCREMENT/DECREMENT ON "1LAIP" CARD'/     00116600
     $ 13X,'IS NOT AN INTEGER MULTIPLE OF 0.5')                         00116700
      ICC = 100                                                         00116800
C                                                                       00116900
 160  IF (SHTMOV .NE. AINT(SHTMOV)) GO TO 165                           00117000
      MOVFL1 = .TRUE.                                                   00117100
 165  IF (INDMOD .EQ. 0) GO TO 180                                      00117200
      MOVFL1 = .TRUE.                                                   00117300
      IF (INDMOD .EQ. 1) GO TO 180                                      00117400
      WRITE (IPR,170)                                                   00117500
 170  FORMAT ('0** M1170 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00117600
     $ 13X,'INDEXING METHOD ON "1LAIP" CARD IS NOT BLANK, 0, OR 1')     00117700
      ICC = 100                                                         00117800
C                                                                       00117900
 180  IF (METENG.EQ.0.OR.METENG.EQ.1) GO TO 200                         00118000
      WRITE (IPR,190)                                                   00118100
 190  FORMAT ('0** M1180 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00118200
     $ 13X,'UNITS FLAG ON "1LAIP" CARD IS NOT BLANK, 0, OR 1')          00118300
      ICC = 100                                                         00118400
C                                                                       00118500
 200  IF (MODEPR.GE.0 .AND. MODEPR.LE.2) GO TO 230                      00118600
      WRITE (IPR,220)                                                   00118700
 220  FORMAT ('0** M1190 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00118800
     $ 13X,'PROCESSING MODE ON "1LAIP" CARD MUST BE BLANK, 0, 1, OR 2') 00118900
      ICC = 100                                                         00119000
C                                                                       00119100
 230  IF (IPLDIR.EQ.0 .OR. IPLDIR.EQ.1) GO TO 250                       00119200
      WRITE (IPR,240)                                                   00119300
 240  FORMAT ('0** M1200 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00119400
     $ 13X,'PLOT DIRECTION ON "1LAIP" CARD MUST BE BLANK, 0, OR 1')     00119500
      ICC = 100                                                         00119600
C                                                                       00119700
 250  IF (PLTFLG(4).GE.0 .AND. PLTFLG(4).LE.2) GO TO 270                00119800
      WRITE (IPR,260)                                                   00119900
 260  FORMAT ('0** M1210 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00120000
     $ 13X,'WEATHERING DISPLAY FLAG ON "1LAIP" CARD MUST BE ',          00120100
     $     '0 (OR BLANK), 1, OR 2')                                     00120200
      ICC = 100                                                         00120300
C                                                                       00120400
 270  IF (PLTFLG(1).GE.0 .AND. PLTFLG(1).LE.2) GO TO 290                00120500
      WRITE (IPR,280)                                                   00120600
 280  FORMAT ('0** M1220 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00120700
     $ 13X,'ELEVATION DISPLAY FLAG ON "1LAIP" CARD MUST BE ',           00120800
     $     '0 (OR BLANK), 1, OR 2')                                     00120900
      ICC = 100                                                         00121000
C                                                                       00121100
 290  IF (PLTFLG(2).GE.0 .AND. PLTFLG(2).LE.2) GO TO 310                00121200
      WRITE (IPR,300)                                                   00121300
 300  FORMAT ('0** M1230 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00121400
     $ 13X,'STACKING CHART DISPLAY FLAG ON "1LAIP" CARD MUST BE ',      00121500
     $     '0 (OR BLANK), 1, OR 2')                                     00121600
      ICC = 100                                                         00121700
C                                                                       00121800
 310  IF (PLTFLG(3).GE.0 .AND. PLTFLG(3).LE.2) GO TO 330                00121900
      WRITE (IPR,320)                                                   00122000
 320  FORMAT ('0** M1240 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00122100
     $ 13X,'TRAVERSE DISPLAY FLAG ON "1LAIP" CARD MUST BE ',            00122200
     $     '0 (OR BLANK), 1, OR 2')                                     00122300
      ICC = 100                                                         00122400
C                                                                       00122500
 330  IF (ISYS.GE.0 .AND. ISYS.LE.2) GO TO 400                          00122600
      WRITE (IPR,340)                                                   00122700
 340  FORMAT ('0** M1250 ** ERROR DETECTED BY SUBROUTINE LAIP1C:'/      00122800
     $ 13X,'PRINTOUT FLAG ON "1LAIP" CARD MUST BE ',                    00122900
     $     'BLANK, 0, 1, OR 2')                                         00123000
      ICC = 100                                                         00123100
C                                                                       00123200
 400  IF (MOVFL1) GO TO 420                                             00123300
      DPI = XGRINT * 0.25                                               00123400
      GO TO 430                                                         00123500
C                                                                       00123600
 420  DPI = XGRINT * 0.5                                                00123700
C                                                                       00123800
 430  RETURN                                                            00123900
      END                                                               00124000
C  ROUTINE:       LAIP2C                                                00124100
C  ROUTINE TYPE:  SUBROUTINE                                            00124200
C  PURPOSE:  CHECK PARAMETERS ON 2LAIP CARD                             00124300
C  AUTHOR:  DOUGLAS BODDY                                               00124400
C  DATE WRITTEN:  AUGUST 1985                                           00124500
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00124600
C                                                                       00124700
      SUBROUTINE LAIP2C (ICC,IEQUIP,IOAC,LINE,IFOLD,ITYPE,IRDC,         00124800
     $                   DATTYP,EORW,NORS,ANGDEV,IPR)                   00124900
C                                                                       00125000
	character*4 line,ibl4
      INTEGER*2 IFOLD,ITYPE,ANGDEV
	character*1 iequip,dattyp,nors,eorw
cmam  INTEGER*2 IEQUIP,IFOLD,ITYPE,DATTYP,EORW,NORS,ANGDEV              00125100
cmam  INTEGER*2 REGCDE                                                  00125200
cmam  INTEGER*2 EWNS(4)/'E','W','N','S'/                                00125300
cmam  INTEGER*2 VALTYP(3)/'C','R','T'/                                  00125400
      character*1 EWNS(4)
      character*1 VALTYP(3)
C                                                                       00125500
      character*1 EQUPCD(6)
cmam  INTEGER*2 EQUPCD(6)/'A','P','E','D','J','I'/                      00125600
      character*2 LOAC2,NA,NZ
cmam  INTEGER*2 LOAC2/'  '/,NA/' A'/,NZ/' Z'/                           00125700
C                                                                       00125800
      LOGICAL LOAC(2), NOAC(3), IRDC(3)
cmam  LOGICAL LOAC(2), NOAC(3), OK, IRDC(3)
cmam  INTEGER*4 REGNAM                                                  00126000
C                                                                       00126100
      EQUIVALENCE (LOAC(1),LOAC2)                                       00126200
      EQUIVALENCE (NOAC(1),KOAC)                                        00126300
C                                                                       00126400
      DATA IBL4/'    '/                                                 00126500
      data EWNS/'E','W','N','S'/
      data VALTYP/'C','R','T'/
C                                                                       00125500
      data EQUPCD/'A','P','E','D','J','I'/
      data LOAC2/'  '/,NA/' A'/,NZ/' Z'/
C                                                                       00126600
      KOAC = IOAC                                                       00126700
C                                                                       00126800
C     NUMB = 4                                                          00126900
C     CALL GSPARM ( 11, IRDC, NUMB )                                    00127000
C                                                                       00127100
      DO 50 I=1,6                                                       00127200
         IF (IEQUIP.EQ.EQUPCD(I)) GO TO 100                             00127300
 50   CONTINUE                                                          00127400
C                                                                       00127500
      WRITE (IPR,70) (EQUPCD(I),I=1,6)                                  00127600
 70   FORMAT ('0** M2110 ** WARNING FROM SUBROUTINE LAIP2C:'/           00127700
     $ 13X,'EQUIPMENT CODE ON "2LAIP" CARD IS NOT ',                    00127800
     $                5('"',A1,'", '),'OR "',A1,'"')                    00127900
C                                                                       00128000
 100	continue
C                                                                       00129400
 200  CONTINUE                                                          00129500
C                                                                       00129600
      IF (LINE.NE.IBL4) GO TO 300                                       00129700
      WRITE (IPR,250)                                                   00129800
 250  FORMAT ('0** M2130 ** ERROR DETECTED BY SUBROUTINE LAIP2C:'/      00129900
     $ 13X,'LINE ON "2LAIP" CARD MUST NOT BE BLANK')                    00130000
      ICC = 100                                                         00130100
C                                                                       00130200
 300  IF (IFOLD.GT.0) GO TO 400                                         00130300
      WRITE (IPR,350)                                                   00130400
 350  FORMAT ('0** M2140 ** ERROR DETECTED BY SUBROUTINE LAIP2C:'/      00130500
     $ 13X,'FOLD ON "2LAIP" CARD MUST BE GREATER THAN ZERO')            00130600
      ICC = 100                                                         00130700
C                                                                       00130800
 400  IF (ITYPE.GE.0 .AND. ITYPE.LE.2) GO TO 470                        00130900
      WRITE (IPR,450)                                                   00131000
 450  FORMAT ('0** M2150 ** ERROR DETECTED BY SUBROUTINE LAIP2C:'/      00131100
     $ 13X,'TYPE ON "2LAIP" CARD MUST BE BLANK, 0, 1, OR 2')            00131200
      ICC = 100                                                         00131300
C                                                                       00131400
 470  IF (DATTYP.EQ.VALTYP(1) .OR. DATTYP.EQ.VALTYP(2) .OR.             00131500
     $    DATTYP.EQ.VALTYP(3)) GO TO 500                                00131600
      WRITE (IPR,480)                                                   00131700
 480  FORMAT ('0** M2160 ** WARNING FROM SUBROUTINE LAIP2C:'/           00131800
     $ 13X,'DATA TYPE ON "2LAIP" CARD IS NOT "C", "R", OR "T"')         00131900
C                                                                       00132000
 500  IF (EORW.EQ.EWNS(1).OR.EORW.EQ.EWNS(2)) GO TO 520                 00132100
      WRITE (IPR,510)                                                   00132200
 510  FORMAT ('0** M2170 ** ERROR DETECTED BY SUBROUTINE LAIP2C:'/      00132300
     $ 13X,'EAST OR WEST FLAG ON "2LAIP" CARD MUST BE "E" OR "W"')      00132400
      ICC = 100                                                         00132500
C                                                                       00132600
 520  IF (NORS.EQ.EWNS(3).OR.NORS.EQ.EWNS(4)) GO TO 540                 00132700
      WRITE (IPR,530)                                                   00132800
 530  FORMAT ('0** M2180 ** ERROR DETECTED BY SUBROUTINE LAIP2C:'/      00132900
     $ 13X,'NORTH OR SOUTH FLAG ON "2LAIP" CARD MUST BE "N" OR "S"')    00133000
      ICC = 100                                                         00133100
C                                                                       00133200
 540  IF (ANGDEV.GE.0.AND.ANGDEV.LE.90) GO TO 570                       00133300
      WRITE (IPR,550)                                                   00133400
 550  FORMAT ('0** M2190 ** ERROR DETECTED BY SUBROUTINE LAIP2C:'/      00133500
     $ 13X,'ANGLE ON "2LAIP" CARD MUST BE BETWEEN 0 AND 90 DEGREES, ',  00133600
     $     'INCLUSIVE')                                                 00133700
      ICC = 100                                                         00133800
C                                                                       00133900
 570  RETURN                                                            00134000
      END                                                               00134100
C  ROUTINE:       PRMPRT                                                00134200
C  ROUTINE TYPE:  SUBROUTINE                                            00134300
C  PURPOSE:  PRINT PARAMETERS TO BE USED                                00134400
C  AUTHOR:  DOUGLAS BODDY                                               00134500
C  DATE WRITTEN:  AUGUST 1985                                           00134600
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00134700
C                                                                       00134800
      SUBROUTINE PRMPRT (NLOC,MODEPR,NREC,NTPR,XGRINT,INDMOD,PLTFLG,    00134900
     $                   SHTMOV,SPINC,METENG,IPLDIR,TERVAL,ISYS,IPR)    00135000
C                                                                       00135100
      INTEGER*2 MODEPR,PLTFLG(4),METENG,ISYS,INDMOD,IPLDIR              00135200
                                                                        00135300
      WRITE (IPR,100) NLOC,MODEPR,NREC,NTPR,XGRINT                      00135400
      WRITE (IPR,200) INDMOD,PLTFLG(4),SHTMOV,PLTFLG(1),                00135500
     $                SPINC,METENG,PLTFLG(2),                           00135600
     $                PLTFLG(3),IPLDIR,TERVAL,ISYS                      00135700
 100  FORMAT ('0',26X,'***** PROCESSING PARAMETERS FOR PROGRAM ',       00135800
     $                'LAIP AFTER DEFAULTS *****'//                     00135900
     $ 17X,'NUMBER OF GROUPS ON LINE . . . . . . . ',I5,                00136000
     $                10X,'PROCESSING METHOD. . . . . . . . . . . ',I5/ 00136100
     $       61X,     13X,'0 = NORMAL PROCESSING, WITH'/                00136200
     $ 17X,'NUMBER OF RECORDS. . . . . . . . . . . ',I5,                00136300
     $                13X,'    INDEXING AND STATICS COMPUTATIONS'/      00136400
     $       61X,     13X,'1 = INDEXING ONLY,'/                         00136500
     $ 17X,'NUMBER OF TRACES PER RECORD. . . . . . ',I5,                00136600
     $                13X,'    NO STATICS COMPUTATIONS'/                00136700
     $       61X,     13X,'2 = STATICS COMPUTATIONS ONLY,'/             00136800
     $ 17X,'GROUP INTERVAL . . . . . . . . . . . . ',F8.2,              00136900
     $                10X,'    NO INDEXING'/ )                          00137000
 200  FORMAT (17X,'INDEXING METHOD. . . . . . . . . . . . ',I5,         00137100
     $                10X,'DISPLAY FLAG - WEATHERING. . . . . . . ',I5/ 00137200
     $       61X,     13X,'0=NO DISPLAY, 1=PRINTER, 2=PLOTTER'/         00137300
     $ 17X,'NORMAL SHOT MOVE-UP. . . . . . . . . . ',F8.2/              00137400
     $       61X,     10X,'DISPLAY FLAG - ELEVATION . . . . . . . ',I5/ 00137500
     $ 17X,'NORMAL SHOT LABEL INCREMENT/DECREMENT. ',F8.2,              00137600
     $                10X,'0=NO DISPLAY, 1=PRINTER, 2=PLOTTER'/ /       00137700
     $ 17X,'UNITS FLAG . . . . . . . . . . . . . . ',I5,                00137800
     $                10X,'DISPLAY FLAG - STACKING CHART. . . . . ',I5/ 00137900
     $ 20X,'0 = ENGLISH UNITS',24X,                                     00138000
     $                13X,'0=NO DISPLAY, 1=PRINTER, 2=PLOTTER'/         00138100
     $ 20X,'1 = METRIC  UNITS'/                                         00138200
     $       61X,     10X,'DISPLAY FLAG - TRAVERSE. . . . . . . . ',I5/ 00138300
     $ 17X,'PLOT DIRECTION . . . . . . . . . . . . ',I5,                00138400
     $                13X,'0=NO DISPLAY, 1=PRINTER, 2=PLOTTER'/         00138500
     $ 20X,'0 = RIGHT TO LEFT  1 = LEFT TO RIGHT'/                      00138600
     $               71X,'CDP LABELING BUCKET. . . . . . . . . . ',F8.2/00138700
     $ 17X,'PRINTOUT OPTIONS . . . . . . . . . . . ',I5/                00138800
     $ 20X,'0 = FULL REPORT'/20X,'1 = ABBREVIATED USER REPORT'/         00138900
     $ 20X,'2 = SHORT FORM REPORT')                                     00139000
      RETURN                                                            00139100
      END                                                               00139200
C  ROUTINE:       UPDAT1                                                00139300
C  ROUTINE TYPE:  SUBROUTINE                                            00139400
C  PURPOSE:  UPDATE TABLE USING INFO ON "1GPAR" AND "2GPAR"             00139500
C  AUTHOR:  DOUGLAS BODDY                                               00139600
C  DATE WRITTEN:  AUGUST 1985                                           00139700
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00139800
C                                                                       00139900
      SUBROUTINE UPDAT1 (CHTHK1,CHTHK2,IGNDX,ELEV,CHELEV,XCOOR,YCOOR,   00140000
     $                   THICK1,VEL1,THICK2,VEL2,RGELEV,CHRGEL,RGRVEL)  00140100
C                                                                       00140200
C***********************************************************************00140300
C     TABLE CHARACTERISTICS:                                            00140400
C       EACH "RECORD" CONTAINS 15 ENTRIES:                              00140500
C         1)  GROUP INDEX                                               00140600
C         2)  ELEVATION                                                 00140700
C         3)  X COORDINATE                                              00140800
C         4)  Y COORDINATE                                              00140900
C         5)  THICKNESS LAYER 1                                         00141000
C         6)  VELOCITY LAYER 1                                          00141100
C         7)  THICKNESS LAYER 2                                         00141200
C         8)  VELOCITY LAYER 2                                          00141300
C         9)  THICKNESS LAYER 3                                         00141400
C        10)  VELOCITY LAYER 3                                          00141500
C        11)  REGIONAL REFERENCE SURFACE ELEVATION                      00141600
C        12)  REGIONAL REFERENCE SURFACE REPLACEMENT VELOCITY           00141700
C        13)  UPHOLE TIME (CORRECTED TO VERTICAL)                       00141800
C             NOTE:  IF SOURCE LOCATION ON 1SPAR CARD IS FRACTIONAL,    00141900
C                    THE LOCATION WILL BE ROUNDED IN ORDER THAT         00142000
C                    IT CAN BE ASSOCIATED WITH AN INTEGER GROUP INDEX   00142100
C                    IN THIS TABLE.                                     00142200
C        14)  DEPTH OF HOLE                                             00142300
C        15)  GROUP CORRECTION                                          00142400
C***********************************************************************00142500
C                                                                       00142600
cmam  DOUBLE PRECISION CHTHK1,CHTHK2,CHELEV,CHRGEL                      00142700
cmam  DOUBLE PRECISION BLANK8                                           00142800
      character*5 CHTHK1,CHTHK2,CHELEV,CHRGEL
      character*5 BLANK8
      DOUBLE PRECISION RAD                                              00142900
C                                                                       00143000
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00143100
	character*4 card, TDIS, SPAR
C                                                                       00143200
C                                                                       00143800
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
      DATA BLANK8/'     '/
cmam  DATA BLANK8/'        '/                                           00143900
C                                                                       00144000
      ICTR = IGNDX - INX1ST                                             00144100
C                                                                       00144200
      IF (YCOOR .GT. BUFMAX(7)) BUFMAX(7) = YCOOR                       00144300
      IF (YCOOR .LT. BUFMIN(7)) BUFMIN(7) = YCOOR                       00144400
C                                                                       00144500
      CALL BUFSTR (ICTR,1,FLOAT(IGNDX))                                 00144600
      IF (CHELEV.EQ.BLANK8) GO TO 50                                    00144700
      CALL BUFSTR (ICTR,2,ELEV)                                         00144800
      IF (ELEV .GT. BUFMAX(5)) BUFMAX(5) = ELEV                         00144900
      IF (ELEV .LT. BUFMIN(5)) BUFMIN(5) = ELEV                         00145000
 50   CONTINUE                                                          00145100
      CALL BUFSTR (ICTR,3,XCOOR)                                        00145200
      CALL BUFSTR (ICTR,4,YCOOR)                                        00145300
      IF (CHTHK1.NE.BLANK8) CALL BUFSTR (ICTR,5,THICK1)                 00145400
      IF (VEL1.NE.0.0) CALL BUFSTR (ICTR,6,VEL1)                        00145500
      IF (CHTHK2.NE.BLANK8) CALL BUFSTR (ICTR,7,THICK2)                 00145600
      IF (VEL2.NE.0.0) CALL BUFSTR (ICTR,8,VEL2)                        00145700
C                                                                       00145800
      IF (RGELEV.EQ.0.0 .AND. CHRGEL.EQ.BLANK8) GO TO 70                00145900
      CALL BUFSTR (ICTR,11,RGELEV)                                      00146000
      IF (RGELEV.GT.BUFMAX(2)) BUFMAX(2) = RGELEV                       00146100
      IF (RGELEV.LT.BUFMIN(2)) BUFMIN(2) = RGELEV                       00146200
 70   CONTINUE                                                          00146300
      IF (RGRVEL.NE.0.0) CALL BUFSTR (ICTR,12,RGRVEL)                   00146400
C                                                                       00146500
      GO TO 999                                                         00146600
C                                                                       00146700
      ENTRY UPDAT2 (IGNDX2,THICK3,VEL3)                                 00146800
C                                                                       00146900
C     +----------------------------------------------+                  00147000
C     | MAKE SURE INDEX MATCHES INDEX USED IN UPDAT1 |                  00147100
C     +----------------------------------------------+                  00147200
C                                                                       00147300
      ICTR2 = IGNDX2 - INX1ST                                           00147400
      IF (ICTR2.EQ.ICTR) GO TO 200                                      00147500
      WRITE (IPR,100)                                                   00147600
 100  FORMAT ('0** M3010 ** ERROR DETECTED BY SUBROUTINE UPDAT2:'/      00147700
     $ 13X,'GROUP INDEX FROM "2GPAR" CARD TO UPDATE TABLE DOES NOT',    00147800
     $ 13X,'MATCH THE GROUP INDEX LAST USED IN UPDATE OF TABLE USING ', 00147900
     $     'A "1GPAR" CARD')                                            00148000
      ICC = 100                                                         00148100
      GO TO 999                                                         00148200
C                                                                       00148300
 200  CONTINUE                                                          00148400
      CALL BUFSTR (ICTR2,9,THICK3)                                      00148500
      IF (VEL3.NE.0.0) CALL BUFSTR (ICTR2,10,VEL3)                      00148600
C                                                                       00148700
 999  RETURN                                                            00148800
      END                                                               00148900
C  ROUTINE:       UPDAT3                                                00149000
C  ROUTINE TYPE:  SUBROUTINE                                            00149100
C  PURPOSE:  UPDATE                                                     00149200
C  AUTHOR:  DOUGLAS BODDY                                               00149300
C  DATE WRITTEN:  AUGUST 1985                                           00149400
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00149500
C                                                                       00149600
      SUBROUTINE UPDAT3 (ZLSLOC,TIM,DEPHOL)                             00149700
C                                                                       00149800
      DOUBLE PRECISION RAD                                              00149900
C                                                                       00150000
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00150100
	character*4 card, TDIS, SPAR
C                                                                       00150200
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00150800
      DATA PCTR3/0.5/,PDEP/-99999./                                     00150900
C                                                                       00151000
      ZCTR3 =  ZLSLOC - FLOAT(INX1ST)                                   00151100
      LCTR3 = ZCTR3 + 0.5                                               00151200
      XCTR3 = AINT(ZCTR3)                                               00151300
      ICTR3 = INT(ZCTR3)                                                00151400
C                                                                       00151500
      IF (ZCTR3.GE.1.0 .AND. ZCTR3.LE.NLOC) GO TO 150                   00151600
      K1 = BUF(1,1)                                                     00151700
      K2 = K1 + NLOC - 1                                                00151800
      WRITE (IPR,100) K1,K2                                             00151900
 100  FORMAT ('0** M3020 ** ERROR DETECTED BY SUBROUTINE UPDAT3:'/      00152000
     $ 13X,'GROUP INDEX ON "1SPAR" CARD IS INVALID'/                    00152100
     $ 13X,'VALID RANGE GIVEN THE INFORMATION ON "1LAIP" AND "1GPAR" ', 00152200
     $     'CARDS IS',I6,' TO',I6)                                      00152300
      ICC = 100                                                         00152400
      GO TO 999                                                         00152500
C                                                                       00152600
C     +------------------------------------------+                      00152700
C     |    DETERMINE MAX/MIN HOLE DEPTH          |                      00152800
C     +------------------------------------------+                      00152900
C                                                                       00153000
 150  IF (DEPHOL.GT.BUFMAX(3)) BUFMAX(3) = DEPHOL                       00153100
      IF (DEPHOL.LT.BUFMIN(3)) BUFMIN(3) = DEPHOL                       00153200
C                                                                       00153300
      IF (ZCTR3.EQ.XCTR3) CALL BUFSTR (LCTR3,14,DEPHOL)                 00153400
      AJCTR3 = AINT(PCTR3+1.0)                                          00153500
      IF (AJCTR3.GE.ZCTR3) GO TO 190                                    00153600
 160  JCTR3 = AJCTR3                                                    00153700
      IF (DEPHOL.NE.PDEP.AND.PDEP.GT.-99999.) GO TO 170                 00153800
      ADEP = DEPHOL                                                     00153900
      GO TO 180                                                         00154000
C                                                                       00154100
 170  ADEP = PDEP + (DEPHOL - PDEP) * ((AJCTR3 - PCTR3) / (ZCTR3-PCTR3))00154200
C                                                                       00154300
 180  CALL BUFSTR (JCTR3,14,ADEP)                                       00154400
      AJCTR3 = AJCTR3 + 1.0                                             00154500
      IF (AJCTR3.LT.ZCTR3) GO TO 160                                    00154600
 190  PCTR3 = ZCTR3                                                     00154700
      PDEP = DEPHOL                                                     00154800
C                                                                       00154900
C     +------------------------------------------+                      00155000
C     |     DETERMINE MAX/MIN UPHOLE TIME        |                      00155100
C     |       (CORRECTED TO VERTICAL)            |                      00155200
C     +------------------------------------------+                      00155300
C                                                                       00155400
      CALL BUFSTR (LCTR3,13,TIM)                                        00155500
      IF (TIM.GT.BUFMAX(4)) BUFMAX(4) = TIM                             00155600
      IF (TIM.LT.BUFMIN(4)) BUFMIN(4) = TIM                             00155700
C                                                                       00155800
C     +------------------------------------------+                      00155900
C     |    DETERMINE MAX/MIN GROUP ELEVATION     |                      00156000
C     +------------------------------------------+                      00156100
C                                                                       00156200
      IF (XCTR3.EQ.ZCTR3) GO TO 330                                     00156300
      IF (BUF(ICTR3,2).EQ.BUF(ICTR3+1,2)) GO TO 330                     00156400
      XDF = ZCTR3 - XCTR3                                               00156500
      Y = BUF(ICTR3,2)                                                  00156600
      Z = (BUF(ICTR3+1,2) - Y) * XDF + Y                                00156700
      IF (Z.GT.BUFMAX(1)) BUFMAX(1) = Z                                 00156800
      IF (Z.LT.BUFMIN(1)) BUFMIN(1) = Z                                 00156900
      GO TO 999                                                         00157000
C                                                                       00157100
 330  ITEMP = BUF(ICTR3,2)                                              00157200
      IF (ITEMP.EQ.ZMISS) GO TO 999                                     00157300
      IF (ITEMP.GT.BUFMAX(1)) BUFMAX(1) = ITEMP                         00157400
      IF (ITEMP.LT.BUFMIN(1)) BUFMIN(1) = ITEMP                         00157500
C                                                                       00157600
 999  RETURN                                                            00157700
      END                                                               00157800
C  ROUTINE:       UPDAT4                                                00157900
C  ROUTINE TYPE:  SUBROUTINE                                            00158000
C  PURPOSE:  CALCULATE STATICS                                          00158100
C  AUTHOR:  DOUGLAS BODDY                                               00158200
C  DATE WRITTEN:  AUGUST 1985                                           00158300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00158400
C                                                                       00158500
      SUBROUTINE UPDAT4                                                 00158600
C                                                                       00158700
#include <save_defs.h>
      DOUBLE PRECISION CINI,CREC,TW
cmam  DOUBLE PRECISION CINI,CREC,XDF,TW                                 00158800
      DOUBLE PRECISION RAD                                              00158900
C                                                                       00159000
      INTEGER*2 IBSCOR,MODEPR                                           00159100
      INTEGER*2 IBUF2(128)                                              00159200
C                                                                       00159300
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00159400
      LOGICAL SPLTFL
	logical test1
	integer jspbuf(1)
	pointer (kspbuf,jspbuf)
	character*4 card, TDIS, SPAR
C                                                                       00159600
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00160200
      EQUIVALENCE (IBUF4(1),IBUF2(1))                                   00160300
	data test1/.false./
	save test1
C                                                                       00160400
	kspbuf = indxsp
      NST = 1                                                           00160500
      NEND = NLOC                                                       00160600
C                                                                       00160700
      IF (BUF(NST,2).EQ.ZMISS) GO TO 999                                00160800
C                                                                       00160900
 390  DO 420 I=NST,NEND                                                 00161000
         BF2 = BUF(I,2)                                                 00161100
         IF (BF2.EQ.ZMISS) then	
	   call saver(ibuf2,'GrpElv',ival,1)
	   BF2 = ival
	 endif
cmam     IF (BF2.EQ.ZMISS) BF2 = IBUF2(120)                             00161200
         CREC = BUF(I,11) - BF2                                         00161300
         IF (ST1FLG) CREC = CREC + BUF(I,5)                             00161400
         IF (ST2FLG) CREC = CREC + BUF(I,7)                             00161500
         IF (ST3FLG) CREC = CREC + BUF(I,9)                             00161600
         CREC = CREC / DBLE(BUF(I,12))                                  00161700
         CREC = CREC - DBLE(BUF(I,13)) / 1000.0D+00                     00161800
         DEPHLE = BUF(I,14)
	 test1 = .true.
cmam     DEPHOL = BUF(I,14)                                             00161900
         ZI = I                                                         00162000
         CALL WCOR (ZI,ZI,I,DEPHLE,ST1FLG,ST2FLG,ST3FLG,TW)
cmam     CALL WCOR (ZI,ZI,I,DEPHOL,ST1FLG,ST2FLG,ST3FLG,TW)             00162100
         CREC = CREC - TW                                               00162200
	avalue = sngl(crec)
         CALL BUFSTR (I,15,avalue)
ccmam    CALL BUFSTR (I,15,CREC)                                        00162300
 420  CONTINUE                                                          00162400
C                                                                       00162500
      IF (BUF(NST,2).NE.ZMISS) GO TO 999                                00162600
C                                                                       00162700
      ENTRY UPDAT5 (ZLSLOC,XLCTRA,XLCTRB,DEPHOL,XLLTBG,XLFTAG,IBSCOR,   00162800
     $              OFFDIS,OFFANG,SHTMOV,                               00162900
     $              CORINI,CORREC,                                      00163000
     $              SPINC,LRI,NEXTRI,SPNN,ACTSPN,MODEPR,SPLTFL)         00163100
C                                                                       00163200
	kspbuf = indxsp
      LRI1 = LRI                                                        00163300
	if(test1) then
	   dephol = dephle
	   test1 = .false.
	endif
C                                                                       00163400
C     **********************************                                00163500
C     | RESET SRCLOC TO REFLECT OFFDIS |                                00163600
C     **********************************                                00163700
C                                                                       00163800
      SRCLOC = ZLSLOC                                                   00163900
      IF ( MODEPR .EQ. 2 .OR. OFFDIS .EQ. 0 ) GO TO 480                 00164000
      X = DBLE(OFFANG) * RAD                                            00164100
      XDIS =  COS(X) * OFFDIS                                           00164200
      IXDIS = XDIS + SIGN(0.5,XDIS)                                     00164300
      XDGR = FLOAT(IXDIS) / XGRINT                                      00164400
      SRCLOC = ZLSLOC + XDGR                                            00164500
C                                                                       00164600
 480  LOCA = XLCTRA                                                     00164700
      LOCB = XLCTRB                                                     00164800
      LOCL = XLLTBG                                                     00164900
      LOCF = XLFTAG                                                     00165000
      SHTMVT = 0                                                        00165100
      IF (SPNN.EQ.0.) GO TO 490                                         00165200
      ACTSPN = SPNN                                                     00165300
      GO TO 500                                                         00165400
C                                                                       00165500
 490  ACTSPN = ACTSPN + SPINC                                           00165600
C                                                                       00165700
 500  NNSPN = ACTSPN                                                    00165800
      IF (FLOAT(NNSPN).NE.ACTSPN) NNSPN = 0                             00165900
      ZCTR5 =  SRCLOC - FLOAT(INX1ST)                                   00166000
C                                                                       00166100
      NACTR5 = (ZCTR5 + 0.4999) * 2. - 1.                               00166200
C                                                                       00166300
      IF (MODEPR.NE.2) jSPBUF (NACTR5) = NNSPN
cmam  IF (MODEPR.NE.2) ISPBUF (NACTR5+INDXSP) = NNSPN                   00166400
      IF (MODEPR.EQ.1) GO TO 597                                        00166500
C                                                                       00166600
      LCTR5 = ZCTR5 + 0.5                                               00166700
      XCTR5 = AINT(ZCTR5)                                               00166800
      ICTR5 = INT(ZCTR5)                                                00166900
C                                                                       00167000
      CALL WCOR (ZCTR5,XCTR5,ICTR5,DEPHOL,ST1FLG,ST2FLG,ST3FLG,TW)      00167100
C                                                                       00167200
C     +------------------------------------------+                      00167300
C     |     CALCULATE INITIATION CORRECTION      |                      00167400
C     +------------------------------------------+                      00167500
C                                                                       00167600
      BF2 = BUF(ICTR5,2)                                                00167700
      IF (BF2.EQ.ZMISS) then
	call saver(ibuf2,'SrPtEl',ival,1)
	BF2 = ival
      endif
cmam  IF (BF2.EQ.ZMISS) BF2 = IBUF2(112)                                00167800
      CINI = 0                                                          00167900
      IF (ST1FLG) CINI = CINI + BUF(ICTR5,5)                            00168000
      IF (ST2FLG) CINI = CINI + BUF(ICTR5,7)                            00168100
      IF (ST3FLG) CINI = CINI + BUF(ICTR5,9)                            00168200
      CINI = (DBLE(BUF(ICTR5,11) - BF2) + CINI) /                       00168300
     $        DBLE(BUF(ICTR5,12)) - TW                                  00168400
C                                                                       00168500
      ICTR5A = LOCA - INX1ST                                            00168600
      ICTR5B = LOCB - INX1ST                                            00168700
      LOCACT = LOCA                                                     00168800
C                                                                       00168900
      DO 595 II=ICTR5A,ICTR5B                                           00169000
         IF (SPLTFL.AND.LOCACT.GT.LOCL.AND.LOCACT.LT.LOCF) GO TO 590    00169100
         CREC = BUF(II,15)                                              00169200
         IF (CREC.NE.ZMISS) GO TO 570                                   00169300
C                                                                       00169400
C     +------------------------------------------+                      00169500
C     |     BRANCH TO CALCULATE GROUP STATIC     |                      00169600
C     |     THEN COME BACK AND FINISH UP.        |                      00169700
C     +------------------------------------------+                      00169800
C                                                                       00169900
         BF2 = BUF(II,2)                                                00170000
         IF (BF2.EQ.ZMISS) then
	   call saver(ibuf2,'GrpElv',ival,1)
	   BF2 = ival
         endif
cmam     IF (BF2.EQ.ZMISS) BF2 = IBUF2(120)                             00170100
         CREC = BUF(II,11) - BF2                                        00170200
         IF (ST1FLG) CREC = CREC + BUF(II,5)                            00170300
         IF (ST2FLG) CREC = CREC + BUF(II,7)                            00170400
         IF (ST3FLG) CREC = CREC + BUF(II,9)                            00170500
         CREC = CREC / DBLE(BUF(II,12))                                 00170600
         CREC = CREC - DBLE(BUF(II,13)) / 1000.0D+00                    00170700
         DEPHOL = BUF(II,14)                                            00170800
         ZI = II                                                        00170900
         CALL WCOR (ZI,ZI,II,DEPHOL,ST1FLG,ST2FLG,ST3FLG,TW)            00171000
         CREC = CREC - TW                                               00171100
	avalue = sngl(crec)
         CALL BUFSTR (II,15,avalue)
ccmam    CALL BUFSTR (II,15,CREC)                                       00171200
C                                                                       00171300
 568     CREC = BUF(II,15)                                              00171400
C                                                                       00171500
 570     STATIC = (CINI + CREC) * 1000                                  00171600
C                                                                       00171700
         IF (STATIC.GE.30000.OR.STATIC.LT.-32767) GO TO 580             00171800
         IF (STATIC.GT.BUFMAX(6)) BUFMAX(6) = STATIC                    00171900
         IF (STATIC.LT.BUFMIN(6)) BUFMIN(6) = STATIC                    00172000
C                                                                       00172100
 580     CORREC = SNGL(CREC)                                            00172200
         CORINI = SNGL(CINI)                                            00172300
         IF (MODEPR.EQ.2) GO TO 595                                     00172400
         WRITE (IDSK2) SRCLOC,LOCACT,CORINI,CORREC                      00172500
 590     LOCACT = LOCACT + 1                                            00172600
 595  CONTINUE                                                          00172700
C                                                                       00172800
      IF (MODEPR.EQ.2) GO TO 999                                        00172900
C                                                                       00173000
 597  SRCLOC = SRCLOC + SHTMOV                                          00173100
      IF (ZCTR5+SHTMOV.GT.NLOC) GO TO 999                               00173200
C                                                                       00173300
      SHTMVT = SHTMVT + SHTMOV                                          00173400
      LOCA = XLCTRA + SHTMVT                                            00173500
      LOCB = XLCTRB + SHTMVT                                            00173600
      LOCL = XLLTBG + SHTMVT                                            00173700
      LOCF = XLFTAG + SHTMVT                                            00173800
C                                                                       00173900
      LRI1 = LRI1 + 1                                                   00174000
      IF (LRI1.LT.NEXTRI) GO TO 490                                     00174100
C                                                                       00174200
 999  RETURN                                                            00174300
      END                                                               00174400
C  ROUTINE:       WCOR                                                  00174500
C  ROUTINE TYPE:  SUBROUTINE                                            00174600
C  PURPOSE:                                                             00174700
C  AUTHOR:  DOUGLAS BODDY                                               00174800
C  DATE WRITTEN:  DECEMBER 1985                                         00174900
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00175000
C                                                                       00175100
      SUBROUTINE WCOR (ZCTR5,XCTR5,ICTR5,DEPHOL,ST1FLG,ST2FLG,ST3FLG,TW)00175200
C                                                                       00175300
      DOUBLE PRECISION TW,X1,X2,X3                                      00175400
C                                                                       00175500
cmam  LOGICAL*1 INTFLG                                                  00175600
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG                                    00175700
      LOGICAL INTFLG
      LOGICAL ST1FLG,ST2FLG,ST3FLG
C                                                                       00175800
      INTFLG = .FALSE.                                                  00175900
      IF (XCTR5.EQ.ZCTR5) GO TO 505                                     00176000
C                                                                       00176100
C     +------------------------------------------+                      00176200
C     |    INTFLG = .TRUE.                       |                      00176300
C     |    MEANS THAT WE MUST INTERPOLATE        |                      00176400
C     |    BETWEEN GROUPS SINCE GROUPS ON GPAR   |                      00176500
C     |    CARDS (AND IN OUR TABLE) ARE WHOLE    |                      00176600
C     |    NUMBERS ONLY.                         |                      00176700
C     +------------------------------------------+                      00176800
C                                                                       00176900
      INTFLG = .TRUE.                                                   00177000
      XDF = ZCTR5 - XCTR5                                               00177100
C                                                                       00177200
C     +------------------------------------------+                      00177300
C     |    DETERMINE WEATHERING CORRECTION       |                      00177400
C     |    FOR SHOTS WITHIN THE WEATHERING.      |                      00177500
C     |    (IF OUTSIDE, SET TO 0.0)              |                      00177600
C     |    THIS IS USED TO CALCULATE STATICS.    |                      00177700
C     +------------------------------------------+                      00177800
C                                                                       00177900
 505  TW = 0.0                                                          00178000
      IF (.NOT.ST1FLG) GO TO 560                                        00178100
      X1 = BUF(ICTR5,5)                                                 00178200
      IF (INTFLG) GO TO 510                                             00178300
      IF (DEPHOL.GE.X1) GO TO 520                                       00178400
      TW = (X1 - DBLE(DEPHOL)) / DBLE(BUF(ICTR5,6))                     00178500
      IF (ST2FLG) TW = TW + DBLE(BUF(ICTR5,7)) / DBLE(BUF(ICTR5,8))     00178600
      IF (ST3FLG) TW = TW + DBLE(BUF(ICTR5,9)) / DBLE(BUF(ICTR5,10))    00178700
      GO TO 560                                                         00178800
C                                                                       00178900
 510  X1 = X1 + (DBLE(BUF(ICTR5+1,5)) - X1) * XDF                       00179000
      IF (DEPHOL.GE.X1) GO TO 520                                       00179100
      TW = (X1 - DBLE(DEPHOL)) /                                        00179200
     $     (BUF(ICTR5,6) + (DBLE(BUF(ICTR5+1,6) - BUF(ICTR5,6))) * XDF) 00179300
      IF (ST2FLG) TW = TW +                                             00179400
     $   (BUF(ICTR5,7) + DBLE((BUF(ICTR5+1,7) - BUF(ICTR5,7))) * XDF) / 00179500
     $   (BUF(ICTR5,8) + DBLE((BUF(ICTR5+1,8) - BUF(ICTR5,8))) * XDF)   00179600
      IF (ST3FLG) TW = TW +                                             00179700
     $   (BUF(ICTR5,9)  + DBLE((BUF(ICTR5+1,9) - BUF(ICTR5,9))) * XDF) /00179800
     $   (BUF(ICTR5,10) + DBLE((BUF(ICTR5+1,10) - BUF(ICTR5,10)))* XDF) 00179900
      GO TO 560                                                         00180000
C                                                                       00180100
 520  IF (.NOT.ST2FLG) GO TO 560                                        00180200
      X2 = X1 + BUF(ICTR5,7)                                            00180300
      IF (INTFLG) GO TO 530                                             00180400
      IF (DEPHOL.GE.X2) GO TO 540                                       00180500
      TW = (X2 - DBLE(DEPHOL)) / DBLE(BUF(ICTR5,8))                     00180600
      IF (ST3FLG) TW = TW + DBLE(BUF(ICTR5,9)) / DBLE(BUF(ICTR5,10))    00180700
      GO TO 560                                                         00180800
C                                                                       00180900
 530  X2 = X2 + DBLE((BUF(ICTR5+1,7) - BUF(ICTR5,7))) * XDF             00181000
      IF (DEPHOL.GE.X2) GO TO 540                                       00181100
      TW = (X2 - DEPHOL) /                                              00181200
     $     (BUF(ICTR5,8) + DBLE((BUF(ICTR5+1,8) - BUF(ICTR5,8))) * XDF) 00181300
      IF (ST3FLG) TW = TW +                                             00181400
     $   (BUF(ICTR5,9) + DBLE((BUF(ICTR5+1,9) - BUF(ICTR5,9))) * XDF) / 00181500
     $   (BUF(ICTR5,10)+ DBLE((BUF(ICTR5+1,10)- BUF(ICTR5,10)))* XDF)   00181600
C                                                                       00181700
 540  IF (.NOT.ST3FLG) GO TO 560                                        00181800
      X3 = X2 + BUF(ICTR5,9)                                            00181900
      IF (INTFLG) GO TO 550                                             00182000
      IF (DEPHOL.LT.X3) TW = (X3 - DBLE(DEPHOL)) / DBLE(BUF(ICTR5,8))   00182100
      GO TO 560                                                         00182200
C                                                                       00182300
 550  X3 = X3 + DBLE((BUF(ICTR5+1,9) - BUF(ICTR5,9))) * XDF             00182400
      IF (DEPHOL.LT.X3) TW = (X3 - DBLE(DEPHOL)) /                      00182500
     $    (BUF(ICTR5,8) + DBLE((BUF(ICTR5+1,8) - BUF(ICTR5,8))) * XDF)  00182600
C                                                                       00182700
 560  RETURN                                                            00182800
      END                                                               00182900
C  ROUTINE:       INTBUF                                                00183000
C  ROUTINE TYPE:  SUBROUTINE                                            00183100
C  PURPOSE:  INTERPOLATE FOR MISSING VALUES IN BUFF                     00183200
C  AUTHOR:  DOUGLAS BODDY                                               00183300
C  DATE WRITTEN:  AUGUST 1985                                           00183400
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00183500
C                                                                       00183600
      SUBROUTINE INTBUF (MODEPR,ICODE,ERRFL1)                           00183700
C                                                                       00183800
      DOUBLE PRECISION RAD                                              00183900
C                                                                       00184000
      INTEGER*2 MODEPR                                                  00184100
C                                                                       00184200
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00184300
cmam  LOGICAL*1 ERRFL1                                                  00184400
cmam  LOGICAL*1 ERRFL2/.FALSE./                                         00184500
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL ERRFL1
      LOGICAL ERRFL2
	character*4 card, TDIS, SPAR
C                                                                       00184600
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
      data ERRFL2/.FALSE./
C                                                                       00185200
      IF (ICODE.EQ.2) GO TO 680                                         00185300
      ISTART = 1                                                        00185400
      IEND = 12                                                         00185500
      GO TO 690                                                         00185600
C                                                                       00185700
 680  ISTART = 13                                                       00185800
      IEND = 14                                                         00185900
      IF (ERRFL1) ERRFL2 = .TRUE.                                       00186000
C                                                                       00186100
 690  DO 850 JENT=ISTART,IEND                                           00186200
C                                                                       00186300
         I1 = 1                                                         00186400
         IF (BUF(1,JENT).NE.ZMISS) GO TO 740                            00186500
C                                                                       00186600
         DO 700 I=1,NLOC                                                00186700
            IF (BUF(I,JENT).NE.ZMISS) GO TO 730                         00186800
 700     CONTINUE                                                       00186900
C                                                                       00187000
         IF (MODEPR.EQ.1.AND.(JENT.GE.5.AND.JENT.LE.12.OR.JENT.EQ.2))   00187100
     $       GO TO 850                                                  00187200
         IF (JENT.GE.13) GO TO 715                                      00187300
C                                                                       00187400
         IF ((.NOT.ST1FLG.AND.(JENT.EQ.5.OR.JENT.EQ.6)) .OR.            00187500
     $       (.NOT.ST2FLG.AND.(JENT.EQ.7.OR.JENT.EQ.8)) .OR.            00187600
     $       (.NOT.ST3FLG.AND.(JENT.EQ.9.OR.JENT.EQ.10))) GO TO 850     00187700
         WRITE (IPR,710) JENT                                           00187800
 710     FORMAT ('0** M3110 ** ERROR DETECTED BY SUBROUTINE INTBUF:'/   00187900
     $    13X,'NO ENTRIES WERE INPUT TO FIELD',I3,' OF TABLE ',         00188000
     $        '(VIA 1GPAR AND 2GPAR CARDS)'/                            00188100
     $    13X,'UNABLE TO INTERPOLATE FOR MISSING VALUES')               00188200
         ICC = 100                                                      00188300
         ERRFL1 = .TRUE.                                                00188400
         GO TO 850                                                      00188500
C                                                                       00188600
 715     WRITE (IPR,720) JENT                                           00188700
 720     FORMAT ('0** M3120 ** ERROR DETECTED BY SUBROUTINE INTBUF:'/   00188800
     $    13X,'NO ENTRIES WERE INPUT TO FIELD',I3,' OF TABLE ',         00188900
     $        '(VIA 1SPAR CARDS)'/                                      00189000
     $    13X,'UNABLE TO INTERPOLATE FOR MISSING VALUES')               00189100
         ERRFL1 = .TRUE.                                                00189200
         ICC = 100                                                      00189300
         GO TO 850                                                      00189400
C                                                                       00189500
C     +------------------------------------------+                      00189600
C     |     FIRST "GOOD" VALUE IS NOT AT         |                      00189700
C     |     BEGINNING, SO WE MUST EXTRAPOLATE.   |                      00189800
C     |     REPLACE "MISSING" VALUES WITH        |                      00189900
C     |     FIRST "GOOD" VALUE.                  |                      00190000
C     +------------------------------------------+                      00190100
C                                                                       00190200
 730     I1 = I                                                         00190300
         K = I1 - 1                                                     00190400
         VAL = BUF(I1,JENT)                                             00190500
C                                                                       00190600
         DO 735 I=1,K                                                   00190700
            CALL BUFSTR (I,JENT,VAL)                                    00190800
 735     CONTINUE                                                       00190900
C                                                                       00191000
 740     IF (I1.GE.NLOC) GO TO 850                                      00191100
         IF (BUF(I1+1,JENT).EQ.ZMISS) GO TO 750                         00191200
         I1 = I1 + 1                                                    00191300
         GO TO 740                                                      00191400
C                                                                       00191500
 750     KNT = 0                                                        00191600
         J2 = I1 + 1                                                    00191700
C                                                                       00191800
         DO 760 I=J2,NLOC                                               00191900
            KNT = KNT + 1                                               00192000
            IF (BUF(I,JENT).NE.ZMISS) GO TO 790                         00192100
 760     CONTINUE                                                       00192200
C                                                                       00192300
         VAL = BUF(I1,JENT)                                             00192400
         IF (JENT.NE.1) GO TO 780                                       00192500
C                                                                       00192600
C     +------------------------------------------+                      00192700
C     |   REPLACE REMAINING "MISSING" VALUES     |                      00192800
C     |    INCREMENTING GROUP INDEX BY ONE.      |                      00192900
C     +------------------------------------------+                      00193000
C                                                                       00193100
         DO 770 I=J2,NLOC                                               00193200
            VAL = VAL + 1.                                              00193300
            CALL BUFSTR (I,JENT,VAL)                                    00193400
 770     CONTINUE                                                       00193500
C                                                                       00193600
         GO TO 850                                                      00193700
C                                                                       00193800
C     +------------------------------------------+                      00193900
C     |   REPLACE REMAINING "MISSING" VALUES     |                      00194000
C     |    WITH LAST "GOOD" VALUE.               |                      00194100
C     +------------------------------------------+                      00194200
C                                                                       00194300
 780     DO 785 I=J2,NLOC                                               00194400
            CALL BUFSTR (I,JENT,VAL)                                    00194500
 785     CONTINUE                                                       00194600
C                                                                       00194700
         GO TO 850                                                      00194800
C                                                                       00194900
 790     PREV = BUF(I1,JENT)                                            00195000
         IF (JENT.LT.13) GO TO 800                                      00195100
         ZINCR = 0.0                                                    00195200
         GO TO 830                                                      00195300
C                                                                       00195400
C     +------------------------------------------+                      00195500
C     |     INTERPOLATE FOR "MISSING" VALUES     |                      00195600
C     +------------------------------------------+                      00195700
C                                                                       00195800
 800     CONTINUE                                                       00195900
         ZINCR = (BUF(I,JENT) - PREV) / FLOAT(KNT)                      00196000
 830     I1 = I                                                         00196100
         I2 = I1 - 1                                                    00196200
         ZK = 0.0                                                       00196300
         IF (J2.GT.I2) GO TO 740                                        00196400
C                                                                       00196500
         DO 840 I=J2,I2                                                 00196600
            ZK = ZK + 1.                                                00196700
            CALL BUFSTR (I,JENT,PREV+ZINCR*ZK)                          00196800
 840     CONTINUE                                                       00196900
C                                                                       00197000
C     +------------------------------------------+                      00197100
C     |     GO LOOK FOR ANOTHER GROUP            |                      00197200
C     |     OF "MISSING" VALUES IN THIS FIELD    |                      00197300
C     +------------------------------------------+                      00197400
C                                                                       00197500
         GO TO 740                                                      00197600
C                                                                       00197700
C     +------------------------------------------+                      00197800
C     |     INTERPOLATION FOR THIS FIELD IS      |                      00197900
C     |     COMPLETE - LOOP TO NEXT FIELD        |                      00198000
C     +------------------------------------------+                      00198100
C                                                                       00198200
 850  CONTINUE                                                          00198300
C                                                                       00198400
      IF (ERRFL1 .AND. .NOT.ERRFL2) WRITE (IPR,860)                     00198500
 860  FORMAT ('0',10X,'TABLE ENTRIES ARE:'/                             00198600
     $         13X,'1 = GROUP INDEX'/                                   00198700
     $         13X,'2 = ELEVATION'/                                     00198800
     $         13X,'3 = X COORDINATE'/                                  00198900
     $         13X,'4 = Y COORDINATE'/                                  00199000
     $         13X,'5 = THICKNESS LAYER 1'/                             00199100
     $         13X,'6 = VELOCITY LAYER 1'/                              00199200
     $         13X,'7 = THICKNESS LAYER 2'/                             00199300
     $         13X,'8 = VELOCITY LAYER 2'/                              00199400
     $         13X,'9 = THICKNESS LAYER 3'/                             00199500
     $         12X,'10 = VELOCITY LAYER 3'/                             00199600
     $         12X,'11 = REGIONAL REFERENCE SURFACE ELEVATION'/         00199700
     $         12X,'12 = REGIONAL REFERENCE REPLACEMENT VELOCITY'/      00199800
     $         12X,'13 = UPHOLE TIME'/                                  00199900
     $         12X,'14 = SHOT DEPTH')                                   00200000
C                                                                       00200100
      RETURN                                                            00200200
      END                                                               00200300
C  ROUTINE:       BUFSTR                                                00200400
C  ROUTINE TYPE:  SUBROUTINE                                            00200500
C  PURPOSE:  STORES AN ELEMENT INTO ARRAY BUFF                          00200600
C  AUTHOR:  DOUGLAS BODDY                                               00200700
C  DATE WRITTEN:  OCTOBER 1985                                          00200800
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00200900
C                                                                       00201000
      SUBROUTINE BUFSTR (IVAL1,IVAL2,VALUE)                             00201100
C                                                                       00201200
      DOUBLE PRECISION RAD                                              00201300
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	real xbuff(1)
	pointer(kbuff,xbuff)
	character*4 card, TDIS, SPAR
C                                                                       00201500
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00202100
C=======================================================================00202200
C=======================================================================00203500
	kbuff = indxbf
c.c.c.c      XBUFF ((IVAL2 - 1) * NLOC + IVAL1 + 1)  = VALUE
      XBUFF ((IVAL2 - 1) * NLOC + IVAL1)  = VALUE
cmam  BUFF ((IVAL2 - 1) * NLOC + IVAL1 + INDXBF) = VALUE                00203600
      RETURN                                                            00203700
      END                                                               00203800
C  ROUTINE:       BUF                                                   00203900
C  ROUTINE TYPE:  FUNCTION                                              00204000
C  PURPOSE:  RETRIEVES AN ELEMENT FROM ARRAY BUFF                       00204100
C  AUTHOR:  DOUGLAS BODDY                                               00204200
C  DATE WRITTEN:  OCTOBER 1985                                          00204300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00204400
C                                                                       00204500
      FUNCTION BUF (IVAL1,IVAL2)                                        00204600
C                                                                       00204700
      DOUBLE PRECISION RAD                                              00204800
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	real xbuff(1)
	pointer (kbuff,xbuff)
	character*4 card, TDIS, SPAR

C                                                                       00205000
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00205600
C=======================================================================00205700
	kbuff = indxbf
c.c.c.c.      BUF = XBUFF ((IVAL2 - 1) * NLOC + IVAL1 + 1)
	BUF = XBUFF ((IVAL2 - 1) * NLOC + IVAL1)
cmam  BUF = BUFF ((IVAL2 - 1) * NLOC + IVAL1 + INDXBF)                  00207000
      RETURN                                                            00207100
      END                                                               00207200
C  ROUTINE:       PASS1                                                 00207300
C  ROUTINE TYPE:  SUBROUTINE                                            00207400
C  PURPOSE:  CHECKS ON 1SPAR & 8TDIS CARDS, STORE ON DISK               00207500
C  AUTHOR:  DOUGLAS BODDY                                               00207600
C  DATE WRITTEN:  AUGUST 1985                                           00207700
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00207800
C                                                                       00207900
      SUBROUTINE PASS1 (CARDFH,SHTMOV,NMCRD,IDCRD,ICR,ICGRP,IWCOD,      00208000
     $                  ZDIST,KTR,IFHCRD,NSPN,                          00208100
     $                  MODEPR,SPINC,UPHTIM,ZLOC1,SPLTFL)               00208200
C                                                                       00208300
      DOUBLE PRECISION RAD                                              00208400
C                                                                       00208500
      character*4 CARDFH(20)
cmam  DIMENSION CARDFH(20)                                              00208600
      DIMENSION ZDIST(7)                                                00208700
cmam  INTEGER   ERRMES(10)/' ** ','ERRO','R DE','TECT','ED B','Y SU',   00208800
      character*4 ERRMES(10)
C                                                                       00209000
      character*4 INOMCD(4)
cmam  INTEGER   INOMCD(4)/'GROM','GRIN','TROM','TRIN'/                  00209100
C                                                                       00209200
cmam  INTEGER   SPAR,TDIS                                               00209300
cmam  INTEGER   FLDH/'FLDH'/                                            00209400
      character*4 SPAR,TDIS,FLDH,ibl4,idcrd,iholch
	character*3 itimch
	character*1 ispna
C                                                                       00209500
      INTEGER*2 KTR(7),IBSCOR,NMCRD                                     00209600
      INTEGER*2 MODEPR
cmam  INTEGER*2 ISPNA,MODEPR                                            00209700
C                                                                       00209800
      LOGICAL SPLTFL
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL INOMFG
	character*80 kard
	character*4 card
C                                                                       00210200
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00210800
	equivalence (card(1),kard)
      data INOMFG/.FALSE./
      data ERRMES/' ** ','ERRO','R DE','TECT','ED B','Y SU',
     $                     'BROU','TINE',' PAS','S1: '/                 00208900
C                                                                       00209000
      data INOMCD/'GROM','GRIN','TROM','TRIN'/
      data FLDH/'FLDH'/
      DATA IBL4/'    '/                                                 00210900
      DATA DEPHOL/0.0/                                                  00211000
      DATA NZERO/0/,LZERO/0/                                            00211100
      DATA LASTRI/-99999/                                               00211200
C                                                                       00211300
      IFHCRD = 0                                                        00211400
      CALL WRCARD (CARD,1,IPR)                                          00211500
      IWCOD = 3                                                         00211600
      NCARD = 0                                                         00211700
C                                                                       00211800
C     +------------------------------------------+                      00211900
C     |   CHECK FOR MISSING 1GPAR CARDS          |                      00212000
C     +------------------------------------------+                      00212100
C                                                                       00212200
      IF (ICGRP .NE. 0) GO TO 200                                       00212300
      WRITE (IPR,100) ERRMES                                            00212400
 100  FORMAT ('0** M4010 **',10A4/                                      00212500
     $ 13X,'"1GPAR" CARDS MUST BE INPUT PRIOR TO ',                     00212600
     $     'ANY "SPAR" OR "TDIS" CARDS')                                00212700
      ICC = 100                                                         00212800
      IWCOD = 1                                                         00212900
C                                                                       00213000
 200  ICGRP = 0                                                         00213100
      IF (NMCRD .NE. 8 .OR. IDCRD .NE. TDIS) GO TO 300                  00213200
      WRITE (IPR,220) ERRMES                                            00213300
 220  FORMAT ('0** M4020 **',10A4/                                      00213400
     $ 13X,'A "1SPAR" CARD MUST BE INPUT BEFORE THE "8TDIS" CARD')      00213500
      ICC = 100                                                         00213600
      IWCOD = 1                                                         00213700
      GO TO 300                                                         00213800
C                                                                       00213900
C     +------------------------------------------+                      00214000
C     |        READ 1SPAR OR 8TDIS CARD          |                      00214100
C     +------------------------------------------+                      00214200
C                                                                       00214300
 250  READ (ICR,260,END=3000) CARD,NMCRD,IDCRD,JOBNO                    00214400
 260  FORMAT (20A4,T1,I1,A4,T69,A7)                                     00214500
      IF (NMCRD .EQ. 1 .AND. IDCRD .EQ. FLDH) GO TO 390                 00214600
      CALL WRCARD (CARD,IWCOD,IPR)                                      00214700
      IWCOD = 3                                                         00214800
C                                                                       00214900
      IF (NMCRD.NE.1) GO TO 320                                         00215000
C                                                                       00215100
 300  IF (NMCRD .EQ. 1 .AND. IDCRD .EQ. SPAR) GO TO 400                 00215200
C                                                                       00215300
      DO 310 I=1,4                                                      00215400
         II = I                                                         00215500
         IF (IDCRD.EQ.INOMCD(I)) GO TO 360                              00215600
 310  CONTINUE                                                          00215700
C                                                                       00215800
 320  IF (NMCRD .EQ. 8 .AND. IDCRD .EQ. TDIS) GO TO 1250                00215900
      WRITE (IPR,350) ERRMES                                            00216000
 350  FORMAT ('0** M4030',10A4/                                         00216100
     $ 13X,'EXPECTED CARD TO BE ONE OF THE FOLLOWING TYPES:'/           00216200
     $ 13X,'"1SPAR", "8TDIS",'/                                         00216300
     $ 13X,'"1GROM", "1GRIN", "1TROM", "1TRIN",'/                       00216400
     $ 13X,'"1FLDH"')                                                   00216500
      ICC = 100                                                         00216600
      IWCOD = 1                                                         00216700
      GO TO 250                                                         00216800
C                                                                       00216900
 360  IF (MODEPR.NE.2) GO TO 380                                        00217000
      IF (INOMFG) GO TO 250                                             00217100
      INOMFG = .TRUE.                                                   00217200
      WRITE (IPR,370)                                                   00217300
 370  FORMAT ('0** M4035 ** WARNING FROM SUBROUTINE PASS1:'/            00217400
     $ 13X,'"1GROM", "1GRIN", "1TROM", "1TRIN" CARDS WILL NOT BE USED ',00217500
     $     'SINCE WE ARE DOING "STATICS ONLY"')                         00217600
      GO TO 250                                                         00217700
C                                                                       00217800
 380  CALL INOMCK (II)                                                  00217900
      GO TO 250                                                         00218000
C                                                                       00218100
 390  IFHCRD = 1                                                        00218200
      CALL MOVE (1,CARDFH,CARD,80)                                      00218300
      GO TO 3000                                                        00218400
C                                                                       00218500
C     +------------------------------------------+                      00218600
C     |            DECODE 1SPAR CARD             |                      00218700
C     +------------------------------------------+                      00218800
C                                                                       00218900
 400  NZERO = 0                                                         00219000
      LZERO = 0                                                         00219100
      NCARD = NCARD + 1                                                 00219200
      XLOCSA = XLCTRA                                                   00219300
      XLOCSB = XLCTRB                                                   00219400
      LOCSC = LTBG                                                      00219500
      XLOCSD = XLLTBG                                                   00219600
      LOCSE = IFTAG                                                     00219700
      XLOCSF = XLFTAG                                                   00219800
      LRIS = LRI                                                        00219900
C=======================================================================00220000
cmam  CALL STRING (CARD,80)                                             00220600
cmam  READ (99,450)     ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,  00220700
      READ (kard,450)   ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,
     $                  OFFDIS,OFFANG,ISPNN,ISPNA,                      00220800
     $                  HOLDEP,UPTIME,UPHOFF,IBSCOR,LRI,IHOLCH,ITIMCH   00220900
C=======================================================================00221000
C=======================================================================00221100
 450  FORMAT           (5X,F6.0,2I5,I4,I5,I4,I5,                        00221200
     $                  F5.0,F4.0,I5,A1,                                00221300
     $                  F4.0,F3.0,F3.0,I4,7X,I5,T55,A4,A3)              00221400
      WRITE (IDSK1,500) CARD                                            00221500
 500  FORMAT (20A4)                                                     00221600
C                                                                       00221700
      IF (NCARD.NE.1) GO TO 520                                         00221800
C                                                                       00221900
C     +------------------------------------------+                      00222000
C     |       CHECKS ON FIRST CARD ONLY          |                      00222100
C     +------------------------------------------+                      00222200
C                                                                       00222300
      XLCTRA = LOCTRA                                                   00222400
      XLCTRB = LOCTRB                                                   00222500
      XLLTBG = LCLTBG                                                   00222600
      XLFTAG = LCFTAG                                                   00222700
      IF ( ISPNN .GE. 0 ) GO TO 505                                     00222800
         WRITE(IPR,504) ERRMES, ISPNN                                   00222900
 504     FORMAT ('0**M4037',10A4/                                       00223000
     $           13X,'SHOT POINT NUMBER IN CC 49-53 OF 1SPAR CARD,'/    00223100
     $           13X,I6,'  MUST BE GREATER THAN ZERO.  CORRECT',/       00223200
     $           13X,'PARAMETER AND RESUBMIT.',/)                       00223300
      ICC = 100                                                         00223400
      IWCOD = 1                                                         00223500
C                                                                       00223600
 505  IF (ISPNN.EQ.0) ISPNN = 1                                         00223700
      NSPN = ISPNN                                                      00223800
      ZLOC1 = ZLSLOC                                                    00223900
      IF (LTBG.EQ.0.AND.LCLTBG.EQ.0.AND.IFTAG.EQ.0.AND.LCFTAG.EQ.0)     00224000
     $     GO TO 580                                                    00224100
      SPLTFL = .TRUE.                                                   00224200
      IF (LTBG.GT.0.AND.LCLTBG.GT.0.AND.IFTAG.GT.0.AND.LCFTAG.GT.0)     00224300
     $     GO TO 580                                                    00224400
      WRITE (IPR,510) ERRMES                                            00224500
 510  FORMAT ('0** M4040',10A4/                                         00224600
     $ 13X,'SPLIT-SPREAD INFORMATION MUST BE EITHER'/                   00224700
     $ 13X,'  1) ALL BLANK OR ZERO   OR  2) ALL GREATER THAN ZERO')     00224800
      ICC = 100                                                         00224900
      IWCOD = 1                                                         00225000
C                                                                       00225100
      GO TO 580                                                         00225200
C                                                                       00225300
C     +------------------------------------------+                      00225400
C     |       CHECKS ON ALL BUT FIRST CARD       |                      00225500
C     +------------------------------------------+                      00225600
C                                                                       00225700
 520  ZIII = FLOAT(LRI - LRIS) * SHTMOV                                 00225800
      IF (LOCTRA.NE.0.OR.LOCTRB.NE.0) GO TO 522                         00225900
      XLCTRA = XLOCSA + ZIII                                            00226000
      XLCTRB = XLOCSB + ZIII                                            00226100
      LOCTRA = XLCTRA                                                   00226200
      LOCTRB = XLCTRB                                                   00226300
      GO TO 524                                                         00226400
C                                                                       00226500
 522  XLCTRA = LOCTRA                                                   00226600
      XLCTRB = LOCTRB                                                   00226700
C                                                                       00226800
 524  IF (LTBG.NE.0.OR.LCLTBG.NE.0.OR.IFTAG.NE.0.OR.LCFTAG.NE.0)        00226900
     $    GO TO 526                                                     00227000
      LTBG = LOCSC                                                      00227100
      XLLTBG = XLOCSD                                                   00227200
      LCLTBG = XLLTBG                                                   00227300
      IFTAG = LOCSE                                                     00227400
      XLFTAG = XLOCSF                                                   00227500
      LCFTAG = XLFTAG                                                   00227600
      GO TO 528                                                         00227700
C                                                                       00227800
 526  XLLTBG = LCLTBG                                                   00227900
      XLFTAG = LCFTAG                                                   00228000
C                                                                       00228100
 528  IF (LRI.NE.0) GO TO 535                                           00228200
      WRITE (IPR,530) ERRMES                                            00228300
 530  FORMAT ('0** M4050',10A4/                                         00228400
     $ 13X,'RECORD INDEX ON "1SPAR" CARD IS BLANK OR ZERO'/             00228500
     $ 13X,'THIS IS ONLY ALLOWED ON THE FIRST "1SPAR" CARD')            00228600
      ICC = 100                                                         00228700
      IWCOD = 1                                                         00228800
C                                                                       00228900
 535  IF (ISPNN .GE. 0 ) GO TO 540                                      00229000
      WRITE (IPR,537) ERRMES, NCARD, ISPNN                              00229100
 537  FORMAT ('0** M4055',10A4/                                         00229200
     $ 13X,'SHOT POINT NUMBER IN CC 49-53 OF ',I1,'  1SPAR CARD',/      00229300
     $ 13X,',',I6,' ,MUST BE GREATER THAN ZERO.  CORRECT AND',/         00229400
     $ 13X,'RESUBMIT.',/)                                               00229500
      ICC = 100                                                         00229600
      IWCOD = 1                                                         00229700
 540  IF (SPLTFL) GO TO 545                                             00229800
      IF (LTBG.EQ.0.AND.LCLTBG.EQ.0.AND.IFTAG.EQ.0.AND.LCFTAG.EQ.0)     00229900
     $    GO TO 560                                                     00230000
      GO TO 546                                                         00230100
C                                                                       00230200
 545  IF (LTBG.GT.0.AND.LCLTBG.GT.0.AND.IFTAG.GT.0.AND.LCFTAG.GT.0)     00230300
     $    GO TO 560                                                     00230400
 546  WRITE (IPR,550) ERRMES                                            00230500
 550  FORMAT ('0** M4060',10A4/                                         00230600
     $ 13X,'SPLIT-SPREAD INFORMATION MUST BE EITHER'/                   00230700
     $ 15X,  '1) ALL BLANK OR ZERO IF THEY WERE ALL BLANK OR ZERO ON ', 00230800
     $     'THE FIRST 1SPAR CARD'/                                      00230900
     $ 15X,  '2) ALL GREATER THAN ZERO OR  ALL BLANK OR ZERO IF THEY'/  00231000
     $ 18X,  'WERE ALL NON-ZERO AND NON-BLANK ON THE FIRST 1SPAR CARD') 00231100
      ICC = 100                                                         00231200
      IWCOD = 1                                                         00231300
C                                                                       00231400
 560  IF (LRI.GT.LASTRI) GO TO 580                                      00231500
      WRITE (IPR,570) ERRMES                                            00231600
 570  FORMAT ('0** M4070',10A4/                                         00231700
     $ 13X,'RECORD INDEX ON "1SPAR" CARD IS NOT GREATER THAN THE ',     00231800
     $     'RECORD INDEX ON PREVIOUS "1SPAR" CARD')                     00231900
      ICC = 100                                                         00232000
      IWCOD = 1                                                         00232100
C                                                                       00232200
C     +------------------------------------------+                      00232300
C     |          CHECKS ON ALL CARDS             |                      00232400
C     +------------------------------------------+                      00232500
C                                                                       00232600
 580  IF (MODEPR.EQ.2) GO TO 800                                        00232700
      IF (.NOT.SPLTFL) GO TO 600                                        00232800
      LOCCAL = LOCTRA + LTBG - LCLTBG - IFTAG + LCFTAG + NTPR - 1       00232900
      IF (LOCTRB.EQ.LOCCAL) GO TO 640                                   00233000
      WRITE (IPR,590) ERRMES,NTPR                                       00233100
 590  FORMAT ('0** M4080',10A4/                                         00233200
     $ 13X,'NUMBER OF TRACES AS DETERMINED FROM'/                       00233300
     $ 13X,'END-OF-SPREAD LOCATIONS  AND  SPLIT-SPREAD LOCATIONS'/      00233400
     $ 13X,'DOES NOT CORRESPOND TO THE NUMBER OF TRACES REQUESTED (',   00233500
     $      I5,')')                                                     00233600
      ICC = 100                                                         00233700
      IWCOD = 1                                                         00233800
      GO TO 640                                                         00233900
C                                                                       00234000
 600  IF ((LOCTRB-LOCTRA+1) .EQ. NTPR) GO TO 640                        00234100
      WRITE (IPR,610) ERRMES                                            00234200
 610  FORMAT ('0** M4090',10A4/                                         00234300
     $ 13X,'RANGE FROM LOCATION TRACE "1" TO LOCATION TRACE "N"'/       00234400
     $ 13X,'MUST BE EQUAL TO THE NUMBER OF TRACES PER RECORD ',         00234500
     $     'FOR OFF-END SHOOTING')                                      00234600
      ICC = 100                                                         00234700
      IWCOD = 1                                                         00234800
C                                                                       00234900
 640  IF (LOCTRA.GE.IGNDXS) GO TO 800                                   00235000
      WRITE (IPR,650) ERRMES                                            00235100
 650  FORMAT ('0** M4100',10A4/                                         00235200
     $ 13X,'LOCATION TRACE "1" ON "1SPAR" CARD MUST BE'/                00235300
     $ 13X,'GREATER THAN OR EQUAL TO GROUP INDEX ON FIRST "1GPAR" CARD')00235400
      ICC = 100                                                         00235500
      IWCOD = 1                                                         00235600
C                                                                       00235700
 800  IF (ZLSLOC.GE.IGNDXS) GO TO 900                                   00235800
      WRITE (IPR,880) ERRMES                                            00235900
 880  FORMAT ('0** M4110',10A4/                                         00236000
     $ 13X,'SOURCE LOCATION ON "1SPAR" CARD MUST BE'/                   00236100
     $ 13X,'GREATER THAN OR EQUAL TO GROUP INDEX ON FIRST "1GPAR" CARD')00236200
      ICC = 100                                                         00236300
      IWCOD = 1                                                         00236400
C                                                                       00236500
 900  IF (OFFANG.GE.-180. .AND. OFFANG.LE.180) GO TO 920                00236600
      WRITE (IPR,910) ERRMES                                            00236700
 910  FORMAT ('0** M4120',10A4/                                         00236800
     $ 13X,'OFFSET ANGLE MUST BE BETWEEN -180 AND 180 DEGREES')         00236900
      ICC = 100                                                         00237000
      IWCOD = 1                                                         00237100
C                                                                       00237200
 920  IF (OFFDIS.GE.0.0) GO TO 1200                                     00237300
      WRITE (IPR,930) ERRMES                                            00237400
 930  FORMAT ('0** M4130',10A4/                                         00237500
     $ 13X,'OFFSET DISTANCE CANNOT BE NEGATIVE')                        00237600
      ICC = 100                                                         00237700
      IWCOD = 1                                                         00237800
C                                                                       00237900
 1200 IF (ICC.NE.0) GO TO 1220                                          00238000
      IF (IHOLCH.NE.IBL4) DEPHOL = HOLDEP                               00238100
      IF (ITIMCH.NE.IBL4) UPHTIM = UPTIME                               00238200
cmam....do not know why this default was set to 10, so as of 7-7-94
cmam..... the default is zero.  this allows the uphole time input to
cmam..... be what is put in the trace header (request of mike o'brien)
cmam  IF (UPHOFF.EQ.0.0) UPHOFF = 10.                                   00238300
      LASTRI = LRI                                                      00238400
C                                                                       00238500
C     +------------------------------------------+                      00238600
C     |      CALCULATE TIME TO THE VERTICAL      |                      00238700
C     |        (TO ACCOUNT FOR AN OFFSET)        |                      00238800
C     +------------------------------------------+                      00238900
C                                                                       00239000
      IF (UPHTIM.NE.0.0) GO TO 1205                                     00239100
      TIM = 0.0                                                         00239200
      GO TO 1210                                                        00239300
C                                                                       00239400
 1205 if(dephol.eq.0.0) then
	tim = uphtim
      else
c1205 TIM = SNGL(DBLE(DEPHOL) /                                         00239500
      TIM = SNGL(DBLE(DEPHOL) /                                         00239500
     $    (DSQRT(DBLE(DEPHOL) ** 2 + DBLE(UPHOFF) ** 2) / DBLE(UPHTIM)))00239600
      endif
C                                                                       00239700
C                                                                       00239800
C     **********************************                                00239900
C     | RESET SRCLOC TO REFLECT OFFDIS |                                00240000
C     **********************************                                00240100
C                                                                       00240200
 1210 IF ( OFFDIS .EQ. 0 ) GO TO 1215                                   00240300
      X = DBLE(OFFANG) * RAD                                            00240400
      XDIS =  COS(X) * OFFDIS                                           00240500
      IXDIS = XDIS + SIGN(0.5,XDIS)                                     00240600
      XDGR = FLOAT(IXDIS) / XGRINT                                      00240700
      ZLSLOC = ZLSLOC + XDGR                                            00240800
C                                                                       00240900
 1215 CALL UPDAT3 (ZLSLOC,TIM,DEPHOL)                                   00241000
C                                                                       00241100
 1220 ICGRP = 6                                                         00241200
      GO TO 250                                                         00241300
C                                                                       00241400
C     +------------------------------------------+                      00241500
C     |            DECODE 8TDIS CARD             |                      00241600
C     +------------------------------------------+                      00241700
C                                                                       00241800
 1250 CONTINUE                                                          00241900
C=======================================================================00242000
cmam  CALL STRING (CARD,80)                                             00242400
cmam  READ (99,1300)     (KTR(I),ZDIST(I),I=1,7),KRI                    00242500
      READ (kard,1300)     (KTR(I),ZDIST(I),I=1,7),KRI
C=======================================================================00242600
C=======================================================================00242700
 1300 FORMAT (5X,7(I4,F5.0),7X,I5)                                      00242800
      WRITE (IDSK1,500) CARD                                            00242900
C                                                                       00243000
      IF (KRI.EQ.0 .OR. KRI.EQ.LRI) GO TO 1400                          00243100
      WRITE (IPR,1350) ERRMES                                           00243200
 1350 FORMAT ('0** M4140',10A4/                                         00243300
     $ 13X,'RECORD INDEX ON "8TDIS" CARD DOES NOT MATCH RECORD INDEX ', 00243400
     $     'ON "1SPAR" CARD'/                                           00243500
     $ 13X,'ALL "8TDIS" CARDS MUST HAVE A CORRESPONDING "1SPAR" CARD ', 00243600
     $     'WITH THE SAME RECORD INDEX')                                00243700
      ICC = 100                                                         00243800
      IWCOD = 1                                                         00243900
C                                                                       00244000
 1400 IF (NZERO.EQ.0) GO TO 1500                                        00244100
      IF (LZERO.NE.7) GO TO 1500                                        00244200
      IF (KTR(1).NE.0 .OR. ZDIST(1).NE.0.0) GO TO 1500                  00244300
      WRITE (IPR,1450) ERRMES                                           00244400
 1450 FORMAT ('0** M4150',10A4/                                         00244500
     $ 13X,'TRACE/DISTANCE PAIR #7 ON PREVIOUS CARD HAS VALUES ',       00244600
     $     'OF BLANK OR ZERO'/                                          00244700
     $ 13X,'THIS IS ONLY ALLOWED IF NO MORE PAIRS ARE ',                00244800
     $     'TO BE INPUT FOR THIS GROUP'/                                00244900
     $ 13X,'HOWEVER, THE FIRST PAIR ON THIS CARD HAS NON-ZERO ',        00245000
     $     'AND NON-BLANK ENTRIES')                                     00245100
      ICC = 100                                                         00245200
      IWCOD = 1                                                         00245300
      NZERO = 0                                                         00245400
      LZERO = 0                                                         00245500
C                                                                       00245600
 1500 DO 2000 I=1,7                                                     00245700
         IF (KTR(I).GT.0) GO TO 1650                                    00245800
         IF (KTR(I).NE.0 .OR. ZDIST(I).NE.0.0) GO TO 1550               00245900
         NZERO = NZERO + 1                                              00246000
         LZERO = I                                                      00246100
         GO TO 2000                                                     00246200
C                                                                       00246300
 1550    WRITE (IPR,1600) ERRMES,I                                      00246400
 1600    FORMAT ('0** M4160',10A4/                                      00246500
     $    13X,'TRACE NUMBER - ENTRY',I5,' IS NOT GREATER THAN ZERO')    00246600
         ICC = 100                                                      00246700
         IWCOD = 1                                                      00246800
         GO TO 2000                                                     00246900
C                                                                       00247000
 1650    IF (ZDIST(I).NE.0.0) GO TO 1750                                00247100
         WRITE (IPR,1700) ERRMES,KTR(I)                                 00247200
 1700    FORMAT ('0** M4170',10A4/                                      00247300
     $    13X,'DISTANCE FOR TRACE NUMBER',I6,' IS BLANK OR ZERO')       00247400
         ICC = 100                                                      00247500
         IWCOD = 1                                                      00247600
         GO TO 1850                                                     00247700
C                                                                       00247800
 1750    IF (I.EQ.1) GO TO 1850                                         00247900
         IF (ZDIST(I-1).NE.0.0 .OR. KTR(I-1).NE.0) GO TO 1850           00248000
         IM1 = I - 1                                                    00248100
         WRITE (IPR,1800) ERRMES,IM1                                    00248200
 1800    FORMAT ('0** M4180',10A4/                                      00248300
     $    13X,'TRACE/DISTANCE PAIR #',I1,' HAS VALUES OF ',             00248400
     $     'BLANK OR ZERO'/                                             00248500
     $    13X,'THE ONLY TIME THIS IS VALID IS IF NO MORE PAIRS ARE ',   00248600
     $        'TO BE INPUT FOR THIS GROUP')                             00248700
         ICC = 100                                                      00248800
         IWCOD = 1                                                      00248900
C                                                                       00249000
 1850    IF (KTR(I).LE.NTPR) GO TO 2000                                 00249100
         WRITE (IPR,1900) ERRMES                                        00249200
 1900    FORMAT ('0** M4190',10A4/                                      00249300
     $    13X,'TRACE NUMBER ON "8TDIS" CARD EXCEEDS NUMBER OF TRACES ', 00249400
     $        'PER RECORD SPECIFIED ON "1LAIP" CARD')                   00249500
         ICC = 100                                                      00249600
         IWCOD = 1                                                      00249700
C                                                                       00249800
 2000 CONTINUE                                                          00249900
C                                                                       00250000
      ICGRP = 8                                                         00250100
      GO TO 250                                                         00250200
C                                                                       00250300
 3000 RETURN                                                            00250400
      END                                                               00250500
C  ROUTINE:       INOMCK                                                00250600
C  ROUTINE TYPE:  SUBROUTINE                                            00250700
C  PURPOSE:  VALIDATE INVERT/OMIT CARDS AND WRITE TO DISK               00250800
C  AUTHOR:  DOUGLAS BODDY                                               00250900
C  DATE WRITTEN:  AUGUST 1985                                           00251000
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00251100
C                                                                       00251200
      SUBROUTINE INOMCK (ICTYP)                                         00251300
C                                                                       00251400
      DOUBLE PRECISION RAD                                              00251500
C                                                                       00251600
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
cmam  LOGICAL*1 ST1FLG,ST2FLG,ST3FLG,DISK                               00251700
C                                                                       00251800
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
	character*80 kard
	character*4 card, TDIS, SPAR
	equivalence (card(1),kard)
C                                                                       00252400
C=======================================================================00252500
cmam  CALL STRING (CARD,80)                                             00252900
cmam  READ (99,10)     (INOM(I),I=1,12)                                 00253000
      READ (kard,10)     (INOM(I),I=1,12)
C=======================================================================00253100
C=======================================================================00253200
 10   FORMAT           (5X,12I5)                                        00253300
      IFUN = INOMUN + ICTYP - 1                                         00253400
C                                                                       00253500
      DO 100 I=1,12,4                                                   00253600
         IF (INOM(I).EQ.0) INOM(I) = INOM(I+1)                          00253700
         IF (INOM(I+1).NE.0) GO TO 20                                   00253800
         IF (INOM(I).EQ.0) GO TO 40                                     00253900
         INOM(I+1) = INOM(I)                                            00254000
 20      IF (INOM(I+3).EQ.0) INOM(I+3) = INOM(I+2)                      00254100
         IF (INOM(I+2).EQ.0) INOM(I+2) = INOM(I+3)                      00254200
         IF (INOM(I).LE.INOM(I+1).AND.INOM(I+2).LE.INOM(I+3)) GO TO 90  00254300
         WRITE (IPR,30)                                                 00254400
 30      FORMAT ('0** M4210 ** ERROR DETECTED BY SUBROUTINE INOMCK'/    00254500
     $13X,'"1GROM", "1GRIN", "1TROM", OR "1TRIN" CARD CONTAINS ENTRY'/  00254600
     $13X,'WITH AN ENDING G.I. OR TRACE LESS THAN STARTING GI OR TRACE'/00254700
     $13X,'OR AN ENDING R.I. LESS THAN STARTING R.I.')                  00254800
         ICC = 100                                                      00254900
         GO TO 100                                                      00255000
C                                                                       00255100
 40      IF (INOM(I+2).EQ.0 .AND. INOM(I+3).EQ.0) GO TO 100             00255200
         WRITE (IPR,50)                                                 00255300
 50      FORMAT ('0** M4220 ** ERROR DETECTED BY SUBROUTINE INOMCK'/    00255400
     $13X,'"1GROM", "1GRIN", "1TROM", OR "1TRIN" CARD CONTAINS ENTRY'/  00255500
     $    13X,'WITH R.I. INFORMATION BUT NO G.I. OR TRACE INFORMATION') 00255600
         ICC = 100                                                      00255700
         GO TO 100                                                      00255800
C                                                                       00255900
c...........open the unit before writing to it...........
 90	if(inomct(ictyp).eq.0) then
      	  open (unit = ifun, form = 'unformatted',
     $      status = 'scratch', access = 'sequential')
	endif
         INOMCT(ICTYP) = INOMCT(ICTYP) + 1                              00256000
c90      INOMCT(ICTYP) = INOMCT(ICTYP) + 1                              00256000
         WRITE (IFUN) INOM(I),INOM(I+1),INOM(I+2),INOM(I+3)             00256100
 100  CONTINUE                                                          00256200
C                                                                       00256300
      RETURN                                                            00256400
      END                                                               00256500
C  ROUTINE:       PASS2                                                 00256600
C  ROUTINE TYPE:  SUBROUTINE                                            00256700
C  PURPOSE:  SECOND PASS OF CARDS TO CALCULATE STATICS.                 00256800
C  AUTHOR:  DOUGLAS BODDY                                               00256900
C  DATE WRITTEN:  AUGUST 1985                                           00257000
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00257100
C                                                                       00257200
      SUBROUTINE PASS2 (SHTMOV,SPINC,                                   00257300
     $                  MODEPR,SPLTFL)                                  00257400
C                                                                       00257500
      DOUBLE PRECISION RAD                                              00257600
C                                                                       00257700
      character*4 SPAR,TDIS, idcrd,iholch
cmam  INTEGER   SPAR,TDIS                                               00257800
C                                                                       00257900
      INTEGER*2 IBSCOR,MODEPR
cmam  INTEGER*2 IBSCOR,MODEPR,ISPNA                                     00258000
C                                                                       00258100
      LOGICAL SPLTFL
      LOGICAL EOF
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
C                                                                       00258500
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00259100
	character*4 ibl4, card
	character*80 kard
	equivalence (card(1),kard)
      DATA DEPHOL/0.0/                                                  00259200
      DATA IBL4/'    '/                                                 00259300
      DATA NCARD/0/                                                     00259400
      DATA LRI/0/                                                       00259500
      data EOF/.FALSE./
C                                                                       00259600
      REWIND IDSK1                                                      00259700
C                                                                       00259800
 10   READ (IDSK1,20,END=80) CARD,IDCRD                                 00259900
 20   FORMAT (20A4,T1,1X,A4)                                            00260000
      IF (IDCRD.NE.SPAR) GO TO 10                                       00260100
C                                                                       00260200
 30   NCARD = NCARD + 1                                                 00260300
      XLOCSA = XLCTRA                                                   00260400
      XLOCSB = XLCTRB                                                   00260500
      LOCSC = LTBG                                                      00260600
      XLOCSD = XLLTBG                                                   00260700
      LOCSE = IFTAG                                                     00260800
      XLOCSF = XLFTAG                                                   00260900
      LRIS = LRI                                                        00261000
C=======================================================================00261100
cmam  CALL STRING (CARD,80)                                             00261700
cmam  READ (99,40)      ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,  00261800
      READ (kard,40)    ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,
     $                  OFFDIS,OFFANG,ISPNN,ISPNA,                      00261900
     $                  HOLDEP,UPTIME,UPHOFF,IBSCOR,LRI,IHOLCH,ITIMCH   00262000
C=======================================================================00262100
C=======================================================================00262200
 40   FORMAT           (5X,F6.0,2I5,I4,I5,I4,I5,                        00262300
     $                  F5.0,F4.0,I5,A1,                                00262400
     $                  F4.0,F3.0,F3.0,I4,7X,I5,T55,A4,A3)              00262500
      IF (IHOLCH.NE.IBL4) DEPHOL = HOLDEP                               00262600
      SPNN = ISPNN                                                      00262700
      IF (NCARD.GT.1) GO TO 43                                          00262800
      IF ( SPNN .GE. 0.0 ) GO TO 42                                     00262900
         WRITE(IPR,41) ISPNN                                            00263000
  41     FORMAT ('0**M5100** ERROR DETECTED BY SUBROUTINE PASS2:'/      00263100
     $           13X,'SHOT POINT NUMBER IN CC 49-53 OF 1SPAR CARD',     00263200
     $           13X,I6,'MUST BE GREATER THAN ZERO.  CORRECT',          00263300
     $           13X,'PARAMETER AND RESUBMIT.',/)                       00263400
      ICC = 100                                                         00263500
C                                                                       00263600
  42  IF (SPNN.EQ.0.) SPNN = 1.                                         00263700
      XLCTRA = LOCTRA                                                   00263800
      XLCTRB = LOCTRB                                                   00263900
      XLLTBG = LCLTBG                                                   00264000
      XLFTAG = LCFTAG                                                   00264100
      GO TO 47                                                          00264200
C                                                                       00264300
 43   ZIII = FLOAT(LRI - LRIS) * SHTMOV                                 00264400
      IF (SPNN.EQ.0.) SPNN = ACTSPN + SPINC                             00264500
      IF (LOCTRA.NE.0.OR.LOCTRB.NE.0) GO TO 44                          00264600
      XLCTRA = XLOCSA + ZIII                                            00264700
      LOCTRA = XLCTRA                                                   00264800
      XLCTRB = XLOCSB + ZIII                                            00264900
      LOCTRB = XLCTRB                                                   00265000
      GO TO 45                                                          00265100
C                                                                       00265200
 44   XLCTRA = LOCTRA                                                   00265300
      XLCTRB = LOCTRB                                                   00265400
C                                                                       00265500
 45   IF (LTBG.NE.0.OR.LCLTBG.NE.0.OR.IFTAG.NE.0.OR.LCFTAG.NE.0)        00265600
     $    GO TO 46                                                      00265700
      LTBG = LOCSC                                                      00265800
      XLLTBG = XLOCSD                                                   00265900
      LCLTBG = XLLTBG                                                   00266000
      IFTAG = LOCSE                                                     00266100
      XLFTAG = XLOCSF                                                   00266200
      LCFTAG = XLFTAG                                                   00266300
      GO TO 47                                                          00266400
C                                                                       00266500
 46   XLLTBG = LCLTBG                                                   00266600
      XLFTAG = LCFTAG                                                   00266700
C                                                                       00266800
 47   READ (IDSK1,20,END=70) CARD,IDCRD                                 00266900
      IF (IDCRD.NE.SPAR) GO TO 47                                       00267000
C=======================================================================00267100
cmam  CALL STRING (CARD,80)                                             00267500
cmam  READ (99,50)      NEXTRI                                          00267600
      READ (kard,50)      NEXTRI
C=======================================================================00267700
C=======================================================================00267800
 50   FORMAT (75X,I5)                                                   00267900
C                                                                       00268000
 60   CALL UPDAT5  (ZLSLOC,XLCTRA,XLCTRB,DEPHOL,XLLTBG,XLFTAG,IBSCOR,   00268100
     $              OFFDIS,OFFANG,SHTMOV,                               00268200
     $              CORINI,CORREC,                                      00268300
     $              SPINC,LRI,NEXTRI,SPNN,ACTSPN,MODEPR,SPLTFL)         00268400
      IF (.NOT.EOF) GO TO 30                                            00268500
      GO TO 100                                                         00268600
C                                                                       00268700
 70   EOF = .TRUE.                                                      00268800
      GO TO 60                                                          00268900
C                                                                       00269000
 80   ICC = 100                                                         00269100
      WRITE (IPR,90)                                                    00269200
 90   FORMAT ('0** M5200 ** ERROR DETECTED BY SUBROUTINE PASS2:'/       00269300
     $ 13X,'END OF FILE ON INPUT CARD DISK FILE PRIOR TO READING ',     00269400
     $     'ANY "SPAR" CARDS')                                          00269500
      ICC = 100                                                         00269600
C                                                                       00269700
 100  RETURN                                                            00269800
      END                                                               00269900
C  ROUTINE:       INSHDR                                                00270000
C  ROUTINE TYPE:  SUBROUTINE                                            00270100
C  PURPOSE:  INSERT INFO INTO LINE HEADER.                              00270200
C  AUTHOR:  DOUGLAS BODDY                                               00270300
C  DATE WRITTEN:  AUGUST 1985                                           00270400
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00270500
C                                                                       00270600
      SUBROUTINE INSHDR (IEQUIP,CREW,DATTYP,DTS,                        00270700
     $                   IOAC,LINE,JOBNO1,NREC,ITYPE,IFOLD,NSPN,        00270800
     $                   NSANEW,METENG,SPINC,ZLOC1,MODEPR,DPI,          00270900
     $                   SHTMOV,IPLDIR,IFSP,IBFLAG,MOVFL1,LAIPF2)       00271000
C                                                                       00271100
#include <save_defs.h>
cmam  DOUBLE PRECISION CREW,JOBNO1                                      00271200
cmam  DOUBLE PRECISION BLANK8/'        '/                               00271300
	character*6 crew
	character*7 jobno1
	character*7 blank8
	character*4 nsanew, grpint
	character*1 ajob(8)
	character*2 achar
cmam	character*2 achar(2)
C                                                                       00271400
      DIMENSION LINHD4(1500)                                            00271500
C                                                                       00271600
      DOUBLE PRECISION RAD                                              00271700
C                                                                       00271800
cmam  INTEGER   BLKEBC/Z40404040/                                       00271900
	character*4 blkebc
C                                                                       00272000
      INTEGER*2 MODEPR,ITYPE
	integer ibflag,ibias,ihsp
cmam  INTEGER*2 IBFLAG,IBIAS,IHSP,MODEPR,ITYPE                          00272100
      INTEGER*2 IPLDIR,METENG,IFOLD
	character*2 dts
	character*1 dattyp,iequip
cmam	character*2 dattyp,iequip
cmam  INTEGER*2 IPLDIR,METENG,IFOLD,DTS,IEQUIP,DATTYP                   00272200
      INTEGER*2 LINHD2(3000)                                            00272300
cmam  INTEGER*2 SORT(3)/' 0',' 1',' 2'/                                 00272400
      character*2 SORT(3)
C=======================================================================00272500
C                                                                       00273100
      REAL * 4  RBUF (1500)                                             00273200
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL MOVFL1,LAIPF2
      character*1 LINHD1(6000)
cmam  LOGICAL LINHD1(6000)
	character*1 oaclin(8)
	character*4 card, TDIS, SPAR
C                                                                       00273600
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00274200
      EQUIVALENCE (LINHD4(1),LINHD2(1),LINHD1(1),IBUF4(1),RBUF(1))      00274300
C                                                                       00274400
	data blkebc/'    '/
      data SORT/' 0',' 1',' 2'/
	data blank8/'       '/
c...........these words are not defined...........
cmam  LINHD4(9)  = BLKEBC                                               00274500
cmam  LINHD4(11) = BLKEBC                                               00274600
      INTGRP = INT(XGRINT)                                              00274700
      IF (AINT(XGRINT).NE.XGRINT) INTGRP = INTGRP + 1                   00274800
C=======================================================================00274900
      IF (LAIPF2) GO TO 25                                              00276600
cmam  CALL MOVE (1,LINHD1( 1),IEQUIP,1)                                 00276700
	call savew(LINHD2,'EqpCod',iequip,0)
cmam  CALL MOVE (1,LINHD1( 2),CREW,  6)                                 00276800
	call savew(LINHD2,'CrwNam',crew,0)
cmam  CALL MOVE (1,LINHD1( 8),DATTYP,1)                                 00276900
	call savew(LINHD2,'DatTyp',dattyp,0)
cmam  CALL MOVE (1,LINHD1( 9),DTS,   2)                                 00277000
	call savew(LINHD2,'DgTrkS',dts,0)
cmam  CALL MOVE (1,LINHD1(34),IOAC,  3)                                 00277100
cmam  CALL MOVE (1,LINHD1(37),LINE,  4)                                 00277200
	oaclin(1) = ' '
	call move (1,oaclin(2),ioac,3)
	call move (1,oaclin(5),line,4)
	call savew(LINHD2,'OACLin',oaclin,0)
cmam  LINHD2(37) = SORT(ITYPE+1)                                        00277300
	call savew(LINHD2,'SrtTyp',sort(itype+1),0)
cmam  LINHD4(26) = NSANEW                                               00277400
	call savew(LINHD2,'LinDir',NSANEW,0)
cm25  IF (JOBNO1.NE.BLANK8) CALL MOVE (1,LINHD1(42),JOBNO1,7)           00277500
  25	if(jobno1.ne.blank8) then
	   ajob(1) = ' '
	   call move (1,ajob(2),jobno1,7)
	   call savew(LINHD2,'JobNum',ajob,0)
	endif
cmam  CALL ENCODF (INTGRP,IGICH,4,IFLAG)                                00277600
cmam  LINHD4(20) = IGICH                                                00277700
	write(grpint,799) intgrp
  799	format(i4)
	call savew(LINHD2,'GrpInt',grpint,0)
C=======================================================================00277800
C=======================================================================00277900
cmam  LINHD4(6)  = BLKEBC                                               00278000
C                                                                       00278100
      IF ( METENG .EQ. 0 ) GO TO 27                                     00278200
         GRINTF = XGRINT * 3.280                                        00278300
         SPMILE = 5280.0 / ( GRINTF * SHTMOV )                          00278400
         GO TO 28                                                       00278500
C                                                                       00278600
  27  SPMILE = 5280.0 / ( XGRINT * SHTMOV )                             00278700
C                                                                       00278800
  28  IF (MODEPR.EQ.2) GO TO 50                                         00278900
cmam  LINHD4(13) = NTPR                                                 00279000
	call savew(LINHD4,'NumTrc',ntpr,0)
cmam  LINHD4(14) = NREC                                                 00279100
	call savew(LINHD4,'NumRec',nrec,0)
cmam  LINHD2(71) = METENG                                               00279200
	kval = meteng
	call savew(LINHD2,'UnitFl',kval,0)
cmam  LINHD2(76) = DPI                                                  00279300
	kval = dpi
	call savew(LINHD2,'DptInt',kval,0)
cmam  LINHD2(85) = IPLDIR                                               00279400
	kval = ipldir
	call savew(LINHD2,'PltDir',kval,0)
C                                                                       00279500
cmam  RBUF (57) = SPMILE                                                00279600
	call savew(LINHD2,'NmSpMi',spmile,0)
cmam  LINHD2 (55) = NTPR                                                00279700
	call savew(LINHD2,'OrNTRC',ntpr,0)
cmam  LINHD2 (56) = NREC                                                00279800
	call savew(LINHD2,'OrNREC',nrec,0)
C                                                                       00279900
cmam  IBIAS = LINHD2(104)                                               00280000
	call saver(LINHD2,'SPBias',achar,0)
	write(ibias,19) achar
cmam	write(ibias,19) achar(2)
   19	format(a2)
ccc19	format(a1)
      IFSP = NSPN                                                       00280100
cmam  CALL SBIAS (IBFLAG,IBIAS,IHSP,IFSP)                               00280200
c......ihsp is calculated from ifsp in sbias according to ibflag & ibias
c.......we got the bias above, need to get the bias flag here
	call saver(LINHD2,'SpBiFl',ibflag,0)
	CALL SBIAS (IBFLAG,IBIAS,IFSP,IHSP)
cmam  LINHD2(72) = IHSP                                                 00280300
	call savew(LINHD2,'FrstSP',ihsp,0)
c.......ibias does not change -- no need to reset it here
cmam  LINHD2(104) = IBIAS                                               00280400
C                                                                       00280500
      IF (MOVFL1) GO TO 30                                              00280600
cmam  LINHD2(73) = ZLOC1 * 4                                            00280700
	call savew(LINHD2,'DpN1SP',zloc1*4,0)
      GO TO 40                                                          00280800
C                                                                       00280900
c30   LINHD2(73) = ZLOC1 * 2                                            00281000
 30	call savew(LINHD2,'DpN1SP',zloc1*2,0)
C                                                                       00281100
c40   LINHD2(74) = (SHTMOV * XGRINT * 100.) / (DPI * SPINC)             00281200
 40	kval = (SHTMOV * XGRINT * 100.) / (DPI * SPINC)
   	call savew(LINHD2,'NmDpIn',kval,0)
C                                                                       00281300
cmam  LINHD2(67) = BUFMAX(7) + 0.5                                      00281400
	kval = bufmax(7) + 0.5
	call savew(LINHD2,'MxTrOf',kval, 0)
cmam  LINHD2(68) = BUFMIN(7)                                            00281500
	kval = bufmin(7)
	call savew(LINHD2,'MnTrOf',kval,0)
C                                                                       00281600
c...........this word is not defined...........
c50   LINHD2(36) = BLKEBC                                               00281700
cmam  LINHD2(38) = IFOLD                                                00281800
 50	call savew(LINHD2,'CDPFld',ifold,0)
C                                                                       00281900
      IF (BUFMAX(1).EQ.ZMISS) GO TO 55                                  00282000
cmam  LINHD2(43) = BUFMAX(1) + 0.5                                      00282100
	kval = BUFMAX(1) + 0.5
	call savew(LINHD2,'MxSPEl',kval,0)
cmam  LINHD2(44) = BUFMIN(1) + 0.5                                      00282200
	kval = BUFMIN(1) + 0.5
	call savew(LINHD2,'MnSPEl',kval,0)
C                                                                       00282300
 55   IF (BUFMAX(2).EQ.ZMISS) GO TO 60                                  00282400
cmam  LINHD2(45) = BUFMAX(2) + 0.5                                      00282500
	kval = BUFMAX(2) + 0.5
	call savew(LINHD2,'MxRSEL',kval,0)
cmam  LINHD2(46) = BUFMIN(2) + 0.5                                      00282600
	kval = BUFMIN(2) + 0.5
	call savew(LINHD2,'MnRSEL',kval,0)
C                                                                       00282700
 60   IF (BUFMAX(5).EQ.ZMISS) GO TO 65                                  00282800
cmam  LINHD2(47) = BUFMAX(5) + 0.5                                      00282900
	kval = BUFMAX(5) + 0.5
	call savew(LINHD2,'MxGrEl',kval,0)
cmam  LINHD2(48) = BUFMIN(5) + 0.5                                      00283000
	kval = BUFMIN(5) + 0.5
	call savew(LINHD2,'MnGrEl',kval,0)
C                                                                       00283100
 65   IF (MODEPR.NE.0) GO TO 70                                         00283200
      IF (BUFMAX(6).LT.-32767) BUFMAX(6) = 0                            00283300
      IF (BUFMIN(6).LT.-32767) BUFMIN(6) = 0                            00283400
      IF (BUFMAX(6).GE. 30000) BUFMAX(6) = 0                            00283500
      IF (BUFMIN(6).GE. 30000) BUFMIN(6) = 0                            00283600
cmam  LINHD2(49) = BUFMAX(6) + SIGN(0.5,BUFMAX(6))                      00283700
	kval = BUFMAX(6) + SIGN(0.5,BUFMAX(6))
	call savew(LINHD2,'MxTrSt',kval,0)
cmam  LINHD2(50) = BUFMIN(6) + SIGN(0.5,BUFMIN(6))                      00283800
	kval = BUFMIN(6) + SIGN(0.5,BUFMIN(6))
	call savew(LINHD2,'MnTrSt',kval,0)
C                                                                       00283900
c70   LINHD2(63) = BUFMAX(3) + 0.5                                      00284000
 70	kval = BUFMAX(3) + 0.5
	call savew(LINHD2,'MxShDp',kval,0)
cmam  LINHD2(64) = BUFMIN(3) + 0.5                                      00284100
	kval = BUFMIN(3) + 0.5
	call savew(LINHD2,'MnShDp',kval,0)
cmam  LINHD2(65) = BUFMAX(4) + 0.5                                      00284200
	kval = BUFMAX(4) + 0.5
	call savew(LINHD2,'MxUHTm',kval,0)
cmam  LINHD2(66) = BUFMIN(4) + 0.5                                      00284300
	kval = BUFMIN(4) + 0.5
	call savew(LINHD2,'MnUHTm',kval,0)
C                                                                       00284400
cmam  LINHD2(75) = 0                                                    00284500
	kval = 0
	call savew(LINHD2,'StWdFl',kval,0)
cmam  LINHD2(103) = 1                                                   00284600
	kval = 1
	call savew(LINHD2,'MutFlg',kval,0)
      RETURN                                                            00284700
      END                                                               00284800
C  ROUTINE:       FLDH                                                  00284900
C  ROUTINE TYPE:  SUBROUTINE                                            00285000
C  PURPOSE:  PROCESS FIELD HISTORY CARDS.                               00285100
C  AUTHOR:  DOUGLAS BODDY                                               00285200
C  DATE WRITTEN:  AUGUST 1985                                           00285300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00285400
C                                                                       00285500
      SUBROUTINE FLDH (CRDTYP,KARD,LINHD1,LINHD2,IRD,IPR,N,*,*)         00285600
C                                                                       00285700
cmam  REAL*8 FLDH1/'1FLDH'/,CRDTYP                                      00285800
	character*5 crdtyp, fldh1
C                                                                       00285900
C=======================================================================00286000
C                                                                       00286700
      INTEGER*2 LINHD2(3000)                                            00286800
cmam  INTEGER*2 IFHBYT,IFHBT2                                           00286900
cmam  INTEGER*2 HEX5A/Z5A40/,HEXCHK/Z4040/                              00287000
C                                                                       00287100
      character*1 LINHD1(6000),KARD(80),pkard(35)
      LOGICAL EOC
C                                                                       00287400
cmam  EQUIVALENCE (HEXCHK,HEXCK1(1))                                    00287500
cmam  EQUIVALENCE (HEX5A,HEX5A1(1))                                     00287600
C                                                                       00287700
cmam  DATA LHDRSZ/6000/                                                 00287800
cmam  DATA LHLHSZ/4996/                                                 00287900
cmam  DATA NCHAR/35/                                                    00288000
	data fldh1/'1FLDH'/
      data EOC/.FALSE./
C                                                                       00288100
      CALL WRCARD (KARD,1,IPR)                                          00288200
	call DEFLDH(linhd2,n,linhd1)
C                                                                       00288300
C     +---------------------------------------------------------------+ 00288400
C     | LINE HEADER MAXIMUM NUMBER OF BYTES = 6000.                   | 00288500
C     | LINE HEADER HISTORY MAXIMUM NUMBER OF BYTES = 4996.           | 00288600
C     |    1- BYTES 1   -1000; GENERAL INFORMATION.                   | 00288700
C     |    2- BYTES 1001-1002; NO. OF ENTRIES IN LINE HEADER HISTORY. | 00288800
C     |    3- BYTES 1003-1004; NO. OF BYTES IN LINE HEADER HISTORY.   | 00288900
C     | NUMBER OF CHARACTERS (BYTES) OF FREE FORM INFO. IS 35.        | 00289000
C     | HEXADECIMAL '5A' PRECEEDS FIELD HISTORY ENTRY.                | 00289100
C     | SEARCH FOR EXISTING FIELD HISTORY INFORMATION.                | 00289200
C     | THIS EXISTING FIELD HISTORY WILL BE REPLACED BY NEW INFO.     | 00289300
C     +---------------------------------------------------------------+ 00289400
C                                                                       00289500
cmam  ICOUNT = 1005                                                     00289600
c10   HEXCK1(1) = LINHD1(ICOUNT+2)                                      00289700
cmam  IF (HEXCHK.NE.HEX5A) GO TO 20                                     00289800
cmam  CALL MOVE (1,IFHBYT,LINHD1(ICOUNT),2)                             00289900
cmam  IFHBT2 = IFHBYT + 2                                               00290000
cmam  ICOUNT = ICOUNT + IFHBT2                                          00290100
cmam  LINHD2(502) = LINHD2(502) - IFHBT2                                00290200
cmam  LINHD2(501) = LINHD2(501) - 1                                     00290300
cmam  GO TO 10                                                          00290400
C                                                                       00290500
c20   NENTRY = LINHD2(501)                                              00290600
cmam  I502M4 = LINHD2(502) - 4                                          00290700
cmam  LBYTES = I502M4                                                   00290800
cmam  I = 0                                                             00290900
cmam  J = 0                                                             00291000
C                                                                       00291100
cmam  NCHARX = NCHAR + 1                                                00291200
cmam  LHLHSV = LHDRSZ - LBYTES + 1                                      00291300
cmam  IWRKSZ = LHLHSZ - LBYTES                                          00291400
cmam  JINCR = NCHARX + 2                                                00291500
cmam  IINCR = JINCR / 2                                                 00291600
C                                                                       00291700
C     +------------------------------------------+                      00291800
C     |    IF FIELD HISTORY ALREADY EXISTS,      |                      00291900
C     |         SAVE AT END OF LINE HEADER.      |                      00292000
C     |    FILL VACATED SPACE WITH BLANKS.       |                      00292100
C     +------------------------------------------+                      00292200
C                                                                       00292300
C=======================================================================00292400
cmam  CALL MOVE (4,LINHD1(LHLHSV),LINHD1(ICOUNT),LBYTES)                00292700
cmam  IF (IWRKSZ.GT.0) CALL MOVE (2,LINHD1(1005),0,IWRKSZ)              00292800
C=======================================================================00293800
C                                                                       00293900
C     +------------------------------------------+                      00294000
C     |        READ A PARAMETERS CARD            |                      00294100
C     |    CHECK FOR A FIELD HISTORY CARD        |                      00294200
C     +------------------------------------------+                      00294300
C                                                                       00294400
      GO TO 60                                                          00294500
C                                                                       00294600
 30   EOC = .TRUE.                                                      00294700
      GO TO 100                                                         00294800
C                                                                       00294900
 40   READ(IRD,50,END=30)(KARD(ii),ii=1,80),CRDTYP,(pkard(jj),jj=1,35)
 50   FORMAT (80A1,T1,A5,5x,35a1)
c40   READ (IRD,50,END=30) KARD,CRDTYP                                  00295000
c50   FORMAT (80A1,T1,A5)                                               00295100
      IF (CRDTYP.NE.FLDH1) GO TO 100                                    00295200
      CALL WRCARD (KARD,3,IPR)                                          00295300
C                                                                       00295400
C     +----------------------------------------------------+            00295500
C     |  FILL:                                             |            00295600
C     |     1- "NUMBER OF CHARACTERS IN ENTRY" ENTRY       |            00295700
C     |     2- "HEX 5A" IDENTIFIER FOR FIELD HISTORY       |            00295800
C     |     3- "FREE FORM FIELD HISTORY INFORMATION        |            00295900
C     |  UPDATE THE NUMBER OF BYTES ADDED TO LINE HEADER   |            00296000
C     |  UPDATE THE NUMBER OF ENTRIES ADDED TO LINE HEADER |            00296100
C     +----------------------------------------------------+            00296200
C                                                                       00296300
 60	i = leng2(pkard,35)
	if(i .lt. 1) i = 1
	call infldh(linhd2,n,pkard,i,linhd1)
	go to 40
c60   LINHD2(503+I) = NCHARX                                            00296400
cmam  LINHD1(1007+J) = HEX5A1(1)                                        00296500
C=======================================================================00296600
cmam  CALL MOVE (1,LINHD1(1008+J),KARD(11),NCHAR)                       00296900
C=======================================================================00298000
cmam  I = I + IINCR                                                     00298100
cmam  J = J + JINCR                                                     00298200
cmam  LBYTES = LBYTES + JINCR                                           00298300
cmam  NENTRY = NENTRY + 1                                               00298400
cmam  IF (LBYTES+1004.LT.LHLHSV) GO TO 40                               00298500
cmam  WRITE (IPR,90) LHDRSZ                                             00298600
c90   FORMAT ('0** M0202 ** ERROR DETECTED BY SUBROUTINE FLDH:'/        00298700
cmam $ 13X,'MAXIMUM LENGTH OF LINE HEADER IS ',I5/                      00298800
cmam $ 13X,'IF THE EXISTING PROCESSING HISTORY ALONG WITH THE FIELD ',  00298900
cmam $     'HISTORY ON THE FLDH CARDS IS ALL USED, '/                   00299000
cmam $ 13X,'THIS LIMIT WILL BE EXCEEDED'/                               00299100
cmam $ 13X,'DECREASE THE NUMBER OF FLDH CARDS BEFORE RESUBMITTING')     00299200
cmam  ICC = 100                                                         00299300
cmam  RETURN 2                                                          00299400
C                                                                       00299500
C     +----------------------------------------------------+            00299600
C     |  SHIFT ORIGINAL HISTORY CARDS BACK BEHIND NEW INFO |            00299700
C     +----------------------------------------------------+            00299800
C                                                                       00299900
c100  LINHD2(501) = NENTRY                                              00300000
cmam  LINHD2(502) = LBYTES + 4                                          00300100
cmam  CALL MOVE (1,LINHD1(1005+LBYTES-I502M4),LINHD1(LHLHSV),I502M4)    00300200
cmam  N = LINHD2(502) + 1000                                            00300300
cmam  IF (.NOT.EOC) RETURN                                              00300400
cmam  RETURN 1                                                          00300500
  100	return
      END                                                               00300600
C  ROUTINE:       PLTSET                                                00300700
C  ROUTINE TYPE:  SUBROUTINE                                            00300800
C  PURPOSE:  CHECK IF GRAPH DISPLAYS REQUESTED, DO SETUP IF NECESSARY   00300900
C  AUTHOR:  DOUGLAS BODDY                                               00301000
C  DATE WRITTEN:  AUGUST 1985                                           00301100
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00301200
C                                                                       00301300
      SUBROUTINE PLTSET (PLTFLG,MODEPR,IPLT1,IPLT2,NUMLAY,JCC,          00301400
     $                   IUNIT)                                         00301500
C                                                                       00301600
      DOUBLE PRECISION RAD
cmam  DOUBLE PRECISION XMCH,RAD                                         00301700
      DOUBLE PRECISION DEST                                             00301800
C                                                                       00301900
      INTEGER*2 PLTFLG(4)                                               00302000
      INTEGER*2 MODEPR                                                  00302100
C                                                                       00302200
      LOGICAL PRNT,PLOT,FLGO,INTERA
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	character*4 card, TDIS, SPAR
C                                                                       00302500
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00303100
      COMMON /PLTCOM/ ICODE,NUMDEV,ILINE,IPRTY,
     $                XXADD,YYADD,XPLT1,FONTUN,XLIBR,                   00303300
     $                THKMAX,XSTATN,DSN,PRNT,PLOT,FLGO,INTERA,igscod
C                                                                       00303500
C=======================================================================00303600
      COMMON /DSTCOM/ DEST                                              00303900
      INTEGER*2 IUNIT                                                   00304600
C=======================================================================00305200
C                                                                       00305300
cmam  DATA XMCH/'        '/                                             00305400
cmam  DATA YMCH/'30.0'/,YMCH1/'14.0'/,YMCH2/'19.0'/                     00305500
C                                                                       00305600
      IF (MODEPR.NE.2) GO TO 50                                         00305700
      IF (PLTFLG(2).EQ.0) GO TO 30                                      00305800
      WRITE (IPR,20)                                                    00305900
 20   FORMAT ('0** M6005 ** WARNING FROM SUBROUTINE PLTSET:'/           00306000
     $ 13X,'REQUEST FOR STACKING CHART WILL NOT BE HONORED'/            00306100
     $ 13X,'SINCE PROCESSING IS NOT FOR INDEXING')                      00306200
      PLTFLG(2) = 0                                                     00306300
C                                                                       00306400
 30   IF (PLTFLG(3).EQ.0) GO TO 50                                      00306500
      WRITE (IPR,40)                                                    00306600
 40   FORMAT ('0** M6010 ** WARNING FROM SUBROUTINE PLTSET:'/           00306700
     $ 13X,'REQUEST FOR TRAVERSE PLOT WILL NOT BE HONORED'/             00306800
     $ 13X,'SINCE PROCESSING IS NOT FOR INDEXING')                      00306900
      PLTFLG(3) = 0                                                     00307000
C                                                                       00307100
 50   IF (PLTFLG(1).EQ.0) GO TO 60                                      00307200
      IF (BUF(1,2).NE.ZMISS) GO TO 60                                   00307300
      WRITE (IPR,55)                                                    00307400
 55   FORMAT ('0** M6015 ** WARNING FROM SUBROUTINE PLTSET:'/           00307500
     $ 13X,'REQUEST FOR ELEVATION PLOT WILL NOT BE HONORED'/            00307600
     $ 13X,'SINCE ELEVATIONS WERE NOT INPUT')                           00307700
      PLTFLG(1) = 0                                                     00307800
C                                                                       00307900
 60   IF (PLTFLG(4).EQ.0) GO TO 90                                      00308000
      IF (MODEPR.NE.1) GO TO 80                                         00308100
      WRITE (IPR,70)                                                    00308200
 70   FORMAT ('0** M6020 ** WARNING FROM SUBROUTINE PLTSET:'/           00308300
     $ 13X,'REQUEST FOR WEATHERING GRAPH WILL NOT BE HONORED'/          00308400
     $ 13X,'SINCE PROCESSING IS NOT FOR STATICS')                       00308500
      PLTFLG(4) = 0                                                     00308600
      GO TO 90                                                          00308700
C                                                                       00308800
 80   IF (NUMLAY.GT.0) GO TO 90                                         00308900
      WRITE (IPR,85)                                                    00309000
 85   FORMAT ('0** M6030 ** WARNING FROM SUBROUTINE PLTSET:'/           00309100
     $ 13X,'REQUEST FOR WEATHERING GRAPH WILL NOT BE HONORED'/          00309200
     $ 13X,'SINCE NO WEATHERING INFORMATION SUPPLIED')                  00309300
      PLTFLG(4) = 0                                                     00309400
C                                                                       00309500
C                                                                       00329600
  90	continue
 3920 PLOT = .FALSE.                                                    00329700
      PRNT = .TRUE.                                                     00329800
C                                                                       00329900
      DO 3950 I=1,4                                                     00330000
         IF (PLTFLG(I).EQ.2) PLTFLG(I) = 1                              00330100
 3950 CONTINUE                                                          00330200
C                                                                       00330300
 4000 	continue
cmam......write(0,*)'here is where PLTFLG(2) set = 3 ... do not do it!'
c4000 IF (PLTFLG(2).EQ.1.AND.NTPR.GT.96) PLTFLG(2) = 3                  00330400
      IF (PLTFLG(4).EQ.0) GO TO 5000                                    00330500
      THKMAX = 0.0                                                      00330600
      IF (.NOT.ST1FLG) GO TO 5000                                       00330700
C                                                                       00330800
      DO 4200 I=1,NLOC                                                  00330900
         TMAX = BUF(I,5)                                                00331000
         IF (.NOT.ST2FLG) GO TO 4100                                    00331100
         TMAX = TMAX + BUF(I,7)                                         00331200
         IF (.NOT.ST3FLG) GO TO 4100                                    00331300
         TMAX = TMAX + BUF(I,9)                                         00331400
 4100    IF (TMAX.GT.THKMAX) THKMAX = TMAX                              00331500
 4200 CONTINUE                                                          00331600
C                                                                       00331700
 5000 RETURN                                                            00331800
      END                                                               00331900
C  ROUTINE:       TEMINI                                                00332000
C  ROUTINE TYPE:  SUBROUTINE                                            00332100
C  PURPOSE:  TEMPLATE INITIALIZATION                                    00332200
C  AUTHOR:  DOUGLAS BODDY                                               00332300
C  DATE WRITTEN:  SEPTEMBER 1985                                        00332400
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00332500
C                                                                       00332600
      SUBROUTINE TEMINI                                                 00332700
C                                                                       00332800
      COMMON /PLTCOM/ ICODE,NUMDEV,ILINE,IPRTY,
     $                XXADD,YYADD,XPLT1,FONTUN,XLIBR,                   00333000
     $                THKMAX,XSTATN,DSN,PRNT,PLOT,FLGO,INTERA,igscod
C                                                                       00333200
      LOGICAL FLGO,PRNT,PLOT,INTERA
C                                                                       00333500
      RETURN                                                            00336400
      END                                                               00336500
C  ROUTINE:       PLOTIT                                                00336600
C  ROUTINE TYPE:  SUBROUTINE                                            00336700
C  PURPOSE:  PLOT THE GRAPHS                                            00336800
C  AUTHOR:  DOUGLAS BODDY                                               00336900
C  DATE WRITTEN:  SEPTEMBER 1985                                        00337000
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00337100
C                                                                       00337200
      SUBROUTINE PLOTIT (PLTFLG,SHTMOV,METENG,MODEPR,SPINC)             00337300
C                                                                       00337400
      DOUBLE PRECISION RAD                                              00337500
C                                                                       00337600
      INTEGER*2 PLTFLG(4)                                               00337700
      INTEGER*2 METENG,MODEPR                                           00337800
C                                                                       00337900
      LOGICAL PRNT,PLOT,FLGO,INTERA
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	character*4 card, TDIS,SPAR
C                                                                       00338200
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00338800
      COMMON /PLTCOM/ ICODE,NUMDEV,ILINE,IPRTY,
     $                XXADD,YYADD,XPLT1,FONTUN,XLIBR,                   00339000
     $                THKMAX,XSTATN,DSN,PRNT,PLOT,FLGO,INTERA,igscod
C                                                                       00339200
C=======================================================================00339300
      RETURN                                                            00350700
      END                                                               00350800
C  ROUTINE:       CLSPLT                                                00350900
C  ROUTINE TYPE:  SUBROUTINE                                            00351000
C  PURPOSE:  CLOSE THE PLOT DEVICE                                      00351100
C  AUTHOR:  DOUGLAS BODDY                                               00351200
C  DATE WRITTEN:  SEPTEMBER 1985                                        00351300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00351400
C                                                                       00351500
      SUBROUTINE CLSPLT                                                 00351600
      RETURN                                                            00356600
      END                                                               00356700
C=======================================================================00356800
C  ROUTINE:       PRNTIT                                                00360400
C  ROUTINE TYPE:  SUBROUTINE                                            00360500
C  PURPOSE:  PRINT THE GRAPHS                                           00360600
C  AUTHOR:  DOUGLAS BODDY                                               00360700
C  DATE WRITTEN:  SEPTEMBER 1985                                        00360800
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00360900
C                                                                       00361000
      SUBROUTINE PRNTIT (PLTFLG,SHTMOV,METENG,MODEPR,                   00361100
     $                   ARRAY,SPINC)                                   00361200
C                                                                       00361300
      character*8 UNIT,METRES
cmam  DOUBLE PRECISION UNIT/' FEET  '/,METRES/' METRES'/                00361400
      DOUBLE PRECISION RAD                                              00361500
C                                                                       00361600
      INTEGER*2 PLTFLG(4)                                               00361700
      INTEGER*2 METENG,MODEPR                                           00361800
C                                                                       00361900
      LOGICAL PRNT,PLOT,FLGO,INTERA
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      character*1 ARRAY(120)
cmam  LOGICAL*1 ARRAY(120)                                              00362200
	character*4 card, TDIS, SPAR
C                                                                       00362300
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00362900
      COMMON /PLTCOM/ ICODE,NUMDEV,ILINE,IPRTY,
     $                XXADD,YYADD,XPLT1,FONTUN,XLIBR,                   00363100
     $                THKMAX,XSTATN,DSN,PRNT,PLOT,FLGO,INTERA,igscod
C                                                                       00363300
      data UNIT/' FEET  '/,METRES/' METRES'/
C=======================================================================00363400
C                                                                       00364000
      ZNX1ST = INX1ST                                                   00364100
C                                                                       00364200
      IF (METENG.EQ.1) UNIT = METRES                                    00364300
C                                                                       00364400
      IF (PLTFLG(1).EQ.1)                                               00364500
     $    CALL   ELEVPR (CARD,IPR,IDSK1,ZNX1ST,NLOC,XGRINT,SHTMOV,      00364600
     $                   BUFMIN(5),BUFMAX(5),ARRAY,UNIT,RAD)            00364700
C                                                                       00364800
      IF (PLTFLG(3).EQ.1)                                               00364900
     $    CALL   TRAVPR (CARD,IPR,IDSK1,ZNX1ST,NLOC,XGRINT,SHTMOV,      00365000
     $                   BUFMIN(7),BUFMAX(7),ARRAY,                     00365100
     $                   UNIT,RAD,SPINC)                                00365200
C                                                                       00365300
      IF (PLTFLG(4).EQ.1)                                               00365400
     $    CALL   WETHPR (IPR,INX1ST,NLOC,THKMAX,ARRAY,                  00365500
     $                   ST1FLG,ST2FLG,ST3FLG,UNIT)                     00365600
C                                                                       00365700
      WRITE (IPR,100)                                                   00365800
 100  FORMAT ('1')                                                      00365900
C                                                                       00366000
      RETURN                                                            00366100
      END                                                               00366200
C  ROUTINE:       ELEVGR                                                00366300
C  ROUTINE TYPE:  SUBROUTINE                                            00366400
C  PURPOSE:  PLOT ELEVATION DISPLAY                                     00366500
C  AUTHOR:  DOUGLAS BODDY                                               00366600
C  DATE WRITTEN:  AUGUST 1985                                           00366700
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00366800
C                                                                       00366900
      SUBROUTINE ELEVGR (CARD,IPR,IDSK1,ZNX1ST,NLOC,XGRINT,SHTMOV,      00367000
     $                   NUMDEV,XXADD,YYADD,ELEVMN,ELEVMX,              00367100
     $                   METENG,RAD)                                    00367200
C                                                                       00367300
      DOUBLE PRECISION RAD                                              00367400
C                                                                       00367500
      character*4   CARD(20)
C                                                                       00367800
      INTEGER*2 METENG                                                  00367900
C                                                                       00368000
C                                                                       00368200
C                                                                       00368500
      RETURN                                                            00384900
      END                                                               00385000
C  ROUTINE:       WETHGR                                                00385100
C  ROUTINE TYPE:  SUBROUTINE                                            00385200
C  PURPOSE:  PLOT WEATHERING THICKNESS DISPLAY                          00385300
C  AUTHOR:  DOUGLAS BODDY                                               00385400
C  DATE WRITTEN:  AUGUST 1985                                           00385500
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00385600
C                                                                       00385700
      SUBROUTINE WETHGR (IPR,ZNX1ST,NLOC,                               00385800
     $                   NUMDEV,XXADD,YYADD,THKMAX,XLIBR,               00385900
     $                   METENG,ST1FLG,ST2FLG,ST3FLG)                   00386000
C                                                                       00386100
      INTEGER*2 METENG                                                  00386200
C                                                                       00386300
      LOGICAL ST1FLG,ST2FLG,ST3FLG
C                                                                       00386500
C                                                                       00386800
      RETURN                                                            00404800
      END                                                               00404900
C  ROUTINE:       TRAVGR                                                00405000
C  ROUTINE TYPE:  SUBROUTINE                                            00405100
C  PURPOSE:  PLOT TRAVERSE DISPLAY                                      00405200
C  AUTHOR:  DOUGLAS BODDY                                               00405300
C  DATE WRITTEN:  AUGUST 1985                                           00405400
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00405500
C                                                                       00405600
      SUBROUTINE TRAVGR (CARD,IPR,IDSK1,ZNX1ST,NLOC,XGRINT,SHTMOV,      00405700
     $                   NUMDEV,XXADD,YYADD,TRAVMN,TRAVMX,              00405800
     $                   METENG,SPINC)                                  00405900
C                                                                       00406000
      character*4   CARD(20)
C                                                                       00406200
      INTEGER*2 METENG                                                  00406300
C                                                                       00406400
C                                                                       00406900
      RETURN                                                            00420200
      END                                                               00420300
cmam.......modified ISTCHP, STCHP, and ENDSTH so that the stacking
cmam.......	chart comes out in one piece at end of LERR printout
C  ROUTINE:       ISTCHP                                                00437700
C  ROUTINE TYPE:  SUBROUTINE                                            00437800
C  PURPOSE:  PRINT STACKING CHART                                       00437900
C  AUTHOR:  L BAIRD                                                     00438000
C  DATE WRITTEN:  AUGUST 1972                                           00438100
C  MODIFIED BY:  DOUGLAS BODDY                                          00438200
C  DATE MODIFIED:  AUGUST 1985                                          00438300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00438400
C                                                                       00438500
      SUBROUTINE ISTCHP (IEOS,IOBF,IOAC,LINEN,NTPR,ICC,IPR,IUNSCP,      00438600
     $                   MOVFL1,PLTFLG)                                 00438700
C                                                                       00438800
      INTEGER*2 IDI(*)
cmam  INTEGER*2 IDI(96)                                                 00439200
      INTEGER*2 PLTFLG(4)                                               00439300
C                                                                       00439400
	integer ieos,iobf,ntpr,icc,ipr,iunscp,idisp,iri,iob,mtpr
	integer kunscp
      character*1 LINEN(4),torf,ioac(3)
	character*4 FMT4(4)
	character*20 fmta
	equivalence (fmt4(1),fmta)
      LOGICAL MOVFL1
cmam.........
	save
cmam.........
C=================================================================      00440200
    	open(unit=iunscp,status='SCRATCH',access='SEQUENTIAL',
     *		form='UNFORMATTED')
	if(movfl1) then
	   torf = 'T'
	else
	   torf = 'F'
	endif
    	write(iunscp) ieos,iobf,(ioac(i),i=1,3),(linen(j),j=1,4),
     *			ntpr,torf
	mtpr = ntpr
	kunscp = iunscp
	return
C                                                                       00452300
C-----------------------------------------------------------------------00452400
C                  ENTRY FOR EACH RI                                    00452500
C-----------------------------------------------------------------------00452600
C                                                                       00452700
      ENTRY STCHP (IDI,IDISP,IRI,IOB)                                   00452800
c
    	write(kunscp,err=499) idisp,iri,iob,(idi(i),i=1,mtpr)
	return
  499	write(0,*)'error occured writing for stacking chart,ri=',iri
	return
C-----------------------------------------------------------------------00471200
C                  ENTRY TO EMPTY BUFFER                                00471300
C-----------------------------------------------------------------------00471400
C                                                                       00471500
      ENTRY ENDSTH                                                      00471600
C=======================================================================00473800
  500 RETURN                                                            00473900
      END                                                               00474000
C  ROUTINE:       ISTCHG                                                00474100
C  ROUTINE TYPE:  SUBROUTINE                                            00474200
C  PURPOSE:  PLOT STACKING CHART                                        00474300
C  AUTHOR:  DOUGLAS BODDY                                               00474400
C  DATE WRITTEN:  AUGUST 1985                                           00474500
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00474600
C                                                                       00474700
      SUBROUTINE ISTCHG (IEOS,IOAC,LINE,NTPR,                           00474800
     $                   NUMDEV,NLOC,INX1ST,MOVFL1)                     00474900
C                                                                       00475000
	logical MOVFL1
C                                                                       00475200
      RETURN                                                            00490500
C                                                                       00490600
C-----------------------------------------------------------------------00490700
C                  ENTRY FOR EACH RI                                    00490800
C-----------------------------------------------------------------------00490900
C                                                                       00491000
      ENTRY STCHG (IDI,XDISP,IRI)                                       00491100
C                                                                       00491200
      RETURN                                                            00494600
      END                                                               00494700
C  ROUTINE:       ELEVPR                                                00494800
C  ROUTINE TYPE:  SUBROUTINE                                            00494900
C  PURPOSE:  PRINT ELEVATION DISPLAY                                    00495000
C  AUTHOR:  DOUGLAS BODDY                                               00495100
C  DATE WRITTEN:  AUGUST 1985                                           00495200
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00495300
C                                                                       00495400
      SUBROUTINE ELEVPR (CARD,IPR,IDSK1,ZNX1ST,NLOC,XGRINT,SHTMOV,      00495500
     $                   ELEVMN,ELEVMX,ARRAY,                           00495600
     $                   UNIT,RAD)                                      00495700
C                                                                       00495800
      DOUBLE PRECISION RAD                                              00495900
      DOUBLE PRECISION UNIT                                             00496000
C                                                                       00496100
cmam  INTEGER   SPAR/'SPAR'/                                            00496200
cmam  INTEGER   CARD(20)                                                00496300
    	character*4 SPAR, card(20),idcrd
	character*80 kard
c.c.c.c.c.c.	equivalence (card(1),kard)
C                                                                       00496400
      LOGICAL EOF
      character*1 EX,OH,BOTH,SPACE,ARRAY(118)
cmam  LOGICAL*1 EX/'*'/,OH/'O'/,BOTH/'#'/,SPACE/' '/,ARRAY(118)         00496600
C                                                                       00496700
	data spar/'SPAR'/,EOF/.false./
      data EX/'*'/,OH/'O'/,BOTH/'#'/,SPACE/' '/
      DATA KFLAG/0/                                                     00496800
      DATA LFLAG/0/
      DATA NFLAG/0/                                                     00497000
      DATA L/1/                                                         00497100
C                                                                       00497200
	call move (1,kard,card,80)
      XINCR = AINT((ELEVMX - ELEVMN) / 117.0) + 1.                      00497300
      NINC = XINCR                                                      00497400
C                                                                       00497500
      WRITE (IPR,10)                                                    00497600
 10   FORMAT ('1',T57,'ELEVATION PLOT'/////)                            00497700
      WRITE (IPR,20) ELEVMN,UNIT,NINC,UNIT,ELEVMX,UNIT                  00497800
 20   FORMAT (6X,'GI MIN ELEV = ',F8.1,A8,T53,'EACH SPACE=',I4,A8,      00497900
     $ T104,'MAX ELEV = ',F8.1,A8//                                     00498000
     $ 9X,120('+'))                                                     00498100
C                                                                       00498200
      CALL MOVE (2,ARRAY,0,118)                                         00498300
      REWIND IDSK1                                                      00498400
C                                                                       00498500
 150  READ (IDSK1,160) CARD,IDCRD                                       00498600
 160  FORMAT (20A4,T1,1X,A4)                                            00498700
      IF (IDCRD .NE. SPAR) GO TO 150                                    00498800
C                                                                       00498900
      WRITE (IPR,300)                                                   00499000
      IGRP = ZNX1ST                                                     00499100
C                                                                       00499200
      DO 400 I=1,NLOC                                                   00499300
         IGRP = IGRP + 1                                                00499400
         XGRP = FLOAT(IGRP)                                             00499500
         K = (BUF(I,2) - ELEVMN) / XINCR + 1.                           00499600
         ARRAY(K) = EX                                                  00499700
 165     IF (LFLAG.EQ.1) GO TO 275                                      00499800
         IF (KFLAG.EQ.0) GO TO 170                                      00499900
         IF (KFLAG.EQ.1) GO TO 167                                      00500000
         IF (NFLAG.EQ.0) GO TO 280                                      00500100
         GO TO 299                                                      00500200
C                                                                       00500300
 167     SRCLOC = SRCLOC + SHTMOV                                       00500400
         GO TO 215                                                      00500500
C                                                                       00500600
 170     CONTINUE                                                       00500700
C=======================================================================00500800
cmam     CALL STRING (CARD,80)                                          00501200
cmam     READ (99,180)     ZLSLOC,OFFDIS,OFFANG,LRI                     00501300
	read(kard,180) ZLSLOC,OFFDIS,OFFANG,LRI
cmam	read(card,180) ZLSLOC,OFFDIS,OFFANG,LRI
C=======================================================================00501500
 180     FORMAT           (5X,F6.0,28X,F5.0,F4.0,27X,I5)                00501600
C                                                                       00501700
 190     READ (IDSK1,200,END=250) CARD,IDCRD                            00501800
 200     FORMAT (20A4,T1,1X,A4)                                         00501900
         IF (IDCRD .NE. SPAR) GO TO 190                                 00502000
C=======================================================================00502100
cmam     CALL STRING (CARD,80)                                          00502500
cmam     READ (99,205)     NXIRI                                        00502600
	read(kard,205) NXIRI
cmam	read(card,205) NXIRI
C=======================================================================00502800
 205     FORMAT (75X,I5)                                                00502900
C                                                                       00503000
C     **********************************                                00503100
C     | RESET SRCLOC TO REFLECT OFFDIS |                                00503200
C     **********************************                                00503300
C                                                                       00503400
 210     SRCLOC = ZLSLOC                                                00503500
         IF ( OFFDIS .EQ. 0.0 ) GO TO 215                               00503600
         X = DBLE(OFFANG) * RAD                                         00503700
         XDIS =  COS(X) * OFFDIS                                        00503800
         IXDIS = XDIS + SIGN(0.5,XDIS)                                  00503900
         XDGR = FLOAT(IXDIS) / XGRINT                                   00504000
         SRCLOC = ZLSLOC + XDGR                                         00504100
C                                                                       00504200
 215     ACTLOC = SRCLOC - ZNX1ST                                       00504300
C                                                                       00504400
 230     II = INT(ACTLOC)                                               00504500
         FI = FLOAT(II)                                                 00504600
         ELEV = BUF(II,2)                                               00504700
         IF (FI.EQ.ACTLOC) GO TO 240                                    00504800
         IF (II.GE.NLOC) GO TO 240                                      00504900
         IF (ELEV.EQ.BUF(II+1,2)) GO TO 240                             00505000
         ELEV = ELEV + (BUF(II+1,2) - ELEV) * (ACTLOC - FI)             00505100
C                                                                       00505200
 240     L = (ELEV - ELEVMN) / XINCR + 1.                               00505300
         LFLAG = 1                                                      00505400
C                                                                       00505500
         LRI = LRI + 1                                                  00505600
         IF (EOF) GO TO 275                                             00505700
         KFLAG = 0                                                      00505800
         IF (LRI.LT.NXIRI) KFLAG = 1                                    00505900
         GO TO 275                                                      00506000
C                                                                       00506100
 250     EOF = .TRUE.                                                   00506200
         KFLAG = 2                                                      00506300
         GO TO 210                                                      00506400
C                                                                       00506500
 275     IF (NFLAG.EQ.1) GO TO 290                                      00506600
cmam........assuming this is a typo...XIGRP is not used any other place
         IF (ACTLOC.GE.XGRP-0.25) GO TO 276
cmam     IF (ACTLOC.GE.XIGRP-0.25) GO TO 276                            00506700
         LFLAG = 0                                                      00506800
         GO TO 165                                                      00506900
C                                                                       00507000
 276     IF (ACTLOC.GT.XGRP+0.25) GO TO 280                             00507100
C=======================================================================00507200
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================00507300
C=============================           ===============================00507400
         IF (ARRAY(L).NE.EX) GO TO 278                                  00507500
C        IF (ARRAY(L).NEQV.EX) GO TO 278                                00507600
C=======================================================================00507700
C=======================================================================00507800
         ARRAY(L) = BOTH                                                00507900
         GO TO 279                                                      00508000
C                                                                       00508100
 278     ARRAY(L) = OH                                                  00508200
 279     LFLAG = 0                                                      00508300
C                                                                       00508400
 280     WRITE (IPR,285) IGRP,ARRAY                                     00508500
 285     FORMAT (2X,I5,2X,'+',118A1,'+')                                00508600
         ARRAY(K) = SPACE                                               00508700
         ARRAY(L) = SPACE                                               00508800
C                                                                       00508900
 290     NFLAG = 0                                                      00509000
         IF (EOF.AND.LFLAG.EQ.0) GO TO 299                              00509100
         IF (ACTLOC.GT.XGRP+0.25) GO TO 292                             00509200
         LFLAG = 0                                                      00509300
         NFLAG = 1                                                      00509400
         GO TO 165                                                      00509500
C                                                                       00509600
 292     IF (ACTLOC.GE.XGRP+0.75) GO TO 299                             00509700
C=======================================================================00509800
         IF (ARRAY(L).NE.EX) GO TO 293                                  00510100
C=======================================================================00510400
         ARRAY(L) = BOTH                                                00510500
         GO TO 294                                                      00510600
C                                                                       00510700
 293     ARRAY(L) = OH                                                  00510800
 294     LFLAG = 0                                                      00510900
C                                                                       00511000
         WRITE (IPR,295) ARRAY                                          00511100
 295     FORMAT (9X,'+',118A1,'+')                                      00511200
         ARRAY(L) = SPACE                                               00511300
         GO TO 400                                                      00511400
C                                                                       00511500
 299     WRITE (IPR,300)                                                00511600
 300     FORMAT (9X,'+',118X,'+')                                       00511700
C                                                                       00511800
 400  CONTINUE                                                          00511900
C                                                                       00512000
      WRITE (IPR,960) EX,OH,BOTH                                        00512100
 960  FORMAT (9X,120('+')/                                              00512200
     $        15X,'LEGEND:  ',A1,' = GROUP ELEVATION',                  00512300
     $                     5X,A1,' = SOURCE ELEVATION'/                 00512400
     $                    24X,A1,' = GROUP AND SOURCE ELEVATION')       00512500
      RETURN                                                            00512600
      END                                                               00512700
C  ROUTINE:       WETHPR                                                00512800
C  ROUTINE TYPE:  SUBROUTINE                                            00512900
C  PURPOSE:  PRINT WEATHERING THICKNESS DISPLAY                         00513000
C  AUTHOR:  DOUGLAS BODDY                                               00513100
C  DATE WRITTEN:  AUGUST 1985                                           00513200
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00513300
C                                                                       00513400
      SUBROUTINE WETHPR (IPR,INX1ST,NLOC,                               00513500
     $                   THKMAX,ARRAY,                                  00513600
     $                   ST1FLG,ST2FLG,ST3FLG,UNIT)                     00513700
C                                                                       00513800
      DOUBLE PRECISION UNIT                                             00513900
C                                                                       00514000
      INTEGER*2 IJK(12)                                                 00514100
C                                                                       00514200
      LOGICAL ST1FLG,ST2FLG,ST3FLG
cmam  LOGICAL*1 ARRAY(119)                                              00514400
cmam  LOGICAL*1 ONE/'X'/,TWO/'-'/,THREE/'/'/                            00514500
      character*1 ONE,TWO,THREE,ARRAY(120)
      data ONE/'X'/,TWO/'-'/,THREE/'/'/
C                                                                       00514600
      CALL MOVE (2,ARRAY,0,120)                                         00514700
      UPS = AINT((THKMAX + 118.9999) / 119.)                            00514800
      IUPS = UPS                                                        00514900
      IS = IUPS * 10                                                    00515000
C                                                                       00515100
      DO 10 I=1,12                                                      00515200
         IV = IS * I                                                    00515300
         IJK(I) = IV                                                    00515400
 10   CONTINUE                                                          00515500
C                                                                       00515600
      WRITE (IPR,20) IUPS,UNIT,(IJK(L),L=1,12)                          00515700
 20   FORMAT ('1',T57,'WEATHERING THICKNESS'////                        00515800
     $ 4X,'GI',20X,'EACH SPACE =',I4,A8//                               00515900
     $ 8X,12I10)                                                        00516000
      WRITE (IPR,30)                                                    00516100
 30   FORMAT (7X,12('O+++++++++'),'O')                                  00516200
C                                                                       00516300
      IF (THKMAX.LE.0.0) GO TO 330                                      00516400
      IGI = INX1ST                                                      00516500
C                                                                       00516600
      DO 300 I=1,NLOC                                                   00516700
         IGI = IGI + 1                                                  00516800
         IV = BUF(I,5) / UPS                                            00516900
         IF (IV.LT.1) GO TO 150                                         00517000
         ARRAY(1)  = ONE                                                00517100
         IF (IV.GT.1) CALL MOVE (1,ARRAY(2),ARRAY(1),IV-1)              00517200
C                                                                       00517300
 150     IF (.NOT.ST2FLG) GO TO 250                                     00517400
         IV1 = IV + 1                                                   00517500
         IV = (BUF(I,5) + BUF(I,7)) / UPS                               00517600
         IF (IV.LT.IV1) GO TO 200                                       00517700
         ARRAY(IV1) = TWO                                               00517800
         IF (IV.GT.IV1) CALL MOVE (1,ARRAY(IV1+1),ARRAY(IV1),IV-IV1)    00517900
C                                                                       00518000
 200     IF (.NOT.ST3FLG) GO TO 250                                     00518100
         IV1 = IV + 1                                                   00518200
         IV = (BUF(I,5) + BUF(I,7) + BUF(I,9)) / UPS                    00518300
         IF (IV.LT.IV1) GO TO 250                                       00518400
         ARRAY(IV1) = THREE                                             00518500
         IF (IV.GT.IV1) CALL MOVE (1,ARRAY(IV1+1),ARRAY(IV1),IV-IV1)    00518600
C                                                                       00518700
 250     WRITE (IPR,280) IGI,ARRAY                                      00518800
 280     FORMAT (1X,I5,1X,'+',119A1,'+')                                00518900
         CALL MOVE (2,ARRAY,0,119)                                      00519000
 300  CONTINUE                                                          00519100
C                                                                       00519200
 330  WRITE (IPR,30)                                                    00519300
      WRITE (IPR,350) ONE,TWO,THREE                                     00519400
 350  FORMAT ('0',20X,A1,' = LAYER 1',5X,A1,' = LAYER 2',               00519500
     $             5X,A1,' = LAYER 3')                                  00519600
      RETURN                                                            00519700
      END                                                               00519800
C  ROUTINE:       TRAVPR                                                00519900
C  ROUTINE TYPE:  SUBROUTINE                                            00520000
C  PURPOSE:  PRINT TRAVERSE DISPLAY                                     00520100
C  AUTHOR:  DOUGLAS BODDY                                               00520200
C  DATE WRITTEN:  AUGUST 1985                                           00520300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00520400
C                                                                       00520500
      SUBROUTINE TRAVPR (CARD,IPR,IDSK1,ZNX1ST,NLOC,XGRINT,SHTMOV,      00520600
     $                   TRAVMN,TRAVMX,ARRAY,                           00520700
     $                   UNIT,RAD,SPINC)                                00520800
C                                                                       00520900
      DOUBLE PRECISION RAD                                              00521000
      character*8 UNIT
cmam  DOUBLE PRECISION UNIT                                             00521100
C                                                                       00521200
	character*80 kard
      character*4   SPAR, card(20),idcrd
c.c.c.c.c.c.	equivalence (card(1),kard)
cmam  INTEGER   SPAR/'SPAR'/                                            00521300
cmam  INTEGER   CARD(20)                                                00521400
C                                                                       00521500
      INTEGER*2 NUMBRE(23)
      character*1 ISPA,ISPNA
cmam  INTEGER*2 ISPA,ISPNA                                              00521800
      character*1 IAST,SPACE
cmam  INTEGER*2 IAST/'* '/,SPACE/'  '/                                  00521900
C                                                                       00522000
      LOGICAL EOF
cmam  LOGICAL*1 EX/'X'/,OH/'O'/,BOTH/'#'/,ARRAY(111),SPACE1             00522200
cmam  LOGICAL*1 DOT/'.'/,DOLLAR/'$'/                                    00522300
      character*1 EX,OH,BOTH,ARRAY(111),SPACE1
      character*1 DOT,DOLLAR
C                                                                       00522400
      EQUIVALENCE (SPACE,SPACE1)                                        00522500
C                                                                       00522600
      data NUMBRE/55,50,45,40,35,30,25,20,15,10, 5,0,
     $                      5,10,15,20,25,30,35,40,45,50,55/
      data IAST/'*'/,SPACE/' '/
      data EOF/.FALSE./
      data EX/'X'/,OH/'O'/,BOTH/'#'/
      data DOT/'.'/,DOLLAR/'$'/
      DATA NCARD/0/                                                     00522700
      DATA LFLAG/0/                                                     00522800
      DATA L/1/                                                         00522900
      DATA NXIRI/-99999/,LRI/99999/                                     00523000
	data SPAR/'SPAR'/
C                                                                       00523100
	call move (1,kard,card,80)
      TRMX = TRAVMX - BUF(1,4)                                          00523200
      TRMN = BUF(1,4) - TRAVMN                                          00523300
      IUPS = 1                                                          00523400
      IF (TRMX.GT.55.OR.TRMN.GT.55) IUPS = 10                           00523500
      IF (TRMX.GT.550.OR.TRMN.GT.550) IUPS = 100                        00523600
      UPS = IUPS                                                        00523700
C                                                                       00523800
      WRITE (IPR,10)                                                    00523900
 10   FORMAT ('1',T53,'T R A V E R S E   P L O T'///)                   00524000
      WRITE (IPR,20) IUPS,UNIT,NUMBRE                                   00524100
 20   FORMAT (20X,'EACH SPACE =',I5,A8/                                 00524200
     $        11X,23I5/                                                 00524300
     $        4X,'GI    SP   ',22('O****'),'O')                         00524400
C                                                                       00524500
      CALL MOVE (2,ARRAY,0,111)                                         00524600
      REWIND IDSK1                                                      00524700
C                                                                       00524800
 100  READ (IDSK1,110) CARD,IDCRD                                       00524900
 110  FORMAT (20A4,T1,1X,A4)                                            00525000
      IF (IDCRD .NE. SPAR) GO TO 100                                    00525100
C                                                                       00525200
      XGRP = ZNX1ST + 0.5                                               00525300
      NLOC2 = NLOC * 2 - 1                                              00525400
C                                                                       00525500
      DO 400 I=1,NLOC2                                                  00525600
         XGRP = XGRP + 0.5                                              00525700
         ZGRP = AINT(XGRP)                                              00525800
         IGRP = ZGRP                                                    00525900
         ARRAY(56) = DOT                                                00526000
         ZZ = XGRP - ZNX1ST                                             00526100
         II = ZZ                                                        00526200
         IF (FLOAT(II).NE.ZZ) GO TO 140                                 00526300
C                                                                       00526400
         XX = (BUF(II,4) - BUF(1,4)) / UPS                              00526500
         K = IFIX(XX + SIGN(0.5,XX)) + 56                               00526600
C                                                                       00526700
         IF ( K .GE. 1 .AND. K .LE. 111 ) GO TO 130                     00526800
            IF ( K .LT. 1 ) K = 1                                       00526900
            IF ( K .GT. 111 ) K = 111                                   00527000
            ARRAY(K) = DOLLAR                                           00527100
            GO TO 140                                                   00527200
C                                                                       00527300
 130     ARRAY(K) = EX                                                  00527400
C                                                                       00527500
 140     IF (LFLAG.EQ.1) GO TO 275                                      00527600
         IF (EOF) GO TO 300                                             00527700
         LRI = LRI + 1                                                  00527800
         IF (LRI.GE.NXIRI) GO TO 170                                    00527900
         SRCLOC = SRCLOC + SHTMOV                                       00528000
         ISPA = SPACE                                                   00528100
         SPN = SPNN + SPINC                                             00528200
         SPNN = SPN                                                     00528300
         OFFDIS = 0.0                                                   00528400
         GO TO 215                                                      00528500
C                                                                       00528600
 170     NCARD = NCARD + 1                                              00528700
C=======================================================================00528800
cmam     CALL STRING (CARD,80)                                          00529200
cmam     READ (99,180)     ZLSLOC,OFFDIS,OFFANG,ISPNN,ISPNA,LRI         00529300
	read(kard,180) ZLSLOC,OFFDIS,OFFANG,ISPNN,ISPNA,LRI
cmam	read(card,180) ZLSLOC,OFFDIS,OFFANG,ISPNN,ISPNA,LRI
C=======================================================================00529500
 180     FORMAT           (5X,F6.0,28X,F5.0,F4.0,I5,A1,21X,I5)          00529600
         ISPA = ISPNA                                                   00529700
C                                                                       00529800
         IF ( ISPNN .GE. 0 ) GO TO 182                                  00529900
            WRITE(IPR,181) ISPNN                                        00530000
 181        FORMAT ('0**M7005** ERROR DETECTED BY SUBROUTINE TRAVPR:'/  00530100
     $              13X,'SHOT POINT NUMBER IN CC 49-53 OF 1SPAR CARD',  00530200
     $              13X,I6,'MUST BE GREATER THAN ZERO.  CORRECT',       00530300
     $              13X,'PARAMETER AND RESUBMIT.',/)                    00530400
         ICC = 100                                                      00530500
C                                                                       00530600
 182     IF (ISPNN.NE.0) GO TO 186                                      00530700
         IF (NCARD.NE.1) GO TO 185                                      00530800
         SPNN = 1.                                                      00530900
         GO TO 187                                                      00531000
C                                                                       00531100
 185     SPNN = SPNN + SPINC                                            00531200
         GO TO 187                                                      00531300
C                                                                       00531400
 186     SPNN = ISPNN                                                   00531500
C                                                                       00531600
 187     IF (ISPA.NE.IAST) GO TO 188                                    00531700
         ISPA = SPACE                                                   00531800
         SPN = 0.                                                       00531900
         GO TO 190                                                      00532000
C                                                                       00532100
 188     SPN = SPNN                                                     00532200
C                                                                       00532300
 190     READ (IDSK1,200,END=250) CARD,IDCRD                            00532400
 200     FORMAT (20A4,T1,1X,A4)                                         00532500
         IF (IDCRD .NE. SPAR) GO TO 190                                 00532600
C=======================================================================00532700
cmam     CALL STRING (CARD,80)                                          00533100
cmam     READ (99,205)     NXIRI                                        00533200
	read(kard,205)  NXIRI
cmam	read(card,205)  NXIRI
C=======================================================================00533400
 205     FORMAT (75X,I5)                                                00533500
C                                                                       00533600
C     **********************************                                00533700
C     | RESET SRCLOC TO REFLECT OFFDIS |                                00533800
C     **********************************                                00533900
C                                                                       00534000
 207     YDIS = 0.0                                                     00534100
         SRCLOC = ZLSLOC                                                00534200
         IF ( OFFDIS .EQ. 0.0 ) GO TO 215                               00534300
         X = DBLE(OFFANG) * RAD                                         00534400
         XDIS =  COS(X) * OFFDIS                                        00534500
         YDIS = -SIN(X) * OFFDIS                                        00534600
         IXDIS = XDIS + SIGN(0.5,XDIS)                                  00534700
         XDGR = FLOAT(IXDIS) / XGRINT                                   00534800
         SRCLOC = ZLSLOC + XDGR                                         00534900
C                                                                       00535000
 215     XLOC = SRCLOC - ZNX1ST                                         00535100
         ACTLOC = SRCLOC - ZNX1ST                                       00535200
C                                                                       00535300
 230     FI = AINT(XLOC)                                                00535400
         II = INT(XLOC)                                                 00535500
         TRAV = BUF(II,4)                                               00535600
         IF (FI.EQ.XLOC) GO TO 240                                      00535700
         IF (II.GE.NLOC) GO TO 240                                      00535800
         IF (TRAV.EQ.BUF(II+1,4)) GO TO 240                             00535900
         TRAV = TRAV + (BUF(II+1,4) - TRAV) * (ACTLOC - FI)             00536000
C                                                                       00536100
 240     TRAV = TRAV + YDIS                                             00536200
         XX = (TRAV - BUF(1,4)) / UPS                                   00536300
         L = IFIX(XX + SIGN(0.5,XX)) + 56                               00536400
C                                                                       00536500
         IF ( L .GE. 1 .AND. L .LE. 111 ) GO TO 245                     00536600
            IF ( L .LT. 1 ) L = 1                                       00536700
            IF ( L .GT. 111 ) L = 111                                   00536800
            ARRAY(L) = DOLLAR                                           00536900
 245     LFLAG = 1                                                      00537000
         GO TO 275                                                      00537100
C                                                                       00537200
 250     EOF = .TRUE.                                                   00537300
         GO TO 207                                                      00537400
C                                                                       00537500
 275     IF (ACTLOC.GE.XGRP-0.25) GO TO 276                             00537600
         LFLAG = 0                                                      00537700
         GO TO 140                                                      00537800
C                                                                       00537900
 276     IF (ACTLOC.GT.XGRP+0.25) GO TO 300                             00538000
C=======================================================================00538100
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================00538200
C=============================           ===============================00538300
         IF (ARRAY(L).NE.EX .AND. ARRAY(L).NE.DOLLAR) GO TO 278         00538400
C        IF (ARRAY(L).NEQV.EX .AND. ARRAY(L).NEQV.DOLLAR) GO TO 278     00538500
C=======================================================================00538600
C=======================================================================00538700
         ARRAY(L) = BOTH                                                00538800
         GO TO 279                                                      00538900
C                                                                       00539000
 278     ARRAY(L) = OH                                                  00539100
C                                                                       00539200
 279     LFLAG = 0                                                      00539300
C                                                                       00539400
 280     ISPN = SPN                                                     00539500
         IF (FLOAT(ISPN).NE.SPN.OR.SPN.EQ.0.0) GO TO 300                00539600
         IF (ZGRP.NE.XGRP) GO TO 290                                    00539700
         WRITE (IPR,285) IGRP,ISPN,ISPA,ARRAY                           00539800
 285     FORMAT (1X,I5,1X,I5,A1,2X,111A1)                               00539900
         GO TO 350                                                      00540000
C                                                                       00540100
 290     WRITE (IPR,295) ISPN,ISPA,ARRAY                                00540200
 295     FORMAT (7X,I5,A1,2X,111A1)                                     00540300
         GO TO 350                                                      00540400
C                                                                       00540500
 300     IF (ZGRP.NE.XGRP) GO TO 330                                    00540600
         WRITE (IPR,320) IGRP,ARRAY                                     00540700
 320     FORMAT (1X,I5,9X,111A1)                                        00540800
         GO TO 350                                                      00540900
C                                                                       00541000
 330     WRITE (IPR,340) ARRAY                                          00541100
 340     FORMAT (15X,111A1)                                             00541200
C                                                                       00541300
 350     ARRAY(K) = SPACE1                                              00541400
         ARRAY(L) = SPACE1                                              00541500
 400  CONTINUE                                                          00541600
C                                                                       00541700
      WRITE (IPR,960) EX,OH,BOTH                                        00541800
 960  FORMAT (15X,22('O****'),'O'/                                      00541900
     $        20X,'LEGEND:  ',A1,' = GROUP TRAVERSE OFFSET',            00542000
     $                     5X,A1,' = SOURCE TRAVERSE OFFSET'/           00542100
     $                    29X,A1,' = GROUP AND SOURCE TRAVERSE OFFSET') 00542200
      RETURN                                                            00542300
      END                                                               00542400
C  ROUTINE:       GO4IT                                                 00542500
C  ROUTINE TYPE:  SUBROUTINE                                            00542600
C  PURPOSE:  PROCESS INPUT TAPE, UPDATE TRACE HEADERS, OUTPUT TRACES.   00542700
C  AUTHOR:  DOUGLAS BODDY                                               00542800
C  DATE WRITTEN:  AUGUST 1985                                           00542900
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00543000
C                                                                       00543100
      SUBROUTINE GO4IT (ZDIST,SHTMOV,TERVAL,                            00543200
     $                  IDCRD,NTAP,OTAP,IUNSCP,IUNSCF,NREC,NUMDEV,      00543300
     $                  IFSP,IRECP,MAXTRC,LINE,IOAC,                    00543400
     $                  KTR,SPINC,IBSCOR,ISYS,                          00543500
     $                  MODEPR,IBFLAG,METENG,PLTFLG,                    00543600
     $                  MOVFL1,SPLTFL,SAVEPERM)
C                                                                       00543800
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
	integer savelu,status,length,iform
      DOUBLE PRECISION RAD                                              00543900
      character*7 ENGMET(2),UNITDS, jobno
cmam  DOUBLE PRECISION ENGMET(2),UNITDS                                 00544000
C                                                                       00544100
cmam  DIMENSION DIST(8192)                                              00544200
      DIMENSION ZDIST(7)                                                00544300
cmam  DIMENSION SAVE(8192,3)                                            00544400
	real dist(1), save1(1),save2(1),save3(1)
	integer*2 isave1(1),isave2(1),isave3(1)
	pointer (ipdist,dist),(ipsav1,save1),(kpsav1,isave1)
	pointer (ipsav2,save2),(ipsav3,save3),(kpsav2,isave2),
     *		(kpsav3,isave3)
C=======================================================================00544500
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================00544600
C=============================           ===============================00544700
      INTEGER   IAVAIL(4),IADD(4)
C=======================================================================00544900
C=======================================================================00545000
C                                                                       00545100
      INTEGER   OTAP
	character*4 spar,tdis,idcrd
cmam  INTEGER   SPAR,TDIS,OTAP                                          00545200
cmam  INTEGER   ERRMES(10)/' ** ','ERRO','R DE','TECT','ED B','Y SU',   00545300
      character*4 ERRMES(10)
C                                                                       00545500
      INTEGER*2 PLTFLG(4),IPF2                                          00545600
      INTEGER*2 KTR(7)                                                  00545700
      INTEGER*2 IBUF2(128)                                              00545800
      INTEGER*2 NMCRD,IBSCOR,MODEPR,METENG
	integer ibflag
cmam  INTEGER*2 NMCRD,IBSCOR,MODEPR,IBFLAG,METENG                       00545900
      INTEGER*2 ISYS
	integer ibias,ihspd,ihsp
cmam  INTEGER*2 IBIAS,IHSPD,IHSP,ISYS                                   00546000
cmam  INTEGER*2 ISPNA,ISPNB,ISPNC                                       00546100
cmam  INTEGER*2 IBL2/'  '/                                              00546200
cmam  INTEGER*2 IAST/'* '/                                              00546300
	character*4 iholch,ibl4,card
	character*80 kard
	character*1 ispna,ispnb,ispnb1,ispnb2,ibl1,iast,ispnc
	character*1 ibl2, bchar
cmam  INTEGER*2 ISAVE(8192,3)                                           00546400
      INTEGER*2 HALFWD,IH109,IH109D                                     00546500
C                                                                       00546600
      LOGICAL FOUND,NOPRNT
      LOGICAL EOT,EOF
      LOGICAL IFIRST,IRCRD1
      LOGICAL MOVFL1,SPLTFL,INOMFL
      LOGICAL TRACFL
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL SAVEPERM
cmam  LOGICAL*1 ISPNB1,ISPNB2                                           00547300
cmam  LOGICAL*1 IBL1                                                    00547400
	integer jspbuf(1)
	pointer (kspbuf,jspbuf)
C                                                                       00547500
      EQUIVALENCE (IBUF4(1),IBUF2(1))                                   00547600
      EQUIVALENCE (ISPNB,ISPNB1)                                        00547700
      EQUIVALENCE (IBL2,IBL1)                                           00547800
C                                                                       00547900
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
	equivalence (card(1),kard)
C                                                                       00548500
      DATA IBL4/'    '/                                                 00548600
      DATA DEPHOL/0.0/                                                  00548700
      DATA NZERO/0/,LZERO/0/                                            00548800
      DATA JRECP/0/                                                     00548900
      DATA IRI/-99999/                                                  00549000
      DATA SPN/-99999./                                                 00549100
      DATA ISPNB/' '/
cmam  DATA ISPNB/0/                                                     00549200
      DATA NCARD/0/                                                     00549300
      DATA LCN/0/                                                       00549400
      DATA ENGMET/'ENGLISH','METRIC '/                                   00549500
      DATA XCVTDI/2./                                                   00549600
      DATA IEOS/0/                                                      00549700
      DATA YDIS/0.0/                                                    00549800
      data IAVAIL/4*0/,IADD/4*0/
      data ERRMES/' ** ','ERRO','R DE','TECT','ED B','Y SU',
     $                     'BROU','TINE',' GO4','IT: '/
	data iast/'*'/,ibl2/' '/
	data FOUND/.FALSE./,NOPRNT/.FALSE./,EOT/.FALSE./,EOF/.FALSE./,
     *		IFIRST/.TRUE./,IRCRD1/.TRUE./
C                                                                       00549900
cmam.........dynamically allocate arrays.....6-20-94
	iwant = maxtrc * szsmpd
	call galloc(ipdist,iwant,ierrcd,abort)
	if(ierrcd.ne.0) then
	   write(LERR,*)'ERROR: '
           write(LERR,*) 'Unable to allocate workspace for DIST'
           write(LERR,*) 'FATAL'
           ICC = 100
           GO TO 9999
        endif
cmam..................................................
        iwant = iwant * 3
        call galloc(ipsav1,iwant,ierrcd,abort)
        if(ierrcd.ne.0) then
           write(LERR,*)'ERROR: '
           write(LERR,*) 'Unable to allocate workspace for SAVE'
           write(LERR,*) 'FATAL'
           ICC = 100
           GO TO 9999
        endif
	ipsav2 = ipsav1 + maxtrc*szsmpd
	ipsav3 = ipsav2 + maxtrc*szsmpd
cmam..................................................
        iwant = maxtrc * szhfwd * 3
        call galloc(kpsav1,iwant,ierrcd,abort)
        if(ierrcd.ne.0) then
           write(LERR,*)'ERROR: '
           write(LERR,*) 'Unable to allocate workspace for ISAVE'
           write(LERR,*) 'FATAL'
           ICC = 100
           GO TO 9999
        endif
	kpsav2 = kpsav1 + maxtrc*szhfwd
	kpsav3 = kpsav2 + maxtrc*szhfwd
cmam..................................................
c.....................
	kspbuf = indxsp
	status = savelu('RecNum',iform,l_RecNum,length,TRACEHEADER)
	status = savelu('TrcNum',iform,l_TrcNum,length,TRACEHEADER)
	status = savelu('DatShf',iform,l_DatShf,length,TRACEHEADER)
	status = savelu('ToTmAU',iform,l_ToTmAU,length,TRACEHEADER)
	status = savelu('ShtDep',iform,l_ShtDep,length,TRACEHEADER)
	status = savelu('UphlTm',iform,l_UphlTm,length,TRACEHEADER)
	status = savelu('SrPtEl',iform,l_SrPtEl,length,TRACEHEADER)
	status = savelu('GrpElv',iform,l_GrpElv,length,TRACEHEADER)
	status = savelu('DePtEl',iform,l_DePtEl,length,TRACEHEADER)
	status = savelu('RfSrEl',iform,l_RfSrEl,length,TRACEHEADER)
	status = savelu('PerSPO',iform,l_PerSPO,length,TRACEHEADER)
	status = savelu('InlSPO',iform,l_InlSPO,length,TRACEHEADER)
        if (.not. saveperm) then
	  status = savelu('PrRcNm',iform,l_PrRcNm,length,TRACEHEADER)
	  status = savelu('PrTrNm',iform,l_PrTrNm,length,TRACEHEADER)
        endif
	status = savelu('DstUsg',iform,l_DstUsg,length,TRACEHEADER)
	status = savelu('DstSgn',iform,l_DstSgn,length,TRACEHEADER)
	status = savelu('RecInd',iform,l_RecInd,length,TRACEHEADER)
	status = savelu('DphInd',iform,l_DphInd,length,TRACEHEADER)
	status = savelu('SrcPnt',iform,l_SrcPnt,length,TRACEHEADER)
	status = savelu('SoPtNm',iform,l_SoPtNm,length,TRACEHEADER)
	status = savelu('StaCor',iform,l_StaCor,length,TRACEHEADER)
	status = savelu('SrcLoc',iform,l_SrcLoc,length,TRACEHEADER)
	status = savelu('SoPtAl',iform,l_SoPtAl,length,TRACEHEADER)
	status = savelu('SoPtBi',iform,l_SoPtBi,length,TRACEHEADER)
cmam.............6-20-94...put in x,y coords and midpt coords
cmam.......note that these are LONG words (use ibuf4)
        status = savelu('SrPtXC',iform,l_SrPtXC,length,TRACEHEADER)
        status = savelu('SrPtYC',iform,l_SrPtYC,length,TRACEHEADER)
        status = savelu('RcPtXC',iform,l_RcPtXC,length,TRACEHEADER)
        status = savelu('RcPtYC',iform,l_RcPtYC,length,TRACEHEADER)
        status = savelu('SrRcMX',iform,l_SrRcMX,length,TRACEHEADER)
        status = savelu('SrRcMY',iform,l_SrRcMY,length,TRACEHEADER)
cmam.............6-20-94
c.............
	do 11 ii = 1,4
   11	iadd(ii) = 0
c.............
      J = INOMUN                                                        00550000
C                                                                       00550100
      DO 20 I=1,4                                                       00550200
         IF (INOMCT(I).LE.0) GO TO 10                                   00550300
         ENDFILE J                                                      00550400
         REWIND J                                                       00550500
         INOMFL = .TRUE.                                                00550600
 10      J = J + 1                                                      00550700
 20   CONTINUE                                                          00550800
C                                                                       00550900
      IF (.NOT.INOMFL) GO TO 30                                         00551000
C=======================================================================00551100
      CALL INOMCV (IADD,IAVAIL)                                         00551500
C=======================================================================00551700
      IF (ICC.NE.0) GO TO 9850                                          00551800
C                                                                       00551900
 30   IF (.NOT.MOVFL1) XCVTDI = 4.                                      00552000
      ZNX1ST = INX1ST                                                   00552100
      IPF2 = PLTFLG(2) + 1                                              00552200
      IF (SPINC.LT.0.) SPN = 99999                                      00552300
      UNITDS = ENGMET(METENG+1)                                         00552400
      REWIND IDSK1                                                      00552500
C                                                                       00552600
      READ (IDSK1,100) CARD,NMCRD,IDCRD,JOBNO                           00552700
      GO TO 200                                                         00552800
C                                                                       00552900
C     +------------------------------------------+                      00553000
C     |        READ 1SPAR OR 8TDIS CARD          |                      00553100
C     +------------------------------------------+                      00553200
C                                                                       00553300
 50   READ (IDSK1,100,END=450) CARD,NMCRD,IDCRD,JOBNO                   00553400
 100  FORMAT (20A4,T1,I1,A4,T69,A7)                                     00553500
      IF (IDCRD .EQ. SPAR) GO TO 500                                    00553600
      IF (IDCRD .EQ. TDIS) GO TO 300                                    00553700
      GO TO 50                                                          00553800
C                                                                       00553900
C     +------------------------------------------+                      00554000
C     |            DECODE 1SPAR CARD             |                      00554100
C     +------------------------------------------+                      00554200
C                                                                       00554300
 200  NZERO = 0                                                         00554400
      LZERO = 0                                                         00554500
      TRACFL = .FALSE.                                                  00554600
      CALL MOVE (0,DIST,0,maxtrc*SZSMPD)
cmam  CALL MOVE (0,DIST,0,8192*SZSMPD)
cmam  CALL MOVE (0,DIST,0,4096)                                         00554700
      NCARD = NCARD + 1                                                 00554800
      XLOCSA = XLCTRA                                                   00554900
      XLOCSB = XLCTRB                                                   00555000
      LOCSC = LTBG                                                      00555100
      XLOCSD = XLLTBG                                                   00555200
      LOCSE = IFTAG                                                     00555300
      XLOCSF = XLFTAG                                                   00555400
      LRIS = LRI                                                        00555500
C=======================================================================00555600
cmam  CALL STRING (CARD,80)                                             00556200
cmam  READ (99,250)     ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,  00556300
	read(kard,250)  ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,
cmam	read(card,250)  ZLSLOC,LOCTRA,LOCTRB,LTBG,LCLTBG,IFTAG,LCFTAG,
     $                  OFFDIS,OFFANG,ISPNN,ISPNA,                      00556400
     $                  HOLDEP,IBSCOR,LRI,IHOLCH                        00556500
C=======================================================================00556700
 250  FORMAT           (5X,F6.0,2I5,I4,I5,I4,I5,                        00556800
     $                  F5.0,F4.0,I5,A1,                                00556900
     $                  F4.0,6X,I4,7X,I5,T55,A4)                        00557000
C                                                                       00557100
      SPNN = ISPNN                                                      00557200
      IF (IHOLCH.NE.IBL4) DEPHOL = HOLDEP                               00557300
cmam....do not know why this default was set to 10, so as of 7-7-94
cmam..... the default is zero.  this allows the uphole time input to
cmam..... be what is put in the trace header (request of mike o'brien)
cmam  IF (UPHOFF.EQ.0.0) UPHOFF = 10.                                   00557400
C                                                                       00557500
      IF (NCARD.LE.1) GO TO 270                                         00557600
      IF (SPNN.EQ.0.) SPNN = SPN + SPINC                                00557700
C                                                                       00557800
 252  ZIII = FLOAT(LRI - LRIS) * SHTMOV                                 00557900
      IF (LOCTRA.NE.0.OR.LOCTRB.NE.0) GO TO 255                         00558000
      XLCTRA = XLOCSA + ZIII                                            00558100
      LOCTRA = XLCTRA                                                   00558200
      XLCTRB = XLOCSB + ZIII                                            00558300
      LOCTRB = XLCTRB                                                   00558400
      GO TO 260                                                         00558500
C                                                                       00558600
 255  XLCTRA = LOCTRA                                                   00558700
      XLCTRB = LOCTRB                                                   00558800
C                                                                       00558900
 260  IF (LTBG.NE.0.OR.LCLTBG.NE.0.OR.IFTAG.NE.0.OR.LCFTAG.NE.0)        00559000
     $    GO TO 265                                                     00559100
      LTBG = LOCSC                                                      00559200
      XLLTBG = XLOCSD + ZIII                                            00559300
      LCLTBG = XLLTBG                                                   00559400
      IFTAG = LOCSE                                                     00559500
      XLFTAG = XLOCSF + ZIII                                            00559600
      LCFTAG = XLFTAG                                                   00559700
      GO TO 50                                                          00559800
C                                                                       00559900
 265  XLLTBG = LCLTBG                                                   00560000
      XLFTAG = LCFTAG                                                   00560100
      GO TO 50                                                          00560200
C                                                                       00560300
 270  IF (SPNN.EQ.0.) SPNN = 1.                                         00560400
      XLCTRA = LOCTRA                                                   00560500
      XLCTRB = LOCTRB                                                   00560600
      XLLTBG = LCLTBG                                                   00560700
      XLFTAG = LCFTAG                                                   00560800
      GO TO 50                                                          00560900
C                                                                       00561000
C     +------------------------------------------+                      00561100
C     |            DECODE 8TDIS CARD             |                      00561200
C     +------------------------------------------+                      00561300
C                                                                       00561400
 300  CONTINUE                                                          00561500
C=======================================================================00561600
cmam  CALL STRING (CARD,80)                                             00562000
cmam  READ (99,350)     (KTR(I),ZDIST(I),I=1,7)                         00562100
	read(kard,350) (KTR(I),ZDIST(I),I=1,7)
cmam	read(card,350) (KTR(I),ZDIST(I),I=1,7)
C=======================================================================00562300
 350  FORMAT (5X,7(I4,F5.0))                                            00562400
C                                                                       00562500
      DO 400 I=1,7                                                      00562600
         IF (KTR(I).GT.0) DIST(KTR(I)) = ZDIST(I)                       00562700
 400  CONTINUE                                                          00562800
C                                                                       00562900
      TRACFL = .TRUE.                                                   00563000
      GO TO 50                                                          00563100
C                                                                       00563200
 450  EOF = .TRUE.                                                      00563300
      NXIRI = 99999                                                     00563400
      GO TO 600                                                         00563500
C                                                                       00563600
C     +------------------------------------------+                      00563700
C     |     GET RECORD INDEX FROM 'NEXT' CARD    |                      00563800
C     +------------------------------------------+                      00563900
C                                                                       00564000
 500  CONTINUE                                                          00564100
C=======================================================================00564200
cmam  CALL STRING (CARD,80)                                             00564600
cmam  READ (99,550)     NXIRI                                           00564700
	read(kard,550) NXIRI
cmam	read(card,550) NXIRI
C=======================================================================00564900
 550  FORMAT (75X,I5)                                                   00565000
C                                                                       00565100
 600  IF (FOUND) GO TO 900                                              00565200
 700  N = 0                                                             00565300
      CALL RTAPE (NTAP,IBUF4,N)                                         00565400
      IF (N.EQ.0) GO TO 850                                             00565500
      IF (IRI.EQ.IBUF2(l_RecNum)) GO TO 800
cmam  IF (IRI.EQ.IBUF2(106)) GO TO 800                                  00565600
      IF (IRI.EQ.-99999) GO TO 750                                      00565700
      IRECP = IRECP + 1                                                 00565800
      JRECP = IRECP                                                     00565900
 750  IRI = IBUF2(l_RecNum)
c750  IRI = IBUF2(106)                                                  00566000
 800  IF (LRI.NE.IBUF2(l_RecNum) .AND. LRI.NE.0) GO TO 700
c800  IF (LRI.NE.IBUF2(106) .AND. LRI.NE.0) GO TO 700                   00566100
      GO TO 890                                                         00566200
C                                                                       00566300
 850  IF (IRI.EQ.-99999) GO TO 870                                      00566400
      IRECP = IRECP + 1                                                 00566500
 870  WRITE (IPR,880) ERRMES                                            00566600
 880  FORMAT ('0** M7010',10A4/                                         00566700
     $ 13X,'RECORD INDEX ON FIRST "1SPAR" CARD WAS NOT FOUND ON ',      00566800
     $     'INPUT TAPE')                                                00566900
      ICC = 100                                                         00567000
      GO TO 9850                                                        00567100
C                                                                       00567200
 890  FOUND = .TRUE.                                                    00567300
C                                                                       00567400
 900  SHTMVT = 0                                                        00567500
C                                                                       00567600
      IF (MODEPR.EQ.2) GO TO 960                                        00567700
C                                                                       00567800
      IF (OFFDIS.NE.0.0) GO TO 930                                      00567900
      IXDIS = 0                                                         00568000
      IYDIS = 0                                                         00568100
      XDGR = 0.                                                         00568200
      GO TO 960                                                         00568300
C                                                                       00568400
 930  X = DBLE(OFFANG) * RAD                                            00568500
      XDIS =  COS(X) * OFFDIS                                           00568600
      YDIS = -SIN(X) * OFFDIS                                           00568700
      IXDIS = XDIS + SIGN(0.5,XDIS)                                     00568800
      IYDIS = YDIS + SIGN(0.5,YDIS)                                     00568900
      XDGR = FLOAT(IXDIS) / XGRINT                                      00569000
C                                                                       00569100
 960  IF (.NOT.TRACFL) GO TO 970                                        00569200
      CALL INTDIS (DIST,NTPR,IPR,ICC)                                   00569300
      IF (ICC.NE.0) GO TO 9850                                          00569400
C                                                                       00569500
 970  IF (SPNN.NE.SPN) GO TO 1150                                       00569600
      IF (ISPNA.NE.ISPNB) GO TO 1150                                    00569700
      WRITE (IPR,1000) ERRMES,SPN,ISPNB,SPNN,ISPNA                      00569800
 1000 FORMAT ('0** M7020',10A4/                                         00569900
     $ 13X,'SHOT POINT NUMBER ON PREVIOUS RECORD WAS ',F7.0,1X,A1/      00570000
     $ 13X,'SHOT POINT NUMBER FOR CURRENT RECORD ',                     00570100
     $     'FROM "1SPAR" CARD IS ',F7.0,1X,A1)                          00570200
      ICC = 100                                                         00570300
      GO TO 9850                                                        00570400
C                                                                       00570500
 1150 SPN = SPNN                                                        00570600
C                                                                       00570700
C     ******************************                                    00570800
C     |  OFFSET SRCLOC BY OFFDIS   |                                    00570900
C     ******************************                                    00571000
C                                                                       00571100
      SRCLOC = ZLSLOC + XDGR                                            00571200
      ISPNB = ISPNA                                                     00571300
      LOCA = LOCTRA                                                     00571400
      LOCB = LOCTRB                                                     00571500
      LOCL = LCLTBG                                                     00571600
      LOCF = LCFTAG                                                     00571700
      GO TO 1250                                                        00571800
C                                                                       00571900
C     +------------------------------------------+                      00572000
C     |   START OF LOOP TO PROCESS ALL RECORDS   |                      00572100
C     |   FROM ONE 1SPAR CARD TO THE NEXT        |                      00572200
C     +------------------------------------------+                      00572300
C                                                                       00572400
 1200 SPN = SPN + SPINC                                                 00572500
      IF ( SPN .GT. 0 ) GO TO 1225                                      00572600
         WRITE(IPR,251) ERRMES, SPN                                     00572700
C                                                                       00572800
 251     FORMAT ('0** M7007',10A4/                                      00572900
     $           13X,'GENERATED SHOT POINT NUMBER,',F10.4,' ,',/        00573000
     $           13X,'MUST BE GREATER THAN ZERO.  CHECK',/              00573100
     $           13X,'SHOT LABEL INCREMENT AND SHOT POINT NUMBER',/     00573200
     $           13X,'ON INPUT.  CORRECT AND RESUBMIT.',/)              00573300
         CALL LBCLOS ( OTAP )                                           00573400
         CALL CCEXIT ( 100 )                                            00573500
C                                                                       00573600
 1225 ISPNB = IBL2                                                      00573700
      IXDIS = 0                                                         00573800
      IYDIS = 0                                                         00573900
      XDGR = 0                                                          00574000
      SRCLOC = SRCLOC + SHTMOV                                          00574100
      SHTMVT = SHTMVT + SHTMOV                                          00574200
      LOCA = XLCTRA + SHTMVT                                            00574300
      LOCB = XLCTRB + SHTMVT                                            00574400
      LOCL = XLLTBG + SHTMVT                                            00574500
      LOCF = XLFTAG + SHTMVT                                            00574600
C                                                                       00574700
 1250 IF (SRCLOC-ZNX1ST.GT.NLOC .OR.                                    00574800
     $    LOCA-INX1ST.GT.NLOC .OR.                                      00574900
     $    LOCB-INX1ST.GT.NLOC) GO TO 1300                               00575000
C                                                                       00575100
      LD = 0                                                            00575200
      INDX = INT(SRCLOC) - INX1ST                                       00575300
      IF (AINT(SRCLOC).EQ.SRCLOC) GO TO 1350                            00575400
      IF (INDX.EQ.NLOC) GO TO 1350                                      00575500
      IF (BUF(INDX+1,2).EQ.BUF(INDX,2)) GO TO 1350                      00575600
      IF (MODEPR.NE.0 .AND. BUF(INDX,2).EQ.ZMISS) GO TO 1360            00575700
      ZFCTR = SRCLOC - AINT(SRCLOC)                                     00575800
      BFF = BUF(INDX,2)                                                 00575900
      DIS112 = (BUF(INDX+1,2) - BFF) * ZFCTR + BFF                      00576000
      GO TO 1450                                                        00576100
C                                                                       00576200
 1300 IGLAST = IGNDXS + NLOC - 1                                        00576300
      WRITE (IPR,1310) ERRMES,SRCLOC,LOCA,NTPR,LOCB,IRI,IGNDXS,IGLAST   00576400
 1310 FORMAT ('0** M7030',10A4/                                         00576500
     $ 13X,'SOURCE LOCATION =',F7.1,', LOCATION OF TRACE 1 =',I6,       00576600
     $     ', AND LOCATION OF TRACE ',I4,' =',I6,'  FOR RI',I5/         00576700
     $ 13X,'VALID LOCATIONS RANGE FROM',I6,' TO',I6/                    00576800
     $ 13X,'GI''S MUST BE DEFINED VIA "GPAR" CARDS')                    00576900
      ICC = 100                                                         00577000
      GO TO 9850                                                        00577100
C                                                                       00577200
 1350 IF (MODEPR.EQ.0 .OR. BUF(INDX,2).NE.ZMISS) GO TO 1400             00577300
C                                                                       00577400
 1360 DIS112 = IBUF2(l_SrPtEl)
c1360 DIS112 = IBUF2(112)                                               00577500
      GO TO 1450                                                        00577600
C                                                                       00577700
 1400 DIS112 = BUF(INDX,2)                                              00577800
C                                                                       00577900
 1450 LOC = LOCA                                                        00578000
cmam.....uphole time is associated with the SOURCE, not the GROUP
	iuptm = BUF(Indx,13) + 0.5
cmam.............................................................
C                                                                       00578100
C     +------------------------------------------+                      00578200
C     |    GET COORDINATES OF SOURCE LOCATION    |                      00578300
C     +------------------------------------------+                      00578400
C                                                                       00578500
      ICTR = INT(SRCLOC)                                                00578600
      ZCTR = FLOAT(ICTR)                                                00578700
      ICTR = ICTR - INX1ST                                              00578800
C                                                                       00578900
      IF (MODEPR.EQ.2) GO TO 1550                                       00579000
      GXCO = BUF(ICTR,3)                                                00579100
      GYCO = BUF(ICTR,4)                                                00579200
      IF (ZCTR.EQ.SRCLOC) GO TO 1550                                    00579300
      ZFC = SRCLOC - ZCTR                                               00579400
      GXCO = GXCO + (BUF(ICTR+1,3) - GXCO) * ZFC                        00579500
      GYCO = GYCO + (BUF(ICTR+1,4) - GYCO) * ZFC                        00579600
      GO TO 1550                                                        00579700
C                                                                       00579800
C     +------------------------------------------+                      00579900
C     |   START OF LOOP TO PROCESS ALL TRACES    |                      00580000
C     |                  IN RECORD               |                      00580100
C     +------------------------------------------+                      00580200
C                                                                       00580300
 1500 LOC = LOC + 1                                                     00580400
C                                                                       00580500
 1550 X122 = (SRCLOC + FLOAT(LOC)) * XCVTDI / 2.                        00580600
      ICTRSB = X122 + 0.5 - INX1ST                                      00580700
      IF (ICTRSB.LE.NLOC) GO TO 1553                                    00580800
      ICTRSB = NLOC                                                     00580900
      GO TO 1555                                                        00581000
C                                                                       00581100
 1553 IF (ICTRSB.LT.1) ICTRSB = 1                                       00581200
C                                                                       00581300
 1555 IF (MODEPR.EQ.0) GO TO 1590                                       00581400
      IF (MODEPR.EQ.1) GO TO 1800                                       00581500
      LOC = IBUF2(l_RecInd)
      X122 = IBUF2(l_DphInd)
      ICTRSB = IBUF2(l_DphInd) - INX1ST
cmam  LOC = IBUF2(118)                                                  00581600
cmam  X122 = IBUF2(122)                                                 00581700
cmam  ICTRSB = IBUF2(122) - INX1ST                                      00581800
      IF (ICTRSB.LE.NLOC) GO TO 1557                                    00581900
      ICTRSB = NLOC                                                     00582000
      GO TO 1558                                                        00582100
C                                                                       00582200
 1557 IF (ICTRSB.LT.1) ICTRSB = 1                                       00582300
 1558 IF (LOC.GT.0) GO TO 1580                                          00582400
      WRITE (IPR,1560) ERRMES,LOC,IBUF2(l_RecNum),IBUF2(l_TrcNum)
cmam  WRITE (IPR,1560) ERRMES,LOC,IBUF2(106),IBUF2(107)                 00582500
 1560 FORMAT ('0** M7040',10A4/                                         00582600
     $ 13X,'RECEIVER LOCATION INDEX IN THE INPUT TRACE HEADER (',       00582700
     $     I6,') IS INVALID'/  13X,'FOR RI',I6,' TRACE',I6)             00582800
      ICC = 100                                                         00582900
      GO TO 9850                                                        00583000
C                                                                       00583100
C     +------------------------------------------+                      00583200
C     |        PROCESS MODE 0 AND 2 HERE         |                      00583300
C     |              FOR STATICS                 |                      00583400
C     +------------------------------------------+                      00583500
C                                                                       00583600
 1570 IF (MODEPR.NE.2) GO TO 1590                                       00583700
 1580 XXLOC = LOC                                                       00583800
      CALL  UPDAT5 (SRCLOC,XXLOC,XXLOC,DEPHOL,XLLTBG,XLFTAG,IBSCOR,     00583900
     $              OFFDIS,OFFANG,SHTMOV,                               00584000
     $              CORINI,CORREC,                                      00584100
     $              SPINC,LRI,NEXTRI,SPN,ACTSPN,MODEPR,SPLTFL)          00584200
      GO TO 1700                                                        00584300
C                                                                       00584400
 1590 READ (IDSK2,END=1600) XLOC,ICTRAC,CORINI,CORREC                   00584500
      IF (XLOC.EQ.SRCLOC.AND.ICTRAC.EQ.LOC) GO TO 1700                  00584600
      GO TO 1570                                                        00584700
C                                                                       00584800
 1600 WRITE (IPR,1650) ERRMES,LOC,SRCLOC                                00584900
 1650 FORMAT ('0** M7050',10A4/                                         00585000
     $ 13X,'EOF LOOKING FOR TRACE LOC.',I6,' AND SOURCE LOC.',G13.6/    00585100
     $ 13X,'ON DISK FILE CONTAINING CALCULATED STATICS'/                00585200
     $ 13X,'POSSIBLE CAUSE:  NUMBER OF TRACES PER RECORD ON INPUT TAPE'/00585300
     $ 13X,'DOES NOT MATCH NUMBER OF TRACES ENTERED ON 1LAIP CARD')     00585400
      ICC = 100                                                         00585500
      GO TO 9850                                                        00585600
C                                                                       00585700
 1700 STATIC = (CORINI + CORREC) * 1000.                                00585800
C                                                                       00585900
C     +------------------------------------------+                      00586000
C     |  VALIDITY CHECKS ON STATIC CALCULATIONS  |                      00586100
C     +------------------------------------------+                      00586200
C                                                                       00586300
      CALL STATCK (CORINI,CORREC,STATIC,LCN,IPR,IBUF2)                  00586400
C                                                                       00586500
C     +------------------------------------------+                      00586600
C     |     PROCESS MODE 0, 1 AND 2 HERE         |                      00586700
C     +------------------------------------------+                      00586800
C                                                                       00586900
 1800 IF (SPN.NE.SPNN) GO TO 1900                                       00587000
cmam  IBUF2(126) = IBSCOR                                               00587100
      IBUF2(l_DatShf) = IBSCOR
      IBUF2(l_ToTmAU) = IBSCOR * 4
cmam  IBUF2(16) = IBSCOR * 4                                            00587200
C                                                                       00587300
 1900 IBUF2(l_ShtDep)  = BUF(ICTRSB,14) + 0.5
c1900 IBUF2(99)  = BUF(ICTRSB,14) + 0.5                                 00587400
C                                                                       00587500
cmam......set uphole time to value from SPAR card, or the interpolated
cmam........value if it was not input
 2000 IBUF2(l_UphlTm) = iuptm
cmam...................................................................
c2000 IBUF2(l_UphlTm) = BUF(ICTRSB,13) + 0.5
c2000 IBUF2(100) = BUF(ICTRSB,13) + 0.5                                 00587600
C                                                                       00587700
      IBUF2(l_SrPtEl) = DIS112 + 0.5
cmam  IBUF2(112) = DIS112 + 0.5                                         00587800
      INDX = X122 / XCVTDI - INX1ST                                     00587900
      IF (INDX.LE.NLOC) GO TO 2060                                      00588000
      INDX = NLOC                                                       00588100
      GO TO 2070                                                        00588200
C                                                                       00588300
 2060 IF (INDX.LT.1) INDX = 1                                           00588400
 2070 KLI = LOC - INX1ST                                                00588500
C                                                                       00588600
      IF (MODEPR.EQ.0) GO TO 2080                                       00588700
      BFF = BUF(KLI,2)                                                  00588800
      IF (BFF.NE.ZMISS) IBUF2(l_GrpElv) = BFF + 0.5
cmam  IF (BFF.NE.ZMISS) IBUF2(120) = BFF + 0.5                          00588900
      BFF = BUF(INDX,2)                                                 00589000
      IF (BFF.NE.ZMISS) IBUF2(l_DePtEl) = BFF + 0.5
cmam  IF (BFF.NE.ZMISS) IBUF2(123) = BFF + 0.5                          00589100
      BFF = BUF(INDX,11)                                                00589200
      IF (BFF.NE.ZMISS) IBUF2(l_RfSrEl) = BFF + 0.5
cmam  IF (BFF.NE.ZMISS) IBUF2(124) = BFF + 0.5                          00589300
      IF (MODEPR.EQ.2) GO TO 2420                                       00589400
      GO TO 2085                                                        00589500
C                                                                       00589600
 2080 IBUF2(l_GrpElv) = BUF(KLI,2) + 0.5
c2080 IBUF2(120) = BUF(KLI,2) + 0.5                                     00589700
      IBUF2(l_DePtEl) = BUF(INDX,2) + 0.5
cmam  IBUF2(123) = BUF(INDX,2) + 0.5                                    00589800
      IBUF2(l_RfSrEl) = BUF(INDX,11) + 0.5
cmam  IBUF2(124) = BUF(INDX,11) + 0.5                                   00589900
C                                                                       00590000
C     +------------------------------------------+                      00590100
C     |        PROCESS MODE 0 AND 1 HERE         |                      00590200
C     |              FOR INDEXING                |                      00590300
C     +------------------------------------------+                      00590400
C                                                                       00590500
 2085 IBUF2(l_PerSPO) = IYDIS
c2085 IBUF2(43) = IYDIS                                                 00590600
      IBUF2(l_InlSPO) = IXDIS
cmam  IBUF2(44) = IXDIS                                                 00590700
C                                                                       00590800
      IBUF2(l_SrcLoc) = SRCLOC * 10.
cmam  IBUF2(109) = SRCLOC * 10.                                         00590900
C                                                                       00591000
      IF (PLTFLG(2).EQ.0) GO TO 2097                                    00591100
      IF (IBUF2(l_TrcNum).NE.1) GO TO 2097
cmam  IF (IBUF2(107).NE.1) GO TO 2097                                   00591200
C                                                                       00591300
C     +------------------------------------------+                      00591400
C     |      SET VALUES FOR STACKING CHART       |                      00591500
C     +------------------------------------------+                      00591600
C                                                                       00591700
      X109 = IBUF2(l_SrcLoc)
cmam  X109 = IBUF2(109)                                                 00591800
      XDISP = XCVTDI * X109 / 10.                                       00591900
      IDISP = XDISP + 0.5                                               00592000
      SI = X109 / 10.                                                   00592100
      X = SI - AINT(SI)                                                 00592200
      IOB = 0                                                           00592300
      IF (MOVFL1) GO TO 2086                                            00592400
      IF (X .LE. 0.13 .OR. X .GE. 0.74) GO TO 2090                      00592500
      IF (X .LT. 0.37 .OR. X .GT. 0.68) GO TO 2087                      00592600
      IOB = 2                                                           00592700
      GO TO 2090                                                        00592800
C                                                                       00592900
 2086 IF (X .LE. 0.26 .OR. X .GE. 0.74) GO TO 2090                      00593000
C                                                                       00593100
 2087 IOB = 1                                                           00593200
C                                                                       00593300
 2090 IF (.NOT.IFIRST) GO TO 2097                                       00593400
      IFIRST = .FALSE.                                                  00593500
      IF (SPLTFL) GO TO 2094                                            00593600
      IEOS = 1                                                          00593700
      IF (SI .GT. LOC) IEOS = 2                                         00593800
C                                                                       00593900
 2094 IF (PLTFLG(2).EQ.2) GO TO 2096                                    00594000
      IF (PLTFLG(2).NE.1) GO TO 2097                                    00594100
      CALL ISTCHP (IEOS,IOB,IOAC,LINE,NTPR,ICC,IPR,IUNSCP,MOVFL1,PLTFLG)00594200
      IF (ICC.EQ.0) GO TO 2097                                          00594300
      GO TO 9850                                                        00594400
C                                                                       00594500
 2096 CALL ISTCHG (IEOS,IOAC,LINE,NTPR,NUMDEV,NLOC,INX1ST,MOVFL1)       00594600
C                                                                       00594700
 2097 continue
      if (.not. saveperm) then
        IBUF2(l_PrRcNm) = IBUF2(l_RecNum)
c2097   IBUF2(110) = IBUF2(106)                                         00594800
        IBUF2(l_PrTrNm) = IBUF2(l_TrcNum)
cmam    IBUF2(111) = IBUF2(107)                                         00594900
      endif
C                                                                       00595000
C     +------------------------------------------+                      00595100
C     |       DETERMINE TRACE DISTANCES          |                      00595200
C     +------------------------------------------+                      00595300
C                                                                       00595400
      IF (SPN.NE.SPNN) GO TO 2150                                       00595500
      IF (TRACFL) GO TO 2240                                            00595600
      IF (OFFDIS.EQ.0.0) GO TO 2150                                     00595700
      ICTR = LOC - INX1ST                                               00595800
      TXCO = BUF(ICTR,3)                                                00595900
      TYCO = BUF(ICTR,4)                                                00596000
      XXDIS = SQRT((GXCO-TXCO)**2 + (GYCO-TYCO)**2 )                    00596100
C                                                                       00596200
      CDIS = SQRT(XXDIS**2 + YDIS**2)                                   00596300
      GO TO 2170                                                        00596400
C                                                                       00596500
 2150 ICTR = LOC - INX1ST                                               00596600
      TXCO = BUF(ICTR,3)                                                00596700
      TYCO = BUF(ICTR,4)                                                00596800
      CDIS = SQRT((GXCO-TXCO)**2 + (GYCO-TYCO)**2 )                     00596900
C                                                                       00597000
 2170 IF (CDIS.LT.32767.5) GO TO 2210                                   00597100
      WRITE (IPR,2200) ERRMES,CDIS,IBUF2(l_RecNum),IBUF2(l_TrcNum)
cmam  WRITE (IPR,2200) ERRMES,CDIS,IBUF2(106),IBUF2(107)                00597200
 2200 FORMAT ('0** M7060',10A4/                                         00597300
     $ 13X,'CALCULATE TRACE DISTANCE OF ',G13.6,' FOR RI',I6,' TR',I6/  00597400
     $ 13X,'ABS. VAL. IS GREATER THAN 32767')                           00597500
      ICC = 100                                                         00597600
      GO TO 9850                                                        00597700
C                                                                       00597800
 2210 IBUF2(l_DstUsg) = CDIS + 0.5
c2210 IBUF2(117) = CDIS + 0.5                                           00597900
      IF (SRCLOC.LE.LOC) GO TO 2250                                     00598000
      IBUF2(l_DstSgn) = -IBUF2(l_DstUsg)
cmam  IBUF2(119) = -IBUF2(117)                                          00598100
      GO TO 2260                                                        00598200
C                                                                       00598300
 2240 IBUF2(l_DstUsg) = DIST(IBUF2(l_TrcNum))
c2240 IBUF2(117) = DIST(IBUF2(107))                                     00598400
C                                                                       00598500
 2250 IBUF2(l_DstSgn) = IBUF2(l_DstUsg)
c2250 IBUF2(119) = IBUF2(117)                                           00598600
C                                                                       00598700
 2260 IBUF2(l_RecInd) = LOC
c2260 IBUF2(118) = LOC                                                  00598800
C                                                                       00598900
C     +------------------------------------------+                      00599000
C     | PROCESS 1GROM, 1GRIN, 1TROM, 1TRIN CARDS |                      00599100
C     +------------------------------------------+                      00599200
C                                                                       00599300
      IF (INOMFL) CALL INOMDO(iadd)
cmam  IF (INOMFL) CALL INOMDO                                           00599400
C                                                                       00599500
C     +------------------------------------------+                      00599600
C     |       CALCULATE DEPTH INDEX              |                      00599700
C     |     (XCVTDI = 2 OR 4 DEPENDING ON        |                      00599800
C     |      WHAT THE INDEXING METHOD IS)        |                      00599900
C     +------------------------------------------+                      00600000
C                                                                       00600100
      IBUF2(l_DphInd) = X122 + 0.5
cmam  IBUF2(122) = X122 + 0.5                                           00600200
      X122 = IBUF2(l_DphInd)
cmam  X122 = IBUF2(122)                                                 00600300
      XCT = (X122 / XCVTDI - ZNX1ST) * 2. - 1.                          00600400
      ICT1 = XCT - TERVAL + 0.99                                        00600500
      ICT2 = XCT + TERVAL                                               00600600
      IFSP = SPN                                                        00600700
      IFSPD = 0                                                         00600800
      IF (FLOAT(IFSP).EQ.SPN.AND.ISPNB.NE.IAST) GO TO 2300              00600900
      IFSP = 0                                                          00601000
      GO TO 2400                                                        00601100
C                                                                       00601200
 2300 IF (ICT1.GE.1) GO TO 2330                                         00601300
      IF (ICT2.LT.1) GO TO 2370                                         00601400
      ICT1 = 1                                                          00601500
 2330 IF (ICT1.GT.ICT2) GO TO 2370                                      00601600
      XDIFS = 99999999.                                                 00601700
C                                                                       00601800
      DO 2360 I=ICT1,ICT2                                               00601900
         IS = jSPBUF(I)
cmam     IS = ISPBUF(INDXSP+I)                                          00602000
         IF (IS.EQ.0) GO TO 2360                                        00602100
         XDIF = ABS(FLOAT(I)-XCT)                                       00602200
         IF (XDIF.GE.XDIFS) GO TO 2360                                  00602300
         IFSPD = IS                                                     00602400
         XDIFS = XDIF                                                   00602500
 2360 CONTINUE                                                          00602600
C                                                                       00602700
 2370 IF (ISPNB.EQ.IBL2) GO TO 2400                                     00602800
C=======================================================================00602900
cmam  CALL MOVE (1,IBUF2(128),ISPNA,1)                                  00603300
	call savew(ibuf2,'SoPtAl',ispna,1)
C=======================================================================00603500
C                                                                       00603600
C     +------------------------------------------+                      00603700
C     |       USE SHOT POINT BIASING ROUTINE     |                      00603800
C     +------------------------------------------+                      00603900
C                                                                       00604000
c2400 IBIAS = IBUF2(128)                                                00604100
 2400 call saver(ibuf2,'SoPtBi',bchar,1)
	ibias = ichar(bchar)
cmam  CALL SPBIAS (IBFLAG,IBIAS,IHSPD,IHSP,IFSPD,IFSP)                  00604200
	call sbias(ibflag,ibias,ifspd,ihspd)
	call sbias(ibflag,ibias,ifsp,ihsp)
cmam  IBUF2(108) = IHSPD                                                00604300
	ibuf2(l_SrcPnt) = ihspd
cmam  IBUF2(127) = IHSP                                                 00604400
	ibuf2(l_SoPtNm) = ihsp
c...........this bias doesn't change -- do not reset it
cmam  IBUF2(128) = IBIAS                                                00604500
C                                                                       00604600
      IF (LD.GT.0) IBUF2(l_StaCor) = 30000
cmam  IF (LD.GT.0) IBUF2(125) = 30000                                   00604700
C                                                                       00604800
C     +------------------------------------------+                      00604900
C     |           PROCESS ALL MODES HERE         |                      00605000
C     |       FOR OUTPUT AND INPUT NEW TRACE     |                      00605100
C     +------------------------------------------+                      00605200
C                                                                       00605300
C     +------------------------------------------+                      00605400
C     |        PRINT SHOT INFORMATION            |                      00605500
C     +------------------------------------------+                      00605600
C                                                                       00605700
 2420 IF (NOPRNT) GO TO 2500                                            00605800
      NOPRNT = .TRUE.                                                   00605900
cmam  CALL MOVE (0,ISAVE,0,MAXTRC*6)                                    00606000
cmam  CALL MOVE (0,ISAVE,0,MAXTRC*3*SZHFWD)
      CALL MOVE (0,ISAVE1,0,MAXTRC*3*SZHFWD)
cmam  CALL MOVE (0,SAVE,0,MAXTRC*12)                                    00606100
cmam  CALL MOVE (0,SAVE,0,MAXTRC*3*SZSMPD)
      CALL MOVE (0,SAVE1,0,MAXTRC*3*SZSMPD)
cmam  TMP1 = IBUF2(109)                                                 00606200
      TMP1 = IBUF2(l_SrcLoc)
      TMP1 = TMP1 / 10.                                                 00606300
      WRITE (IPR,2430) IBUF2(l_RecNum),TMP1,DIS112,UNITDS
cmam  WRITE (IPR,2430) IBUF2(106),TMP1,DIS112,UNITDS                    00606400
 2430 FORMAT ('0',131('*')//                                            00606500
     $      1X,'RECORD INDX =',I6,2X,'SOURCE INDX = GI',F7.1,5X,        00606600
     $                 'SURF ELEV =',F9.3,5X,'UNITS = ',A7)             00606700
C                                                                       00606800
      IF (MODEPR.EQ.2) GO TO 2440                                       00606900
C                                                                       00607000
      ITMP1 = 0                                                         00607100
      IF (SPN.EQ.SPNN) ITMP1 = IBSCOR                                   00607200
      IISP = SPN                                                        00607300
      IF (FLOAT(IISP).NE.SPN.OR.ISPNB.EQ.IAST) IISP = 0                 00607400
      ISPNC = ISPNB                                                     00607500
      IF (ISPNB.EQ.IAST) ISPNC = IBL2                                   00607600
      IF (MODEPR.NE.2) WRITE (IPR,2435) IISP,ISPNC,ITMP1,GXCO,GYCO      00607700
 2435 FORMAT (1X,'SHOT POINT  =',I6,A1,1X,'DATUM SHIFT =',I8,7X,        00607800
     $          'S.P.LOCATION:',12X,'X COOR=',G21.10,' Y COOR=',G21.10) 00607900
C                                                                       00608000
      IF (MODEPR.EQ.1) GO TO 2500                                       00608100
C                                                                       00608200
 2440 ICTRSC = SRCLOC - ZNX1ST                                          00608300
      CALL PRSHOT (ICTRSC,CORINI,DEPHOL)                                00608400
C                                                                       00608500
C     +------------------------------------------+                      00608600
C     |         SAVE TRACE INFORMATION           |                      00608700
C     +------------------------------------------+                      00608800
C                                                                       00608900
 2500 ITR = IBUF2(l_TrcNum)
c2500 ITR = IBUF2(107)                                                  00609000
      ISAVE1(ITR) = IBUF2(l_RecInd)
cmam  ISAVE(ITR,1) = IBUF2(l_RecInd)
cmam  ISAVE(ITR,1) = IBUF2(118)                                         00609100
      ISAVE2(ITR) = IBUF2(l_DphInd)
cmam  ISAVE(ITR,2) = IBUF2(l_DphInd)
cmam  ISAVE(ITR,2) = IBUF2(122)                                         00609200
      ISAVE3(ITR) = IBUF2(l_DstSgn)
cmam  ISAVE(ITR,3) = IBUF2(l_DstSgn)
cmam  ISAVE(ITR,3) = IBUF2(119)                                         00609300
      SAVE1(ITR)  = STATIC
cmam  SAVE(ITR,1)  = STATIC                                             00609400
      IF (IBUF2(l_StaCor).EQ.30000) SAVE1(ITR) = 30000
cmam  IF (IBUF2(l_StaCor).EQ.30000) SAVE(ITR,1) = 30000
cmam  IF (IBUF2(125).EQ.30000) SAVE(ITR,1) = 30000                      00609500
      SAVE2(ITR)  = TXCO
cmam  SAVE(ITR,2)  = TXCO                                               00609600
      SAVE3(ITR)  = TYCO
cmam  SAVE(ITR,3)  = TYCO                                               00609700
C                                                                       00609800
cmam.......put x,y coord for source, group, and x,y midpts in trhdr
	if(modepr.ne.2) then
	  ibuf4(l_SrPtXC) = GXCO
	  ibuf4(l_SrPtYC) = GYCO
	  ibuf4(l_RcPtXC) = TXCO
	  ibuf4(l_RcPtYC) = TYCO
	  ibuf4(l_SrRcMX) = (GXCO + TXCO) / 2
	  ibuf4(l_SrRcMY) = (GYCO + TYCO) / 2
cmam	  ibuf2(l_SrPtXc) = GXCO
cmam	  ibuf2(l_SrPtYc) = GYCO
cmam	  ibuf2(l_RcPtXC) = TXCO
cmam	  ibuf2(l_RcPtYC) = TYCO
cmam	  ibuf2(l_SrRcMX) = (GXCO + TXCO) / 2
cmam	  ibuf2(l_SrRcMY) = (GYCO + TYCO) / 2
	endif
      CALL WRTAPE (OTAP,IBUF4,N)                                        00609900
C                                                                       00610000
      IF (PLTFLG(2).NE.3) GO TO 2530                                    00610100
      HALFWD = 0                                                        00610200
      IF (IBUF2(l_StaCor).EQ.30000) HALFWD = -1
cmam  IF (IBUF2(125).EQ.30000) HALFWD = -1                              00610300
      IISP = SPN                                                        00610400
      ISPNB2 = ISPNB1                                                   00610500
      IF (FLOAT(IISP).NE.SPN) GO TO 2510                                00610600
      IF (ISPNB.NE.IAST) GO TO 2520                                     00610700
      ISPNB2 = IBL1                                                     00610800
 2510 IISP = 0                                                          00610900
 2520 WRITE (IUNSCF) IBUF2(l_DphInd),IBUF2(l_RecNum),HALFWD,IISP,ISPNB2
c2520 WRITE (IUNSCF) IBUF2(122),IBUF2(106),HALFWD,IISP,ISPNB2           00611000
      GO TO 2550                                                        00611100
C                                                                       00611200
 2530 IF (IBUF2(l_StaCor).EQ.30000.AND.
     *(PLTFLG(2).EQ.1.OR.PLTFLG(2).EQ.2)) then
c2530 IF (IBUF2(125).EQ.30000.AND.(PLTFLG(2).EQ.1.OR.PLTFLG(2).EQ.2))   00611300
          ISAVE2(ITR) = -ISAVE2(ITR)
cmam	print *,'setting DI to its negative:rec,tr,di,isave2,itr=',
cmam *	ibuf2(l_RecNum),ibuf2(l_TrcNum),ibuf2(l_DphInd),isave2(itr),itr
      endif
cmam $    ISAVE(ITR,2) = -ISAVE(ITR,2)                                  00611400
C                                                                       00611500
 2550 IF (MODEPR.EQ.2) GO TO 2580                                       00611600
      IF (.NOT. SPLTFL) GO TO 2580                                      00611700
      IF (LOC.LT.LOCL.OR.LOC.GT.LOCF) GO TO 2580                        00611800
      IF (LOC.NE.LOCL) GO TO 2560                                       00611900
      LD = IFTAG - LTBG - 1                                             00612000
      GO TO 2570                                                        00612100
C                                                                       00612200
 2560 LD = LD - 1                                                       00612300
C                                                                       00612400
 2570 IF (LD.EQ.0) LOC = LOCF - 1                                       00612500
C                                                                       00612600
C     +-------------------------------------------+                     00612700
C     |  SAVE SHOT GI FOR EXTERNAL STACKING CHART |                     00612800
C     |  THEN READ THE NEXT TRACE.                |                     00612900
C     +-------------------------------------------+                     00613000
C                                                                       00613100
 2580 IH109 = IBUF2(l_SrcLoc)
c2580 IH109 = IBUF2(109)                                                00613200
      N = 0                                                             00613300
      CALL RTAPE (NTAP,IBUF4,N)                                         00613400
      IF (N.EQ.0) GO TO 2600                                            00613500
C                                                                       00613600
      IF (IBUF2(l_TrcNum).LT.1.OR.IBUF2(l_TrcNum).GT.NTPR) GO TO 6900
cmam  IF (IBUF2(107).LT.1.OR.IBUF2(107).GT.NTPR) GO TO 6900             00613700
C                                                                       00613800
C     +-------------------------------------------+                     00613900
C     | CHECK IF TRACE IS FOR SAME RECORD AS LAST |                     00614000
C     +-------------------------------------------+                     00614100
C                                                                       00614200
      IF (IRI.EQ.IBUF2(l_RecNum)) GO TO 1500
cmam  IF (IRI.EQ.IBUF2(106)) GO TO 1500                                 00614300
      IF (ITR.NE.NTPR) GO TO 6800                                       00614400
      NOPRNT = .FALSE.                                                  00614500
      GO TO 2610                                                        00614600
C                                                                       00614700
C     +-------------------------------------------+                     00614800
C     |       END OF FILE ON INPUT TAPE           |                     00614900
C     +-------------------------------------------+                     00615000
C                                                                       00615100
 2600 EOT = .TRUE.                                                      00615200
C                                                                       00615300
C     +------------------------------------------+                      00615400
C     | SEND INFO TO STACKING CHART ROUTINE      |                      00615500
C     | OR OUTPUT TO A FILE FOR EXTERNAL         |                      00615600
C     | STACKING CHART OR NOTHING IF NONE WANTED |                      00615700
C     +------------------------------------------+                      00615800
C                                                                       00615900
 2610 IRECP = IRECP + 1                                                 00616000
      GO TO (2800,2650,2700,2750), IPF2                                 00616100
 2650 CALL STCHP (ISAVE2,IDISP,IRI,IOB)
c2650 CALL STCHP (ISAVE(1,2),IDISP,IRI,IOB)                             00616200
      GO TO 2800                                                        00616300
C                                                                       00616400
 2700 CALL STCHG (ISAVE2,XDISP,IRI)
c2700 CALL STCHG (ISAVE(1,2),XDISP,IRI)                                 00616500
      GO TO 2800                                                        00616600
C                                                                       00616700
 2750 HALFWD = -IRI                                                     00616800
      TMP1 = IH109 * XCVTDI                                             00616900
      IH109D = (TMP1 + 0.5) / 10.                                       00617000
      IISP = SPN                                                        00617100
      ISPNB2 = ISPNB1                                                   00617200
      IF (FLOAT(IISP).NE.SPN) GO TO 2760                                00617300
      IF (ISPNB.NE.IAST) GO TO 2770                                     00617400
      ISPNB2 = IBL1                                                     00617500
 2760 IISP = 0                                                          00617600
C                                                                       00617700
 2770 WRITE (IUNSCF) IH109D,HALFWD,IH109,IISP,ISPNB2                    00617800
C                                                                       00617900
 2800 IRI = IBUF2(l_RecNum)
c2800 IRI = IBUF2(106)                                                  00618000
C                                                                       00618100
C     +------------------------------------------+                      00618200
C     |     RECORD IS COMPLETE.  CHECK IF        |                      00618300
C     |  RECORD APPLIES TO THE NEXT 1SPAR CARD.  |                      00618400
C     |  IF NOT, THEN INCREMENT THE SHOT POINT   |                      00618500
C     |  NUMBER, RESET COUNTER AND               |                      00618600
C     |  PROCESS THE TRACES FOR THE NEXT RECORD. |                      00618700
C     |  IF SO, GET INFO FROM 1SPAR CARD, THEN   |                      00618800
C     |  PROCESS THE TRACES FOR THE NEXT RECORD. |                      00618900
C     +------------------------------------------+                      00619000
C                                                                       00619100
      IF (ISYS.NE.1) GO TO 3000                                         00619200
      IF (EOT) GO TO 3000                                               00619300
      IF (.NOT.IRCRD1) GO TO 5000                                       00619400
      IRCRD1 = .FALSE.                                                  00619500
C                                                                       00619600
 3000 CALL PRTRAC(IPR,MODEPR,NTPR,IPSAV1,KPSAV1,maxtrc,
     *		ISYS,LTBG,IFTAG,SPLTFL)
c3000 CALL PRTRAC (IPR,MODEPR,NTPR,SAVE,ISAVE,ISYS,LTBG,IFTAG,SPLTFL)   00619700
C                                                                       00619800
 5000 IF (EOT) GO TO 9700                                               00619900
C                                                                       00620000
      IF (NXIRI.NE.IBUF2(l_RecNum).AND. .NOT.EOF) GO TO 1200
cmam  IF (NXIRI.NE.IBUF2(106).AND. .NOT.EOF) GO TO 1200                 00620100
      IF (.NOT.EOF) GO TO 200                                           00620200
      WRITE (IPR,6000) ERRMES                                           00620300
 6000 FORMAT ('0** M7070',10A4/                                         00620400
     $ 13X,'END OF "1SPAR" CARDS BEFORE ALL RECORDS ON ',               00620500
     $     'INPUT TAPE WERE PROCESSED')                                 00620600
      ICC = 100                                                         00620700
      GO TO 9850                                                        00620800
C                                                                       00620900
 6800 WRITE (IPR,6850) ERRMES,IRI,ITR,NTPR                              00621000
 6850 FORMAT ('0** M7080',10A4/                                         00621100
     $13X,'PROCESSING RI',I5,' COMPLETE.  RECORD HAS',I5,' TRACES.'/    00621200
     $13X,'PROGRAM EXPECTED',I5,' TRACES PER RECORD.')                  00621300
      ICC = 100                                                         00621400
      GO TO 9850                                                        00621500
C                                                                       00621600
 6900 WRITE (IPR,7000) ERRMES,ITR,NTPR                                  00621700
 7000 FORMAT ('0** M7090',10A4/                                         00621800
     $ 13X,'TRACE NUMBER ON INPUT TRACE HEADER IS',I5/                  00621900
     $ 13X,'PROGRAM EXPECTED IT TO BE BETWEEN 1 AND',I5,                00622000
     $     ', INCLUSIVE')                                               00622100
      ICC = 100                                                         00622200
      GO TO 9850                                                        00622300
C                                                                       00622400
 9700 IF (EOF) GO TO 9850                                               00622500
      WRITE (IPR,9750)                                                  00622600
 9750 FORMAT ('0** M7100 ** WARNING FROM SUBROUTINE GO4IT:'/            00622700
     $ 13X,'END OF INPUT TAPE BEFORE ALL INPUT CARDS WERE PROCESSED'/   00622800
     $ 13X,'UNUSED INPUT CARDS WILL NOT BE USED')                       00622900
C                                                                       00623000
 9850 CALL LBCLOS (OTAP)                                                00623100
      IF (ICC.NE.0) GO TO 9960                                          00623200
C                                                                       00623300
      GO TO (9960,9870,9900,9960), IPF2                                 00623400
C                                                                       00623500
 9870 CALL ENDSTH                                                       00623600
      GO TO 9960                                                        00623700
C                                                                       00623800
 9900 WRITE (IPR,9950)                                                  00623900
 9950 FORMAT ('0',9X,'PROCESSING FOR STACKING CHART PLOT COMPLETE')     00624000
C                                                                       00624100
 9960 CONTINUE                                                          00624200
C                                                                       00624300
C=======================================================================00624400
      IF (.NOT.INOMFL) GO TO 9999                                       00624700
      DO 9970 I=1,4                                                     00624800
	if(inomct(i).gt.0) then
	  call gfree(iadd(1))
	endif
cmam     IF (INOMCT(I).GT.0.AND.IAVAIL(I).GT.0)                         00624900
cmam $       CALL RELSES (IADD(I),IAVAIL(I))                            00625000
 9970 CONTINUE                                                          00625100
 9999 CONTINUE                                                          00625200
C=======================================================================00625400
C                                                                       00625500
      RETURN                                                            00625600
      END                                                               00625700
C  ROUTINE:       INOMCV                                                00625800
C  ROUTINE TYPE:  SUBROUTINE                                            00625900
C  PURPOSE:  CONVERT GROM,GRIN,TROM,TRIN DISK FILES TO CORE.            00626000
C  AUTHOR:  DOUGLAS BODDY                                               00626100
C  DATE WRITTEN:  NOVEMBER 1985                                         00626200
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00626300
C                                                                       00626400
C=======================================================================00626500
      SUBROUTINE INOMCV (IADD,IAVAIL)                                   00626900
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
      DIMENSION IADD(4),IAVAIL(4)                                       00627000
C=======================================================================00627200
C                                                                       00627300
      DOUBLE PRECISION RAD                                              00627400
	integer inom1(1),inom2(1),inom3(1),inom4(1)
	pointer(knom1,inom1),(knom2,inom2),(knom3,inom3),(knom4,inom4)
C                                                                       00627500
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	character*4 card, TDIS, SPAR
C                                                                       00627700
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00628300
      DO 100 I=1,4                                                      00628400
         ICNT = INOMCT(I)                                               00628500
         IF (ICNT.EQ.0) GO TO 100                                       00628600
C                                                                       00628700
C=======================================================================00628800
         IWANT = ICNT * 4 * SZSMPD
cmam     IWANT = ICNT * 16                                              00629400
cmam     CALL ALLOCS (INOM,INDXIO(I),IWANT,IAVAIL(I),IADD(I))           00629500
cmam     INDXIO(I) = INDXIO(I) / 4 + 1                                  00629600
cmam     IF (IAVAIL(I).GT.0) GO TO 30                                   00629700
cmam      CALL ALLOCS (MHDRS,INDX1,IWANT,IGOT1,IADD1)                   00007960
c.........we need to allocate storage only for those types of cards
c.........input:GRIN,GROM,TRIN,TROM
	go to (1,2,3,4) i
   1    call galloc(knom1,iwant,errcd,abort)
	go to 5
   2    call galloc(knom2,iwant,errcd,abort)
	go to 5
   3    call galloc(knom3,iwant,errcd,abort)
	go to 5
   4    call galloc(knom4,iwant,errcd,abort)
   5    if(errcd .ne. 0) then
           write(LERR,*) ' '
           write(LERR,*) 'Unable to allocate workspace for INOM',i
           write(LERR,*) 'FATAL'
           call ccexit (100)
C=======================================================================00629900
         WRITE (IPR,20)                                                 00630000
 20      FORMAT ('0** M7200 ** ERROR DETECTED BY SUBROUTINE INOMCV:'/   00630100
     $   13X,'INSUFFICIENT STORAGE AVAILABLE TO STORE ',                00630200
     $       'INFORMATION FROM GROM, GRIN, TROM, OR TRIN CARDS'/        00630300
     $   13X,'YOU MUST EITHER DECREASE THE NUMBER OF CARDS OR'/         00630400
     $   13X,'DECREASE THE NUMBER OF LOCATION ON LINE OR'/              00630500
     $   13X,'IBM: INCREASE REGION OVERRIDE'/                           00630600
     $   13X,'PERKIN-ELMER: USE DISK OPTION: EXEC LAIP,DISK=YES'/       00630700
     $   13X,'WARNING: DISK OPTION IS VERY SLOW'/                       00630800
     $   13X,'P.E. 8/32 USERS MAKE SURE DEFAULT REGION IN YOUR PROC '/  00630900
     $   13X,'IS LARGE ENOUGH TO USE ALL AVAILABLE CORE')               00631000
         ICC = 100                                                      00631100
         GO TO 200                                                      00631200
        endif
C                                                                       00631300
 30      IUNIT = INOMUN + I - 1                                         00631400
         REWIND IUNIT                                                   00631500
         INDX1 = I * 4 - 3                                              00631600
         INDX2 = INDX1 + 3                                              00631700
	ival = 4*SZSMPD
	indxio(i) = 1
C                                                                       00631800
c.........the unit has been rewound.  now read all the values from
c......... the associated card type, and put the values into the
c......... allocated array
c.........we pass the addresses of the allocated storage back through
c......... the common array IADD.  just set up pointers and use these
c......... addresses to get to the data in another subroutine
	go to(40,50,60,70) i
   40	do 45 j = 1,icnt
	  READ (IUNIT) (INOM(K),K=INDX1,INDX2)
	  call move(1,inom1((j-1)*4+1),inom(indx1),ival)
   45   continue
	iadd(i) = knom1
	go to 100
   50   do 55 j = 1,icnt
          READ (IUNIT) (INOM(K),K=INDX1,INDX2)
          call move(1,inom2((j-1)*4+1),inom(indx1),16)
   55   continue
	iadd(i) = knom2
        go to 100
   60   do 65 j = 1,icnt
          READ (IUNIT) (INOM(K),K=INDX1,INDX2)
          call move(1,inom3((j-1)*4+1),inom(indx1),16)
   65   continue
	iadd(i) = knom3
        go to 100
   70   do 75 j = 1,icnt
          READ (IUNIT) (INOM(K),K=INDX1,INDX2)
          call move(1,inom4((j-1)*4+1),inom(indx1),16)
   75   continue
	iadd(i) = knom4
cmam     DO 60 J=1,ICNT                                                 00631900
cmam        READ (IUNIT) (INOM(K),K=INDX1,INDX2)                        00632000
cmam        CALL MOVE (1,INOM(INDXIO(I)+(J-1)*4),INOM(INDX1),16)        00632100
c60      CONTINUE                                                       00632200
C                                                                       00632300
 100  CONTINUE                                                          00632400
C                                                                       00632500
      CALL MOVE (0,INOM,0,16*SZSMPD)
cmam  CALL MOVE (0,INOM,0,64)                                           00632600
C                                                                       00632700
 200  RETURN                                                            00632800
      END                                                               00632900
C  ROUTINE:       INOMDO                                                00633000
C  ROUTINE TYPE:  SUBROUTINE                                            00633100
C  PURPOSE:  INVERT/OMIT TRACES                                         00633200
C  AUTHOR:  DOUGLAS BODDY                                               00633300
C  DATE WRITTEN:  NOVEMBER 1985                                         00633400
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00633500
C                                                                       00633600
      SUBROUTINE INOMDO (iadd)
cmam  SUBROUTINE INOMDO                                                 00633700
C                                                                       00633800
#include <f77/lhdrsz.h>
#include <save_defs.h>
      DOUBLE PRECISION RAD                                              00633900
	integer iadd(4)
	integer inom1(1),inom2(1),inom3(1),inom4(1)
	pointer (k1,inom1),(k2,inom2),(k3,inom3),(k4,inom4)
C                                                                       00634000
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	character*4 card, TDIS, SPAR
C                                                                       00634200
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00634800
      REAL      XSAMP(6000)                                             00634900
C                                                                       00635000
      INTEGER*2 IBUF2(129)                                              00635100
cmam  INTEGER*2 ISAMP(12000)                                            00635200
cmam  INTEGER*2 IRI,ITR,LOC                                             00635300
C                                                                       00635400
cmam  EQUIVALENCE (IBUF2(106),IRI),(IBUF2(107),ITR),(IBUF2(118),LOC)    00635500
cmam  EQUIVALENCE (IBUF4(65),IBUF2(129),ISAMP(1),XSAMP(1))              00635600
	equivalence (ibuf4,ibuf2),(ibuf4(ITHWP1),xsamp(1))
c.......
	call saver(ibuf2,'RecNum',iri,1)
	call saver(ibuf2,'TrcNum',itr,1)
	call saver(ibuf2,'RecInd',loc,1)
c....
	k1 = iadd(1)
	k2 = iadd(2)
	k3 = iadd(3)
	k4 = iadd(4)
c.......
	ival = 4*SZSMPD
c.......
C                                                                       00635700
      IF (INOMCT(1).EQ.0) GO TO 300                                     00635800
         IF (LOC.GT.INOM( 2) .OR.  LOC.LT.INOM( 1)) GO TO 105           00635900
         IF (IRI.GE.INOM( 3) .AND. IRI.LE.INOM( 4)) GO TO 120           00636000
 105     ICTR = 1                                                       00636100
         GO TO 115                                                      00636200
C                                                                       00636300
 110     ICTR = ICTR + 1                                                00636400
         IF (ICTR.GT.INOMCT(1)) GO TO 150                               00636500
 115     CALL MOVE (1,INOM(1),INOM1(INDXIO(1)+(ICTR-1)*4),ival)
c115     CALL MOVE (1,INOM(1),INOM(INDXIO(1)+(ICTR-1)*4),16)            00636600
         IF (LOC.LT.INOM( 1) .OR. LOC.GT.INOM( 2)) GO TO 110            00636700
         IF (IRI.LT.INOM( 3) .OR. IRI.GT.INOM( 4)) GO TO 110            00636800
C                                                                       00636900
 120     call savew(ibuf2,'StaCor',30000,1)
c120     IBUF2(125) = 30000                                             00637000
         GO TO 200                                                      00637100
C                                                                       00637200
 150     INOM( 2) = 0                                                   00637300
C                                                                       00637400
 300  IF (INOMCT(3).EQ.0) GO TO 200                                     00637500
         IF (IRI.GT.INOM(12) .OR.IRI.LT.INOM(11)) GO TO 305             00637600
         IF (ITR.GE.INOM( 9).AND.ITR.LE.INOM(10)) GO TO 320             00637700
 305     ICTR = 1                                                       00637800
         GO TO 315                                                      00637900
C                                                                       00638000
 310     ICTR = ICTR + 1                                                00638100
         IF (ICTR.GT.INOMCT(3)) GO TO 350                               00638200
 315     CALL MOVE (1,INOM(9),INOM3(INDXIO(3)+(ICTR-1)*4),ival)
c315     CALL MOVE (1,INOM(9),INOM(INDXIO(3)+(ICTR-1)*4),16)            00638300
         IF (IRI.LT.INOM(11) .OR.IRI.GT.INOM(12)) GO TO 310             00638400
         IF (ITR.LT.INOM( 9) .OR.ITR.GT.INOM(10)) GO TO 310             00638500
C                                                                       00638600
 320     call savew(ibuf2,'StaCor',30000,1)
c320     IBUF2(125) = 30000                                             00638700
         GO TO 200                                                      00638800
C                                                                       00638900
 350     INOM(12) = 0                                                   00639000
C                                                                       00639100
 200  IF (INOMCT(2).EQ.0) GO TO 400                                     00639200
         IF (LOC.GT.INOM( 6) .OR.LOC.LT.INOM( 5)) GO TO 205             00639300
         IF (IRI.GE.INOM( 7).AND.IRI.LE.INOM( 8)) GO TO 240             00639400
 205     ICTR = 1                                                       00639500
         GO TO 220                                                      00639600
C                                                                       00639700
 210     ICTR = ICTR + 1                                                00639800
         IF (ICTR.GT.INOMCT(2)) GO TO 230                               00639900
 220     CALL MOVE (1,INOM(5),INOM2(INDXIO(2)+(ICTR-1)*4),ival)
c220     CALL MOVE (1,INOM(5),INOM(INDXIO(2)+(ICTR-1)*4),16)            00640000
         IF (LOC.LT.INOM( 5) .OR. LOC.GT.INOM( 6)) GO TO 210            00640100
         IF (IRI.LT.INOM( 7) .OR. IRI.GT.INOM( 8)) GO TO 210            00640200
         GO TO 240                                                      00640300
C                                                                       00640400
 230     INOM( 6) = 0                                                   00640500
         GO TO 400                                                      00640600
C                                                                       00640700
 240	continue
c240     IF (IFOR.EQ.3) GO TO 270                                       00640800
C                                                                       00640900
cmam     DO 260 K=1,NSAMPS                                              00641000
cmam        ISAMP(K) = -ISAMP(K)                                        00641100
c260     CONTINUE                                                       00641200
C                                                                       00641300
c        GO TO 500                                                      00641400
C                                                                       00641500
 270	call vneg(xsamp,1,xsamp,1,nsamps)
c270     DO 280 K=1,NSAMPS                                              00641600
cmam        XSAMP(K) = -XSAMP(K)                                        00641700
c280     CONTINUE                                                       00641800
C                                                                       00641900
         GO TO 500                                                      00642000
C                                                                       00642100
 400  IF (INOMCT(4).EQ.0) GO TO 500                                     00642200
         IF (IRI.GT.INOM(16) .OR.IRI.LT.INOM(15)) GO TO 405             00642300
         IF (ITR.GE.INOM(13).AND.ITR.LE.INOM(14)) GO TO 440             00642400
 405     ICTR = 1                                                       00642500
         GO TO 420                                                      00642600
C                                                                       00642700
 410     ICTR = ICTR + 1                                                00642800
         IF (ICTR.GT.INOMCT(4)) GO TO 430                               00642900
 420     CALL MOVE (1,INOM(13),INOM4(INDXIO(4)+(ICTR-1)*4),ival)
c420     CALL MOVE (1,INOM(13),INOM(INDXIO(4)+(ICTR-1)*4),16)           00643000
         IF (IRI.LT.INOM(15) .OR.IRI.GT.INOM(16)) GO TO 410             00643100
         IF (ITR.LT.INOM(13) .OR.ITR.GT.INOM(14)) GO TO 410             00643200
         GO TO 440                                                      00643300
C                                                                       00643400
 430     INOM(16) = 0                                                   00643500
         GO TO 500                                                      00643600
C                                                                       00643700
 440	continue
c440     IF (IFOR.EQ.3) GO TO 470                                       00643800
C                                                                       00643900
cmam     DO 460 K=1,NSAMPS                                              00644000
cmam        ISAMP(K) = -ISAMP(K)                                        00644100
c460     CONTINUE                                                       00644200
C                                                                       00644300
cmam     GO TO 500                                                      00644400
C                                                                       00644500
c470     DO 480 K=1,NSAMPS                                              00644600
cmam        XSAMP(K) = -XSAMP(K)                                        00644700
c480     CONTINUE                                                       00644800
 470	call vneg(xsamp,1,xsamp,1,nsamps)
C                                                                       00644900
 500  RETURN                                                            00645000
      END                                                               00645100
C  ROUTINE:       STATCK                                                00645200
C  ROUTINE TYPE:  SUBROUTINE                                            00645300
C  PURPOSE:  CHECK VALIDITY OF CALCULATED STATICS                       00645400
C  AUTHOR:  DOUGLAS BODDY                                               00645500
C  DATE WRITTEN:  AUGUST 1985                                           00645600
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00645700
C                                                                       00645800
      SUBROUTINE STATCK (CORINI,CORREC,STATIC,LCN,IPR,IBUF2)            00645900
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
        integer savelu,status,length,iform
C                                                                       00646000
      INTEGER*2 IBUF2(128)                                              00646100
C                                                                       00646200
      LOGICAL WRNFLG
C                                                                       00646400
        status = savelu('RecNum',iform,l_RecNum,length,TRACEHEADER)
        status = savelu('TrcNum',iform,l_TrcNum,length,TRACEHEADER)
        status = savelu('StaCor',iform,l_StaCor,length,TRACEHEADER)
        status = savelu('InStUn',iform,l_InStUn,length,TRACEHEADER)
        status = savelu('RcStUn',iform,l_RcStUn,length,TRACEHEADER)
        status = savelu('ToStUn',iform,l_ToStUn,length,TRACEHEADER)
      WRNFLG = .FALSE.                                                  00646500
      I8 = IFIX(CORINI * 4000. + SIGN(0.5,CORINI))                      00646600
      IF (I8.LT.30000.AND.I8.GE.-32767) GO TO 200                       00646700
      IF (IBUF2(l_StaCor).EQ.30000) GO TO 150
cmam  IF (IBUF2(125).EQ.30000) GO TO 150                                00646800
      WRNFLG = .TRUE.                                                   00646900
      IF (LCN.GT.200) GO TO 300                                         00647000
      WRITE (IPR,100) I8,IBUF2(l_TrcNum)
cmam  WRITE (IPR,100) I8,IBUF2(107)                                     00647100
 100  FORMAT (' ** WARNING ** CALCULATED INITIATION STATIC: ',          00647200
     $ I8,' (1/4 MS) OUT OF RANGE - HDR WORD   8 ',                     00647300
     $ 'SET TO ZERO - TRACE',I5)                                        00647400
 150  I8 = 0                                                            00647500
C                                                                       00647600
 200  IBUF2(l_InStUn) = I8
c200  IBUF2(8) = I8                                                     00647700
C                                                                       00647800
 300  I11 = IFIX(CORREC * 4000. + SIGN(0.5,CORREC))                     00647900
      IF (I11.LT.30000.AND.I11.GE.-32767) GO TO 500                     00648000
      IF (IBUF2(l_StaCor).EQ.30000) GO TO 450
cmam  IF (IBUF2(125).EQ.30000) GO TO 450                                00648100
      WRNFLG = .TRUE.                                                   00648200
      IF (LCN.GT.200) GO TO 600                                         00648300
      WRITE (IPR,400) I11,IBUF2(l_TrcNum)
cmam  WRITE (IPR,400) I11,IBUF2(107)                                    00648400
 400  FORMAT (' ** WARNING ** CALCULATED RECEPTION STATIC:  ',          00648500
     $ I8,' (1/4 MS) OUT OF RANGE - HDR WORD  11 ',                     00648600
     $ 'SET TO ZERO - TRACE',I5)                                        00648700
 450  I11 = 0                                                           00648800
C                                                                       00648900
 500  IBUF2(l_RcStUn) = I11
c500  IBUF2(11) = I11                                                   00649000
C                                                                       00649100
 600  I15 = I8 + I11                                                    00649200
      IF (I15.LT.30000.AND.I15.GE.-32767) GO TO 800                     00649300
      IF (IBUF2(l_StaCor).EQ.30000) GO TO 750
cmam  IF (IBUF2(125).EQ.30000) GO TO 750                                00649400
      WRNFLG = .TRUE.                                                   00649500
      IBUF2(l_ToStUn) = 0
cmam  IBUF2(15) = 0                                                     00649600
      IF (LCN.GT.200) GO TO 900                                         00649700
      WRITE (IPR,700) I15,IBUF2(l_TrcNum)
cmam  WRITE (IPR,700) I15,IBUF2(107)                                    00649800
 700  FORMAT (' ** WARNING ** CALCULATED TOTAL STATIC:      ',          00649900
     $ I8,' (1/4 MS) OUT OF RANGE - HDR WORD  15 ',                     00650000
     $ 'SET TO ZERO - TRACE',I5)                                        00650100
 750  I15 = 0                                                           00650200
C                                                                       00650300
 800  IBUF2(15) = I15                                                   00650400
c800  IBUF2(l_ToStUn) = I15
C                                                                       00650500
 900  IF (IBUF2(l_StaCor).GE.30000) GO TO 1200
c900  IF (IBUF2(125).GE.30000) GO TO 1200                               00650600
      I125 = STATIC + SIGN(0.5,STATIC)                                  00650700
      IF (I125.GE.-32767.AND.I125.LT.30000) GO TO 1100                  00650800
      IBUF2(l_StaCor) = 30000
cmam  IBUF2(125) = 30000                                                00650900
      IF (LCN.GT.200) GO TO 1200                                        00651000
      WRITE (IPR,1000) I125,IBUF2(l_TrcNum)
cmam  WRITE (IPR,1000) I125,IBUF2(107)                                  00651100
 1000 FORMAT (' ** WARNING ** TOTAL STATIC: ',I8,                       00651200
     $ ' (MS) IS OUT OF RANGE - TRACE FLAGGED DEAD (WORD 125=30000)',   00651300
     $ ' FOR TRACE',I5)                                                 00651400
      GO TO 1200                                                        00651500
C                                                                       00651600
 1100 IBUF2(l_StaCor) = I125
c1100 IBUF2(125) = I125                                                 00651700
C                                                                       00651800
 1200 IF (.NOT.WRNFLG) GO TO 1500                                       00651900
      LCN = LCN + 1                                                     00652000
      IF (LCN.LT.201) GO TO 1350                                        00652100
      IF (LCN.GT.201) GO TO 1500                                        00652200
      WRITE (IPR,1300)                                                  00652300
 1300 FORMAT ('0** WARNING ** REMAINING STATICS OUT OF RANGE WILL NOT ',00652400
     $        'BE PRINTED')                                             00652500
      GO TO 1500                                                        00652600
C                                                                       00652700
 1350 WRITE (IPR,1400)                                                  00652800
 1400 FORMAT (' ')                                                      00652900
C                                                                       00653000
 1500 RETURN                                                            00653100
      END                                                               00653200
C  ROUTINE:       PRSHOT                                                00653300
C  ROUTINE TYPE:  SUBROUTINE                                            00653400
C  PURPOSE:  PRINT SHOT INFO                                            00653500
C  AUTHOR:  DOUGLAS BODDY                                               00653600
C  DATE WRITTEN:  AUGUST 1985                                           00653700
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00653800
C                                                                       00653900
      SUBROUTINE PRSHOT (ICTRSC,CORINI,DEPHOL)                          00654000
C                                                                       00654100
      DOUBLE PRECISION RAD                                              00654200
C                                                                       00654300
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
	character*4 card, TDIS, SPAR
C                                                                       00654500
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00655100
      TMP1 = BUF(ICTRSC,13)                                             00655200
      CORINI = CORINI * 1000.                                           00655300
C                                                                       00655400
      ZF1 = BUF(ICTRSC,12)                                              00655500
      ZF2 = BUF(ICTRSC,11)                                              00655600
      WRITE (IPR,50) CORINI,TMP1,ZF1,ZF2,DEPHOL                         00655700
 50   FORMAT (1X,'INIT CORR   =',F9.2,' MS  ',                          00655800
     $           'UPHOLE TIME=',F9.3,' MS',2X,                          00655900
     $ 'REPL VEL   =',F9.3,2X,'RRS ELEV =',F9.3,3X,'SHOT DEPTH =',F9.3) 00656000
C                                                                       00656100
      IF (.NOT.ST3FLG) GO TO 150                                        00656200
      ZF1 = BUF(ICTRSC,6)                                               00656300
      ZF2 = BUF(ICTRSC,8)                                               00656400
      ZF3 = BUF(ICTRSC,10)                                              00656500
      ZF4 = BUF(ICTRSC,5)                                               00656600
      ZF5 = BUF(ICTRSC,7)                                               00656700
      ZF6 = BUF(ICTRSC,9)                                               00656800
      WRITE (IPR,100) ZF1,ZF2,ZF3,ZF4,ZF5,ZF6                           00656900
 100  FORMAT (1X,'WX VEL 1    =',F9.3,5X,'WX VEL 2   =',F9.3,5X,        00657000
     $                                   'WX VEL 3   =',F9.3/           00657100
     $        1X,'WX THICK 1  =',F9.3,5X,'WX THICK 2 =',F9.3,5X,        00657200
     $                                   'WX THICK 3 =',F9.3)           00657300
      GO TO 350                                                         00657400
C                                                                       00657500
 150  IF (.NOT.ST2FLG) GO TO 250                                        00657600
      ZF1 = BUF(ICTRSC,6)                                               00657700
      ZF2 = BUF(ICTRSC,8)                                               00657800
      ZF3 = BUF(ICTRSC,5)                                               00657900
      ZF4 = BUF(ICTRSC,7)                                               00658000
      WRITE (IPR,200) ZF1,ZF2,ZF3,ZF4                                   00658100
 200  FORMAT (1X,'WX VEL 1    =',F9.3,5X,'WX VEL 2   =',F9.3/           00658200
     $        1X,'WX THICK 1  =',F9.3,5X,'WX THICK 2 =',F9.3)           00658300
      GO TO 350                                                         00658400
C                                                                       00658500
 250  IF (.NOT.ST1FLG) GO TO 350                                        00658600
      ZF1 = BUF(ICTRSC,6)                                               00658700
      ZF2 = BUF(ICTRSC,5)                                               00658800
      WRITE (IPR,300) ZF1,ZF2                                           00658900
 300  FORMAT (1X,'WX VEL 1    =',F9.3,5X,'WX THICK 1 =',F9.3)           00659000
C                                                                       00659100
 350  RETURN                                                            00659200
      END                                                               00659300
C  ROUTINE:       PRTRAC                                                00659400
C  ROUTINE TYPE:  SUBROUTINE                                            00659500
C  PURPOSE:  PRINT TRACE INFO                                           00659600
C  AUTHOR:  DOUGLAS BODDY                                               00659700
C  DATE WRITTEN:  AUGUST 1985                                           00659800
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00659900
C                                                                       00660000
      SUBROUTINE PRTRAC (IPR,MODEPR,NTPR,IDSAV1,KDSAV1,maxtrc,
cmam  SUBROUTINE PRTRAC (IPR,MODEPR,NTPR,SAVE,ISAVE,                    00660100
     $                   ISYS,LTBG,IFTAG,SPLTFL)                        00660200
C                                                                       00660300
cmam  DIMENSION SAVE(8192,3)                                            00660400
      DIMENSION STHOLD(8)                                               00660500
C                                                                       00660600
      INTEGER*2 MODEPR,ISYS                                             00660700
cmam  INTEGER*2 ISAVE(8192,3)                                           00660800
      INTEGER*2 ITN(8)                                                  00660900
C                                                                       00661000
      LOGICAL SPLTFL
C                                                                       00661200
cmam...............6-20-94................
	real save(maxtrc,3),dum1(1)
	integer*2 isave(maxtrc,3),idum1(1)
	pointer (idsav1,dum1),(kdsav1,idum1)
	pointer(ipsav1,save)
	pointer(kpsav1,isave)
	ipsav1 = idsav1
	kpsav1 = kdsav1
cmam.......................................
      IF (MODEPR.EQ.2) GO TO 500                                        00661300
      J = NTPR / 2                                                      00661400
      IF (J*2.NE.NTPR) J = J + 1                                        00661500
      IF (MODEPR.EQ.1) GO TO 250                                        00661600
      WRITE (IPR,50)                                                    00661700
 50   FORMAT ('0',2(19X,2('TRACE',5X),3X,'TRACE LOCATION',10X)/         00661800
     $         2(1X,'TRACE  G.I.  D.I. DISTANCE  STATIC',3X,            00661900
     $            'X COORDINATE',3X,'Y COORDINATE',1X)/                 00662000
     $           3(1X,5('-')),1X,6('-'),1X,9('-'),2(1X,14('-')),1X,     00662100
     $           3(1X,5('-')),1X,6('-'),1X,9('-'),2(1X,14('-')),1X)     00662200
C                                                                       00662300
      IF (ISYS.NE.2) GO TO 90                                           00662400
      I1 = 1                                                            00662500
      IF (SPLTFL) GO TO 80                                              00662600
      WRITE (IPR,150) I1,(ISAVE(1,I2),I2=1,3),(SAVE(1,I3),I3=1,3),      00662700
     $       NTPR,(ISAVE(NTPR,I2),I2=1,3),(SAVE(NTPR,I3),I3=1,3)        00662800
      GO TO 800                                                         00662900
C                                                                       00663000
 80   WRITE (IPR,150) I1,(ISAVE(1,I2),I2=1,3),(SAVE(1,I3),I3=1,3),      00663100
     $           IFTAG,(ISAVE(IFTAG,I2),I2=1,3),(SAVE(IFTAG,I3),I3=1,3) 00663200
      WRITE(IPR,150)LTBG,(ISAVE(LTBG,I2),I2=1,3),(SAVE(LTBG,I3),I3=1,3),00663300
     $              NTPR,(ISAVE(NTPR,I2),I2=1,3),(SAVE(NTPR,I3),I3=1,3) 00663400
      GO TO 800                                                         00663500
C                                                                       00663600
 90   DO 200 I1=1,J                                                     00663700
         I1B = I1 + J                                                   00663800
         IF (I1B.LE.NTPR) GO TO 100                                     00663900
         WRITE (IPR,150) I1,(ISAVE(I1,I2),I2=1,3),(SAVE(I1,I3),I3=1,3)  00664000
         GO TO 200                                                      00664100
C                                                                       00664200
 100     WRITE (IPR,150) I1,(ISAVE(I1,I2),I2=1,3),(SAVE(I1,I3),I3=1,3), 00664300
     $                  I1B,(ISAVE(I1B,I2),I2=1,3),(SAVE(I1B,I3),I3=1,3)00664400
 150     FORMAT (2(3(1X,I5),1X,I6,1X,F9.2,F15.3,F15.3,1X))              00664500
 200  CONTINUE                                                          00664600
C                                                                       00664700
      GO TO 800                                                         00664800
C                                                                       00664900
 250  WRITE (IPR,300)                                                   00665000
 300  FORMAT ('0',2(19X,'TRACE',18X,'TRACE LOCATION',10X)/              00665100
     $         2(1X,'TRACE  G.I.  D.I. DISTANCE',11X,                   00665200
     $            'X COORDINATE',3X,'Y COORDINATE',1X)/                 00665300
     $           3(1X,5('-')),1X,6('-'),10X,2(1X,14('-')),1X,           00665400
     $           3(1X,5('-')),1X,6('-'),10X,2(1X,14('-')),1X)           00665500
C                                                                       00665600
      IF (ISYS.NE.2) GO TO 330                                          00665700
      I1 = 1                                                            00665800
      IF (SPLTFL) GO TO 310                                             00665900
      WRITE (IPR,400) I1,(ISAVE(1,I2),I2=1,3),(SAVE(1,I3),I3=2,3),      00666000
     $       NTPR,(ISAVE(NTPR,I2),I2=1,3),(SAVE(NTPR,I3),I3=2,3)        00666100
      GO TO 800                                                         00666200
C                                                                       00666300
 310  WRITE (IPR,400) I1,(ISAVE(1,I2),I2=1,3),(SAVE(1,I3),I3=2,3),      00666400
     $    IFTAG,(ISAVE(IFTAG,I2),I2=1,3),(SAVE(IFTAG,I3),I3=2,3)        00666500
      WRITE(IPR,400)LTBG,(ISAVE(LTBG,I2),I2=1,3),(SAVE(LTBG,I3),I3=2,3),00666600
     $              NTPR,(ISAVE(NTPR,I2),I2=1,3),(SAVE(NTPR,I3),I3=2,3) 00666700
      GO TO 800                                                         00666800
C                                                                       00666900
 330  DO 450 I1=1,J                                                     00667000
         I1B = I1 + J                                                   00667100
         IF (I1B.LE.NTPR) GO TO 350                                     00667200
         WRITE (IPR,400) I1,(ISAVE(I1,I2),I2=1,3),(SAVE(I1,I3),I3=2,3)  00667300
         GO TO 450                                                      00667400
C                                                                       00667500
 350     WRITE (IPR,400) I1,(ISAVE(I1,I2),I2=1,3),(SAVE(I1,I3),I3=2,3), 00667600
     $                I1B,(ISAVE(I1B,I2),I2=1,3),(SAVE(I1B,I3),I3=2,3)  00667700
 400     FORMAT (2(3(1X,I5),1X,I6,10X,F15.3,F15.3,1X))                  00667800
 450  CONTINUE                                                          00667900
C                                                                       00668000
      GO TO 800                                                         00668100
C                                                                       00668200
 500  IF (ISYS.NE.2) GO TO 530                                          00668300
      WRITE (IPR,510)                                                   00668400
 510  FORMAT ('0',4('TRACE',3X,'STATIC',2X)/                            00668500
     $        1X,4(5('-'),1X,9('-'),1X))                                00668600
      ITN(1) = 1                                                        00668700
      IF (SPLTFL) GO TO 520                                             00668800
      WRITE (IPR,700) ITN(1),SAVE(1,1),NTPR,SAVE(NTPR,1)                00668900
      GO TO 800                                                         00669000
C                                                                       00669100
 520  WRITE (IPR,700) ITN(1),SAVE(1,1),LTBG,SAVE(LTBG,1),               00669200
     $             IFTAG,SAVE(IFTAG,1),NTPR,SAVE(NTPR,1)                00669300
      GO TO 800                                                         00669400
C                                                                       00669500
 530  J = NTPR / 8                                                      00669600
      IF (J*8.NE.NTPR) J = J + 1                                        00669700
      WRITE (IPR,550)                                                   00669800
 550  FORMAT ('0',8('TRACE',3X,'STATIC',2X)/                            00669900
     $        1X,8(5('-'),1X,9('-'),1X))                                00670000
C                                                                       00670100
      DO 750 I1=1,J                                                     00670200
C                                                                       00670300
         CALL MOVE (0,ITN,0,16)                                         00670400
         CALL MOVE (0,STHOLD,0,32)                                      00670500
         NN = 8                                                         00670600
         JJ = 9                                                         00670700
C                                                                       00670800
         DO 650 KK=1,8                                                  00670900
            JJ = JJ - 1                                                 00671000
            LL = (JJ - 1) * J + I1                                      00671100
            IF (LL.LE.NTPR) GO TO 600                                   00671200
            NN = NN - 1                                                 00671300
            GO TO 650                                                   00671400
C                                                                       00671500
 600        STHOLD(JJ) = SAVE(LL,1)                                     00671600
            ITN(JJ) = LL                                                00671700
 650     CONTINUE                                                       00671800
C                                                                       00671900
         WRITE (IPR,700) (ITN(II),STHOLD(II),II=1,NN)                   00672000
 700     FORMAT (1X,8(I5,1X,F9.2,1X))                                   00672100
 750  CONTINUE                                                          00672200
C                                                                       00672300
 800  RETURN                                                            00672400
      END                                                               00672500
C  ROUTINE:       INTDIS                                                00672600
C  ROUTINE TYPE:  SUBROUTINE                                            00672700
C  PURPOSE:  INTERPOLATE MISSING DISTANCES                              00672800
C  AUTHOR:  DOUGLAS BODDY                                               00672900
C  DATE WRITTEN:  AUGUST 1985                                           00673000
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00673100
C                                                                       00673200
      SUBROUTINE INTDIS (DIST,NTPR,IPR,ICC)                             00673300
C                                                                       00673400
      DIMENSION DIST(*)
cmam  DIMENSION DIST(8192)                                              00673500
C                                                                       00673600
      I = 1                                                             00673700
      IF (DIST(1) .NE. 0.0) GO TO 40                                    00673800
      WRITE (IPR,10)                                                    00673900
 10   FORMAT ('0** M8005 ** ERROR DETECTED BY SUBROUTINE INTDIS:'/      00674000
     $ 13X,'"8TDIS" CARDS WERE ENTERED BUT A NON-ZERO DISTANCE WAS ',   00674100
     $     'NOT SUPPLIED FOR TRACE 1')                                  00674200
      ICC = 100                                                         00674300
C                                                                       00674400
      DO 20 I=1,NTPR                                                    00674500
         IF (DIST(I).NE.0.0) GO TO 40                                   00674600
 20   CONTINUE                                                          00674700
C                                                                       00674800
      WRITE (IPR,30)                                                    00674900
 30   FORMAT ('0** M8010 ** ERROR DETECTED BY SUBROUTINE INTDIS:'/      00675000
     $ 13X,'NO NON-ZERO DISTANCES WERE FOUND ON THE "8TDIS" CARDS ',    00675100
     $     'CORRESPONDING TO POSITIVE TRACE NUMBERS')                   00675200
      ICC = 100                                                         00675300
      GO TO 100                                                         00675400
C                                                                       00675500
 40   IF (I+1.GT.NTPR) GO TO 100                                        00675600
      IF (DIST(I+1).EQ.0.0) GO TO 50                                    00675700
      I = I + 1                                                         00675800
      GO TO 40                                                          00675900
C                                                                       00676000
 50   K = I + 1                                                         00676100
      KTR = 0                                                           00676200
      OLD = DIST(I)                                                     00676300
C                                                                       00676400
      DO 60 J=K,NTPR                                                    00676500
         KTR = KTR + 1                                                  00676600
         IF (DIST(J).NE.0.0) GO TO 80                                   00676700
 60   CONTINUE                                                          00676800
C                                                                       00676900
      WRITE (IPR,70) NTPR                                               00677000
 70   FORMAT ('0** M8015 ** ERROR DETECTED BY SUBROUTINE INTDIS:'/      00677100
     $ 13X,'"8TDIS" CARDS WERE ENTERED BUT A NON-ZERO DISTANCE WAS ',   00677200
     $     'NOT SUPPLIED FOR TRACE ',I4)                                00677300
      ICC = 100                                                         00677400
      GO TO 100                                                         00677500
C                                                                       00677600
 80   AVG = (DIST(J) - OLD) / FLOAT(KTR)                                00677700
      DN = 0.0                                                          00677800
      I = J                                                             00677900
      J = J - 1                                                         00678000
C                                                                       00678100
      DO 90 L=K,J                                                       00678200
         DN = DN + 1.0                                                  00678300
         DIST(L) = OLD + AVG * DN                                       00678400
 90   CONTINUE                                                          00678500
C                                                                       00678600
      GO TO 40                                                          00678700
C                                                                       00678800
 100  RETURN                                                            00678900
      END                                                               00679000
C  ROUTINE:       BLOCK DATA                                            00679100
C  ROUTINE TYPE:  BLOCK DATA                                            00679200
C  PURPOSE:  INITIALIZE COMMON'S                                        00679300
C  AUTHOR:  DOUGLAS BODDY                                               00679400
C  DATE WRITTEN:  AUGUST 1985                                           00679500
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00679600
C                                                                       00679700
C=======================================================================00679800
C======= CODE DIFFERENCES BETWEEN IBM AND PERKIN-ELMER =================00679900
C=============================           ===============================00680000
      BLOCK DATA                                                        00680100
C     BLOCK DATA COMAAA                                                 00680200
C=======================================================================00680300
C=======================================================================00680400
C                                                                       00680500
c...............................................
#ifdef CRAYSYSTEM
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6128),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#else
      COMMON /UPDCOM/ RAD,IPR,INX1ST,IGNDXS,ICC,NLOC,IDSK1,IDSK2,IDKUN, 00022300
     $                INOMUN,ZMISS,SPAR,TDIS,NTPR,XGRINT,IBUF4(6064),   00022400
     $                CARD(20),INDXBF,BUFF(15),INDXSP,ISPBUF(1),        00022500
     $                BUFMAX(7),BUFMIN(7),INOM(16),INOMCT(4),INDXIO(4), 00022600
     $                NSAMPS,IFOR,ST1FLG,ST2FLG,ST3FLG,DISK             00022700
#endif
c...............................................
C                                                                       00681100
      COMMON /PLTCOM/ ICODE,NUMDEV,ILINE,IPRTY,
     $                XXADD,YYADD,XPLT1,FONTUN,XLIBR,                   00681300
     $                THKMAX,XSTATN,DSN,PRNT,PLOT,FLGO,INTERA,igscod
C                                                                       00681500
      DOUBLE PRECISION RAD                                              00681600
C                                                                       00681700
      character*4 SPAR,TDIS,igscod, card
cmam  INTEGER SPAR,TDIS                                                 00681800
C                                                                       00681900
      LOGICAL ST1FLG,ST2FLG,ST3FLG,DISK
      LOGICAL PRNT,PLOT,FLGO,INTERA
C                                                                       00682200
C=======================================================================00682300
C                                                                       00683000
      DATA IGNDXS/0/                                                    00683100
      DATA INDXBF/0/                                                    00683200
      DATA ICC/0/                                                       00683300
#ifdef CRAYSYSTEM
      DATA ZMISS/-1.0E+60/                                              00683400
      DATA IBUF4/6064*0/                                                00683500
      DATA BUFF/15*-1.0E+60/                                            00683600
      DATA BUFMAX/7*-1.0E+60/                                           00683700
      DATA BUFMIN/7*1.0E+60/                                            00683800
#else
      DATA ZMISS/-1.0E+38/                                              00683400
      DATA IBUF4/6064*0/                                                00683500
      DATA BUFF/15*-1.0E+38/                                            00683600
      DATA BUFMAX/7*-1.0E+38/                                           00683700
      DATA BUFMIN/7*1.0E+38/                                            00683800
#endif
      DATA ST1FLG/.FALSE./,ST2FLG/.FALSE./,ST3FLG/.FALSE./,DISK/.FALSE./00683900
      DATA SPAR/'SPAR'/,TDIS/'TDIS'/                                    00684000
      DATA INOMCT/4*0/                                                  00684100
C                                                                       00684200
      DATA PRNT/.FALSE./,PLOT/.FALSE./,FLGO/.FALSE./,INTERA/.FALSE./    00684300
      DATA IGSCOD/'    '/                                               00684400
      DATA XSTATN/1.0/                                                  00684500
      DATA XXADD/0.0/,YYADD/0.0/                                        00684600
      DATA XPLT1/0.0/                                                   00684700
C                                                                       00684800
      END                                                               00684900
C***********************************************************************00685000
C----------------------------------------------------------------------C00270103
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C00271003
C----------------------------------------------------------------------C00280003
C-- DEFLDH - DELETE FIELD HISTORY INFORMATION FROM SEISMIC LINE      --C00290003
C--          HEADER.                                                 --C00300003
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C00310003
C----------------------------------------------------------------------C00320003
      SUBROUTINE DEFLDH ( IHEAD , HDRLEN, HEADER )                      00330003
      IMPLICIT   INTEGER*4 (A-Z)                                        00340003
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
        integer IHEAD(*)
      character*1  HEADER(*), HEX5A
      INTEGER  TOTAL, COUNT
#ifndef CRAYSYSTEM
        integer*2 length
#else
        integer length
#endif
        DATA HEX5A / '!' /
 
        FLDHIS = HLHOFF + 1
        POINT = HSTOFF + 1
        INFO = POINT + HLHINT
C--                                                                     00430003
C--------------------------------------------------------------         00440003
C-- MOVE HISTORICAL HEADER ENTRY COUNTER AND LENGTH INTO WORKSPACE      00450003
C--                                                                     00460003
        call saver(IHEAD , 'HlhEnt', COUNT, 0)
        call saver(IHEAD , 'HlhByt', TOTAL, 0)
C--                                                                     00480003
C--------------------------------------------------------------         00490003
C-- CHECK BOUNDARY CONDITION (NO HISTORICAL INFO...)                    00500003
C--                                                                     00510003
   10 IF (COUNT.LE.0) GOTO 20                                           00520003
C--                                                                     00530003
C--------------------------------------------------------------         00540003
C-- OBTAIN LENGTH OF THIS ENTRY AND ADDRESS OF NEXT ENTRY               00550003
C--                                                                     00560003
         CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)                  00570003
#ifndef CRAYSYSTEM
         NEXT = INFO + LENGTH                                           00580003
#else
        LENGTH = (INT((LENGTH + 7) / 8) * 8)
        NEXT = INFO + LENGTH
#endif
C--                                                                     00590003
C--------------------------------------------------------------         00600003
C-- IF THIS ENTRY IS FLAGGED AS HISTORICAL, THEN DELETE THE ENTRY       00610003
C--    ALSO UPDATE OVERALL LENGTH OF LINE HEADER                        00620003
C--                                                                     00630003
         IF (HEADER(INFO).NE.HEX5A) GOTO 20                             00640003
            LENGTH = LENGTH + HLHINT                                    00650003
            TOTAL = TOTAL - LENGTH                                      00660003
            COUNT = COUNT - 1                                           00670003
            HDRLEN = HDRLEN - LENGTH                                    00680003
            LEN4 = TOTAL                                                00690003
            CALL MOVE ( 4, HEADER(POINT), HEADER(NEXT), LEN4 )          00700003
            GOTO 10                                                     00710003
C--                                                                     00720003
C--------------------------------------------------------------         00730003
C-- UPDATE HEADER...                                                    00740003
C--                                                                     00750003
   20 call savew(IHEAD , 'HlhEnt', COUNT, 0)
      call savew(IHEAD , 'HlhByt', TOTAL, 0)
 
      RETURN                                                            00770003
      END                                                               00780003
C----------------------------------------------------------------------C00790003
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C00800003
C----------------------------------------------------------------------C00810003
C-- INFLDH - INSERT FIELD HISTORY INFORMATION INTO SEISMIC LINE      --C00820003
C--          HEADER.                                                 --C00830003
C----------------------------------------------------------------------C00840003
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C00850003
C----------------------------------------------------------------------C00860003
C-- CATALOGUED AND TESTED - 10/25/82 9:00 AM                         --C00870003
C----------------------------------------------------------------------C00880003
C-- ABSTRACT - INSERT ONE (1) LINE OF FIELD HISTORY INFORMATION INTO --C00890003
C--            A SEISMIC LINE HEADER.  ENTRY IS PLACED AT END OF     --C00900003
C--            "FIELD" INFORMATION IMMEDIATELY BEFORE "PROCESSING"   --C00910003
C--            INFORMATION.  LENGTH OF OVERALL HEADER IS ALSO RESET. --C00920003
C----------------------------------------------------------------------C00930003
      SUBROUTINE INFLDH ( IHEAD , HDRLEN, FLD, FLDLEN, HEADER )         00940003
      IMPLICIT   INTEGER*4 (A-Z)                                        00950003
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
        integer IHEAD(*)
      character*1  HEADER(*), HEX5A, FLD(*)
        integer kount,ktot
#ifndef CRAYSYSTEM
      INTEGER*2 WORKSP(2),LENGTH,TOTAL,COUNT
#else
      INTEGER WORKSP(2),LENGTH,TOTAL,COUNT
#endif
      EQUIVALENCE (WORKSP(1),COUNT),                                    00980003
     $            (WORKSP(2),TOTAL)                                     00990003
        DATA HEX5A / '!' /
        FLDHIS = HLHOFF + 1
        START = HSTOFF + 1
        iNFO = START + HLHINT
C--                                                                     01040003
C--------------------------------------------------------------         01050003
C-- MOVE ITEM COUNT AND LENGTH INTO WORKSPACE                           01060003
C--                                                                     01070003
        call saver(IHEAD , 'HlhEnt', KOUNT, 0)
        call saver(IHEAD , 'HlhByt', KTOT, 0)
        count = kount
        total = ktot
 
C--                                                                     01090003
C--------------------------------------------------------------         01100003
C-- INITIALIZE POINTERS...                                              01110003
C--                                                                     01120003
      POINT = START                                                     01130003
      ENTRY = INFO                                                      01140003
C--                                                                     01150003
C--------------------------------------------------------------         01160003
C-- IF THE HISTORY IS EMPTY, THEN DON'T BOTHER WITH A SEARCH            01170003
C--                                                                     01180003
      IF (COUNT.LE.0) GOTO 20                                           01190003
C--                                                                     01200003
C--------------------------------------------------------------         01210003
C--     GET NEXT ITEM LENGTH...                                         01220003
C--                                                                     01230003
   10    CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)                  01240003
#ifdef CRAYSYSTEM
        LENGTH = (INT((LENGTH + 7) / 8) * 8)
#endif
C--                                                                     01250003
C--------------------------------------------------------------         01260003
C-- IF THIS ENTRY IS A FIELD HISTORY ENTRY, THEN WE SKIP BY IT.         01270003
C--    AND POINT TO THE NEXT ITEM                                       01280003
C--                                                                     01290003
         IF (HEADER(ENTRY).NE.HEX5A) GOTO 20                            01300003
            POINT = ENTRY + LENGTH                                      01310003
            ENTRY = POINT + HLHINT                                      01320003
            GOTO 10                                                     01330003
C--                                                                     01340003
C--------------------------------------------------------------         01350003
C-- COMPUTE LENGTH OF REMAINING HEADER INFO AND TARGET ADDRESS          01360003
C--     THEN MOVE THE HEADER ON DOWN INTO POSTION TO MAKE ROOM          01370003
C--     FOR THE NEW HISTORY ENTRY.                                      01380003
C-- (PROVIDED THERE ACTUALLY IS SOMETHING TO BE MOVED)                  01390003
C--                                                                     01400003
   20 continue
        leng1 = FLDLEN + 1
#ifdef CRAYSYSTEM
        leng1 = (INT((leng1 + 7) / 8) * 8)
#endif
      MOVLEN = START + TOTAL - POINT                                    01410003
      NEWLOC = POINT + leng1 + HLHINT                                   01420003
      IF (MOVLEN.GT.0) then                                             01430003
        call move(4,HEADER(NEWLOC),HEADER(POINT),MOVLEN)
        endif
C--                                                                     01450003
C--------------------------------------------------------------         01460003
C-- FLAG THIS ENTRY AS HISTORY                                          01470003
C--                                                                     01480003
      HEADER(ENTRY) = HEX5A                                             01490003
C--                                                                     01500003
C--------------------------------------------------------------         01510003
C-- MOVE THE ENTRY INTO POSITION (WE DON'T CARE HOW LONG IT IS)         01520003
C--                                                                     01530003
      ENTRY = ENTRY + 1                                                 01540003
      CALL MOVE ( 1, HEADER(ENTRY), FLD, FLDLEN )                       01550003
C--                                                                     01560003
C--------------------------------------------------------------         01570003
C-- SET THE LENGTH OF THE ENTRY...                                      01580003
C--                                                                     01590003
       LENGTH = FLDLEN + 1                                              01600003
      CALL MOVE ( 1, HEADER(POINT), LENGTH, HLHINT)                     01610003
C--                                                                     01620003
C--------------------------------------------------------------         01630003
C-- UPDATE ENTRY COUNT AND TOTAL BYTE LENGTH OF HISTORY HEADER          01640003
C--    THEN GO HOME                                                     01650003
C--                                                                     01660003
      COUNT = COUNT + 1                                                 01670003
      TOTAL = TOTAL + leng1  + HLHINT                                   01680003
      HDRLEN = HDRLEN + leng1  + HLHINT                                 01690003
        kount = count
        ktot = total
        call savew(IHEAD , 'HlhEnt', KOUNT, 0)
        call savew(IHEAD , 'HlhByt', KTOT, 0)
 
      RETURN                                                            01710003
      END                                                               01720003
C----------------------------------------------------------------------C01730003
C--     AMOCO PRODUCTION COMPANY - SEISMIC TRACE PROCESSING GROUP    --C01740003
C--                  FOR USE WITH 'FLDHIS' ROUTINES...               --C01750003
C----------------------------------------------------------------------C01760003
C-- CHARACTER STRING LENGTH FUNCTION - RETURN NUMBER OF CHARACTERS   --C01770003
C-- IN AN ARRAY, ZERO IF ARRAY IS ALL BLANK, ROUTINE ACTS AS A       --C01780003
C-- 'TRIMMING' FUNCTION FOR CHARACTER STRING DATA                    --C01790003
C----------------------------------------------------------------------C01800003
C-- RUSSELL L. WILSON --- 09/05/83 --- 963 SOUTH TDC --- EXT.3783    --C01810003
C----------------------------------------------------------------------C01820003
      INTEGER FUNCTION  LENG2 (STRING,MAXLEN)
      character*1 BLANK,  STRING (*)
      INTEGER*4   MAXLEN
      DATA        BLANK   /' '/
 
      LENG2 = MAXLEN + 1
   10 LENG2 = LENG2 - 1
         IF (LENG2.LT.1) RETURN
         IF (STRING(LENG2).EQ.BLANK)  GOTO 10
      RETURN
      END
c...............................................................................
      subroutine sbias (biasflg, spmul, fstsp, spnum)
 
      integer       biasflg, spmul, fstsp, spnum
 
      if (biasflg .eq. 0) then
         spnum = fstsp
      else
         spnum = fstsp + spmul * 10000
      endif
 
      return
      end
 
c...............................................................................
      subroutine spbias (biasflg, itr, dibsp, srcnum)
 
#include <save_defs.h>
      integer * 2  itr(*)
      integer      biasflg, dibsp, srcnum
 
ccccccc   call savew (itr, 'SrcLoc', srcnum, 1)    cccccccc
      call savew (itr, 'SrcPnt', dibsp , 1)
      call savew (itr, 'SoPtNm', srcnum, 1)
 
      return
      end
c...............................................................................
      subroutine help1
#include <f77/iounit.h>
 
          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM laip................Land Line Indexing'
         write(LER,*)' '
         write(LER,*)
     :' -N [ntap]   (default: pipe in)   : Input data file name'
         write(LER,*)
     :' -O [otap]   (default: pipe out)  : Output data file name'
         write(LER,*)
     :' -C [cardin]    (no default)      : Card data file name'
         write(LER,*)
     :'   the file cardin must contain these card images:'
         write(LER,*)
     :'    1LAIP : required'
         write(LER,*)
     :'    2LAIP : optional; required if indexing'
         write(LER,*)
     :'    1GPAR : required for first and last group on line'
         write(LER,*)
     :'    2GPAR : optional(1 allowed per 1GPAR card)'
         write(LER,*)
     :'    1SPAR : required for first and last shots on line'
         write(LER,*)
     :'    8TDIS : optional; 1 set allowed per 1SPAR card'
         write(LER,*)
     :'    1GROM : optional; valid only when indexing'
         write(LER,*)
     :'    1GRIN : optional; valid only when indexing'
         write(LER,*)
     :'    1TROM : optional; valid only when indexing'
         write(LER,*)
     :'    1TRIN : optional; valid only when indexing'
         write(LER,*)
     :'    1FLDH : optional'
cmam     write(LER,*)
cmam :' -V [verbos]    (default=no)      : Verbose output '
       write(LER,*)
     :'Usage:  ',
     :' laip -N[ntap] -O[otap] -C[cardin]'
cmam :' laip -N[ntap] -O[otap] -C[cardin]  -V'
       write(LER,*)
     :'***************************************************************'
      return
      end
cmam...........this is a modified version of ISTCHP,STCHP and ENDSTH
cmam........... in order to create the stacking chart in one piece at
cmam........... the bottom of the LERR printout file
C  ROUTINE:       ISTCHP                                                00437700
C  ROUTINE TYPE:  SUBROUTINE                                            00437800
C  PURPOSE:  PRINT STACKING CHART                                       00437900
C  AUTHOR:  L BAIRD                                                     00438000
C  DATE WRITTEN:  AUGUST 1972                                           00438100
C  MODIFIED BY:  DOUGLAS BODDY                                          00438200
C  DATE MODIFIED:  AUGUST 1985                                          00438300
C** AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE **00438400
C                                                                       00438500
	subroutine stkcht(ipr,iunscp,icc,line)
cmam...................................................
#include <f77/lhdrsz.h>
C                                                                       00438800
C
      character*4 FMT4A(5)
C                                                                       00439100
      INTEGER*2 IDI(8192)
C                                                                       00439400
      INTEGER*2 ISRCE(180),RI(180)                                      00439500
C                                                                       00439600
      character*1 OH,EX,DEAD,EXX
      character*1 LINEN(4)
      LOGICAL MOVFL1
C                                                                       00440100
C=================================================================      00440200
      character*1 LINE(*), torf, ioac(3)
C=================================================================      00441000
C                                                                       00441100
        character*4 i10,i106,i58
      DATA I10/'  10'/,I106/' 106'/,I58/'  58'/                         00441200
      DATA ISIZE/180/                                                   00441300
      DATA IODD1/-1/                                                    00441400
      DATA IEND/0/,JFLG/0/,ILINE/0/,ID/1/                               00441500
C                                                                       00441600
      DATA ISRCE/180*0/,RI/180*0/                                       00441700
      data FMT4A/'(11X',',I4,','  58','X,1H','O) '/
      data OH/'O'/,EX/'X'/,DEAD/'D'/
C                                                                       00441800
      LENS = ISIZE * 114                                                00441900
cmam........................
	endfile iunscp
	rewind iunscp
    	read(iunscp) ieos,iobf,(ioac(i),i=1,3),(linen(j),j=1,4),
     *			ntpr,torf
	if(torf.eq.'T') then
	   movfl1 = .true.
	else
	   movfl1 = .false.
	endif
	iunit = iunscp
	iunscp = ipr
C=================================================================      00442000
      IWANT = LENS                                                      00443100
   9  CALL MOVE (2,LINE(1),0,LENS)
      LENS = LENS - 113
      INDX1 = 1
      INDX2 = 114
C=================================================================      00445400
C=================================================================      00445500
C                                                                       00445600
C-----------------------------------------------------------------------00445700
C                  WRITE HEADINGS                                       00445800
C-----------------------------------------------------------------------00445900
C                                                                       00446000
      WRITE (IUNSCP,10)                                                 00446100
   10 FORMAT ('1',T66,'STACKING CHART'/' ')                             00446200
      WRITE (IUNSCP,12)                                                 00446300
   12 FORMAT ('  SRC DPTH REC',T43,'COMMON',T71,'COMMON',T99,'COMMON',  00446400
     $          T120,'OAC-LINE')                                        00446500
      WRITE (IUNSCP,15) IOAC, LINEN                                     00446600
   15 FORMAT (' INDX INDX NO.',T41,'INITIATION',T71,'RANGE',            00446700
     $          T98,'RECEPTION',T119,A4,'-',8A1)                        00446800
      WRITE (IUNSCP,20)                                                 00446900
   20 FORMAT (T44,'X',T73,'X',T102,'X'/                                 00447000
     $        T20,'XXXX COMMON DEPTH PT     X',T73,'X',T101,'X',        00447100
     $                            T107,'X=LIVE TRACE D=DEAD TRACE'/     00447200
     $        T46,'X',T73,'X',T100,'X' /                                00447300
     $        T47,'X',T73,'X',T99,'X' /)                                00447400
C                                                                       00447500
C-----------------------------------------------------------------------00447600
C                  WRITE RANGE HEADINGS                                 00447700
C-----------------------------------------------------------------------00447800
C                                                                       00447900
      IF (IEOS-1) 30,40,50                                              00448000
   30 IZVL = 59                                                         00448100
      FMT4A(3) = I58                                                    00448200
      WRITE (IUNSCP,35)                                                 00448300
   35 FORMAT   (T19,'5    5    4    4    3    3    2    2    1    1',5X,00448400
     $'   RANGES     1    1    2    2    3    3    4    4    5    5' )  00448500
      WRITE (IUNSCP,37)                                                 00448600
   37 FORMAT (1X,T16,'...',11('5....0....'),'5...'//)                   00448700
      GO TO  70                                                         00448800
C                                                                       00448900
   40 IZVL = 11                                                         00449000
      FMT4A(3) = I10                                                    00449100
      WRITE (IUNSCP,45)                                                 00449200
   45 FORMAT (T16,'1       RANGES      1    1    2    2    3    3    ', 00449300
     $            '4    4    5    5    6    6    7    7    8    8' )    00449400
      WRITE (IUNSCP,47)                                                 00449500
   47 FORMAT (1X,T16,11('0....5....'),'0....5.'//)                      00449600
      GO TO 70                                                          00449700
C                                                                       00449800
   50 IZVL = 107                                                        00449900
      FMT4A(3) = I106                                                   00450000
      WRITE (IUNSCP,55)                                                 00450100
   55 FORMAT (T17,'8    8    7    7    6    6    5    5    4    4    ', 00450200
     $            '3    3    2    2    1    1       RANGES      1')     00450300
      WRITE (IUNSCP,57)                                                 00450400
   57 FORMAT (1X,T16,'.',11('5....0....'),'5....0'//)                   00450500
C                                                                       00450600
   70 LENMV1 = (ISIZE - 1) * 114                                        00450700
      LENMV2 = (ISIZE - 1) * SZHFWD
C==================                                   ============      00451100
      IZIN = IZVL
C=================================================================      00451400
      IF (MOVFL1) then
        MODINC = 2
      else
        MODINC = 4
      endif
C                                                                       00451800
C                                                                       00452000
  85  MODD2 = MODINC / 2                                                00452100
C                                                                       00452300
C-----------------------------------------------------------------------00452400
C                  ENTRY FOR EACH RI                                    00452500
C-----------------------------------------------------------------------00452600
C                                                                       00452700
C                                                                       00452900
   86	continue
    	read(iunit,end=300) idisp,iri,iob,(idi(i),i=1,ntpr)
	if(movfl1) then
	  ioddd = 0
	else
	  ioddd = mod(idisp,4)
	endif
C                                                                       00453100
cmam..........
	iflag = 0
	iii = 1
  999	i1 = iii
      DO 250 I =i1, NTPR
	iii = i
	if(iflag.eq.1) go to 110
         J = IDI(I)                                                     00453300
         IF (IDI(I).LT.0) IDI(I) = -IDI(I)                              00453400
         IF (J.GT.0) GO TO 87                                           00453500
         IF (J.EQ.0) GO TO 250                                          00453600
         EXX = DEAD                                                     00453700
         J = -J                                                         00453800
         GO TO 90                                                       00453900
C                                                                       00454000
  87     EXX = EX                                                       00454100
C                                                                       00454200
  90     IVL = IZVL + (J - IDISP) / MODD2                               00454300
         IF (MOVFL1) GO TO 100                                          00454400
         IF (IDISP.GE.J) GO TO 100                                      00454500
         IF (IODDD.EQ.0) IVL = IVL - 1                                  00454600
         JJ = J - IDISP                                                 00454700
         IODDJ = MOD(JJ,2)                                              00454800
         IF (IODDJ.EQ.1) IVL = IVL + 1                                  00454900
         IF (IOBF.NE.1.AND.IODDJ.EQ.0) IVL = IVL + 1                    00455000
  100    IF (IVL.LT.1) GO TO 250                                        00455100
C                                                                       00455200
  107    IHL = J - ILINE                                                00455300
         IF (IHL.LE.0) GO TO 250                                        00455400
C                                                                       00455500
         IF (IHL.LE.ISIZE) GO TO 240                                    00455600
C                                                                       00455700
C-----------------------------------------------------------------------00455800
C                  PRINT A LINE                                         00455900
C-----------------------------------------------------------------------00456000
C                                                                       00456100
         IF (ILINE.GT.0) GO TO 110                                      00456200
C                                                                       00456300
C-----------------------------------------------------------------------00456400
C                  PRINT LINE 1                                         00456500
C-----------------------------------------------------------------------00456600
C                                                                       00456700
         IF (RI(1).EQ.0) GO TO 125                                      00456800
         GO TO 185                                                      00456900
C                                                                       00457000
  110    IODD = MOD(ID,MODINC)                                          00457100
         IF (.NOT.MOVFL1) IODD1 = MOD(ID,2)                             00457200
C                                                                       00457300
         IF (IOBF.NE.1) GO TO 180                                       00457400
         IF (IOB.EQ.0) GO TO 115                                        00457500
         IF (.NOT.MOVFL1) GO TO 112                                     00457600
         IF (IODD.EQ.0) GO TO 150                                       00457700
         GO TO 120                                                      00457800
C                                                                       00457900
 112     IF (IODD.NE.1) GO TO 150                                       00458000
         GO TO 120                                                      00458100
C                                                                       00458200
  115    IF (IODD.NE.0) GO TO 150                                       00458300
C                                                                       00458400
  120    IG = ID / MODINC                                               00458500
         WRITE (IUNSCP,195) IG                                          00458600
         IF (ISRCE(1).LT.0) GO TO 185                                   00458700
  125    CONTINUE                                                       00458800
         WRITE (IUNSCP,130) ID,(LINE(II),II=INDX1,INDX2)                00459300
C=================================================================      00459500
  130    FORMAT (6X,I4,5X,114A1)                                        00459600
         IF (IOBF.EQ.1) GO TO 230                                       00459700
         GO TO 205                                                      00459800
C                                                                       00459900
  150    IF (ISRCE(1).EQ.1) GO TO 155                                   00460000
         IF (RI(1).EQ.0) GO TO 151                                      00460100
         IF (IODD1.EQ.0.OR.IOBF.EQ.1) GO TO 155                         00460200
C                                                                       00460300
  151    WRITE (IUNSCP,152)                                             00460400
  152    FORMAT (' ')                                                   00460500
         GO TO 125                                                      00460600
C                                                                       00460700
  155    WRITE (IUNSCP,FMT4A) RI(1)                                     00460800
         GO TO 125                                                      00460900
C                                                                       00461000
  180    IF (IODD.EQ.0) GO TO 190                                       00461100
         IF (IODD1.EQ.0.AND.RI(1).NE.0) GO TO 185                       00461200
         IF (ISRCE(1).LT.1) GO TO 125                                   00461300
C                                                                       00461400
  185    CONTINUE                                                       00461500
         WRITE (IUNSCP,187) ID,RI(1),(LINE(II),II=INDX1,INDX2)          00462000
C=================================================================      00462200
  187    FORMAT (6X,I4,1X,I4,114A1)                                     00462300
         IF (IOBF.EQ.1) GO TO 230                                       00462400
         GO TO 205                                                      00462500
C                                                                       00462600
  190    IG = ID / MODINC                                               00462700
         IF (RI(1).EQ.0) GO TO 200                                      00462800
         WRITE (IUNSCP,195) IG,ID,RI(1),(LINE(II),II=INDX1,INDX2)       00463300
C=================================================================      00463500
  195    FORMAT (' ',I4,1X,I4,1X,I4,114A1)                              00463600
         GO TO 205                                                      00463700
C                                                                       00463800
  200    CONTINUE                                                       00463900
         WRITE (IUNSCP,202) IG,ID,(LINE(II),II=INDX1,INDX2)             00464400
C=================================================================      00464600
  202    FORMAT (' ',I4,1X,I4,5X,114A1)                                 00464700
C                                                                       00464800
  205    WRITE (IUNSCP,152)                                             00464900
C                                                                       00465000
C-----------------------------------------------------------------------00465100
C                  SHIFT ARRAYS                                         00465200
C-----------------------------------------------------------------------00465300
C                                                                       00465400
  230    CONTINUE                                                       00465500
         CALL MOVE (1,LINE(INDX1),LINE(INDX2+1),LENMV1)                 00466000
C=================================================================      00466100
         CALL MOVE (1,RI(1),RI(2),LENMV2)                               00466300
         CALL MOVE (1,ISRCE(1),ISRCE(2),LENMV2)                         00466400
         ILINE = ILINE + 1                                              00466500
         ID = ID + 1                                                    00466600
         IF (IEND.GT.0) GO TO 400                                       00466700
         CALL MOVE (2,LINE(LENS),0,114)                                 00467200
C=================================================================      00467400
         RI(ISIZE) = 0                                                  00467500
         ISRCE(ISIZE) = 0                                               00467600
         IF (JFLG.EQ.1) GO TO 250                                       00467700
         GO TO 107                                                      00467800
C                                                                       00467900
  240    CONTINUE                                                       00468000
         IF (IVL.LE.114) LINE((IHL-1)*114+IVL) = EXX
cmam     IF (IVL.LE.114) LINE(INDX+(IHL-1)*114+IVL) = EXX               00468500
C=================================================================      00468700
  250 CONTINUE                                                          00468800
C                                                                       00468900
      J = IDISP - ILINE                                                 00469000
      IF (IOBF.EQ.1) J = J + 1                                          00469100
      JFLG = 1                                                          00469200
      IF (J.GT.ISIZE) then
	iflag = 1
	go to 999
      endif
cmam  IF (J.GT.ISIZE) GO TO 110                                         00469300
      IF (J.LT.1) GO TO 86
      JFLG = 0                                                          00469500
      RI(J) = IRI                                                       00469600
      IF (IOB.EQ.1) GO TO 260                                           00469700
      LINE(IZIN+(J-1)*114) = OH                                         00470200
C=================================================================      00470400
      ISRCE(J) = -1                                                     00470500
      GO TO 86
C                                                                       00470700
  260 ISRCE(J) = 1                                                      00470800
C                                                                       00470900
      GO TO 86
C                                                                       00471100
C-----------------------------------------------------------------------00471200
C                  ENTRY TO EMPTY BUFFER                                00471300
C-----------------------------------------------------------------------00471400
C                                                                       00471500
  300	continue
      IEND = 1                                                          00471700
	iflag = 1
      GO TO 999
C                                                                       00471900
  400 IEND = IEND + 1                                                   00472000
	iflag = 1
      IF (IEND.LE.ISIZE) GO TO 999
C                                                                       00472200
C=======================================================================00473800
  500 RETURN                                                            00473900
      END                                                               00474000
