C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c *********************************************************************
c
c  SUBROUTINE LLSHIFT (tzero, deltat, totdt, nxcor, rtrpt, trstk,
c                       nsi, nu, ershifts,dbug)
c
c   This subroutine does the cross correlation and trace shifting
c	for the lobe-to-lobe trace alignment
c
c   "tzero" is the trace start cross correlation offset
c   "deltat" is the trace cross correlation shift time
c   "totdt" is the amount of the trace to be cross correlated
c   "nxcor" is the number of pieces of each trace cross correlated
c   "rtrpt" is the input and shifted output trace data
c   "trstk" is the input stacked data to correlate the input data against
c   "nsi" is the trace sample interval
c   "nu" is the number of angle buckets
c   "ershifts" is the returned number of incorrect shift calculations
c   "dbug" is a debug printout flag
c
c**********************************************************************
 
      subroutine llshift (tzero, deltat, totdt, nxcor, rtrpt, trstk,
     1     nsi, nu, ershifts,dbug)

#include <f77/lhdrsz.h>
  
c  Max number of xcorrelations = 5;
c     shiftcnt and harray arrays must be increased if this number is increased

        real    trstk(SZLNHD), xsotr(SZLNHD), rtrpt(SZLNHD,63)
	real	maxmag, nishifts, harray(6)
	real*4	xcor(SZLNHD)
	integer ncount, tdtsmp, dtsmp, tzsmp, ershifts
	integer	shiftcnt(5), shiftsmp, i, ii, iii
	integer	totdt, deltat, nxcor, tzero, nsi

	logical dbug
 
c
c  Initialize variables
c
	tdtsmp = totdt/nsi
	dtsmp  = deltat/nsi
	if(tzero .gt. 0) then
	     tzsmp  = tzero/nsi
	else
	     tzsmp = 0
	endif

       DO iii = 1,nu
c
c  Clear work array to zeros
c
        call vclr (xsotr, 1, nsamp)

c
c  Cross correlate each trace nxcor times
c
	  DO ii = 1, nxcor
c
c  Cross correlate stack with a trace
c
	     call cross(trstk(tzsmp+dtsmp+((ii-1)*tdtsmp)),
     1	tdtsmp+(2*dtsmp),rtrpt((tzsmp+dtsmp+((ii-1)*tdtsmp)),nu),
     2	tdtsmp+(2*dtsmp),xcor,ncount,dtsmp,dtsmp)

c     if( dbug ) then
c	write(LER,*)'ncount = ',ncount
c	do i = 1,ncount
c		write(LER,*)'xcor(',i,') = ',xcor(i)
c	enddo
c     endif

c
c  Find absolute maximum value, and the shift to get it
c
	     call maxmgv(xcor,1,maxmag,shiftcnt(ii),ncount)

c     if( dbug ) then
c	write(LER,*)'maxmag = ',maxmag
c	write(LER,*)'shiftcnt(',ii,') = ',shiftcnt(ii)
c     endif

c  Enddo cross correlate each trace nxcor times
	  ENDDO

c  	if( dbug ) then
c 	    write(LER,*)'after llshift do loop'
c  	endif

c
c  Find "best" shift as given by most frequent max xcor value
c
	do i = 1, 6
		harray(i) = 0
	enddo
	nishifts = 0.

	call hist(shiftcnt,1,harray,nxcor,ncount+1,ncount+1,0)
c
c  Find number of identical shifts (nishifts) for best cross correlation
c     and the shift sample count (shiftsmp) needed to get there
c
	call maxmgv(harray,1,nishifts,shiftsmp,ncount+1)


c     if( dbug ) then
c	do i=1,(ncount+1)
c	write(LER,*)'harray(',i,') = ',harray(i)
c	enddo
c	write(LER,*)'nishifts = ',nishifts
c     endif
c
c  Subtract 1 from shiftsmp to account for zeroth element in harray
c
	shiftsmp = shiftsmp -1

c     if( dbug ) then
c	write(LER,*)'shiftsmp = ',shiftsmp
c     endif

c
c  Keep track of the number of "erroneous" shifts 
c
	ershifts = ershifts + (nxcor-int(nishifts))

c
c  Determine positive or negative trace shift
c
	if (shiftsmp .lt. (dtsmp-1)) then

c
c  move and positive shift trace if shiftsmp < dtsmp-1
c
 	  call vmov(rtrpt(dtsmp-shiftsmp+1,nu),1,
     1			xsotr,1,(nsamp-(dtsmp-shiftsmp)))
c	  if( dbug ) then
c 	    write(LER,*)'POS samples shifted = ',dtsmp-shiftsmp
c	  endif


c
c  fill in end of trace with value of last valid sample
c
	  do i = 1,(dtsmp-shiftsmp)
		xsotr(nsamp-(dtsmp-shiftsmp)+i)=
     1			xsotr(nsamp-(dtsmp-shiftsmp))
	  enddo

	elseif (shiftsmp .gt. dtsmp) then
c
c  move and negative shift trace if shiftsmp > dtsmp
c    (if shiftsmp = dtsmp, no shifting is needed)
c
	  call vmov(rtrpt(1,nu),1,xsotr(shiftsmp-dtsmp+1),
     1			1,(nsamp-(shiftsmp-dtsmp)))
c	  if( dbug ) then
c 	    write(LER,*)'NEG samples shifted = ',shiftsmp-dtsmp
c	  endif


c
c  fill in front of trace with value of first valid sample
c
	  do i = 1,(shiftsmp-dtsmp)
		xsotr(i) = xsotr(shiftsmp-dtsmp+1)
	  enddo

	else
c	  if( dbug ) then
c 	    write(LER,*)'ZERO samples shifted '
c	  endif

	endif

c
c  move shifted, filled trace back into trace array
c
	call vmov(xsotr,1,rtrpt(1,nu),1,nsamp)

      ENDDO

      RETURN
      END
