C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SHAPE1(LB,B,LD,D,LA,A,LC,C,ASE,PREW,SPACE,weight)

#include <f77/iounit.h>
C
C     THIS IS A CONFIDENTIAL PAN AMERICAN PETROLEUM CORPORATION SUBROUTINE
      DIMENSION B(*),D(*)
      DIMENSION A(*),C(*)
      DIMENSION SPACE(*), weight(*)

C     THIS SUBROUTINE FINDS THE LEAST-SQUARES WIENER SHAPING FILTER
C     BY SETTING UP AND SOLVING THE NORMAL EQUATIONS.
C
C
C     SUBROUTINE INPUTS ARE
C         LB = LENGTH OF B
C         B  = INPUT WAVELET
C         LD = LENGTH OF D
C         D  = DESIRED OUTPUT WAVELET
C         LA = LENGTH OF A
C         PREW = PREWHITENING FACTOR, 1.0= 100 PERCENT
C
C     SUBROUTINE OUTPUTS ARE
C         A  = FILTER
C         LC = LENGTH OF C
C         C  = ACTUAL OUTPUT WAVELET
C         ASE= AVERAGE SQUARED ERROR
C                            2
C             SUM (D(I)-C(I))        SUM(A(I)*G(I))
C            =---------------- =1 -  --------------
C                       2                      2
C              SUM(D(I))              SUM(D(I))
C
C     WHERE (D(I))**2=ZEROTH LAG OF AUTOPRODUCT OF D(I)=POWER OF D(I)
C
C         SPACE = AUTOCORRELATION OF B = R           (IN FIRST LA CELLS)
C               = CROSS CORRELATION OF D WITH B = G  (IN NEXT LA CELLS)
C         SPACE NEEDS 4*LA CELLS
C     MAY BE EQUIVALENCE (C,D)

c autocorrelation of input wavelet

      CALL CROSS(LB,B,LB,B,LA,SPACE)

c prewhitening

      SPACE(1)=SPACE(1) + PREW*SPACE(1)

c tapering

      call vmul (space, 1, weight, 1, space, 1, LA)

c crosscorrelation of input and desired output

      CALL CROSS(LD,D,LB,B,LA,sPACE(LA+1))

c calculation of inverse filter

      CALL EUREKb(LA,SPACE,SPACE(LA+1),A,SPACE(2*LA+1))

c dot product
      dd = 0.
      do  1  i = 1, ld
             dd = dd + d(i)*d(i)
1     continue

c dot product 
      ag = 0.
      do  2  i = 1, la
             ag = ag + a(i) * space(i+la)
2     continue

c calculate average squared error

      ASE=(DD-AG)/DD

      RETURN
      END
