C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine forward(file_in,file_out,cmdstring,lerr,
     1                   verbose,current_pwd,nodelist)

      implicit none

c-----------------------------------------------------------------------
c     Declaration for arguments
      integer       lerr
      character*256 file_in,file_out,current_pwd,nodelist
      character*700 cmdstring
      logical       verbose

c     Declaration for local variables
      character*700 string
      integer       lengstring
      parameter     (lengstring=700)
      integer       lnst,system,ireturn
      integer       ld_string,ld_in,ld_out,ld_cmdstring,ld_nodelist
      integer       ld_current_pwd
c-----------------------------------------------------------------------



c-----------------------------------------------------------------------
c     Define the length of the different file name used
c-----------------------------------------------------------------------
      ld_in = lnst(file_in)
      ld_out = lnst(file_out)
      ld_cmdstring = lnst(cmdstring)
      ld_current_pwd = lnst(current_pwd)
      ld_nodelist = lnst(nodelist)


c-----------------------------------------------------------------------
c     Define the command line
c-----------------------------------------------------------------------
      string = cmdstring(1:ld_cmdstring)//' -N'//file_in(1:ld_in)
     1         //' -O'//file_out(1:ld_out)


c-----------------------------------------------------------------------
c     Run on several nodes
c-----------------------------------------------------------------------
      string = 'spawn2 -cmd "cd '
     1         //current_pwd(1:ld_current_pwd)
     2         //' && sammig {totalnodes}'
     3         //' {nodenumber} '//string
      ld_string=lnst(string)
      string = string(1:ld_string)//'" '//nodelist(1:ld_nodelist)


c-----------------------------------------------------------------------
c     Call system
c-----------------------------------------------------------------------
      call callsys(string,lengstring,lerr,verbose)


c-----------------------------------------------------------------------
c     Merge the output of sammig in an unique file
c-----------------------------------------------------------------------
      string = 'mrgcube -N'//file_out(1:ld_out)
     1         //' -O'//file_out(1:ld_out)
      call callsys(string,lengstring,lerr,verbose)


c-----------------------------------------------------------------------
c     Remove the useless files file_out_*
c-----------------------------------------------------------------------
      string = '/bin/rm -f '//file_out(1:ld_out)//'_*'
      call callsys(string,lengstring,lerr,verbose)



      return
      end
