C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
	subroutine gcmdln (ntap,otap,nwatr,nfldh,ncabl,nmoov,
     *                     ndstn,ifold,ibtwn,iplot,metric,
     *           	cdep1,cdep2,dist1,dist2,crew,adate,
cmam *           cdep1,cdep2,dist1,dist2,wbdp1,wbdp2,crew,adate,
     *				linum,direct,pname,iclerr,saveperm)
c
c     FORTRAN by M. A. Miller  07/20/94
c
c     this routine processes the command line arguments for use in
c     program MAIP2 on SUN/Cray2
c
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

c
      character ntap*255, otap*255 ,nwatr*255,nfldh*255,ndstn*255
	character ncabl*255, nmoov*255
c
	character*6 crew
	character*10 pname
	character*8 adate,linum
	character*4 direct
      character ardch*80
c
      logical     verbos
      logical     saveperm
c
      integer argis
c
	real*8 tjobid
      INTEGER  RIPSRC, FCDP, SPNUM1, SPINC,HDRLEN, WATVEL
c
      logical     CONVEN, INDEX, WTRCRD, FELDCD, DSTCRD
      logical     MOOVUP, HISTGR, CBLCRD
c
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00007000
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00007100
c
      COMMON /DEPTH/  FCDP, INCR, WATVEL
c
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00007200
     *                HISTGR, CBLCRD                                    00007300
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00037000
c
	iclerr = 0
c	get verbose printout flag
      verbos = .false.
      verbos = (argis('-V') .gt. 0)
c
C added saveperm flag to save permanent rec indec and trc index from 
c       input data set
C
        saveperm = .false.
        saveperm = (argis('-saveperm') .gt. 0)
c
c	sign convention override
	call argi4('-mode',mode,1,0)
c
c	no indexing override
	call argi4('-noindx',indecs,1,0)
c
c	metric units override
	call argi4('-metric',metric,1,0)
c
c	plot direction override (Reverse)
	call argi4('-pltrev',iplot,1,0)
c
c	no  histogram display
	call argi4('-nohist',ihist,1,0)
c
c	source between groups
	call argi4('-ibtwn',ibtwn,1,0)
c
c	input seismic usp dataset
      call argstr ('-N',ntap,' ',' ')
c
c	output seismic usp dataset
      call argstr ('-O',otap,' ',' ')
c
c	input flatfile containing nCABL card data(tr.no.,depth pairs)
      call argstr ('-CABL',ncabl,' ',' ')
c
c	input flatfile containing 1WATR card data(sp no.,water bottom depth)
      call argstr ('-WATR',nwatr,' ',' ')
c
c	input flatfile containing 1MOOV card data(r1,rl,r1sid,smu,sd)
      call argstr ('-MOOV',nmoov,' ',' ')
c
c	input flatfile containing 1FLDH card data(free-form comments)
      call argstr ('-FLDH',nfldh,' ',' ')
c
c	input flatfile containing nDSTN card data(tr.no.,distance pairs)
      call argstr ('-DSTN',ndstn,' ',' ')
c
c	group (receiver) spacing
      call argr4('-recint', recint, 0., 0.)
c
c	normal source moveup
      call argr4('-srcint', srcint, 0., 0.)
c
c	first record source ID
      call argi4('-sp1', spnum1, 1, 1)
c
c	source point increment or decrement
      call argi4('-spinc', spinc, 1, 1)
c
c	record labeling increment
      call argi4('-labinc', ripsrc, 1, 1)
c
c	fold
      call argi4('-fold', ifold, 0, 0)
c
c	group indexing interval
      call argr4('-giint', giint, 0., 0.)
c
c	depth point indexing interval
      call argr4('-diint', diint, 0., 0.)
c
c	source labling offset
      call argr4('-laboff', offset, 0., 0.)
c
c	job constant static
      call argr4('-jcstat', jcstat, 0., 0.)
c
c	water velocity
      call argi4('-watvel', watvel, 0, 0)
c
c	crew identification
      call argstr('-crew', ardch, ' ', ' ')
      lstr = leng2(ardch,6)
      crew = '      '
      if(lstr.gt.0) crew(1:lstr) = ardch(1:lstr)
c
c	processor's name
      call argstr('-procnm', ardch, ' ', ' ')
      lstr = leng2(ardch,10)
      pname = '          '
      if(lstr.gt.0) pname(1:lstr) = ardch(1:lstr)
c
c	date
      call argstr('-date', ardch, ' ', ' ')
      lstr = leng2(ardch,8)
      adate = '        '
      if(lstr.gt.0) adate(1:lstr) = ardch(1:lstr)
c
c	oac
      call argstr('-oacline', ardch, ' ', ' ')
      lstr = leng2(ardch,7)
      linum = '        '
      if(lstr.gt.0) linum(2:lstr+1) = ardch(1:lstr)
c
c	line direction
      call argstr('-lindir', ardch, ' ', ' ')
      lstr = leng2(ardch,4)
      direct = '    '
      if(lstr.gt.0) direct(1:lstr) = ardch(1:lstr)
c
c	distance for fIrst trace of a record
      call argr4('-dist1', dist1, 0, 0)
c
c	distance for last trace of a record
      call argr4('-dist2', dist2, 0, 0)
c
c	cable depth for first trace of a record
      call argr4('-cdep1', cdep1, 0, 0)
c
c	cable depth for last trace of a record
      call argr4('-cdep2', cdep2, 0, 0)
c
c	water bottom depth for first source point
cmam  call argr4('-wbdep1', wbdp1, 0, 0)
c
c	water bottom depth for last source point
cmam  call argr4('-wbdep2', wbdp2, 0, 0)
c
c.......set flags
	CBLCRD = .FALSE.
	WTRCRD = .FALSE.
	MOOVUP = .FALSE.
	FELDCD = .FALSE.
	DSTCRD = .FALSE.
c
        if(ncabl.ne.' ') then
           if(cdep1.eq.0.0.and.cdep2.eq.0.0) then
                write(LERR,*)' CABL input file=',ncabl
                CBLCRD = .TRUE.
           else
                write(LERR,*)' CABL input file specified, but'
                write(LERR,*)' cabel depths were also specified'
                write(LERR,*)' on command line.  Therefore, the'
                write(LERR,*)' CABL file will not be used.'
           endif
	endif
c
	if(nwatr.ne.' ') WTRCRD = .TRUE.
        if(nmoov.ne.' ') MOOVUP = .TRUE.
        if(nfldh.ne.' ') FELDCD = .TRUE.
        if(ndstn.ne.' ') then
           if(dist1.eq.0.and.dist2.eq.0) then
                write(LERR,*)' DSTN input file=',ndstn
                DSTCRD = .TRUE.
           else
                write(LERR,*)' DSTN input file specified, but'
                write(LERR,*)' distances also specified on the'
                write(LERR,*)' command line.  Therefore, the'
                write(LERR,*)' DSTN file will not be used.'
           endif
	endif
c...............................................
c	print out parameters if verbose mode
c.......................................................
      if(verbos) then
      	if(ntap.ne.' ') write(LERR,*)' Input seismic file =',ntap
      	if(otap.ne.' ') write(LERR,*)' Output seismic file =',otap
	if(CBLCRD) write(LERR,*)' CABL input file=',ncabl
c
	if(nwatr.ne.' ') write(LERR,*)' WATR input file=',nwatr
	if(nmoov.ne.' ') write(LERR,*)' MOOV input file=',nmoov
	if(nfldh.ne.' ') write(LERR,*)' FLDH input file=',nfldh
	if(DSTCRD) write(LERR,*)' DSTN input file=',ndstn
	if(mode.eq.0) then
	  write(LERR,*)' sign convention: positive trace distances',
     *		' are behind the shot'
	else
	  write(LERR,*)' sign convention: positive trace distances',
     *		' are ahead of the shot'
	endif
	if(indecs.eq.0) then
	  write(LERR,*)' indexing the dataset'
	else
	  write(LERR,*)' not indexing the dataset'
	endif
	if(metric.eq.0) then
	  write(LERR,*)' using English units'
	else
	  write(LERR,*)' using Metric units'
	endif
	if(iplot.eq.0) then
	  write(LERR,*)' plot right to left'
	else
	  write(LERR,*)' plot left to right'
	endif
	if(ihist.eq.0) then
	  write(LERR,*)' display histograms'
	else
	  write(LERR,*)' do NOT display histograms'
	endif
	if(ibtwn.eq.0) then
	  write(LERR,*)' source is on groups'
	else
	  write(LERR,*)' source is between groups'
	endif
	write(LERR,*)' The following parameters were input via',
     *		' command-line arguments:'
	write(LERR,*)
     *  '********************************************************'
	if(recint.ne.0.0)
     *	  write(LERR,*)'  Group (Receiver) Spacing=',recint,
     *		' (ft or m)'
	if(srcint.ne.0.0)
     *	  write(LERR,*)'  Normal Source Moveup=',srcint,
     *          ' (ft or m)'
	if(spnum1.ne.0)
     *	  write(LERR,*)'  First Record Source ID=',spnum1
	if(spinc.ne.0)
     *    write(LERR,*)'  Source Point Increment/Decrement=',spinc
	if(ripsrc.ne.0)
     *    write(LERR,*)'  Record Labeling Increment=',ripsrc
	if(giint.ne.0.0)
     *	  write(LERR,*)'  Group Indexing Interval=',giint,
     *          ' (ft or m)'
	if(diint.ne.0.0)
     *	  write(LERR,*)'  Depth Point Indexing Interval=',giint,
     *          ' (ft or m)'
	if(offset.ne.0.0)
     *	  write(LERR,*)'  Source Labeling Offset=',offset,
     *          ' (ft or m)'
	if(jcstat.ne.0.0)
     *	  write(LERR,*)'  Job Constant Static=',jcstat
	if(ifold.ne.0)
     *    write(LERR,*)'  Fold =',ifold
	if(watvel.ne.0)
     *	  write(LERR,*)'  Water Velocity =',watvel
	if(crew.ne.' ')
     *	  write(LERR,*)'  Crew Identifier=',crew
	if(pname.ne.' ')
     *	  write(LERR,*)'  Processor Name=',pname
	if(adate.ne.' ')
     *	  write(LERR,*)'  Date=',adate
	if(linum.ne.' ')
     *	  write(LERR,*)'  OAC/Line Number=',linum
	if(direct.ne.' ')
     *	  write(LERR,*)'  Line Direction=',direct
	if(dist1.ne.0)
     *	  write(LERR,*)'  Distance for First Trace of record=',dist1
	if(dist2.ne.0)
     *	  write(LERR,*)'  Distance for Last Trace of record=',dist2
	if(cdep1.ne.0)
     *	  write(LERR,*)'  Cable Depth for First Trace of record=',cdep1
	if(cdep2.ne.0)
     *	  write(LERR,*)'  Cable Depth for Last Trace of record=',cdep2
        if (saveperm)
     *    write(LERR,*)'  Do not override permanent rec and tr num'
cmam	if(wbdp1.ne.0)
cmam *	  write(LERR,*)'  Water Bottom Depth for First S.P.=',wbdp1
cmam	if(wbdp2.ne.0)
cmam *	  write(LERR,*)'  Water Bottom Depth for Last S.P.=',wbdp2
      endif
c.....................
c	check for appropriate value for parameters
c.....................
c
c	check first record source id that it is not negative
      IF ( SPNUM1 .lt. 0 ) then
         WRITE(LERR,5)
    5 FORMAT (/,13X,'** M0001 ** ERROR DETECTED :',
     *        /,25X,'FIRST RECORD SOURCE ID IS INVALID ',
     *        /,25X,'ID MUST BE GREATER THAN ZERO.  CORRECT AND',
     *        /,25X,'RESUBMIT.',/)
	iclerr = 1
      endif
      IF ( MODE .NE. 1 ) MODE   = 0
      IF ( MODE .NE. 1 ) CONVEN = .TRUE.
C--
C---- SET SOME DEFAULTS....
C--
      IF ( SPNUM1 .LE. 0 ) SPNUM1 = 1
      IF ( SPINC  .EQ. 0 ) SPINC  = 1
      IF ( RIPSRC .LE. 0 ) RIPSRC = 1
      IF ( IPLOT  .NE. 0 ) IPLOT  = 1
      IF ( METRIC .NE. 0 ) METRIC = 1
      IF ( INDECS .NE. 0 ) INDEX  = .FALSE.
      IF ( IHIST  .EQ. 1 ) HISTGR = .FALSE.
      IF ( IBTWN  .NE. 0 ) IBTWN  = 1
C--
C--
      return
      end
