C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************00000100
C                                                                       00000200
C     PROGRAM NAME: MAIP  ( MARINE LINE INDEXING PROGRAM )              00000300
C                                                                       00000400
C     LANGUAGE: FORTRAN                                                 00000500
C                                                                       00000600
C     AUTHOR: R. WILSON AND E. ANDES                                    00000700
C                                                                       00000800
C     DATE WRITTEN: 01/13/86                                            00000900
C                                                                       00001000
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00001100
C                              TO BE MAINTAINED IN CONFIDENCE           00001200
C                                                                       00001300
C     ABSTRACT:                                                         00001400
C          PROGRAM MAIP WAS DESIGNED TO INDEX A MARINE LINE WITH        00001500
C          AS LITTLE CARD INPUT AS POSSIBLE, BUT AT THE SAME TIME       00001600
C          TO BE EXTREMELY FLEXIBLE.  A MARINE LINE CAN BE INDEXED,     00001700
C          CAN RECEIVE FIELD HISTORY, WATER DEPTHS, CABLE DEPTHS,       00001800
C          TRACE STATICS, OR TRACE DISTANCES.                           00001900
C                                                                       00002000
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00002100
C                             INITIAL RELEASE.                          00002200
C                             02/28/86   J. VINSON                      00002300
C                             CORRECTED CDP CALCULATION TO USE          00002400
C                             ACTUAL SOURCE POSITION RATHER THAN        00002500
C                             SOURCE LABELING POSITION                  00002600
C                             07/08/86   E. JOHNSON                     00002700
C                             ADDED ERROR MESSAGES, ADDED SHOT          00002800
C                             POINTS / MILE IN HEADER.                  00002900
C                             01/08/87   J. VINSON                      00003000
C                             SET STATIC TYPE (HW 75) IN LH TO 2        00003100
C                             USE TR HW 125 AS DEAD TRACE FLAG ONLY     00003200
C                             SET JOB CONSTANT STATIC IN TR HW 15       00003300
C                             SET INIT CORR IN TR HW 7 AND 8            00003400
C                             SET RECP CORR IN TR HW 10 AND 11          00003500
C                             MISC. BUG FIXES - SEE ITEM 86147          00003600
C                             10/13/87   J. VINSON                      00003700
C                             BUG FIX RE CHECK ON NEGATIVE SHOT POINTS  00003800
C                                                                       00003900
C                                                                       00004000
C***********************************************************************00004100

#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
C                                                                       00004200
      REAL    * 8 TJOBID                                                00004300
C                                                                       00004400
      REAL    * 4 DIST(1024), WDEPTH(12000), JCSTAT, DSTNCE(2,5000),    00004504
     *            BEGIN(1024), FINISH(1024), INCR, RBUF ( 1500 ),
     *            CHARGE, DINKY, SMALL, CONV
C                                                                       00004700
      INTEGER * 4 IHEAD(12128), RIPSRC, luout, IBLANK,
     *            FCDP, SPNUM1, SPINC, DIERR(50), GIERR(50), luin,
     *            SPSET, ASSIGN, BOUNDS(3,5000), HDRLEN, WATVEL,
     *            MAXWD, MINWD, IREC, MULT, N22, N23, N25, N4,
     *            IDISKC, IDISKW
      character*80 KARD
	integer spbiasfl,spbas,isp1
C
#include <f77/pid.h>
c...........for new command-line arguments
      character   ntap*255, otap*255, ncabl*255, nwatr*255,
     *		nmoov*255, nfldh*255, ndstn*255
      integer pltrev
cmam	character crew*7, adate*9, linum*9, direct*5, pname*11
	character*6 crew
	character*4 direct
	character*8 adate,linum
	character*10 pname
c...............................
      INTEGER * 2 itr (12128)
      INTEGER * 2 IBUF(12128), STYPE, IBFLAG
cmam  INTEGER * 2 IBUF(12128), STYPE, IBFLAG, METRIC
C                                                                       00005300
      character * 4 MAIP, grpst, name
	character*4 chgrpi
      character * 1 TITLE(66), LHEAD(12000)
ccc   character * 1 TITLE(66), LHEAD(150)
      logical     CONVEN, INDEX, WTRCRD, FELDCD, DSTCRD
      logical     MOOVUP, HISTGR, CBLCRD, MAIP1
	logical	verbos, query
	integer argis
C
C added flag (saveperm) to not override PrRcNm and PrTrNm
C    3/18/97 - jev
C
      logical saveperm
C                                                                       00005600
      EQUIVALENCE  ( IBUF(1), IHEAD(1), LHEAD(1) ,RBUF (1) )            00005700
      EQUIVALENCE  ( IBUF(1), itr(1))
C                                                                       00005800
      DATA  TITLE/19*' ','M','A','R','I','N','E',' ','L','I','N','E',
     *                   ' ','I','N','D','E','X','I','N','G',' ','P',
     *                   'R','O','G','R','A','M',19*' '/,
     *      DINKY/0.0/, N4/4/, MAIP/'MAIP'/, CHARGE/0.5/, IREC/0/,
     *      MULT/1/, N22/22/, N23/23/, N25/25/, STYPE/' 1'/,
     *      SMALL/99999.0/, MAXWD/-32768/, MAIP1/.FALSE./,
     *      IBLANK/0/, WDEPTH/12000*-99999.99/, CONV /3.280/,
     *      MINWD/2147483647/, METRIC / 0 /, name/'MAIP'/,
     *      IDISKC/13/, IDISKW/11/
C
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00007000
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00007100
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00007200
     *                HISTGR, CBLCRD                                    00007300
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                00007400
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00007500

cc       check for help flag

      query= ((argis ('-?').gt.0).or.(argis('-H').gt.0))
      if ( query ) then
         call help1()
         stop
      endif

C--                                                                     00007600
C---- open printout file
C--                                                                     00007800
#include <f77/open.h>

C--                                                                     00007600
C---- SET INITIAL CONDITIONS...                                         00007700
C--                                                                     00007800
	lcount = 0
      IREADR = 99
      IPRNTR = LERR
      WTRCRD = .FALSE.                                                  00008400
      FELDCD = .FALSE.                                                  00008500
      INDEX  = .TRUE.                                                   00008600
      CONVEN = .FALSE.                                                  00008700
      DSTCRD = .FALSE.                                                  00008800
      MOOVUP = .FALSE.                                                  00008900
      CBLCRD = .FALSE.                                                  00009000
      HISTGR = .TRUE.                                                   00009100
	call move (0, DIERR, 0, 50*SZSMPD)
	call move (0, GIERR, 0, 50*SZSMPD)
	dist1 = 0.
	dist2 = 0.
C--                                                                     00009200
C---- PRINT BANNER PAGE AND OPEN TAPES...                               00009300
C--                                                                     00009400
      CALL GAMOCO ( TITLE, 1, IPRNTR )                                  00009500
cmam  call argstr ('-N', ntap, ' ', ' ')
cmam  call argstr ('-O', otap, ' ', ' ')
cmam  call argstr ('-C',cardin, ' ', ' ')
c.......get command-line arguments.......mam 7-22-94..................
	call gcmdln (ntap, otap, nwatr, nfldh,ncabl,nmoov,
     *               ndstn,ifold,ibtwn,iplot,metric,
     *      cdep1,cdep2,dist1,dist2,crew,adate, linum,
cmam *      cdep1,cdep2,dist1,dist2,wbdp1,wbdp2,crew,adate, linum,
     *			direct, pname, iclerr,saveperm)
	if(iclerr.ne.0) call ccexit(100)
c.....................................................................
C *------------------------------------------------------------------* C
C *  If ntap specified, open it, otherwise set lui to standard
C *  input (= pipe in)
C *------------------------------------------------------------------* C
      if (ntap.ne.' ')then
        call getln (luin , ntap, 'r', 0)
      else
        luin = 0
      endif
       if (luin .lt. 0) then
         write (LERR,*) 'Could not open input ',ntap
         call ccexit(100)
      endif
C *------------------------------------------------------------------* C
C *  If otap specified, open it, otherwise set luo to standard
C *  output (= pipe out)
C *------------------------------------------------------------------* C
      if (otap.ne.' ')then
        call getln (luout, otap, 'w', 1)
      else
        luout = 1
      endif
c
      open (unit = IDISKC, form = 'formatted',
     1      status = 'scratch', access = 'sequential')
      open (unit = IDISKW, form = 'formatted',
     1      status = 'scratch', access = 'sequential')
c
C--                                                                     00009700
C---- READ LINE HEADER..                                                00009800
C--                                                                     00009900
      HDRLEN = 0                                                        00010000
      CALL RTAPE ( luin, IHEAD, HDRLEN )                                00010100
      IF ( HDRLEN .NE. 0 ) GO TO 200                                    00010200
C                                                                       00010300
      WRITE(IPRNTR,100)                                                 00010400
  100 FORMAT (/,13X,'** M0000 ** ERROR DETECTED BY PROGRAM MAIN:',      00010500
     *        /,25X,'AN END-OF-FILE WAS ENCOUNTERED ATTEMPTING TO',     00010600
     *        /,25X,'READ THE INPUT DATA SET LINE HEADER.  VERIFY',     00010700
     *        /,25X,'THE INPUT DATA SET NAME AND IN THE CASE OF',       00010800
     *        /,25X,'MULTI-VOLUME DATA SETS, VERIFY THE ORDER IN',      00010900
     *        /,25X,'WHICH THE VOLUMES WERE CATALOGED.',/)              00011000
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00011200
C--                                                                     00011300
C---- UPDATE HISTORY...                                                 00011400
C--                                                                     00011500
  200 continue

      call saver(ihead, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(ihead, 'UnitSc', unitsc, LINHED)
      endif

      CALL HLHprt ( IHEAD, HDRLEN, MAIP, N4, LERR )
	call saver(itr, 'JobNum', TJOBID, 0)
  221 format(/,3x,'job no. from tape=', a8)
      call saver(itr, 'NumTrc', NTRACE , 0)
      call saver(itr, 'NumRec', nrec , 0)
C--                                                                     00012000
C---- STUFF GOOD INFO IF INPUT...
C--
      IF ( CREW   .NE. '      ' ) then
        call savew(ihead,'CrwNam',crew,0)
        endif
      IF ( aDATE  .NE. '        ' ) then
        call savew(ihead,'PrcDat',adate,0)
        endif
      IF ( LINUM  .NE. '        ' ) then
        call savew(ihead,'OACLin',linum,0)
        endif
      IF ( DIRECT .NE. '    ' ) then
        call savew(ihead,'LinDir',direct,0)
        endif
      IF ( pname  .NE. '          ' ) then
        call savew(ihead,'PrcNam',pname,0)
        endif
C
c	interpolate distances if command-line input
	if(dist1.ne.0.0.or.dist2.ne.0.0) then
		BLANK=-99999.99
		call vfill(BLANK, DIST, 1, NTRACE)
		dist(1) = dist1
		dist(ntrace) = dist2
		call interp(dist,1,ntrace)
	endif
	if(feldcd) call fldhcd(nfldh,hdrlen)
	if(wtrcrd) call watrcd(nwatr,WDEPTH, MINWD, MAXWD )
	if(cblcrd) call cablcd(ncabl)
	if(moovup) call moovcd(nmoov)
      IF ( DSTCRD ) CALL DISTRD ( RECORD, ndstn, NTRACE )
C--                                                                     00099500
C---- SET GROUP INTERVAL INITIALLY                                      00099600
C--                                                                     00099700
      IF ( GIINT .le. 0.0 ) then
C--                                                                     00099900
C---- DEFAULT THE GROUP INDEXING INTERVAL..                             00100000
C--                                                                     00100100
         FAKE = ABS (RECINT - SRCINT)                                   00100200
         IF ( RECINT .LE. SRCINT                                        00100300
     *               .AND. RECINT .LE. FAKE ) GIINT = RECINT            00100400
         IF ( SRCINT .LE. RECINT                                        00100500
     *               .AND. SRCINT .LE. FAKE ) GIINT = SRCINT            00100600
         IF ( FAKE   .LE. RECINT                                        00100700
     *               .AND. FAKE .LE. SRCINT ) GIINT = FAKE              00100800
         IF ( FAKE .EQ. 0. ) GIINT = RECINT                             00100900
      endif
C--                                                                     00101000
C---- DO WE NEED TO DEFAULT DI INTERVAL ???                             00101100
C--                                                                     00101200
      IF ( DIINT .le. 0.0 ) then
C                                                                       00101400
           DIINT = GIINT                                                00101500
           IF ( ( RECINT * 0.5 ) .LT. GIINT ) DIINT = RECINT * 0.5      00101600
      endif
C--                                                                     00012700
C--                                                                     00012700
C---- CHECK INPUT THEN SEE IF INDEXING...                               00012800
C--                                                                     00012900
  400 CALL ERRCHK ( IBUF, IHEAD,dist1,dist2)
cc400 CALL ERRCHK ( IBUF, IHEAD, MAIP1 )                                00013000
C
cmam  IF ( WTRCRD ) CALL WSTUFF ( WDEPTH )                              00013100
c---------------------------
c  if index is true then we will index the data
c  else we attempt to read previous indexing
c---------------------------
      IF ( INDEX ) GO TO 500                                            00013200
C--                                                                     00013300
C---- ANYTHING SPECIAL FOR HLH ??                                       00013400
C--                                                                     00013500
      IF ( FELDCD )
     *     CALL HLHprt (IHEAD,HDRLEN,' (REPLACE FIELD HISTORY',N23,
     *                  LERR)
      IF ( WTRCRD )
     *     CALL HLHprt (IHEAD,HDRLEN,' (REPLACE WATER DEPTHS',N22,
     *                  LERR)
cmam  IF ( DSTCRD )
      IF ( DSTCRD.or.(dist1.ne.0).or.(dist2.ne.0) )
     *     CALL HLHprt (IHEAD,HDRLEN,' (REPLACE TRACE DISTANCES',N25,
     *                  LERR)
C--                                                                     00014200
C---- WERE WATR CARDS INPUT ???                                         00014300
C--                                                                     00014400
      IF ( .NOT. WTRCRD ) GO TO 900                                     00014500
C--                                                                     00014600
C---- IF NO INDEXING AND WATER DEPTHS ARE                               00014700
C---- TO BE INPUT, WE NEED SOME INFO TO                                 00014800
C---- PROPERLY ASSIGN A WATER DEPTH                                     00014900
C---- ABOVE A DEPTH POINT....                                           00015000
C--                                                                     00015100
      call saver (ibuf, 'SpBiFl', spbiasfl, 0)
      call saver (ibuf, 'SPBias', spbas  , 0)
      call saver (ibuf, 'FrstSP', isp1    , 0)
      CALL GETSP ( spbiasfl, spbas, isp1, IFSORC )
      FSORC = IFSORC                                                    00015300
      call saver (ibuf, 'DpN1SP', FCDP, 0)
      call saver (ibuf, 'NmDpIn', INCR, 0)
      GO TO 900                                                         00015700
C--                                                                     00015800
C---- SET SOURCE INFORMATION...                                         00015900
C--                                                                     00016000
  500 SLINT  = GIINT / 10.0                                             00016100
C--                                                                     00016200
C---- HOW FAR BETWEEN LABELED SOURCES ???                               00016300
C--                                                                     00016400
      SPLINT = SRCINT * FLOAT( RIPSRC )                                 00016500
      IF ( METRIC .EQ. 0 ) GO TO 550                                    00016600
         SPLIN2 = SPLINT * CONV                                         00016700
         SPMILE = 5280.0 / SPLIN2                                       00016800
         GO TO 575                                                      00016900
  550 SPMILE = 5280.0 / SPLINT                                          00017000
                                                                        00017100
C--                                                                     00017200
C---- SET POSITION OF SOURCE BEFORE INITIAL MOVEUP...                   00017300
C---- WE WANT THE MOST NEGATIVE TRACE TO FALL EXACTLY                   00017400
C---- ON THE FIRST GI FOR THE FIRST SOURCE POINT..                      00017500
C---- TRACE DISTANCE WILL DECIDE WHETHER OR NOT SOURCE                  00017600
C---- LOCATION INDEX OF 1ST SOURCE WILL BE ON A GI CENTER               00017700
C---- I.E. ON THE GROUP AS OPPOSED TO BETWEEN GROUP SHOOTING            00017800
C--                                                                     00017900
C---- DETERMINE HOW FAR TO FIRST SOURCE POINT                           00018000
C---- GET HELP TO LOCATE GROUP 1...                                     00018100
C--                                                                     00018200
  575 DO 700 I = 1,NTRACE                                               00018300
         IF ( CONVEN ) GO TO 600                                        00018400
         MULT = -1                                                      00018500
         IF ( DIST(I) .LT. DINKY ) DINKY = DIST(I)                      00018600
         IF ( DIST(I) .LT. SMALL ) SMALL = DIST(I)                      00018700
         GO TO 700                                                      00018800
  600    IF ( DIST(I) .GT. DINKY ) DINKY = DIST(I)                      00018900
  700    CONTINUE                                                       00019000
C--                                                                     00019100
C---- IF PUSHING A SPREAD, GET SMALLEST                                 00019200
C---- TRACE DISTANCE TO REPOSITION ORIGIN FOR 108...                    00019300
C--                                                                     00019400
      IF ( SMALL .LE. 0.0                                               00019500
     *           .OR. DINKY .LT. 0.0 ) SMALL = 0.0                      00019600
C--                                                                     00019700
C---- IF MOVEUP CARDS INPUT, USE THE FIRST MOVEUP                       00019800
C---- ( IF FIRST MOVEUP IS NOT BLANK, -99999.99 )                       00019900
C---- TO POSITION THINGS SO FIRST TRACE                                 00020000
C---- LANDS ON A GROUP CENTER...                                        00020100
C--                                                                     00020200
      ALIGN  = SRCINT                                                   00020300
      IF ( ( MOOVUP )                                                   00020400
     *       .AND. DSTNCE(1,1) .NE. -99999.99 ) ALIGN = DSTNCE(1,1)     00020500
      SOURCE = ( MULT * DINKY ) + GIINT - ALIGN + OFFSET                00020600
C--                                                                     00020700
C---- IF PUSHING A SPREAD, MAKE SURE                                    00020800
C---- FIRST TRACE LANDS ON A GROUP                                      00020900
C---- CENTER.  SOURCE CAN GO ANYWHERE...                                00021000
C--                                                                     00021100
ccc   IF ( DINKY .EQ. 0.0 ) SOURCE = SOURCE + ( ALIGN - SMALL )         00021200
      IF ( DINKY .EQ. 0.0 ) then
      	SOURCE = SOURCE + ( ALIGN - SMALL )
	endif
C--                                                                     00021300
C---- SET SOME STUFF IN LINE HEADER                                     00021400
C---- THAT SORT AND PLOT NEED...                                        00021500
C--                                                                     00021600
      RDREGS = SOURCE + ALIGN                                           00021700
C--                                                                     00021800
C---- IF SHOT ON GROUP, RDREGS WILL                                     00021900
C---- BE ZERO.  PUSHING SPREAD ONLY...                                  00022000
C--                                                                     00022100
      IF ( RDREGS .EQ. 0 ) RDREGS = RDREGS + ALIGN                      00022200
      FSTSRC = RDREGS                                                   00022300
C--                                                                     00022400
C---- GET BUCKET LIMIT FOR DI SLOP PER LABELED SOURCE POINT             00022500
C---- WHAT FRACTION OF SPLINT DOES A DI HAVE TO FALL IN...              00022600
C--                                                                     00022700
      DIOVRL = DIINT / SPLINT * 0.5                                     00022800
C--                                                                     00022900
C---- DOES WATER VELOCITY NEED TO BE DEFAULTED ???                      00023000
C--                                                                     00023100
      IF ( .NOT. INDEX ) GO TO 900                                      00023200
         IF ( WATVEL .EQ. 0                                             00023300
     *            .AND. METRIC .EQ. 0 ) WATVEL = 4850                   00023400
         IF ( WATVEL .EQ. 0                                             00023500
     *            .AND. METRIC .EQ. 1 ) WATVEL = 1480                   00023600
ccc      CALL MOVE ( 1, IHEAD(31), WATVEL, 4 )                          00023700
	call savew(ibuf, 'WatVel', WATVEL,0)
C--                                                                     00023800
C---- GET THE GROUP INTERVAL IN PROPER                                  00023900
C---- FRAME OF MIND...                                                  00024000
C--                                                                     00024100
      IGIINT = RECINT + 0.5                                             00024200
ccc   call inttoc (IGIINT, grpst)
	write(grpst,799) IGIINT
  799   format(i4)
      call savew (ibuf, 'GrpInt', grpst, 0)
c     CALL STRING ( IHEAD(20), 4 )                                      00024300
c     WRITE(99,800) IGIINT                                              00024400
c 800 FORMAT ( I4 )                                                     00024500
C--                                                                     00024600
C---- STUFF ALL KINDS OF CRAP IN LINE HEADER....                        00024700
C--                                                                     00024800
c     IBUF(35)  = IBTWN
      call savew (ibuf, 'OpGrFl', IBTWN, 0)
c     IBUF(37)  = STYPE
	intval = STYPE
      call savew (ibuf, 'SrtTyp', intval, 0)
cmam  call savew (ibuf, 'SrtTyp', STYPE, 0)
      IF ( IFOLD .NE. 0 ) THEN
c    *           IBUF(38)  = IFOLD
      call savew (ibuf, 'CDPFld', IFOLD, 0)
      ENDIF
c     IBUF(55)  = IHEAD(13)
      call savew (ibuf, 'OrNTRC', ntrc , 0)
c     IBUF(56)  = IHEAD(14)
      call savew (ibuf, 'OrNREC', nrec , 0)
c     RBUF(57)  = SPMILE
      call savew (rbuf, 'NmSpMi', SPMILE, 0)
cmam  call savew (ibuf, 'NmSpMi', SPMILE, 0)
cc    call savew (ibuf, 'NmSPMi', SPMILE, 0)
c     IBUF(71)  = METRIC
	intval = METRIC
      call savew (ibuf, 'UnitFl', intval, 0)
cmam  call savew (ibuf, 'UnitFl', METRIC, 0)
c     IBUF(72)  = SPSET ( RDREGS, SPLINT, DIOVRL, TRUESP, FSTSRC )
      IBUF72  = SPSET ( RDREGS, SPLINT, DIOVRL, TRUESP, FSTSRC )
      call savew (ibuf, 'FrstSP', IBUF72, 0)
c     IBUF(73)  = ASSIGN ( RDREGS, DIINT, 0, DUMMY )
      IBUF73  = ASSIGN ( RDREGS, DIINT, 0, DUMMY )
      call savew (ibuf, 'DpN1SP', IBUF73, 0)
c     IBUF(74)  = SPLINT / ( DIINT * SPINC ) * 100.
      IBUF74  = SPLINT / ( DIINT * SPINC ) * 100.
      call savew (ibuf, 'NmDpIn', IBUF74, 0)
c     IBUF(75)  = 2
      call savew (ibuf, 'StWdFl',  2   , 0)
c     IBUF(76)  = DIINT + 0.5
      IBUF76  = DIINT + 0.5
      call savew (ibuf, 'DptInt', IBUF76, 0)
c     IBUF(85)  = IPLOT
      call savew (ibuf, 'PltDir', IPLOT, 0)
c     IBUF(103) = STYPE
	intval = STYPE
      call savew (ibuf, 'MutFlg', intval, 0)
cmam  call savew (ibuf, 'MutFlg', STYPE, 0)
      call saver (ibuf, 'TmMsFS', it0  , 0)
      IF ( it0 .EQ. 0) THEN
      call savew (ibuf, 'OpGrFl',  it0 , 0)
      ENDIF
C--                                                                     00026500
C---- CALL SOURCE POINT BIASING ROUTINE...                              00026600
C--                                                                     00026700
      call saver (ibuf, 'SpBiFl', spbiasfl, 0)
cc    call saver (ibuf, 'SPBiFl', spbiasfl, 0)
      call saver (ibuf, 'SPBias', spbas  , 0)
      call saver (ibuf, 'FrstSP', isp1    , 0)
c     CALL SBIAS ( IBUF(105), IBUF(104), IBUF(72), SPNUM1 )             00026800
      CALL SBIAS ( spbiasfl, spbas, isp1, SPNUM1 )
      IBFLAG = spbiasfl
C                                                                       00027000
900   continue
ckjm  CALL WRTAPE ( luout, IHEAD, HDRLEN )
      call savhlh(ihead,hdrlen,lbyout)
      call wrtape(luout,ihead,lbyout)       
C--                                                                     00027200
C---- IF WATER DEPTHS ARE TO BE INPUT,                                  00027300
C---- GO INTERPOLATE AND PRINT THEM FIRST....                           00027400
C--                                                                     00027500
      IF ( WTRCRD ) CALL DSPLAY ( WDEPTH, MINWD, MAXWD, 1 )             00027600
C                                                                       00027700
      IF ( .NOT. INDEX ) CALL UTILTY ( IREC, KARD, IBUF, MINWD, MAXWD,  00027800
     *                      NTRACE, FSORC, WDEPTH,dist1,dist2,ndstn )
cmam *                      NTRACE, FSORC, WDEPTH,dist1,dist2 )
cmam *                                 NTRACE, FSORC, WDEPTH )          00027900
C                                                                       00028000
      IF ( INDEX ) then                                                 00028100
           CALL INDX ( IREC, SLINT, SPLINT, SOURCE, FSTSRC, DIOVRL,     00028200
     *                 TRUESP, DIERR, GIERR, MULT, IBUF, ibuf,          00028300
     *                 WDEPTH, MINWD, MAXWD, NTRACE, IBFLAG,dist1,
     *			dist2,ndstn,cdep1,cdep2 ,saveperm)
cmam *			dist2 )
cmam *                 WDEPTH, MINWD, MAXWD, NTRACE, IBFLAG) 
	endif
C                                                                       00028500
      IF  ( ( INDEX )                                                   00028600
     *        .AND. ( HISTGR ) ) CALL HISTGM ( GIERR, 1 )               00028700
      IF  ( ( INDEX )                                                   00028800
     *        .AND. ( HISTGR ) ) CALL HISTGM ( DIERR, 6 )               00028900
C--                                                                     00029000
C---- DO MY ACCOUNTING...                                               00029100
C--                                                                     00029200
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 0 )                                                 00029500
      END                                                               00029600
C                                                                       00029700
C                                                                       00029800
      SUBROUTINE INDX ( IREC, SLINT, SPLINT, SOURC1, FSTSRC, DIOVRL,    00029900
     *                  TRUESP, DIERR, GIERR, MULT, IBUF, ibuf4,
     *                  WDEPTH, MINWD, MAXWD, NTRACE, IBFLAG,dist1,
     *			dist2 ,ndstn,cdep1,cdep2,saveperm)
cmam *                  WDEPTH, MINWD, MAXWD, NTRACE, IBFLAG)
C***********************************************************************00030200
C                                                                       00030300
C     SUBROUTINE NAME: INDX                                             00030400
C                                                                       00030500
C     LANGUAGE: FORTRAN                                                 00030600
C                                                                       00030700
C     AUTHOR: R. WILSON AND E. ANDES                                    00030800
C                                                                       00030900
C     DATE WRITTEN: 01/13/86                                            00031000
C                                                                       00031100
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00031200
C                              TO BE MAINTAINED IN CONFIDENCE           00031300
C                                                                       00031400
C     ABSTRACT:                                                         00031500
C         SUBROUTINE INDX DOES THE STUFFING OF TRACE HEADER VALUES      00031600
C         AND IS ONLY CALLED WHEN INDEXING IS TO BE PERFORMED.          00031700
C                                                                       00031800
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00031900
C                             INITIAL RELEASE.                          00032000
C                             02/28/86   J. VINSON                      00032100
C                             CORRECTED CDP CALCULATION TO USE          00032200
C                             ACTUAL SOURCE POSITION RATHER THAN        00032300
C                             SOURCE LABELING POSITION                  00032400
C                                                                       00032500
C     PARAMETERS PASSED:                                                00032600
C         IREC   - NUMBER OF RECORDS PROCESSED                          00032700
C         SLINT  - SOURCE LOCATION INDEX INTERVAL                       00032800
C         SPLINT - INTERVAL AT WHICH SOURCES ARE LABELED ABOVE CDP'S    00032900
C         SOURC1 - SOURCE LOCATION IN DISTANCE                          00033000
C         FSTSRC - FIRST SOURCE ON LINE                                 00033100
C         DIOVRL - SLOP FOR LABELING SP OVER CDP                        00033200
C         TRUESP - WHAT SOURCE POINT IS ABOVE ANY CDP                   00033300
C         DIERR  - ERROR IN CDP ASSIGNMENTS                             00033400
C         GIERR  - ERROR IN GI ASSIGNMENTS                              00033500
C         MULT   - MULTIPLIER FOR TRACE DISTANCE MAGNITUDES             00033600
C         IBUF   - TRACE BUFFER                                         00033700
C         WDEPTH - WATER DEPTH ARRAY                                    00033800
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    00033900
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    00034000
C         NTRACE - NUMBER OF TRACES PER RECORD                          00034100
C         IBFLAG - SOURCE POINT BIASING FLAG                            00034200
C                                                                       00034300
C***********************************************************************00034400
#include <save_defs.h>
#include <f77/sisdef.h>
C                                                                       00034500
      REAL    * 8 TJOBID
      REAL    * 4 DIST(1024), WDEPTH(12000), JCSTAT, DSTNCE(2,5000),    00034604
     *            BEGIN(1024), FINISH(1024), INIT                       00034700
C                                                                       00034800
      INTEGER * 4 RECORD, SRCLOC, SRCNUM, SPSET, luout, SPINC, SPNUM1,
     *            DIERR(50), GIERR(50), ASSIGN, BOUNDS(3,5000), VALUE,  00035004
     *            RIPSRC, FCDP, WATVEL, IHEAD(12128), DIBSP             00035100
      integer     assign4,prrcnm
	integer ASSIG1
	integer kval, lval, mval, nval
      character*80  KARD
	character ndstn*255
	integer SPSET1
      integer scrloc4
C                                                                       00035300
      INTEGER * 2 IBUF(12128), IBFLAG                                   00035400
      integer*4   ibuf4(*)
	real lcdp(2), lshot(2), lrecv(2), ldiint(2)
	integer ldi(2), ltr
C                                                                       00035500
      logical   CONVEN, INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, FIRST,
     *            START, END, HISTGR, CBLCRD
      logical   saveperm
c
C                                                                       00035800
      DATA FIRST/.TRUE./, START/.FALSE./, END/.FALSE./,                 00035900
     *     IPNTR/1/, BLANK/-99999.99/, IBOTOM/-99999/, ISTART/-9999/,   00036000
     *     IEND/-9999/                                                  00036100
C                                                                       00036200
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00036600
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00036700
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00036800
     *                HISTGR, CBLCRD                                    00036900
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                00036500
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00037000
	save ltr,ldi,lcdp,lshot,lrecv,ldiint

c__________________________________________________________________
c     look up hardware specific trace header indices.
c     these indices will be the same for all output records.
c__________________________________________________________________
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
      call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
      call savelu('SoPtNm',ifmt,l_SoPtNm,length,TRACEHEADER)
      call savelu('RedVel',ifmt,l_RedVel,length,TRACEHEADER)
      call savelu('RcStAp',ifmt,l_RcStAp,length,TRACEHEADER)
      call savelu('RcStUn',ifmt,l_RcStUn,length,TRACEHEADER)
      call savelu('SrPtXC',ifmt,l_SrPtXC,length,TRACEHEADER)
      call savelu('SrPtEl',ifmt,l_SrPtEl,length,TRACEHEADER)
      call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
      call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
      call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
      call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
      call savelu('SGRDat',ifmt,l_SGRDat,length,TRACEHEADER)
      call savelu('WDepDP',ifmt,l_WDepDp,length,TRACEHEADER)
      call savelu('ToTmAU',ifmt,l_ToTmAU,length,TRACEHEADER)
      call savelu('ShtDep',ifmt,l_ShtDep,length,TRACEHEADER)
      call savelu('CabDep',ifmt,l_CabDep,length,TRACEHEADER)
      call savelu('PREPIn',ifmt,l_PREPIn,length,TRACEHEADER)
      call savelu('InStUn',ifmt,l_InStUn,length,TRACEHEADER)
      call savelu('PREPRc',ifmt,l_PREPRc,length,TRACEHEADER)
      call savelu('RcStUn',ifmt,l_RcStUn,length,TRACEHEADER)
      call savelu('ToStUn',ifmt,l_ToStUn,length,TRACEHEADER)
 
      if (.not. saveperm) then
         call savelu('PrRcNm',ifmt,l_PrRcNm,length,TRACEHEADER)
         call savelu('PrTrNm',ifmt,l_PrTrNm,length,TRACEHEADER)
      endif
C--                                                                     00037100
C---- START PROCESSING TAPE....                                         00037200
C--                                                                     00037300
      ICNT = 0                                                          00037400
      LASTRI = 0                                                        00037500
  100 ILABEL = 0                                                        00037600
  200 ISTAT  = 0                                                        00037700
      JSTAT  = 0                                                        00037800
      INIT   = 0.                                                       00037900
      RECEP  = 0.                                                       00038000
      TOTAL  = 0.                                                       00038100
      LENGTH = 0                                                        00038200
      CALL RTAPE ( luin, IBUF, LENGTH )                                 00038300
      IF ( LENGTH .EQ. 0 ) GO TO 1200                                   00038400
C                                                                       00038500
        krec=ibuf(l_recnum)
        ktrc=ibuf(l_trcnum)
ckjm	call saver(IBUF, 'RecNum', krec, 1)
ckjm    call saver(IBUF, 'TrcNum', ktrc, 1)
	if(ktrc .ne. 1) go to 250
	if(krec .ne. LASTRI) go to 240
      WRITE (IPRNTR,230) krec                                           00038800
  230 FORMAT(/13X,'** M0202 ** WARNING FROM SUBROUTINE INDX:'           00038900
     *      ,/25X,'DUPLICATE RECORD NUMBER ', I6,' FOUND.',             00039000
     *       /25X,'PROCESSING CONTINUES.',/)                            00039100
  240 LASTRI = krec                                                     00039200
  250 CONTINUE                                                          00039300
C                                                                       00039400
      IF ( .NOT. MOOVUP ) GO TO 400                                     00039500
C--                                                                     00039600
C---- WE HAVE MOVE UP CARDS...PANIC !!!!                                00039700
C---- START SETTING FLAGS...                                            00039800
C--                                                                     00039900
C---- HAVE WE PASSED THE END RECORD ???                                 00040000
C--                                                                     00040100
      IF ( ( .NOT. END )                                                00040200
     *       .OR. krec .EQ. BOUNDS(2,IPNTR) ) GO TO 300                 00040300
      START = .FALSE.                                                   00040400
      END   = .FALSE.                                                   00040500
C--                                                                     00040600
C---- BUMP POINTER TO NEXT STARTING RECORD...                           00040700
C---- IF ZERO, THAT WILL MEAN NO MORE TO WRITE OUT...                   00040800
C--                                                                     00040900
      ICNT   = 0                                                        00041000
      SOURC1 = SOURCE                                                   00041100
      IPNTR = IPNTR + 1                                                 00041200
      IF ( BOUNDS(1,IPNTR) .EQ. 0 ) GO TO 1200                          00041300
C--                                                                     00041400
C---- WE HAVE REACHED THE FIRST RECORD YET ???                          00041500
C--                                                                     00041600
  300 IF ( krec .EQ. BOUNDS(1,IPNTR) ) START = .TRUE.                   00041700
      IF ( .NOT. START ) GO TO 100                                      00041800
C--                                                                     00041900
C---- DO THIS STUFF FOR TRACE 1 OF EVERY RECORD...                      00042000
C--                                                                     00042100
  400    IF ( ktrc .GT. 1 ) GO TO 600                                   00042200
C                                                                       00042300
cmam...........check for job constant distances on command line
            RECORD = krec                                               00042400
	if(dist1.ne.0.0.or.dist2.ne.0.0) go to 410
cmam	if(dist1.ne.0.0.or.dist2.ne.0.0) go to 600
            CALL DSTUPD ( RECORD, ndstn, NTRACE )
cmam        CALL DSTUPD ( RECORD, KARD, NTRACE )                        00042500
C                                                                       00042600
  410	continue
	 if(iend.ne.99999) then
		if(cdep1.ne.0.0 .or. cdep1.ne.0.0) then
			begin(1) = cdep1
			begin(ntrace) = cdep2
			call interp(begin,1,ntrace)
			iend = 99999
		endif
         endif
            IF ( ( CBLCRD )                                             00042700
     *             .AND. RECORD .GT. IEND )                             00042800
     *                 CALL CDEPTH ( ISTART, IEND, NTRACE )
C--                                                                     00043000
C---- HOW FAR IS THIS SOURCE AFTER MOVEUP ???                           00043100
C--                                                                     00043200
            IF ( ( .NOT. MOOVUP )                                       00043300
     *             .OR. ( ( MOOVUP ) .AND.                              00043400
     *                  DSTNCE(1,IPNTR) .EQ. BLANK ) )                  00043500
     *                        SOURCE = SOURC1 + SRCINT * (ICNT + 1)     00043600
C    *                        SOURCE = SOURCE + SRCINT                  00043700
C--                                                                     00043800
C---- IS THERE A SOURCE MOVEUP ON THE MOOV CARD ???                     00043900
C---- -99999.99 SIGNIFIES A BLANK ENTRY AS OPPOSED TO A ZERO ENTRY...   00044000
C--                                                                     00044100
            IF ( (  MOOVUP    )                                         00044200
     *              .AND. DSTNCE(1,IPNTR) .NE. BLANK )                  00044300
     *         SOURCE = SOURC1 + DSTNCE(1,IPNTR) * (ICNT + 1)           00044400
C                                                                       00044500
C           IF ( (  MOOVUP    )                                         00044600
C    *              .AND. DSTNCE(1,IPNTR) .NE. BLANK )                  00044700
C    *                  SOURCE = SOURCE + DSTNCE(1,IPNTR)               00044800
C--                                                                     00044900
C---- IF THEY SPECIFIED A SHOT POINT TO TIE                             00045000
C---- TO, LET'S COMPUTE WHERE THE SHOT SHOULD BE...                     00045100
C--                                                                     00045200
            IF ( ( .NOT. MOOVUP )                                       00045300
     *             .OR. BOUNDS(3,IPNTR) .LE. 0                          00045400
     *                .OR. RECORD .NE. BOUNDS(1,IPNTR) ) GO TO 500      00045500
               NUMSP  = ( BOUNDS(3,IPNTR) - SPNUM1 )  / SPINC           00045600
            RNUMSP = FLOAT(( BOUNDS(3,IPNTR) - SPNUM1 )) / FLOAT(SPINC)
               SOURCE = FSTSRC + ( ABS(RNUMSP) * SPLINT )
C              SOURCE = FSTSRC + ( IABS(NUMSP) * SPLINT )               00045700
               SOURC1 = SOURCE                                          00045800
               ICNT   = ICNT - 1                                        00045900
C--                                                                     00046000
C---- BACK UP FROM ANTENNA IF NECESSARY...                              00046100
C--                                                                     00046200
  500       SHOT  = SOURCE - OFFSET                                     00046300
C--                                                                     00046400
C---- DETERMINE SOURCE LOCATION INDEX (109)                             00046500
C--                                                                     00046600
            SRCLOC = ASSIGN ( SHOT, SLINT, 0, DUMMY )                   00046700
            srcloc4= assign4( shot, slint, 0, dummy )                   00046700
            IF ( SRCLOC .NE. -1 ) GO TO 550                             00046800
            WRITE(IPRNTR,525) RECORD                                    00046900
  525       FORMAT(/13X,'** M0200 ** ERROR DETECTED BY SUBROUTINE INDX:'00047000
     *            ,/25X,'THE COMPUTED SOURCE LOCATION INDEX FOR',       00047100
     *             /25X,'RECORD ',I5,' IS LESS THAN ONE.  VERIFY',      00047200
     *             /25X,'ALL PROCESSING PARAMETERS ARE CORRECT.',/)     00047300
            CALL LBCLOS ( luin )
            CALL LBCLOS ( luout )
            CALL CCEXIT ( 100 )                                         00047500
C--                                                                     00047600
  550       IF ( FIRST ) FSTSRC = SOURCE                                00047700
                 FIRST = .FALSE.                                        00047800
cc	write out heading for trace related values
	write(IPRNTR,560)
  560 format(//,1x,'Tr#  ',
     *'   CDP   ','  SHOT  ',' RECEIV ','DIINT ','  DI  ',1x,
     *'   CDP   ','  SHOT  ',' RECEIV ','DIINT ','  DI  ',/)
  570 format(1x,i3,2x,3f8.1,f6.1,i5,3x,3f8.1,f6.1,i5)
C--                                                                     00047900
C---- WHAT IS THE SOURCE NUMBER FOR THIS RECORD ???                     00048000
C--                                                                     00048100
C---- TRUESP IS ACTUAL SOURCE EVEN BETWEEN LABELED SOURCES...           00048200
C--                                                                     00048300
            SRCNUM = SPSET ( SOURCE, SPLINT, DIOVRL, TRUESP, FSTSRC )   00048400
            if (BOUNDS(3,IPNTR) .GT. 0) then
               if (RECORD .EQ. BOUNDS(1,IPNTR))
     *          SRCNUM = BOUNDS(3,IPNTR)
               if ((SRCNUM .EQ. 0) .AND. (SPINC .EQ. 2))
     *          SRCNUM = TRUESP
            endif
C--                                                                     00048500
C---- RECALL SRCLOC IS A FACTOR OF 10 BIGGER...                         00048600
C--                                                                     00048700
600     continue
        ibuf(l_srcloc)=srcloc
        ibuf4(l_sgrdat)=srcloc4
ckjm  	call savew(ibuf, 'SrcLoc', SRCLOC, 1)
ckjm    call savew(ibuf,'SGRDat',srcloc4,1)
C--                                                                     00048900
C---- SET TRACE DISTANCE...                                             00049000
C--                                                                     00049100
         SDIST     = DIST( ktrc )                                       00049200
ccc      IBUF(119) = SDIST + SIGN ( 0.5, SDIST )                        00049300
ccc      IBUF(117) = IBUF(119)                                          00049400
ccc      IF ( IBUF(119) .LT. 0 )                                        00049500
ccc  *                  IBUF(117) = -IBUF(117)                          00049600
	kval = sdist + SIGN(0.5, sdist)
        ibuf(l_dstsgn)=kval
        ibuf(l_dstusg)=abs(kval)
ckjm	call savew(ibuf, 'DstSgn', kval, 1)
ckjm	call savew(ibuf, 'DstUsg', abs(kval), 1)
C--                                                                     00049700
C---- DETERMINE WHERE RECEIVER IS LOCATED..                             00049800
C--                                                                     00049900
         RECEIV    = SHOT - ( MULT * SDIST )                            00050000
         kval = ASSIGN ( RECEIV, GIINT, 1, GIERR )                      00050100
        ibuf(l_recind)=kval
ckjm	call savew(ibuf, 'RecInd', kval, 1)
C                                                                       00050200
         IF ( kval .NE. -1 ) GO TO 650                                  00050300
         WRITE(IPRNTR,625) RECORD, ktrc                                 00050400
  625    FORMAT (/13X,'** M0201 ** ERROR DETECTED BY SUBROUTINE INDX:', 00050500
     *           /25X,'THE COMPUTED GROUP INDEX FOR RECORD ',I5,        00050600
     *           /25X,'TRACE ',I4,' WAS LESS THAN ONE.  VERIFY',        00050700
     *           /25X,'THAT THE GROUP INTERVAL AND TRACE DISTANCES',    00050800
     *           /25X,'ARE CORRECT.',/)                                 00050900
         CALL LBCLOS ( luin )
         CALL LBCLOS ( luout )
         CALL CCEXIT ( 100 )                                            00051100
C--                                                                     00051200
C---- WHAT IS THE CDP ??                                                00051300
C----             CDP IS CALCULATED FROM SHOT (ACTUAL SOURCE POSITION)  00051400
C----             RATHER THAN SOURCE (SOURCE LABELING POSITION)         00051500
C--                                                                     00051600
C 650    CDP       = ( SOURCE + RECEIV ) * 0.5                          00051700
  650    CDP       = ( SHOT + RECEIV ) * 0.5                            00051800
         kval = ASSIG1 ( CDP, DIINT, 1, DIERR )                         00051900
         ibuf(l_dphind)=kval
ckjm	 call savew(ibuf, 'DphInd', kval, 1)
cc	save values, write out values
	lcount = lcount + 1
	if(lcount .gt.2) then
	   write(IPRNTR,570)ltr,(lcdp(i),lshot(i),lrecv(i),
     *		ldiint(i),ldi(i),i=1,2)
	   lcount = 1
	   ltr = ktrc
	endif
ccc	if(IBUF(107) .EQ. 1) ltr = 1
	if(ktrc .EQ. 1) ltr = 1
	lcdp(lcount) = CDP
	lshot(lcount) = SHOT
	lrecv(lcount) = RECEIV
	ldiint(lcount) = DIINT
	ldi(lcount) = kval
	
cc       WRITE(IPRNTR,9999) CDP, SHOT, RECEIV, DIINT, IBUF(122)         00052001
c        WRITE(6,9999) CDP, SHOT, RECEIV, DIINT, IBUF(122)              00052001
 9999    FORMAT(' CDP = ', E12.5,' SHOT = ', E12.5,' RECEIV = ', E12.5, 00052101
     *          ' DIINT = ', E12.5,' DI = ', I10)                       00052202
         DIBSP     = SPSET1( CDP, SPLINT, DIOVRL, TRUESP, FSTSRC )      00052300
C--                                                                     00052400
C---- GET SOURCE POINT LABELS TO                                        00052500
C---- ASSIGN VALUES...                                                  00052600
C--                                                                     00052700
         IF ( WTRCRD ) then                                             00052800
                 kval = VALUE ( TRUESP, WDEPTH, MINWD, MAXWD,           00052900
     *                               SPINC )                            00053000
                ibuf(l_wdepdp)=kval
ckjm		call savew(ibuf, 'WDepDP', kval, 1)
	endif
ckjm    call savew(ibuf, 'PrRcNm', krec, 1)
ckjm    call savew(ibuf, 'PrTrNm', ktrc, 1)
        if (.not. saveperm) then
           ibuf(l_prrcnm)=krec
           ibuf(l_prtrnm)=ktrc
        endif
C                                                                       00053300
              IF ( DIBSP .EQ. 0 ) GO TO 700                             00053400
                 IF ((ILABEL .GT. DIBSP .AND. SPINC .GT. 0 .AND.        00053500
     *                ILABEL .NE. 0 ) .OR.                              00053600
     *               (ILABEL .LT. DIBSP .AND. SPINC .LT. 0 .AND.        00053700
     *                ILABEL .NE. 0 ))  GO TO 700                       00053800
                   ILABEL = DIBSP                                       00053900
ckjm		call saver(ibuf, 'DphInd', IWHERE, 1)
                iwhere=ibuf(l_dphind)
                   IF ( WTRCRD ) then
ckjm  			call saver(ibuf, 'WDepDP', IBOTOM, 1)
                        ibotom=ibuf(l_wdepdp)
                   endif
C                                                                       00054300
C ***         IBUF(125) WILL BE DEAD TRACE FLAG ONLY                    00054400
C ***         JOB-CONSTANT STATIC WILL BE STORED IN                     00054500
C ***         IBUF(16) - TIMING ADJUSTMENT                              00054600
C                                                                       00054700
700      continue
         kval=ibuf(l_stacor)
ckjm   call saver(ibuf, 'StaCor', kval, 1)
	 if(kval .ge. 30000
     *                  .OR. JCSTAT .EQ. 0. ) GO TO 800                 00054900
                   TOTAL   = JCSTAT * 4                                 00055200
ckjm	 call saver(ibuf, 'ToTmAU', lval, 1)
ckjm	 lval = lval + ( TOTAL + SIGN(0.5, TOTAL) )
ckjm	 call savew(ibuf, 'ToTmAU', lval, 1)
         ibuf(l_totmau)=ibuf(l_totmau)+total+sign(.5,total)
                   GO TO 1100                                           00055700
C                                                                       00055800
C
  800   if((cdep1.eq.0.0.and.cdep2.eq.0.0) .or. ( .NOT. CBLCRD ) )
     *		GO TO 1100
c 800         IF ( .NOT. CBLCRD ) GO TO 1100                            00055900
C--                                                                     00056000
C---- IEND = 99999 MEANS NO MORE CABL CARDS;                            00056100
C---- HENCE, NO MORE SPATIAL INTERPOLATION...                           00056200
C---- IF NOT 99999, SPATIALLY INTERPOLATE...                            00056300
C--                                                                     00056400
                 IF ( IEND .EQ. 99999                                   00056500
     *                     .OR. RECORD .LE. ISTART                      00056600
     *                            .OR. RECORD .GT. IEND ) GO TO 900     00056700
                    ISPAN    = IEND - ISTART                            00056800
ccc                 DIFF     = FINISH(IBUF(107)) - BEGIN(IBUF(107))     00056900
		    DIFF = FINISH(ktrc) - BEGIN(ktrc)
                    STEP     = DIFF / FLOAT(ISPAN)                      00057000
                    RECEP    = (( FLOAT( RECORD - ISTART ) * STEP )     00057100
     *                          + BEGIN(ktrc))                          00057200
ccc  *                          + BEGIN(IBUF(107)))                     00057200
                 GO TO 1000                                             00057300
C                                                                       00057400
  900               RECEP    = BEGIN( ktrc )                            00057500
 1000               INIT     = DSTNCE(2,IPNTR)                          00057600
ccc                 IBUF(99) = INIT  + 0.5                              00057700
ccc                 IBUF(96) = RECEP + 0.5                              00057800
ckjm		call savew(ibuf, 'ShtDep', INIT + 0.5, 1)
ckjm		call savew(ibuf, 'CabDep', RECEP + 0.5, 1)
ckjm		call saver(ibuf, 'StaCor', kval, 1)
                ibuf(l_shtdep)=init+.5
                ibuf(l_cabdep)=recep+.5
                kval=ibuf(l_stacor)
C                                                                       00057900
                 IF ( kval .GE. 30000 ) GO TO 1100                      00058000
                    INIT     = INIT  / FLOAT(WATVEL)                    00058100
                    RECEP    = RECEP / FLOAT(WATVEL)                    00058200
                    TOTAL    = INIT + RECEP                             00058300
C--                                                                     00058400
C---- CONVERT TO 1/4 MS...                                              00058500
C--                                                                     00058600
C-- INITIATION STATIC...                                                00058700
                 INIT      = INIT * 4 * 1000.                           00058800
                   ISTAT   = INIT + SIGN ( 0.5, INIT )                  00058900
C                                                                       00059000
C-- RECEPTION STATIC...                                                 00059100
                 RECEP     = RECEP * 4 * 1000.                          00059200
                   JSTAT   = RECEP + SIGN ( 0.5, RECEP )                00059300
C--                                                                     00059400
C---- STORE IN TRACE HEADER...                                          00059500
C--                                                                     00059600
ckjm	call saver(ibuf, 'PREPIn', kval, 1)
ckjm	kval = kval + ISTAT
ckjm	call savew(ibuf, 'PREPIn', kval, 1)
ckjm	call saver(ibuf, 'InStUn', kval, 1)
ckjm	kval = kval + ISTAT
ckjm	call savew(ibuf, 'InStUn', kval, 1)
ckjm	call saver(ibuf, 'PREPRc', kval, 1)
ckjm    kval = kval + JSTAT
ckjm	call savew(ibuf, 'PREPRc', kval, 1)
ckjm	call saver(ibuf, 'RcStUn', kval, 1)
ckjm	kval = kval + JSTAT
ckjm	call savew(ibuf, 'RcStUn', kval, 1)
ckjm	call saver(ibuf, 'ToStUn', kval, 1)
ckjm	kval = kval + ISTAT + JSTAT
ckjm	call savew(ibuf, 'ToStUn', kval, 1)
        ibuf(l_prepin)=ibuf(l_prepin)+istat
        ibuf(l_instun)=ibuf(l_instun)+istat
        ibuf(l_preprc)=ibuf(l_preprc)+jstat
        ibuf(l_rcstun)=ibuf(l_rcstun)+jstat
        ibuf(l_tostun)=ibuf(l_tostun)+istat+jstat
C--                                                                     00060400
C---- STUFF BIASED SOURCE POINTS...                                     00060500
C--                                                                     00060600
 1100 continue

c1100 CALL SPBIAS ( IBFLAG, IBUF(128), IBUF(108), IBUF(127), DIBSP,     00060700
c    *              SRCNUM )                                            00060800
      call spbias ( ibflag, ibuf, DIBSP, SRCNUM )
C--                                                                     00060900
C---- WRITE IT OUT AND DO IT AGAIN...                                   00061000
C--                                                                     00061100
         CALL WRTAPE ( luout, IBUF, LENGTH )
            IF ( ( MOOVUP ) .AND.                                       00061300
     *             krec .EQ. BOUNDS(2,IPNTR) ) END = .TRUE.             00061400
C--                                                                     00061500
C---- KEEP TRACK OF WHAT WE PROCESS...                                  00061600
C--                                                                     00061700
         IF ( ktrc .LT. NTRACE ) GO TO 200                              00061800
C                                                                       00061900
cc	 write out values if any are ready
	if(lcount .gt.0) then
	   write(IPRNTR,570)ltr,(lcdp(i),lshot(i),lrecv(i),
     *		ldiint(i),ldi(i),i=1,lcount)
	   lcount = 0
	endif
         CALL WRTOUT ( RECORD, ILABEL, IWHERE, IBOTOM )                 00062000
         IREC = IREC + 1                                                00062100
         ICNT = ICNT + 1                                                00062200
         GO TO 100                                                      00062300
C                                                                       00062400
 1200 RETURN                                                            00062500
      END                                                               00062600
C                                                                       00062700
C                                                                       00062800
      INTEGER FUNCTION ASSIGN ( PLACE, DELTA, MODE, INTERR )            00062900
C***********************************************************************00063000
C                                                                       00063100
C     FUNCTION NAME: ASSIGN                                             00063200
C                                                                       00063300
C     LANGUAGE: FORTRAN                                                 00063400
C                                                                       00063500
C     AUTHOR: R. WILSON AND E. ANDES                                    00063600
C                                                                       00063700
C     DATE WRITTEN: 01/13/86                                            00063800
C                                                                       00063900
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00064000
C                              TO BE MAINTAINED IN CONFIDENCE           00064100
C                                                                       00064200
C     ABSTRACT:                                                         00064300
C         FUNCTION ASSIGN WILL ASSIGN AN INDEX VALUE BASED ON           00064400
C         A DISTANCE PASSED AND A BUCKET SIZE.                          00064500
C                                                                       00064600
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00064700
C                             INITIAL RELEASE.                          00064800
C                                                                       00064900
C     PARAMETERS PASSED:                                                00065000
C         PLACE  - DISTANCE FROM ORIGIN TO BE LABELED                   00065100
C         DELTA  - LABELING INTERVAL                                    00065200
C         MODE   - FLAG TO SEE IF WE'RE ACCUMULATING ERROR              00065300
C         INTERR - ERROR COUNTER                                        00065400
C                                                                       00065500
C***********************************************************************00065600
C                                                                       00065700
      INTEGER * 4 ERROR, INTERR(50), DIFFER                             00065800
C--                                                                     00065900
C---- SET 'BUCKET' ASSIGNMENT                                           00066000
C--                                                                     00066100
      DELTA2 = DELTA * 0.5                                              00066200
      ASSIGN = ( PLACE + DELTA2 ) / DELTA                               00066300
C--                                                                     00066400
C---- MAKE SURE INDEX STAYS UNDER 32768..                               00066500
C--                                                                     00066600
         IF ( ASSIGN .GT. 32767 ) ASSIGN = 32767                        00066700
C--                                                                     00066800
C---- IF NEGATIVE, SEND BACK BAD INDEX...                               00066900
C--                                                                     00067000
         IF ( ASSIGN .GE. 1 ) GO TO 100                                 00067100
              ASSIGN = -1                                               00067200
              RETURN                                                    00067300
C--                                                                     00067400
C--------------------------------------------------------------         00067500
C-- IF USER PASSED A 'ZERO' FLAG FOR PARM3, THEN LEAVE.                 00067600
C-- OTHERWISE ASSUME PARM4 IS AN ERROR FUNCTION VECTOR RANGING          00067700
C-- FROM -0.5 TO 0.46 (INCREMENTED BY 0.04) INDEXED FROM 1 TO 50.       00067800
C-- UPDATE THIS VECTOR WITH DIFFERENCE BETWEEN TRUE POSITION OF         00067900
C-- THE TRACE ATTRIBUTE AND THE IDEAL POSITION OF THAT ATTRIBUTE.       00068000
C--                                                                     00068100
  100 IF ( MODE .LT. 1 ) RETURN                                         00068200
         DIFFER = ( PLACE - DELTA * ASSIGN ) / DELTA * 50.0             00068300
         ERROR = 26 + DIFFER                                            00068400
         IF (ERROR .LT.  1) ERROR = 1                                   00068500
         IF (ERROR .GT. 50) ERROR = 50                                  00068600
         INTERR(ERROR) = INTERR(ERROR) + 1                              00068700
         RETURN                                                         00068800
      END                                                               00068900
      INTEGER FUNCTION ASSIGN4( PLACE, DELTA, MODE, INTERR )            00062900
C                                                                       00065700
      INTEGER * 4 ERROR, INTERR(50), DIFFER                             00065800
C--                                                                     00065900
C---- SET 'BUCKET' ASSIGNMENT                                           00066000
C--                                                                     00066100
      DELTA2 = DELTA * 0.5                                              00066200
      ASSIGN4= ( PLACE + DELTA2 ) / DELTA                               00066300
C--                                                                     00066800
C---- IF NEGATIVE, SEND BACK BAD INDEX...                               00066900
C--                                                                     00067000
         IF ( ASSIGN4 .GE. 1 ) GO TO 100  
              ASSIGN4 = -1 
              RETURN                                                    00067300
C--                                                                     00067400
C--------------------------------------------------------------         00067500
C-- IF USER PASSED A 'ZERO' FLAG FOR PARM3, THEN LEAVE.                 00067600
C-- OTHERWISE ASSUME PARM4 IS AN ERROR FUNCTION VECTOR RANGING          00067700
C-- FROM -0.5 TO 0.46 (INCREMENTED BY 0.04) INDEXED FROM 1 TO 50.       00067800
C-- UPDATE THIS VECTOR WITH DIFFERENCE BETWEEN TRUE POSITION OF         00067900
C-- THE TRACE ATTRIBUTE AND THE IDEAL POSITION OF THAT ATTRIBUTE.       00068000
C--                                                                     00068100
  100 IF ( MODE .LT. 1 ) RETURN                                         00068200
         DIFFER = ( PLACE - DELTA * ASSIGN4) / DELTA * 50.0             00068300
         ERROR = 26 + DIFFER                                            00068400
         IF (ERROR .LT.  1) ERROR = 1                                   00068500
         IF (ERROR .GT. 50) ERROR = 50                                  00068600
         INTERR(ERROR) = INTERR(ERROR) + 1                              00068700
         RETURN                                                         00068800
      END                                      
C                                                                       00069000
C                                                                       00069100
      INTEGER FUNCTION VALUE ( REAL, WDEPTH, MINWD, MAXWD, SPINC )      00069200
C***********************************************************************00069300
C                                                                       00069400
C     FUNCTION NAME: VALUE                                              00069500
C                                                                       00069600
C     LANGUAGE: FORTRAN                                                 00069700
C                                                                       00069800
C     AUTHOR: R. WILSON AND E. ANDES                                    00069900
C                                                                       00070000
C     DATE WRITTEN: 01/13/86                                            00070100
C                                                                       00070200
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00070300
C                              TO BE MAINTAINED IN CONFIDENCE           00070400
C                                                                       00070500
C     ABSTRACT:                                                         00070600
C         FUNCTION VALUE WILL COMPUTE WATER DEPTHS FOR TRACE INPUT.     00070700
C                                                                       00070800
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00070900
C                             INITIAL RELEASE.                          00071000
C                                                                       00071100
C     PARAMETERS PASSED:                                                00071200
C         REAL   - TRUE SOURCE POINT                                    00071300
C         WDEPTH - WATER DEPTH ARRAY                                    00071400
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    00071500
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    00071600
C         SPINC  - SOURCE POINT INCREMENT                               00071700
C                                                                       00071800
C***********************************************************************00071900
C                                                                       00072000
      REAL    * 4 WDEPTH(12000)                                         00072100
C                                                                       00072200
      INTEGER * 4 SPINC                                                 00072300
C                                                                       00072400
      IREEL  = REAL                                                     00072500
      DIFFER = REAL - IREEL                                             00072600
      IF ( SPINC .LT. 0                                                 00072700
     *           .AND. DIFFER .NE. 0. ) IREEL = IREEL + 1               00072800
C--                                                                     00072900
C---- SEE IF IN BOUNDS....                                              00073000
C--                                                                     00073100
      IF ( IREEL .LT. MINWD ) IREEL = MINWD                             00073200
      IF ( IREEL .GT. MAXWD ) IREEL = MAXWD                             00073300
C--                                                                     00073400
C---- ARE WE BETWEEN TWO SOURCE POINTS ???                              00073500
C---- OR ARE WE AT THE OUTER LIMIT ???                                  00073600
C--                                                                     00073700
      IPNT1  = IREEL - ( MINWD - 1 )                                    00073800
      VALUE1 = WDEPTH(IPNT1)                                            00073900
      IF ( SPINC .GT. 0                                                 00074000
     *           .AND. ( DIFFER .EQ. 0.                                 00074100
     *                .OR. (IREEL + 1) .GT. MAXWD ) )                   00074200
     *                       IREEL = IREEL - 1                          00074300
      IF ( SPINC .LT. 0                                                 00074400
     *           .AND. ( DIFFER .EQ. 0.                                 00074500
     *                .OR. (IREEL - 1) .LT. MINWD ) )                   00074600
     *                       IREEL = IREEL + 1                          00074700
      IPNT2  = IREEL - ( MINWD - 1 )                                    00074800
      IPNT2  = IPNT2 + ISIGN ( 1, SPINC )                               00074900
      VALUE2 = WDEPTH( IPNT2 )                                          00075000
C--                                                                     00075100
C---- SEE HOW IN BETWEEN IT IS...                                       00075200
C--                                                                     00075300
      WDIFF  = VALUE2 - VALUE1                                          00075400
      XDIFF  = DIFFER                                                   00075500
      IF ( SPINC .LT. 0 ) XDIFF = 1. - DIFFER                           00075600
      ISLOPE = ( WDIFF * XDIFF ) + SIGN ( 0.5, WDIFF )                  00075700
      VALUE  = VALUE1 + ISLOPE                                          00075800
C                                                                       00075900
      RETURN                                                            00076000
      END                                                               00076100
C                                                                       00076200
C                                                                       00076300
      SUBROUTINE HISTGM ( ERROR, NMBR )                                 00076400
C***********************************************************************00076500
C                                                                       00076600
C     SUBROUTINE NAME: HISTGM                                           00076700
C                                                                       00076800
C     LANGUAGE: FORTRAN                                                 00076900
C                                                                       00077000
C     AUTHOR: R. WILSON AND E. ANDES                                    00077100
C                                                                       00077200
C     DATE WRITTEN: 01/13/86                                            00077300
C                                                                       00077400
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00077500
C                              TO BE MAINTAINED IN CONFIDENCE           00077600
C                                                                       00077700
C     ABSTRACT:                                                         00077800
C         SUBROUTINE HISTGM DISPLAYS ERROR HISTOGRAMS WHICH ILLUSTRATE  00077900
C         HOW WELL INDEX ASSIGNMENTS FELL INTO ASSIGNMENT BUCKETS.      00078000
C                                                                       00078100
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00078200
C                             INITIAL RELEASE.                          00078300
C                                                                       00078400
C     PARAMETERS PASSED:                                                00078500
C         ERROR  - GI OR DI ERROR IN ASSIGNMENTS                        00078600
C         NMBR   - POINTER FOR HISTOGRAM TITLE                          00078700
C                                                                       00078800
C***********************************************************************00078900
C                                                                       00079000
      INTEGER * 4 ERROR(50)                                             00079100
C                                                                       00079200
      character * 1 TITLE(39), STRING(90), NDECS(10)
C                                                                       00079400
      DATA TITLE/'=','=','=','=','>',7*' ','I','N','D','E','X',         00079500
     *           ' ','E','R','R','O','R',' ','H','I','S','T','O',       00079600
     *           'G','R','A','M',' ','<','=','=','=','='/,              00079700
     *     STRING /90*'*'/, NDECS/'G','R','O','U','P',                  00079800
     *     'D','E','P','T','H'/, MIDDLE/26/                             00079900
C                                                                       00080000
      COMMON /LUNIT/ IREADR, IPRNTR, IDISKW, IDISKC

C--                                                                     00080200
C---- DISPLAY THE TITLE FIRST                                           00080300
C--                                                                     00080400
      CALL MOVE ( 1, TITLE(7), NDECS(NMBR), 5 )                         00080500
      WRITE(IPRNTR,100) TITLE                                           00080600
  100 FORMAT ('1',47X,39A1,/,54X,'---------------------------',/,       00080700
     *        5X,'ERROR',4X,'COUNT',5X,'%',/,5X,'-----',4X,'-----',     00080800
     *        3X,'-----')                                               00080900
C--                                                                     00081000
C---- FIND MAX MAGNITUDE                                                00081100
C--                                                                     00081200
      PERCNT   = 0.                                                     00081300
      MAX      = 0                                                      00081400
      ITOTAL   = 0                                                      00081500
      DO 200 I = 1,50                                                   00081600
         IF ( ERROR(I) .LT.   0) ERROR(I) = -ERROR(I)                   00081700
         IF ( ERROR(I) .GT. MAX) MAX = ERROR(I)                         00081800
         ITOTAL = ITOTAL + ERROR(I)                                     00081900
  200 CONTINUE                                                          00082000
C--                                                                     00082100
C---- COMPUTE NORMALIZATION COEFFICIENT                                 00082200
C--                                                                     00082300
	if(max.eq.0) then
		write(iprntr,*)'*** ERROR in HISTGM ***'
		write(iprntr,*)'  max. error = 0'
		return
	endif
      RNORML = 80.0 / FLOAT( MAX )                                      00082400
C--                                                                     00082500
C---- SCALE EACH ELEMENT AND PLOT HISTOGRAM                             00082600
C--                                                                     00082700
      DO 800 I = 1,50                                                   00082800
         IVAL = ERROR(I) * RNORML + 1                                   00082900
         PERCNT = ( FLOAT( ERROR(I) ) / FLOAT( ITOTAL ) ) * 100.        00083000
         IF ( I .GT. 1 ) GO TO 400                                      00083100
            WRITE (IPRNTR,300) ERROR(I), PERCNT, (STRING(J),J=1,IVAL)   00083200
  300       FORMAT (/,5X,'-0.50',2X,I7,3X,F5.1,3X,'+',90A1)             00083300
            GO TO 800                                                   00083400
  400    IF ( I .NE. MIDDLE ) GO TO 600                                 00083500
            WRITE (IPRNTR,500) ERROR(I), PERCNT, (STRING(J),J=1,IVAL)   00083600
  500       FORMAT (5X,' 0.00',2X,I7,3X,F5.1,3X,'+',90A1)               00083700
            GO TO 800                                                   00083800
  600    WRITE (IPRNTR,700) ERROR(I), PERCNT, (STRING(J),J=1,IVAL)      00083900
  700    FORMAT (12X,I7,3X,F5.1,3X,'I',90A1)                            00084000
  800    CONTINUE                                                       00084100
C                                                                       00084200
      WRITE (IPRNTR,900) ITOTAL                                         00084300
  900 FORMAT (5X,'+0.50',2X,'      0',3X,'  0.0',3X,'+*',/,12X,         00084400
     *        '-------',/,4X,'TOTAL = ',I7)                             00084500
C--                                                                     00084600
C---- GET OUTTA HERE !!!!                                               00084700
C--                                                                     00084800
      IF ( NMBR .EQ. 6 ) WRITE(IPRNTR,1000)                             00084900
 1000 FORMAT ('1')                                                      00085000
      RETURN                                                            00085100
      END                                                               00085200
C                                                                       00122600
      SUBROUTINE FLDHCD ( nfldh,hdrlen)
cmam  SUBROUTINE FLDHCD ( KARD, HDRLEN, CC1, PKARD )                    00122700
C***********************************************************************00122800
C                                                                       00122900
C     SUBROUTINE NAME: FLDHCD                                           00123000
C                                                                       00123100
C     LANGUAGE: FORTRAN                                                 00123200
C                                                                       00123300
C     AUTHOR: R. WILSON AND E. ANDES                                    00123400
C                                                                       00123500
C     DATE WRITTEN: 01/13/86                                            00123600
C                                                                       00123700
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00123800
C                              TO BE MAINTAINED IN CONFIDENCE           00123900
C                                                                       00124000
C     ABSTRACT:                                                         00124100
C         SUBROUTINE FLDHCD INSERTS FIELD HISTORY INTO THE              00124200
C         LINE HEADER.                                                  00124300
C                                                                       00124400
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00124500
C                             INITIAL RELEASE.                          00124600
C                                                                       00124700
C     PARAMETERS PASSED:                                                00124800
C         KARD   - CARD IMAGE                                           00124900
C         HDRLEN - LENGTH OF LINE HEADER                                00125000
C         CC1    - VALUE IN CC 1                                        00125100
C         PKARD  - PORTION OF CARD IMAGE (CC 11-45)                     00125200
C                                                                       00125300
C***********************************************************************00125400
C                                                                       00125500
      REAL    * 4 DIST(1024), DSTNCE(2,5000),                           00125604
     *            BEGIN(1024), FINISH(1024)                             00125704
C                                                                       00125900
      INTEGER * 4  IHEAD(12128), CC1, HDRLEN,
     *            BOUNDS(3,5000), LENG2
      CHARACTER*1 PKARD(35)
	character*80 KARD
	character nfldh*255
C                                                                       00126200
cmam  DATA  DELFLD/.TRUE./                                              00126500
C                                                                       00126600
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00126800
C--                                                                     00126900
      CALL DEFLDH ( IHEAD, HDRLEN, IHEAD )
C                                                                       00127600
C                                                                       00128200
      if (nfldh(1:1) .ne. ' ') then
         open (unit=91, file= nfldh, status='old',
     1         form='formatted',access='sequential')
      else
	return
      endif
c
    5 read(91,10,end=100) kard
   10	format(a80)
      I = LENG2 ( KARD, 35 )
      IF ( I .LT. 1 ) I = 1                                             00128400
      CALL INFLDH ( IHEAD, HDRLEN, KARD, I, IHEAD )
	go to 5
c
  100 continue
      RETURN                                                            00128600
      END                                                               00128700
C                                                                       00128800
C                                                                       00128900
      SUBROUTINE WATRCD ( nwatr, WDEPTH, MINWD, MAXWD )
C***********************************************************************00129100
C                                                                       00129200
C     SUBROUTINE NAME: WATRCD                                           00129300
C                                                                       00129400
C     LANGUAGE: FORTRAN                                                 00129500
C                                                                       00129600
C     AUTHOR: R. WILSON AND E. ANDES                                    00129700
C                                                                       00129800
C     DATE WRITTEN: 01/13/86                                            00129900
C                                                                       00130000
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00130100
C                              TO BE MAINTAINED IN CONFIDENCE           00130200
C                                                                       00130300
C     ABSTRACT:                                                         00130400
C         SUBROUTINE WATRCD READS IN SOURCE POINT ORIENTED WATER        00130500
C         DEPTHS AND STORES THEM.                                       00130600
C                                                                       00130700
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00130800
C                             INITIAL RELEASE.                          00130900
C                                                                       00131000
C     PARAMETERS PASSED:                                                00131100
C         KARD   - CARD IMAGE                                           00131200
C         WDEPTH - WATER DEPTH ARRAY                                    00131300
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    00131400
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    00131500
C                                                                       00131600
C***********************************************************************00131700
C                                                                       00131800
      REAL    * 8 TJOBID, CJOBID                                        00131900
C                                                                       00132000
      REAL    * 4 DIST(1024), WDEPTH(12000), DEEP(4), DSTNCE(2,5000),   00132104
     *            BEGIN(1024), FINISH(1024)                             00132200
C                                                                       00132300
      INTEGER * 4 IHEAD(12128), SPOINT(4), BOUNDS(3,5000),              00132404
     *            luout, SPNUM1, SPINC, RIPSRC
C                                                                       00132600
	integer ispno
	real	wbd
	character nwatr*255
	character*80 KARD
c
C                                                                       00133000
      DATA  NCARDS/0/
C                                                                       00133200
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00133500
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00133600
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00133700

C--                                                                     00133800
      if (nwatr(1:1) .ne. ' ') then
         open (unit=92, file= nwatr, status='old',
     1         form='formatted',access='sequential')
      else
	return
      endif
c
    5 continue
      READ(92,10,end=100) KARDID, KARD
   10 FORMAT (1X,A4,T1,A80)
      READ(KARD, 20) NCHECK, (SPOINT(I),I=1,4)
   20 FORMAT (I1,4X,4(I5,10X))

C--                                                                     00138000
C---- TRAP MIN AND MAX WATER DEPTH....                                  00138100
C--                                                                     00138200
      DO 50 J = 1,4
         IF (   SPOINT(J) .LE. 0   ) GO TO 50
         IF ( SPOINT(J) .LT. MINWD ) MINWD = SPOINT(J)                  00138500
         IF ( SPOINT(J) .GT. MAXWD ) MAXWD = SPOINT(J)                  00138600
   50 CONTINUE                                                          00138700
        iminwd = MINWD
        imaxwd = MAXWD
C                                                                       00138800
      WRITE(IDISKW,60) kard
   60 format(a80)
C                                                                       00139100
	go to 5
C                                                                       00139700
  100	continue
            ENDFILE IDISKW                                              00139800
            REWIND  IDISKW                                              00139900
	minwd1 = iminwd - 1
C--                                                                     00140000
C---- READ CARD FROM DISK...                                            00140100
C--                                                                     00140200
  800 continue
      READ(IDISKW,900,END=1100) (SPOINT(I),DEEP(I),I=1,4)               00140400
  900 FORMAT (5X,4(I5,F10.0))                                           00140500
C--                                                                     00140600
C---- STUFF WATER DEPTHS INTO BUFFER....                                00140700
C--                                                                     00140800
      DO 1000 K = 1,4                                                   00140900
         IF ( SPOINT(K) .LE. 0 ) GO TO 1000                             00141000
         WDEPTH( SPOINT(K) - minwd1 ) = DEEP(K)
 1000 CONTINUE                                                          00141200
      GO TO 800                                                         00141300

C--                                                                     00140600
C                                                                       00141400
 1100 RETURN                                                            00141500
      END                                                               00141600
C                                                                       00141700
C                                                                       00141800
      SUBROUTINE CABLCD ( ncabl)
C***********************************************************************00142000
C                                                                       00142100
C     SUBROUTINE NAME: CABLCD                                           00142200
C                                                                       00142300
C     LANGUAGE: FORTRAN                                                 00142400
C                                                                       00142500
C     AUTHOR: R. WILSON AND E. ANDES                                    00142600
C                                                                       00142700
C     DATE WRITTEN: 01/13/86                                            00142800
C                                                                       00142900
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00143000
C                              TO BE MAINTAINED IN CONFIDENCE           00143100
C                                                                       00143200
C     ABSTRACT:                                                         00143300
C         SUBROUTINE CABLCD READS CABLE DEPTH CARDS AND WRITES THEM     00143400
C         TO DISK FOR LATER ACCESS.                                     00143500
C                                                                       00143600
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00143700
C                             INITIAL RELEASE.                          00143800
C                                                                       00143900
C     PARAMETERS PASSED:                                                00144000
C         KARD   - CARD IMAGE                                           00144100
C         TJOBID - JOB NUMBER FROM TAPE                                 00144200
C         KARDID - CC 2-5                                               00144300
C         NTRACE - NUMBER OF TRACES PER RECORD                          00144400
C                                                                       00144500
C***********************************************************************00144600
C                                                                       00144700
      REAL    * 8 TJOBID, CJOBID                                        00144800
C                                                                       00144900
      INTEGER * 4  CC1                                                  00145000
C                                                                       00145100
      character * 1 CJOB(8)
	character*80 KARD
	character ncabl*255
C                                                                       00145300
      EQUIVALENCE ( CJOB(1), CJOBID )                                   00145400
C                                                                       00145500
C                                                                       00145700
      COMMON /LUNIT/ IREADR, IPRNTR, IDISKW, IDISKC

C--                                                                     00145900
      if (ncabl(1:1) .ne. ' ') then
         open (unit=93, file= ncabl, status='old',
     1         form='formatted',access='sequential')
      else
	return
      endif
C--                                                                     00146100
    5   continue
cmam	read(93,*,end=100) itr,idep
	read(93,10,end=100) KARD
   10	format (a80)
C                                                                       00146700
C---- WRITE IT OUT AND READ ANOTHER...                                  00148800
C--                                                                     00148900
	write(idiskc,10) kard
	go to 5
C                                                                       00146300
  100	continue
         ENDFILE IDISKC                                                 00146400
         REWIND  IDISKC                                                 00146500
C                                                                       00149500
      RETURN                                                            00149600
      END                                                               00149700
C                                                                       00149800
C                                                                       00149900
      SUBROUTINE MOOVCD ( nmoov)
cmam  SUBROUTINE MOOVCD ( KARD )                                        00150000
C***********************************************************************00150100
C                                                                       00150200
C     SUBROUTINE NAME: MOOVCD                                           00150300
C                                                                       00150400
C     LANGUAGE: FORTRAN                                                 00150500
C                                                                       00150600
C     AUTHOR: R. WILSON AND E. ANDES                                    00150700
C                                                                       00150800
C     DATE WRITTEN: 01/13/86                                            00150900
C                                                                       00151000
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00151100
C                              TO BE MAINTAINED IN CONFIDENCE           00151200
C                                                                       00151300
C     ABSTRACT:                                                         00151400
C         SUBROUTINE MOOVCD READS IN RECORD VARIABLE SOURCE MOVEUPS.    00151500
C         THE MOVEUP VALUE ENTERED WILL OVERRIDE THE SOURCE INTERVAL    00151600
C         ENTERED ON THE 1MAIP CARD FOR THE RECORD BOUNDARIES GIVEN     00151700
C         ON THE 1MOOV CARD(S).                                         00151800
C                                                                       00151900
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00152000
C                             INITIAL RELEASE.                          00152100
C                                                                       00152200
C     PARAMETERS PASSED:                                                00152300
C         KARD   - CARD IMAGE                                           00152400
C                                                                       00152500
C***********************************************************************00152600
C                                                                       00152700
#include <f77/lhdrsz.h>
      REAL    * 4 DIST(1024), DSTNCE(2,5000), BEGIN(1024), FINISH(1024) 00152804
C                                                                       00152900
      INTEGER * 4 BOUNDS(3,5000), CC1, IHEAD(12128), luout
	character nmoov*255
C                                                                       00153100
cmam ... 052093 ... potential error on cray.........
	character*10 IPOOP, IBLANK
	data iblank/'          '/
      DATA IPOINT/1/,  BLANK/-99999.99/
cmam ... 052093 ... end of changes...................
C                                                                       00153300
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00153600
	save
C                                                                       00153700
           CALL MOVE ( 0, DSTNCE, 0., 10000*SZSMPD )                    00153904
           CALL MOVE ( 0, BOUNDS, 0 , 15000*SZSMPD )                    00154004
C--                                                                     00154100
      if (nmoov(1:1) .ne. ' ') then
         open (unit=94, file= nmoov, status='old',
     1         form='formatted',access='sequential')
      else
	return
      endif

    5 continue
      READ(94,200,end=990) CC1, BOUNDS(1,IPOINT), BOUNDS(2,IPOINT),
     *                 BOUNDS(3,IPOINT),DSTNCE(1,IPOINT),               00154800
     *                 DSTNCE(2,IPOINT),ipoop
  200 FORMAT (I1,4X,3I5,2F10.0,t21,a10)
c
      IF ( CC1 .NE. 1 ) WRITE(IPRNTR,300) CC1                           00155200
  300 FORMAT (/13X,'** M1000 ** WARNING FROM SUBROUTINE MOOVCD:',       00155300
     *        /25X,'THE CARD NUMBER IDENTIFIER (CC 1) IS INCORRECT.',   00155400
     *        /25X,'THE CARD CONTAINS A ',I1,' BUT IT SHOULD HAVE',     00155500
     *        /25X,'BEEN A 1.  VERIFY CARD INPUT IS CORRECT.',/)        00155600
C                                                                       00155700
      IF ( IPOINT .LE. 5000 ) GO TO 500                                 00155804
C                                                                       00155900
      WRITE(IPRNTR,400)                                                 00156000
  400 FORMAT (/13X,'** M1001 ** ERROR DETECTED IN SUBROUTINE MOOVCD:',  00156100
     *        /25X,'PROGRAM MAIP WILL ACCEPT A MAXIMUM OF 5000 MOOV',   00156204
     *        /25X,'CARDS PER PROGRAM EXECUTION.  THIS MAXIMUM HAS',    00156300
     *        /25X,'BEEN EXCEEDED.  REDUCE THE NUMBER OF MOOV CARDS',   00156400
     *        /25X,'AND RESUBMIT.',/)                                   00156500
      CALL CCEXIT ( 100 )                                               00157700
C                                                                       00156800
  500 IF ( BOUNDS(1,IPOINT) .NE. 0                                      00156900
     *             .AND. BOUNDS(2,IPOINT) .NE. 0 ) GO TO 700            00157000
      WRITE(IPRNTR,600)                                                 00157100
  600 FORMAT (/13X,'** M1002 ** ERROR DETECTED IN SUBROUTINE MOOVCD:',  00157200
     *        /25X,'THE FIRST (CC 6-10) AND LAST (CC 11-15) RECORD',    00157300
     *        /25X,'ENTRIES CAN NOT BE LEFT BLANK OR 0.  VERIFY',       00157400
     *        /25X,'CARD INPUT AND RESUBMIT.',/)                        00157500
      CALL CCEXIT ( 100 )                                               00157700
C                                                                       00157800
  700 IF ( BOUNDS(3,IPOINT) .GE. 0 ) GO TO 900                          00157900
      WRITE(IPRNTR,800)                                                 00158000
  800 FORMAT (/13X,'** M1003 ** WARNING FROM SUBROUTINE MOOVCD:',       00158100
     *        /25X,'THE FIRST RECORD SOURCE ID ON 1MOOV CARD IS LESS',  00158200
     *        /25X,'THAN ZERO.  PARAMETER WILL NOT BE USED.'/)          00158300
  900 IF ( IPOOP .EQ. IBLANK ) DSTNCE(1,IPOINT) = BLANK                 00158400
C                                                                       00158500
      IPOINT = IPOINT + 1                                               00158600
C                                                                       00158700
	go to 5
C                                                                       00158700
  990	continue
	write(iprntr,*)'   MOOV cards read:'
	write(iprntr,995)(bounds(1,i),bounds(2,i),bounds(3,i),
     *		dstnce(1,i),dstnce(2,i),i=1,ipoint)
  995 format(3i15,2f15.3)
      RETURN                                                            00158800
      END                                                               00158900
C                                                                       00159000
C                                                                       00159100
      INTEGER FUNCTION SPSET ( SOURCE, DELTA, LIMIT, TRUESP, FRSTSP )   00159200
C***********************************************************************00159300
C                                                                       00159400
C     FUNCTION NAME: SPSET                                              00159500
C                                                                       00159600
C     LANGUAGE: FORTRAN                                                 00159700
C                                                                       00159800
C     AUTHOR: R. WILSON AND E. ANDES                                    00159900
C                                                                       00160000
C     DATE WRITTEN: 01/13/86                                            00160100
C                                                                       00160200
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00160300
C                              TO BE MAINTAINED IN CONFIDENCE           00160400
C                                                                       00160500
C     ABSTRACT:                                                         00160600
C         FUNCTION SPSET ASSIGNS HALF WORD 108.                         00160700
C                                                                       00160800
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00160900
C                             INITIAL RELEASE.                          00161000
C                                                                       00161100
C     PARAMETERS PASSED:                                                00161200
C         SOURCE - DISTANCE FROM ORIGIN                                 00161300
C         DELTA  - LABELING INTERVAL                                    00161400
C         LIMIT  - AMOUNT OF SLOP FOR LABELING                          00161500
C         TRUESP - FLOATING POINT SOURCE POINT AT ANY LOCATION          00161600
C         FRSTSP - LOCATION OF FIRST SOURCE ON LINE                     00161700
C                                                                       00161800
C***********************************************************************00161900
C                                                                       00162000
      REAL    * 8 TJOBID
      REAL    * 4 SOURCE, LIMIT, ERROR                                  00162100
C                                                                       00162200
      INTEGER * 4 SPNUM1, SPINC, RIPSRC, ASSIGN                         00162300
C                                                                       00162400
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/ luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00162500
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00162600
C--                                                                     00162900
C---- COMPUTE DISTANCE FROM FIRST SOURCE POINT AND BIAS BY ONE          00163000
C---- SOURCE POINT LABELING INTERVAL.                                   00163100
C--                                                                     00163200
      ADJUST = SOURCE - FRSTSP + DELTA                                  00163300
C--                                                                     00163400
C---- GET SOURCE POINT OVER THIS DI...                                  00163500
C--                                                                     00163600
      SPSET = ASSIGN ( ADJUST, DELTA, 0, DUMMY )                        00163700
C--                                                                     00163800
C---- IS IT VALID ???                                                   00163900
C--                                                                     00164000
      IF ( SPSET .GT. 0 ) GO TO 100                                     00164100
           SPSET  = 0                                                   00164200
           TRUESP = SPNUM1                                              00164300
           RETURN                                                       00164400
C--                                                                     00164500
C-- COMPUTE REAL ERROR IN SOURCE POINT LABEL INDEX ASSIGNMENT           00164600
C--                                                                     00164700
  100 ERROR = ADJUST / DELTA - FLOAT(SPSET)                             00164800
C--                                                                     00164900
C---- COMPUTE AND RETURN SOURCE POINT LABEL                             00165000
C---- ASSOCIATED WITH THIS POSITION...                                  00165100
C---- DETERMINE REAL SOURCE POINT LABELING                              00165200
C---- INDEX TOO, EVEN BETWEEN TWO LABELED SOURCE POINTS....             00165300
C--                                                                     00165400
      SPSET  = SPNUM1 + ( SPSET - 1 ) * SPINC                           00165500
      TRUESP = SPSET + ( ERROR * FLOAT( SPINC ) )                       00165600
C--                                                                     00165700
C---- IF POSITION IS BEFORE FIRST SOURCE LABEL POSTION, RETURN          00165800
C---- ZERO FOR A LABEL AND FIRST SOURCE POINT AS TRUESP                 00165900
C---- ALSO NEED TO ADD AN INCREMENT OF SOURCE POINT LABEL IF            00166000
C---- NOT A POSITIVE NUMBER...                                          00166100
C--                                                                     00166200
C     IF ( ABS(ERROR) .LT. LIMIT ) GO TO 150                            00166300
      IF (( ABS(ERROR) .LT.   LIMIT ) .OR.                              00166400
     *    (     ERROR  .EQ.   LIMIT   .AND. SPINC .GT. 0) .OR.          00166500
     *    (     ERROR  .EQ. -(LIMIT)  .AND. SPINC .LT. 0) )             00166600
     * GO TO 150                                                        00166700
C                                                                       00166800
      SPSET = 0                                                         00166900
      IF ( TRUESP .LT. SPNUM1                                           00167000
     *            .AND. SPINC .GT. 0 ) TRUESP = SPNUM1                  00167100
      IF ( TRUESP .GT. SPNUM1                                           00167200
     *            .AND. SPINC .LT. 0 ) TRUESP = SPNUM1                  00167300
      RETURN                                                            00167400
C                                                                       00167500
  150 IF (SPSET .GT. 0) RETURN                                          00167600
C                                                                       00167700
      WRITE(IPRNTR,200) SPSET                                           00167800
  200 FORMAT (/13X,'** M1100 ** ERROR DETECTED IN FUNCTION SPSET:',     00167900
     *        /25X,'SOURCE POINT NUMBER ',I5,' IS LESS THAN OR',        00168000
     *        /25X,'EQAUL TO ZERO. REENTER SOURCE ID AND SOURCE',       00168100
     *        /25X,'POINT INCREMENT ON 1MAIP CARD.',/)                  00168200
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00168400
      END                                                               00168500
C                                                                       00168600
C                                                                       00168700
      SUBROUTINE DSTUPD ( RECORD, ndstn, NTRACE)
cmam  SUBROUTINE DSTUPD ( RECORD, KARD, NTRACE)                         00168800
C***********************************************************************00168900
C                                                                       00169000
C     SUBROUTINE NAME: DSTUPD                                           00169100
C                                                                       00169200
C     LANGUAGE: FORTRAN                                                 00169300
C                                                                       00169400
C     AUTHOR: R. WILSON AND E. ANDES                                    00169500
C                                                                       00169600
C     DATE WRITTEN: 01/13/86                                            00169700
C                                                                       00169800
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00169900
C                              TO BE MAINTAINED IN CONFIDENCE           00170000
C                                                                       00170100
C     ABSTRACT:                                                         00170200
C         SUBROUTINE DSTUPD CHECKS TO SEE IF THE CURRENT SET OF         00170300
C         TRACE DISTANCES ARE VALID.  IF THEY ARE NOT, IT WILL          00170400
C         READ IN ANOTHER SET OF DISTANCES.                             00170500
C                                                                       00170600
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00170700
C                             INITIAL RELEASE.                          00170800
C                                                                       00170900
C     PARAMETERS PASSED:                                                00171000
C         RECORD - CURRENT RECORD NUMBER                                00171100
C                                                                       00171200
C***********************************************************************00171300
C                                                                       00171400
#include <f77/lhdrsz.h>
      REAL    * 8 TJOBID, CJOBID                                        00171500
C                                                                       00171600
      REAL    * 4 CDIST(4), DIST(1024), DSTNCE(2,5000),                 00171704
     *            BEGIN(1024), FINISH(1024)                             00171800
C                                                                       00171900
      INTEGER * 4 TRASE(4), RECORD, BYTES, CC1, ONECHK,                 00172000
     *            BOUNDS(3,5000), IHEAD(12128), luout,
     *            SPNUM1, SPINC, RIPSRC
C                                                                       00172200
cmam	character*80 KARD
	character ndstn*255
      CHARACTER*1 CJOB(8)
      LOGICAL     HDRFLG, RDFLAG, CONVEN, FIRST, INDEX,
     *            WTRCRD, FELDCD, DSTCRD, MOOVUP, HISTGR, CBLCRD
      LOGICAL     LRIFLG,
     *            DCHECK 
	INTEGER*4 MRI
	SAVE MRI, LRIFLG
C                                                                       00172700
      EQUIVALENCE ( CJOB(1), CJOBID )                                   00172800
C                                                                       00172900
      DATA  LASTRI/-9999/, BLANK/-99999.99/
      DATA LRIFLG /.FALSE./, DCHECK /.TRUE./
C                                                                       00173100
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00173500
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00173600
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00173700
     *                HISTGR, CBLCRD                                    00173800
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00173400
C--                                                                     00173900
C-- IF WE HAVE DISTANCES FOR THIS RECORD, LEAVE...                      00174000
C--                                                                     00174100
      MRI = 0                                                           00174200
C                                                                       00174300
  100 IF ( RECORD .LE. LASTRI ) RETURN                                  00174400
      GO TO 200                                                         00174500
C--                                                                     00174600
C-- IF READING NEXT SET OF TRACE DISTANCES,                             00174700
C-- RESET SOME STUFF..                                                  00174800
C--                                                                     00174900
C---- THIS IS FOR VERY FIRST DSTN CARD ONLY....                         00175000
cmam  ENTRY DISTRD ( RECORD, KARD, NTRACE )                             00175100
      ENTRY DISTRD ( RECORD, ndstn, NTRACE )
      FIRST  = .TRUE.                                                   00175200
C--                                                                     00175300
C---- HDRFLG IS TO INDICATE FIRST DSTN CARD OF A SET...                 00175400
C---- RDFLAG INDICATES A DISTANCE HAS BEEN READ FOR THE LAST TRACE      00175500
C---- OF A RECORD....                                                   00175600
C--                                                                     00175700
  200 HDRFLG = .FALSE.                                                  00175800
      RDFLAG = .TRUE.                                                   00175900
      ONECHK = 0                                                        00176000
      CALL MOVE ( 2, CJOB, 0, 8 )                                       00176100
C--                                                                     00176200
C---- READ A CARD...                                                    00176300
C--                                                                     00176400
c     IF ( FIRST ) CALL STRING ( KARD, 80 )                             00176500
C                                                                       00176600
c.......if first, open dataset to read
  300 if(FIRST) then
       if (ndstn(1:1) .ne. ' ') then
         open (unit=87, file= ndstn, status='old',
     1         form='formatted',access='sequential')
       else
	DSTCRD = .FALSE.
        return
       endif
      endif
c
cmam	read(KARD,402,END=2000) CC1,KARDID,(TRASE(I),CDIST(I),I=1,4),
cmam *	    (CJOB(K),K=2,8), LRI
  402 FORMAT (I1,A4,4(1X,I4,F10.0),3X,7A1,I5)                           00176900
cmam  else
      READ(87,400,END=2000) CC1, KARDID, (TRASE(I),CDIST(I),I=1,4),
cmam  READ(IREADR,400,END=2000) CC1, KARDID, (TRASE(I),CDIST(I),I=1,4), 00176700
c 300 READ(IREADR,400,END=2000) CC1, KARDID, (TRASE(I),CDIST(I),I=1,4), 00176700
     *                          (CJOB(K),K=2,8), LRI, KARD              00176800
  400 FORMAT (I1,A4,4(1X,I4,F10.0),3X,7A1,I5,T1,A80)                    00176900
cmam  endif
C--                                                                     00177000
C---- CHECK PARAMETERS ON DISTANCE CARDS...                             00177100
C--                                                                     00177200
      IF ( LRI .EQ. 0 ) LRI = 99999                                     00177300
                                                                        00177400
      IF ( MRI .EQ. 0 ) MRI = LRI                                       00177600
      IF ( TRASE(1) .NE. 1 .AND. LRI .NE. MRI ) GO TO 2200              00177500
c     IF ( MRI .EQ. 0 ) MRI = LRI                                       00177600
                                                                        00177700
      IF ( LRI .NE. MRI .AND. .NOT. LRIFLG ) GO TO 2200                 00177800
      IF ( MRI .NE. LRI ) LRIFLG = .FALSE.                              00177900
      IF ( MRI .NE. LRI ) MRI = LRI                                     00178000
                                                                        00178100
C--                                                                     00178200
C---- SET UP TRACE DISTANCE BUFFER FOR INTERPOLATION...                 00178300
C--                                                                     00178400
      IF ( HDRFLG ) GO TO 500                                           00178500
      BYTES = ( NTRACE * SZSMPD ) - SZSMPD                              00178600
      DIST(1) = BLANK                                                   00178700
ccc   CALL MOVE ( 1, DIST(2), DIST(1), BYTES )                          00178800
	call vfill(BLANK, DIST, 1, NTRACE)
C--                                                                     00178900
C---- WAS LAST RECORD BLANK ???                                         00179000
C--                                                                     00179100
  500 continue
c     call stoflt(CJOB,CJOBID)
      IF ( CJOBID .EQ. TJOBID ) GO TO 700                               00179200
C                                                                       00179300
      IF ( .NOT. HDRFLG ) CALL WRCARD ( KARD, 1, IPRNTR )               00179400
      IF     ( HDRFLG )   CALL WRCARD ( KARD, 3, IPRNTR )               00179500
      WRITE(IPRNTR,600) CC1, CC1, (CJOB(I),I=1,8), TJOBID               00179600
  600 FORMAT (/,13X,'** M1200 ** WARNING FROM SUBROUTINE DSTUPD:',      00179700
     *        /,25X,'JOB IDENTIFICATION NUMBER OF THE ',I1,'DSTN CARD', 00179800
     *        /,25X,'(CC 69-75), DOES NOT MATCH THE JOB',               00179900
     *        /,25X,'IDENTIFICATION NUMBER ON THE INPUT TAPE.',         00180000
     *        /,25X, I1,'DSTN CARD: ',8A1,                              00180100
     *        /,25X,'INPUT TAPE: ', A8,/)                               00180200
C                                                                       00180300
  700 FIRST = .FALSE.                                                   00180400
C--                                                                     00180500
C---- IF THIS IS FIRST DSTN CARD, GRAB SOME STUFF..                     00180600
C--                                                                     00180700
      IF ( HDRFLG ) GO TO 800                                           00180800
           HDRFLG = .TRUE.                                              00180900
C--                                                                     00181000
C---- PRINT IT OUT...                                                   00181100
C--                                                                     00181200
         CALL WRCARD ( KARD, 1, IPRNTR )                                00181300
         LASTRI = LRI                                                   00181400
         GO TO 900                                                      00181500
C--                                                                     00181600
C-- SHOW THEM THE CARD... MAKE SURE ITS OK...                           00181700
C--                                                                     00181800
  800 CALL WRCARD ( KARD, 3, IPRNTR )                                   00181900
  900	go to 1100
c 900 IF ( KARDID .EQ. NDSTN ) GO TO 1100                               00182000
      WRITE (IPRNTR,1000)                                               00182100
 1000 FORMAT (/,13X,'** M1201 ** ERROR DETECTED IN SUBROUTINE DSTUPD:', 00182200
     *        /,25X,'THE PRECEDING CARD IS INVALID INPUT TO PROGRAM',   00182300
     *        /,25X,'MAIP.  VERIFY CARD INPUT AND RESUBMIT.',/)         00182400
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00182600
C--                                                                     00182700
C---- CHECK CARD SEQUENCE COUNTER, CC1 ....                             00182800
C--                                                                     00182900
 1100 ONECHK = ONECHK + 1                                               00183000
      IF ( CC1 .NE. ONECHK ) WRITE(IPRNTR,1200) CC1, ONECHK             00183100
 1200 FORMAT (/,13X,'** M1202 ** WARNING FROM SUBROUTINE DSTUPD:',      00183200
     *        /,25X,'THE CARD SEQUENCE NUMBER (CC 1) IS INCORRECT.',    00183300
     *        /,25X,'THE DSTN CARD CONTAINS A ',I1,' BUT IT SHOULD',    00183400
     *        /,25X,'HAVE BEEN A ',I1,'.  VERIFY CARD INPUT IS',        00183500
     *        /,25X,'CORRECT.',/)                                       00183600
C                                                                       00183700
      IF ( ONECHK .EQ. 9 ) ONECHK = 0                                   00183800
C--                                                                     00183900
C---- GET TRACE DISTANCE (IF VALID) AND STASH THEM IN DISTANCE ARRAY.   00184000
C---- WHEN TRACE 'N' IS READ, SET FLAG TO NOT READ CARDS...             00184100
C--                                                                     00184200
      DO 1300 I = 1,4                                                   00184300
         IF ( TRASE(I) .EQ. NTRACE ) RDFLAG = .FALSE.                   00184400
         IF ( .NOT. RDFLAG .AND. DCHECK ) GO TO 2200                    00184500
            DCHECK = .FALSE.                                            00184600
         IF ( ( TRASE(I) .LT. 1 )                                       00184700
     *            .OR. ( TRASE(I) .GT. NTRACE ) ) GO TO 1300            00184800
         IF ( TRASE (I) .NE. TRASE (I-1) ) GO TO 1250                   00184900
      WRITE (IPRNTR,1225)                                               00185000
 1225 FORMAT (//,13X,'** M1203 ** ERROR IN SUBROUTINE DSTUPD:',         00185100
     *         /,25X,'TRACE NUMBERS ENTERED ON THE DSTN CARDS ARE',     00185200
     *         /,25X,'INVALID.  YOU MUST BEGIN WITH THE FIRST TRACE',   00185300
     *         /,25X,'OF THE RECORD AND END WITH THE LAST.  CORRECT',   00185400
     *         /,25X,'PARAMETER AND RESUBMIT.',/)                       00185500
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00185700
                                                                        00185800
 1250    DIST( TRASE(I) ) = CDIST(I)                                    00185900
 1300 CONTINUE                                                          00186000
C                                                                       00186100
      IF ( RDFLAG ) GO TO 300                                           00186200
C--                                                                     00186300
C---- INTERPOLATE BETWEEN KNOWN DISTANCES....                           00186400
C--   TO POSSIBLE SPLIT SPREAD OR OFF END CONDITIONS...                 00186500
C--   THEN GO CHECK IF THIS FUNCTION IS OK.                             00186600
C--                                                                     00186700
      CALL INTERP ( DIST, 1, NTRACE )                                   00186800
      LRIFLG = .TRUE.                                                   00186900
C--                                                                     00187000
C---- PRINT THEM OUT....                                                00187100
C--                                                                     00187200
      NROWS = ( NTRACE + 9 ) / 10                                       00187300
      IPNT1 = 1                                                         00187400
      IPNT2 = 10                                                        00187500
      WRITE (IPRNTR,1400) LASTRI                                        00187600
 1400 FORMAT (///3X,'TRACE',19X,'**** THE FOLLOWING ARE TRACE ',        00187700
     *               'DISTANCES TO BE USED THROUGH RECORD ',I5,' ****', 00187800
     *          /3X,'-----')                                            00187900
      DO 1600 L = 1,NROWS                                               00188000
         IF ( IPNT2 .GT. NTRACE ) IPNT2 = NTRACE                        00188100
         WRITE (IPRNTR,1500) IPNT1, (DIST(M),M=IPNT1,IPNT2)             00188200
 1500    FORMAT (4X,I4,10F12.1)                                         00188300
         IPNT1 = IPNT1 + 10                                             00188400
         IPNT2 = IPNT2 + 10                                             00188500
 1600 CONTINUE                                                          00188600
      WRITE(IPRNTR,1700)                                                00188700
 1700 FORMAT(///)                                                       00188800
C--                                                                     00188900
C---- CHECK FOR SPLIT SPREAD...                                         00189000
C--                                                                     00189100
      IF ( CONVEN ) GO TO 100                                           00189200
      DO 1800 I = 2,NTRACE                                              00189300
            IF ( DIST( I - 1 ) .LT. DIST(I) ) GO TO 1900                00189400
               DIST( I - 1 ) = -DIST( I - 1 )                           00189500
 1800 CONTINUE                                                          00189600
         DIST( NTRACE ) = -DIST( NTRACE )                               00189700
 1900 GO TO 100                                                         00189800
C--                                                                     00189900
C---- REPORT END OF DATASET....                                         00190000
C--                                                                     00190100
 2000 IF ( .NOT. LRIFLG ) GO TO 2200                                    00190200
      WRITE (IPRNTR,2100)                                               00190300
 2100 FORMAT (//,13X,'** M1204 ** WARNING FROM SUBROUTINE DSTUPD:',     00190400
     *         /,25X,'END OF FILE ENCOUNTERED ON INPUT CARD DATASET.'   00190500
     *         /,25X,'THE LAST SET OF TRACE DISTANCES WILL BE USED',    00190600
     *         /,25X,'TO THE END OF THE DATASET.',/)                    00190700
      LASTRI = 99999                                                    00190800
      RETURN                                                            00190900
 2200 WRITE (IPRNTR,1225)                                               00191000
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT (100)                                                 00191200
      END                                                               00191300
C                                                                       00191400
C                                                                       00191500
      SUBROUTINE CDEPTH ( ISTART, IEND, NTRACE )                        00191600
C***********************************************************************00191700
C                                                                       00191800
C     SUBROUTINE NAME: CDEPTH                                           00191900
C                                                                       00192000
C     LANGUAGE: FORTRAN                                                 00192100
C                                                                       00192200
C     AUTHOR: R. WILSON AND E. ANDES                                    00192300
C                                                                       00192400
C     DATE WRITTEN: 01/13/86                                            00192500
C                                                                       00192600
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00192700
C                              TO BE MAINTAINED IN CONFIDENCE           00192800
C                                                                       00192900
C     ABSTRACT:                                                         00193000
C         SUBROUTINE CDEPTH CHECKS TO SEE IF THE CURRENT SET OF         00193100
C         CABLE DEPTHS ARE VALID.  IF THEY ARE NOT, IT WILL             00193200
C         READ IN ANOTHER SET OF DEPTHS.                                00193300
C                                                                       00193400
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00193500
C                             INITIAL RELEASE.                          00193600
C                                                                       00193700
C     PARAMETERS PASSED:                                                00193800
C         ISTART - STARTING RECORD BOUNDARY                             00193900
C         IEND   - ENDING RECORD BOUNDARY                               00194000
C         NTRACE - NUMBER OF TRACES PER RECORD                          00194100
C                                                                       00194200
C***********************************************************************00194300
C                                                                       00194400
#include <f77/lhdrsz.h>
      REAL    * 4 UNDER(4), DIST(1024), DSTNCE(2,5000),                 00194504
     *            BEGIN(1024), FINISH(1024)                             00194600
C                                                                       00194700
      INTEGER * 4 TNUMB(4), CC1,                                        00194800
     *            BOUNDS(3,5000), IHEAD(12128), ENDRI, luout
C                                                                       00195000
      LOGICAL     FCARD, LDEPTH, FSET, TCHECK                           00195100
      LOGICAL     KRIFLG
C                                                                       00195300
      DATA  ENDRI/-9999/, BLANK/-99999.99/, FSET/.TRUE./
      DATA  TCHECK/.TRUE./, KRIFLG / .FALSE. /
C                                                                       00195600
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00195900
C                                                                       00196000
      LENGTH = NTRACE * SZSMPD                                          00196100
      MRI = 0                                                           00196200
C--                                                                     00196300
C---- FCARD IS TO INDICATE FIRST CABL CARD OF A SET...                  00196400
C---- LDEPTH INDICATES A DEPTH HAS BEEN READ FOR THE LAST TRACE         00196500
C---- OF A RECORD....MOVE ENDING FUNCTION TO BEGINNING IF NEEDED...     00196600
C--                                                                     00196700
      IF ( FSET ) GO TO 100                                             00196800
      CALL MOVE ( 1, BEGIN, FINISH, LENGTH )                            00196900
      ISTART = IEND                                                     00197000
C                                                                       00197100
  100 FCARD  = .FALSE.                                                  00197200
      LDEPTH = .TRUE.                                                   00197300
C--                                                                     00197400
C---- READ A CARD...                                                    00197500
C--                                                                     00197600
  200 READ(IDISKC,300,END=1000) CC1, KARDID, (TNUMB(I),UNDER(I),I=1,4), 00197700
     *                          KRI                                     00197800
  300 FORMAT (I1,A4,4(1X,I4,F10.0),10X,I5)                              00197900
C                                                                       00198000
      IF ( KRI .EQ. 0 ) KRI = 99999                                     00198100
      IF ( TNUMB(1) .NE. 1 .AND. KRI .NE. MRI ) GO TO 1150              00198200
C--                                                                     00198300
C---- CHECK FOR LAST TRACE BEFORE NEW RECORD BEGINS...                  00198400
C--                                                                     00198500
      IF ( MRI .EQ. 0 ) MRI = KRI                                       00198600
C                                                                       00198700
      IF ( KRI .NE. MRI .AND. .NOT. KRIFLG ) GO TO 1150                 00198800
C                                                                       00198900
      IF ( MRI .NE. KRI ) KRIFLG = .FALSE.                              00199000
      IF ( MRI .NE. KRI ) MRI = KRI                                     00199100
C--                                                                     00199200
C---- SET UP CABLE DEPTH BUFFER FOR INTERPOLATION...                    00199300
C--                                                                     00199400
      IF ( FCARD ) GO TO 400                                            00199500
         NBYTES    = LENGTH - SZSMPD                                    00199600
         FINISH(1) = BLANK                                              00199700
         CALL MOVE ( 1, FINISH(2), FINISH(1), NBYTES )                  00199800
C--                                                                     00199900
C---- WAS LAST RECORD BLANK ???                                         00200000
C--                                                                     00200100
  400 IF ( ( FSET )                                                     00200200
     *       .OR. KRI .NE. 0 ) GO TO 600                                00200300
      WRITE (IPRNTR,500)                                                00200400
  500 FORMAT (//,13X,'** M1300 ** ERROR DETECTED BY SUBROUTINE CDEPTH:',00200500
     *         /,25X,'IF MULTIPLE SETS OF NCABL CARDS ARE INPUT TO',    00200600
     *         /,25X,'FACILITATE SPATIAL INTERPOLATION OF CABLE',       00200700
     *         /,25X,'DEPTHS, A BLANK, ZERO, OR 99999 FOR THE RECORD',  00200800
     *         /,25X,'NUMBER, (CC 76-80 NCABL), IS INVALID.  PLEASE',   00200900
     *         /,25X,'VERIFY ALL RECORDS ARE VALID NON-ZERO',           00201000
     *         /,25X,'NUMBERS AND RESUBMIT.',/)                         00201100
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00201300
C--                                                                     00201400
C---- IF THIS IS FIRST CABL CARD, SET SOME STUFF..                      00201500
C--                                                                     00201600
  600 IF ( FCARD ) GO TO 700                                            00201700
           FCARD = .TRUE.                                               00201800
           ENDRI = KRI                                                  00201900
C                                                                       00202000
  700 DO 800 I = 1,4                                                    00202100
         IF ( TNUMB(I) .EQ. NTRACE ) LDEPTH = .FALSE.                   00202200
                                                                        00202300
         IF ( .NOT. LDEPTH .AND. TCHECK ) GO TO 1100                    00202400
            TCHECK = .FALSE.                                            00202500
                                                                        00202600
         IF ( ( TNUMB(I) .LT. 1 )                                       00202700
     *            .OR. ( TNUMB(I) .GT. NTRACE ) ) GO TO 800             00202800
         IF ( TNUMB (I) .NE. TNUMB (I-1) ) GO TO 750                    00202900
            WRITE(IPRNTR,775) TNUMB(I), TNUMB(I-1)                      00203000
  775 FORMAT (//,13X,'** M1350 ** ERROR DETECTED BY SUBROUTINE CDEPTH:',00203100
     *         /,25X,'FOR SPATIAL INTERPOLATION OF CABLE DEPTHS',       00203200
     *         /,25X,'A MINIMUM DISTANCE OF TWO TRACES IS REQUIRED.',   00203300
     *         /,25X,I6,' AND ',I6,' ARE NOT VALID.  CORRECT AND',      00203400
     *         /,25X,'RESUBMIT.',/)                                     00203500
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00203700
  750    FINISH( TNUMB(I) ) = UNDER(I)                                  00203800
  800 CONTINUE                                                          00203900
C                                                                       00204000
      IF ( LDEPTH ) GO TO 200                                           00204100
C--                                                                     00204200
C---- INTERPOLATE BETWEEN KNOWN DEPTHS....                              00204300
C--                                                                     00204400
      CALL INTERP ( FINISH, 1, NTRACE )                                 00204500
      KRIFLG = .TRUE.                                                   00204600
C--                                                                     00204700
C---- NEXT BLOCK OF CODE DONE FIRST AFTER FIRST                         00204800
C---- SET OF NCABL CARDS ONLY...                                        00204900
C--                                                                     00205000
      IF ( .NOT. FSET ) GO TO 900                                       00205100
         CALL MOVE ( 1, BEGIN, FINISH, LENGTH )                         00205200
         FSET = .FALSE.                                                 00205300
         ISTART = ENDRI                                                 00205400
         GO TO 100                                                      00205500
C                                                                       00205600
  900 IEND = ENDRI                                                      00205700
      RETURN                                                            00205800
C                                                                       00205900
 1000 IF ( KRIFLG ) GO TO 1010                                          00206000
         WRITE ( IPRNTR, 1200 )                                         00206100
         CALL LBCLOS ( luin )
         CALL LBCLOS ( luout )
         CALL CCEXIT (0)                                                00206300
c/c      CALL CCEXIT                                                    00206300
C                                                                       00206400
 1010 IEND = 99999                                                      00206500
      RETURN                                                            00206600
 1100    WRITE( IPRNTR, 1200 )  NTRACE                                  00206700
 1150    WRITE( IPRNTR, 1200 )                                          00206800
 1200 FORMAT (//,13X,'** M1325 ** ERROR DETECTED BY SUBROUTINE CDEPTH:',00206900
     *         /,25X,'FOR SPATIAL INTERPOLATION OF CABLE DEPTHS',       00207000
     *         /,25X,'BEGIN WITH THE FIRST TRACE OF THE RECORD',        00207100
     *         /,25X,'AND END WITH THE LAST TRACE OF THE RECORD FOR',   00207200
     *         /,25X,'EACH SET OF CABLE CARDS.  ',I6,' IS NOT A ',      00207300
     *         /,25X,'VALID BEGINNING POINT.  CORRECT PARAMETERS AND',  00207400
     *         /,25X,'RESUBMIT.',/)                                     00207500
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00207700
      END                                                               00207800
C                                                                       00207900
C                                                                       00208000
      SUBROUTINE INTERP ( ARRAY, IFIRST, ILAST )                        00208100
C***********************************************************************00208200
C                                                                       00208300
C     SUBROUTINE NAME: INTERP                                           00208400
C                                                                       00208500
C     LANGUAGE: FORTRAN                                                 00208600
C                                                                       00208700
C     AUTHOR: R. WILSON AND E. ANDES                                    00208800
C                                                                       00208900
C     DATE WRITTEN: 01/13/86                                            00209000
C                                                                       00209100
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00209200
C                              TO BE MAINTAINED IN CONFIDENCE           00209300
C                                                                       00209400
C     ABSTRACT:                                                         00209500
C         SUBROUTINE INTERP WILL INTERPOLATE AN ARRAY GIVEN THE         00209600
C         FIRST AND LAST ELEMENT LOCATIONS.  BLANK ENTRIES ARE          00209700
C         FLAGGED WITH A -99999.99 IN THEM.                             00209800
C                                                                       00209900
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00210000
C                             INITIAL RELEASE.                          00210100
C                                                                       00210200
C     PARAMETERS PASSED:                                                00210300
C         ARRAY  - ARRAY TO BE INTERPOLATED                             00210400
C         IFIRST - STARTING POSITION FOR INTERPOLATION                  00210500
C         ILAST  - ENDING POSITION FOR INTERPOLATION                    00210600
C                                                                       00210700
C***********************************************************************00210800
C                                                                       00210900
      REAL * 4 ARRAY(12000)                                             00211000
C                                                                       00211100
      DATA BLANK/-99999.99/                                             00211200
C--                                                                     00211300
C---- SET STARTING POSITION...                                          00211400
C--                                                                     00211500
      I1 = IFIRST                                                       00211600
  100 I1 = I1 + 1                                                       00211700
      ICOUNT = 0                                                        00211800
C--                                                                     00211900
C---- FIND NUMBER OF BLANKS                                             00212000
C---- BETWEEN VALID ENTRIES...                                          00212100
C--                                                                     00212200
      DO 200 I = I1, ILAST                                              00212300
         IF ( ARRAY(I) .NE. BLANK ) GO TO 300                           00212400
         ICOUNT = ICOUNT + 1                                            00212500
         IF ( I .EQ. ILAST ) RETURN                                     00212600
  200 CONTINUE                                                          00212700
C                                                                       00212800
  300 continue
      IF ( ICOUNT .EQ. 0 ) GO TO 500                                    00212900
c 300 IF ( ICOUNT .EQ. 0 ) GO TO 500                                    00212900
C--                                                                     00213000
C---- DETERMINE INTERPOLATION INCREMENT....                             00213100
C--                                                                     00213200
      SLOPE = ( ARRAY(I) - ARRAY(I1-1) ) / ( ICOUNT + 1 )               00213300
      I2    = I - 1                                                     00213400
C                                                                       00213500
      DO 400 J = I1, I2                                                 00213600
         ARRAY(J) = ARRAY(J-1) + SLOPE                                  00213700
  400 CONTINUE                                                          00213800
C                                                                       00213900
  500 continue
      IF ( I1 .NE. ILAST ) GO TO 100                                    00214000
c 500 IF ( I1 .NE. ILAST ) GO TO 100                                    00214000
      RETURN                                                            00214100
      END                                                               00214200
C                                                                       00214300
C                                                                       00214400
      SUBROUTINE UTILTY ( IREC, KARD, IBUF, MINWD, MAXWD, NTRACE,       00214500
     *                    FSORC, WDEPTH,dist1,dist2,ndstn )
cmam *                    FSORC, WDEPTH )                               00214600
C***********************************************************************00214700
C                                                                       00214800
C     SUBROUTINE NAME: UTILTY                                           00214900
C                                                                       00215000
C     LANGUAGE: FORTRAN                                                 00215100
C                                                                       00215200
C     AUTHOR: R. WILSON AND E. ANDES                                    00215300
C                                                                       00215400
C     DATE WRITTEN: 01/13/86                                            00215500
C                                                                       00215600
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00215700
C                              TO BE MAINTAINED IN CONFIDENCE           00215800
C                                                                       00215900
C     ABSTRACT:                                                         00216000
C         SUBROUTINE UTILTY PERFORMS TASKS NOT ASSOCIATED WITH          00216100
C         THE INDEXING PORTION OF MAIP.  IT WILL INPUT TRACE            00216200
C         DISTANCES AND WATER DEPTHS IF NEEDED.  THIS ROUTINE           00216300
C         IS DESIGNED FOR USE WITH SECONDARY RUNS TO CORRECT            00216400
C         OR CHANGE INFORMATION ON TAPE.                                00216500
C                                                                       00216600
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00216700
C                             INITIAL RELEASE.                          00216800
C                                                                       00216900
C     PARAMETERS PASSED:                                                00217000
C         IREC   - NUMBER OF RECORDS PROCESSED                          00217100
C         KARD   - CARD IMAGE                                           00217200
C         IBUF   - TRACE BUFFER                                         00217300
C         MINWD  - MIN SOURCE POINT/WATER DEPTH PAIR                    00217400
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH PAIR                    00217500
C         NTRACE - NUMBER OF TRACES PER RECORD                          00217600
C         FSORC  - FIRST SOURCE POINT ON LINE FROM LINE HEADER          00217700
C                                                                       00217800
C***********************************************************************00217900
C                                                                       00218000
      REAL    * 4 WDEPTH(12000), DIST(1024), DSTNCE(2,5000),            00218104
     *            BEGIN(1024), FINISH(1024), INCR                       00218204
C                                                                       00218400
      INTEGER * 4 luout, FCDP,  RECORD, BOUNDS(3,5000),
     *            WATVEL, IHEAD(12128)                                  00218600
	character*80 KARD
	character ndstn*255
C                                                                       00218700
      INTEGER * 2 IBUF(12128)                                           00218800
C                                                                       00218900
      LOGICAL     WTRCRD, FELDCD, INDEX, DSTCRD, MOOVUP, CONVEN,        00219000
     *            HISTGR, CBLCRD                                        00219100
C                                                                       00219200
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00219500
     *                HISTGR, CBLCRD                                    00219600
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                00219700
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD        00219800
C--                                                                     00219900
      KRI = -99999                                                      00220000
      LASTRI = 0                                                        00220100
C--                                                                     00220200
C---- READ A TRACE....                                                  00220300
C--                                                                     00220400
  100 LENGTH = 0                                                        00220500
      CALL RTAPE ( luin, IBUF, LENGTH )                                 00220600
      IF ( LENGTH .EQ. 0 ) GO TO 700                                    00220700
C                                                                       00220800
	call saver (ibuf, 'RecNum', krec, 1)
	call saver (ibuf, 'TrcNum', ktrc, 1)
      IF (ktrc .NE. 1) GO TO 150                                        00220900
      IF (krec .NE. LASTRI) GO TO 140                                   00221000
      WRITE (IPRNTR,130) krec                                           00221100
  130 FORMAT(/13X,'** M0302 ** WARNING FROM SUBROUTINE UTILTY:'         00221200
     *      ,/25X,'DUPLICATE RECORD NUMBER ', I6,' FOUND.',             00221300
     *       /25X,'PROCESSING CONTINUES.',/)                            00221400
  140 LASTRI = krec                                                     00221500
  150 CONTINUE                                                          00221600
C--                                                                     00221700
C---- ARE TRACE DISTANCES TO BE INPUT ??                                00221800
C--                                                                     00221900
      IF ( .NOT. DSTCRD ) GO TO 300                                     00222000
C--                                                                     00222100
C---- IF TRACE ONE, SEE IF DISTANCES STILL GOOD....                     00222200
C--                                                                     00222300
            IF ( ktrc      .GT. 1 ) GO TO 200                           00222400
cmam......check for job constant distances
	if(dist1.ne.0.0.or.dist2.ne.0.0) go to 200
            RECORD = krec                                               00222500
            CALL DSTUPD ( RECORD, ndstn, NTRACE)
cmam        CALL DSTUPD ( RECORD, KARD, NTRACE)                         00222600
C--                                                                     00222700
C---- IS TRACE DEAD ??  WE HAVE TO CHECK FOR                            00222800
C---- DEAD TRACE NOW INSTEAD OF BEFORE TO ENSURE                        00222900
C---- WE GET A CURRENT SET OF TRACE DISTANCES                           00223000
C---- IN CASE TRACE 1 IS DEAD....                                       00223100
C--                                                                     00223200
cc200       IF ( IBUF(125) .GE. 30000 ) GO TO 600                       00223300
  200		call saver(ibuf, 'StaCor', kval, 1)
		if(kval .ge. 30000) go to 600
            SDIST     = DIST( ktrc      )                               00223400
            lval      = SDIST + SIGN ( 0.5, SDIST )                     00223500
		call savew(ibuf, 'DstSgn', lval, 1)
		if(lval .lt. 0) lval = -lval
		call savew(ibuf, 'DstUsg', lval, 1)
ccc         IBUF(117) = IBUF(119)                                       00223600
ccc         IF ( IBUF(119) .LT. 0 )                                     00223700
ccc  *                     IBUF(117) = -IBUF(117)                       00223800
C--                                                                     00223900
C---- ARE WE ASSIGNING WATER DEPTHS ???                                 00224000
C--                                                                     00224100
  300 call saver(ibuf, 'StaCor', mval, 1)
      IF ( ( .NOT. WTRCRD )                                             00224200
     *           .OR. mval      .GE. 30000 ) GO TO 600                  00224300
C                                                                       00224400
      IREEL = 0                                                         00224500
C--                                                                     00224600
C---- HOW MANY CDP'S ARE WE FROM THE                                    00224700
C---- FIRST LABELED SOURCE POINT ???                                    00224800
C--                                                                     00224900
ccc   LOCAT  = IBUF(122)                                                00225000
	call saver(ibuf, 'DphInd', LOCAT, 1)
      IMANY  = LOCAT - FCDP                                             00225100
C--                                                                     00225200
C---- IF WE ARE BEFORE FIRST SOURCE, LEAVE...                           00225300
C--                                                                     00225400
      IF ( IMANY .GE. 0  ) GO TO 400                                    00225500
C                                                                       00225600
      IREEL = FSORC                                                     00225700
      IF (IREEL .LT. MINWD) IREEL = MINWD                               00225800
      IF (IREEL .GT. MAXWD) IREEL = MAXWD                               00225900
      REEL  = IREEL                                                     00226000
      GO TO 500                                                         00226100
C--                                                                     00226200
C---- IF NOT, FIGURE WHAT SOURCE                                        00226300
C---- POINT WE'RE ON NOW....                                            00226400
C--                                                                     00226500
  400 REEL  = FLOAT( IMANY ) / ( INCR / 100. ) + FSORC                  00226600
      IREEL = REEL                                                      00226700
C--                                                                     00226800
C---- ARE WE OUT OF BOUNDS ???                                          00226900
C--                                                                     00227000
      IF ( IREEL .LE. MAXWD ) GO TO 450                                 00227100
C                                                                       00227200
      IREEL = MAXWD                                                     00227300
      REEL  = IREEL                                                     00227400
      GO TO 500                                                         00227500
C                                                                       00227600
  450 IF ( IREEL .GE. MINWD ) GO TO 500                                 00227700
C                                                                       00227800
      IREEL = MINWD                                                     00227900
      REEL  = IREEL                                                     00228000
C--                                                                     00228100
C---- SEE IF WE'RE BETWEEN TWO GIVEN WATER DEPTHS....                   00228200
C--                                                                     00228300
  500 DIFFER = REEL - IREEL                                             00228400
      IF ( INCR .LT. 0.                                                 00228500
     *          .AND. DIFFER .NE. 0. ) IREEL = IREEL + 1                00228600
      IPNT1  = IREEL - ( MINWD - 1 )                                    00228700
      DEPTH1 = WDEPTH( IPNT1 )                                          00228800
      IF ( INCR .GT. 0.                                                 00228900
     *          .AND. ( DIFFER .EQ. 0.                                  00229000
     *                .OR. (IREEL + 1) .GT. MAXWD ) )                   00229100
     *                       IREEL = IREEL - 1                          00229200
      IF ( INCR .LT. 0.                                                 00229300
     *          .AND. ( DIFFER .EQ. 0.                                  00229400
     *                .OR. (IREEL - 1) .LT. MINWD ) )                   00229500
     *                       IREEL = IREEL + 1                          00229600
      IPNT2  = IREEL - ( MINWD - 1 )                                    00229700
      IPNT2  = IPNT2 + SIGN ( 1., INCR )                                00229800
      DEPTH2 = WDEPTH( IPNT2 )                                          00229900
C--                                                                     00230000
C---- FIGURE DIFFERENCE BETWEEN TWO DEPTHS....                          00230100
C--                                                                     00230200
      WDIFF  = DEPTH2 - DEPTH1                                          00230300
C--                                                                     00230400
C---- MULTIPLY THIS DIFFERENCE BY                                       00230500
C---- THE FRACTIONAL AMOUNT BETWEEN THE TWO SOURCES....                 00230600
C--                                                                     00230700
      XDIFF = DIFFER                                                    00230800
      IF ( INCR .LT. 0. ) XDIFF = 1. - DIFFER                           00230900
      ISLOPE = ( WDIFF * XDIFF ) + SIGN ( 0.5, WDIFF )                  00231000
C--                                                                     00231100
C---- ADD THIS AMOUNT TO PREVIOUS DEPTH...                              00231200
C--                                                                     00231300
      IBUF(97) = DEPTH1 + ISLOPE                                        00231400
C                                                                       00231500
  600 CALL WRTAPE ( luout, IBUF, LENGTH )
      IF ( KRI .EQ. krec      ) GO TO 100                               00231700
      KRI = krec                                                        00231800
      CALL RIPRNT ( KRI, IPRNTR )                                       00231900
      IREC = IREC + 1                                                   00232000
      GO TO 100                                                         00232100
C                                                                       00232200
  700 CALL RICLR ( IPRNTR )                                             00232300
      RETURN                                                            00232400
      END                                                               00232500
C                                                                       00232600
C                                                                       00232700
      SUBROUTINE ERRCHK ( IBUF, IHEAD,dist1,dist2)
cmam  SUBROUTINE ERRCHK ( IBUF, IHEAD, MAIP1 )                          00243700
C***********************************************************************00243800
C                                                                       00243900
C     SUBROUTINE NAME: ERRCHK                                           00244000
C                                                                       00244100
C     LANGUAGE: FORTRAN                                                 00244200
C                                                                       00244300
C     AUTHOR: E. ANDES                                                  00244400
C                                                                       00244500
C     DATE WRITTEN: 01/13/86                                            00244600
C                                                                       00244700
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00244800
C                              TO BE MAINTAINED IN CONFIDENCE           00244900
C                                                                       00245000
C     ABSTRACT:                                                         00245100
C         SUBROUTINE ERRCHK PERFORMS ERROR CHECKING ON INPUT DATA       00245200
C         SET.                                                          00245300
C                                                                       00245400
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00245500
C                             INITIAL RELEASE.                          00245600
C                                                                       00245700
C     PARAMETERS PASSED:                                                00245800
C         IBUF   - LINE HEADER (I*2)                                    00245900
C         IHEAD  - LINE HEADER (I*4)                                    00246000
C         MAIP1  - FLAG SET WHEN 1MAIP CARD IS READ                     00246100
C                                                                       00246200
C***********************************************************************00246300
C                                                                       00246400
      REAL    * 8 TJOBID                                                00246500
C                                                                       00246600
      REAL    * 4 JCSTAT                                                00246700
C                                                                       00246800
      INTEGER * 4 IHEAD(12128), SPNUM1, SPINC, RIPSRC, luout
C                                                                       00247000
      INTEGER * 2 IBUF(12128)                                           00247100
C                                                                       00247200
      LOGICAL     INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,        00247300
     *            HISTGR, CBLCRD, MAIP1                                 00247400
C                                                                       00247500
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00247800
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00247900
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00248000
     *                HISTGR, CBLCRD                                    00248100
	integer IBUF33, IHEAD16, IHEAD13
	call saver(IBUF, 'Format', IBUF33, 0)
	call saver(IBUF, 'NumSmp', IHEAD16, 0)
	call saver(IBUF, 'NumTrc', IHEAD13, 0)
C                                                                       00248200
      IF ( IBUF33 .EQ. 1                                                00248300
     *              .OR. IBUF33 .EQ. 3 ) GO TO 200                      00248400
C                                                                       00248500
      WRITE(IPRNTR,100)                                                 00248600
  100 FORMAT (/,13X,'** M1700 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00248700
     *        /,25X,'THE FORMAT CODE READ FROM THE INPUT DATA SET',     00248800
     *        /,25X,'LINE HEADER IS NOT A 1 OR A 3.  VERIFY THAT',      00248900
     *        /,25X,'THE INPUT DATA SET HAS THE CORRECT FORMAT CODE',   00249000
     *        /,25X,'AND RESUBMIT.',/)                                  00249100
      GO TO 1700                                                        00249200
C                                                                       00249300
  200 IF ( ( IBUF33 .EQ. 1 .AND. IHEAD16 .LE. 12000)                    00249400
     *           .OR. ( IBUF33 .EQ. 3 .AND. IHEAD16 .LE. 6000 ) )       00249500
     *                GO TO 600                                         00249600
C                                                                       00249700
      WRITE(IPRNTR,300)                                                 00249800
  300 FORMAT (/,13X,'** M1701 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00249900
     *        /,25X,'THE NUMBER OF SAMPLES PER TRACE AS FILED IN',      00250000
     *        /,25X,'THE INPUT DATA SET LINE HEADER EXCEEDS THE ',      00250100
     *        /,25X,'PROGRAM LIMIT.  PROGRAM MAIP ACCEPTS A MAXIMUM',   00250200
     *        /,25X,'OF 6000 SAMPLES IF FORMAT 3, AND ACCEPTS A ',      00250300
     *        /,25X,'MAXIMUM OF 12000 SAMPLES IF FORMAT 1.',/)          00250400
      GO TO 1700                                                        00250500
C                                                                       00250600
C                                                                       00251400
  600 IF ( ( .NOT. INDEX )                                              00251500
     *          .OR. GIINT .GT. 0 ) GO TO 800                           00251600
C                                                                       00251700
      WRITE(IPRNTR,700)                                                 00251800
  700 FORMAT (/,13X,'** M1703 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00251900
     *        /,25X,'PROGRAM MAIP WAS REQUESTED TO PERFORM INDEXING,',  00252000
     *        /,25X,'BUT THE GROUP INTERVAL (CC 11-20 2MAIP) WAS',      00252100
     *        /,25X,'NOT PROVIDED AND A SUITABLE DEFAULT COULD NOT',    00252200
     *        /,25X,'BE DETERMINED.  VERIFY INPUT AND RESUBMIT.',/)     00252300
      GO TO 1700                                                        00252400
C                                                                       00252500
  800 IF ( ( .NOT. INDEX )                                              00252600
     *          .OR. SRCINT .GT. 0 ) GO TO 1000                         00252700
C                                                                       00252800
      WRITE(IPRNTR,900)                                                 00252900
  900 FORMAT (/,13X,'** M1704 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00253000
     *        /,25X,'PROGRAM MAIP WAS REQUESTED TO PERFORM INDEXING,',  00253100
     *        /,25X,'BUT THE SOURCE INTERVAL (CC 21-30 1MAIP) WAS',     00253200
     *        /,25X,'NOT PROVIDED AND A SUITABLE DEFAULT COULD NOT',    00253300
     *        /,25X,'BE DETERMINED.  VERIFY INPUT AND RESUBMIT.',/)     00253400
      GO TO 1700                                                        00253500
C                                                                       00253600
 1000 IF ( ( .NOT. INDEX )                                              00253700
     *          .OR. ( DSTCRD ) ) GO TO 1200                            00253800
C                                                                       00253900
	if(dist1.ne.0.0.or.dist2.ne.0.0) go to 1200
      WRITE(IPRNTR,1100)                                                00254000
 1100 FORMAT (/,13X,'** M1705 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00254100
     *        /,25X,'PROGRAM MAIP WAS REQUESTED TO PERFORM INDEXING',   00254200
     *        /,25X,'(CC 7 1MAIP), BUT TRACE DISTANCES WERE NOT',       00254300
     *        /,25X,'SUPPLIED ON NDSTN CARDS.  FOR INDEXING TO BE',     00254400
     *        /,25X,'PERFORMED, TRACE DISTANCES MUST BE SUPPLIED.',     00254500
     *        /,25X,'VERIFY CARD INPUT AND RESUBMIT.',/)                00254600
      GO TO 1700                                                        00254700
C                                                                       00254800
 1200 IF ( ( .NOT. INDEX )                                              00254900
     *          .OR. ( RECINT .NE. 0. ) ) GO TO 1400                    00255000
C                                                                       00255100
      WRITE(IPRNTR,1300)                                                00255200
 1300 FORMAT (/,13X,'** M1706 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00255300
     *        /,25X,'IF INDEXING IS REQUESTED (CC 7 1MAIP), THE',       00255400
     *        /,25X,'GROUP (RECEIVER) SPACING MUST BE INPUT.',          00255500
     *        /,25X,'VERIFY CARD INPUT AND RESUBMIT.',/)                00255600
      GO TO 1700                                                        00255700
C                                                                       00255800
 1400 IF ( IHEAD13 .LE. 1024 ) GO TO 1600                               00255900
C                                                                       00256000
      WRITE(IPRNTR,1500)                                                00256100
 1500 FORMAT (/,13X,'** M1707 ** ERROR DETECTED BY SUBROUTINE ERRCHK:', 00256200
     *        /,25X,'THE NUMBER OF TRACES PER RECORD AS FILED IN',      00256300
     *        /,25X,'THE INPUT DATA SET LINE HEADER EXCEEDS THE ',      00256400
     *        /,25X,'PROGRAM LIMIT.  PROGRAM MAIP ACCEPTS A MAXIMUM',   00256500
     *        /,25X,'OF 1024 TRACES PER RECORD.',/)                     00256600
      GO TO 1700                                                        00256700
C                                                                       00256800
 1600 RETURN                                                            00256900
C                                                                       00257000
 1700 CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00257200
      RETURN                                                            00257300
      END                                                               00257400
C                                                                       00257500
C                                                                       00257600
      SUBROUTINE DSPLAY ( WDEPTH, MINWD, MAXWD )                        00257700
C***********************************************************************00257800
C                                                                       00257900
C     SUBROUTINE NAME: DSPLAY                                           00258000
C                                                                       00258100
C     LANGUAGE: FORTRAN                                                 00258200
C                                                                       00258300
C     AUTHOR: E. ANDES                                                  00258400
C                                                                       00258500
C     DATE WRITTEN: 01/13/86                                            00258600
C                                                                       00258700
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00258800
C                              TO BE MAINTAINED IN CONFIDENCE           00258900
C                                                                       00259000
C     ABSTRACT:                                                         00259100
C         SUBROUTINE DSPLAY DISPLAYS INFORMATION ABOUT WATER DEPTHS     00259200
C         TO BE USED IN JOB.                                            00259300
C                                                                       00259400
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00259500
C                             INITIAL RELEASE.                          00259600
C                                                                       00259700
C     PARAMETERS PASSED:                                                00259800
C         WDEPTH - WATER DEPTH ARRAY                                    00259900
C         MINWD  - MIN SOURCE POINT/WATER DEPTH ARRAY                   00260000
C         MAXWD  - MAX SOURCE POINT/WATER DEPTH ARRAY                   00260100
C                                                                       00260200
C***********************************************************************00260300
C                                                                       00260400
      REAL    * 4 WDEPTH(12000)                                         00260500
	real*8 TJOBID
	real*4 DIST(1024),DSTNCE(2,5000),BEGIN(1024),FINISH(1024)
	integer*4 IHEAD(12128),BOUNDS(3,5000)
	logical INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,
     *		HISTGR, CBLCRD
C                                                                       00260600
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00007000
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00007100
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00007200
     *                HISTGR, CBLCRD                                    00007300
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                00007400
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD
C                                                                       00260800
      IQUIT = MAXWD - ( MINWD - 1 )                                     00260900
      CALL INTERP ( WDEPTH, 1, IQUIT )                                  00261000
C                                                                       00261100
      WRITE(IPRNTR,100)                                                 00261200
  100 FORMAT(///2X,'SOURCE',28X,'**** THE FOLLOWING ARE SOURCE ',       00261300
     *              'POINT ORIENTED WATER DEPTHS ****',                 00261400
     *         /2X,'------')                                            00261500
C                                                                       00261600
      NROWS = ( ( MAXWD - MINWD ) + 10 ) / 10                           00261700
      IPNT1 = MINWD                                                     00261800
      I1    = 1                                                         00261900
      I2    = 10                                                        00262000
C                                                                       00262100
      DO 300 I = 1,NROWS                                                00262200
         IF ( I2 .GT. ( MAXWD - ( MINWD - 1 ) ) )                       00262300
     *            I2 = MAXWD - ( MINWD - 1 )                            00262400
         WRITE(IPRNTR,200) IPNT1, ( WDEPTH(M),M=I1,I2)                  00262500
  200    FORMAT(3X,I5,10F12.1)                                          00262600
         IPNT1 = IPNT1 + 10                                             00262700
         I1    = I1 + 10                                                00262800
         I2    = I2 + 10                                                00262900
  300 CONTINUE                                                          00263000
C                                                                       00263100
      WRITE(IPRNTR,400)                                                 00263200
  400 FORMAT(///)                                                       00263300
      RETURN                                                            00263400
      END                                                               00263500
C                                                                       00263600
C                                                                       00263700
      SUBROUTINE WRTOUT ( RECORD, ILABEL, IWHERE, IBOTOM )              00263800
C***********************************************************************00263900
C                                                                       00264000
C     SUBROUTINE NAME: WRTOUT                                           00264100
C                                                                       00264200
C     LANGUAGE: FORTRAN                                                 00264300
C                                                                       00264400
C     AUTHOR: E. ANDES                                                  00264500
C                                                                       00264600
C     DATE WRITTEN: 09/12/85                                            00264700
C                                                                       00264800
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00264900
C                              TO BE MAINTAINED IN CONFIDENCE           00265000
C                                                                       00265100
C     ABSTRACT:                                                         00265200
C         SUBROUTINE WRTOUT DISPLAYS INFORMATION FOR EACH OUTPUT        00265300
C         RECORD.                                                       00265400
C                                                                       00265500
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00265600
C                             INITIAL RELEASE.                          00265700
C                                                                       00265800
C     PARAMETERS PASSED:                                                00265900
C         RECORD - RECORD JUST PROCESSED                                00266000
C         ILABEL - LAST LABELED SOURCE POINT FOR RECORD                 00266100
C         IWHERE - CDP BELOW LAST SOURCE POINT                          00266200
C         IBOTOM - WATER DEPTH FOR SOURCE POINT                         00266300
C                                                                       00266400
C***********************************************************************00266500
C                                                                       00266600
      INTEGER * 4 RECORD, OLDLBL                                        00266700
	real*8 TJOBID
	real*4 DIST(1024),DSTNCE(2,5000),BEGIN(1024),FINISH(1024)
	integer*4 IHEAD(12128),BOUNDS(3,5000)
	logical INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,
     *		HISTGR, CBLCRD
C                                                                       00266800
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/  luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00007000
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00007100
      COMMON /REFER/  INDEX, WTRCRD, FELDCD, DSTCRD, MOOVUP, CONVEN,    00007200
     *                HISTGR, CBLCRD                                    00007300
      COMMON /DEPTH/  FCDP, INCR, WATVEL                                00007400
      COMMON /ARRAYS/ DIST, BOUNDS, DSTNCE, BEGIN, FINISH, IHEAD
C                                                                       00267000
      DATA OLDLBL/-9999/                                                00267100
C                                                                       00267200
      IF ( ( ILABEL .NE. OLDLBL )                                       00267300
     *              .AND. ( ILABEL .NE. 0 )                             00267400
     *                    .AND. ( IBOTOM .NE. -99999 ) )                00267500
     *                      WRITE(IPRNTR,100) RECORD, ILABEL, IWHERE,   00267600
     *                                        IBOTOM                    00267700
  100 FORMAT (20X,'RECORD ',I5,' HAS BEEN PROCESSED.  SOURCE ',         00267800
     *            'POINT ',I5,' IS ABOVE CDP ',I5,' IN ',I5,' UNITS ',  00267900
     *            'OF WATER.')                                          00268000
C                                                                       00268100
      IF ( ( ILABEL .NE. OLDLBL )                                       00268200
     *              .AND. ( ILABEL .NE. 0 )                             00268300
     *                    .AND. ( IBOTOM .EQ. -99999 ) )                00268400
     *                      WRITE(IPRNTR,200) RECORD, ILABEL, IWHERE    00268500
  200 FORMAT (20X,'RECORD ',I5,' HAS BEEN PROCESSED.  SOURCE ',         00268600
     *            'POINT ',I5,' IS ABOVE CDP ',I5,'.')                  00268700
C                                                                       00268800
      IF ( ( ILABEL .EQ. OLDLBL )                                       00268900
     *              .OR. ( ILABEL .EQ. 0 ) )                            00269000
     *                     WRITE(IPRNTR,300) RECORD                     00269100
  300 FORMAT (20X,'RECORD ',I5,' HAS BEEN PROCESSED.')                  00269200
C                                                                       00269300
C---- SAVE SOURCE LABEL TO CHECK AGAINST                                00269400
C---- NEXT LABEL.  IF THEY MATCH, DON'T                                 00269500
C---- PRINT OUT SAME INFORMATION AGAIN.                                 00269600
      OLDLBL = ILABEL                                                   00269700
C                                                                       00269800
      RETURN                                                            00269900
      END                                                               00270000
C----------------------------------------------------------------------C00270103
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C00271003
C----------------------------------------------------------------------C00280003
C-- DEFLDH - DELETE FIELD HISTORY INFORMATION FROM SEISMIC LINE      --C00290003
C--          HEADER.                                                 --C00300003
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C00310003
C----------------------------------------------------------------------C00320003
      SUBROUTINE DEFLDH ( IHEAD , HDRLEN, HEADER )                      00330003
ccc   SUBROUTINE DEFLDH ( HEADER, HDRLEN )                              00330003
      IMPLICIT   INTEGER*4 (A-Z)                                        00340003
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	integer IHEAD(*)
      character*1  HEADER(*), HEX5A
      INTEGER  WORKSP(2), TOTAL, COUNT
#ifndef CRAYSYSTEM
	integer*2 length
#else
	integer length
#endif
ccc   INTEGER  WORKSP(2), LENGTH, TOTAL, COUNT
ccc   EQUIVALENCE (WORKSP(1),COUNT),                                    00370003
ccc  $            (WORKSP(2),TOTAL)                                     00380003
cc    DATA FLDHIS / 1001 /,                                             00390003
cc   $     POINT  / 1005 /,                                             00400003
cc   $     INFO   / 1007 /,                                             00410003
cc   $     HEX5A  /  Z5A /                                              00420003
cc    DATA FLDHIS / HLHOFF + 1 /,
cc   $     POINT  / HSTOFF + 1 /,
cc   $     INFO   / POINT + HLHINT /,
cc   $     HEX5A  /  Z5A /
	DATA HEX5A / '!' /

	FLDHIS = HLHOFF + 1
	POINT = HSTOFF + 1
	INFO = POINT + HLHINT
C--                                                                     00430003
C--------------------------------------------------------------         00440003
C-- MOVE HISTORICAL HEADER ENTRY COUNTER AND LENGTH INTO WORKSPACE      00450003
C--                                                                     00460003
ccc      CALL MOVE ( 1, WORKSP, HEADER(FLDHIS),2*HLHINT)                00470003
	call saver(IHEAD , 'HlhEnt', COUNT, 0)
	call saver(IHEAD , 'HlhByt', TOTAL, 0)
C--                                                                     00480003
C--------------------------------------------------------------         00490003
C-- CHECK BOUNDARY CONDITION (NO HISTORICAL INFO...)                    00500003
C--                                                                     00510003
   10 IF (COUNT.LE.0) GOTO 20                                           00520003
C--                                                                     00530003
C--------------------------------------------------------------         00540003
C-- OBTAIN LENGTH OF THIS ENTRY AND ADDRESS OF NEXT ENTRY               00550003
C--                                                                     00560003
         CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)                  00570003
#ifndef CRAYSYSTEM
         NEXT = INFO + LENGTH                                           00580003
#else
	LENGTH = (INT((LENGTH + 7) / 8) * 8)
	NEXT = INFO + LENGTH
#endif
C--                                                                     00590003
C--------------------------------------------------------------         00600003
C-- IF THIS ENTRY IS FLAGGED AS HISTORICAL, THEN DELETE THE ENTRY       00610003
C--    ALSO UPDATE OVERALL LENGTH OF LINE HEADER                        00620003
C--                                                                     00630003
         IF (HEADER(INFO).NE.HEX5A) GOTO 20                             00640003
            LENGTH = LENGTH + HLHINT                                    00650003
            TOTAL = TOTAL - LENGTH                                      00660003
            COUNT = COUNT - 1                                           00670003
            HDRLEN = HDRLEN - LENGTH                                    00680003
            LEN4 = TOTAL                                                00690003
            CALL MOVE ( 4, HEADER(POINT), HEADER(NEXT), LEN4 )          00700003
ccc	call move(1, holdit(1), HEADER(NEXT), LEN4)
ccc	call move (1, HEADER(POINT), holdit(1), LEN4)
            GOTO 10                                                     00710003
C--                                                                     00720003
C--------------------------------------------------------------         00730003
C-- UPDATE HEADER...                                                    00740003
C--                                                                     00750003
ccc20 CALL MOVE ( 1, HEADER(FLDHIS), WORKSP, 2*HLHINT)                  00760003
   20 call savew(IHEAD , 'HlhEnt', COUNT, 0)
      call savew(IHEAD , 'HlhByt', TOTAL, 0)

      RETURN                                                            00770003
      END                                                               00780003
C----------------------------------------------------------------------C00790003
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C00800003
C----------------------------------------------------------------------C00810003
C-- INFLDH - INSERT FIELD HISTORY INFORMATION INTO SEISMIC LINE      --C00820003
C--          HEADER.                                                 --C00830003
C----------------------------------------------------------------------C00840003
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C00850003
C----------------------------------------------------------------------C00860003
C-- CATALOGUED AND TESTED - 10/25/82 9:00 AM                         --C00870003
C----------------------------------------------------------------------C00880003
C-- ABSTRACT - INSERT ONE (1) LINE OF FIELD HISTORY INFORMATION INTO --C00890003
C--            A SEISMIC LINE HEADER.  ENTRY IS PLACED AT END OF     --C00900003
C--            "FIELD" INFORMATION IMMEDIATELY BEFORE "PROCESSING"   --C00910003
C--            INFORMATION.  LENGTH OF OVERALL HEADER IS ALSO RESET. --C00920003
C----------------------------------------------------------------------C00930003
      SUBROUTINE INFLDH ( IHEAD , HDRLEN, FLD, FLDLEN, HEADER )         00940003
      IMPLICIT   INTEGER*4 (A-Z)                                        00950003
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	integer IHEAD(*)
      character*1  HEADER(*), HEX5A, FLD(*)
	character*1 check(8)
	integer*2 newln
	integer kount,ktot
	integer*2 lengx
#ifndef CRAYSYSTEM
      INTEGER*2 WORKSP(2),LENGTH,TOTAL,COUNT
#else
      INTEGER WORKSP(2),LENGTH,TOTAL,COUNT
#endif
      EQUIVALENCE (WORKSP(1),COUNT),                                    00980003
     $            (WORKSP(2),TOTAL)                                     00990003
	DATA HEX5A / '!' /
	FLDHIS = HLHOFF + 1
	START = HSTOFF + 1
	iNFO = START + HLHINT
C--                                                                     01040003
C--------------------------------------------------------------         01050003
C-- MOVE ITEM COUNT AND LENGTH INTO WORKSPACE                           01060003
C--                                                                     01070003
	call saver(IHEAD , 'HlhEnt', KOUNT, 0)
	call saver(IHEAD , 'HlhByt', KTOT, 0)
	count = kount
	total = ktot

C--                                                                     01090003
C--------------------------------------------------------------         01100003
C-- INITIALIZE POINTERS...                                              01110003
C--                                                                     01120003
      POINT = START                                                     01130003
      ENTRY = INFO                                                      01140003
C--                                                                     01150003
C--------------------------------------------------------------         01160003
C-- IF THE HISTORY IS EMPTY, THEN DON'T BOTHER WITH A SEARCH            01170003
C--                                                                     01180003
      IF (COUNT.LE.0) GOTO 20                                           01190003
C--                                                                     01200003
C--------------------------------------------------------------         01210003
C--     GET NEXT ITEM LENGTH...                                         01220003
C--                                                                     01230003
   10    CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)                  01240003
#ifdef CRAYSYSTEM
	LENGTH = (INT((LENGTH + 7) / 8) * 8)
#endif
C--                                                                     01250003
C--------------------------------------------------------------         01260003
C-- IF THIS ENTRY IS A FIELD HISTORY ENTRY, THEN WE SKIP BY IT.         01270003
C--    AND POINT TO THE NEXT ITEM                                       01280003
C--                                                                     01290003
         IF (HEADER(ENTRY).NE.HEX5A) GOTO 20                            01300003
            POINT = ENTRY + LENGTH                                      01310003
            ENTRY = POINT + HLHINT                                      01320003
            GOTO 10                                                     01330003
C--                                                                     01340003
C--------------------------------------------------------------         01350003
C-- COMPUTE LENGTH OF REMAINING HEADER INFO AND TARGET ADDRESS          01360003
C--     THEN MOVE THE HEADER ON DOWN INTO POSTION TO MAKE ROOM          01370003
C--     FOR THE NEW HISTORY ENTRY.                                      01380003
C-- (PROVIDED THERE ACTUALLY IS SOMETHING TO BE MOVED)                  01390003
C--                                                                     01400003
   20 continue
	leng1 = FLDLEN + 1
#ifdef CRAYSYSTEM
	leng1 = (INT((leng1 + 7) / 8) * 8)
#endif
      MOVLEN = START + TOTAL - POINT                                    01410003
      NEWLOC = POINT + leng1 + HLHINT                                   01420003
ccc   NEWLOC = POINT + FLDLEN + HLHINT + 1                              01420003
      IF (MOVLEN.GT.0) then                                             01430003
      	call move(4,HEADER(NEWLOC),HEADER(POINT),MOVLEN)
cc	call move (1,HOLDIT(1), HEADER(POINT), MOVLEN)
cc	call move (1,HEADER(NEWLOC),HOLDIT(1),MOVLEN)
	endif
C--                                                                     01450003
C--------------------------------------------------------------         01460003
C-- FLAG THIS ENTRY AS HISTORY                                          01470003
C--                                                                     01480003
      HEADER(ENTRY) = HEX5A                                             01490003
C--                                                                     01500003
C--------------------------------------------------------------         01510003
C-- MOVE THE ENTRY INTO POSITION (WE DON'T CARE HOW LONG IT IS)         01520003
C--                                                                     01530003
      ENTRY = ENTRY + 1                                                 01540003
      CALL MOVE ( 1, HEADER(ENTRY), FLD, FLDLEN )                       01550003
C--                                                                     01560003
C--------------------------------------------------------------         01570003
C-- SET THE LENGTH OF THE ENTRY...                                      01580003
C--                                                                     01590003
       LENGTH = FLDLEN + 1                                              01600003
      CALL MOVE ( 1, HEADER(POINT), LENGTH, HLHINT)                     01610003
C--                                                                     01620003
C--------------------------------------------------------------         01630003
C-- UPDATE ENTRY COUNT AND TOTAL BYTE LENGTH OF HISTORY HEADER          01640003
C--    THEN GO HOME                                                     01650003
C--                                                                     01660003
      COUNT = COUNT + 1                                                 01670003
      TOTAL = TOTAL + leng1  + HLHINT                                   01680003
      HDRLEN = HDRLEN + leng1  + HLHINT                                 01690003
	kount = count
	ktot = total
	call savew(IHEAD , 'HlhEnt', KOUNT, 0)
   	call savew(IHEAD , 'HlhByt', KTOT, 0)
ccc	call savew(IHEAD , 'HlhEnt', COUNT, 0)
ccc	call savew(IHEAD , 'HlhByt', TOTAL, 0)

      RETURN                                                            01710003
      END                                                               01720003
C----------------------------------------------------------------------C01730003
C--     AMOCO PRODUCTION COMPANY - SEISMIC TRACE PROCESSING GROUP    --C01740003
C--                  FOR USE WITH 'FLDHIS' ROUTINES...               --C01750003
C----------------------------------------------------------------------C01760003
C-- CHARACTER STRING LENGTH FUNCTION - RETURN NUMBER OF CHARACTERS   --C01770003
C-- IN AN ARRAY, ZERO IF ARRAY IS ALL BLANK, ROUTINE ACTS AS A       --C01780003
C-- 'TRIMMING' FUNCTION FOR CHARACTER STRING DATA                    --C01790003
C----------------------------------------------------------------------C01800003
C-- RUSSELL L. WILSON --- 09/05/83 --- 963 SOUTH TDC --- EXT.3783    --C01810003
C----------------------------------------------------------------------C01820003
      INTEGER FUNCTION  LENG2 (STRING,MAXLEN)
      character*1 BLANK,  STRING (*)
      INTEGER*4   MAXLEN
      DATA        BLANK   /' '/

      LENG2 = MAXLEN + 1
   10 LENG2 = LENG2 - 1
         IF (LENG2.LT.1) RETURN
         IF (STRING(LENG2).EQ.BLANK)  GOTO 10
      RETURN
      END


      subroutine getsp (biasflg, spmul, fstsp, ifsorc)

      integer       biasflg, spmul, fstsp, ifsorc

      if (biasflg .eq. 0) then
         ifsorc = fstsp
      else
         ifsorc = fstsp - spmul * 10000
      endif

      return
      end

      subroutine sbias (biasflg, spmul, fstsp, spnum)

      integer       biasflg, spmul, fstsp, spnum

      if (biasflg .eq. 0) then
         spnum = fstsp
      else
         spnum = fstsp + spmul * 10000
      endif

      return
      end

      subroutine spbias (biasflg, itr, dibsp, srcnum)

      integer * 2  itr(*)
      integer      dibsp, srcnum
	integer*2 biasflg
cmam  integer      biasflg, dibsp, srcnum

ccccccc   call savew (itr, 'SrcLoc', srcnum, 1)    cccccccc
      call savew (itr, 'SrcPnt', dibsp , 1)
      call savew (itr, 'SoPtNm', srcnum, 1)

      return
      end
ccccccccccccccccccccccccccccc
      subroutine help1
#include <f77/iounit.h>

          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM maip................Marine Line Indexing'
         write(LER,*)' '
         write(LER,*)
     :' -N [ntap]  (default=stdin pipe)  : Input USP data file name'
         write(LER,*)
     :' -O [otap]  (default=stdout pipe) : Output USP data file name'
	 write(LER,*)
     :' ...The following 6 flags are to override defaults:'
	 write(LER,*)
     :' -mode      : sign convention=positive tr.dist. ahead of shot'
	 write(LER,*)
     :'              (default=postive tr.dist. behind shot)'
	 write(LER,*)
     :' -noindx    : do not index the dataset (default=index dataset)'
	 write(LER,*)
     :' -metric    : Metric units  (default=English units)'
	 write(LER,*)
     :' -pltrev    : reverse plot direction (left to right)'
	 write(LER,*)
     :'              (default=normal=right to left)'
	 write(LER,*)
     :' -nohist    : do not display histograms (default = display)'
	 write(LER,*)
     :' -ibtwn     : sources are between groups'
	 write(LER,*)
     :'              (default=sources are on groups)'
	 write(LER,*)
     :' ...The following are input parameters'
	 write(LER,*)
     :' -recint [recint] : group (receiver) spacing (ft or m)'
	 write(LER,*)
     :' -srcint [srcint] : normal source moveup (ft or m)'
	 write(LER,*)
     :' -sp1 [spnum1]    : first record source ID (default=1)'
	 write(LER,*)
     :' -spinc [spinc]   : source point increment/decrement(default=1)'
	 write(LER,*)
     :' -labinc [ripsrc] : record labeling increment (default=1)'
	 write(LER,*)
     :' -fold [ifold]    : fold'
	 write(LER,*)
     :' -giint [giint]   : group indexing interval (ft or m)'
	 write(LER,*)
     :' -diint [diint]   : depth point indexing interval (ft or m)'
	 write(LER,*)
     :' -laboff (offset] : source labeling offset (ft or m)'
	 write(LER,*)
     :'                    (default=label is at the source)'
	 write(LER,*)
     :' -jcstat [jcstat] : job constant static'
	 write(LER,*)
     :' -watvel [watvel] : water velocity (ft/s or m/s)'
	 write(LER,*)
     :'                    (default=4850 ft/s or 1480 m/s)'
	 write(LER,*)
     :' -crew [crew]     : crew identifier - 6 chars ',
     :'                    (i.e., Westrn) (no spaces allowed)'
	 write(LER,*)
     :' -procnm [pname]  : processor''s name  - 10 chars ',
     :'                    (i.e., M.A.Miller) (no spaces allowed)'
	 write(LER,*)
     :' -date [adate]    : date - 8 chars (mm/dd/yy) ',
     :'                    (no spaces allowed)'
	 write(LER,*)
     :' -oacline [OACLin]: OAC/line number - 7 chars ',
     :'                   (ooollll; i.e., ABC1234) (no spaces allowed)'
C***********************************************************************00000000
	 write(LER,*)
     :' -lindir [direct] : line direction  - 4 chars ',
     :'                    (N/S angle E/W; i.e., N45W) ',
     :'                    (no spaces allowed)'
	 write(LER,*)
     :' -dist1 [dist1]   : trace distance (ft or m) for first trace'
	 write(LER,*)
     :'                    of a record (default=0)'
	 write(LER,*)
     :' -dist2 [dist2]   : trace distance (ft or m) for last trace'
	 write(LER,*)
     :'                    of a record (default=0)'
	 write(LER,*)
     :'                    (dist1 and dist2 apply to all records on',
     :'                     the USP input dataset.  these entries',
     :'                     override a specified -DSTN dataset entry.)'
C***********************************************************************00000000
	 write(LER,*)
     :' -cdep1 [cdep1]   : cable depth (ft or m) for first trace of'
	 write(LER,*)
     :'                    a record (default=0)'
	 write(LER,*)
     :' -cdep2 [cdep2]   : cable depth (ft or m) for last trace of'
	 write(LER,*)
     :'                    a record (default=0)'
	 write(LER,*)
     :'                    (cdep1 and cdep2 apply to all records on',
     :'                     the USP input dataset.  these entries',
     :'                     override a specified -CABL dataset entry.)'
cmam	 write(LER,*)
cmam :' -wbdep1 [wbdp1]  : water bottom depth for first source point'
cmam   	 write(LER,*)
cmam :' -wbdep2 [wbdp2]  : water bottom depth for last source point'
cmam 	 write(LER,*)
cmam :'                    (water bottom depths will be interpolated'
cmam	 write(LER,*)
cmam :'                     between first and last source points)'
	 write(LER,*)
     :' -CABL [ncabl]    : optional dataset containing nCABL cards'
	 write(LER,*)
     :' -WATR [nwatr]    : optional dataset containing 1WATR cards'
	 write(LER,*)
     :' -MOOV [nmoov]    : optional dataset containing 1MOOV cards'
	 write(LER,*)
     :' -FLDH [nfldh]    : optional dataset containing field history'
	 write(LER,*)
     :'                    information: each record in the dataset'
	 write(LER,*)
     :'                    may contain up to 35 characters of info.'
	 write(LER,*)
     :' -DSTN [ndstn]    : optional dataset containing nDSTN cards'
         write(LER,*)
     :' -V [verbos]    (default=no)      : Verbose output '
	 write(LER,*)
     :'***************************************************************'
       write(LER,*)
     :'Usage:  ',
     :' maip2 -N[ntap] -O[otap] -CABL[ncabl] -WATR[nwatr] -MOOV[nmoov]',
C***********************************************************************00000000
     :'       -FLDH[nfldh] -DSTN[ndstn] -mode -noindx -metric -pltrev',
     :'       -nohist -ibtwn -recint[recint] -srcint[srcint]',
     :'       -sp1[spnum1] -spinc[spinc] -labinc[ripsrc] -fold[ifold]',
     :'       -giint[giint] -diint[diint] -laboff[offset]',
     :'       -jcstat[jcstat] -watvel[watvel] -crew[crew]',
     :'       -procnm[pname] -date[adate] -oacline[linum]',
     :'       -lindir[direct] -dist1[dist1] -dist2[dist2]',
     :'       -cdep1[cdep1] -cdep2[cdep2] -V'
cmam :'       -dist2[dist2] -cdep1[cdep1] -cdep2[cdep2]',
cmam :'       -wbdep1[wbdp1] -wbdep2[wbdp2] -V'
       write(LER,*)
     :'***************************************************************'
      return
      end
ccccccccccccccccccc
      INTEGER FUNCTION ASSIG1 ( PLACE, DELTA, MODE, INTERR )            00062900
C***********************************************************************00063000
C                                                                       00063100
C     FUNCTION NAME: ASSIGN                                             00063200
C                                                                       00063300
C     LANGUAGE: FORTRAN                                                 00063400
C                                                                       00063500
C     AUTHOR: R. WILSON AND E. ANDES                                    00063600
C                                                                       00063700
C     DATE WRITTEN: 01/13/86                                            00063800
C                                                                       00063900
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00064000
C                              TO BE MAINTAINED IN CONFIDENCE           00064100
C                                                                       00064200
C     ABSTRACT:                                                         00064300
C         FUNCTION ASSIGN WILL ASSIGN AN INDEX VALUE BASED ON           00064400
C         A DISTANCE PASSED AND A BUCKET SIZE.                          00064500
C                                                                       00064600
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00064700
C                             INITIAL RELEASE.                          00064800
C                                                                       00064900
C     PARAMETERS PASSED:                                                00065000
C         PLACE  - DISTANCE FROM ORIGIN TO BE LABELED                   00065100
C         DELTA  - LABELING INTERVAL                                    00065200
C         MODE   - FLAG TO SEE IF WE'RE ACCUMULATING ERROR              00065300
C         INTERR - ERROR COUNTER                                        00065400
C                                                                       00065500
C***********************************************************************00065600
C                                                                       00065700
      INTEGER * 4 ERROR, INTERR(50), DIFFER                             00065800
C--                                                                     00065900
C---- SET 'BUCKET' ASSIGNMENT                                           00066000
C--                                                                     00066100
      DELTA2 = DELTA * 0.5                                              00066200
      ASSIG1 = ( PLACE + DELTA2 ) / DELTA                               00066300
C--                                                                     00066400
C---- MAKE SURE INDEX STAYS UNDER 32768..                               00066500
C--                                                                     00066600
         IF ( ASSIG1 .GT. 32767 ) ASSIG1 = 32767                        00066700
C--                                                                     00066800
C---- IF NEGATIVE, SEND BACK BAD INDEX...                               00066900
C--                                                                     00067000
         IF ( ASSIG1 .GE. 1 ) GO TO 100                                 00067100
ccc 	print *,'ASSIG1 is negative or zero, set = -1'
              ASSIG1 = -1                                               00067200
              RETURN                                                    00067300
C--                                                                     00067400
C--------------------------------------------------------------         00067500
C-- IF USER PASSED A 'ZERO' FLAG FOR PARM3, THEN LEAVE.                 00067600
C-- OTHERWISE ASSUME PARM4 IS AN ERROR FUNCTION VECTOR RANGING          00067700
C-- FROM -0.5 TO 0.46 (INCREMENTED BY 0.04) INDEXED FROM 1 TO 50.       00067800
C-- UPDATE THIS VECTOR WITH DIFFERENCE BETWEEN TRUE POSITION OF         00067900
C-- THE TRACE ATTRIBUTE AND THE IDEAL POSITION OF THAT ATTRIBUTE.       00068000
C--                                                                     00068100
  100 IF ( MODE .LT. 1 ) RETURN                                         00068200
         DIFFER = ( PLACE - DELTA * ASSIG1 ) / DELTA * 50.0             00068300
         ERROR = 26 + DIFFER                                            00068400
ccc	print *,'in ASSIG1: DIFFER, ERROR, PLACE, DELTA, ASSIG1=',
ccc  *	DIFFER, ERROR, PLACE, DELTA, ASSIG1
         IF (ERROR .LT.  1) ERROR = 1                                   00068500
         IF (ERROR .GT. 50) ERROR = 50                                  00068600
         INTERR(ERROR) = INTERR(ERROR) + 1                              00068700
         RETURN                                                         00068800
      END                                                               00068900
C                                                                       00159100
      INTEGER FUNCTION SPSET1( SOURCE, DELTA, LIMIT, TRUESP, FRSTSP )   00159200
C***********************************************************************00159300
C                                                                       00159400
C     FUNCTION NAME: SPSET                                              00159500
C                                                                       00159600
C     LANGUAGE: FORTRAN                                                 00159700
C                                                                       00159800
C     AUTHOR: R. WILSON AND E. ANDES                                    00159900
C                                                                       00160000
C     DATE WRITTEN: 01/13/86                                            00160100
C                                                                       00160200
C     AMOCO PRODUCTION CO. PROPRIETARY -                                00160300
C                              TO BE MAINTAINED IN CONFIDENCE           00160400
C                                                                       00160500
C     ABSTRACT:                                                         00160600
C         FUNCTION SPSET ASSIGNS HALF WORD 108.                         00160700
C                                                                       00160800
C     MODIFICATION HISTORY:   01/13/86   E.ANDES                        00160900
C                             INITIAL RELEASE.                          00161000
C                                                                       00161100
C     PARAMETERS PASSED:                                                00161200
C         SOURCE - DISTANCE FROM ORIGIN                                 00161300
C         DELTA  - LABELING INTERVAL                                    00161400
C         LIMIT  - AMOUNT OF SLOP FOR LABELING                          00161500
C         TRUESP - FLOATING POINT SOURCE POINT AT ANY LOCATION          00161600
C         FRSTSP - LOCATION OF FIRST SOURCE ON LINE                     00161700
C                                                                       00161800
C***********************************************************************00161900
C                                                                       00162000
      REAL    * 8 TJOBID
      REAL    * 4 SOURCE, LIMIT, ERROR                                  00162100
C                                                                       00162200
      INTEGER * 4 SPNUM1, SPINC, RIPSRC, ASSIGN                         00162300
C                                                                       00162400
      COMMON /LUNIT/  IREADR, IPRNTR, IDISKW, IDISKC
      COMMON /TAPES/ luin, luout
      COMMON /JOBCON/ RECINT, SRCINT, SPNUM1, SPINC, RIPSRC, GIINT,     00162500
     *                DIINT, OFFSET, MODE, JCSTAT, TJOBID, lcount       00162600
C--                                                                     00162900
C---- COMPUTE DISTANCE FROM FIRST SOURCE POINT AND BIAS BY ONE          00163000
C---- SOURCE POINT LABELING INTERVAL.                                   00163100
C--                                                                     00163200
      ADJUST = SOURCE - FRSTSP + DELTA                                  00163300
C--                                                                     00163400
C---- GET SOURCE POINT OVER THIS DI...                                  00163500
C--                                                                     00163600
      SPSET1 = ASSIGN ( ADJUST, DELTA, 0, DUMMY )                       00163700
C--                                                                     00163800
C---- IS IT VALID ???                                                   00163900
C--                                                                     00164000
      IF ( SPSET1.GT. 0 ) GO TO 100                                     00164100
           SPSET1 = 0                                                   00164200
           TRUESP = SPNUM1                                              00164300
           RETURN                                                       00164400
C--                                                                     00164500
C-- COMPUTE REAL ERROR IN SOURCE POINT LABEL INDEX ASSIGNMENT           00164600
C--                                                                     00164700
  100 ERROR = ADJUST / DELTA - FLOAT(SPSET1)                             00164800
C--                                                                     00164900
C---- COMPUTE AND RETURN SOURCE POINT LABEL                             00165000
C---- ASSOCIATED WITH THIS POSITION...                                  00165100
C---- DETERMINE REAL SOURCE POINT LABELING                              00165200
C---- INDEX TOO, EVEN BETWEEN TWO LABELED SOURCE POINTS....             00165300
C--                                                                     00165400
      SPSET1 = SPNUM1 + ( SPSET1- 1 ) * SPINC                           00165500
      TRUESP = SPSET1+ ( ERROR * FLOAT( SPINC ) )                       00165600
C--                                                                     00165700
C---- IF POSITION IS BEFORE FIRST SOURCE LABEL POSTION, RETURN          00165800
C---- ZERO FOR A LABEL AND FIRST SOURCE POINT AS TRUESP                 00165900
C---- ALSO NEED TO ADD AN INCREMENT OF SOURCE POINT LABEL IF            00166000
C---- NOT A POSITIVE NUMBER...                                          00166100
C--                                                                     00166200
C     IF ( ABS(ERROR) .LT. LIMIT ) GO TO 150                            00166300
      IF (( ABS(ERROR) .LT.   LIMIT ) .OR.                              00166400
     *    (     ERROR  .EQ.   LIMIT   .AND. SPINC .GT. 0) .OR.          00166500
     *    (     ERROR  .EQ. -(LIMIT)  .AND. SPINC .LT. 0) )             00166600
     * GO TO 150                                                        00166700
C                                                                       00166800
      SPSET1 = 0                                                        00166900
      IF ( TRUESP .LT. SPNUM1                                           00167000
     *            .AND. SPINC .GT. 0 ) TRUESP = SPNUM1                  00167100
      IF ( TRUESP .GT. SPNUM1                                           00167200
     *            .AND. SPINC .LT. 0 ) TRUESP = SPNUM1                  00167300
      RETURN                                                            00167400
C                                                                       00167500
  150 IF (SPSET1.GT. 0) RETURN                                          00167600
C                                                                       00167700
      WRITE(IPRNTR,200) SPSET1                                          00167800
  200 FORMAT (/13X,'** M1100 ** ERROR DETECTED IN FUNCTION SPSET1:',    00167900
     *        /25X,'SOURCE POINT NUMBER ',I5,' IS LESS THAN OR',        00168000
     *        /25X,'EQAUL TO ZERO. REENTER SOURCE ID AND SOURCE',       00168100
     *        /25X,'POINT INCREMENT ON 1MAIP CARD.',/)                  00168200
      CALL LBCLOS ( luin )
      CALL LBCLOS ( luout )
      CALL CCEXIT ( 100 )                                               00168400
      END                                                               00168500

