C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c     program module memsrt
c
c**********************************************************************c
c
c     memsrt reads a seismic trace from the command line,
c     and creates an output in the order of entries in
c     a table to create an output stream ordered on the
c     gi, si, di or distance

c     the input data is read in into a large memory buffer
c     within which the sort is done locally.  when more data
c     is needed the pointer is moved down the data (many more
c     than 1 trace) to where the next range of sorted traces
c     is spanned and the buffer is refilled
c     in this way reads can be done using large buffers with
c     only a few (hundred?) pointer moves and consequent buff
c     flushes.
c
c subroutine calls: rtape, hlh, wrtape, save, dagc, odd
c
c**********************************************************************c
c
c     declare variables
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD ), ltr ( SZLNHD )
      integer     roll
      pointer     (iaddr5, roll(1))
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, rind, tind
      integer     luin , luout, lbytes, nbytes
      integer     istart,iend, nsampo,obytes
#include <f77/pid.h>
      integer     reccnt(4),trccnt(4)
      integer     trc,rec,newrec,jj,index,numtrc
      pointer     (iaddr1, trc(1))
      pointer     (iaddr2, rec(1))
      pointer     (iaddr3, newrec(1))
      pointer     (iaddr4, jj(1))
      pointer     (iaddr6, index(1))
      pointer     (iaddr7, numtrc(1))
      integer     currec, curtrc, mntrc(SZLNHD),mxtrc(SZLNHD)
      integer     ist(SZLNHD), ied(SZLNHD)
      integer     gimin, gidel,recind,gival,depind,srcind
      real        tri ( SZLNHD )
      character   name * 6,   ntap * 256, otap * 256, tnam * 256
      real        lri ( SZLNHD )
      logical     verbos, query, G, S, D, R, X, leave, heap
      integer     argis, lud

      equivalence ( itr(  1), lhed(1), tri(1) )
      equivalence ( ltr(1), lri (1) )
      data name     /'MEMSORT'/
      data lbytes / 0 /, nbytes / 0 /, leave / .false. /
      data ltr/ SZLNHD * 0/, lud/41/
      

c-----
c     get help if necessary
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout files
c-----
#include <f77/open.h>

c-----
c     read program parameters from command line card image file
c-----
      call gcmdln(ntap,otap,tnam,G,S,D,R,X,verbos,leave,
     &             istart,iend,nsampo,ibuf)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     guarantee that we can work with the files
c-----
       if(tnam(1:1).eq.' ')then
              luns = LIN
       else
              luns = 22
              open(luns,file=tnam,status='old',
     1                     form='formatted',access='sequential')
              rewind luns
       endif
c logical units in effect
      write(LERR,*)'LER=  ',LER,'  LERR=  ',LERR
      write(LERR,*)'luin=  ',luin,'  luout=  ',luout,'  luns=  ',luns

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes )
      write(LERR,*)'lbytes=  ',lbytes
      if(lbytes .eq. 0) then
             write(LOT,*)'memsrt: no header read from unit ',luin
             write(LOT,*)'FATAL'
             stop
      endif

      call hlhprt ( itr , lbytes, name, 6, LERR        )

#include <f77/saveh.h>

      nsampo = nsampo/nsi
      if(nsampo .le. 0) nsampo = nsamp
      obytes = SZTRHD + SZSMPD * nsampo
      nbytes = SZTRHD + SZSMPD * nsamp

c-----
c  check for old table & abort if necessary
c-----
      read(luns,*,end=7) itype
      if(itype .ne. -1) then
c  old table
      write(LERR,*)'Sort table is old: run presort step again'
      stop
      endif
      go to 9
c  new table
    7 continue
      write(LERR,*)'Premature end of file on sort table'
      write(LERR,*)'check presort run & repeat if necessary'
      stop
    9 continue

c------------
c     read presort table header
c------------
      read(luns,*)ndat
      write(LERR,*)'number entries in sort table= ',ndat
      read(luns,*)(reccnt(i),trccnt(i),i=1,4)
      write(LERR,*)(reccnt(i),trccnt(i),i=1,4)
      read(luns,*)gimin,gidel
      if(G)then
            nrecc = reccnt(1)
            jtr   = trccnt(1)
      elseif(S)then
            nrecc = reccnt(2)
            jtr   = trccnt(2)
      elseif(D)then
            nrecc = reccnt(3)
            jtr   = trccnt(3)
      elseif(R)then
            nrecc = reccnt(4)
            jtr   = reccnt(1)
      elseif(X)then
            nrecc = reccnt(4)
            jtr   = trccnt(4)
      endif
      if(iend .ne. 0) then
         nrecc = iend - istart + 1
      else
         iend = 1000000
      endif

      memsiz = jtr * (nsamp + LNTRHD)
      write(LERR,*)'gather size= ',memsiz,' words'

c-----
c     save hist line output line header values
c     adjust hist. line header
c     write line header
c-----
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savew(itr, 'NumSmp', nsampo,LINHED)
      call savhlh( itr, lbytes, lbyout)
      call wrtape ( luout, itr, lbyout                 )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)


c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec,iform, 
     1           ntap,otap,tnam,G,S,D,R,X,istart,iend,nsampo)
      end if

c---------------------------------------------------
c     here we depart from sisort
c     we now allocate memory storage for the indices


c  malloc only space we're going to use
      heap = .true.

      call galloc (iaddr1, ndat*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (iaddr2, ndat*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (iaddr3, ndat*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (iaddr4, ndat*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (iaddr6, ndat*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (iaddr7, ndat*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)'********************'
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*)'********************'
         nrec = 0
         ntrc = 0
         go to 9999
      else
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
         write(LERR,*) ndat*SZSMPD,'  bytes'
      endif

c---------------------------------------------------
c------------
c     pick up desired index, and stay within its range
c     pick up assoc rec & trc numbers
c     put them in the appropriate vectors (sequenced 
c     from 1 to the # governed by the range istart-iend)
c------------

      ic = 0
      jjj0 = 0
      do  800  jjj = 1, ndat

          read(luns,*,end=803)i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12

                  jjj0 = jjj0 + 1

                  if     (R) then
                        jj(jjj0)  = i10
                        rec(jjj0) = i11
                        trc(jjj0) = i12
                  elseif (S) then
                        rec(jjj0) = i6
                        trc(jjj0) = i7
                        jj(jjj0)  = i2

          if (i6 .eq. 0 .or. i7 .eq. 0) then
             write(LERR,*)'Source indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Source indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif
                  elseif (G) then
                        rec(jjj0) = i4
                        trc(jjj0) = i5
                        jj(jjj0)  = i1

          if (i4 .eq. 0 .or. i5 .eq. 0) then
             write(LERR,*)'Group index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Group indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif
                  elseif (D) then
                        rec(jjj0) = i8
                        trc(jjj0) = i9
                        jj(jjj0)  = i3

          if (i8 .eq. 0 .or. i9 .eq. 0) then
             write(LERR,*)'Depth index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Depth indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif
                  elseif (X) then
                        rec(jjj0) = i11
                        trc(jjj0) = i12
                        jj(jjj0)  = i10

          if (i11 .eq. 0 .or. i12 .eq. 0) then
             write(LERR,*)'Offset indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Offst indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif
                  endif


          if (jj(jjj0) .ge. istart .and. jj(jjj0) .le. iend) then
                  newrec(jjj0) = ntrc*(rec(jjj0) - 1) + trc(jjj0)
          elseif (jj(jjj0) .lt. istart) then
                  jjj0 = jjj0 - 1
          elseif (jj(jjj0) .gt. iend) then
                  jjj0 = jjj0 - 1
                  go to 803
          endif

800   continue
803   continue

c-----
c    what is the maximum possible trace range within index range
c    newrec - actual trace offset for each entry in sort table
c    jj     - sort index for each entry in sort table
c-----
      ndats = jjj0
      jjlast = jj(jjj0)

      write(LERR,*)'ndats= ',ndats,' ic= ',ic,' jjlast= ',jjlast
      write(LERR,*)' '
c-----
c    look out for a reversed data data, i.e. if the first index
c    read out of the presort table actually is found at the end 
c    of the data set.....

      noffirst = newrec (  1  )
      nofflast = newrec (ndats)

      write(LERR,*)' '
      write(LERR,*)'noffirst, nofflast= ',noffirst, nofflast

      if (noffirst .gt. nofflast) then
         write(LERR,*)' '
         write(LERR,*)'Data set reversed: first,last= ',noffirst,
     1                 nofflast
         write(LERR,*)' '
c-----
c    .... and reverse the trace pointer and the sort index vectors

         call vrvrs (newrec, 1, ndats)
         call vrvrs ( jj   , 1, ndats)

      endif
c-----


c------------------------------------------------------------------
c     now let's figure out initially how many chunks of the sort table
c     we can use after a large-buffered read
c     let's start with a buffer size = total # bytes in the data
c     and if that's too large we'll knock it down by 1/2 until it fits

c---------------
c       figure out total number bytes in data set (w/o line header)
c       set memory limits in bytes for each machine
c       nbytes = number bytes/trace (trc header incl)
c       sun: 1 mw;  cray2: 64 mw
        
        isztot =  nrec * ntrc * (nsamp + LNTRHD)
        
#ifdef CRAYSYSTEM
        if (ibuf .eq. 0) ibuf = 16000000
#else
        if (ibuf .eq. 0) ibuf = 4000000
#endif
        nblk = isztot / ibuf + 1
        if (X .and. nblk .gt. 1) then
           write(LERR,*)'For offset sort must be able to fit whole'
           write(LERR,*)'set into memory at one time.  This data set'
           write(LERR,*)'is too big.  Use sisort with same command line'
           call ccexit(666)
        endif
        write(LERR,*)'Maximum memory buffer size ',ibuf,' words'
        write(LERR,*)'Total data set size (in memory)= ',isztot
        write(LERR,*)'Rolling buffer size ',nblk,' words'
        write(LERR,*)' '
c---------------

c------
c     initialize limits
c     nrecc = # distinct gathers
c------
      mnoff  =  1000000
      mxoff  = -1000000
c------
c     figure out the min & max trc offsets for each gather
c     index  - vector of unique sort indeces
c     numtrc - vector of numbers of traces for each of above indeces
c     ist    - min trc offset for each sort index
c     ied    - man trc offset for each sort index
c------
      jlst = 0
      ig   = 0
      ic   = 1
      jj(ndats+1) = 0
      newrec(ndats+1) = 0

      mxofff = -1000000

      do  j = 1, ndats
          if (jj(j) .ne. jlst) then
             ic = 1
             ig = ig + 1
             mnoff =  1000000
             mxoff = -1000000
             index(ig)  = jj(j)
             if (newrec(j) .le. mnoff) mnoff = newrec(j)
             if (newrec(j) .ge. mxoff) mxoff = newrec(j)
             jlst    = jj(j)
             ist(ig) = mnoff
             ied(ig) = mxoff
             numtrc(ig) = ic
          else
             if (newrec(j) .le. mnoff) mnoff = newrec(j)
             if (newrec(j) .ge. mxoff) mxoff = newrec(j)
             ist(ig) = mnoff
             ied(ig) = mxoff
             ic = ic + 1
             numtrc(ig) = ic
          endif

          if (mxoff .ge. mxofff) mxofff = mxoff
      enddo

      write(LERR,*)' '
      write(LERR,*)'Unique sort index info'
      write(LERR,*)'ig,nrecc= ',ig,nrecc
      do j = 1, ig
         write(LERR,*)'J= ',j,' indx= ',index(j),' s/e= ',ist(j),ied(j),
     1   ' ngath= ',numtrc(j)
      enddo
      write(LERR,*)'Absolute maximum trace offset found= ',mxofff
      write(LERR,*)' '

      chnk = nrecc / nblk
      nchnk = nint (chnk)

      mnoff =  1000000
      mxoff = -1000000

c------
c     figure out the min & max trc offsets for each sort chunk
c------
      ic = 1
      nchnk1 = nchnk
      xrec = float(nrecc)/ float(nchnk)
      last = nrecc - (nblk-1) * nchnk
      if (nblk .eq. 1) last = nrecc
      idelmx = -1000000

      write(LERR,*)'chunk= ',nchnk,' last= ',last,' nrecc= ',nrecc,
     1             ' nblk= ',nblk

      do  j = 1, nrecc, nchnk

          if (ic .eq. nblk) nchnk1 = last
          do  j1 = 1, nchnk1
              jjj = j + j1 - 1
              if (jjj .gt. nrecc) go to 111
              if (ist(jjj) .le. mnoff) mnoff = ist(jjj)
              if (ied(jjj) .ge. mxoff) mxoff = ied(jjj)
          enddo
          if (j .eq. 1 .and. mnoff .gt. 1) then
             mnoff = 1
          endif
          mntrc(ic) = mnoff
          mxtrc(ic) = mxoff
          idel      = mxoff - mnoff
          if (idel .ge. idelmx) idelmx = idel
          write(LERR,*)'chunk= ',ic,' mn/mx/idel= ',mntrc(ic),mxtrc(ic),
     1    idel
          if (mxoff .ge. mxofff .AND. ic .lt. nblk) then
             nblk = ic
             go to 111
          endif
          ic = ic + 1
          mnoff =  1000000
          mxoff = -1000000
      enddo

111   continue

      xrec = float(nrecc)/ float(nchnk)
      last = nrecc - (nblk-1) * nchnk
      if (nblk .eq. 1) last = nrecc

c------
c     k will be the number of "chunks" in which the sort is done in
c     memory.  each chunk has associated with it a range of sort
c     indices from the sort table and a range of traces (min & max)
c     required by the indices
c------

      write(LERR,*)'nchnk= ',nchnk,' nblk= ',nblk,' idelmx= ',idelmx
      write(LERR,*)' '
      do  760  k = 1, nblk
          write(LERR,*)'K= ',k,' ist= ',ist(k),' ied= ',
     1    ied(k),' maxtrc= ',mxtrc(k),' mintrc= ',mntrc(k)
760   continue
      write(LERR,*)' '

c----
c   make a second pass through the rolling window start & end
c   trace vectors (mntrc, & mxtrc).  check to see that successive
c   mntrc values are always at least as great as prior values and
c   if not force them to be.  check to see that successive mxtrc
c   values are always greater than prior values and if not force
c   them to be.
c   then re-check the max rolling window size
c----

      IF (nblk .gt. 1) THEN

         idelmx = -1000000

         do  j = 2, nblk

             mnoff = mntrc(j)
             mxoff = mxtrc(j)
             if (mnoff .lt. mntrc(j-1)) then
                 mntrc(j-1) = mnoff
             endif
             if (mxoff .lt. mxtrc(j-1)) then
                 mxoff = mxtrc(j-1)
                 mxoff = mxoff + 1
                 mxtrc(j) = mxoff
             endif
             idel = mxoff - mnoff
             if (idel .ge. idelmx) idelmx = idel
         enddo

      ELSE

         idelmx = mxtrc (1)

      ENDIF

      write(LERR,*)'Second pass:'
      write(LERR,*)' '
      do  k = 1, nblk
          write(LERR,*)'K= ',k,' ist= ',ist(k),' ied= ',
     1    ied(k),' maxtrc= ',mxtrc(k),' mintrc= ',mntrc(k)
      enddo
      write(LERR,*)'Max rolling window size (trcs)= ',idelmx
      write(LERR,*)' '

c----
c   check mintrc & mxtrc vectors for consistency:
c   they both must be in ascending order or else
c   something's terribly wrong
c----
      call sort (mntrc, trc, nblk)
      do  j = 1, nblk
          jin = j
          jot = trc(j)
          if (jin .ne. jot) then
             write(LERR,*)'FATAL error in memsrt (mntrc vector):'
             write(LERR,*)'Rolling sort buffer out of synch.  Not'
             write(LERR,*)'enough memory requested?  Try increasing'
             write(LERR,*)'-b[] on cmd line (currently= ',ibuf,')'
             write(LERR,*)'If this needs to be too large you have no'
             write(LERR,*)'choice but to use sisort (same cmd line)'
             write(LER ,*)'FATAL error in memsrt (mntrc vector):'
             write(LER ,*)'Rolling sort buffer out of synch.  Not'
             write(LER ,*)'enough memory requested?  Try increasing'
             write(LER ,*)'-b[] on cmd line (currently= ',ibuf,')'
             write(LER ,*)'If this needs to be too large you have no'
             write(LER ,*)'choice but to use sisort (same cmd line)'
             go to 9999
          endif
      enddo

      call sort (mxtrc, trc, nblk)
      do  j = 1, nblk
          jin = j
          jot = trc(j)
          if (jin .ne. jot) then
             write(LERR,*)'FATAL error in memsrt (mxtrc vector):'
             write(LERR,*)'Rolling sort buffer out of synch.  Not'
             write(LERR,*)'enough memory requested?  Try increasing'
             write(LERR,*)'-b[] on cmd line (currently= ',ibuf,')'
             write(LERR,*)'If this needs to be too large you have no'
             write(LERR,*)'choice but to use sisort (same cmd line)'
             write(LER ,*)'FATAL error in memsrt (mxtrc vector):'
             write(LER ,*)'Rolling sort buffer out of synch.  Not'
             write(LER ,*)'enough memory requested?  Try increasing'
             write(LER ,*)'-b[] on cmd line (currently= ',ibuf,')'
             write(LER ,*)'If this needs to be too large you have no'
             write(LER ,*)'choice but to use sisort (same cmd line)'
             go to 9999
          endif
      enddo

c------------------------------------------------------------------


c---------------------------------------------------
c-----
c    we now have enough info to alloc actual data space
c    for the rolling buffer
 
c  malloc only space we're going to use
      heap = .true.

      items = (idelmx+1) * (nsamp + ITRWRD)
      call galloc (iaddr5, items*SZSMPD, errcod, abort)
      write(LERR,*)'errcod= ',errcod
      if (errcod .ne. 0) heap = .false.
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         nrec = 0
         ntrc = 0
         go to 9999
      else 
         write(LERR,*)' ' 
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c     call flush (LERR)
c---------------------------------------------------


c-----
c     BEGIN PROCESSING
c     process desired trace records
c-----

      currec = 0
      curtrc = 0

c-----------------------------------------------------------------
c     do actual sorting, for each chunk in memory

c     the scheme goes something like this:

c     for each chunk of sort indeces there will be a min & max trace
c     number (sequential within the data set on disk), e.g.

c     chunk1 -  1   82
c     chunk2 - 11  182
c     chunk3 - 39  282
c           ...

c     For the 1st chunk we read all 82 traces and store them in array
c     "roll".  So for the 1st range of sort indeces we have enough data
c     to do the sort.
c     For the 2nd chunk we don't have to re-read in traces 11 - 82 since
c     we already have those in "roll".  We do need to shift the those 72
c     traces to the beginning of "roll".  Now we just need to read in trcs
c     83 - 182 storing those in "roll" after the shifted block of traces.
c     For chunk3, ..., we repeat the shifting & reading operations.
c------------
      nwrd   = (SZTRHD + nsamp * SZSMPD) / SZSMPD
#ifndef CRAYSYSTEM
      mbytes = 1
#else
      mbytes = SZTRHD + nsamp * SZSMPD
#endif
      nchnk1 = nchnk
      mnlst = 1

      DO   2000  j = 1, nblk


           mntrcj = mntrc(j)
           mxtrcj = mxtrc(j)
           if (j .gt. 1) then
              j1 = mxlst + 1
              j2 = mxtrcj
              idlst = mxlst - mntrcj + 1
              imov  = idlst * mbytes
              isrol = (mntrcj - mnlst) * mbytes + 1
              istrt = imov + 1
           else
              j1 = mntrcj
              j2 = mxtrcj
              istrt = 1
           endif
c------
c     position pointer at minimum trace for new chunk
c     span of traces
c     then fill up roll matrix with ALL the traces in this span

              jt0 = 0
              do  710  jt = j1, j2

                       call rtape (luin, itr, nbytes)
                       if (nbytes .eq. 0) then
                          write(LERR,*)'End of File on Input:'
                          write(LERR,*)'halting sort operation'
                          write(LERR,*)'at data chunk ',j
                          go to 9999
                       endif

                       jt0 = jt0 + 1
c-------------
c   ndxj is the starting index in array "roll" where we put
c   the next new trace read in.  It is referenced to the block
c   of shifted traces from the last chunk (istrt)
c-------------
#ifndef CRAYSYSTEM
                       ndxj = (jt0-1) * nwrd + (istrt-1) * nwrd
                       if (j .gt. 1 .and. jt .eq. j1) then
                          isoff = (isrol-1) * nwrd
                          do  ii = 1, nwrd*imov
                              roll (ii) = roll (ii+isoff)
                          enddo
                       endif
                          do  ii = 1, nwrd
                              roll (ii+ndxj) = lhed (ii)
                          enddo
#else
                       ndxj = (jt0-1) * nbytes + istrt
                       if (j .gt. 1 .and. jt .eq. j1) then
                          call strmov (roll, isrol, imov, roll, 1)
                       endif
                          call strmov (itr, 1, nbytes, roll, ndxj)
#endif

710           continue
c------

c------
c     within this span of traces in memory choose only the ones
c     that correspond to the given sort index - jj ()

c     jjj  - pointer to each unique sort index:  index(jjj)
c            each will have numtrc(jjj) traces/gather
c------
            if (j .eq. nblk) nchnk1 = last

            do  1000  j1 = 1, nchnk1

                jjj = (j-1) * nchnk + j1
                isrt = index (jjj)
                ngat = numtrc(jjj)
                curtrc = 0

c------
c     pass through all the possible indeces looking for the desired one
c------
                do  ji = 1, ndats

                    IF (isrt .eq. jj(ji)) THEN

c------
c     when we find them we compute the trace offset within the
c     current chunk (which starts at mntrcj in the data)
c------
                       curtrc = curtrc + 1
                       if (curtrc .eq. 1) then
                          currec = currec + 1
                       endif
                       ioff = newrec (ji) - mntrcj + 1


c------------
c     compute trace # we want from the current matrix spanning
c     all possible traces for this chunk of the sort table
c     then read it from memory
c------------
#ifndef CRAYSYSTEM
            irj = (ioff - 1) * nwrd
            do  ii = 1, nwrd
                lhed (ii) = roll (ii+irj)
            enddo
#else
            irj = (ioff - 1) * nbytes + 1
            call strmov (roll,irj,nbytes,itr,1)
#endif


c           recind = itr(l_RecInd)
c           srcind = itr(l_SrcLoc)
c           depind = itr(l_DphInd)
c           rind   = itr(l_RecNum)
c           tind   = itr(l_TrcNum)
            call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                  recind, TRACEHEADER)
            call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                  srcind, TRACEHEADER)
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  rind  , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  tind  , TRACEHEADER)

            if(verbos)write(LERR,*)'rind= ',rind,'  tind= ',tind,
     1                ' GI# =  ',recind,'  PI# =  ',srcind,
     2                '  DI# =  ',depind

            if(.not. leave) then
               call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     currec, TRACEHEADER)
               call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     curtrc, TRACEHEADER)
            endif

            call wrtape( luout, itr, obytes)

            if(verbos)write(LERR,*)'rec trc gival ',currec, 
     1            curtrc, gival,recind

                    ENDIF

             enddo

c-----
c    pad last record if necessary
c-----
             if(curtrc.ge.ngat .and. curtrc.lt.jtr)then
                  if(verbos)
     1            write(LERR,*)'currec= ',currec,' curtrc= ',curtrc
                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                 l_RecNum,l_TrcNum,l_PrRcNm,l_PrTrNm,
     2                 l_RecInd,l_SrcLoc,l_DphInd,l_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_PrRcNm,ln_PrTrNm,
     4                 ln_RecInd,ln_SrcLoc,ln_DphInd,ln_StaCor,
     5                 ifmt_RecNum,ifmt_TrcNum,ifmt_PrRcNm,ifmt_PrTrNm,
     6                 ifmt_RecInd,ifmt_SrcLoc,ifmt_DphInd,ifmt_StaCor,
     7                 currec,curtrc,jtr,nsamp,iform)
                  endif

1000        continue

c-----
c    For the current chunk store it's min/max traces (refernced to the
c    data on disk) 
c-----
            mnlst = mntrcj
            mxlst = mxtrcj

2000     CONTINUE
c-----------------------------------------------------------------

            currec = currec + 1
            IF (currec .lt. nrecc) THEN
                if(curtrc.lt.jtr)then
                  if(verbos)
     1            write(LERR,*)'End of line:  currec= ',currec,
     2                          ' curtrc= ',curtrc
                      call nultrc(ltr,lri,verbos,obytes,luout,
     1                 l_RecNum,l_TrcNum,l_PrRcNm,l_PrTrNm,
     2                 l_RecInd,l_SrcLoc,l_DphInd,l_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_PrRcNm,ln_PrTrNm,
     4                 ln_RecInd,ln_SrcLoc,ln_DphInd,ln_StaCor,
     5                 ifmt_RecNum,ifmt_TrcNum,ifmt_PrRcNm,ifmt_PrTrNm,
     6                 ifmt_RecInd,ifmt_SrcLoc,ifmt_DphInd,ifmt_StaCor,
     7                 currec-1,curtrc-1,jtr,nsamp,iform)
                endif
            ENDIF

 9999 continue
c-----
c     close data files
c-----
      close       ( luns )
      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of memsrt, processed',nrec,' record(s)',
     1            ' with ',ntrc, ' traces'
      close (LERR)
      end

      subroutine nultrc(itr,tri,verbos,nbytes,luout,
     1                 l_RecNum,l_TrcNum,l_PrRcNm,l_PrTrNm,
     2                 l_RecInd,l_SrcLoc,l_DphInd,l_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_PrRcNm,ln_PrTrNm,
     4                 ln_RecInd,ln_SrcLoc,ln_DphInd,ln_StaCor,
     5                 ifmt_RecNum,ifmt_TrcNum,ifmt_PrRcNm,ifmt_PrTrNm,
     6                 ifmt_RecInd,ifmt_SrcLoc,ifmt_DphInd,ifmt_StaCor,
     3                 currec,j1,j2,nsamp,iform)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer     nsamp, iform, j1, j2
      integer     itr ( SZLNHD )
      real        tri ( SZLNHD )
      integer     currec
      integer     luout
      logical     verbos

            if (j1 .gt. j2) return
c           itr(l_StaCor) = 30000
            call savew2(itr,ifmt_StaCor,l_StaCor,
     1                  ln_StaCor, 30000, 1)
 1002       continue
            do 1001 i=j1+1,j2
                  if(verbos)write(LERR,*)'Null outputting rec='
     1                  ,currec,' trace=',i
c                 itr(l_RecNum)=currec
c                 itr(l_TrcNum)=i
c                 itr(l_SrcLoc)=0
c                 itr(l_PrRcNm)=0
c                 itr(l_PrTrNm)=0
c                 itr(l_RecInd)=0
c                 itr(l_DphInd)=0
                  call savew2(itr,ifmt_RecNum,l_RecNum,
     1                        ln_RecNum, currec, 1)
                  call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                        ln_TrcNum, i     , 1)
                  call savew2(itr,ifmt_SrcLoc,l_SrcLoc,
     1                        ln_SrcLoc, 0     , 1)
                  call savew2(itr,ifmt_PrRcNm,l_PrRcNm,
     1                        ln_PrRcNm, 0     , 1)
                  call savew2(itr,ifmt_PrTrNm,l_PrTrNm,
     1                        ln_PrTrNm, 0     , 1)
                  call savew2(itr,ifmt_RecInd,l_RecInd,
     1                        ln_RecInd, 0     , 1)
                  call savew2(itr,ifmt_DphInd,l_DphInd,
     1                        ln_DphInd, 0     , 1)
                  call wrtape( luout, itr, nbytes)
 1001       continue
      return
      end

      subroutine help
#include <f77/iounit.h>
         write(LOT,*)
     1'***************************************************************'
      write(LOT,*)
     1'execute memsrt by typing memsrt and  list of program parameters.'
      write(LOT,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LOT,*)
     1'a character(s) corresponding to some parameter.'
        write(LOT,*)
     1'users enter the following parameters, or use the default values'
       write(LOT,*)' '
        write(LOT,*)
     1' -N[ntap]     (no default)         : input data file name'
        write(LOT,*)
     1' -O[otap]     (default = stdout )  : output data file name'
       write(LOT,*)
     1' -n[tnam]     (default = stdin)    : sort table name'
       write(LOT,*)' '
        write(LOT,*)
     1' -e[time]     (default = input )   : output trace length (ms)'
        write(LOT,*)
     1' -l[istart]   (default = first )   : starting record to sort'
        write(LOT,*)
     1' -m[iend]     (default = last )    : ending record to sort'
       write(LOT,*)
     1' -orig        (default = false)    : leave original rec/trc nos.'
       write(LOT,*)
     1' -G           (default = false)    : sort on receiver index'
       write(LOT,*)
     1' -S           (default = false)    : sort on source index  '
       write(LOT,*)
     1' -D           (default = false)    : sort on depth index'
       write(LOT,*)
     1' -R           (default = false)    : sort on distance-zero pad'
       write(LOT,*)
     1' -X           (default = false)    : sort on distance-no pad'
       write(LOT,*)' '
       write(LOT,*)
     1' -b[ibuf]     (def = 128MW, cray)  : memory size (words)'
       write(LOT,*)
     1'              (def =   1MW, sun)'
       write(LOT,*)' '
        write(LOT,*)
     1' NOTE: only one of -G -R -S or -D can be given'
       write(LOT,*)
     1'usage:   memsrt -N[ntap] -O[otap] -n[tnam] -e[] -G -R -S -D -X',
     2'-b[ibuf]  -V'
         write(LOT,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,tnam,G,S,D,R,X,verbos, leave,
     &                       istart, iend, nsampo,ibuf)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table file name
c   istart  - I         start sort record
c    iend   - I         stop sort record
c    ibuf   - I         change default buffer size (in words)
c   leave   - L         leave trace & record number the same as input
c     G     - L         Sort on receiver index
c     S     - L         Sort on source index
c     D     - L         Sort on depth index
c     R     - L         Sort on distance
c     X     - L         Sort on distance - no null trace padding
c     verbos- L   verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), tnam*(*)
      logical verbos, leave, G, S, D, R, X
      integer argis,istart,iend

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-n', tnam, ' ', ' ' )
            call argi4('-e',nsampo,0,0)
            call argi4('-l',istart,-999999,-999999)
            call argi4('-m',iend,0,0)
            call argi4('-b',ibuf,0,0)
            verbos = ( argis( '-V' ) .gt. 0 )
            leave = ( argis( '-orig' ) .gt. 0 )
            G = ( argis( '-G' ) .gt. 0 )
            D = ( argis( '-D' ) .gt. 0 )
            S = ( argis( '-S' ) .gt. 0 )
            R = ( argis( '-R' ) .gt. 0 )
            X = ( argis( '-X' ) .gt. 0 )
c-----
c     ensure than no more than one processing option is taken
            icmd = 0
            if(G)icmd=icmd+1
            if(D)icmd=icmd+1
            if(R)icmd=icmd+1
            if(S)icmd=icmd+1
            if(X)icmd=icmd+1
            if(icmd.ne.1)then
                  write(LOT,*)'FATAL ERROR'
                  call help()
                  stop
            endif
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec,iform, 
     1        ntap,otap,tnam,G,S,D,R,X,istart,iend,nsampo)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table name
c     G     - L     arrange by receiver index
c     S     - L     arrange by source index
c     D     - L     arrange by CDP index
c     R     - L     arrange by distance
c     X     - L     arrange by distance no trace padding
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, istart, iend
      character ntap*(*), otap*(*), tnam*(*)
      logical D, S, R, G, X

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' sort table name     =  ',tnam
            write(LERR,*) ' output trace lenght =  ',nsampo
            write(LERR,*) ' start record        =  ',istart
            write(LERR,*) ' end record          =  ',iend
            write(LERR,*) ' sort by receiver ind=  ',G
            write(LERR,*) ' sort by source index=  ',S
            write(LERR,*) ' sort by depth index =  ',D
            write(LERR,*) ' sort by distance    =  ',R
            write(LERR,*) ' sort by dist-no fill=  ',X
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end

      subroutine sort(ix,key,no)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 return
      end
