C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
      SUBROUTINE MEDCN(NX,X,Y,NF,F,ITER,ALF,iflag)
C
C------------- UPDATED 09/01/78  BY GUTOWSKI ---------------------------
C
C   X - INPUT TRACE TO FILTER
C   F - FILTER OF LENGTH NF
C   Y - OUTPUT FROM FILTER ( F * X = Y)
C   R - AUTOCORRELATION MATRIX OF INPUT SERIES, X
C   G - CROSS-CORRELATION OF Y**ALF WITH INPUT X
C ALF - IS THE EXPONENT FOR THE FILTER OUTPUT
C
C***********************************************************************
C
C        NOTE:   ALF = 4.0  --  WIGGINS MINIMUM ENTROPY DECONVOLUTION
C
C***********************************************************************
C
C   NORMAL EQUATIONS FOR M.E.D. --  R * F = G
C   THIS IS NONLINEAR AND IS SOLVED ITERATIVELY
C
C   ITER - NUMBER OF ITERATIONS
C   F - CONTAINS INITIAL GUESS OF FILTER ...
C        ... USUALLY WE CHOOSE THIS TO BE (0,...,0,1,0,...,0)
C
      DIMENSION X(*),Y(*),F(*),R(500),G(500),SPACE(3000)
      integer   nx, nf, iter
      real      alf, alf2, alf1
 
      call vclr (y,1,nx)
 
c  initial filter guess
      if (iflag .eq. 0) then
          call vclr (f,1,nf)
          f(nf/2) = 1.0
      endif
 
      ALF2=ALF/2.
      ALF1=ALF - 1.0
 
c--------------------------------------------------------------
c  solve for filter & output iteratively
 
      DO 10 I=1,ITER
C
C
C   COMPUTE NEW FILTER OUTPUT FOR THIS ITERATION STEP
C
      IF(I .EQ. ITER) return
      CALL FOLD(NF,F,NX,X,NY,y)
c     call vmov (space(nf/2),1,y,1,ny)

C   COMPUTE AUTOCORRELATION MATRIX FOR THIS ITERATION
      CALL CROSS(NX,X,NX,X,NF,R)
C
C
C   COMPUTE VARIMAX NORM
C
      V=0.
      U=0.
      DO 1 J=1,NY
      S=Y(J)*Y(J)
      V=V +    (ABS(Y(J)))**ALF
      U=U + S
C
C   CUBE THE FILTER OUTPUT
C
      YP=ABS(Y(J))
      IF(Y(J) .EQ. 0.) GO TO 1
      YSIG=Y(J)/YP
    1 Y(J)=YSIG*(YP**ALF1)
      V=V/(U**ALF2)
      V=V/U
      U=1./(U**ALF2)
C
C   COMPUTE CROSS-CORRELATION VECTOR  Y**(A-1) * X
C
      CALL CROSS(NY,Y,NX,X,NF,G)
C
C   SCALE AUTOCORRELATION MATRIX
C
c     CALL SCALE(V,NF,R)
      call vsdiv (r,1,1./v,r,1,nf)
C
C   SCALE CROSS-CORRELATION MATRIX
C
c     CALL SCALE(U,NF,G)
      call vsdiv (g,1,1./u,g,1,nf)
C
C   SOLVE NORMAL EQUATIONS FOR THIS STEP -- R * F = G --
C
      CALL EUREKb(NF,R,G,F,SPACE)
C
C   SCALE FILTER TO MAX VALUE OF UNITY
C
c     CALL DRANG(F,1,NF,1,SCL)
c     SCL=1./SCL
c     CALL SCALE(SCL,NF,F)
      call maxmgv (f,1,scl,indx,nf)
      call vsdiv (f,1,scl,f,1,nf)
 
   10 CONTINUE
c------------------------------------------------------------
      RETURN
      END
