C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE mednf (JJ, KK, LX, LW, X, G)
C     A CONFIDENTIAL AMOCO SUBROUTINE
C                            FORTRAN BY KEN PEACOCK        7-19-74
C     DAGCM COMPUTES A MEDIAN TRACE using a fast rolling algorithm
C     INPUTS ARE...
C             LX, LENGTH OF X AND G.
C             LW, LENGTH OF ANALYSIS WINDOW, LW ODD.
C             X, INPUT ARRAY.
C     OUTPUT IS...
C             G, median TRACE.
C
#include <f77/iounit.h>

c     DIMENSION X(1),G(1), work(SZLNHD), xx(SZLNHD)
c     real tmp1(SZLNHD), tmp2(SZLNHD)
c     integer key(SZLNHD), ley1(SZLNHD), ley2(SZLNHD)
      real    X(LX), G(LX)
      real    work, xx, tmp1, tmp2
      pointer (wkwork , work(1))
      pointer (wkxx   , xx  (1))
      pointer (wktmp1 , tmp1(1))
      pointer (wktmp2 , tmp2(1))
      integer key, ley1, ley2
      pointer (wkkey  , key (1))
      pointer (wkley1 , ley1(1))
      pointer (wkley2 , ley2(1))
      integer jsz, ier, iert, abort
      logical first

      ier  = 0
      iert = 0
      abort = 0
      first = .true.
      xmed = 0.0
      LWD2 = LW/2
      ISTO = LWD2+1

      call sizefloat(jsz)
      
      call galloc (wkwork, jsz*LX, ier, abort)
      iert = iert + ier
      call galloc (wkxx  , jsz*LX, ier, abort)
      iert = iert + ier
      call galloc (wktmp1, jsz*LX, ier, abort)
      iert = iert + ier
      call galloc (wktmp2, jsz*LX, ier, abort)
      iert = iert + ier
      call galloc (wkkey , jsz*LX, ier, abort)
      iert = iert + ier
      call galloc (wkley1, jsz*LX, ier, abort)
      iert = iert + ier
      call galloc (wkley2, jsz*LX, ier, abort)
      iert = iert + ier

      if (iert .ne. 0) then
         write(LERR,*)'FATAL ERROR in mixn: median option'
         write(LERR,*)'Unable to allocate memory! ',iert,JJ,KK
         write(LER ,*)'FATAL ERROR in mixn: median option'
         write(LER ,*)'Unable to allocate memory! ',iert,JJ,KK
         call ccexit (666)
      endif


      do  i = 1, LX
          g (i) = 0.0
      enddo

c---
c  find non zero start end samples of trace
c---
      is = 1
c     do  i = 1, LX
c         if (x(i) .ne. 0.0) then
c             is = i
c             go to 21
c         endif
c     enddo
21    continue

      ie = LX
c     do  i = LX, is, -1
c         if (x(i) .ne. 0.0) then
c             ie = i
c             go to 22
c         endif
c     enddo
22    continue

c---
c---
      ii = 0
      do  i = is, ie
          ii = ii + 1
          xx (ii) = x(i)
      enddo
      lxx = ie - is + 1
 
c---
c  extract first half window of data
c---
      DO 1 I=1,ISTO
         work(i) = xx(i)
1     CONTINUE

c---
c  the first instance of medon will actually sort this first window
c  in its entirety
c---
      call medon (ISTO, wnew, first, xmed, key,
     1            work, tmp1, tmp2, ley1, ley2)
      g(is) =  xmed
 
c---
c  roll onto full window: we're adding a new sample each increment until
c  we get to a full window complement J = LW samples
c---
      DO 2 I=2,ISTO
         J = LWD2+I

         wnew = xx(J)
         call medon (J, wnew, first, xmed, key,
     1               work, tmp1, tmp2, ley1, ley2)
         g(i+is-1) = xmed
 
    2 continue
 
c---
c  this is probably the bulk of the processing right here as we roll down
c  the trace adding a sample (wnew) and dropping a sample to the full window
c  complement of LW samples
c---
      ISTA = ISTO+1
      ISTO = LXX-LWD2
      LWD2P1=LWD2+1
 
      DO 3 I=ISTA,ISTO
         K = I+LWD2
         wnew = xx(K)
         call medroll (lw, wnew, first, xmed, key,
     1                 work, tmp1, tmp2, ley1, ley2)
         g(i+is-1) = xmed
    3 continue
 
c---
c  now we're rolling off lw/2 samples: we're now dropping a sample each
c  increment
c---
      ISTA = ISTO+1
      ISTO = LXX

      jj = 0
      DO 4 I=ISTA, ISTO
          jj = jj + 1
          call medoff (jj, lw, xmed, key, work, tmp1)
          g(i+is-1) = xmed
    4 continue

      call gfree (wkwork)
      call gfree (wkxx  )
      call gfree (wktmp1)
      call gfree (wktmp2)
      call gfree (wkkey )
      call gfree (wkley1)
      call gfree (wkley2)
 
      RETURN
      END
