C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C2345678
      subroutine hilb(lf,f)
C
C    Sets up an lf-point hilbert trasnformer, i.e. a -90.0 
C    degrees phase shifter having frequency response -i.sgn(f)
C    Coefficinets are those of an ideal transformer. hence
C    filter is just a truncated version of the ideal
C
C234567
      real f(lf)
      pi = 4*atan(1.)
C Set up constant = 2/pi
      const=0.6366198
      if(lf.lt.3) lf=3
C Make sure lf is odd
      lfh=(lf+1)/2
      lf=2*lfh-1
C lfq is number of non-zero coeffieients
      lfq=lfh/2
      do j=1,lf
       f(J)=0.0
      end do
      k=lfh-1
      l=lfh+1
      t=-1.0
      do i=1,lfq
       k=k+2
       l=l-2
       t=t+2.0
       f(k)=const/t
       f(l)=-f(k)
      end do
      return
      end
