C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mkpest(sum, cb, cc, cd, thc, thd, theta, phest,
     :kb,kc,kd)
*
*23456789012345678901234567890123456789012345678901234567890123456789012
*
*      computes coefficients in equation for variation of kurtosis with 
*      phase, viz. kz = kc + kb cos2(0+0c) + kd cos4(0+0d), from sums 
*      of products from subroutine mksums.   
*      
*      15 july 94 : rew  -  original
*
*      inputs: array sum(5) from s/r mksums 
*              sum(1) = sum of x**4 = kx in white(1988)
*              sum(2) = sum of y**4 = ky in white(1988)
*              sum(3) = sum of x**2 y**2 = jxy in white(1988)
*              sum(4) = sum of xy(x**2 + y**2) = jxy+ in white(1988)
*              sum(5) = sum of xy(x**2 - y**2) = jxy- in white(1988)
* 
*      output: cb, cc, cd   = coefficients kb, kc, kd 
*              thc, thd     = phase angles 0c, 0d 
*              theta, phest = maximum kurtosis phase estimates 
*
*      reference:  r.e.white, 1988, geophys.j. 95, 371-389. 
*
*23456789012345678901234567890123456789012345678901234567890123456789012
*
      implicit none
      real sum(5), cb, cc, cd, ce, cf, thc, thd, theta, phest, pi
      real cstwo, csfour, ctmx, ctpi, ang 
      real kb,kc,kd
*
      pi = 4.*atan(1.0)
      cb = 0.375*(sum(1) + sum(2) + 2.0*sum(3))
      cc = 0.5*(sum(1) - sum(2))
      cd = 0.125*(sum(1) + sum(2) - 6.0*sum(3))
      ce = sum(4)
      cf = 0.5*sum(5)
      kb=cb
      kc=cc
      kd=cd
      thc = 90.0*atan2(ce,cc)/pi
      thd = 45.0*atan2(cf,cd)/pi
*
*      thc is in the range -90 to +90 degrees, thd in the range
*      -45 to +45.  there may be an alternative value for thd 
*      90 degrees away which is closer to thc.
*
      if ((thc-thd).gt.45.0) thd=thd+90.0
      if ((thd-thc).gt.45.0) thd=thd-90.0
      cc = cc*cc + ce*ce
      cd = cd*cd + cf*cf
*	no cos(4*theta) term if thd differs much from thc
      if(abs(thc-thd).gt.20.0.and.cd.lt.(0.2*cc)) then 
        cd = 0.0
        thd = thc
      endif
      phest = (cc*thc + 4.0*cd*thd)/(cc + 4.0*cd)
      cc = sqrt(cc)
      cd = sqrt(cd)
      theta = (cc*thc + 4.0*cd*thd)/(cc + 4.0*cd)
      cstwo = cos((thc - phest)*pi/90.0)
      csfour = cos((thd - phest)*pi/45.0)
      ctmx = cb + cc*cstwo + cd*csfour
      ctpi = cb - cc*cstwo + cd*csfour
      ang = 0.0
      if(ctmx.lt.ctpi) ang = 90.0
      phest = phest - ang
      theta = theta - ang
      thc = thc - ang
      thd = thd - ang
*
      return
      end
