C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mksums(n, x, y, sum)
C
C23456789012345678901234567890123456789012345678901234567890123456789012
C
C      Computes sums of pruducts required for mazimum kurtosis phase 
C      estimation.  Assumes zero-mean sequences.
C
C      13 July 94 : REW  -  Original version
C
C      input:  n    =  number of points in data segment
C              x(n) =  array containing data segment 
C              y(n) =  array containinG +90-degree phase shifted data 
C                      segment (note: Hilbert transformer --> -90 DEG)
C
C      OUTPUT: sum(1) = sum OF x**4 = Kx in White(1988)
C              sum(2) = sum OF y**4 = Ky in White(1988)
C              sum(3) = sum OF x**2 y**2 = Jxy in White(1988)
C              sum(4) = sum OF xy(x**2 + y**2) = Jxy+ in White(1988)
C              sum(5) = sum OF xy(x**2 - y**2) = Jxy- in White(1988)
*              sum(6) = sum of x**2
C
C      Reference:  R.E.White, 1988, Geophys.J. 95, 371-389. 
C
C23456789012345678901234567890123456789012345678901234567890123456789012
C
      implicit none
      integer n, i
      real x(*), y(*), sum(*), xsq, ysq, xy
C
      do i = 1, n
        xsq = x(i)*x(i)
        ysq = y(i)*y(i)
        xy  = x(i)*y(i)
        sum(1) = sum(1) + xsq*xsq
        sum(2) = sum(2) + ysq*ysq
        sum(3) = sum(3) + xsq*ysq
        sum(4) = sum(4) + xy*(xsq + ysq)
        sum(5) = sum(5) + xy*(xsq - ysq)
        sum(6) = sum(6) + xsq
      end do
      return
      end
