C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine quad(lt, t, lq, q, ierr)
c      form quadrature trace q from input trace t
c      q corresponds to a +90 degree phase shift on t
c      q = - (t convolved with hilbert transformer h)
c      length of hilbert transformer taken as lh=lq-lt+1
c     on output q is aligned in time with t and contains
c     lt live points, not lq.  the last (lq-lt) points in 
c     q are zeroed
c      note that first (lh-1)/2 points and last (lh-1)/2
c      points of q contain transients from truncation of t
c
      dimension t(lt), q(lq)
      parameter (maxlh=129, minlh=29)
      dimension h(maxlh)
      ierr = 0
      lh = lq-lt+1
      if(lh.gt.maxlh) lh=maxlh
      if(lh.gt.maxlh) ierr=1
      if(lh.lt.minlh) ierr=2
      if(lh.lt.minlh) lh = minlh
      call hilb(lh,h)
      lo = lt+lh-1
      if(lq.ne.lo) ierr=3
      if(lo.gt.lq) return
      call fold(lt,t,lh,h,lo,q)
c      fold displaces values of q by (lh-1)/2 samples
      ishift = (lh-1)/2
c      restore timing of q to that of t while reversing polarity
      do 10 i=1,lt
        q(i) = -q(i+ishift)
   10 continue
c      zero remainder of q array
      call zero((lh-1),q(lt+1))
      return
      end
