C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     program to merge (and optionally transpose) a cube of seismic data 
c     residing in multiple files  with the same stem name.
C
C**********************************************************************C
C
C mrgcube READS SEISMIC TRACE DATA FROM N INPUT FILES,
C and either merges trace-by-trace or record-by-record, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/pid.h>
#include <save_defs.h>
c
      parameter (maxs=0 000 002)
      parameter (max_units=100)
      dimension s(maxs)
      pointer   (pntrs,s)
C
      integer   hbegin
C

      integer         sheader ( SZLNHD )
      integer         luin(max_units)
      integer         nsamp(max_units)
      integer         ntr(max_units),nrec(max_units)
      integer         luout,obytes
      integer         argis
      integer         totalnodes
      character*8     name             
      character*120   ntap(max_units),otap
      character*2     int2str
      character*(120) file_stem
      logical         verbos,query,transpose
      logical         file_exists,multiple_files,single_file
C
      data name     /'MRGCUBE'/
c
      call timstr(vtot,wtot)
C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0)
      if(query) then
        call help(ler)
        call exitfu(0)
      endif
C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>
c_____________________________________________________________
c     Get processor stem name.
c_____________________________________________________________
      call argstr('-N',file_stem,' ',' ')
c___________________________________________________________________
c     get output data set name and open it up.
c___________________________________________________________________
      call argstr('-O',otap,' ',' ')
      call getln(luout,otap,'w',1)
c___________________________________________________________________
c     get remaining command line parameters.
c___________________________________________________________________
      transpose=(argis('-transpose') .gt. 0)
      single_file=(argis('-S') .gt. 0)
      multiple_files=.not. single_file
      verbos=(argis('-V') .gt. 0)
      call argr4('-M',amaxmem,0.,0.)
      if(amaxmem .le. 0.) then
         if(szsmpd .eq. 4) then
c________________________________________________________________________
c           workstation architecture.
c           default to 32 Megabytes=8 Megawords
c________________________________________________________________________
            amaxmem=8. 
         else
c________________________________________________________________________
c           supercomputer architecture.
c           default to 50 Megawords
c________________________________________________________________________
            amaxmem=64.
         endif
      endif
c___________________________________________________________________
c     open first (perhaps only input file name).
c___________________________________________________________________
      write(lerr,*) 'single_file = ',single_file
      write(lerr,*) 'multiple_files = ',multiple_files
      iunit=1
      kpass=1
      nodenumber=1
      if(multiple_files .and. file_stem .eq. ' ') then
         write(lerr,*) 'multiple files cannot be piped as input!'
         write(lerr,*) 'single file must be flagged by -S option'
         close(lerr)
         call exitfu(5555)
      endif
      if(single_file) then
         call getln(luin(iunit),file_stem,'r',0)
      else
         length=lnst(file_stem)
         ntap(iunit)=file_stem(1:length)//'_'//int2str(kpass,'_')//
     1                     '_'//int2str(nodenumber,'_')
         inquire(file=ntap(iunit),exist=file_exists)
         if(file_exists) then
            multiple_files=.true.
            write(lerr,*) 'open unit ',iunit,', luin(iunit) = ',
     1               luin(iunit), ' ntap(iunit) = ',ntap(iunit)
            call lbopen(luin(iunit),ntap(iunit),'r')
         else
            write(lerr,*) 'cannot find file :',ntap(iunit)
            write(lerr,*) 'single file must be flagged by -S option'
            close(lerr)
            call exitfu(5556)
         endif
      endif
c___________________________________________________________________
c     read in the lineheader.
c___________________________________________________________________
      call rtape(luin(iunit),sheader,lensh) 
      if(lensh .eq. 0) then
         write(lerr,*)'error in routine mrgcube!'
         write(lerr,*)'no header read on unit ',luin(iunit)
         write(lerr,*) 'iunit= ',iunit
         if(multiple_files) then
            write(lerr,*) 'trying to read in multiple files '
            write(lerr,*) 'file = ',ntap(iunit)
         else 
            write(lerr,*) 'multiple files of the form ',ntap(iunit)
            write(lerr,*) 'does not exist'
            write(lerr,*) 'trying to read in a single file'  
            write(lerr,*) 'file = ',ntap(iunit)
         endif
         write(lerr,*)'FATAL ERROR'
         close(lerr)
         call exitfu(1003)
      endif
      if(multiple_files) then
         call saver(sheader,'MxUHTm',totalnodes,LINEHEADER)
         call saver(sheader,'MnUHTm',jnode,LINEHEADER)
         call saver(sheader,'MxLnIn',npass,LINEHEADER)
         call saver(sheader,'MnLnIn',jpass,LINEHEADER)
      else
         totalnodes=1
         npass=1 
         jnode=1
         jpass=1
      endif
      write(lerr,*) 'totalnodes = ',totalnodes
      hbegin = 1-ITRWRD
      if(jnode .ne. 1) then                                     
         write(lerr,*) 'error in mrgcube for first file.'
         write(lerr,*) 'MnUHTm (node number) read as ',jnode
         close(lerr)
         call exitfu(1002)
      endif
      if(jpass .ne. 1) then                                     
         write(lerr,*) 'error in mrgcube.'
         write(lerr,*) 'MnLnIn (pass number) read as      ',jpass
         close(lerr)
         call exitfu(1003)
      endif
      call lbclos(luin(iunit))
c___________________________________________________________________
c     initialize and then open and read line header from ALL files.
c___________________________________________________________________
      ntrmax=0 
      ntrtot=0 
      iunit=0
      do 10003 nodenumber=1,totalnodes
c___________________________________________________________________
c      open up this unit for pass number 1.   
c___________________________________________________________________
       kpass=0
10002  continue
       iunit=iunit+1
       kpass=kpass+1
       ntap(iunit)=file_stem(1:length)//'_'//int2str(kpass,'_')//
     1                   '_'//int2str(nodenumber,'_')
       call getln(luin(iunit),ntap(iunit),'r',0)
       write(lerr,*) 'open unit ',iunit,', luin(iunit) = ',
     1                   luin(iunit), ' ntap(iunit) = ',ntap(iunit)
       lensh=0
c___________________________________________________________________
c      read in the lineheader.
c___________________________________________________________________
       call rtape(luin(iunit),sheader,lensh)
       if(lensh .eq. 0) then
          write(lerr,*)'error in routine mrgcube!'
          write(lerr,*)'no header read on unit ',luin(iunit)
          write(lerr,*)'unit = ',iunit
          write(lerr,*)'file = ',ntap(iunit)
          close(lerr)
          call exitfu(1003)
       endif
       call saver(sheader,'MnUHTm',jnode,LINEHEADER)
       call saver(sheader,'MxLnIn',npass,LINEHEADER)
       call saver(sheader,'MnLnIn',jpass,LINEHEADER)
       call saver(sheader,'NumSmp',nsamp(iunit),LINEHEADER)
       call saver(sheader,'SmpInt',nsi,LINEHEADER)
       call saver(sheader,'NumTrc',ntr(iunit),LINEHEADER)
       call saver(sheader,'NumRec',nrec(iunit),LINEHEADER)
       call saver(sheader,'Format',iform,LINEHEADER)
       write(lerr,*) 'iunit,nsamp(iunit),ntr(iunit),nrec(iunit) ',
     1               iunit,nsamp(iunit),ntr(iunit),nrec(iunit)
       ntrmax=max(ntr(iunit),ntrmax)
       ntrtot=ntrtot+ntr(iunit)
       write(lerr,*) 'pass ',kpass,' of ',npass ,' passes'
       if(jpass .ne. kpass) then
          write(lerr,*) 'error in mrgcube.'
          write(lerr,*) 'inconsistent header value in pass ',kpass
          write(lerr,*) 'MnLnIn (pass number) read as      ',jpass
          close(lerr)
          call exitfu(1004)
       endif
       if(jpass .lt. npass) go to 10002
10003 continue
      nfiles=iunit
      call hlhprt(sheader,lensh,name,len(name),lerr)

      ierror=0
      do 20000 iunit=2,nfiles
       if(nrec(iunit) .ne. nrec(1)) then
          write(lerr,*)'Input rec/line not alike for unit= ',iunit
          ierror=ierror+1
       endif
       if(nsamp(iunit) .ne. nsamp(1)) then
          write(lerr,*)' error! input number of samples differ '
          write(lerr,*) 'input data set number ',1,' nsamp =',
     1                   nsamp(1)
          write(lerr,*) 'input data set number ',iunit,' nsamp =',
     1                   nsamp(iunit)
          ierror=ierror+1
       endif
20000 continue
      nsampo=nsamp(1)
      if(nsampo .gt. SZSMPM) nsampo=szsmpm
      nreco=nrec(1)
c
      ntrmem=ntrmax
      if(.not. transpose) then               
         call savew(sheader,'NumTrc',ntrtot,LINEHEADER)
         call savew(sheader,'NumRec',nreco,LINEHEADER)
         lenu=(ITRWRD+nsampo)
      else
         call savew(sheader,'NumRec',ntrtot,LINEHEADER)
         call savew(sheader,'NumTrc',nreco,LINEHEADER)
         lenu=nreco*(ITRWRD+nsampo)*ntrmem
         maxwords=amaxmem*1.e+06
         if(lenu .gt. maxwords) then
c____________________________________________________________________
c           all common offsets for a given io unit will not fit in 
c           maximum memory allowed. calculate how many offsets (ntrmem)
c           will fit within memory.
c____________________________________________________________________
            factor=float(lenu)/maxwords
            ntrmem=float(ntrmax)/factor
            lenu=nreco*(ITRWRD+nsampo)*ntrmem
         endif
      endif
cmat  lentr2=lntrhd+nsampo*i2fact
      lentr2=ITRWRD+nsampo
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
c
      write(lerr,*) 'nreco = ',nreco
      write(lerr,*) 'nsampo= ',nsampo
      write(lerr,*) 'ntrmax= ',ntrmax
      write(lerr,*) 'ntrmem= ',ntrmem
      write(lerr,*) 'ntrtot= ',ntrtot
      write(lerr,*) 'ITRWRD= ',ITRWRD
      write(lerr,*) 'lenu  = ',lenu
c
      call savew(sheader,'NumSmp',nsampo,LINEHEADER)
      obytes = SZTRHD + SZSMPD * nsampo
C**********************************************************************C
C     write to printout file
C**********************************************************************C
      write(lerr,*)
      write(lerr,*)' Values read from input data set line header'
      write(lerr,*)
      write(lerr,*) ' # of Samples/Trace =  ', nsampo
      write(lerr,*) ' Sample Interval    =  ', nsi  
      write(lerr,*)' New traces/record = ',ntrtot,' OTAP= ',otap
      write(lerr,*)' New samples/trace= ',nsampo
      write(lerr,*)' Output Records per Line   =  ', nreco 
      write(lerr,*)' Output Traces per Rec     =  ', ntrtot
      write(lerr,*)' Format of Data     =  ', iform
      if(ierror .gt. 0) then
         write(lerr,*)'total number of input errors = ',ierror             
         close(lerr)
         call exitfu(1666)
      endif
c_______________________________________________________________________
c     write out sheader.
c_______________________________________________________________________
      call savhlh(sheader,lensh,lbyout)
      call wrtape(luout,sheader,lbyout)
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(/,a,/)') ' memory for tabling ray fan results.'
      write(lerr,'(80a1)') ('_',i=1,80)
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('u',l_u,l_free,lenu,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for MRGCUBE: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for MRGCUBE: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)
         write(lerr,*)'program MRGCUBE aborted'
         close(lerr)
         call exitfu(101)
      endif
      if(transpose) then 
C_______________________________________________________________________
c        transpose and then concatenate each data set.  
C_______________________________________________________________________
         call moffset(s(l_u),s(l_u),lentr2,
     1                ntr,nreco,nsampo,ntrmem,hbegin,
     2                luin,luout,nfiles,lerr,obytes,sheader,
     3                l_recnum,l_trcnum,
     4                ifmt_RecNum,ifmt_TrcNum,ln_RecNum,ln_TrcNum)
      else                                  
C_______________________________________________________________________
c        merge the data sets without transposing.  
C_______________________________________________________________________
         call mcrp(s(l_u),s(l_u),lentr2,ntr,nreco,nsampo,hbegin,
     1             luin,luout,nfiles,lerr,
     2             l_recnum,l_trcnum,
     4             ifmt_RecNum,ifmt_TrcNum,ln_RecNum,ln_TrcNum)
      endif
c_______________________________________________________________________
c     close all open units
c_______________________________________________________________________
      do 30000 iunit=1,nfiles
       call lbclos(luin(iunit))
30000 continue
      call lbclos(luout)
c
      call timend(cputime,vtot,v2,waltime,wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'total',cputime,waltime

      write(lerr,*) 'Normal completion of routine MRGCUBE'
      close(lerr)
      write(ler,*) 'Normal completion of routine MRGCUBE'
c
      close(lerr)
      call exitfu(0)
      end

      subroutine help(ler)
c----------------------------------------------------------------------
c     help panel
c----------------------------------------------------------------------
      write(LER,*)' '
      write(LER,*)'Command Line Arguments for mrgcube :'          
      write(ler,*)'merge and optionally transpose a cube of data'
     1                 //' distributed over similarly named files'
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(ler,*)
      write(ler,*)'-N[file_stem] --- for multiple files, the STEM '//
     1                       ' of the input file names of the form:'  
      write(ler,*)'                   file_stem__1 '                 
      write(ler,*)'                   file_stem__2 '                 
      write(ler,*)'                       :        '                 
      write(ler,*)'                       :        '                 
      write(ler,*)'                       v        '                 
      write(ler,*)'                   file_stem__N '                 
      write(ler,*)'                (no default for multiple files)'
      write(ler,*)'              --- for single file, the input file'
     1                                   //' (stdin)'
      write(ler,*)
      write(LER,*)'-O[otap]      --- output data set name (stdout)'
      write(LER,*)'-transpose    --- if present, transpose'
     1                           //' data after merging'                       
      write(ler,*)'-M[amaxmem]  -- maximum memory in megawords'
      write(ler,*)'                ( 8.0 on 4 byte Sparc arch)'
      write(ler,*)'                (64.0 on 8 byte Cray arch)'

      write(LER,*)'-S            --- a single file is input, with the'
     1                           //' name file_stem '
      write(LER,*)'-V            --- verbos printout'
      write(LER,*)' '
 
      return
      end
