C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE  RAMP ( INDEX, ISTART, ISTOP, NRAMP, Y )
C**********************************************************************C
C
C  APPLY LINEAR RAMP FROM START OF MUTE BACK TOWARD TIME ZERO
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
      INTEGER * 4 INDEX, ISTART, ISTOP, NRAMP
      REAL    * 4 Y   ( 1    )
C**********************************************************************C
C
C  SUBROUTINE ARGUMENTS
C
C  INDEX = STARTING SAMPLE WHERE TAPER BEGINS
C  ISTART= STARTING SAMPLE WITHIN THE RAMP
C          ( USED WHEN THE RAMP LENGTH EXCEEDS THE START OF THE MUTE )
C  NRAMP = LENGTH OF RAMP IN SAMPLES
C  Y     = TRACE VECTOR
C
C**********************************************************************C
      XRAMP = NRAMP
          DO 300 I = ISTART,ISTOP
            Y ( INDEX + I ) =
     *      Y ( INDEX + I ) *  ( I ) / XRAMP
 300     CONTINUE
      RETURN
      END
