C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (ntap, nsamp, nsi, ntrc, nrec, iform, otap, irs,
     :       ire, ns, ne, off, offset, disco, mfile, restore, ONword, 
     :     OFFword, tmul, dmul, tm, vm, mindis, maxdis, nramp, keywrd, 
     :     flt, threed )

#include <f77/iounit.h>

      integer nsamp, nsi, ntrc, nrec, irs, ire, ns, ne, iform
      integer mindis, maxdis, nramp
      character ntap*(*), otap*(*), mfile*(*), ONword*(*), OFFword*(*)
      character keywrd*6
      real tm, vm
      logical off, disco, offset, restore, flt, threed

      write(LERR,*)' '
      write(LERR,*)'    Input Data Parameters '
      write(LERR,*)' '
      write(LERR,*)' Input Data Set Name:  ',ntap
      write(LERR,*)' Samples / Trace    =  ',nsamp
      write(LERR,*)' Sample Interval    =  ',nsi
      write(LERR,*)' Traces / Record    =  ',ntrc
      write(LERR,*)' Records / Line     =  ',nrec
      write(LERR,*)' Format of Data     =  ',iform

      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters'
      write(LERR,*)' '
      write(LERR,*)' Output Data Set Name:               ',otap
      if (threed) then
      write(LERR,*)' 3D option selected:'
      write(LERR,*)'    -rs[] -re[] refer to xline start end'
      write(LERR,*)'    e.g. LI start and end'
      write(LERR,*)'    -ns[] -ne[] refer to nline start end'
      write(LERR,*)'    e.g. DI start and end'
      endif
      write(LERR,*)' First record to process             =  ',irs
      write(LERR,*)' Last record to process              =  ',ire
      write(LERR,*)' Starting trace number               =  ',ns
      write(LERR,*)' Ending   trace number               =  ',ne
      write(LERR,*)' Mute time in sec at zero offset     =  ',tm
      write(LERR,*)' Mute velocity                       =  ',vm
      write(LERR,*)' nramp (samples)                     = ',nramp
      write(LERR,*)' minimum distance to mute (ft/m)     = ',mindis
      write(LERR,*)' maximum distance to mute (ft/m)     = ',maxdis
      write(LERR,*)' distance multiplier                 = ', dmul
      write(LERR,*)' time multiplier                     = ', tmul
      write(LERR,*)' Mute key Word                       = ',keywrd
      if ( flt ) then
         write(LERR,*)' '
         write(LERR,*)' Mute trace header word is floating point value'
      endif

      if ( offset ) then
         write(LERR,*)' '
         write(LERR,*)' mute performed based on trace distance'
         write(LERR,*)' information from the file ',mfile
      endif 

      if ( disco ) then
         write(LERR,*)' '
         write(LERR,*)' Time-Offset cards are in DISCO format'
      endif 

      write(LERR,*)' '
      if ( off ) then
         write(LERR,*)' OFF mute to be performed'
         write(LERR,*)' Times stored in                 ',OFFword
      elseif ( .not. restore ) then
         write(LERR,*)' ON mute to be performed'
         write(LERR,*)' Times stored in                 ',ONword
      endif
      write(LERR,*)' '
      if ( restore ) then
         write(LERR,*)' Mute restore requested'
         write(LERR,*)' ON Times recovered from         ',ONword
         write(LERR,*)' OFF Times recovered from        ',OFFword
      endif

      return
      end

