C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE BPASS (LTYPE,IF1,IF2,IF3,IF4,IF5,IF6,IF7,IF8,          00000100
     1                  INVERT,ISI,LF,FILTR,WORK,EXP,IERR)              00000200
C ******************************************************************** C00000300
C *                                                                  * C00000400
C *   PROGRAM - BPASS                    ENTRY POINTS - BPASS        * C00000500
C *   LANGUAGE - FORTRAN                                             * C00000600
C *   AUTHOR -                                                       * C00000700
C *   DATE WRITTEN -                                                 * C00000800
C *   DATE LAST MODIFIED - 08/25/83                                  * C00000900
C *                        09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00001000
C *                                                                  * C00001100
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00001200
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00001300
C *                                                                  * C00001400
C *   ABSTRACT                                                       * C00001500
C *                                                                  * C00001600
C *    SUBROUTINE TO GENERATE BANDPASS, LOWPASS, HIGHPASS,           * C00001700
C *    OR STACKED FILTERS WITH ROSS WEIGHTING.  THE TYPE FILTER      * C00001800
C *    DESIGNED IS DETERMINED BY THE FREQUENCY VALUES ENTERED.       * C00001900
C *                                                                  * C00002000
C *   SUBROUTINES CALLED                                             * C00002100
C *       FILG ORMSBY ROSSW                                          * C00002200
C *                                                                  * C00002300
C *   USAGE                                                          * C00002400
C *                                                                  * C00002500
C *       CALL BPASS (LTYPE,IF1,IF2,IF3,IF4,IF5,IF6,IF7,IF8,         * C00002600
C *                  INVERT,ISI,LF,FILTR,WORK,EXP,IERR)              * C00002700
C *                                                                  * C00002800
C *           LTYPE - LENGTH COMPUTATION OPTION                      * C00002900
C *                   0 - COMPUTE OPTIMUM LENGTH.                    * C00003000
C *                   1 - COMPUTE MAXIMUM LENGTH.                    * C00003100
C *                   2 - COMPUTE OLD LENGTH.                        * C00003200
C *             IF1 - LOW CUT FREQUENCY FIRST FILTER STAGE.          * C00003300
C *             IF2 - LOW PASS FREQUENCY FIRST FILTER STAGE.         * C00003400
C *                   IF IF1 AND IF2 ARE ZERO THE FILTER WILL        * C00003500
C *                   BE A LOWPASS FILTER.                           * C00003600
C *             IF3 - HIGH PASS FREQUENCY FIRST FILTER STAGE.        * C00003700
C *             IF4 - HIGH CUT FREQUENCY FIRST FILTER STAGE.         * C00003800
C *                   IF IF3 AND IF4 ARE ZERO THE FILTER WILL        * C00003900
C *                   BE A HIGHPASS FILTER.                          * C00004000
C *             IF5 - LOW CUT FREQUENCY SECOND FILTER STAGE.         * C00004100
C *             IF6 - LOW PASS FREQUENCY SECOND FILTER STAGE.        * C00004200
C *             IF7 - HIGH PASS FREQUENCY SECOND FILTER STAGE.       * C00004300
C *             IF8 - HIGH CUT FREQUENCY SECOND FILTER STAGE.        * C00004400
C *                   IF IF5 THRU IF8 ARE 0 THE FILTER WILL BE       * C00004500
C *                   SINGLE STAGE.                                  * C00004600
C *          INVERT - INVERT FILTER:                                 * C00004700
C *                   0 - DO NOT INVERT FILTER OPERATOR.             * C00004800
C *                   1 - INVERT FILTER OPERATOR.                    * C00004900
C *             ISI - SAMPLE INTERVAL IN MSEC.                       * C00005000
C *              LF - LENGTH OF OPERATOR COMPUTED.                   * C00005100
C *           FILTR - OPERATOR ARRAY.                                * C00005200
C *            WORK - WORK ARRAY.                                    * C00005300
C *             EXP - ROSS WEIGHTING EXPONENT (DEFAULT = 3).         * C00005400
C *            IERR - ERROR RETURNED                                 * C00005500
C *                   0 = NO ERROR.                                  * C00005600
C *                   1 = DEFINING FREQUENCIES ARE NOT IN            * C00005700
C *                       ASCENDING ORDER.                           * C00005800
C *                   2 = A DEFINING FREQUENCY EXCEEDS THE NYQUIST   * C00005900
C *                       FREQUENCY FOR THE DATA.                    * C00006000
C *                   3 = INVALID LENGTH COMPUTATION OPTION.         * C00006100
C *                   4 = SAMPLE INTERVAL IS LESS THAN 1 MSEC.       * C00006200
C *                   6 = ROSS WEIGHTING WAS NOT APPLIED BECAUSE     * C00006300
C *                       EXPONENT IS LESS THAN 0.                   * C00006400
C *                   8 = OUT/OUT FILTER SPECIFIED.                  * C00006500
C *                                                                  * C00006600
C ******************************************************************** C00006700
      REAL FILTR(1001), WORK(1001)                                      00006800
C                                                                       00006900
      IERR = 0                                                          00007000
      LF = 0                                                            00007100
      ITYPE = LTYPE                                                     00007200
      JTYPE = 0                                                         00007300
      IAA = ITYPE                                                       00007400
      SI = FLOAT(ISI)                                                   00007500
      IF(ISI.LT.1) GO TO 4904                                           00007600
      FMAX = 1000.0 / (2.0 * SI)                                        00007700
      ITYPE = 0                                                         00007800
      F1 = FLOAT(IF1)                                                   00007900
      F2 = FLOAT(IF2)                                                   00008000
      F3 = FLOAT(IF3)                                                   00008100
      F4 = FLOAT(IF4)                                                   00008200
      F5 = FLOAT(IF5)                                                   00008300
      F6 = FLOAT(IF6)                                                   00008400
      F7 = FLOAT(IF7)                                                   00008500
      F8 = FLOAT(IF8)                                                   00008600
      EX = EXP                                                          00008700
      IF (EXP.EQ.0.0) EX = 3.0                                          00008800
      IF (IF1.EQ.0 .AND. IF2.EQ.0 .AND. IF3.EQ.0 .AND. IF4.EQ.0)        00008900
     *        GO TO 4908                                                00009000
      IF (IF5.EQ.0) GO TO 200                                           00009100
      ITYPE = 3                                                         00009200
  200 IF (IF1.EQ.0.AND.IF2.EQ.0) GO TO 300                              00009300
      IF (IF1.GE.IF2) GO TO 4901                                        00009400
  300 IF (ITYPE.NE.3) GO TO 700                                         00009500
      IF (IF2.GT.IF3) GO TO 4901                                        00009600
      IF (IF3.GE.IF4) GO TO 4901                                        00009700
      IF (IF4.GT.IF5) GO TO 4901                                        00009800
      IF (IF5.GE.IF6) GO TO 4901                                        00009900
      IF (IF8.NE.0) GO TO 500                                           00010000
      IF (IF7.NE.0) GO TO 400                                           00010100
      F7 = FMAX                                                         00010200
  400 F8 = FMAX                                                         00010300
  500 IF (F6.GT.F7) GO TO 4901                                          00010400
      IF (F7.LT.F8) GO TO 600                                           00010500
      IF (F7.EQ.FMAX.AND.F8.EQ.FMAX) GO TO 1100                         00010600
      GO TO 4901                                                        00010700
C                                                                       00010800
  600 IF (F8.GT.FMAX) GO TO 4902                                        00010900
      GO TO 1100                                                        00011000
C                                                                       00011100
  700 IF (IF4.NE.0) GO TO 900                                           00011200
      IF (IF3.NE.0) GO TO 800                                           00011300
      F3 = FMAX                                                         00011400
  800 F4 = FMAX                                                         00011500
  900 IF (F2.GT.F3) GO TO 4901                                          00011600
      IF (F3.LT.F4) GO TO 1000                                          00011700
      IF (F3.EQ.FMAX.AND.F4.EQ.FMAX) GO TO 2000                         00011800
      GO TO 4901                                                        00011900
C                                                                       00012000
 1000 IF (F4.GT.FMAX) GO TO 4902                                        00012100
      GO TO 2000                                                        00012200
C                                                                       00012300
 1100 CONTINUE                                                          00012400
      IF (F8.NE.F7) GO TO 1200                                          00012500
      IF (F8.EQ.FMAX) GO TO 1300                                        00012600
 1200 CALL FILG (IAA,F7,F8,L1,ISI,IERR)                                 00012700
      IF(IERR.EQ.0)GO TO 1400                                           00012800
      GO TO 5000                                                        00012900
C                                                                       00013000
 1300 L1 = 0                                                            00013100
 1400 CALL FILG (IAA,F5,F6,L2,ISI,IERR)                                 00013200
      IF(IERR.EQ.0)GO TO 1401                                           00013300
      GO TO 5000                                                        00013400
 1401 CONTINUE                                                          00013500
      CALL FILG (IAA,F3,F4,L3,ISI,IERR)                                 00013600
      IF(IERR.EQ.0)GO TO 1402                                           00013700
      GO TO 5000                                                        00013800
 1402 CONTINUE                                                          00013900
      IF (IF1.NE.0) GO TO 1500                                          00014000
      L4 = 0                                                            00014100
      GO TO 1600                                                        00014200
C                                                                       00014300
 1500 CALL FILG (IAA,F1,F2,L4,ISI,IERR)                                 00014400
      IF(IERR.EQ.0)GO TO 1600                                           00014500
      GO TO 5000                                                        00014600
 1600 IF (L2.GE.L1) GO TO 1700                                          00014700
      L2 = L1                                                           00014800
 1700 IF (L3.GE.L2) GO TO 1800                                          00014900
      L3 = L2                                                           00015000
 1800 IF (L4.GE.L3) GO TO 1900                                          00015100
      L4 = L3                                                           00015200
 1900 N = L4                                                            00015300
      GO TO 2800                                                        00015400
C                                                                       00015500
C                                                                       00015600
 2000 CONTINUE                                                          00015700
      IF (F4.NE.F3) GO TO 2100                                          00015800
      IF (F4.EQ.FMAX) GO TO 2200                                        00015900
 2100 CALL FILG (IAA,F3,F4,L1,ISI,IERR)                                 00016000
      IF(IERR.EQ.0)GO TO 2300                                           00016100
      GO TO 5000                                                        00016200
C                                                                       00016300
 2200 L1 = 0                                                            00016400
      ITYPE = 1                                                         00016500
 2300 IF (IF1.NE.IF2) GO TO 2400                                        00016600
      IF (IF1.EQ.0) GO TO 2500                                          00016700
 2400 CALL FILG (IAA,F1,F2,L2,ISI,IERR)                                 00016800
      IF(IERR.EQ.0)GO TO 2600                                           00016900
      GO TO 5000                                                        00017000
C                                                                       00017100
 2500 L2 = 0                                                            00017200
      ITYPE = 2                                                         00017300
 2600 IF (L2.LT.L1) GO TO 2700                                          00017400
      N = L2                                                            00017500
      GO TO 2800                                                        00017600
C                                                                       00017700
 2700 N = L1                                                            00017800
 2800 N1 = N                                                            00017900
      IF (ITYPE.NE.0) GO TO 3100                                        00018000
C                                                                       00018100
C         COMPUTE BANDPASS FILTER                                       00018200
C                                                                       00018300
      CALL ORMSBY (N,F3,F4,ISI,FILTR,IERR)                              00018400
      IF (IERR.NE.0) GO TO 5000                                         00018500
C                                                                       00018600
      DO 2900 I=1,N1                                                    00018700
         WORK(I) = FILTR(I)                                             00018800
 2900 CONTINUE                                                          00018900
C                                                                       00019000
      CALL ORMSBY (N,F1,F2,ISI,FILTR,IERR)                              00019100
      IF (IERR.NE.0) GO TO 5000                                         00019200
C                                                                       00019300
      DO 3000 I=1,N1                                                    00019400
         FILTR(I) = WORK(I)-FILTR(I)                                    00019500
 3000 CONTINUE                                                          00019600
C                                                                       00019700
      GO TO 4500                                                        00019800
C                                                                       00019900
C     COMPUTE LOWCUT FILTER                                             00020000
C                                                                       00020100
 3100 IF (ITYPE.NE.1) GO TO 3300                                        00020200
      ICEN = N / 2 + 1                                                  00020300
      CALL ORMSBY (N,F1,F2,ISI,FILTR,IERR)                              00020400
      IF (IERR.NE.0) GO TO 5000                                         00020500
C                                                                       00020600
      DO 3200 I=1,N1                                                    00020700
         FILTR(I) = -FILTR(I)                                           00020800
 3200 CONTINUE                                                          00020900
C                                                                       00021000
      FILTR(ICEN) = FILTR(ICEN) + 1.                                    00021100
      GO TO 4500                                                        00021200
C                                                                       00021300
C         COMPUTE HIGHCUT FILTER                                        00021400
C                                                                       00021500
 3300 IF (ITYPE.NE.2) GO TO 3400                                        00021600
      CALL ORMSBY (N,F3,F4,ISI,FILTR,IERR)                              00021700
      IF (IERR.NE.0) GO TO 5000                                         00021800
C                                                                       00021900
      GO TO 4500                                                        00022000
C                                                                       00022100
C         COMPUTE STACKED FILTER                                        00022200
C                                                                       00022300
 3400 LC = N                                                            00022400
      LCEN = N / 2 + 1                                                  00022500
      IF (IF1.EQ.0.AND.IF2.EQ.0) GO TO 3600                             00022600
      CALL ORMSBY (N,F1,F2,ISI,FILTR,IERR)                              00022700
      IF (IERR.NE.0) GO TO 5000                                         00022800
C                                                                       00022900
      DO 3500 I=1,N1                                                    00023000
         WORK(I) = FILTR(I)                                             00023100
 3500 CONTINUE                                                          00023200
C                                                                       00023300
      GO TO 3800                                                        00023400
C                                                                       00023500
 3600 DO 3700 I=1,N1                                                    00023600
         WORK(I) = 0.0                                                  00023700
 3700 CONTINUE                                                          00023800
C                                                                       00023900
 3800 CALL ORMSBY (N,F3,F4,ISI,FILTR,IERR)                              00024000
      IF (IERR.NE.0) GO TO 5000                                         00024100
C                                                                       00024200
      DO 3900 I=1,N1                                                    00024300
         WORK(I) = FILTR(I) - WORK(I)                                   00024400
 3900 CONTINUE                                                          00024500
C                                                                       00024600
      CALL ORMSBY (N,F5,F6,ISI,FILTR,IERR)                              00024700
      IF (IERR.NE.0) GO TO 5000                                         00024800
C                                                                       00024900
      DO 4000 I=1,N1                                                    00025000
         WORK(I) = WORK(I) - FILTR(I)                                   00025100
 4000 CONTINUE                                                          00025200
C                                                                       00025300
      IF (F8.EQ.FMAX.AND.F7.EQ.FMAX) GO TO 4100                         00025400
      CALL ORMSBY (N,F7,F8,ISI,FILTR,IERR)                              00025500
      IF (IERR.NE.0) GO TO 5000                                         00025600
      GO TO 4300                                                        00025700
C                                                                       00025800
 4100 DO 4200 I=1,N1                                                    00025900
         FILTR(I) = 0.0                                                 00026000
 4200 CONTINUE                                                          00026100
C                                                                       00026200
      FILTR(LCEN) = 1.                                                  00026300
C                                                                       00026400
 4300 DO 4400 I=1,N1                                                    00026500
         FILTR(I) = FILTR(I) + WORK(I)                                  00026600
 4400 CONTINUE                                                          00026700
C                                                                       00026800
 4500 LCENTR = 0                                                        00026900
      IOPT = 5                                                          00027000
      CALL ROSSW (FILTR,N,EX,IOPT,LCENTR,IERR)                          00027100
      LF = N                                                            00027200
      IF (INVERT.NE.1) GO TO 5000                                       00027300
C                                                                       00027400
      DO 4600 I=1,N                                                     00027500
         FILTR(I) = -FILTR(I)                                           00027600
 4600 CONTINUE                                                          00027700
C                                                                       00027800
      GO TO 5000                                                        00027900
C                                                                       00028000
 4901 CONTINUE                                                          00028100
      IERR = 1                                                          00028200
      GO TO 5000                                                        00028300
C                                                                       00028400
 4902 IERR = 2                                                          00028500
      GO TO 5000                                                        00028600
 4904 IERR = 4                                                          00028700
      GO TO 5000                                                        00028800
 4908 IERR = 8                                                          00028900
 5000 CONTINUE                                                          00029000
      RETURN                                                            00029100
      END                                                               00029200
      SUBROUTINE FILG (IOPT,FSTRT,FEND,LF,ISI,IERR)                     00029300
C ******************************************************************** C00029400
C *                                                                  * C00029500
C *                                                                  * C00029600
C *   PROGRAM - FILG                  ENTRY POINTS - FILG            * C00029700
C *   LANGUAGE - FORTRAN                                             * C00029800
C *   AUTHOR - ?                                                     * C00029900
C *   DATE WRITTEN - ?                                               * C00030000
C *   DATE LAST MODIFIED - 01 JAN 78                                 * C00030100
C *                        09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00030200
C *                                                                  * C00030300
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00030400
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00030500
C *                                                                  * C00030600
C *   ABSTRACT -                                                     * C00030700
C *                                                                  * C00030800
C *    SUBROUTINE TO COMPUTE OPTIMUM FILTER LENGTH.                  * C00030900
C *                                                                  * C00031000
C *   USAGE                                                          * C00031100
C *                                                                  * C00031200
C *   CALL FILG (IOPT,FSTRT,FEND,LF,ISI,IERR)                        * C00031300
C *                                                                  * C00031400
C *      IOPT - FILTER OPTION:                                       * C00031500
C *                   0 = OPTIMUM LENGTH ORMSBY.                     * C00031600
C *                   1 = MAXIMUM LENGTH ORMSBY.                     * C00031700
C *                   2 = OLD FILTER LENGTH.                         * C00031800
C *     FSTRT - STARTING FREQUENCY (I.E. F1 OR F3)                   * C00031900
C *      FEND - ENDING   FREQUENCY (I.E. F2 OR F4)                   * C00032000
C *        LF - COMPUTED FILTER LENGTH.                              * C00032100
C *       ISI - SAMPLE INTERVAL IN MSEC.                             * C00032200
C *      IERR - ERROR RETURNED.                                      * C00032300
C *             0 - NO ERRORS.                                       * C00032400
C *             1 - FSTRT IS EQUAL TO OR GREATER THAN FEND.          * C00032500
C *             2 - AN INPUT FREQUENCY EXCEEDS THE NYQUIST           * C00032600
C *                 FREQUENCY FOR THE DATA.                          * C00032700
C *             3 - INVALID OPTION FOR FILTER LENGTH.                * C00032800
C *             4 - SAMPLE INTERVAL IS LESS THAN 1.                  * C00032900
C *             8 - STARTING AND ENDING FREQUENCIES ARE 0.           * C00033000
C *                                                                  * C00033100
C ******************************************************************** C00033200
C                                                                       00033300
      IERR = 0                                                          00033400
      LF = 0                                                            00033500
      SI = ISI                                                          00033600
      IF ( FSTRT.NE.0. .OR. FEND.NE.0.)  GO TO 3                        00033700
      IERR = 8                                                          00033800
      GO TO 10000                                                       00033900
C                                                                       00034000
    3 IF (ISI.GE.1) GO TO 5                                             00034100
      IERR = 4                                                          00034200
      GO TO 10000                                                       00034300
C                                                                       00034400
    5 IF (IOPT.GE.0.AND.IOPT.LE.2) GO TO 10                             00034500
      IERR = 3                                                          00034600
      GO TO 10000                                                       00034700
C                                                                       00034800
   10 IF (FEND.GT.FSTRT) GO TO 20                                       00034900
      IERR = 1                                                          00035000
      GO TO 10000                                                       00035100
C                                                                       00035200
   20 FMAX = 1000. / (2. * SI)                                          00035300
      IF (FSTRT.LE.FMAX.AND.FEND.LE.FMAX) GO TO 30                      00035400
      IERR = 2                                                          00035500
      GO TO 10000                                                       00035600
C                                                                       00035700
   30 IF (IOPT-1) 100,200,300                                           00035800
C                                                                       00035900
C                        OPTIMUM LENGTH FILTER                          00036000
C                                                                       00036100
  100 CON1 = 817531.9022                                                00036200
      CON2 = 51.8601                                                    00036300
      LF = CON1 / (SI * (CON2 + FEND - FSTRT) * (CON2 + FEND - FSTRT))  00036400
      IW = FEND - FSTRT                                                 00036500
      IF (IW.EQ.1) LF = 480 / SI                                        00036600
      IF (IW.EQ.2) LF = 400 / SI                                        00036700
      IF (IW.EQ.3) LF = 360 / SI                                        00036800
      GO TO 500                                                         00036900
C                                                                       00037000
C                        MAX LENGTH FILTER                              00037100
C                                                                       00037200
  200 LF = 500 / SI                                                     00037300
      GO TO 500                                                         00037400
C                                                                       00037500
C                        OLD FILTER                                     00037600
C                                                                       00037700
  300 IF (IOPT.GT.3) GO TO 400                                          00037800
      LF = 7100.0 / (SI * ((3.0 * FEND) - FSTRT)) + 0.5                 00037900
      GO TO 500                                                         00038000
C                        FILTER LENGTH SPECIFIED                        00038100
  400 LF = (IOPT - 1) / 2                                               00038200
C                                                                       00038300
  500 IF (LF.GT.500) LF = 500                                           00038400
      LF = LF * 2 + 1                                                   00038500
10000 CONTINUE                                                          00038600
      RETURN                                                            00038700
      END                                                               00038800
      SUBROUTINE ORMSBY (LF,FSTRT,FEND,ISI,FILTR,IERR)                  00038900
C ******************************************************************** C00039000
C *                                                                  * C00039100
C *   PROGRAM - ORMSBY                    ENTRY POINTS - ORMSBY      * C00039200
C *   LANGUAGE - FORTRAN                                             * C00039300
C *   AUTHOR - ?                                                     * C00039400
C *   DATE WRITTEN - ?                                               * C00039500
C *   DATE LAST MODIFIED - 02/12/79                                  * C00039600
C *                        09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00039700
C *                                                                  * C00039800
C *       CONVERT TO INTERDATA - GEORGE PIERSON                      * C00039900
C *                                                                  * C00040000
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00040100
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00040200
C *                                                                  * C00040300
C *   ABSTRACT                                                       * C00040400
C *                                                                  * C00040500
C *    SUBROUTINE TO COMPUTE AN ORMSBY FILTER.                       * C00040600
C *                                                                  * C00040700
C *   USAGE                                                          * C00040800
C *                                                                  * C00040900
C *       CALL ORMSBY (LF,FSTRT,FEND,ISI,FILTR,IERR)                 * C00041000
C *                                                                  * C00041100
C *            LF = LENGTH OF THE FILTER.                            * C00041200
C *         FSTRT = STARTING FREQUENCY (I.E. F1 OR F3).              * C00041300
C *          FEND = ENDING   FREQUENCY (I.E. F2 OR F4).              * C00041400
C *           ISI = SAMPLE RATE IN MSEC.                             * C00041500
C *         FILTR = OUTPUT ARRAY.                                    * C00041600
C *          IERR = ERROR RETURNED.                                  * C00041700
C *                 0 = NO ERRORS.                                   * C00041800
C *                 1 = FSTRT IS EQUAL TO OR GREATER THAN FEND.      * C00041900
C *                 2 = FSTRT OR FEND EXCEEDS NYQUIST FREQUENCY.     * C00042000
C *                 4 = SAMPLE RATE IS LESS THAN 1.                  * C00042100
C *                 7 = LF IS NOT ODD.                               * C00042200
C *                 8 = STARTING AND ENDING FREQUENCIES ARE BOTH 0.  * C00042300
C *                                                                  * C00042400
C ******************************************************************** C00042500
C                                                                       00042600
      REAL FILTR(1001)                                                  00042700
C                                                                       00042800
      REAL*8 PI                                                         00042900
      REAL*8 T,FAC,SI                                                   00043000
      DATA PI/3.14159265358979323846D0/                                 00043100
C                                                                       00043200
C                                                                       00043300
      IERR = 0                                                          00043400
      IF (FSTRT.EQ.0. .AND. FEND.EQ.0.) GO TO 5008                      00043500
      IF(ISI.LT.1) GO TO 5004                                           00043600
      IF(LF.LT.0) LF = -LF                                              00043700
      IF(LF/2*2.EQ.LF) GO TO 5007                                       00043800
      IF(FEND.LE.FSTRT) GO TO 5001                                      00043900
      FMAX=1000./(2*ISI)                                                00044000
      IF(FSTRT.GT.FMAX .OR. FEND.GT.FMAX) GO TO 5002                    00044100
      N = LF / 2                                                        00044200
      FAC = 2.0D0 * PI                                                  00044300
      LC = 2 * N + 1                                                    00044400
      SI = .001D0 * DBLE(FLOAT(ISI))                                    00044500
      M = -N                                                            00044600
C                                                                       00044700
      DO 100 I=1,N                                                      00044800
         T = .001D0 * DBLE((FLOAT(M*ISI)))                              00044900
         X = ((DCOS(FAC*DBLE(FSTRT)*T) - DCOS(FAC*DBLE(FEND)*T)) /      00045000
     $         (PI*(FEND-FSTRT)*T**2)) / FAC * SI                       00045100
         FILTR(I) = X                                                   00045200
         M = M + 1                                                      00045300
  100 CONTINUE                                                          00045400
C                                                                       00045500
      FILTR(N+1) = (FEND + FSTRT) * SI                                  00045600
      J = LF                                                            00045700
C                                                                       00045800
      DO 200 I = 1,N                                                    00045900
         FILTR(J) = FILTR(I)                                            00046000
         J = J - 1                                                      00046100
  200 CONTINUE                                                          00046200
      GO TO 6000                                                        00046300
C                                                                       00046400
 5001 IERR = 1                                                          00046500
      GO TO 6000                                                        00046600
 5004 IERR = 4                                                          00046700
      GO TO 6000                                                        00046800
 5002 IERR = 2                                                          00046900
      GO TO 6000                                                        00047000
 5007 IERR = 7                                                          00047100
      GO TO 6000                                                        00047200
 5008 IERR = 8                                                          00047300
 6000 CONTINUE                                                          00047400
      RETURN                                                            00047500
      END                                                               00047600
      SUBROUTINE ROSSW (TRACE,NSAMP,EXP,IOPT,LCENTR,IERR)               00047700
C ******************************************************************** C00047800
C *                                                                  * C00047900
C *   PROGRAM - ROSSW                     ENTRY POINTS - ROSSW       * C00048000
C *   LANGUAGE - FORTRAN                                             * C00048100
C *   AUTHOR - GEORGE PIERSON                                        * C00048200
C *   DATE WRITTEN - 13 JUNE 83                                      * C00048300
C *   DATE MODIFIED - 24 AUG 83 BY RLC: ADDED COMMENTS               * C00048400
C *                   09/27/84 , SDL.  ADDITIONAL ERROR CHECKS AND   * C00048500
C *                              CHANGED INCREMENT FROM 1/CENTER TO  * C00048600
C *                              1/(CENTER-1) AND THE CENTER POINT   * C00048700
C *                              IS NOT RECOMPUTED.                  * C00048800
C *                                                                  * C00048900
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00049000
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00049100
C *                                                                  * C00049200
C *   ABSTRACT -                                                     * C00049300
C *                                                                  * C00049400
C *    SUBROUTINE TO COMPUTE AND APPLY A ROSS WEIGHTING FUNCTION.    * C00049500
C *                                                                  * C00049600
C *   USAGE                                                          * C00049700
C *                                                                  * C00049800
C *   CALL ROSSW (TRACE,NSAMP,EXP,IOPT,LCENTR,IERR)                  * C00049900
C *                                                                  * C00050000
C *       TRACE - DATA TO BE WEIGHTED.                               * C00050100
C *       NSAMP - NUMBER OF POINTS TO WEIGHT.                        * C00050200
C *         EXP - EXPONENT FOR WEIGHTING FUNCTION.                   * C00050300
C *        IOPT - WEIGHT CENTERING OPTION                            * C00050400
C *               0 = 1-SIDED WEIGHTING FUNCTION STARTING AT         * C00050500
C *                   SAMPLE 1.                                      * C00050600
C *               1 = CENTER ON MAXIMUM MAGNITUDE.                   * C00050700
C *               2 = USE LENGTH TO CENTER SPECIFIED.                * C00050800
C *               3 = USE MAXIMUM POSITIVE AMPLITUDE.                * C00050900
C *               4 = USE MAXIMUM NEGATIVE AMPLITUDE.                * C00051000
C *               5 = USE MIDDLE OF WINDOW.                          * C00051100
C *      LCENTR - LENGTH TO CENTER (VALID FOR IOPT = 2).             * C00051200
C *        IERR - ERROR RETURN                                       * C00051300
C *               0 - NO ERRORS.                                     * C00051400
C *               5 - INVALID WEIGHT CENTERING OPTION.               * C00051500
C *               6 - EXPONENT LESS THAN OR EQUAL TO ZERO.           * C00051600
C *              18 - LENGTH TO CENTER IS 0 FOR IOPT=2.              * C00051700
C *                                                                  * C00051800
C ******************************************************************** C00051900
      INTEGER*4 CENTER                                                  00052000
      DIMENSION TRACE(12000)                                            00052100
      IERR = 0                                                          00052200
      IF (NSAMP.LE.0) GO TO 1400                                        00052300
      IF (EXP.GT.0.0) GO TO 50                                          00052400
      IERR = 6                                                          00052500
      GO TO 10000                                                       00052600
C                                                                       00052700
   50 CONTINUE                                                          00052800
      IF (IOPT.EQ.0) GO TO 100                                          00052900
      IF (IOPT.EQ.1) GO TO 200                                          00053000
      IF (IOPT.EQ.2) GO TO 400                                          00053100
      IF (IOPT.EQ.3) GO TO 500                                          00053200
      IF (IOPT.EQ.4) GO TO 700                                          00053300
      IF (IOPT.EQ.5) GO TO 900                                          00053400
      IERR = 5                                                          00053500
      GO TO 10000                                                       00053600
C                                                                       00053700
  100 CONTINUE                                                          00053800
C *------------------------------------------------------------------* C00053900
C *    USE FIRST SAMPLE.                                             * C00054000
C *------------------------------------------------------------------* C00054100
      CENTER = 1                                                        00054200
      GO TO 1000                                                        00054300
C                                                                       00054400
  200 CONTINUE                                                          00054500
C *------------------------------------------------------------------* C00054600
C *    USE MAXIMUM MAGNITUDE.                                        * C00054700
C *------------------------------------------------------------------* C00054800
      TBIG = 0.                                                         00054900
      CENTER = 0                                                        00055000
C                                                                       00055100
      DO 300 I=1,NSAMP                                                  00055200
         IF (ABS(TRACE(I)).LE.TBIG) GO TO 300                           00055300
         CENTER = I                                                     00055400
         TBIG = ABS(TRACE(I))                                           00055500
  300 CONTINUE                                                          00055600
C                                                                       00055700
      GO TO 1000                                                        00055800
C                                                                       00055900
  400 CONTINUE                                                          00056000
C *------------------------------------------------------------------* C00056100
C *    USE LENGTH TO CENTER AS SPECIFIED.                            * C00056200
C *------------------------------------------------------------------* C00056300
      CENTER = LCENTR                                                   00056400
      IF (CENTER.LT.0) CENTER=-CENTER                                   00056500
      IF (CENTER.EQ.0) GO TO 5018                                       00056600
      GO TO 1000                                                        00056700
C                                                                       00056800
  500 CONTINUE                                                          00056900
C *------------------------------------------------------------------* C00057000
C *    USE MAXIMUM POSITIVE AMPLITUDE.                               * C00057100
C *------------------------------------------------------------------* C00057200
      TBIG = 0.                                                         00057300
      CENTER = 0                                                        00057400
C                                                                       00057500
      DO 600 I=1,NSAMP                                                  00057600
         IF (TRACE(I).LE.TBIG) GO TO 600                                00057700
         TBIG = TRACE(I)                                                00057800
         CENTER = I                                                     00057900
  600 CONTINUE                                                          00058000
C                                                                       00058100
      GO TO 1000                                                        00058200
C                                                                       00058300
  700 CONTINUE                                                          00058400
C *------------------------------------------------------------------* C00058500
C *    USE MAXIMUM NEGATIVE AMPLITUDE.                               * C00058600
C *------------------------------------------------------------------* C00058700
      CENTER = 0                                                        00058800
      TBIG = 0.0                                                        00058900
C                                                                       00059000
      DO 800 I=1,NSAMP                                                  00059100
         IF (TRACE(I).GE.TBIG) GO TO 800                                00059200
         CENTER = I                                                     00059300
         TBIG = TRACE(I)                                                00059400
  800 CONTINUE                                                          00059500
C                                                                       00059600
      GO TO 1000                                                        00059700
C                                                                       00059800
  900 CONTINUE                                                          00059900
C *------------------------------------------------------------------* C00060000
C *    USE THE MIDDLE OF THE DATA.                                   * C00060100
C *------------------------------------------------------------------* C00060200
      CENTER = NSAMP / 2 + 1                                            00060300
 1000 CONTINUE                                                          00060400
C *------------------------------------------------------------------* C00060500
C *    APPLY ROSS WEIGHT FOR LEFT SIDE OF CENTER.                    * C00060600
C *------------------------------------------------------------------* C00060700
      IF (CENTER.LE.0) GO TO 1400                                       00060800
      IF (CENTER.EQ.1) GO TO 1200                                       00060900
      LEN = CENTER - 1                                                  00061000
      XLEN = LEN                                                        00061100
      XLEN = 1.0 / XLEN                                                 00061200
C                                                                       00061300
      DO 1100 I=1,LEN                                                   00061400
         XI = CENTER - I                                                00061500
         XI = XI * XLEN                                                 00061600
         TRACE(I) = TRACE(I) * ((1.0 - XI * XI) ** EXP)                 00061700
 1100 CONTINUE                                                          00061800
C                                                                       00061900
 1200 CONTINUE                                                          00062000
C *------------------------------------------------------------------* C00062100
C *    APPLY ROSS WEIGHT FOR RIGHT SIDE OF CENTER.                   * C00062200
C *------------------------------------------------------------------* C00062300
      IF (CENTER.EQ.NSAMP) GO TO 1400                                   00062400
      LEN = NSAMP - CENTER + 1                                          00062500
      XLEN = LEN - 1                                                    00062600
      J = CENTER + 1                                                    00062700
      XLEN = 1.0 / XLEN                                                 00062800
C                                                                       00062900
      DO 1300 I=2,LEN                                                   00063000
         XI = I - 1                                                     00063100
         XI = XI * XLEN                                                 00063200
         TRACE(J) = TRACE(J) * ((1.0 - XI * XI) ** EXP)                 00063300
         J = J + 1                                                      00063400
 1300 CONTINUE                                                          00063500
C                                                                       00063600
 1400 CONTINUE                                                          00063700
      GO TO 10000                                                       00063800
 5018 IERR = 18                                                         00063900
10000 CONTINUE                                                          00064000
      RETURN                                                            00064100
      END                                                               00064200
      SUBROUTINE BESSLW (TRACE,NSAMP,EXP,IOPT,LCENTR,IERR)              00064300
C ******************************************************************** C00064400
C *                                                                  * C00064500
C *   PROGRAM - BESSLW                    ENTRY POINTS - BESSLW      * C00064600
C *   LANGUAGE - FORTRAN                                             * C00064700
C *   AUTHOR - SAM LILLY (MODIFIED ROSSW)                            * C00064800
C *   DATE WRITTEN - 04 OCTOBER 84                                   * C00064900
C *                                                                  * C00065000
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00065100
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00065200
C *                                                                  * C00065300
C *   ABSTRACT -                                                     * C00065400
C *                                                                  * C00065500
C *    SUBROUTINE TO COMPUTE AND APPLY A BESSEL WEIGHTING FUNCTION.  * C00065600
C *                                                                  * C00065700
C *   USAGE                                                          * C00065800
C *                                                                  * C00065900
C *   CALL BESSLW (TRACE,NSAMP,EXP,IOPT,LCENTR,IERR)                 * C00066000
C *                                                                  * C00066100
C *       TRACE - DATA TO BE WEIGHTED.                               * C00066200
C *       NSAMP - NUMBER OF POINTS TO WEIGHT.                        * C00066300
C *         EXP - EXPONENT FOR WEIGHTING FUNCTION.                   * C00066400
C *        IOPT - WEIGHT CENTERING OPTION                            * C00066500
C *               0 = 1-SIDED WEIGHTING FUNCTION STARTING AT         * C00066600
C *                   SAMPLE 1.                                      * C00066700
C *               1 = CENTER ON MAXIMUM MAGNITUDE.                   * C00066800
C *               2 = USE LENGTH TO CENTER SPECIFIED.                * C00066900
C *               3 = USE MAXIMUM POSITIVE AMPLITUDE.                * C00067000
C *               4 = USE MAXIMUM NEGATIVE AMPLITUDE.                * C00067100
C *               5 = USE MIDDLE OF WINDOW.                          * C00067200
C *      LCENTR - LENGTH TO CENTER (VALID FOR IOPT = 2).             * C00067300
C *        IERR - ERROR RETURN                                       * C00067400
C *               0 - NO ERRORS.                                     * C00067500
C *               5 - INVALID WEIGHT CENTERING OPTION.               * C00067600
C *               6 - EXPONENT LESS THAN OR EQUAL TO ZERO.           * C00067700
C *              18 - LENGTH TO CENTER IS 0 FOR IOPT=2.              * C00067800
C *                                                                  * C00067900
C ******************************************************************** C00068000
      INTEGER*4 CENTER                                                  00068100
      DIMENSION TRACE(12000)                                            00068200
      IERR = 0                                                          00068300
      EX = EXP                                                          00068400
      IF (NSAMP.LE.0) GO TO 1400                                        00068500
      IF (EXP.GT.0.0) GO TO 50                                          00068600
      IERR = 6                                                          00068700
      GO TO 10000                                                       00068800
C                                                                       00068900
   50 CONTINUE                                                          00069000
      IF (IOPT.EQ.0) GO TO 100                                          00069100
      IF (IOPT.EQ.1) GO TO 200                                          00069200
      IF (IOPT.EQ.2) GO TO 400                                          00069300
      IF (IOPT.EQ.3) GO TO 500                                          00069400
      IF (IOPT.EQ.4) GO TO 700                                          00069500
      IF (IOPT.EQ.5) GO TO 900                                          00069600
      IERR = 5                                                          00069700
      GO TO 10000                                                       00069800
C                                                                       00069900
  100 CONTINUE                                                          00070000
C *------------------------------------------------------------------* C00070100
C *    USE FIRST SAMPLE.                                             * C00070200
C *------------------------------------------------------------------* C00070300
      CENTER = 1                                                        00070400
      GO TO 1000                                                        00070500
C                                                                       00070600
  200 CONTINUE                                                          00070700
C *------------------------------------------------------------------* C00070800
C *    USE MAXIMUM MAGNITUDE.                                        * C00070900
C *------------------------------------------------------------------* C00071000
      TBIG = 0.                                                         00071100
      CENTER = 0                                                        00071200
C                                                                       00071300
      DO 300 I=1,NSAMP                                                  00071400
         IF (ABS(TRACE(I)).LE.TBIG) GO TO 300                           00071500
         CENTER = I                                                     00071600
         TBIG = ABS(TRACE(I))                                           00071700
  300 CONTINUE                                                          00071800
C                                                                       00071900
      GO TO 1000                                                        00072000
C                                                                       00072100
  400 CONTINUE                                                          00072200
C *------------------------------------------------------------------* C00072300
C *    USE LENGTH TO CENTER AS SPECIFIED.                            * C00072400
C *------------------------------------------------------------------* C00072500
      CENTER = LCENTR                                                   00072600
      IF (CENTER.LT.0) CENTER=-CENTER                                   00072700
      IF (CENTER.EQ.0) GO TO 5018                                       00072800
      GO TO 1000                                                        00072900
C                                                                       00073000
  500 CONTINUE                                                          00073100
C *------------------------------------------------------------------* C00073200
C *    USE MAXIMUM POSITIVE AMPLITUDE.                               * C00073300
C *------------------------------------------------------------------* C00073400
      TBIG = 0.                                                         00073500
      CENTER = 0                                                        00073600
C                                                                       00073700
      DO 600 I=1,NSAMP                                                  00073800
         IF (TRACE(I).LE.TBIG) GO TO 600                                00073900
         TBIG = TRACE(I)                                                00074000
         CENTER = I                                                     00074100
  600 CONTINUE                                                          00074200
C                                                                       00074300
      GO TO 1000                                                        00074400
C                                                                       00074500
  700 CONTINUE                                                          00074600
C *------------------------------------------------------------------* C00074700
C *    USE MAXIMUM NEGATIVE AMPLITUDE.                               * C00074800
C *------------------------------------------------------------------* C00074900
      CENTER = 0                                                        00075000
      TBIG = 0.0                                                        00075100
C                                                                       00075200
      DO 800 I=1,NSAMP                                                  00075300
         IF (TRACE(I).GE.TBIG) GO TO 800                                00075400
         CENTER = I                                                     00075500
         TBIG = TRACE(I)                                                00075600
  800 CONTINUE                                                          00075700
C                                                                       00075800
      GO TO 1000                                                        00075900
C                                                                       00076000
  900 CONTINUE                                                          00076100
C *------------------------------------------------------------------* C00076200
C *    USE THE MIDDLE OF THE DATA.                                   * C00076300
C *------------------------------------------------------------------* C00076400
      CENTER = NSAMP / 2 + 1                                            00076500
 1000 CONTINUE                                                          00076600
C *------------------------------------------------------------------* C00076700
C *    APPLY BESSEL WEIGHT FOR LEFT SIDE OF CENTER.                  * C00076800
C *------------------------------------------------------------------* C00076900
      IF (CENTER.LE.0) GO TO 1400                                       00077000
      IF (CENTER.EQ.1) GO TO 1200                                       00077100
      LEN = CENTER - 1                                                  00077200
      XLEN = LEN                                                        00077300
      XLEN = 1.0 / XLEN                                                 00077400
      DEN=1.                                                            00077500
      DS=1.                                                             00077600
      D=0.                                                              00077700
 1003 D=D+2.                                                            00077800
      DS=DS*EX*EX/(D*D)                                                 00077900
      DEN=DEN+DS                                                        00078000
      IF(DS .GT. .2E-8*DEN) GO TO 1003                                  00078100
C                                                                       00078200
      DO 1100 I=1,LEN                                                   00078300
         XI = CENTER - I                                                00078400
         XI = XI * XLEN                                                 00078500
         EXX=EX*SQRT(1. - XI * XI)                                      00078600
         ANUM=1.                                                        00078700
         DS=1.                                                          00078800
         D=0.                                                           00078900
 1004    D=D+2.                                                         00079000
         DS=DS*EXX*EXX/(D*D)                                            00079100
         ANUM=ANUM+DS                                                   00079200
         IF(DS .GT. .2E-8*ANUM) GO TO 1004                              00079300
         TRACE(I) = TRACE(I) * ANUM / DEN                               00079400
 1100 CONTINUE                                                          00079500
C                                                                       00079600
 1200 CONTINUE                                                          00079700
C *------------------------------------------------------------------* C00079800
C *    APPLY BESSEL WEIGHT FOR RIGHT SIDE OF CENTER.                 * C00079900
C *------------------------------------------------------------------* C00080000
      IF (CENTER.EQ.NSAMP) GO TO 1400                                   00080100
      LEN = NSAMP - CENTER + 1                                          00080200
      XLEN = LEN - 1                                                    00080300
      J = CENTER + 1                                                    00080400
      XLEN = 1.0 / XLEN                                                 00080500
      DEN=1.                                                            00080600
      DS=1.                                                             00080700
      D=0.                                                              00080800
 1203 D=D+2.                                                            00080900
      DS=DS*EX*EX/(D*D)                                                 00081000
      DEN=DEN+DS                                                        00081100
      IF(DS .GT. .2E-8*DEN) GO TO 1203                                  00081200
C                                                                       00081300
      DO 1300 I=2,LEN                                                   00081400
         XI = I - 1                                                     00081500
         XI = XI * XLEN                                                 00081600
         EXX=EX*SQRT(1. - XI * XI)                                      00081700
         ANUM=1.                                                        00081800
         DS=1.                                                          00081900
         D=0.                                                           00082000
 1204    D=D+2.                                                         00082100
         DS=DS*EXX*EXX/(D*D)                                            00082200
         ANUM=ANUM+DS                                                   00082300
         IF(DS .GT. .2E-8*ANUM) GO TO 1204                              00082400
         TRACE(J) = TRACE(J) * ANUM / DEN                               00082500
         J = J + 1                                                      00082600
 1300 CONTINUE                                                          00082700
C                                                                       00082800
 1400 CONTINUE                                                          00082900
      GO TO 10000                                                       00083000
 5018 IERR = 18                                                         00083100
10000 CONTINUE                                                          00083200
      RETURN                                                            00083300
      END                                                               00083400
      SUBROUTINE IDEF (FMAX,ISI,LF,FILTR,EXP,IERR)                      00083500
C ******************************************************************** C00083600
C *                                                                  * C00083700
C *   PROGRAM - IDEF                     ENTRY POINTS - IDEF         * C00083800
C *   LANGUAGE - FORTRAN                                             * C00083900
C *   AUTHOR - KEN PEACOCK                                           * C00084000
C *   DATE WRITTEN - 10/06/76                                        * C00084100
C *   DATE LAST MODIFIED - 02/15/76                                  * C00084200
C *        CONVERTED TO INTERDATA - GEORGE PIERSON                   * C00084300
C *                        09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00084400
C *                                                                  * C00084500
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00084600
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00084700
C *                                                                  * C00084800
C *   ABSTRACT                                                       * C00084900
C *                                                                  * C00085000
C *    SUBROUTINE TO CONSTRUCT THE OPERATOR FOR THE IDEAL HIGHCUT    * C00085100
C *    (LOWPASS) FILTER WITH OPTIONAL ROSS WEIGHTING.                * C00085200
C *                                                                  * C00085300
C *   USAGE                                                          * C00085400
C *                                                                  * C00085500
C *       CALL IDEF (FMAX,ISI,LF,FILTR,EXP,IERR)                     * C00085600
C *                                                                  * C00085700
C *            FMAX - LIMITING FREQUENCY TO PASS.                    * C00085800
C *             ISI - SAMPLE INTERVAL IN MSEC.                       * C00085900
C *              LF - LENGTH OF FILTER IN SAMPLES - MUST BE ODD.     * C00086000
C *           FILTR - OPERATOR ARRAY.                                * C00086100
C *             EXP - .LE. 0, NO WEIGHTING WILL BE DONE.             * C00086200
C *                   .GT. 0, USE ROSS WEIGHT FUNCTION WITH          * C00086300
C *                           EXPONENT EXP.                          * C00086400
C *            IERR - ERROR CODE.                                    * C00086500
C *                   0 - NO ERRORS.                                 * C00086600
C *                   4 - SAMPLE INTERVAL IS LESS THAN 1.            * C00086700
C *                   7 - LF MUST BE ODD.                            * C00086800
C *                   8 - LIMITING FREQUENCY IS 0.                   * C00086900
C *                                                                  * C00087000
C *                                                                  * C00087100
C ******************************************************************** C00087200
C                                                                       00087300
      DIMENSION FILTR(1001)                                             00087400
C                                                                       00087500
      REAL*8 PI                                                         00087600
      REAL*8 FACT1,FACT2,AK                                             00087700
	real*8 xn
      DATA PI/3.14159265358979323846D0/                                 00087800
C                                                                       00087900
      IERR = 0                                                          00088000
      IF (FMAX.EQ.0.) GO TO 5008                                        00088100
      IF (ISI .LT. 1) GO TO 5004                                        00088200
      FISI = FLOAT(ISI)*.001                                            00088300
C                                                                       00088400
      FACT2 = PI*DBLE(FISI)                                             00088500
      FACT1 = 2.0D0 * DBLE(FMAX) * FACT2                                00088600
      IF(LF.LT.0) LF=-LF                                                00088700
      N = LF / 2                                                        00088800
	xn = n
      IF (N*2 .NE. LF) GO TO 50                                         00088900
      IERR = 7                                                          00089000
      GO TO 300                                                         00089100
C                                                                       00089200
  50  ISTA = N + 2                                                      00089300
      KFACT = 1 - ISTA                                                  00089400
      JFACT = LF + 1                                                    00089500
C                                                                       00089600
      DO 100 I=ISTA,LF                                                  00089700
         AK = I + KFACT                                                 00089800
         FILTR(I) = DSIN(FACT1*AK) / (FACT2 * AK)*DBLE(FISI)            00089900
         J = JFACT - I                                                  00090000
         FILTR(J) = FILTR(I)                                            00090100
  100 CONTINUE                                                          00090200
C                                                                       00090300
      FILTR(ISTA-1) = 2. * FMAX * FISI                                  00090400
      IF (EXP.LE.0.0) GO TO 300                                         00090500
C                                                                       00090600
CCC   DO 200 I=ISTA,LF                                                  00090700
      DO 200 I=ISTA,LF-1
         AK = I + KFACT                                                 00090800
         FILTR(I) = FILTR(I) * ((1. - (AK /xn) ** 2) ** EXP)
CCC      FILTR(I) = FILTR(I) * ((1. - (AK / N) ** 2) ** EXP)            00090900
         J = JFACT - I                                                  00091000
         FILTR(J) = FILTR(I)                                            00091100
  200 CONTINUE                                                          00091200
	filtr(lf) = 0.0
	filtr(1) = 0.0
      GO TO 300                                                         00091300
C                                                                       00091400
C                                                                       00091500
 5004 IERR = 4                                                          00091600
      GO TO 300                                                         00091700
 5008 IERR = 8                                                          00091800
  300 CONTINUE                                                          00091900
      RETURN                                                            00092000
      END                                                               00092100
      SUBROUTINE IDEF3(FMAX,DELT,EXP,LF,FILTR,IERR)                     00092200
C ******************************************************************** C00092300
C *                                                                  * C00092400
C *   PROGRAM - IDEF3                    ENTRY POINTS - IDEF3        * C00092500
C *   LANGUAGE - FORTRAN                                             * C00092600
C *   AUTHOR - KEN PEACOCK                                           * C00092700
C *   DATE WRITTEN - 07/22/83                                        * C00092800
C *   DATE MODIFIED - 09/27/84, SDL.  ADDITIONAL ERROR CHECKS.       * C00092900
C *                                                                  * C00093000
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00093100
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00093200
C *                                                                  * C00093300
C *   ABSTRACT                                                       * C00093400
C *                                                                  * C00093500
C *    SUBROUTINE IDEF3 CONSTRUCTS THE OPERATOR FOR THE IDEAL HICUT  * C00093600
C *    (LOWPASS) FILTER WITH BESSEL WEIGHTING.  IDEF3 DIFFERS FROM   * C00093700
C *    IDEF2 IN THAT NO FURTHER SUBROUTINES ARE CALLED.              * C00093800
C *            FMAX - LIMITING FREQUENCY TO PASS.                    * C00093900
C *            DELT - SAMPLE INTERVAL IN SECONDS.                    * C00094000
C *             EXP - .LE. 0 = NO WEIGHTING WILL BE DONE.            * C00094100
C *                   .GT. 0 = USE A BESSEL WEIGHT FUNCTION WITH     * C00094200
C *                            EXPONENT EXP.                         * C00094300
C *              LF - LENGTH OF FILTER IN SAMPLES.   LF MUST BE ODD. * C00094400
C *           FILTR - OUTPUT ARRAY FOR FILTER OF LENGTH LF.          * C00094500
C *            IERR - ERROR FLAG.                                    * C00094600
C *                   0 = NO ERRORS.                                 * C00094700
C *                   4 = SAMPLE INTERVAL IS LESS THAN 1.            * C00094800
C *                   7 = LF MUST BE ODD.                            * C00094900
C *                   8 = LIMITING FREQUENCY IS 0.                   * C00095000
C *     CODED FOR THE IBM 370/158 COMPUTER.                          * C00095100
C *     VERSION AS OF 7-22-83.                                       * C00095200
C ******************************************************************** C00095300
C                                                                       00095400
      DIMENSION FILTR(1001)                                             00095500
      IERR = 0                                                          00095600
      IF (FMAX.EQ.0.) GO TO 5008                                        00095700
      IF (DELT.LE.0) GO TO 5004                                         00095800
      FACT1 = 2.*3.1415927*FMAX*DELT                                    00095900
      FACT2 = 3.1415927*DELT                                            00096000
      EX=EXP                                                            00096100
      IF (LF.LT.0) LF=-LF                                               00096200
      N = LF / 2                                                        00096300
	xn = n
      IF (N*2.EQ.LF) GO TO 5007                                         00096400
      ISTA=N+2                                                          00096500
      KFACT=1-ISTA                                                      00096600
      JFACT=LF+1                                                        00096700
      DO 1 I=ISTA,LF                                                    00096800
      AK=I+KFACT                                                        00096900
      FILTR(I)=SIN(FACT1*AK)/(FACT2*AK)*DELT                            00097000
      J= JFACT-I                                                        00097100
   1  FILTR(J)=FILTR(I)                                                 00097200
      FILTR(ISTA-1) = 2.*FMAX*DELT                                      00097300
         DO 2 I = ISTA,LF                                               00097400
         J=JFACT-I                                                      00097500
   2  FILTR(J)=FILTR(I)                                                 00097600
      IF(EX .LE. 0) GO TO 6                                             00097700
      DEN=1.                                                            00097800
      DS=1.                                                             00097900
      D=0.                                                              00098000
   3  D=D+2.                                                            00098100
      DS=DS*EX*EX/(D*D)                                                 00098200
      DEN=DEN+DS                                                        00098300
      IF(DS .GT. .2E-8*DEN) GO TO 3                                     00098400
      DO 5 I = ISTA,LF                                                  00098500
         AK = I + KFACT                                                 00098600
         EXX=EX*SQRT((abs(1.-(AK/xn)))**2)
CCC      EXX=EX*SQRT(1.-(AK/N)**2)                                      00098700
         ANUM=1.                                                        00098800
         DS=1.                                                          00098900
         D=0.                                                           00099000
   4     D=D+2.                                                         00099100
         DS=DS*EXX*EXX/(D*D)                                            00099200
         ANUM=ANUM+DS                                                   00099300
         IF(DS .GT. .2E-8*ANUM) GO TO 4                                 00099400
         FILTR(I)=FILTR(I)*ANUM/DEN                                     00099500
         J=JFACT-I                                                      00099600
   5     FILTR(J) = FILTR(I)                                            00099700
   6     CONTINUE                                                       00099800
         GO TO 6000                                                     00099900
 5007    IERR = 7                                                       00100000
         GO TO 6000                                                     00100100
 5004    IERR = 4                                                       00100200
         GO TO 6000                                                     00100300
 5008    IERR = 8                                                       00100400
 6000    RETURN                                                         00100500
         END                                                            00100600
      SUBROUTINE ROSSF (ISI,NSAMP,MAXLEN,FREQ,                          00100700
     *                  IDB,INVERT,LF,FILTR,IERR)                       00100800
C ******************************************************************** C00100900
C *                                                                  * C00101000
C *   PROGRAM - ROSSF                     ENTRY POINTS - ROSSF       * C00101100
C *   LANGUAGE - FORTRAN                                             * C00101200
C *   AUTHOR -                                                       * C00101300
C *   DATE WRITTEN -                                                 * C00101400
C *   DATE LAST MODIFIED -  09/27/84, SDL. ADDITIONAL ERROR CHECKS.  * C00101500
C *                                                                  * C00101600
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00101700
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00101800
C *                                                                  * C00101900
C *   ABSTRACT -                                                     * C00102000
C *                                                                  * C00102100
C *    SUBROUTINE TO COMPUTE A ROSS-WEIGHTED FILTER WITH SPECIFIED   * C00102200
C *    REJECT LEVEL.                                                 * C00102300
C *                                                                  * C00102400
C *   SUBROUTINES CALLED -                                           * C00102500
C *                                                                  * C00102600
C *   LENGTH  TRUNCT  OPERAT  COMBIN                                 * C00102700
C *                                                                  * C00102800
C *   USAGE -                                                        * C00102900
C *   CALL ROSSF (ISI,NSAMP,MAXLEN,FREQ,IDB,INVERT,LF,FILTR,IERR)    * C00103000
C *                                                                  * C00103100
C *        ISI - PROCESSING SAMPLE INTERVAL IN MSEC.                 * C00103200
C *      NSAMP - LENGTH OF DATA TO BE FILTERED.                      * C00103300
C *     MAXLEN - MAXIMUM FILTER LENGTH ALLOWED.                      * C00103400
C *       FREQ - FREQUENCY ARRAY. CONTAINS F1,F2,F3, AND F4,         * C00103500
C *              IN ORDER.                                           * C00103600
C *        IDB - ATTENUATION (REJECT) LEVEL. IF THIS PARAMETER IS    * C00103700
C *              0, A VALUE OF 65 WILL BE USED. IF LF TRUNCATION     * C00103800
C *              OCCURRED IN COMPUTING THE FILTER, THE VALUE USED    * C00103900
C *              IS RETURNED.                                        * C00104000
C *     INVERT - INVERT FILTER:                                      * C00104100
C *              0 - DO NOT INVERT FILTER OPERATOR.                  * C00104200
C *              1 - INVERT FILTER OPERATOR.                         * C00104300
C *         LF - FILTER LENGTH COMPUTED AND RETURNED.                * C00104400
C *      FILTR - FILTER ARRAY COMPUTED AND RETURNED.                 * C00104500
C *       IERR - ERROR CONDITION CODE.                               * C00104600
C *              0=NO ERRORS.                                        * C00104700
C *              1=FREQUENCY VALUES ARE NOT ASCENDING.               * C00104800
C *              2=ONE OR MORE INPUT FREQUENCIES EXCEED NYQUIST      * C00104900
C *                FOR THE DATA.                                     * C00105000
C *              4=SAMPLE INTERVAL IS LESS THAN 1.                   * C00105100
C *              8=OUT/OUT FILTER SPECIFIED.                         * C00105200
C *              9=REJECT LEVEL IS LESS THAN 21 DB OR GREATER THAN   * C00105300
C *                120 DB.                                           * C00105400
C *             10=MAXIMUM FILTER LENGTH CANNOT BE 0.                * C00105500
C *                                                                  * C00105600
C ******************************************************************** C00105700
C                                                                       00105800
      REAL*4 OPLOW(1001),OPHI(1001),FILTR(1001)                         00105900
      REAL*4 WORKSP(1001)                                               00106000
C                                                                       00106100
      EQUIVALENCE (OPLOW(1),WORKSP(1))                                  00106200
C                                                                       00106300
      INTEGER*4 FREQ(4)                                                 00106400
      INTEGER*4 PERCNT                                                  00106500
      INTEGER*4 HTRUNC                                                  00106600
C                                                                       00106700
      DATA PERCNT/5/                                                    00106800
      DATA ITYPE/1/                                                     00106900
C                                                                       00107000
      IERR = 0                                                          00107100
      LF = 0                                                            00107200
C                                                                       00107300
C-----------------------------------------------------------------------00107400
C     ASSIGN ATTENUATION LEVEL VALUE                                    00107500
C-----------------------------------------------------------------------00107600
C                                                                       00107700
      IF (IDB.EQ.0) IDB = 65                                            00107800
      IF (IDB.LT.0) GO TO 5009                                          00107900
      DB = IDB                                                          00108000
C                                                                       00108100
C-----------------------------------------------------------------------00108200
C                    INITIALIZE VARIABLES.                              00108300
C-----------------------------------------------------------------------00108400
C                                                                       00108500
      IF (ISI.LT.1) GO TO 5004                                          00108600
      NYQIST = 500 / ISI                                                00108700
      DELT = FLOAT(ISI) * .001                                          00108800
      IF (MAXLEN.LE.0) GO TO 5010                                       00108900
C                                                                       00109000
      LENLO = 0                                                         00109100
      LENHI = 0                                                         00109200
C                                                                       00109300
      LTRUNC = 0                                                        00109400
      HTRUNC = 0                                                        00109500
C                                                                       00109600
C-----------------------------------------------------------------------00109700
C     CHECK FREQUENCIES 1 THROUGH 4 AGAINST THE NYQUIST LIMIT.          00109800
C-----------------------------------------------------------------------00109900
C                                                                       00110000
      IF ( FREQ(1) .GT. NYQIST) GO TO 5002                              00110100
      IF ( FREQ(2) .GT. NYQIST) GO TO 5002                              00110200
      IF ( FREQ(3) .GT. NYQIST) GO TO 5002                              00110300
      IF ( FREQ(4) .GT. NYQIST) GO TO 5002                              00110400
C                                                                       00110500
C-----------------------------------------------------------------------00110600
C             CHECK FOR OUT/OUT FILTER CONDITIONS.                      00110700
C-----------------------------------------------------------------------00110800
C                                                                       00110900
      IF (FREQ(1) .NE. 0 .OR. FREQ(2) .NE. 0) GO TO 100                 00111000
      IF (FREQ(3) .NE. 0 .OR. FREQ(4) .NE. 0) GO TO 200                 00111100
C                                                                       00111200
      IERR = 8                                                          00111300
      GO TO 6000                                                        00111400
C                                                                       00111500
  100 IF (FREQ(1) .GE. FREQ(2) ) GO TO 5001                             00111600
C                                                                       00111700
C-----------------------------------------------------------------------00111800
C                      LOWCUT OPERATOR.                                 00111900
C-----------------------------------------------------------------------00112000
C                                                                       00112100
      F1 = FREQ(1)                                                      00112200
      F2 = FREQ(2)                                                      00112300
      CALL LENGT2 (ITYPE,DB,DELT,F1,F2,MAXLEN,LENLO,LTRUNC,IERR)        00112400
c++   CALL LENGTH (ITYPE,DB,DELT,F1,F2,MAXLEN,LENLO,LTRUNC,IERR)        00112400
      IF (IERR.NE.0 .AND. IERR.NE.9) GO TO 6000                         00112500
C                                                                       00112600
      IF (FREQ(3) .EQ. 0 .AND. FREQ(4) .EQ. 0) GO TO 300                00112700
C                                                                       00112800
C-----------------------------------------------------------------------00112900
C                      BANDPASS OPERATOR.                               00113000
C-----------------------------------------------------------------------00113100
C                                                                       00113200
      IF (FREQ(2) .GT. FREQ(3)) GO TO 5001                              00113300
C                                                                       00113400
C-----------------------------------------------------------------------00113500
C                      HIGHCUT OPERATOR.                                00113600
C-----------------------------------------------------------------------00113700
C                                                                       00113800
  200 IF (FREQ(3) .GE. FREQ(4) ) GO TO 5001                             00113900
C                                                                       00114000
      F3 = FREQ(3)                                                      00114100
      F4 = FREQ(4)                                                      00114200
      CALL LENGT2 (ITYPE,DB,DELT,F3,F4,MAXLEN,LENHI,HTRUNC,IERR)        00114300
c++   CALL LENGTH (ITYPE,DB,DELT,F3,F4,MAXLEN,LENHI,HTRUNC,IERR)        00114300
      IF (IERR.NE.0 .AND. IERR.NE.9) GO TO 6000                         00114400
C                                                                       00114500
C-----------------------------------------------------------------------00114600
C       CHECK TO SEE IF OPERATOR LENGTHS ARE WITHIN LIMITS              00114700
C-----------------------------------------------------------------------00114800
C                                                                       00114900
  300 CALL TRUNCT (LENLO,LENHI,NSAMP,PERCNT,LTRUNC,HTRUNC,IERR)         00115000
C                                                                       00115100
C-----------------------------------------------------------------------00115200
C                GENERATE LOW CUT OPERATOR.                             00115300
C-----------------------------------------------------------------------00115400
C                                                                       00115500
      IF (LENLO .GT. 0)                                                 00115600
     * CALL OPERAT (ITYPE,LENLO,DELT,                                   00115700
     *               LTRUNC,DB,F1,F2,OPLOW,IERR)                        00115800
      IF (IERR.NE.0 .AND. IERR.NE.9) GO TO 6000                         00115900
C                                                                       00116000
C-----------------------------------------------------------------------00116100
C               GENERATE HIGH CUT OPERATOR.                             00116200
C-----------------------------------------------------------------------00116300
C                                                                       00116400
      IF (LENHI .GT. 0)                                                 00116500
     * CALL OPERAT (ITYPE,LENHI,DELT,                                   00116600
     *               HTRUNC,DB,F3,F4,OPHI,IERR)                         00116700
C                                                                       00116800
      IF (IERR.NE.0 .AND. IERR.NE.9) GO TO 6000                         00116900
C                                                                       00117000
C-----------------------------------------------------------------------00117100
C    GENERATE FILTER BY COMBINING LOWCUT AND HIGHCUT OPERATORS.         00117200
C-----------------------------------------------------------------------00117300
C                                                                       00117400
      CALL COMBIN (LENLO,LENHI,OPLOW,OPHI,LF,FILTR,IERR)                00117500
      IDB=DB                                                            00117600
      IF (IDB.LT.21 .OR. IDB.GT.120) IERR=9                             00117700
C                                                                       00117800
      IF (INVERT .NE. 1) GO TO 6000                                     00117900
C                                                                       00118000
C-----------------------------------------------------------------------00118100
C          OTHERWISE INVERT FILTER BY NEGATING EACH ELEMENT.            00118200
C-----------------------------------------------------------------------00118300
C                                                                       00118400
      DO 400 I=1,LF                                                     00118500
         FILTR (I) = - FILTR (I)                                        00118600
  400 CONTINUE                                                          00118700
C                                                                       00118800
      GO TO 6000                                                        00118900
C                                                                       00119000
C-----------------------------------------------------------------------00119100
C------------------ ERROR CONDITION CODES. -----------------------------00119200
C-----------------------------------------------------------------------00119300
C                                                                       00119400
 5001 IERR = 1                                                          00119500
      GO TO 6000                                                        00119600
C                                                                       00119700
 5009 IERR = 9                                                          00119800
      GO TO 6000                                                        00119900
C                                                                       00120000
 5002 IERR = 2                                                          00120100
      GO TO 6000                                                        00120200
 5010 IERR = 10                                                         00120300
      GO TO 6000                                                        00120400
 5004 IERR = 4                                                          00120500
 6000 RETURN                                                            00120600
C                                                                       00120700
      END                                                               00120800
      SUBROUTINE BESSLK (ISI,NSAMP,MAXLEN,FREQ,                         00120900
     *                   IDB,INVERT,LF,FILTR,IERR)                      00121000
C ******************************************************************** C00121100
C *                                                                  * C00121200
C *   PROGRAM - BESSLK                    ENTRY POINTS - BESSLK      * C00121300
C *   LANGUAGE - FORTRAN                                             * C00121400
C *   AUTHOR -                                                       * C00121500
C *   DATE WRITTEN -                                                 * C00121600
C *   DATE LAST MODIFIED - 09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00121700
C *                                                                  * C00121800
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00121900
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00122000
C *                                                                  * C00122100
C *   ABSTRACT -                                                     * C00122200
C *                                                                  * C00122300
C *    SUBROUTINE TO COMPUTE A BESSEL-WEIGHTED FILTER (ALSO CALLED   * C00122400
C *    KAISER) WITH SPECIFIED REJECT LEVEL.                          * C00122500
C *                                                                  * C00122600
C *   SUBROUTINES CALLED -                                           * C00122700
C *                                                                  * C00122800
C *   LENGTH  TRUNCT  OPERAT  COMBIN                                 * C00122900
C *                                                                  * C00123000
C *   USAGE -                                                        * C00123100
C *   CALL BESSLK(ISI,NSAMP,MAXLEN,FREQ,IDB,INVERT,LF,FILTR,IERR)    * C00123200
C *                                                                  * C00123300
C *        ISI - PROCESSING SAMPLE INTERVAL IN MSEC.                 * C00123400
C *      NSAMP - LENGTH OF DATA TO BE FILTERED.                      * C00123500
C *     MAXLEN - MAXIMUM FILTER LENGTH ALLOWED.                      * C00123600
C *       FREQ - FREQUENCY ARRAY. CONTAINS F1,F2,F3, AND F4          * C00123700
C *              IN ORDER (INTEGER VALUES).                          * C00123800
C *        IDB - REJECT (ATTENUATION) LEVEL.  IF THIS VALUE IS       * C00123900
C *              0, A VALUE OF 65 WILL BE USED. IF LF TRUNCATION     * C00124000
C *              OCCURRED IN COMPUTING THE FILTER, THE VALUE USED    * C00124100
C *              IS RETURNED.                                        * C00124200
C *     INVERT - INVERT FILTER:                                      * C00124300
C *              0 - DO NOT INVERT FILTER OPERATOR.                  * C00124400
C *              1 - INVERT FILTER OPERATOR.                         * C00124500
C *         LF - FILTER LENGTH COMPUTED AND RETURNED.                * C00124600
C *      FILTR - FILTER ARRAY COMPUTED AND RETURNED.                 * C00124700
C *       IERR - ERROR RETURN                                        * C00124800
C *              0 - NO ERRORS.                                      * C00124900
C *              1 - FREQUENCY VALUES ARE NOT ASCENDING.             * C00125000
C *              2 - ONE OR MORE INPUT FREQUENCIES EXCEED NYQUIST    * C00125100
C *                  FOR THE DATA.                                   * C00125200
C *              4 - SAMPLE RATE IS LESS THAN 1.                     * C00125300
C *              8 - OUT/OUT FILTER SPECIFIED.                       * C00125400
C *              9 - REJECT LEVEL IS LESS THAN 21 DB OR GREATER      * C00125500
C *                  THAN 120 DB.                                    * C00125600
C *             10 - MAXIMUM FILTER LENGTH SHOULD BE GREATER THAN 0. * C00125700
C *                                                                  * C00125800
C ******************************************************************** C00125900
C                                                                       00126000
      REAL*4    OPLOW(1001),OPHI(1001),FILTR(1001)                      00126100
      REAL*4    WORKSP(1001)                                            00126200
C                                                                       00126300
      EQUIVALENCE (OPLOW(1),WORKSP(1))                                  00126400
C                                                                       00126500
      INTEGER*4 FREQ(4)                                                 00126600
      INTEGER*4 PERCNT                                                  00126700
      INTEGER*4 HTRUNC                                                  00126800
C                                                                       00126900
      DATA PERCNT/5/                                                    00127000
      DATA ITYPE/2/                                                     00127100
C                                                                       00127200
      IERR = 0                                                          00127300
      LF = 0                                                            00127400
      IF (ISI.LT.1) GO TO 5004                                          00127500
C                                                                       00127600
C-----------------------------------------------------------------------00127700
C     ASSIGN ATTENUATION LEVEL VALUE                                    00127800
C-----------------------------------------------------------------------00127900
C                                                                       00128000
      IF(IDB.EQ.0)IDB=65                                                00128100
      IF (IDB.LT.0) GO TO 5009                                          00128200
      DB = IDB                                                          00128300
C                                                                       00128400
C-----------------------------------------------------------------------00128500
C                    INITIALIZE VARIABLES.                              00128600
C-----------------------------------------------------------------------00128700
C                                                                       00128800
      NYQIST = 500 / ISI                                                00128900
      DELT = FLOAT(ISI) * .001                                          00129000
      IF (MAXLEN.LE.0) GO TO 5010                                       00129100
C                                                                       00129200
      LENLO = 0                                                         00129300
      LENHI = 0                                                         00129400
C                                                                       00129500
      LTRUNC = 0                                                        00129600
      HTRUNC = 0                                                        00129700
C                                                                       00129800
C-----------------------------------------------------------------------00129900
C     CHECK FREQUENCIES 1 THROUGH 4 AGAINST THE NYQUIST LIMIT.          00130000
C-----------------------------------------------------------------------00130100
C                                                                       00130200
      IF ( FREQ(1) .GT. NYQIST) GO TO 5002                              00130300
      IF ( FREQ(2) .GT. NYQIST) GO TO 5002                              00130400
      IF ( FREQ(3) .GT. NYQIST) GO TO 5002                              00130500
      IF ( FREQ(4) .GT. NYQIST) GO TO 5002                              00130600
C                                                                       00130700
C-----------------------------------------------------------------------00130800
C             CHECK FOR OUT/OUT FILTER CONDITIONS.                      00130900
C-----------------------------------------------------------------------00131000
C                                                                       00131100
      IF (FREQ(1) .NE. 0 .OR. FREQ(2) .NE. 0) GO TO 100                 00131200
      IF (FREQ(3) .NE. 0 .OR. FREQ(4) .NE. 0) GO TO 200                 00131300
C                                                                       00131400
      IERR = 8                                                          00131500
      GO TO 6000                                                        00131600
C                                                                       00131700
  100 IF (FREQ(1) .GE. FREQ(2) ) GO TO 5001                             00131800
C                                                                       00131900
C-----------------------------------------------------------------------00132000
C                      LOWCUT OPERATOR.                                 00132100
C-----------------------------------------------------------------------00132200
C                                                                       00132300
      F1 = FREQ(1)                                                      00132400
      F2 = FREQ(2)                                                      00132500
      CALL LENGT2 (ITYPE,DB,DELT,F1,F2,MAXLEN,LENLO,LTRUNC,IERR)        00132600
c++   CALL LENGTH (ITYPE,DB,DELT,F1,F2,MAXLEN,LENLO,LTRUNC,IERR)        00132600
      IF (IERR.NE.0 .AND. IERR.NE.9) GO TO 6000                         00132700
C                                                                       00132800
      IF (FREQ(3) .EQ. 0 .AND. FREQ(4) .EQ. 0) GO TO 300                00132900
C                                                                       00133000
C-----------------------------------------------------------------------00133100
C                      BANDPASS OPERATOR.                               00133200
C-----------------------------------------------------------------------00133300
C                                                                       00133400
      IF (FREQ(2) .GT. FREQ(3)) GO TO 5001                              00133500
C                                                                       00133600
C-----------------------------------------------------------------------00133700
C                      HIGHCUT OPERATOR.                                00133800
C-----------------------------------------------------------------------00133900
C                                                                       00134000
  200 IF (FREQ(3) .GE. FREQ(4) ) GO TO 5001                             00134100
C                                                                       00134200
      F3 = FREQ(3)                                                      00134300
      F4 = FREQ(4)                                                      00134400
      CALL LENGT2 (ITYPE,DB,DELT,F3,F4,MAXLEN,LENHI,HTRUNC,IERR)        00134500
c++   CALL LENGTH (ITYPE,DB,DELT,F3,F4,MAXLEN,LENHI,HTRUNC,IERR)        00134500
      IF (IERR.NE.0 .AND. IERR.NE.9) GO TO 6000                         00134600
C                                                                       00134700
C-----------------------------------------------------------------------00134800
C       CHECK TO SEE IF OPERATOR LENGTHS ARE WITHIN LIMITS              00134900
C-----------------------------------------------------------------------00135000
C                                                                       00135100
  300 CALL TRUNCT (LENLO,LENHI,NSAMP,PERCNT,LTRUNC,HTRUNC,IERR)         00135200
C                                                                       00135300
C-----------------------------------------------------------------------00135400
C                GENERATE LOW CUT OPERATOR.                             00135500
C-----------------------------------------------------------------------00135600
C                                                                       00135700
      IF (LENLO .GT. 0)                                                 00135800
     * CALL OPERAT (ITYPE,LENLO,DELT,                                   00135900
     *               LTRUNC,DB,F1,F2,OPLOW,IERR)                        00136000
      IF (IERR .NE. 0 .AND. IERR .NE. 9) GO TO 6000                     00136100
C                                                                       00136200
C-----------------------------------------------------------------------00136300
C               GENERATE HIGH CUT OPERATOR.                             00136400
C-----------------------------------------------------------------------00136500
C                                                                       00136600
      IF (LENHI .GT. 0)                                                 00136700
     * CALL OPERAT (ITYPE,LENHI,DELT,                                   00136800
     *               HTRUNC,DB,F3,F4,OPHI,IERR)                         00136900
C                                                                       00137000
      IF (IERR .NE. 0 .AND. IERR .NE. 9) GO TO 6000                     00137100
C                                                                       00137200
C-----------------------------------------------------------------------00137300
C    GENERATE FILTER BY COMBINING LOWCUT AND HIGHCUT OPERATORS.         00137400
C-----------------------------------------------------------------------00137500
C                                                                       00137600
      CALL COMBIN (LENLO,LENHI,OPLOW,OPHI,LF,FILTR,IERR)                00137700
      IDB=DB                                                            00137800
      IF (IDB.LT.21 .OR. IDB.GT.120) IERR=9                             00137900
C                                                                       00138000
      IF (INVERT .NE. 1) GO TO 6000                                     00138100
C                                                                       00138200
C-----------------------------------------------------------------------00138300
C          OTHERWISE INVERT FILTER BY NEGATING EACH ELEMENT.            00138400
C-----------------------------------------------------------------------00138500
C                                                                       00138600
      DO 400 I=1,LF                                                     00138700
         FILTR (I) = - FILTR (I)                                        00138800
  400 CONTINUE                                                          00138900
C                                                                       00139000
      GO TO 6000                                                        00139100
C                                                                       00139200
C-----------------------------------------------------------------------00139300
C------------------ ERROR CONDITION CODES. -----------------------------00139400
C-----------------------------------------------------------------------00139500
C                                                                       00139600
 5009 IERR = 9                                                          00139700
      GO TO 6000                                                        00139800
C                                                                       00139900
 5001 IERR = 1                                                          00140000
      GO TO 6000                                                        00140100
C                                                                       00140200
 5002 IERR = 2                                                          00140300
      GO TO 6000                                                        00140400
 5010 IERR = 10                                                         00140500
      GO TO 6000                                                        00140600
 5004 IERR = 4                                                          00140700
 6000 RETURN                                                            00140800
C                                                                       00140900
      END                                                               00141000
      SUBROUTINE LENGT2 (ITYPE,DB,DELT,                                 00141100
c++   SUBROUTINE LENGTH (ITYPE,DB,DELT,                                 00141100
     *                   FSTRT,FEND,MAXLEN,LF,OTRUNC,IERR)              00141200
C ******************************************************************** C00141300
C *                                                                  * C00141400
C *   PROGRAM - LENGTH                    ENTRY POINTS - LENGTH      * C00141500
C *   LANGUAGE - FORTRAN                                             * C00141600
C *   AUTHOR -                                                       * C00141700
C *   DATE WRITTEN -                                                 * C00141800
C *   DATE LAST MODIFIED - 09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00141900
C *                                                                  * C00142000
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00142100
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00142200
C *                                                                  * C00142300
C *   ABSTRACT -                                                     * C00142400
C *                                                                  * C00142500
C *    SUBROUTINE TO COMPUTE THE LENGTH OF A ROSS OR BESSEL FILTER   * C00142600
C *    FOR A SPECIFIED REJECT LEVEL.                                 * C00142700
C *                                                                  * C00142800
C *   SUBROUTINES CALLED -                                           * C00142900
C *                                                                  * C00143000
C *   NONE                                                           * C00143100
C *                                                                  * C00143200
C *   USAGE -                                                        * C00143300
C *   CALL LENGTH(ITYPE,DB,DELT,FSTRT,FEND,MAXLEN,LF,OTRUNC,IERR)    * C00143400
C *                                                                  * C00143500
C *      ITYPE - FILTER TYPE (1 = ROSS   2 = BESSEL)                 * C00143600
C *         DB - REJECT LEVEL IN DB.  IF LF TRUNCATION OCURRED IN    * C00143700
C *              COMPUTING THE FILTER, THE VALUE USED IS RETURNED.   * C00143800
C *       DELT - SAMPLE INTERVAL IN SECONDS.                         * C00143900
C *      FSTRT - STARTING FREQUENCY VALUE (I.E., F1 OR F3).          * C00144000
C *       FEND - ENDING FREQUENCY VALUE (I.E., F2 OR F4).            * C00144100
C *     MAXLEN - MAXIMUM FILTER LENGTH ALLOWED.                      * C00144200
C *         LF - FILTER LENGTH COMPUTED AND RETURNED.                * C00144300
C *     OTRUNC - TRUNCATION FLAG RETURNED.                           * C00144400
C *              0 = LF NOT TRUNCATED                                * C00144500
C *              1 = LF TRUNCATED TO MAXLEN                          * C00144600
C *       IERR - ERROR RETURN                                        * C00144700
C *              0 - NO ERRORS.                                      * C00144800
C *              1 - FREQUENCY VALUES ARE NOT ASCENDING.             * C00144900
C *              2 - ONE OR MORE INPUT FREQUENCIES EXCEED NYQUIST    * C00145000
C *                  FOR THE DATA.                                   * C00145100
C *              4 - SAMPLE RATE IS LESS THAN 0.                     * C00145200
C *              8 - STARTING AND ENDING FREQUENCIES ARE BOTH 0.     * C00145300
C *              9 - REJECT LEVEL IS LESS THAN 21 DB OR GREATER      * C00145400
C *                  THAN 120 DB.                                    * C00145500
C *             10 - MAXIMUM FILTER LENGTH SHOULD BE GREATER THAN 0. * C00145600
C *             12 - FILTER TYPE IS INCORRECT.                       * C00145700
C *                                                                  * C00145800
C ******************************************************************** C00145900
C                                                                       00146000
      INTEGER*4 OTRUNC                                                  00146100
      IERR = 0                                                          00146200
      LF = 0                                                            00146300
C     CHECK PARAMETERS.                                                 00146400
      IF (FSTRT.EQ.0 .AND. FEND.EQ.0) GO TO 5008                        00146500
      IF (DELT.LE.0) GO TO 5004                                         00146600
      IF (ITYPE.NE.1 .AND. ITYPE.NE.2) GO TO 5012                       00146700
      IF (FSTRT.GE.FEND) GO TO 5001                                     00146800
      IF (DB.LE.0) GO TO 5009                                           00146900
      FNYQ=1./(2.*DELT)                                                 00147000
      IF(FSTRT.GT.FNYQ .OR. FEND.GT.FNYQ) GO TO 5002                    00147100
      IF (MAXLEN.LT.0) MAXLEN=-MAXLEN                                   00147200
      IF (MAXLEN.LE.0) GO TO 5010                                       00147300
C                                                                       00147400
      DDB = DB                                                          00147500
      DIF = (FEND - FSTRT) * DELT                                       00147600
C                                                                       00147700
C-----------------------------------------------------------------------00147800
C          FOR ITYPE = 1, COMPUTE OPERATOR LENGTH FOR ROSS.             00147900
C-----------------------------------------------------------------------00148000
C                                                                       00148100
      IF (ITYPE .EQ. 1) LF = (-.30864+.012374*DB**1.508)/DIF            00148200
C                                                                       00148300
C-----------------------------------------------------------------------00148400
C          FOR ITYPE = 2, COMPUTE OPERATOR LENGTH FOR BESSEL.           00148500
C-----------------------------------------------------------------------00148600
C                                                                       00148700
      IF (ITYPE .EQ. 2) LF = (-.58164+.076399*DB**.983)/DIF             00148800
C                                                                       00148900
C-----------------------------------------------------------------------00149000
C          MAKE SURE THAT THE OPERATOR LENGTH IS ALWAYS ODD.            00149100
C-----------------------------------------------------------------------00149200
C                                                                       00149300
      LF = LF / 2 * 2 + 1                                               00149400
C                                                                       00149500
C-----------------------------------------------------------------------00149600
C     REDUCE THE OPERATOR LENGTH TO THE MAX LENGTH AND SET OPERATOR     00149700
C     TRUNCATION FLAG IF NECESSARY.                                     00149800
C-----------------------------------------------------------------------00149900
C                                                                       00150000
      IF (LF .GT. MAXLEN) OTRUNC = 1                                    00150100
      IF (LF .GT. MAXLEN) LF = MAXLEN                                   00150200
C                                                                       00150300
C                                                                       00150400
C-----------------------------------------------------------------------00150500
C       CALCULATE ATTENUATION LEVEL DEPENDING UPON THE WEIGHT.          00150600
C-----------------------------------------------------------------------00150700
C                                                                       00150800
      IF (OTRUNC .NE. 1) GO TO 200                                      00150900
      DIF = DIF * LF                                                    00151000
      XY=1.0/1.508                                                      00151100
      IF (ITYPE .EQ. 1) DDB = ((DIF + .30864) / .012374)**XY            00151200
      XY=1.0/0.983                                                      00151300
      IF (ITYPE .EQ. 2) DDB = ((DIF + .58164) / .076399)**XY            00151400
      DB=DDB                                                            00151500
  200 CONTINUE                                                          00151600
      IF (DDB.LT.21. .OR. DDB.GT.120) IERR = 9                          00151700
      GO TO 6000                                                        00151800
 5012 IERR = 12                                                         00151900
      GO TO 6000                                                        00152000
 5001 IERR = 1                                                          00152100
      GO TO 6000                                                        00152200
 5009 IERR = 9                                                          00152300
      GO TO 6000                                                        00152400
 5002 IERR = 2                                                          00152500
      GO TO 6000                                                        00152600
 5010 IERR = 10                                                         00152700
      GO TO 6000                                                        00152800
 5004 IERR = 4                                                          00152900
      GO TO 6000                                                        00153000
 5008 IERR = 8                                                          00153100
 6000 RETURN                                                            00153200
      END                                                               00153300
      SUBROUTINE OPERAT (ITYPE,LF,DELT,OTRUNC,DB,FSTRT,                 00153400
     *                     FEND,FILTR,IERR)                             00153500
C ******************************************************************** C00153600
C *                                                                  * C00153700
C *   PROGRAM - OPERAT                    ENTRY POINTS - OPERAT      * C00153800
C *   LANGUAGE - FORTRAN                                             * C00153900
C *   AUTHOR -                                                       * C00154000
C *   DATE WRITTEN -                                                 * C00154100
C *   DATE LAST MODIFIED - 09/27/84, SDL.  ADDITIONAL ERROR CHECKS.  * C00154200
C *                                                                  * C00154300
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00154400
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00154500
C *                                                                  * C00154600
C *   ABSTRACT -                                                     * C00154700
C *                                                                  * C00154800
C *    SUBROUTINE TO COMPUTE THE ROSS OR BESSEL FILTER.              * C00154900
C *                                                                  * C00155000
C *   SUBROUTINES CALLED -                                           * C00155100
C *                                                                  * C00155200
C *   IDEF IDEF3                                                     * C00155300
C *                                                                  * C00155400
C *   USAGE -                                                        * C00155500
C *                                                                  * C00155600
C *   CALL OPERAT(ITYPE,LF,DELT,OTRUNC,DB,FSTRT,FEND,FILTR,IERR)     * C00155700
C *                                                                  * C00155800
C *    ITYPE - FILTER TYPE (1 = ROSS     2 = BESSEL)                 * C00155900
C *       LF - FILTER LENGTH.                                        * C00156000
C *     DELT - SAMPLE INTERVAL IN SECONDS.                           * C00156100
C *   OTRUNC - TRUNCATION FLAG SET BY SUBROUTINE LENGTH AND/OR       * C00156200
C *            SUBROUTINE TRUNCT.                                    * C00156300
C *            0 = LF NOT TRUNCATED.                                 * C00156400
C *            1 = LF TRUNCATED.                                     * C00156500
C *       DB - REJECT LEVEL IN DB.  IF OTRUNC=1, THE REJECT LEVEL IS * C00156600
C *            COMPUTED FOR A FILTER OF LENGTH LF AND IS RETURNED.   * C00156700
C *    FSTRT - STARTING FREQUENCY VALUE (I.E., F1 OR F3).            * C00156800
C *     FEND - ENDING FREQUENCY VALUE (I.E., F2 OR F4).              * C00156900
C *    FILTR - FILTER ARRAY RETURNED.                                * C00157000
C *     IERR - ERROR CODE                                            * C00157100
C *            0 - NO ERRORS.                                        * C00157200
C *            1 - FREQUENCY VALUES ARE NOT ASCENDING.               * C00157300
C *            4 - SAMPLE INTERVAL MUST BE GREATER THAN 0.           * C00157400
C *            7 - LF MUST BE ODD.                                   * C00157500
C *            8 - STARTING AND ENDING FREQUENCIES ARE BOTH 0.       * C00157600
C *            9 - REJECT LEVEL LESS THAN 21 OR GREATER THAN 120 DB. * C00157700
C *           12 - FILTER TYPE MUST BE 1 OR 2.                       * C00157800
C *                                                                  * C00157900
C ******************************************************************** C00158000
C                                                                       00158100
      REAL*4 FILTR(1001)                                                00158200
C                                                                       00158300
      INTEGER*4 OTRUNC                                                  00158400
C                                                                       00158500
      IERR = 0                                                          00158600
      DDB = DB                                                          00158700
C                                                                       00158800
      IF (FSTRT.EQ.0. .AND. FEND.EQ.0.) GO TO 5008                      00158900
      IF (ITYPE.NE.1 .AND. ITYPE.NE.2) GO TO 5012                       00159000
      IF (FSTRT.GE.FEND) GO TO 5001                                     00159100
      IF (LF.LT.0) LF=-LF                                               00159200
      IF (LF/2*2.EQ.LF .AND. LF.NE.0) GO TO 5007                        00159300
      IF (DELT.LE.0) GO TO 5004                                         00159400
C                                                                       00159500
C-----------------------------------------------------------------------00159600
C               LIMITING FREQUENCY TO PASS                              00159700
C-----------------------------------------------------------------------00159800
C                                                                       00159900
      FREQ = (FSTRT + FEND) * .5                                        00160000
      DIF = (FEND - FSTRT) * DELT                                       00160100
      ISI = DELT * 1000.+.5                                             00160200
      IF (OTRUNC .EQ. 1) GO TO 100                                      00160300
      IF (DB.LE.0) GO TO 5009                                           00160400
C                                                                       00160500
C-----------------------------------------------------------------------00160600
C                CALCULATE OPERATOR LENGTH  FOR ROSS.                   00160700
C-----------------------------------------------------------------------00160800
C                                                                       00160900
      IF (ITYPE .EQ. 1) LF = (-.30864+.012374*DDB**1.508)/DIF           00161000
C                                                                       00161100
C-----------------------------------------------------------------------00161200
C                CALCULATE OPERATOR LENGTH FOR BESSEL.                  00161300
C-----------------------------------------------------------------------00161400
C                                                                       00161500
      IF (ITYPE .EQ. 2) LF = (-.58164+.076399*DDB**.983)/DIF            00161600
C                                                                       00161700
C-----------------------------------------------------------------------00161800
C            GUARANTEE THAT THE OPERATOR LENGTH IS ODD.                 00161900
C-----------------------------------------------------------------------00162000
C                                                                       00162100
      LF = LF / 2 * 2 + 1                                               00162200
      GO TO 200                                                         00162300
C                                                                       00162400
C-----------------------------------------------------------------------00162500
C       CALCULATE ATTENUATION LEVEL DEPENDING UPON THE WEIGHT.          00162600
C-----------------------------------------------------------------------00162700
C                                                                       00162800
  100 DIF = DIF * LF                                                    00162900
      IF (LF.EQ.0) GO TO 5007                                           00163000
      XY=1.0/1.508                                                      00163100
      IF (ITYPE .EQ. 1) DDB = ((DIF + .30864) / .012374)**XY            00163200
      XY=1.0/0.983                                                      00163300
      IF (ITYPE .EQ. 2) DDB = ((DIF + .58164) / .076399)**XY            00163400
      DB=DDB                                                            00163500
  200 CONTINUE                                                          00163600
C                                                                       00163700
C-----------------------------------------------------------------------00163800
C           CALCULATE EXPONENT AND GENERATE OPERATOR                    00163900
C-----------------------------------------------------------------------00164000
C                                                                       00164100
      IF (ITYPE .EQ. 2) GO TO 300                                       00164200
C                                                                       00164300
C-----------------------------------------------------------------------00164400
C             EXPONENT CALCULATION FOR ROSS FUNCTION.                   00164500
C-----------------------------------------------------------------------00164600
C                                                                       00164700
      EXPONT = -1.2667 + .0064994 * DDB**1.703                          00164800
      IF (EXPONT .LT. 0.) EXPONT = 0.                                   00164900
      CALL IDEF(FREQ,ISI,LF,FILTR,EXPONT,IERR)                          00165000
C                                                                       00165100
      IF (IERR.EQ.0 .AND. (DDB.LT.21 .OR. DDB.GT.120)) IERR=9           00165200
      GO TO 6000                                                        00165300
C                                                                       00165400
C-----------------------------------------------------------------------00165500
C            EXPONENT CALCULATION FOR BESSEL FUNCTION.                  00165600
C-----------------------------------------------------------------------00165700
C                                                                       00165800
  300 EXPONT = -7.4901 + 1.6808*DDB**.505                               00165900
      IF (EXPONT .LT. 0.) EXPONT = 0.                                   00166000
      CALL IDEF3(FREQ,DELT,EXPONT,LF,FILTR,IERR)                        00166100
      IF (IERR.EQ.0 .AND. (DDB.LT.21 .OR. DDB.GT.120)) IERR=9           00166200
C                                                                       00166300
      GO TO 6000                                                        00166400
 5012 IERR = 12                                                         00166500
      GO TO 6000                                                        00166600
 5009 IERR = 9                                                          00166700
      GO TO 6000                                                        00166800
 5001 IERR = 1                                                          00166900
      GO TO 6000                                                        00167000
 5007 IERR = 7                                                          00167100
      GO TO 6000                                                        00167200
 5004 IERR = 4                                                          00167300
      GO TO 6000                                                        00167400
 5008 IERR = 8                                                          00167500
 6000 RETURN                                                            00167600
      END                                                               00167700
      SUBROUTINE COMBIN (LENLO,LENHI,OPLOW,OPHI,LF,FILTR,IERR)          00167800
C ******************************************************************** C00167900
C *                                                                  * C00168000
C *   PROGRAM - COMBIN                    ENTRY POINTS - COMBIN      * C00168100
C *   LANGUAGE - FORTRAN                                             * C00168200
C *   AUTHOR -                                                       * C00168300
C *   DATE WRITTEN -                                                 * C00168400
C *   DATE LAST MODIFIED -  09/27/84 SDL, ADDITIONAL ERROR CHECKS.   * C00168500
C *                                                                  * C00168600
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00168700
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00168800
C *                                                                  * C00168900
C *   ABSTRACT -                                                     * C00169000
C *                                                                  * C00169100
C *    SUBROUTINE TO COMBINE LOWCUT AND HIGHCUT OPERATORS TO         * C00169200
C *    PRODUCE A BANDPASS OPERATOR.                                  * C00169300
C *                                                                  * C00169400
C *   SUBROUTINES CALLED -                                           * C00169500
C *                                                                  * C00169600
C *     MOVE                                                         * C00169700
C *                                                                  * C00169800
C *   USAGE -                                                        * C00169900
C *                                                                  * C00170000
C *   CALL COMBIN(LENLO,LENHI,OPLOW,OPHI,LF,FILTR,IERR)              * C00170100
C *                                                                  * C00170200
C *    LENLO - LENGTH OF LOWCUT OPERATOR.                            * C00170300
C *    LENHI - LENGTH OF HIGHCUT OPERATOR.                           * C00170400
C *    OPLOW - LOWCUT OPERATOR.                                      * C00170500
C *     OPHI - HIGHCUT OPERATOR.                                     * C00170600
C *       LF - BANDPASS FILTER LENGTH.                               * C00170700
C *    FILTR - FILTER ARRAY RETURNED.                                * C00170800
C *     IERR - ERROR CONDITIONS:                                     * C00170900
C *            0 - NO ERRORS.                                        * C00171000
C *            8 - OUT/OUT FILTER SPECIFIED.                         * C00171100
C *                                                                  * C00171200
C ******************************************************************** C00171300
C                                                                       00171400
      REAL*4 OPLOW(1001),OPHI(1001),FILTR(1001)                         00171500
C                                                                       00171600
      IERR = 0                                                          00171700
      LF = 0                                                            00171800
      IF (LENLO .GT. 0) GO TO 100                                       00171900
C                                                                       00172000
C-----------------------------------------------------------------------00172100
C     FOR HIGH CUT FILTER ONLY: MOVE THE HIGH CUT OPERATOR INTO THE     00172200
C     FILTER AND SET THE FILTER LENGTH TO THE VALUE OF THE HIGH CUT     00172300
C     OPERATOR'S LENGTH.                                                00172400
C-----------------------------------------------------------------------00172500
C                                                                       00172600
      IF (LENHI.LE.0) GO TO 5008                                        00172700
      LF = LENHI                                                        00172800
      CALL MOVE (1,FILTR,OPHI,4*LENHI)                                  00172900
      GO TO 6000                                                        00173000
C                                                                       00173100
  100 IF (LENHI .GT. 0) GO TO 300                                       00173200
C                                                                       00173300
C-----------------------------------------------------------------------00173400
C     FOR LOW CUT FILTER ONLY: COPY THE NEGATED VALUES OF THE LOW CUT   00173500
C     OPERATOR INTO THE FILTER, SET FILTER LENGTH TO THE VALUE OF THE   00173600
C     LOW CUT OPERATOR'S LENGTH.                                        00173700
C-----------------------------------------------------------------------00173800
C                                                                       00173900
      LF = LENLO                                                        00174000
      DO 200 I=1,LENLO                                                  00174100
         FILTR (I) = - OPLOW (I)                                        00174200
  200 CONTINUE                                                          00174300
C                                                                       00174400
C                                                                       00174500
      I = LENLO / 2 + 1                                                 00174600
      FILTR (I) = 1.0 + FILTR (I)                                       00174700
      GO TO 6000                                                        00174800
C                                                                       00174900
C-----------------------------------------------------------------------00175000
C                 LOWCUT AND HIGHCUT OPERATOR                           00175100
C-----------------------------------------------------------------------00175200
C                                                                       00175300
  300 IF (LENLO - LENHI) 400,700,900                                    00175400
C                                                                       00175500
C-----------------------------------------------------------------------00175600
C                   HIGHCUT LENGTH LARGEST                              00175700
C-----------------------------------------------------------------------00175800
C                                                                       00175900
  400 IC = LENHI / 2 + 1                                                00176000
      IC2 = LENLO / 2 + 1                                               00176100
      LF = LENHI                                                        00176200
      I = IC - IC2                                                      00176300
C                                                                       00176400
      DO 500 L=1,IC2                                                    00176500
         OPHI (I + L) = OPHI (I + L) - OPLOW (L)                        00176600
  500 CONTINUE                                                          00176700
C                                                                       00176800
      FILTR (IC) = OPHI (IC)                                            00176900
      IC = IC - 1                                                       00177000
      IC2 = LENHI + 1                                                   00177100
C                                                                       00177200
      DO 600 L=1,IC                                                     00177300
         FILTR (L) = OPHI (L)                                           00177400
         FILTR (IC2 - L) = OPHI (L)                                     00177500
  600 CONTINUE                                                          00177600
C                                                                       00177700
      GO TO 6000                                                        00177800
C                                                                       00177900
C-----------------------------------------------------------------------00178000
C     EQUAL LENGTH OPERATORS: SUBTRACT (ELEMENT FOR ELEMENT) THE LOW    00178100
C     CUT OPERATOR FROM THE HIGH CUT OPERATOR.                          00178200
C-----------------------------------------------------------------------00178300
C                                                                       00178400
  700 DO 800 L=1,LENLO                                                  00178500
         FILTR (L) = OPHI (L) - OPLOW (L)                               00178600
  800 CONTINUE                                                          00178700
C                                                                       00178800
      LF = LENLO                                                        00178900
      GO TO 6000                                                        00179000
C                                                                       00179100
C-----LOWCUT LENGTH LARGEST                                             00179200
C                                                                       00179300
  900 IC = LENLO / 2 + 1                                                00179400
      IC2 = LENHI / 2 + 1                                               00179500
      LF = LENLO                                                        00179600
      I = IC - IC2                                                      00179700
C                                                                       00179800
      DO 1000 L=1,I                                                     00179900
         FILTR (L) = - OPLOW (L)                                        00180000
 1000 CONTINUE                                                          00180100
C                                                                       00180200
      DO 1100 L=1,IC2                                                   00180300
         FILTR (I + L) = OPHI (L) - OPLOW (I + L)                       00180400
 1100 CONTINUE                                                          00180500
C                                                                       00180600
      IC = IC - 1                                                       00180700
      IC2 = LENLO + 1                                                   00180800
C                                                                       00180900
      DO 1200 L=1,IC                                                    00181000
         FILTR (IC2 - L) = FILTR (L)                                    00181100
 1200 CONTINUE                                                          00181200
      GO TO 6000                                                        00181300
 5008 IERR = 8                                                          00181400
C                                                                       00181500
 6000 CONTINUE                                                          00181600
      RETURN                                                            00181700
      END                                                               00181800
      SUBROUTINE TRUNCT (LENLO,LENHI,NSAMP,PERCNT,LTRUNC,HTRUNC,IERR)   00181900
C ******************************************************************** C00182000
C *                                                                  * C00182100
C *   PROGRAM - TRUNCT                    ENTRY POINTS - TRUNCT      * C00182200
C *   LANGUAGE - FORTRAN                                             * C00182300
C *   AUTHOR -                                                       * C00182400
C *   DATE WRITTEN -                                                 * C00182500
C *   DATE LAST MODIFIED -  09/27/84 SDL, ADDITIONAL ERROR CHECKS.   * C00182600
C *                                                                  * C00182700
C *           AMOCO PRODUCTION COMPANY - PROPRIETARY                 * C00182800
C *               TO BE MAINTAINED IN CONFIDENCE                     * C00182900
C *                                                                  * C00183000
C *   ABSTRACT -                                                     * C00183100
C *                                                                  * C00183200
C *    SUBROUTINE TO TRUNCATE LOWCUT AND / OR HIGHCUT LENGTHS IF     * C00183300
C *    THEY ARE WITHIN THE GIVEN PERCENT OF THE PREVIOUS             * C00183400
C *    TRANSFORM LENGTH.                                             * C00183500
C *                                                                  * C00183600
C *   SUBROUTINES CALLED -                                           * C00183700
C *                                                                  * C00183800
C *     NONE                                                         * C00183900
C *                                                                  * C00184000
C *   USAGE -                                                        * C00184100
C *                                                                  * C00184200
C *   CALL TRUNCT(LENLO,LENHI,NSAMP,PERCNT,LTRUNC,HTRUNC,IERR)       * C00184300
C *                                                                  * C00184400
C *    LENLO - LENGTH OF LOWCUT OPERATOR.                            * C00184500
C *    LENHI - LENGTH OF HIGHCUT OPERATOR.                           * C00184600
C *    NSAMP - TRACE LENGTH.                                         * C00184700
C *   PERCNT - PERCENT FOR CUTBACK OF OPERATOR.                      * C00184800
C *   LTRUNC - LOWCUT TRUNCATION FLAG RETURNED.                      * C00184900
C *            0 - NO TRUNCATION.                                    * C00185000
C *            1 - TRUNCATION.                                       * C00185100
C *   HTRUNC - HIGHCUT TRUNCATION FLAG RETURNED.                     * C00185200
C *            0 - NO TRUNCATION.                                    * C00185300
C *            1 - TRUNCATION.                                       * C00185400
C *     IERR - ERROR CONDITIONS:                                     * C00185500
C *            0 - NO ERRORS.                                        * C00185600
C *            8 - OUT/OUT FILTER SPECIFIED.                         * C00185700
C *                                                                  * C00185800
C ******************************************************************** C00185900
C                                                                       00186000
      INTEGER*4 PERCNT,LTRUNC,HTRUNC                                    00186100
C                                                                       00186200
C-----------------------------------------------------------------------00186300
C     INTERNAL VARIABLES:                                               00186400
C       XFMLEN - TRANSFORM LENGTH.                                      00186500
C       N2     - XFMLEN / 2.                                            00186600
C       MAXLEN - MAXIMUM LENGTH OF FILTER.                              00186700
C       DATLEN - TRACE LENGTH + HALF OF FILTER LENGTH + 1.              00186800
C       TOLERN - TOLERANCE.                                             00186900
C-----------------------------------------------------------------------00187000
C                                                                       00187100
      INTEGER*4 XFMLEN,DATLEN,TOLERN,MAXLEN                             00187200
      IERR = 0                                                          00187300
C                                                                       00187400
C-----------------------------------------------------------------------00187500
C     SET MAX LENGTH OF FILTER TO THE LARGER OF LOWCUT LENGTH OR        00187600
C     HIGHCUT LENGTH.                                                   00187700
C-----------------------------------------------------------------------00187800
C                                                                       00187900
      MAXLEN = LENLO                                                    00188000
      IF (LENHI .GT. MAXLEN) MAXLEN = LENHI                             00188100
      IF (MAXLEN .LE. 0) GO TO 5008                                     00188200
C                                                                       00188300
C-----------------------------------------------------------------------00188400
C                 CALCULATE DATA LENGTH.                                00188500
C-----------------------------------------------------------------------00188600
C                                                                       00188700
      DATLEN = (MAXLEN / 2) + 1 + NSAMP                                 00188800
C                                                                       00188900
C-----------------------------------------------------------------------00189000
C     INCREASE THE TRANSFORM LENGTH BY POWER OF TWO UNTIL GREATER THAN  00189100
C     OR EQUAL TO THE DESIRED DATA LENGTH.                              00189200
C-----------------------------------------------------------------------00189300
C                                                                       00189400
      XFMLEN = 128                                                      00189500
  100 XFMLEN = XFMLEN + XFMLEN                                          00189600
      IF (XFMLEN .LT. DATLEN) GO TO 100                                 00189700
C                                                                       00189800
C-----------------------------------------------------------------------00189900
C        CHECK TO SEE IF TOLERANCE IS WITHIN THE GIVEN PERCENTAGE.      00190000
C-----------------------------------------------------------------------00190100
C                                                                       00190200
      N2 = XFMLEN / 2                                                   00190300
      TOLERN = DATLEN - N2                                              00190400
      IF (TOLERN .GT. PERCNT * MAXLEN / 100) GO TO 6000                 00190500
C                                                                       00190600
C-----------------------------------------------------------------------00190700
C          OTHERWISE CALCULATE MAXIMUM FILTER LENGTH ALLOWED.           00190800
C-----------------------------------------------------------------------00190900
C                                                                       00191000
      MAXLEN = (N2 - NSAMP) * 2 - 1                                     00191100
C                                                                       00191200
C-----------------------------------------------------------------------00191300
C    ADJUST OPERATOR LENGTHS AND SET TRUNCATION FLAGS IF NECESSARY.     00191400
C-----------------------------------------------------------------------00191500
C                                                                       00191600
      IF (LENLO .GT. MAXLEN) LTRUNC = 1                                 00191700
      IF (LENLO .GT. MAXLEN) LENLO = MAXLEN                             00191800
C                                                                       00191900
      IF (LENHI .GT. MAXLEN) HTRUNC = 1                                 00192000
      IF (LENHI .GT. MAXLEN) LENHI = MAXLEN                             00192100
C                                                                       00192200
      GO TO 6000                                                        00192300
 5008 IERR = 8                                                          00192400
 6000 RETURN                                                            00192500
      END                                                               00192600
      SUBROUTINE FLPKER(IPR,SNAME,ISERR,IERR)                           00192700
C ******************************************************************** C00192800
C *                                                                  * C00192900
C *   SUBROUTINE - FLPKER                           ENTRY - FLPKER   * C00193000
C *   LANGUAGE - FORTRAN                                             * C00193100
C *   AUTHOR - S. LILLY                                              * C00193200
C *   DATE WRITTEN - 10/19                                           * C00193300
C *   MODIFICATION HISTORY -                                         * C00193400
C *                                                                  * C00193500
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                * C00193600
C *                 TO BE MAINTAINED IN CONFIDENCE                   * C00193700
C *                                                                  * C00193800
C *   ABSTRACT -                                                     * C00193900
C *                                                                  * C00194000
C *  SUBROUTINE TO PRINT DESCRIPTIVE MESSAGES CORRESPONDING TO THE   * C00194100
C *  ERROR CODE RETURNED BY A FILTER PACKAGE SUBROUTINE.             * C00194200
C *                                                                  * C00194300
C *   SUBROUTINES CALLED -  NONE                                     * C00194400
C *                                                                  * C00194500
C *   USAGE -                                                        * C00194600
C *                                                                  * C00194700
C *     CALL FLPKER(IPR,SNAME,ISERR,IERR)                            * C00194800
C *                                                                  * C00194900
C *           IPR - LOGICAL UNIT NUMBER OF PRINT DEVICE.             * C00195000
C *         SNAME - NAME OF SUBROUTINE WHERE ERROR CONDITION OCCURED.* C00195100
C *                 (REAL*8 VARIABLE)                                * C00195200
C *         ISERR - ERROR CODE RETURNED BY FILTER PACKAGE SUBROUTINE.* C00195300
C *          IERR - ERROR CONDITION:                                 * C00195400
C *                 0 - NO ERRORS.                                   * C00195500
C *                 1 - ERROR CODE IS NOT ON FILE.                   * C00195600
C *                                                                  * C00195700
C *   OUTPUT IS...                                                   * C00195800
C *          PRINTED MESSAGE ON PRINT DEVICE.                        * C00195900
C *                                                                  * C00196000
C ******************************************************************** C00196100
      REAL*8 SNAME                                                      00196200
      IERR=0                                                            00196300
      IF(ISERR.EQ.0) GO TO 10000                                        00196400
      WRITE(IPR,9000)                                                   00196500
 9000 FORMAT('0')                                                       00196600
      N=ISERR                                                           00196700
      IF(N.GT.10)GO TO 2                                                00196800
      GO TO (                                                           00196900
     *5,15,25,35,45,55,65,75,85,95),N                                   00197000
C     1  2  3  4  5  6  7  8  9 10     VALUES OF N                      00197100
    2 IF(N.GT.20) GO TO 9999                                            00197200
      NN=N-10                                                           00197300
      GO TO (105,115,125,135,145,155,165,175,185,195),NN                00197400
C             11  12 13   14  15  16  17  18  19  20                    00197500
    5 WRITE(IPR,10) SNAME                                               00197600
   10 FORMAT('0',T10,'*** FP001 *** ERROR DETECTED IN SUBROUTINE ',A8,  00197700
     */,1X,T10,'THE FREQUENCIES SPECIFIED ARE NOT IN ASCENDING ORDER.', 00197800
     */,1X,T10,'ENSURE THAT FREQUENCIES ARE IN ASCENDING ORDER BEFORE', 00197900
     *' RESUBMITTING YOUR JOB.')                                        00198000
      GO TO 10000                                                       00198100
   15 WRITE(IPR,20) SNAME                                               00198200
   20 FORMAT('0',T10,'*** FP002 *** ERROR DETECTED IN SUBROUTINE ',A8,  00198300
     */,1X,T10,'A SPECIFIED FREQUENCY EXCEEDS THE NYQUIST FREQUENCY FOR'00198400
     *,' THE DATA.',/1X,T10,'CORRECT THE FREQUENCY BEFORE ',            00198500
     *'RESUBMITTING YOUR JOB.')                                         00198600
      GO TO 10000                                                       00198700
   25 WRITE(IPR,30) SNAME                                               00198800
   30 FORMAT('0',T10,'*** FP003 *** ERROR DETECTED IN SUBROUTINE ',A8,  00198900
     */,1X,T10,'THE FILTER LENGTH COMPUTATION OPTION MUST BE 0, 1, OR', 00199000
     *' 2.',/1X,T10,'ENSURE THAT THE OPTION IS AVAILABLE BEFORE ',      00199100
     *'RESUBMITTING YOUR JOB.')                                         00199200
      GO TO 10000                                                       00199300
   35 WRITE(IPR,40) SNAME                                               00199400
   40 FORMAT('0',T10,'*** FP004 *** ERROR DETECTED IN SUBROUTINE ',A8,  00199500
     */,1X,T10,'THE SAMPLE INTERVAL IS LESS THAN OR EQUAL TO 0.',       00199600
     */,1X,T10,'ENSURE THAT THE SAMPLE INTERVAL IS CORRECT BEFORE ',    00199700
     *'RESUBMITTING YOUR JOB.')                                         00199800
      GO TO 10000                                                       00199900
   45 WRITE(IPR,50) SNAME                                               00200000
   50 FORMAT('0',T10,'*** FP005 *** ERROR DETECTED IN SUBROUTINE ',A8,  00200100
     */1X,T10,'THE WEIGHT CENTERING OPTION MUST BE 0, 1, 2, 3, 4, OR 5.'00200200
     *,/1X,T10,'ENSURE THAT THE REQUESTED OPTION IS AVAILABLE BEFORE ', 00200300
     *'RESUBMITTING YOUR JOB.')                                         00200400
      GO TO 10000                                                       00200500
   55 WRITE(IPR,60) SNAME                                               00200600
   60 FORMAT('0',T10,'*** FP006 *** ERROR DETECTED IN SUBROUTINE ',A8,  00200700
     */,1X,T10,'THE WEIGHTING EXPONENT IS LESS THAN OR EQUAL TO 0.',    00200800
     */,1X,T10,'ENSURE THAT THE EXPONENT SPECIFIED IS CORRECT.')        00200900
      GO TO 10000                                                       00201000
   65 WRITE(IPR,70) SNAME                                               00201100
   70 FORMAT('0',T10,'*** FP007 *** ERROR DETECTED IN SUBROUTINE ',A8,  00201200
     */,1X,T10,'THE FILTER LENGTH IS NOT AN ODD NUMBER OF SAMPLES.',    00201300
     */,1X,T10,'ENSURE THAT THE FILTER LENGTH IS ODD BEFORE ',          00201400
     *'RESUBMITTING YOUR JOB.')                                         00201500
      GO TO 10000                                                       00201600
   75 WRITE(IPR,80) SNAME                                               00201700
   80 FORMAT('0',T10,'*** FP008 *** WARNING DETECTED IN SUBROUTINE ',A8,00201800
     */,1X,T10,'AN ALL PASS FILTER HAS BEEN SPECIFIED.',                00201900
     */,1X,T10,'ENSURE THAT ALL FREQUENCIES SHOULD BE 0.')              00202000
      GO TO 10000                                                       00202100
   85 WRITE(IPR,90) SNAME                                               00202200
   90 FORMAT('0',T10,'*** FP009 *** WARNING DETECTED IN SUBROUTINE ',A8,00202300
     */,1X,T10,'THE REJECT LEVEL SPECIFIED IS LESS THAN 21 DB OR ',     00202400
     *'GREATER THAN 120 DB.',/,1X,T10,                                  00202500
     *'ENSURE THAT THE REJECT LEVEL IS CORRECT.')                       00202600
      GO TO 10000                                                       00202700
   95 WRITE(IPR,100) SNAME                                              00202800
  100 FORMAT('0',T10,'*** FP010 *** ERROR DETECTED IN SUBROUTINE ',A8,  00202900
     */,1X,T10,'THE MAXIMUM FILTER (OR WAVELET) LENGTH CANNOT BE 0.',   00203000
     */,1X,T10,'ENSURE THAT MAXIMUM LENGTH IS GREATER THAN 0 ',         00203100
     *'BEFORE RESUBMITTING YOUR JOB.')                                  00203200
      GO TO 10000                                                       00203300
  105 WRITE(IPR,110) SNAME                                              00203400
  110 FORMAT('0',T10,'*** FP011 *** ERROR DETECTED IN SUBROUTINE ',A8,  00203500
     */,1X,T10,'THE INVERT FILTER FLAG IS NOT 0 OR 1.',                 00203600
     */,1X,T10,'ENSURE THAT THE INVERT FILTER FLAG IS 0 OR 1 BEFORE ',  00203700
     *'RESUBMITTING YOUR JOB.')                                         00203800
      GO TO 10000                                                       00203900
  115 WRITE(IPR,120) SNAME                                              00204000
  120 FORMAT('0',T10,'*** FP012 *** ERROR DETECTED IN SUBROUTINE ',A8,  00204100
     */,1X,T10,'THE FILTER TYPE MUST BE 1 OR 2 (ROSS OR BESSEL, RESP',  00204200
     *'ECTIVELY).',                                                     00204300
     */,1X,T10,'ENSURE THAT THE PROPER FILTER TYPE IS SPECIFIED BEFORE '00204400
     *,'RESUBMITTING YOUR JOB.')                                        00204500
      GO TO 10000                                                       00204600
  125 WRITE(IPR,130) SNAME                                              00204700
  130 FORMAT('0',T10,'*** FP013 *** ERROR DETECTED IN SUBROUTINE ',A8,  00204800
     */,1X,T10,'THE TRUNCATION FLAG SHOULD BE 0 OR 1.',                 00204900
     */,1X,T10,'ENSURE THAT THE TRUNCATION FLAG IS 0 OR 1 BEFORE ',     00205000
     *'RESUBMITTING YOUR JOB.')                                         00205100
      GO TO 10000                                                       00205200
  135 WRITE(IPR,140) SNAME                                              00205300
  140 FORMAT('0',T10,'*** FP014 *** ERROR DETECTED IN SUBROUTINE ',A8,  00205400
     */,1X,T10,'THE SWEEP DURATION MUST BE GREATER THAN 0.',            00205500
     */,1X,T10,'CORRECT THE SWEEP DURATION PARAMETER ',                 00205600
     *'BEFORE RESUBMITTING YOUR JOB.')                                  00205700
      GO TO 10000                                                       00205800
  145 WRITE(IPR,150) SNAME                                              00205900
  150 FORMAT('0',T10,'*** FP015 *** ERROR DETECTED IN SUBROUTINE ',A8,  00206000
     */,1X,T10,'THE LAG IS LESS THAN 1 OR CAUSES THE MAXIMUM NUMBER ',  00206100
     */,1X,T10,' OF POINTS ALLOWED TO BE EXCEEDED.',                    00206200
     */,1X,T10,'CORRECT THE LAG PARAMETER BEFORE ',                     00206300
     *'RESUBMITTING YOU JOB.')                                          00206400
      GO TO 10000                                                       00206500
  155 WRITE(IPR,160) SNAME                                              00206600
  160 FORMAT('0',T10,'*** FP016 *** ERROR DETECTED IN SUBROUTINE ',A8,  00206700
     */,1X,T10,'THE FORMAT CODE OF THE DATA MUST BE 1 OR 3.',           00206800
     */,1X,T10,'ENSURE THAT THE FORMAT CODE FOR DATA IS 1 OR 3 BEFORE ',00206900
     *'RESUBMITTING YOUR JOB.')                                         00207000
      GO TO 10000                                                       00207100
  165 WRITE(IPR,170) SNAME                                              00207200
  170 FORMAT('0',T10,'*** FP017 *** ERROR DETECTED IN SUBROUTINE ',A8,  00207300
     */,1X,T10,'THE SPECIFIED FREQUENCY PRODUCES A WAVELET GREATER ',   00207400
     *'THAN 1001 POINTS IN LENGTH.',                                    00207500
     */,1X,T10,'CORRECT THE SPECIFIED FREQUENCY BEFORE ',               00207600
     *'RESUBMITTING YOUR JOB.')                                         00207700
      GO TO 10000                                                       00207800
  175 WRITE(IPR,180) SNAME                                              00207900
  180 FORMAT('0',T10,'*** FP018 *** ERROR DETECTED IN SUBROUTINE ',A8,  00208000
     */,1X,T10,'THE LENGTH TO CENTER OF WINDOW CANNOT BE 0 FOR WEIGHT ',00208100
     *'CENTERING OPTION = 2.',/1X,T10,'ENSURE THAT LENGTH TO CENTER',   00208200
     *' IS NOT 0 BEFORE RESUBMITTING YOUR JOB.')                        00208300
      GO TO 10000                                                       00208400
  185 WRITE(IPR,190) SNAME                                              00208500
  190 FORMAT('0',T10,'*** FP019 *** ERROR DETECTED IN SUBROUTINE ',A8,  00208600
     */,1X,T10,'THE MAXIMUM FREQUENCY MUST BE GREATER THAN 0.',         00208700
     */,1X,T10,'CORRECT THE MAXIMUM FREQUENCY BEFORE ',                 00208800
     *'RESUBMITTING YOUR JOB.')                                         00208900
      GO TO 10000                                                       00209000
  195 WRITE(IPR,200) SNAME                                              00209100
  200 FORMAT('0',T10,'*** FP020 *** ERROR DETECTED IN SUBROUTINE ',A8,  00209200
     */,1X,T10,'BANDWIDTH MUST BE GREATER THAN 1 HZ.',                  00209300
     */,1X,T10,'ENSURE THAT BANDWIDTH IS GREATER THAN 1 BEFORE ',       00209400
     *'RESUBMITTING YOUR JOB.')                                         00209500
      GO TO 10000                                                       00209600
 9999 WRITE(IPR,5999) SNAME,ISERR                                       00209700
 5999 FORMAT('0',T10,'*** FP999 *** ERROR DETECTED IN SUBROUTINE ',A8,  00209800
     */,1X,T10,'NO FILTER PACKAGE DESCRIPTION FOR THIS ERROR, ERROR=',  00209900
     *I5)                                                               00210000
      IERR=1                                                            00210100
10000 CONTINUE                                                          00210200
      RETURN                                                            00210300
      END                                                               00210400
      SUBROUTINE GRAPF (FILTER,WORK,LF,NSR,IPR,LISTF,INVERT,IERR)       00299700
C ******************************************************************** C00299800
C *                                                                  * C00299900
C *   PROGRAM  - GRAPF                              ENTRY GRAPF      * C00300000
C *   LANGUAGE - FORTRAN                                             * C00300100
C *   AUTHOR - UNKNOWN                                               * C00300200
C *   DATE WRITTEN - UNKNOWN                                         * C00300300
C *   MODIFICATION HISTORY - 11/16/84 WRITE OUT SAMPLE RATE AND      * C00300400
C *                                   FILTER LENGTH IF EITHER ARE    * C00300500
C *                                   INVALID.                       * C00300600
C *                                                                  * C00300700
C *                                                                  * C00300800
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                * C00300900
C *                 TO BE MAINTAINED IN CONFIDENCE                   * C00301000
C *                                                                  * C00301100
C *   ABSTRACT -                                                     * C00301200
C *                                                                  * C00301300
C *     SUBROUTINE TO GENERATE A PRINTER PLOT OF THE IMPULSE         * C00301400
C *     RESPONSE AND/OR AMPLITUDE SPECTRUM OF A FILTER (ASSUMED TO   * C00301500
C *     BE ZERO PHASE) AND LIST THE FILTER COEFFICIENTS.             * C00301600
C *                                                                  * C00301700
C *   USAGE -                                                        * C00301800
C *                                                                  * C00301900
C *     CALL GRAPF(FILTER,WORK,LF,NSR,IPR,LISTF,IERR)                * C00302000
C *                                                                  * C00302100
C *   FILTER - FILTER ARRAY TO BE PLOTTED.                           * C00302200
C *   WORK   - WORK ARRAY DIMENSIONED SAME AS FILTER.                * C00302300
C *   LF     - LENGTH OF FILTER ARRAY.                               * C00302400
C *   NSR    - SAMPLE INTERVAL, IN MSEC.                             * C00302500
C *   IPR    - PRINTER LOGICAL UNIT.                                 * C00302600
C *   LISTF  - TYPE OF PLOT.                                         * C00302700
C *             0 = PRINT FILTER VALUES AND PLOT IMPULSE             * C00302800
C *                 RESPONSE ONLY.                                   * C00302900
C *             1 = PRINT FILTER VALUES AND PLOT FREQUENCY           * C00303000
C *                 AND IMPULSE RESPONSE.                            * C00303100
C *             2 = PLOT FREQUENCY RESPONSE ONLY.                    * C00303200
C *   INVERT - FLAG FOR INVERTED FILTER.                             * C00303300
C *             0 = NO                                               * C00303400
C *             1 = YES                                              * C00303500
C *   IERR   - ERROR CODE:                                           * C00303600
C *            0 - NO ERRORS.                                        * C00303700
C *            4 - SAMPLE RATE IS LESS THAN 0                        * C00303800
C *            7 - FILTER LENGTH IS LESS THAN 1.                     * C00303900
C *                                                                  * C00304000
C *   SUBROUTINES CALLED -                                           * C00304100
C *     GRAPHO    COST1    GRAF3                                     * C00304200
C *                                                                  * C00304300
C ******************************************************************** C00304400
      DIMENSION FILTER(1001),WORK(1001)                                 00304500
      ILEN=LF                                                           00304600
      IF(NSR.GE.1 .AND. LF.GT.0) GO TO 5                                00304700
      IF(LF.LE.0) IERR=7                                                00304800
      IF(NSR.LT.1) IERR=4                                               00304900
      WRITE(IPR,10) NSR,ILEN                                            00305000
      RETURN                                                            00305100
C                                                                       00305200
5     IF(LISTF.EQ.2) GO TO 200                                          00305300
      WRITE(IPR,10) NSR,ILEN                                            00305400
10    FORMAT(//,11X,'SAMPLE INTERVAL = ',I2,' MS.',/,                   00305500
     *          11X,'THE ',I4,' OPERATOR POINTS ARE :',/)               00305600
      WRITE(IPR,20) (FILTER(I),I=1,ILEN)                                00305700
20    FORMAT(10(3X,F10.6))                                              00305800
      CALL GRAPHO(ILEN,IPR,FILTER,WORK)                                 00305900
C                                                                       00306000
      IF(LISTF.EQ.0)RETURN                                              00306100
C                                                                       00306200
200   CONTINUE                                                          00306300
      FDEL = 1.0                                                        00306400
      FMAX = 500/NSR                                                    00306500
      IF(NSR.LE.4) FDEL = FMAX * .008                                   00306600
C     CALL COST1(ILEN,FDEL,FMAX,NSR,3,IPR,0,FILTER,WORK)                00306700
      CALL COST1(ILEN,FDEL,FMAX,NSR,3,IPR,INVERT,FILTER,WORK)           00306800
      RETURN                                                            00306900
      END                                                               00307000
      SUBROUTINE GRAPHO(LF,IPR,FILTER,WORK)                             00307100
C ******************************************************************** C00307200
C *                                                                  * C00307300
C *   PROGRAM  - GRAPHO                             ENTRY GRAPHO     * C00307400
C *   LANGUAGE - FORTRAN                                             * C00307500
C *   AUTHOR - UNKNOWN                                               * C00307600
C *   DATE WRITTEN - UNKNOWN                                         * C00307700
C *   MODIFICATION HISTORY -                                         * C00307800
C *                                                                  * C00307900
C *                                                                  * C00308000
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                * C00308100
C *                 TO BE MAINTAINED IN CONFIDENCE                   * C00308200
C *                                                                  * C00308300
C *   ABSTRACT -                                                     * C00308400
C *                                                                  * C00308500
C *     SUBROUTINE TO GENERATE A PRINTER PLOT OF THE IMPULSE         * C00308600
C *     RESPONSE (TIME-DOMAIN AMPLITUDE) OF A FILTER.                * C00308700
C *                                                                  * C00308800
C *   USAGE -                                                        * C00308900
C *                                                                  * C00309000
C *     CALL GRAPHO(LF,IPR,FILTER,WORK)                              * C00309100
C *                                                                  * C00309200
C *   LF     - LENGTH OF FILTER ARRAY.                               * C00309300
C *   IPR    - PRINTER LOGICAL UNIT.                                 * C00309400
C *   FILTER - FILTER ARRAY TO BE PLOTTED.                           * C00309500
C *   WORK   - WORK ARRAY DIMENSIONED SAME AS FILTER.                * C00309600
C *                                                                  * C00309700
C *   SUBROUTINES CALLED -                                           * C00309800
C *     MOVE                                                         * C00309900
C *                                                                  * C00310000
C ******************************************************************** C00310100
C                                                                       00310200
      REAL * 4  FILTER(1001)
	character*4 LLINE(29)
c++   REAL * 4  LLINE(29),FILTER(1001)                                  00310300
C                                                                       00310400
      INTEGER * 4 WORK(1),GCORRE,CCORRE                                 00310500
C                                                                       00310600
      character * 1 LINE(113),SLINE(113),AMP(36),SPLAT
c++   LOGICAL * 1 LINE(113),SLINE(113),AMP(36),SPLAT                    00310700
C                                                                       00310800
C-----------------------------------------------------------------------00310900
C                                                                       00311000
      DATA  LLINE/'A---',27*'T---','A   '/                              00311100
C                                                                       00311200
      DATA  LINE  /113*' '/                                             00311300
C                                                                       00311400
      DATA  SLINE /'A',55*' ','I',55*' ','A'/                           00311500
C                                                                       00311600
      DATA  AMP   /13*' ','A','M','P','L','I','T','U','D','E',14*' '/   00311700
C                                                                       00311800
      DATA  SPLAT /'*'/                                                 00311900
C                                                                       00312000
C-----------------------------------------------------------------------00312100
C               LF = NUMBER OF ELEMENTS TO GRAPH                        00312200
C-----------------------------------------------------------------------00312300
C                                                                       00312400
      GCORRE=0                                                          00312500
      CCORRE=0                                                          00312600
      M = LF                                                            00312700
      L = M / 2                                                         00312800
C                                                                       00312900
      DO 100 I=1,M                                                      00313000
      WORK(I) = FILTER(I) * 1000.                                       00313100
  100 CONTINUE                                                          00313200
C                                                                       00313300
C-----------------------------------------------------------------------00313400
C  CALCULATE GRAPH CORRECTION (GCORRE) AND C ARRAY CORRECTION (CCORRE)  00313500
C-----------------------------------------------------------------------00313600
C                                                                       00313700
      IF (M - 113)  120,150,130                                         00313800
C                                                                       00313900
  120 GCORRE = 56 - L                                                   00314000
      GO TO 150                                                         00314100
C                                                                       00314200
  130 CCORRE = L - 56                                                   00314300
      M = 113                                                           00314400
C                                                                       00314500
C-----------------------------------------------------------------------00314600
C                        FIND MIN AND MAX VALUES                        00314700
C-----------------------------------------------------------------------00314800
C                                                                       00314900
  150 MIN = WORK(1 + CCORRE)                                            00315000
      MAX = MIN                                                         00315100
      IF (M .EQ. 1) GO TO 275                                           00315200
C                                                                       00315300
      DO 250 I=2,M                                                      00315400
      INTER = WORK(I + CCORRE)                                          00315500
      IF (INTER .LT. MIN)  MIN = INTER                                  00315600
      IF (INTER .GT. MAX)  MAX = INTER                                  00315700
  250 CONTINUE                                                          00315800
C                                                                       00315900
C-----------------------------------------------------------------------00316000
C                     FIND BEST SCALE FACTOR                            00316100
C-----------------------------------------------------------------------00316200
C                                                                       00316300
  275 IDIF = MAX - MIN                                                  00316400
      IF (IDIF .NE. 0)  GO TO 300                                       00316500
      KSCALE = 1                                                        00316600
      GO TO 350                                                         00316700
C                                                                       00316800
  300 SCALE = IDIF / 35.                                                00316900
      I = ALOG10 (SCALE) + .999999                                      00317000
      IF (I .LT. 0)  I = 0                                              00317100
      KSCALE = 10 ** I                                                  00317200
C                                                                       00317300
  350 ISCALE = KSCALE/2                                                 00317400
C                                                                       00317500
      IF (ISCALE .LT. 1) ISCALE=1                                       00317600
C                                                                       00317700
      KLOW = (MIN/ISCALE) * ISCALE                                      00317800
C                                                                       00317900
      IF (MIN .LT. 0)  KLOW = KLOW - KSCALE                             00318000
C                                                                       00318100
      IF ((KLOW + 35 * ISCALE) .LT. MAX) GO TO 410                      00318200
C                                                                       00318300
      IF (ISCALE .EQ. 1) KLOW = MAX-36                                  00318400
C                                                                       00318500
      IF (ISCALE .EQ. 1) GO TO 410                                      00318600
C                                                                       00318700
      KSCALE = ISCALE                                                   00318800
      GO TO 350                                                         00318900
C                                                                       00319000
C-----------------------------------------------------------------------00319100
C                      CENTER GRAPH                                     00319200
C-----------------------------------------------------------------------00319300
C                                                                       00319400
  410 KLOW = KLOW - ((35 * KSCALE - IDIF)/(2 * KSCALE)) * KSCALE        00319500
      KHIGH = KLOW + 35 * KSCALE                                        00319600
      IF (KSCALE .EQ. 1) GO TO 600                                      00319700
C                                                                       00319800
C-----------------------------------------------------------------------00319900
C                         WRITE HEADING                                 00320000
C-----------------------------------------------------------------------00320100
C                                                                       00320200
  411 WRITE (IPR,6000)                                                  00320300
 6000 FORMAT ('1',//,T60,' FILTER OPERATOR TIMES 1000'///)              00320400
C                                                                       00320500
C-----------------------------------------------------------------------00320600
C                  NOW IT IS TIME TO OUTPUT GRAPH                       00320700
C-----------------------------------------------------------------------00320800
C                                                                       00320900
      DO 570 I=1,36                                                     00321000
      IF (I .EQ. 36)  GO TO 470                                         00321100
      CALL MOVE(1, LINE(1), SLINE(1), 113)                              00321200
      GO TO 480                                                         00321300
  470 CALL MOVE(1, LINE(1), LLINE(1), 113)                              00321400
C                                                                       00321500
  480 DO 510 K=1,M                                                      00321600
C                                                                       00321700
      IF ((KHIGH .GE. WORK(K + CCORRE))                                 00321800
     *  .AND. (WORK(K + CCORRE) .GT. (KHIGH - KSCALE)))                 00321900
     *     LINE(K + GCORRE) = SPLAT                                     00322000
C                                                                       00322100
  510 CONTINUE                                                          00322200
C                                                                       00322300
      IF (((I - 1)/5) * 5 .NE. (I -1))  GO TO 550                       00322400
C                                                                       00322500
      WRITE (IPR,6010) AMP(I), KHIGH, LINE                              00322600
 6010 FORMAT (T4,A1,T7,I8,T16,113A1)                                    00322700
C                                                                       00322800
      GO TO 560                                                         00322900
C                                                                       00323000
  550 WRITE (IPR,6020) AMP(I), LINE                                     00323100
 6020 FORMAT (T4,A1,T16,113A1)                                          00323200
C                                                                       00323300
  560 KHIGH = KHIGH - KSCALE                                            00323400
  570 CONTINUE                                                          00323500
C                                                                       00323600
C-----------------------------------------------------------------------00323700
C                                                                       00323800
      WRITE (IPR,6030)                                                  00323900
 6030 FORMAT (T15,'56 52  48  44  40  36  32  28  24  20  16  12   8   400324000
     *   0   4   8  12  16  20  24  28  32  36  40  44  48  52  56'//T7000324100
     *,'TIME')                                                          00324200
C                                                                       00324300
C-----------------------------------------------------------------------00324400
C                                                                       00324500
      RETURN                                                            00324600
C                                                                       00324700
  600 IF (KHIGH .LT. MAX) KHIGH = MAX                                   00324800
      IF (KHIGH .EQ. MAX) KLOW = KHIGH - 35                             00324900
      GO TO 411                                                         00325000
C                                                                       00325100
      END                                                               00325200
      SUBROUTINE COST1(LF,FDEL,FMAX,NSR,IFLAG,IPR,INVERT,               00325300
     *FILTER,WORK)                                                      00325400
C ******************************************************************** C00325500
C *                                                                  * C00325600
C *   PROGRAM  - COST1                              ENTRY COST1      * C00325700
C *   LANGUAGE - FORTRAN                                             * C00325800
C *   AUTHOR - UNKNOWN                                               * C00325900
C *   DATE WRITTEN - UNKNOWN                                         * C00326000
C *   MODIFICATION HISTORY -                                         * C00326100
C *                                                                  * C00326200
C *                                                                  * C00326300
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                * C00326400
C *                 TO BE MAINTAINED IN CONFIDENCE                   * C00326500
C *                                                                  * C00326600
C *   ABSTRACT -                                                     * C00326700
C *                                                                  * C00326800
C *     SUBROUTINE TO COMPUTE THE COSINE TRANSFORM OF THE FILTER     * C00326900
C *     ARRAY.                                                       * C00327000
C *                                                                  * C00327100
C *   USAGE -                                                        * C00327200
C *                                                                  * C00327300
C *     CALL COST1(LF,FDEL,FMAX,NSR,IFLAG,IPR,INVERT,FILTER,WORK)    * C00327400
C *                                                                  * C00327500
C *   LF     - LENGTH OF FILTER ARRAY.                               * C00327600
C *   FDEL   - FREQUENCY INCREMENT FOR COMPUTATIONS.                 * C00327700
C *   FMAX   - UPPER FREQUENCY LIMIT.                                * C00327800
C *   NSR    - SAMPLE INTERVAL, IN MSEC.                             * C00327900
C *   IFLAG  - PRINT AND NORMALIZATION FLAG.                         * C00328000
C *            0 - DO NOT PRINT OR NORMALIZE THE AMPLITUDE SPECTRUM. * C00328100
C *            1 - DO NOT PRINT OR NORMALIZE THE AMPLITUDE SPECTRUM. * C00328200
C *            2 - PRINT THE UNNORMALIZED AMPLITUDE SPECTRUM.        * C00328300
C *            3 - DO NOT PRINT OR NORMALIZE THE AMPLITUDE SPECTRUM. * C00328400
C *            4 - NORMALIZE THE AMPLITUDE SPECTRUM TO 1 AND         * C00328500
C *                PRINT THE VALUES.                                 * C00328600
C *   IPR    - PRINTER LOGICAL UNIT.                                 * C00328700
C *   INVERT - INVERT THE FILTER ARRAY BEFORE COMPUTING AMPLITUDE    * C00328800
C *            SPECTRUM.                                             * C00328900
C *   FILTER - FILTER ARRAY FOR WHICH RESPONSE IS TO BE COMPUTED.    * C00329000
C *   WORK   - WORK ARRAY DIMENSIONED SAME AS FILTER.                * C00329100
C *                                                                  * C00329200
C *   SUBROUTINES CALLED -                                           * C00329300
C *     GRAF3                                                        * C00329400
C *                                                                  * C00329500
C ******************************************************************** C00329600
      DIMENSION FILTER(1),WORK(1)                                       00329700
C                                                                       00329800
      A = 1.0                                                           00329900
      IF (INVERT .EQ. 1) A = -1.0                                       00330000
      L = LF / 2                                                        00330100
      SI=FLOAT(NSR)                                                     00330200
      FREQ = 0.0                                                        00330300
      LE = FMAX/FDEL+1.                                                 00330400
      FACT = .0062831854*SI                                             00330500
      XX = FLOAT(-(LF-1)/2)                                             00330600
C                                                                       00330700
      DO 10 J=1,LE                                                      00330800
      XN = XX                                                           00330900
      FAC = FACT * FREQ                                                 00331000
      WORK (J) = 0.0                                                    00331100
      I=1                                                               00331200
   20 WORK (J) = WORK (J) + FILTER (I) * COS (FAC * XN)                 00331300
      XN = XN + 1.0                                                     00331400
      I = I + 1                                                         00331500
      IF (I .LE. L) GO TO 20                                            00331600
C                                                                       00331700
      WORK (J) = (2. * WORK (J) + FILTER (I)) * A                       00331800
C                                                                       00331900
   10 FREQ = FREQ + FDEL                                                00332000
C                                                                       00332100
      IF (IFLAG .NE. 4) GO TO 15                                        00332200
      AMAX = 0.0                                                        00332300
C                                                                       00332400
      DO 11 I=1,LE                                                      00332500
      IF (WORK(I) .GT. AMAX) AMAX=WORK(I)                               00332600
   11 CONTINUE                                                          00332700
C                                                                       00332800
      SCALE = 1.0 / AMAX                                                00332900
C                                                                       00333000
      DO 12 I=1,LE                                                      00333100
   12 WORK(I) = WORK(I) * SCALE                                         00333200
C                                                                       00333300
      WRITE (IPR,3) SCALE                                               00333400
    3 FORMAT (10X,'SCALE FACTOR FOR AMPLITUDE RESPONSE IS',E15.7)       00333500
C                                                                       00333600
   15 IF (IFLAG .NE. 2) GO TO 30                                        00333700
C                                                                       00333800
      WRITE (IPR,1) LE,FDEL                                             00333900
    1 FORMAT ('1',9X,'AMPLITUDE RESPONSE',I4,' VALUES IN',F5.1,         00334000
     *              ' CPS STEPS.',//)                                   00334100
C                                                                       00334200
      WRITE (IPR,2)(WORK(J),J=1,LE)                                     00334300
    2 FORMAT (5(10X,F10.5))                                             00334400
C                                                                       00334500
   30 CALL GRAF3 (LE,FDEL,NSR,IPR,WORK)                                 00334600
C                                                                       00334700
      RETURN                                                            00334800
      END                                                               00334900
      SUBROUTINE GRAF3(LA,FDEL,NSR,IPR,AMP)                             00335000
C ******************************************************************** C00335100
C *                                                                  * C00335200
C *   PROGRAM  - GRAF3                              ENTRY GRAF3      * C00335300
C *   LANGUAGE - FORTRAN                                             * C00335400
C *   AUTHOR - UNKNOWN                                               * C00335500
C *   DATE WRITTEN - UNKNOWN                                         * C00335600
C *   MODIFICATION HISTORY -                                         * C00335700
C *                                                                  * C00335800
C *                                                                  * C00335900
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                * C00336000
C *                 TO BE MAINTAINED IN CONFIDENCE                   * C00336100
C *                                                                  * C00336200
C *   ABSTRACT -                                                     * C00336300
C *                                                                  * C00336400
C *     SUBROUTINE TO GENERATE A SIMULATED VARIABLE-AREA PLOT OF     * C00336500
C *     THE AMPLITUDE SPECTRUM IN FDEL STEPS.                        * C00336600
C *                                                                  * C00336700
C *   USAGE -                                                        * C00336800
C *                                                                  * C00336900
C *     CALL GRAF3(LA,FDEL,NSR,IPR,AMP)                              * C00337000
C *                                                                  * C00337100
C *   LF     - LENGTH OF FILTER ARRAY.                               * C00337200
C *   FDEL   - FREQUENCY INCREMENT FOR COMPUTATIONS.                 * C00337300
C *   FMAX   - UPPER FREQUENCY LIMIT.                                * C00337400
C *   NSR    - SAMPLE INTERVAL, IN MSEC.                             * C00337500
C *   IPR    - PRINTER LOGICAL UNIT.                                 * C00337600
C *   AMP    - AMPLITUDE ARRAY TO BE PLOTTED.                        * C00337700
C *                                                                  * C00337800
C *   SUBROUTINES CALLED -                                           * C00337900
C *     MOVE                                                         * C00338000
C *                                                                  * C00338100
C ******************************************************************** C00338200
C                                                                     * 00338300
C            CONFIDENTIAL AMOCO PRODUCTION COMPANY SOFTWARE:          * 00338400
C                      ALL RIGHTS RESERVED.                           * 00338500
C                                                                     * 00338600
C********************************************************************** 00338700
C                                                                       00338800
      REAL*4 AMP(1)                                                     00338900
C                                                                       00339000
      INTEGER*4 IPR,NSR,LA,LINCNT,BUFLEN,CURENT                         00339100
C                                                                       00339200
      INTEGER*2 BUFF(26)                                                00339300
C                                                                       00339400
      character*1 BUFFER(126)
      character*1 A,SPLAT,HYPHEN
c++   LOGICAL*1 BUFFER(126)                                             00339500
c++   LOGICAL*1 A,SPLAT,HYPHEN                                          00339600
C                                                                       00339700
      DATA A/'A'/,SPLAT/'*'/,HYPHEN/'-'/,BUFLEN/126/                    00339800
C                                                                       00339900
      WRITE (IPR,3)                                                     00340000
    3 FORMAT ('1',//,9X,'AMPLITUDE RESPONSE OF FILTER')                 00340100
C                                                                       00340200
      WRITE (IPR,5) NSR                                                 00340300
    5 FORMAT (//,9X,'SAMPLE INTERVAL =',I4,' MS.'////)                  00340400
C                                                                       00340500
      IF (LA .GT. BUFLEN) LA = BUFLEN                                   00340600
C                                                                       00340700
      YDELTA =  .03333333                                               00340800
      YCOUNT = 1.0333333333                                             00340900
      ASCALE = 1.1                                                      00341000
      LINCNT=0                                                          00341100
C                                                                       00341200
      DO 30 J=1,30                                                      00341300
      YCOUNT=YCOUNT-YDELTA                                              00341400
C                                                                       00341500
      CALL MOVE (2,BUFFER,0,BUFLEN)                                     00341600
C                                                                       00341700
      DO 40 I=1,LA                                                      00341800
      IF (AMP(I).GE.YCOUNT) BUFFER (I) = A                              00341900
   40 CONTINUE                                                          00342000
C                                                                       00342100
      LINCNT = LINCNT + 1                                               00342200
C                                                                       00342300
      IF (LINCNT .EQ. 1) GO TO 70                                       00342400
      WRITE (IPR,1) (BUFFER(I),I=1,LA)                                  00342500
    1 FORMAT (4X,126A1)                                                 00342600
C                                                                       00342700
      IF (LINCNT .EQ. 3) LINCNT = 0                                     00342800
      GO TO 30                                                          00342900
C                                                                       00343000
   70 ASCALE = ASCALE - .1                                              00343100
C                                                                       00343200
      WRITE (IPR,2)     ASCALE,(BUFFER(I),I=1,LA)                       00343300
    2 FORMAT (' ',F3.1,126A1)                                           00343400
C                                                                       00343500
   30 CONTINUE                                                          00343600
C                                                                       00343700
      IDEL = IFIX (FDEL)                                                00343800
C                                                                       00343900
C     CALL MOVE (3,BUFFER,HYPHEN,LA)                                    00344000
      DO 109 I=1,LA                                                     00344100
  109 BUFFER(I)=HYPHEN                                                  00344200
C                                                                       00344300
      DO 110 I=1,LA,5                                                   00344400
  110 BUFFER (I) = SPLAT                                                00344500
C                                                                       00344600
      WRITE (IPR,1) (BUFFER(I),I=1,LA)                                  00344700
C                                                                       00344800
      DO 120 I=1,LA,5                                                   00344900
      CURENT = (I/ 5 + 1)                                               00345000
  120 BUFF (CURENT) = IDEL * (I-1)                                      00345100
C                                                                       00345200
      WRITE (IPR,4) (BUFF(I),I=1,CURENT)                                00345300
    4 FORMAT (2X,I3,3X,25(I3,2X))                                       00345400
C                                                                       00345500
      WRITE (IPR,6)                                                     00345600
    6 FORMAT (//,10X,'FREQUENCY-----')                                  00345700
C                                                                       00345800
      RETURN                                                            00345900
      END                                                               00346000
