C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c Author P. Garossino
c
c nanfix reads data in USP format one trace at a time, searches for
c an integer representation of NaN as specified by the user and replaces
c such a value with a user defined integer amplitude.  
c
c  get machine dependent parameters 
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c  dimension standard USP variables 

      integer     itr( SZLNHD )
      integer     nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     luin,luout,lbytes,nbytes,obytes
      integer     argis,ist,iend,irs,ire,ns,ne
      integer	  nanchk
      integer     JJ,KK
      integer     nanamp,nanstat
      integer     nancpy

      real        RealTrace(SZLNHD), repamp

      character   name*6, ntap*256, otap*256, ftap*256, label*80

      logical     verbos,query,debug,kill,inf
 

c  initialize necessary variables 

      data name/'NANFIX'/
      data lbytes/0/
      data debug/.false./


c  get online help if necessary 

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if ( query ) then

           call help ()
           stop 0

      endif

#include <f77/open.h>

c  get command line parameters 
c

      call cmdln (ntap,otap,ist,iend,irs,ire,ns,ne,debug,nanamp,repamp,
     :     verbos,kill,inc,ftap,inf,label)

      if (label .ne. ' ') then
	write(LERR,'(/,a,/)') label
      endif

c
c  get logical units 
c

      call getln(luin,ntap,'r',0)

      write(LERR,*)'Input unit # is ',luin,' for DSN= ',ntap

      lbytes = 0
      call rtape(luin,itr,lbytes)
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'nanfix: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop 1
      endif
      if ( .not. debug ) call getln(luout,otap,'w',1)


      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 6, LERR)
 
      if(nsamp .gt. SZSMPM) nsamp=SZSMPM

c
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c set record start and end defaults

      if(irs .eq. 0) irs=1
      if(ire .eq. 0) ire=nrec
      if(ns .eq. 0) ns = 1
      if(ne .eq. 0) ne = ntrc

c determine number of records to process

      nreco=ire-irs+1

c convert start and end time to start and end sample

      ist=ist/nsi
      iend=iend/nsi

      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp

c determine number of output samples

      nsampo=iend-ist+1

c determine number of output traces

      ntrco = ne - ns + 1

c write out line header in not in debug mode

      call savhlh ( itr, lbytes, lbyout )

      if (.not. debug ) call wrtape ( luout, itr, lbyout )

c change output bytes to reflect change 
c       from time to # traces
c

      obytes = SZTRHD + SZSMPD * nsamp

c
c  printout 
c

      call verbal(nsamp,nsi,ntrc,nrec,iform,ist,iend,
     :      ns,ne,irs,ire,nanamp, repamp, debug,kill,inc,inf)

      inc = - iabs (inc)
c  skip to start record 

      call recskp(1,irs-1,luin,ntrc,itr)

      DO 100 JJ = irs, ire

c  skip to desired trace 

           call trcskp(jj,1,ns-1,luin,ntrc,itr)

           DO 99 KK = ns,ne

                 nbytes = 0
                 call rtape(luin,itr,nbytes)
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',KK
                    go to 999
                 endif
                 call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic, TRACEHEADER)

                 if ( debug ) then

c write out integer version of so user can find integer representation of NaN

                    write(LOT,*)' Record ',JJ,'  Trace ',KK
                    write(LOT,10)i,(itr(i+ITRWRD),i=1,nsamp)
 10                 format(i5,5x,(i20,1x))

c---
c  if there is even a single NaN in a trace kill it and
c  zero it out and mark it dead
c---
                 elseif (kill) then

                    IF (istatic .ne. 30000) THEN

                    do  i = nsamp, 1, inc
		      if (nanamp .ne. -1) then
                        if (itr(ITRWRD+i) .eq. nanamp) go to 101
		      else
		        nanstat=nanchk(itr(ITRWRD+i))
			if (nanstat .eq. 2) then
			  if (verbos)
     1  		    write(LERR,111) jj,kk,i,itr(ITRWRD+i),'NaN'
                          go to 101
			endif
			if (inf) then
     			  if (nanstat .eq. 1) then
#ifdef CRAYSYSTEM
			    if (verbos)
     1    		      write(LERR,111) jj,kk,i,itr(ITRWRD+i),'Inf'
111  			    format('rec ',i7,' trc ',i7,' sample ',i5,
     1				' value = ',z16,3x,'(',a,')')
#else
			    if (verbos) then
			      call move(1,nancpy,itr(ITRWRD+i),4)
          		      write(LERR,111) jj,kk,i,nancpy,'Inf'
			    endif
111  			    format('rec ',i7,' trc ',i7,' sample ',i5,
     1				' value = ',Z8,3x,'(',a,')')
#endif
                            go to 101
			  else if (nanstat .eq. -1) then
			    if (verbos) then
			      call move(1,nancpy,itr(ITRWRD+i),4)
        		      write(LERR,111) jj,kk,i,nancpy,'-Inf'
			    endif
                            go to 101
			  endif
			endif
		      endif
                    enddo
                    go to 202

101                 continue
                    do  ii = 1, nsamp
                      itr (ITRWRD+ii) = 0
                    enddo
                    call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000 , TRACEHEADER)

                    if (verbos) then
                    call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec  , TRACEHEADER)
                    call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          itrc  , TRACEHEADER)
                    call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInD,
     1                          idi   , TRACEHEADER)
                    call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInD,
     1                          ili   , TRACEHEADER)
                    write(LERR,*)'Killed Rec ',irec,' trc ',itrc,
     1			 ' LI ',ili,' DI ',idi
                    endif

202                 continue
                    ENDIF
                    call wrtape ( luout, itr, obytes )

                 else

                    call vmov (itr(ITHWP1),1,RealTrace,1,nsamp)

                    do i = ist, iend
		      if (nanamp .ne. -1) then
                        if ( itr (ITRWRD+i) .eq. nanamp ) 
     1			  RealTrace(i) = repamp
		      else
		        nanstat=nanchk(itr(ITRWRD+i))
		        if (nanstat .eq. 2) then
			  if (verbos)
     1  		    write(LERR,111) jj,kk,i,itr(ITRWRD+i),'NaN'
     			  RealTrace(i) = repamp
		        endif
		        if (inf) then
     			  if (nanstat .eq. 1) then
			    if (verbos) write(LERR,111) 
     1    		      jj,kk,i,itr(ITRWRD+i),'Inf'
     			    RealTrace(i) = repamp
			  else if (nanstat .eq. -1) then
			    if (verbos) write(LERR,111) 
     1  		      jj,kk,i,itr(ITRWRD+i),'-Inf'
     			    RealTrace(i) = repamp
			  endif
		        endif
		      endif
                    enddo
                    call vmov(RealTrace,1,itr(ITHWP1),1,nsamp)
c load output
                    call wrtape ( luout, itr, obytes )

                 endif

99         CONTINUE

c  skip to end of record 

            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

100   CONTINUE

999   continue

       call lbclos(luin)
       call lbclos(luout)

      stop 0
      end

c
c  online help section 
c

      subroutine  help

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'Command Line Arguments for nanfix'
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[ntap]   -- input data set'
      write(LER,*)'-O[otap]   -- output data set'
      write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
      write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
      write(LER,*)'-ns[ns]    -- start trace             (first trace)'
      write(LER,*)'-ne[ne]    -- end trace                (last trace)'
      write(LER,*)'-rs[irs]   -- start record                 (first)'
      write(LER,*)'-re[ire]   -- end record                    (last)'
      write(LER,*)'-nan[num]  -- Integer NaN to change  (auto-detect)'
      write(LER,*)'-inf       -- auto-detect +/-infinity values in   '
      write(LER,*)'              addition to NaN values.             '
      write(LER,*)'-F[ftap]   -- optional file containing NaN integer'
      write(LER,*)'-rep[rnum] -- replacement Integer              (0)'
      write(LER,*)'-debug     -- print Integer time series only'
      write(LER,*)'-K         -- kill & zero out trace with NaN      '
      write(LER,*)'-L         -- optional comment line to be put at '
      write(LER,*)'              the top of the printout file'
      write(LER,*)'-i[inc]    -- sample increment for -K mode     (1)'
      write(LER,*)'-V         -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'nanfix -N[] -s[] -e[] -ns[] -ne[] -rs[] -re[] -inf '
      write(LER,*)'        [ [ -nan -F[] ] -rep -debug [ -K -i[] ] ] -V'
      write(LER,*)' '

      return
      end

c
c  command line parsing subroutine 
c

      subroutine cmdln (ntap,otap,ist,iend,irs,ire,ns,ne,debug,nanamp,
     :     repamp,verbos,kill,inc,ftap,inf,label)

#include <f77/iounit.h>

      integer    argis,ist,iend,irs,ire, nanamp, inc, luftap

      real       repamp
     
      character  ntap*(*),otap*(*), ftap*(*), label*(*)

      logical    verbos, debug, kill, inf

          debug = (argis('-debug') .gt. 0)
          kill  = (argis('-K') .gt. 0)
          inf  = (argis('-inf') .gt. 0)
          call argi4('-e',iend,0,0)
          call argi4('-nan',nanamp,-1,-1)
          call argi4('-ne',ne,0,0)
          call argi4('-ns',ns,0,0)
          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argstr('-F',ftap,' ',' ') 
          call argstr('-L',label,' ',' ') 
          call argr4('-rep',repamp,0.0,0.0)
          call argi4('-re',ire,0,0)
          call argi4('-rs',irs,1,1)
          call argi4('-s',ist,1,1)
          call argi4('-i',inc,1,1)
          verbos = (argis('-V') .gt. 0)

          if (ftap(1:1) .ne. ' ') then
             call alloclun ( luftap )
             open (unit=luftap, file=ftap, status = 'old', iostat=ierr)
             if (ierr .ne. 0) then
                write(LERR,*)'WARNING from nanfix:'
                write(LERR,*)'Could not open nan integer file using'
                write(LERR,*)'-F[] cmd line entry - check exeistence'
             endif

           rewind luftap
           read (luftap, *) nanamp
           write (LER ,*)'Read integer ',nanamp,' from file ',ftap
         endif
 

      return
      end

      subroutine verbal(nsamp,nsi,ntrc,nrec,iform,ist,iend,ns,ne,irs,
     :     ire,nanamp, repamp, debug,kill,inc,inf)

#include <f77/iounit.h>

      
      integer nsamp,nsi,ntrc,nrec,iform,ist,iend,inc
      integer ns,ne, nanamp
      real repamp
      logical debug, kill, inf

        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi
        write(LERR,*) ' Input Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*)
        write(LERR,*)' Values read from command line'
        write(LERR,*)
        write(LERR,*) ' window start in samples   =  ', ist
        write(LERR,*) ' window end in samples     =  ', iend
        write(LERR,*) ' trace start       =  ', ns
        write(LERR,*) ' trace end       =  ', ne
        write(LERR,*) ' record start       =  ', irs
        write(LERR,*) ' record end         =  ', ire
	if (nanamp .ne. -1) then
          write(LERR,*) ' NaN search amplitude = ',nanamp
	  if (inf) then
            write(LER,*) 'NANFIX: Warning - The -inf flag is ',
     :		'ignored when -nan is specified'
	    inf = .false.
	  endif
	else
	  if (inf) then
            write(LERR,*) ' Using automatic NaN and +/- ',
     :		'Infinity detection'
	  else
            write(LERR,*) ' Using automatic NaN detection'
	  endif
	endif
        write(LERR,*) ' NaN replacement amplitude =',repamp
        if ( debug ) write(LERR,*)
     :'running in NaN amplitude search mode'
        if ( kill ) then
	if ( inf ) then
          write(LERR,*) 'Kill any trace with even one NaN or +/- ',
     :		'Infinity value'
	else
          write(LERR,*) 'Kill any trace with even one NaN value'
	endif
        write(LERR,*) 'NaN sample detect increment= ',inc
        endif
        write(LERR,*) ' '

      return
      end
