C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c     -----------------  Main Routine -----------------------

c     Program Changes:

c      - original written: December 15, 1994

c     Program Description:
c     
c     Changed the output xgraph files to be optional 
c     make the offset calculation a floating point operation, I don't
c     know why it wasn't originally.   J. M. Gridley 8-97

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis
      integer     xlow, xhigh, ylow, yhigh, maxdist

      real        tri ( SZLNHD )
      real        tol, value, dx, xmin

      character   ntap*255, otap*255, name*8
      character   hword1*6, hword2*6, hword3*6, hword4*6
      character   xtap1*255, xtap2*255, xtap3*255

      logical     verbos, Head_Word, Dist_Check
      logical      Survey_Limits, Range

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    Trace_WorkSpace

      pointer (wkadr1, Trace_WorkSpace(200000))

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_hword1,l_hword1,ln_hword1
      integer ifmt_hword2,l_hword2,ln_hword2
      integer ifmt_hword3,l_hword3,ln_hword3
      integer ifmt_hword4,l_hword4,ln_hword4
c Initialize variables

      data abort/1/
      data name/"NAVCHECK"/
      Head_Word = .false.
      Dist_Check = .false.
      Survey_Limits = .false.

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos,
     :     hword1, hword2, hword3, hword4, value, tol,
     :     dx, xmin, xlow, xhigh, ylow, yhigh,
     :     Head_Word, Dist_Check, Survey_Limits,
     :     xtap1, xtap2, maxdist, Range, xtap3)

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      
      luin2= 11
      luin3= 12
      luin4= 13

           
         
         if (xtap1(1:1) .ne. ' ') then
            len1=lenth(xtap1)
            open (unit=luin2, file=xtap1(1:len1), status='unknown')
         endif

         if (xtap2(1:1) .ne. ' ') then
            len2=lenth(xtap2)
            open (unit=luin3, file=xtap2(1:len2), status='unknown')
         endif

         if (xtap3(1:1) .ne. ' ') then
            len3=lenth(xtap3)
            open (unit=luin4, file=xtap3(1:len3), status='unknown')
         endif
         
  
         
c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'NAVCHECK: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu( hword1 ,ifmt_hword1,l_hword1,ln_hword1,
     1		TRACEHEADER)
      call savelu( hword2 ,ifmt_hword2,l_hword2,ln_hword2,
     1		TRACEHEADER)
      call savelu( hword3 ,ifmt_hword3,l_hword3,ln_hword3,
     1		TRACEHEADER)
      call savelu( hword4 ,ifmt_hword4,l_hword4,ln_hword4,
     1		TRACEHEADER)



c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, verbos,
     :     hword1, hword2, hword3, hword4, value, tol, xmin, dx,
     :     xlow, xhigh, ylow, yhigh, Dist_Check, Survey_Limits,
     :     Head_Word, maxdist, Range)

c dynamic memory allocation:  

      TraceSize = nsamp 
      call galloc (wkadr1, TraceSize * SZSMPD, errcd1, abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

      write(LERR,*)'Record  Trace '



c initialize memory
         
      call vclr ( Trace_WorkSpace, 1, TraceSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

            call saver2 ( itr, ifmt_hword1, l_hword1,
     :           ln_hword1, ival_head_1 , 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_hword2, l_hword2,
     :           ln_hword2, ival_head_2 , 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_hword3, l_hword3,
     :           ln_hword3, ival_head_3, 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_hword4, l_hword4,
     :           ln_hword4, ival_head_4, 
     :           TRACEHEADER )

         
c process only live traces

            if ( StaCor .ne. 30000) then

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c load trace portion of itr[] to real array tri[]
 
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
c========================================================================
c
c check for bad navigation by checking specific values in the header
c
               if (Head_Word) then
               if (float(ival_head_1) .eq. value) then
                  StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                 TRACEHEADER)  
                  write(LERR,*)JJ,KK, 
     :                 '  Flagged Dead  Bad Navigation'
                  if (xtap1(1:1) .ne. ' ') then
                     write(luin2,*)JJ,KK
               endif
                  go to 998
               endif

               if (float(ival_head_2) .eq. value) then
                  StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                 TRACEHEADER) 
               
                  write(LERR,*)JJ,KK,
     :                 '  Flagged Dead Bad Navigation'
                  if (xtap1(1:1) .ne. ' ') then
                     write(luin2,*)JJ,KK
                  endif
                  go to 998
               endif

               if (float(ival_head_3) .eq. value) then
                  StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                 TRACEHEADER)  
                  write(LERR,*)JJ,KK
     :                 , '  Flagged Dead  Bad Navigation'
                  if (xtap1(1:1) .ne. ' ') then
                     write(luin2,*)JJ,KK
                  endif
                  go to 998
               endif

               if (float(ival_head_4) .eq. value) then
                  StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                 TRACEHEADER)  
                  write(LERR,*)JJ,KK,
     :                 '  Flagged Dead  Bad Navigation'
                  if (xtap1(1:1) .ne. ' ') then
                     write(luin2,*)JJ,KK     
               endif
               go to 998
               endif
            endif
c========================================================================
c
c     Check the survey limits (assuming rectangular survey only!!!)
c
            if (Survey_Limits) then

               if (ival_head_1 .lt. xlow .or. ival_head_1 
     :              .gt. xhigh) then
                   StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                  TRACEHEADER)  
                  write(LERR,*)JJ,KK,
     :                 '  Flagged Dead  Outside Survey Limits'
                  if (xtap1(1:1) .ne. ' ') then
                     write(luin2,*)JJ,KK   
                  endif
                  go to 998
               endif

               if (ival_head_2 .lt. ylow .or. ival_head_2 
     :              .gt. yhigh) then
                   StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                  TRACEHEADER)  
                  write(LERR,*)JJ,KK,
     :                 '  Flagged Dead  Outside Survey Limits'  
                  if (xtap1(1:1) .ne. ' ') then
                     write(luin2,*)JJ,KK
                  endif
                  go to 998
               endif

               if (ival_head_3 .lt. xlow .or. ival_head_3 
     :              .gt. xhigh) then
                   StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                  TRACEHEADER)  
                  write(LERR,*)JJ,KK,
     :                 '  Flagged Dead  Outside Survey Limits'  
                  
                  if (xtap1(1:1) .ne. ' ') then
                      write(luin2,*)JJ,KK
               endif
                  go to 998
               endif

               if (ival_head_4 .lt. ylow .or. ival_head_4 
     :              .gt. yhigh) then
                   StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                  TRACEHEADER)  
                  write(LERR,*)JJ,KK,
     :                 '  Flagged Dead  Outside Survey Limits'
                  if (xtap1(1:1) .ne. ' ') then 
                  write(luin2,*)JJ,KK
               endif
                  go to 998
               endif

            endif

c========================================================================
c
c Check for bad navigation based on a bad distance calculation
            if (Dist_Check) then
               ixmin = int (xmin)
               idx = int (dx)
               itol= int(tol)

               dist_mod =  ((float(TrcNum - 1) * dx ) + xmin)

cjmg               idist_mod =  (((TrcNum - 1) * idx ) + ixmin)

cjmg		if (DstSgn .le. idist_mod + itol )then
		if (float(DstSgn) .le. (dist_mod + tol) )then

                  go to 998
               else
                  StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                 TRACEHEADER)  
                  write(LERR,*)JJ,KK,DstSgn,dist_mod,
     :                 abs(float(DstSgn)-dist_mod),
     :                 '  Flagged Dead Bad Distance'  
                  if (xtap2(1:1) .ne. ' ') then    
                     write(luin3,*)JJ,KK 
                  endif
                  go to 998
               endif
            endif
c========================================================================
c Check range limit of DstSgn  and flag if >maxdist
            if(Range) then
               if(DstSgn .gt. maxdist) then
                  StaCor = 30000
                  call savew2(itr,ifmt_StaCor,l_StaCor,
     :                 ln_StaCor,StaCor, 
     :                 TRACEHEADER)  
                  write(LERR,*)JJ,KK,DstSgn,maxdist,
     :                 '  Flagged Dead Bad Range' 
                  if (xtap3(1:1) .ne. ' ') then
                  write(luin4,*)JJ,KK
               endif
                  go to 998
               endif
            endif
c========================================================================
 998           call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )

            endif
c write output data

            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 
      
      if(xtap1(1:1) .ne. ' ') close ( luin2 )
      if(xtap2(1:1) .ne. ' ') close ( luin3 )
      if(xtap3(1:1) .ne. ' ') close ( luin4 )
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'navcheck: Normal Termination'
      write(LER,*)'navcheck: Normal Termination'
      stop

 999  continue

      call lbclos( luin )
      call lbclos ( luout )
      if(xtap1(1:1) .ne. ' ') close ( luin2 )
      if(xtap2(1:1) .ne. ' ') close ( luin3 )
      if(xtap3(1:1) .ne. ' ') close ( luin4 )
    
      write(LERR,*)'navcheck: ABNORMAL Termination'
      write(LER,*)'navcheck: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for NAVCHECK	'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input +.................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-X1[]  -- xgraph file of bad nav       (optional)'
      write(LER,*)'-X2[]  -- xgraph file of bad distance  (optional)'
      write(LER,*)'-X3[]  -- xgraph file of bad ranges    (optional)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-value -- key value to search header word for(0.)'
      write(LER,*)'-tol   -- tolerance for distance exclusion  (25.)'
      write(LER,*)'-mindist-- minimum distance for spread       (0.)'
      write(LER,*)'-maxdist--max allowable distance for DstSgn(5000)'
      write(LER,*)'-dx    -- group interval of spread          (25.)'
      write(LER,*)'-hw1   -- header word 1                  (SrPtXC)'
      write(LER,*)'-hw2   -- header word 2                  (SrPtYC)'
      write(LER,*)'-hw3   -- header word 3                  (RcPtXC)'
      write(LER,*)'-hw4   -- header word 4                  (RcPtXC)'
      write(LER,*)'-xmin  -- X min survey limit                  (0)'
      write(LER,*)'-xmax  -- X max survey limit                  (0)'
      write(LER,*)'-ymin  -- Y min survey limit                  (0)'
      write(LER,*)'-ymax  -- Y max survey limit                  (0)'
      write(LER,*)'-W     -- Use Header Word Limit Check'
      write(LER,*)'-D     -- Use Distance Calculation Check'
      write(LER,*)'-L     -- Use Survey Limits as Check'
      write(LER,*)'-R     -- Use maximum range limit of DstSgn      '
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'     navcheck -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -hw1[] -hw2[] -hw3[] -hw4[] '
      write(LER,*)'            -value[] -tol[] -mindist[] -dx[]'
      write(LER,*)'             -maxdist[] '
      write(LER,*)'            -xmin[] -xmax[] -ymin[] -ymax[] '
      write(LER,*)'             [ -W -D -L -R -V ]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

     
      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos,
     :     hword1, hword2, hword3, hword4, value, tol,
     :     dx, xmin, xlow, xhigh, ylow, yhigh,
     :     Head_Word, Dist_Check, Survey_Limits,
     :     xtap1, xtap2, maxdist, Range, xtap3)
#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis
      integer    xlow, xhigh, ylow, yhigh, maxdist
      character  ntap*(*), otap*(*), name*(*)
      character  hword1*(*),hword2*(*)
      character  hword3*(*),hword4*(*)
      character  xtap1*(*), xtap2*(*), xtap3*(*)
      real tol, value, dx, xmin

      logical    verbos, Head_Word, Dist_Check
      logical    Survey_Limits, Range

      call argr4 ( '-dx', dx, 25., 25. )
      Dist_Check = (argis('-D') .gt. 0)
     
      call argi4 ( '-e', iend, 0, 0 )
      
      call argstr ('-hw1', hword1 , 'SrPtXC', 'SrPtXC' )
      call argstr ('-hw2', hword2 , 'SrPtYC', 'SrPtYC' )
      call argstr ('-hw3', hword3 , 'RcPtXC', 'RcPtXC' )
      call argstr ('-hw4', hword4 , 'RcPtYC', 'RcPtYC' )

      Survey_Limits = (argis('-L') .gt. 0)

      call argr4 ( '-maxdist', maxdist, 5000, 5000 )
      call argr4 ( '-mindist', xmin, 0., 0. )

      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argstr ( '-N', ntap, ' ', ' ' ) 
      
      call argstr ( '-O', otap, ' ', ' ' ) 

      Range = (argis('-R') .gt. 0)
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )
      
      call argi4 ( '-s', ist, 1, 1 )

      call argr4 ( '-tol', tol, 1., 1. )

      call argr4 ( '-value', value, 0., 0. )

      verbos = (argis('-V') .gt. 0)

      Head_Word = (argis('-W') .gt. 0)

      call argi4 ( '-xmax', xhigh, 0., 0. )
      call argi4 ( '-xmin', xlow, 0., 0. )
      call argstr ( '-X1', xtap1, ' ', ' ' ) 
      call argstr ( '-X2', xtap2, ' ', ' ' ) 
      call argstr ( '-X3', xtap3, ' ', ' ' ) 
      call argi4 ( '-ymax', yhigh, 0., 0. )
      call argi4 ( '-ymin', ylow, 0., 0. )

c check for extraneous arguments ad abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars

      subroutine verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, verbos,
     :     hword1, hword2, hword3, hword4, value, tol, xmin, dx,
     :     xlow, xhigh, ylow, yhigh, Dist_Check, Survey_Limits,
     :     Head_Word, maxdist, Range)    

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi
      integer    xlow, xhigh, ylow, yhigh, maxdist
      character  ntap*(*), otap*(*)
      character  hword1*(*),hword2*(*)
      character  hword3*(*),hword4*(*)
   
      real      tol, value, dx, xmin
      logical    verbos, Head_Word, Dist_Check
      logical   Survey_Limits,Range

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' header word 1          = ',hword1
      write(LERR,*) ' header word 2          = ',hword2
      write(LERR,*) ' header word 3          = ',hword3
      write(LERR,*) ' header word 4          = ',hword4
      write(LERR,*) ' tolerance value        = ',tol
      write(LERR,*) ' header word kill value = ',value
      write(LERR,*) ' minimum group distance = ',xmin
      write(LERR,*) ' group interval         = ',dx
      write(LERR,*) ' maxdist (range)        = ',maxdist
      write(LERR,*) ' '
      write(LERR,*) ' '
      if (Survey_Limits) then
         write(LERR,*) 'Checking base on Survey Limits'
         write(LERR,*) ' survey  limits, xmin  = ',xlow
         write(LERR,*) ' survey  limits, xmax  = ',xhigh
         write(LERR,*) ' survey  limits, ymin  = ',ylow
         write(LERR,*) ' survey  limits, ymax  = ',yhigh
      endif
      if (Dist_Check) then
         write(LERR,*) 'Checking Based on Distance Calcultion'
      endif
      if (Head_Word) then
         write(LERR,*) 'Checking based on header word limit'
      endif
      if (Range) then
         write(LERR,*) 'Checking DstSgn  based on Range
     :        Limit of ', maxdist
      endif
      if ( verbos )  then
         write(LERR,*) ' verbose printout requested'
         write(LERR,*) ' Live Long and Process'
      endif
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





