C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ---------------------------NMOREC -------------------------------------
c
c Author>Paul G. A. Garossino (TRC:2F04:3192) 5/30/91
c
c bdnmo accesses both seismic amplitude and velocity sis trace files
c and either applies or removes normal moveout using
c the full nmo map or alternately the portion before or after the 
c last velocity cross-over in the nmo map.
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
c
c ----- dimension standard USP variables -----
c

      integer     itr(SZLNHD),ntr(SZLNHD)
      integer     nsamp,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     nsampv, nsiv, ntrcv, nrecv, iformv
      integer     luin,luout,luvel
      integer     nbytes,obytes,lbytes,lbyout
      integer     nvbytes,lvbytes
      integer     irs,ire,ns,ne
      integer     vrs,vre,vst,ved
      integer     argis,pipe,JJ,KK

      real        tri( SZSMPM )
      
      character  ntap*200,otap*200,name*6,vtap*200

      logical    verbos

c ----- integer USP variables -----
c
c	itr()      : data trace plus header from rtape
c       ntr()      : velocity trace plus header from rtape 
c       itrh()     : trace headers for record
c       nsamp      : number of samples of input trace
c       nsi        : input sample interval
c       ntrc       : input traces/record
c       ntrco      : output traces/record
c       nrec       : input number of records
c       nreco      : output number of records
c       iform      : format of data
c       nsampv     : number of samples of velocity trace
c       nsiv       : velocity sample interval
c       ntrcv      : velocity traces/record
c       nrecv      : number of velocity records
c       iformv     : format of velocity data
c       luin       : input device
c       luout      : output device
c       luvel      : velocity device
c       lbytes     : number of bytes in lineheader
c       nbytes     : number of input bytes when trace is read
c       lvbytes    : number of bytes in velocity lineheader
c       nvbytes    : number of input bytes when velocity trace is read
c       obytes     : number of bytes to output when processed trace is written
c       argis      : an int function returns 1 if element requested is there 0 if not
c       ist        : window start time (ms)
c       iend       : window end time (ms)
c       irs        : record start
c       ire        : record end
c       ns         : trace start
c       ne         : trace end
c       pipe       : pipe device
c       JJ,KK      : loop counters
c
c ----- real USP variables -----
c
c	tri()      : data trace time series 
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	ntap       : input data file name 
c       otap       : output file name
c       vtap       : input velocity file name 
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c
c ----- set up printout files -----
c

#include <f77/pid.h>

c
c ----- dimension program specific variables -----
c

      integer    vflag
      integer    i,kv,nn,luXY
      integer    DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer    StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer    errcd1,errcd2,errcd3,errcd4,errcd5,errcd6,abort
      integer    errcd7,errcd8,errcd9

      logical    dead
      integer    itrhd
      real       v_trace,nmo_trace,rnum,work,t,data,offs
      real       dt,dist,yp1,ypn

      pointer     (wkadr1, v_trace(200000))
      pointer     (wkadr2, nmo_trace(200000))
      pointer     (wkadr3, rnum(200000))
      pointer     (wkadr4, work(200000))
      pointer     (wkadr5, t(200000))
      pointer     (wkadr6, data(200000))
      pointer     (wkadr7, itrhd(200000))
      pointer     (wkadr8, offs(200000))
      pointer     (wkadr9, dead(200000))

      logical    stat, remove, reverse, top, bot, XY

c
c ----- integer program variables -----
c
c     StaCor    : static value
c     vflag     : multiple velocity function switch
c     kv        : reverse velocity function counter
c     nn        : trace to output nmo-map for
c     luXY      : output nmo-map device
c     errcd1...5: used with galloc
c     abort     : used with galloc
c
c ----- real program variables -----
c
c     v_trace()    : velocity trace
c     nmo_trace()  : nmo corrected/removed trace
c     rnum()       : random number array 
c     work()       : work space
c     t()          : array of sample value reference 1 ... nsamp
c     yp1          : value of second derivative at sample 1
c     ypn          : value of second derivative at nsamp
c
c ----- logical program variables -----
c
c     stat   : flag for static application
c     remove : flag for nmo removal/application
c     reverse: flag for input velocity fcn in reverse order
c     top    : flag to use top of nmo map only
c     bot    : flag to use bottom of nmo map only
c     XY     : flag to output nmo-map
c----------------------------------------------------------------

c
c ----- initialize necessary variables -----
c

      data lbytes/0/
      datan bytes/0/
      dataname/'NMOREC'/
      data lvbytes/0/
      data nvbytes/0/
      data lbyout/0/
      data pipe/3/
      data vst/1/
      data ved/1/
      data abort/0/

c ----- use natural cubic spline -----
c    see Numerical Recipes pp.88
c    flags so that second derivative will be zero on each boundary
c

      yp1 = 1.e+31
      ypn = 1.e+31

      top = .false.
      bot = .false.
      XY = .false.
      verbos = .false.

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c open printout files
 
#include <f77/open.h>
 
c read program parameters from command line card image file

      call cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,remove,
     :    reverse,top,bot,nn,verbos)

c
c ----- open input and output units -----
c     0 = default stdin
c     1 = default stdout
c

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c
c ----- if nn.gt.0 open xgraph input file and write header
c

      if(nn.gt.0) then
        
         luXY = 4
         open(luXY,file='nmorec_fcn',status='unknown',err=990)
         write(luXY,*)'" trace ',nn
         
      endif

c
c ----- open velocity dataset -----
c

      if (vtap .ne. ' ') then

         call getln(luvel,vtap,'r',-1)

      else

         write(LERR,*)'nmorec assumed to be running inside IKP'

         if (reverse) then

            write(LERR,*)'velocity is in a pipe and -B option'
            write(LERR,*)'(reverse) option cannot be used.  If this'
            write(LERR,*)'option must be used -v[] with a disk file'
            go to 999

         endif

         call sisfdfit (luvel, pipe)

      endif

      if  (luvel .lt. 0)   then

         write(LERR,*)'Fatal: velocity file ',vtap,' not found.'
         write(LERR,*)' '
         stop

      endif

c
c ----- read input lineheader -----
c

      call rtape(luin,itr,lbytes)

      if(lbytes .eq. 0) then
         write(LERR,*)'FATAL: no lineheader found on',ntap
         write(LERR,*)' '
         stop
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers 
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c
c ----- save ususal lineheader values -----
c

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c
c ----- print historical line header to printout file -----
c

      call hlhprt (itr, lbytes, name, 6, LERR)

c
c ----- check compatibility of command line entries -----
c 

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c
c ----- malloc only space we're going to use -----
c

      item  =         nsamp  * SZSMPD
      itemd = ntrco * nsamp  * SZSMPD
      itemi = ntrco * ITRWRD * SZSMPD
      itemx = ntrco          * SZSMPD

      call galloc(wkadr1,item,errcd1,abort)
      call galloc(wkadr2,item,errcd2,abort)
      call galloc(wkadr3,item,errcd3,abort)
      call galloc(wkadr4,item,errcd4,abort)
      call galloc(wkadr5,item,errcd5,abort)
      call galloc(wkadr6,itemd,errcd6,abort)
      call galloc(wkadr7,itemi,errcd7,abort)
      call galloc(wkadr8,itemx,errcd8,abort)
      call galloc(wkadr9,itemx,errcd9,abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 ) then

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 5*item,'  bytes'
         write(LERR,*) itemd ,'  bytes'
         write(LERR,*) itemi ,'  bytes'
         write(LERR,*) itemx ,'  bytes'
         write(LERR,*) itemx ,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 5*item,'  bytes'
         write(LERR,*) itemd ,'  bytes'
         write(LERR,*) itemi ,'  bytes'
         write(LERR,*) itemx ,'  bytes'
         write(LERR,*) itemx ,'  bytes'
         write(LER,*)' '
         go to 999

      else

         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)  5*item,'  bytes'
         write(LERR,*) itemd ,'  bytes'
         write(LERR,*) itemi ,'  bytes'
         write(LERR,*) itemx ,'  bytes'
         write(LERR,*) itemx ,'  bytes'
         write(LERR,*)' '

      endif

c
c ----- modify line header for output -----
c
#include <f77/saveh.h>

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c
c ----- number output bytes -----
c

      obytes = SZTRHD + nsamp * SZSMPD

      call savhlh(itr,lbytes,lbyout)
      call wrtape(luout,itr,lbyout)

c
c ----- velocity data -----
c

      vflag=1
      lvbytes=0

c read the velocity dataset line header

      call rtape(luvel,ntr,lvbytes)

      if(lvbytes .eq. 0) then
         write(LERR,*)'FATAL: no lineheader read on',vtap
         write(LERR,*)' '
         stop
      endif

      call saver(ntr, 'NumSmp', nsampv, LINHED)
      call saver(ntr, 'SmpInt', nsiv  , LINHED)
      call saver(ntr, 'NumTrc', ntrcv , LINHED)
      call saver(ntr, 'NumRec', nrecv , LINHED)
      call saver(ntr, 'Format', iformv, LINHED)

c
c ----- vflag=0 single velocity function -----
c       vflag=1 multiple velocity function

      if(nrecv.le.1) vflag=0

      if(nsampv .lt. nsamp) then
         write(LERR,*)' '
         write(LERR,*)'NMOREC: seismic -- velocity dataset mismatch'
         write(LERR,*)'       Number of samples in seismic dataset = ',
     :        nsamp
         write(LERR,*)'       Number of samples in velocity dataset = ',
     :        nsampv
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'NMOREC: seismic -- velocity dataset mismatch'
         write(LER,*)'       Number of samples in seismic dataset = ',
     :        nsamp
         write(LER,*)'       Number of samples in velocity dataset = ',
     :        nsampv
         write(LER,*)'FATAL'
         goto 999
      endif

      call cmdchk(vst,ved,vrs,vre,ntrcv,nrecv)

c
c ----- printout -----
c

      call verbal(nsamp,nsi,ntrc,nrec,nrecv,iform,nsampv,nsiv,ntrcv,
     :     iformv,reverse,vflag,stat,remove,top,bot,vtap,ntap,otap)

c
c ----- handle velocity data -----
c

      nvbytes=1

c
c ----- multiple velocity functions -----
c

      if(vflag .eq. 1) then

         if(vrs .le. nrecv) then
            call recskp(1,vrs-1,luvel,ntrcv,ntr)
         else
            write(LERR,*)' start record to skip to exceeds number'
            write(LERR,*)' records on velocity file'
            write(LERR,*)' check velin run to make sure your velocity'
            write(LERR,*)' model covers the part of the data between'
            write(LERR,*)' records ',vrs,' and ', vre
            stop
         endif

c
c ----- single velocity function -----
c

      elseif(vflag .eq. 0) then

         nvbytes=0
         call rtape(luvel,ntr,nvbytes)
         if(nvbytes .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'NMOREC: No velocity data found after '
            write(LERR,*)'       lineheader in ',vtap,' check '
            write(LERR,*)'       velin run thoroughly.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'NMOREC: No velocity data found after '
            write(LER,*)'       lineheader in ',vtap,' check '
            write(LER,*)'       velin run thoroughly.'
            write(LER,*)'FATAL'
            goto 999
         endif
         call vmov(ntr(ITHWP1),1,v_trace,1,nsampv)

         if(verbos) then
            write(LERR,*)'velocity'
            write(LERR,777)(v_trace(i),i=1,nsampv)
 777        format(10f8.2)
         endif

c
c ----- check for valid velocities -----
c

         call dotpr (v_trace,1,v_trace,1,vdot,nsampv)
         if (abs(vdot) .lt. 1.e-06) then
            write(LERR,*)' '
            write(LERR,*)'NMOREC: Velocity trace contains zeros'
            write(LERR,*)'       Check the velin step thoroughly'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'NMOREC: Velocity trace contains zeros'
            write(LER,*)'       Check the velin step thoroughly'
            write(LER,*)'FATAL '
            go to 999
         endif


      endif

c
c ----- read trace -----
c
c   when reading velocity traces make sure that if we run out of vel. traces
c   we use the last vel trace to the end of the line...
c

      kv = 0
      nvbytes=1

c
c ----- compute sample interval in secs -----
c       take care of micro secs if necessary
c

      if (nsi .le. 64) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif

c
c ----- generate random number array for spline routine -----
c       required when leading zeroes on trace data cause
c       ieee underflow errors in spline.
c

      call vrand(911,rnum,1,nsamp)

      do i=1,nsamp
         rnum(i)=rnum(i)*1.0e-21
         t(i) = float(i)
      enddo

c
c ----- BEGIN PROCESSING -----
c     skip unwanted records
c

      call recskp(1,irs-1,luin,ntrc,itr)

      DO 100 JJ = irs, ire

         if(vflag.eq.1.and.nvbytes.ne.0.and.JJ.le.vre)then

            nvbytes=0

c
c ----- read in reverse order ?
c
            
            if(reverse)then

               kv = kv + 1

               call skipt (luvel, ntrcv*(vre-kv), idummy)


            endif

c
c ----- read velocity data -----
c

            call rtape(luvel,ntr,nvbytes)
            if(nvbytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'NMOREC: Premature EOF on Velocity Dataset'
               write(LERR,*)'       at sequential record number ',JJ
               write(LERR,*)'FATAL' 
               write(LER,*)' '
               write(LER,*)'NMOREC: Premature EOF on Velocity Dataset'
               write(LER,*)'       at sequential record number ',JJ
               write(LER,*)'FATAL' 
               goto 999
            endif
            call vmov (ntr(ITHWP1),1,v_trace,1,nsampv)

c
c ----- check for valid data -----
c

            call dotpr (v_trace,1,v_trace,1,vdot,nsampv)

            if (abs(vdot) .lt. 1.e-06) then
               write(LERR,*)' '
               write(LERR,*)'NMOREC: Velocity trace contains zeros'
               write(LERR,*)'       Check the velin step thoroughly'
               write(LERR,*)'FATAL '
               write(LER,*)' '
               write(LER,*)'NMOREC: Velocity trace contains zeros'
               write(LER,*)'       Check the velin step thoroughly'
               write(LER,*)'FATAL '
               go to 999
            endif

            if(verbos) then
               write(LERR,*)'rec ',JJ,' velocity'
               write(LERR,777)(v_trace(i),i=1,nsampv)
            endif

         endif


c
c ----- skip to start trace -----
c

         call trcskp(jj,1,ns-1,luin,ntrc,itr)

         call vclr (data, 1, ntrco*nsamp)
         ic = 0
         DO 99  KK = ns,ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of seismic dataset:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            ic = ic + 1
            istrt = (ic-1) * nsamp
            ishdr = (ic-1) * ITRWRD

            call vmov(itr(ITHWP1),1,tri,1,nsamp)

            call vmov (itr, 1, itrhd(ishdr+1), 1, ITRWRD)

            call vclr(work,1,nsamp)

c
c ----- skip if trace is flagged dead ----- 
c
 
            call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor,
     :           TRACEHEADER)
                
            IF ( StaCor .ne. 30000 ) THEN

c
c ----- get absolute value of trace distance from traceheader -----
c

               call saver2 ( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               dist = float(iabs(DstSgn))

               offs (ic) = dist
               dead (ic) = .false.

               StaCor=StaCor/nsi
               if(.not.stat) StaCor=1
               if(StaCor .eq. 0) StaCor=1

               if(StaCor .lt. 0) then

                  StaCor=-StaCor
                  call vmov(tri(StaCor),1,data(istrt+1),1,nsamp)

               else

                  call vmov(tri(1),1,data(istrt+StaCor),1,nsamp)

               endif

            ELSE

               dead (ic) = .true.

            ENDIF

 99      CONTINUE
 
c
c ----- set XY flag to true if trace is nn -------
c       this will enable the output of the xgraph moveout map
c       file nmorec_fcn for this trace
c

         ic = 0
         DO  kk = ns, ne

            ic = ic + 1
            istrt = (ic-1) * nsamp
            ishdr = (ic-1) * ITRWRD

            call vmov (itrhd(ishdr+1), 1, itr , 1, ITRWRD)
            call vmov (data (istrt+1), 1, work, 1, nsamp)

            IF (.not. dead(ic)) THEN

               dist = offs (ic)
               if(KK.eq.nn)XY = .true.

               call bdsub(work,dt,nsamp,dist,v_trace,remove,nmo_trace,
     :              top,bot,rnum,XY,luXY,yp1,ypn,t)

            ELSE

               call vclr(nmo_trace,1,nsamp)


            ENDIF

            call vmov(nmo_trace(1),1,itr(ITHWP1),1,nsamp)
            call wrtape (luout,itr,obytes)

         ENDDO
c
c ----- skip to end of record -----
c

         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

 100  CONTINUE

c normal termination
  
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )
      if(nn.gt.0)close(luXY)

      write(LERR,*)'end of nmorec, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)' nmorec: Normal Termination'
      stop

      
 990  continue

c
c ----- unable to open xgraph data output file -----
c

      write(LERR,*)' '
      write(LERR,*)'NMOREC: Unable to open nmorec_fcn xgraph outpt file'
      write(LERR,*)'       Check that you have write permission in    '
      write(LERR,*)'       directory where you started this process.'
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'NMOREC: Unable to open nmorec_fcn xgraph output file'
      write(LER,*)'       Check that you have write permission in    '
      write(LER,*)'       directory where you started this process.'
      write(LER,*)'FATAL'
      stop

c
c ----- close data files -----
c

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )

      if(nn.gt.0)close(luXY)

      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' nmorec: Abnormal Termination'

      stop
      end
