C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c subroutine splint
c
c from Numerical Recipes - Press etal - pp 89
c
      subroutine splint(xa,ya,y2a,n,x,y)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer n
      real xa(*),ya(*),y2a(*)
      real x,y

      klo=1
      khi=n
1	if (khi-klo.gt.1)then
		k=(khi+klo)/2
		if(xa(k).gt.x)then
			khi=k
		else
			klo=k
		endif
	 goto 1
	endif
      h=xa(khi)-xa(klo)
      if(h.eq.0)goto 999
      a=(xa(khi)-x)/h
      b=(x-xa(klo))/h
      y=a*ya(klo)+b*ya(khi)+
     *         ((a**3-a)*y2a(klo)+(b**3-b)*y2a(khi))*(h**2)/6.
      return
999   write (LERR,*)'xa(',klo,') == xa(',khi,') == ',xa(klo) 
      write(LERR,*)' FATAL -- for now'
      stop
      end
