C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine restore(u,uout,
     1                   hbegin,lenhed,nsamp,nbytes_out,
     2                   luin,luout,lerr,npad,ntr,nrec_inline,
     3                   lenu2,ntrpline,nline)

      implicit none

c declare variables passed from calling routine

      integer lenhed, nsamp, hbegin, nbytes_out, luin, luout
      integer lerr, npad, ntr, nrec_inline, lenu2, ntrpline
      integer nline

      real u(hbegin:nsamp,-npad+1:ntr+npad)
      real uout(hbegin:nsamp,ntr)

c declare local variables

      integer jtr, iline
      integer jtrtotal, irec, nbytes

c this is the record loop....nline is the number of records
c in the original unpartitioned dataset

      do 80000 iline = 1, nline

         jtrtotal=0

c read in a partitioned record, strip off pad and output center part
c keep going until original record is reconstructed
 
         do 70000 irec= 1 ,nrec_inline

            do 20000 jtr=-npad+1,ntr+npad
              
               nbytes = 0
               call rtape(luin,u(hbegin,jtr),nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input!'
                  write(LERR,*)'  rec= ',irec,'  trace= ',jtr
               endif

20000       continue

c-----------------------------------------------------------------------
c      drop the pad and write out the central bit
c-----------------------------------------------------------------------
            do 40000 jtr= 1, ntr

               jtrtotal=jtrtotal+1
  
               if(jtrtotal .gt. ntrpline) then
                  go to 80000
               endif

               call wrtape(luout,u(hbegin,jtr),nbytes_out)

40000       continue

70000    continue

80000 continue

      return
      end

