C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bulkrot (nsamp, nsampo, n2, n22, degrad, radeg,
     1                    xtr, work, amp, phz, ctr, rot)

      integer nsamp, nsampo, n2, n22
      real    xtr(*), work(*), amp(*), phz(*)
      complex ctr(*)
 
         call vmov   (xtr,1,work,1,nsampo)
         call vclr   (ctr, 1, n2)
         call rfftb  (work,ctr,n2,1)
         call rfftsc (ctr,n2,2,1)

            call cvabs  (ctr, 2, amp,  1, n2)

            do  i = 1, n22
                xr = real  ( ctr (i) )
                xi = aimag ( ctr (i) )
                if (xr .eq. 0.) then
                   phz (i) = 0.
                else
                   phzi = radeg * atan2 ( xi , xr )
                   phzi = phzi + rot
                   phz (i) = degrad * phzi
                endif
            enddo
            call cvmexp (phz , 1, amp, 1, ctr, 2, nsamp)
            call rfftsc (ctr, n2, -2, 0)
            call rffti  (ctr, xtr, n2)

      return
      end
