C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
        subroutine iphase(tri, nsamp, npts, npts21,
     1                    npoint, dt, fl, fh, twopi,
     2                    degrad, radeg, phzi, rot)

c  routine to compute instantaneous phase

c  input
c       tri  --  inpute data
c     nsamp  --  number input data samples
c        dt  --  sample interval in sec
c      npts  --  power of 2 # samples
c    npts21  --  npts/2 + 1
c    npoint  --  length of smoother
c        fl  --  lo cut freq
c        fh  --  hi cut freq

c  output
c    tri     --  output data

#include <f77/lhdrsz.h>

        integer   nsamp, npts, npts21
        real      tri(*), phzi(*)
        complex   data
        pointer   (wkdata, data(1))
        real      triphz, h, q, e
        pointer   (wktriphz, triphz(1))
        pointer   (wkh, h(1))
        pointer   (wkq, q(1))
        pointer   (wke, e(1))
        real      rot, sumn, sumd, dt, fl, fh
        integer   jsz, ierr, ierrt, iabort, npoint
        logical   twopi

        iabort = 0
        ierrt  = 0
        call sizefloat(jsz)
        itemr = npts * jsz
        itemc = npts * jsz * 2
        call galloc (wkdata, itemc, ierr, iabort)
        ierrt = ierrt + ierr
        call galloc (wktriphz, itemr, ierr, iabort)
        ierrt = ierrt + ierr
        call galloc (wkh, itemr, ierr, iabort)
        ierrt = ierrt + ierr
        call galloc (wkq, itemr, ierr, iabort)
        ierrt = ierrt + ierr
        call galloc (wke, itemr, ierr, iabort)
        ierrt = ierrt + ierr
        if (ierrt .ne. 0) then
           write(LERR,*)'instphz:'
           write(LERR,*)'Unable to allocate memory -- FATAL'
           write(LER ,*)'instphz:'
           write(LER ,*)'Unable to allocate memory -- FATAL'
           call ccexit (666)
        endif

        do 2000 i=1,NPTS
                if(i.le.nsamp)then
                        data(i) = cmplx(tri(i),0.0)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 2000   continue

        call four(data,npts,-1,dt,df)
c-----
c       form spectra to get quadrature
c-----
        do 3000 i=1, npts
                if(i.lt.npts21)then
                        data(i) = 2.0*data(i)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 3000   continue
        call four(data,npts,+1,dt,df)

c-----
c       now real(data) is the original time series
c       and aimag(data) is the quadrature series
c-----
        do 4000 i=1,nsamp
                h(i) = real(data(i))
                q(i) = aimag(data(i))
                e(i) = sqrt (h(i)*h(i) + q(i)*q(i))
 4000   continue

c-----
c       weighted average of frequency
c       use a NPOINT smoothing operator
c-----
        do 6000 i=1,nsamp
                sumn = 0.0
                sumd = 0.0
                jlow = i - NPOINT/2
                jup  = i + NPOINT/2
                if(jlow.lt.1)jlow = 1
                if(jup .gt.nsamp)jup=nsamp
                do 6001 j=jlow,jup
                        sumn = sumn + q(j)
                        sumd = sumd + h(j)
 6001           continue
                triphz(i) = radeg * atan2( sumn,sumd )
 6000   continue

c---
c  drum unwraps the phase into a continuous function (seems to work the best
c  for this inverse inst phz application). piwrap wraps the phz betw +/- pi
c  For the current code twopi = .false.
c---
        if (twopi) then
            call piwrap (triphz, nsamp)
        else
            call drum (nsamp, triphz)
        endif


c---
c  add in input phase trace to computed instantaneous phase
c---
        do  i = 1, nsamp
            triphz(i) = degrad * (triphz(i) - rot * phzi(i))
        enddo
c---
c  build new hilb & quad traces from new inst phase and old envelope
c  [envelope must stay same if only phase changes]
c---
        do  i = 1, nsamp
            h(i) = e(i) * cos(triphz(i))
            q(i) = e(i) * sin(triphz(i))
        enddo

c---
c  The new trace is just the real part of the complex vector h(i) + j.q(i)
c  i.e. we don't need to do any forward & reverse FT's
c---
        do  i = 1, nsamp
            tri(i) = h(i)
        enddo

        call gfree (wkdata)
        call gfree (wktriphz)
        call gfree (wkh)
        call gfree (wkq)
        call gfree (wke)

        return
        end


