C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  amplitude picking subroutine
 
      subroutine aubs (ntrc,nsamp,dt,icenter,igate,nlags,
     1                 array1,live,stor,nsi,maa,scalef,
     3                 dedtrc,irec, wts)
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c  input:

c    ntrc  - # traces per gather
c   nsamp  - # samples per trace
c     nsi  - sample interval (ms)
c      dt  - sample interval in secs
c  icenter - window center time in samples
c   igate  - total window length in samples
c    nlags - # of x-corr lags (either neg or pos)
c   nlags2 - nlags / 2
c   niter  - # iterations
c   maa    - flags Maximum Absolute Amplitude scaling (else average - aaa)
c  dedtrc  - vector of 0s & 1s signifying dead & live traces in rec
c  array1  - original input gather (ntrc x nsamp)

c output:

c   stor   - vector of residual shifts (ms)
c    wts   - vector of correlation values (for last iteration)


      real      array1(nsamp, ntrc)
      real      wts   (ntrc)
      real      stor(*)
      integer   dedtrc(*)

      real      e, scalef
      real      work(SZLNHD)
      logical   maa

      e = 1.e-30

      if (live .lt. 1) then
         do  j = 1, ntrc
             stor (j) = 0.
             wts  (j) = 0.
             if (dedtrc(j) .eq. 0) dedtrc(j) = 1
         enddo
         return
      endif

c__________	
c initialize
c__________	
       igate2  = igate/2
       i1      =  icenter - igate2
       i2      = i1 + igate - 1
       if (i2 .gt. nsamp) then
          im = i2 - nsamp
          igatei = igate - im
       else
          igatei = igate
       endif

       call vclr (stor , 1, ntrc)

c-----
c within time window compute maximum abs amplitude
c-----
       IF (maa) THEN

	   DO  jj = 1, ntrc

              IF (dedtrc(jj) .eq. 0) then

                 do  i = 1, igatei
                     work (i) = array1(i1+i-1,jj)
                 enddo

                 call maxmgv (work, 1, wmax, lndx, igatei)

                 wts  (jj) = 1.0
                 stor (jj) = alog ( scalef / (wmax + e) )

	      ENDIF

	   ENDDO

c-----
c within time window compute average abs amplitude
c-----
       ELSE

           DO  jj = 1, ntrc
 
              IF (dedtrc(jj) .eq. 0) then
 
                 lsamps = 0
                 do  i = 1, igatei
                     work (i) = array1(i1+i-1,jj)
                     if (abs(work(i)) .gt. e) lsamps = lsamps + 1
                 enddo
 
                 call svemg  (work, 1, wmax, igatei)

                 wmax = wmax / float (lsamps)

                 wts  (jj) = 1.0
                 stor (jj) = alog ( scalef / (wmax + e) )
 
              ENDIF
 
           ENDDO


       ENDIF
c----------

      return
      end
