C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine centr1 (li, di, times, nt, nsi, icenter,
     1                   limin, limax, dimin, dimax, nli, ndi)

#include <f77/iounit.h>

c-----
c    2D interpolation:
c    given the current record number (RecNum, LI, DI, etc)
c    compute an interpolated time based on a vector of
c    control records and times
c    assumption: the input record index increments by 1
c-----

      integer  li, di, limin, limax, dimin, dimax, nli, ndi
      real     times (ndi, nli)
      integer  icenter, nsi

      J = li - limin + 1
      I = di - dimin + 1

      t = times (I,J)
      icenter = t / float (nsi)

      return
      end
