C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 



c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     qhed ( SZLNHD )
      integer     itr  ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes, nwds
      integer     luin , luout, lbytes, nbytes, lbyout, qbytes
      integer     irs,ire,ns,ne
      integer     ordfft, limin, limax, dimin, dimax
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      integer     itrhdr
      real        bigar1, bigar2, corr, acor
      pointer     (wkadri, itrhdr(1))
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, bigar2(1))
      pointer     (wkcorr, corr  (1))
      pointer     (wkacor, acor  (1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum, currec, dphind, linind
      integer     stacor
      real        r_start, r_stat
      integer     idead, ibad
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD ), weight ( SZLNHD ), omega ( SZLNHD )
      real        freqs (100)
      integer     record, li, di
      real        wts, stor, start, timer, wcent, wrk1, wrk2, sig
      pointer     (wkwts  , wts   (1000000))
      pointer     (wktimer, timer (1000000))
      pointer     (wkrec  , record(1000000))
      pointer     (wkli   , li    (1000000))
      pointer     (wkdi   , di    (1000000))
      pointer     (wkstor , stor  (1000000))
      pointer     (wkstart, start (1000000))
      pointer     (wkwcent, wcent (1000000))
      pointer     (wkwrk1 , wrk1  (1000000))
      pointer     (wkwrk2 , wrk2  (1000000))
      pointer     (wksig  , sig   (1000000))
      real        pi, scalef
      integer     dedtrc ( SZLNHD )
      complex     expphi ( SZLNHD )
      character   ntap * 256, otap * 256, name*6, stawrdi*6
      character   qtap * 256, ttap * 256, etap * 256, tag * 5
      character   stawrdo*6, recwrd*6, ptap * 256, card * 80
      logical     verbos, heap1, heap2, heapi, scor, xsd, flat
      logical     first, pick, gli, smooth, env, datum, sgn, vverbos
      logical     period, model, phase, D3, heap, pamp, medn
      logical     winhdr, qctime, track
      integer     argis, adatum, qlin, maa
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
c     equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'PICKER'/
      data pi / 3.14159265 /
      data nwds / 25 /, idead/-10000/, ibad/-10000/
      data first/.true./
      data winhdr/.false./
      data qhed/SZLNHD*0/
      data tag/'rtldt'/
 
c-----
c     read program parameters from command line card image file
c-----
	
      if (( argis ( '-?' ) .gt. 0 ) .or.
     :    ( argis ( '-h' ) .gt. 0 ) .or.
     :    ( argis ( '-help' ) .gt. 0 ) )then
            call help()
            stop
      endif
 
      call alloclun (luetap)
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,fl,fc,fh,stawrdi,uniti,
     1             itime,iwind,nlags, niter,verbos,scor,stawrdo,unito,
     2             ptap,xsd,flat,tdatum,pick,thr,gli,smooth,iord,env,
     3             datum,sgn,qtap,ttap,recwrd,vverbos,period,norder,
     4             model,dmin,dmax,etap,luetap, phase, D3, tol,medn,
     5             limin, limax, dimin, dimax, pamp, maa, scalef,winhdr,
     6             qctime, track, nstk )
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (qtap(1:1) .ne. ' ') then
          call getln(qlin, qtap,'w', -1)
          if (qlin .le. 0) then
             write(LERR,*)'picker error:'
             write(LERR,*)'Could not open QC output data set'
             write(LERR,*)'Will proceed without QC'
             qlin = -999
          endif
      else
          qlin = -999
      endif
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'PRGM: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('ShtDep',ifmt_ShtDep,l_ShtDep,ln_ShtDep,TRACEHEADER)
      call savelu('UphlTm',ifmt_UphlTm,l_UphlTm,ln_UphlTm,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)

      if (stawrdi(1:1) .ne. ' ') then
      call savelu(stawrdi,ifmt_stawrdi,l_stawrdi,ln_stawrdi,TRACEHEADER)
      endif
      call savelu(stawrdo,ifmt_stawrdo,l_stawrdo,ln_stawrdo,TRACEHEADER)
      call savelu(recwrd,ifmt_recwrd,l_recwrd,ln_recwrd,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs. 
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)

      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
      write(LERR,*)'stawrdi,ifmti,l_stawrdi,length= ',
     1             ifmt_stawrdi,l_stawrdi,ln_stawrdi
      write(LERR,*)'stawrdo,ifmto,l_stawrdo,length= ',
     1             ifmt_stawrdo,l_stawrdo,ln_stawrdo
      write(LERR,*)'recwrd,ifmto,l_recwrd,length= ',
     1             ifmt_recwrd,l_recwrd,ln_recwrd
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
      if (ntrc .eq. 1) then
         write(LERR,*)'FATAL HEART ATTACK in picker:'
         write(LERR,*)'must have multi-trace records'
         write(LER ,*)'FATAL HEART ATTACK in picker:'
         write(LER ,*)'must have multi-trace records'
         stop 666
      endif

      IF (D3) THEN

       if (limin.eq.0 .and. limax.eq.0 .and. dimin.eq.0 .and. dimax.eq.0
     1    ) then
          call saver(itr, 'MnLnIn', limin, LINHED)
          call saver(itr, 'MxLnIn', limax, LINHED)
          call saver(itr, 'MnDpIn', dimin, LINHED)
          call saver(itr, 'MxDpIn', dimax, LINHED)
       endif
       if (limin.eq.0 .and. limax.eq.0 .and. dimin.eq.0 .and. dimax.eq.0
     1    ) then
          write(LERR,*)'FATAL ERROR in picker 3D application:'
          write(LERR,*)'Min & Max LI & DI are zero. Either fix line'
          write(LERR,*)'header or input limits on cmd line'
          write(LER ,*)'FATAL ERROR in picker 3D application:'
          write(LER ,*)'Min & Max LI & DI are zero. Either fix line'
          write(LER ,*)'header or input limits on cmd line'
          stop
       endif
       nli = limax - limin + 1
       ndi = dimax - dimin + 1

      ENDIF

c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c-----
c  get storage for residuals and weights
c  (record-by-record each of ntrc traces)
c-----
      heap = .true.
      item = ntrc
      jtem = 1
      if (winhdr) jtem = ntrc
      call galloc (wkstor , item * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      call galloc (wkstart, item * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      call galloc (wkwcent, jtem * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      call galloc (wkwrk1 , item * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      call galloc (wkwrk2 , item * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      call galloc (wksig  , item * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.

      if (.not. heap) then
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) jtem,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) jtem,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
      endif

      do  i = 1, ntrc
          sig (i) = 1.0
      enddo

c-----
c   set gate length in samples
c-----
      igate   = iwind / nsi
      igate2  = igate / 2

c-----
c     read in optional file of record - time control
c     points for the correlation window
c     sort into ascending record order
c-----
      if (ttap(1:1) .ne. ' ') then
     
c-----
c  count times in file
c-----
         nf = 0
         do while (1 .eq. 1)
             read (57, '(a80)', end = 11) card
             nf = nf + 1
         enddo
11       continue
         if (nf .eq. 0) then
         write(LERR,*)'FATAL ERROR in picker:'
         write(LERR,*)'Hit end of file and detected no entries. Is'
         write(LERR,*)'file empty?'
         write(LER ,*)'FATAL ERROR in picker:'
         write(LER ,*)'Hit end of file and detected no entries. Is'
         write(LER ,*)'file empty?'
         stop
         else
         write(LERR,*)' '
         write(LERR,*)'Read ',nf,' lines from times file'
         endif

         IF (D3) THEN

            heap = .true.
            item = nli * ndi
            iteml = nli
            itemd = ndi
            call galloc (wkrec,   SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            call galloc (wktimer, item * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            call galloc (wkli   , nf * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            call galloc (wkdi   , nf * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.

            call timrd1 (57, nf, li, di, timer, nli, ndi,
     1                   limin, limax, dimin, dimax, nsi)

         ELSE

            heap = .true.
            item = nf
            call galloc (wkrec, item * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            call galloc (wktimer, item * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.

            if (.not. heap) then
               write(LER ,*)' '
               write(LER ,*)'Unable to allocate workspace:'
               write(LER ,*) item,'  bytes'
               write(LER ,*) item,'  bytes'
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)'Allocating workspace:'
               write(LERR,*) item,'  bytes'
               write(LERR,*) item,'  bytes'
            endif


            call timred (57, nt, record, timer)	
            if (nt .gt. nf) then
               write(LER ,*)'FATAL ERROR in picker:'
               write(LER ,*)'Not enough lines in times file'
               stop
            endif

            do  j = 1, nt
                write(LERR,*)'J= ',j,' rec = ',record(j),' time= ',
     1                       timer(j)
            enddo

         ENDIF
c-----
c     window center times extracted from trace header word
c-----
      elseif (winhdr) then
c-----
c     otherwise a global wiindow center time will 
c     be used. Check window bounds and correct if necessary
c-----
      else

         icenter = itime / nsi
         icentmn = icenter
         icentmx = icenter
         ist = icentmn - igate2
         if (ist .le. 0) then
         igate  = igate + ist
         igate2 = igate / 2
         write(LERR,*)' '
         write(LERR,*)'WARNING from picker:'
         write(LERR,*)'Gate is too long causing start time of window'
         write(LERR,*)'to be less than 1 sample.  Gate will be reset'
         write(LERR,*)'to start at sample 1 and extend to ',nsi*igate,
     1                'ms'
         write(LERR,*)' '
         endif
         ied = icentmx + igate2
         if (ied .gt. nsamp) then
         igate  = igate - (ied-nsamp)
         igate2 = igate / 2
         write(LERR,*)' '
         write(LERR,*)'WARNING from picker:'
         write(LERR,*)'Gate is too long causing end time of window to'
         write(LERR,*)'exceed ',nsamp,' samples.  Gate will be reset to'
         write(LERR,*)igate,' samples long.'
         write(LERR,*)' '
         endif

      endif


      igate4  = igate / 4 + 1
      if (nlags .ge. igate/2) then
         write(LERR,*)' '
         write(LERR,*)'Too many lags: cannot be > 1/2 window length= ',
     1   igate
         nlags = igate/2 - 1
         write(LERR,*)'Resetting lags to ',nlags
      endif
      nlags2  = 2 * nlags + 1

c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      if (scor) then
          itemi = ntrc * (ITRWRD + nwds) * SZSMPD
          nhdr  = ITRWRD + nwds
      else
          itemi = ntrc * ITRWRD * SZSMPD
          nhdr  = ITRWRD
      endif
      item1 = ntrc * nsamp  * SZSMPD
      item2 = ntrc * igate  * SZSMPD
      itemp = ntrc *          SZSMPD
      itemc = ntrc * ntrc   * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkadri, itemi, errcdi, aborti)
      if (errcdi .ne. 0.) heapi = .false.
      call galloc (wkadr1, item1, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.
      call galloc (wkadr2, item2, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
      call galloc (wkwts  , itemp, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
      call galloc (wkcorr , itemc, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
      call galloc (wkacor , itemc, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.
 
 
      if (.not. heap1 .or. .not. heap2 .or. .not. heapi) then
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemi,'  bytes'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LER ,*) itemp,'  bytes'
         write(LER ,*) itemc,'  bytes'
         write(LER ,*) itemc,'  bytes'
         write(LER ,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemc,'  bytes'
         write(LERR,*) itemc,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
 
c----------------------
c  number output bytes
      if (scor) then

          nwds2 = 2 * nwds
          call savew (itr,'NumSmp', nwds , LINHED)
          call savew (itr,'Format',   3  , LINHED)
          call savew (itr,'MxUHTm',   1  , LINHED)
          call savew (itr,'MnUHTm',   1  , LINHED)
          call savew (itr,'MxTrOf',   1  , LINHED)
          call savew (itr,'MnTrOf',   0  , LINHED)
          call savew (itr,'NmDpIn',   0  , LINHED)
C         call savew (itr,'StWdFl',   1  , LINHED)
          call savew (itr,'DptInt',   0  , LINHED)
          call savew (itr,'TmMsSl',   1  , LINHED)
          call savew (itr,'TmSlIn',nsamps, LINHED)
          if (unito .eq. 1.0) unito = 100.
          if (pamp) unito = 1.0
          iunito = unito
          call savew (itr,'ReSpFm',iunito, LINHED)

          obytes = (ITRWRD + nwds)  * SZSMPD
      else

          obytes = (ITRWRD + nsamp) * SZSMPD
      endif
      write(LERR,*)'output bytes= ',obytes
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
      if ( qlin .gt. 0) then
         qbytes = SZTRHD + igate   * SZSMPD
         call savew (itr,'NumSmp', igate, LINHED)
         call savew (itr,'NumRec', nrecc, LINHED)
         call savew (itr,'NumTrc', 1    , LINHED)
         call wrtape ( qlin, itr, lbyout                 )
         call savew2(qhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               1 , TRACEHEADER)
      endif
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      si = nsi
      dt = real (nsi) * unitsc

      fnyq = .5 / (dt)
      if (fh .eq. 0.) fh = .5 * fnyq

      IF (phase .OR. pamp) THEN

             fc = fh
             freqs (1) = fh

      ELSE

             if (fc .eq. 0.) then
                 fc = fh
             endif

                if (period) then
                   t1 = 1. / (unitsc * fc)
                   t2 = 1. / (unitsc * fh)
                   delt = (t2 - t1) / float(niter-1)
                   do  j = 1, niter+1
                       tj = t1 + (j-1) * delt
                       freqs (j) = 1. / (unitsc * tj)
                   enddo
                else
                   delf = (fh - fc) / float(niter-1)
                   do  j = 1, niter
                       freqs (j) = fc + (j-1) * delf
                   enddo
                endif

      ENDIF

       IF (smooth) THEN
          if (iord .eq. 0) iord = ntrc / 10
          if (iord .le. 5) then
             write(LERR,*)'WARNING from picker:'
             write(LERR,*)'smoothing order= ',iord,' very low...'
             write(LERR,*)'will set equal to 5'
             iord = 5
             if (iord .le. ntrc) iord = ntrc
             write(LERR,*)'WARNING from picker:'
             write(LERR,*)'smoothing order= ',iord,' still too low...'
             write(LERR,*)'will set equal to # trc/rec= ',ntrc
          endif
       ENDIF
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
      		call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  itime,iwind,nlags,niter,igate,model,
     2                  ist,ied,icenter,fl,fc,fh,ntap,otap,
     3                  stawrdi,stawrdo,uniti,unito,tdatum,ptap,
     4                  xsd,gli,flat,smooth,iord,datum,sgn,
     5                  ttap,recwrd,freqs,dmin,dmax,phase,D3,
     6                  limin,limax,dimin,dimax,pamp,maa,scalef,
     7                  winhdr,track)
c     end if

      scalef = scalef * 2047. / 100.
 
      if (.not. phase) then
         nu = ordfft ( nsamp )
         nsamp2 = 2 ** nu
         domega = 2. * pi / nsamp2
         do  iomega = 1, nsamp2/2
             omega(iomega) = (iomega - 1) * domega
         enddo
      endif

          call vfill (1.0, weight, 1, igate)
          do  i = 1, igate4
              ang = 3.14159265 * float(igate4-i+1)/float(igate4)
              wt = .5 * (1. + cos ( ang ))
              weight(i) = wt
              j = igate - i + 1
              weight(j) = wt
          enddo
          if ( track ) then
             do i = 1, igate
                weight (i) = sqrt ( weight(i) )
             enddo
          endif

      write(LERR,*)' '
      write(LERR,*)'Window Weights'
      write(LERR,*) (weight(ii),ii=1,igate)
      write(LERR,*)' '
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      ir = 0
      do 1000 jj = irs, ire
 
            ir   = ir + 1
            ic   = 0
            il   = 0
            live = 0
            ipk  = 0
            wtim = 0.
            call vclr (wrk1, 1, ntrc)
            call vclr (wrk2, 1, ntrc)

            do 1001  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
 
c------
c     use previously derived pointers to trace header values
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist  , TRACEHEADER)
                  dist = idist

                  if (winhdr) then
                     if (stacor .ne. 30000) then
                         il = il + 1
                         call saver2(itr,ifmt_recwrd,l_recwrd,ln_recwrd,
     1                               iwcent , TRACEHEADER)
                         wcent (il) = float (iwcent) / si
                         wtim = wtim + wcent (il)
                     endif
                  else
                     call saver2(itr,ifmt_recwrd,l_recwrd, ln_recwrd,
     1                           ireccr , TRACEHEADER)
                  endif

                  if (phase) then
                     start (kk) = 0.
                  else
                     if (stawrdi(1:1) .ne. ' ') then
cmam....determine if word is real or integer
                       if ((ifmt_stawrdi .eq. SAVE_SHORT_DEF) .or.
     :                     (ifmt_stawrdi .eq. SAVE_LONG_DEF)) then
cmam......word is integer
                        call saver2(itr,ifmt_stawrdi,l_stawrdi,
     2                              ln_stawrdi, istart , TRACEHEADER)
                        start (kk) = uniti * float ( istart )
                       else
cmam.....word is real or fake float
                        call saver2(itr,ifmt_stawrdi,l_stawrdi,
     2                              ln_stawrdi, r_start , TRACEHEADER)
                        start (kk) = uniti * r_start
                       endif

                     else
                        start (kk) = 0.
                     endif
                  endif

c------

                  ic = ic + 1
                  IF (stacor .eq. 30000) then
                     call vclr (tri,1,nsamp)
                     dedtrc (ic) = 1
                  ELSE
                     live = live + 1
                     wrk2 (live) = dist
                     if (dist .ge. dmin .AND. dist .le. dmax) then
                        dedtrc (ic) = 0
                     else
                        dedtrc (ic) = 1
                     endif
                     currec = ireccr
                     call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                           dphind , TRACEHEADER)
                     call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                           linind , TRACEHEADER)
                  ENDIF
 
c----------------------
c  pack data into array
                  istrc = (ic-1) * nsamp
                  ishdr = (ic-1) * nhdr
                  call vmov (tri,1, bigar1(istrc+1),1, nsamp)
                  call vmov (itr,1, itrhdr(ishdr+1),1,nhdr)
 
1001        continue
 
c-----
c  if using a window times file:
c  2D (keyed on records) & 3D (keyed on LI/DI numbers) options
c-----
            if (ttap(1:1) .ne. ' ' .AND. live .gt. 0) then

               if (D3) then
               call centr1 (linind, dphind, timer, nt, nsi, icenter,
     1                      limin, limax, dimin, dimax, nli, ndi)
               else
               call center (record, timer, nt, nsi, currec, icenter)
               endif

c-----
c  else we are using times extracted from the trace hdr word 'recwrd'
c  we will average all times in gather associated with live traces
c  and average the result.
c-----
            elseif (winhdr) then

               if (il .gt. 0) then
                  icenter = nint ( wtim / float(il) )
               else
                  icenter = 0
               endif

c-----
c  else we are using a global window time
c-----
            endif

            if ( qctime ) then
               if (icenter .gt. 0)
     1         write(LERR,231) tag,recnum,trcnum,linind,dphind,
     2                         nsi*icenter
231            format(a5,5x,5i10)
            endif

            if ( icenter .le. 0 ) then
              write(LERR,*)'window time < 0 for rec/trc,LI/DI ',
     1        recnum,trcnum,linind,dphind
              go to 900
            endif
 
c-----------------------
c  here's the meat...
c  pick the data
 
c----
c  pick times based on summing into reference trace & correlating
c----
            IF (model) THEN

                call subs  (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                     niter,omega,expphi,weight,bigar1,bigar2,
     2                     stor,fl,fc,fh,nsi,wts,nlags2,scor,thr,sgn,
     3                     dedtrc,JJ,smooth,iord,env,datum,adatum,
     4                     qlin,qhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                     qbytes,live,ipk,freqs,norder,vverbos,verbos,
     6                     nstk)

c----
c  pick times based on median shifts forming reference trace
c----
            ELSEIF (medn) THEN

                call subs2 (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                     niter,omega,expphi,weight,bigar1,bigar2,
     2                     stor,fl,fc,fh,nsi,wts,nlags2,scor,thr,sgn,
     3                     dedtrc,JJ,smooth,iord,env,datum,adatum,
     4                     qlin,qhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                     qbytes,live,ipk,freqs,norder,corr,acor,
     6                     verbos,vverbos)

c----
c  pick amplitudes or traces
c----
            ELSEIF (pamp) THEN

                call aubs  (ntrc,nsamp,dt,icenter,igate,nlags,
     1                     bigar1,live,stor,nsi,maa,scalef,
     2                     dedtrc,irec,wts)

c----
c  track event across gather using 1st live
c  trc as reference
c----
            ELSEIF (track) THEN

                call fltshift (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                     niter,omega,expphi,weight,bigar1,bigar2,
     2                     stor,fl,fc,fh,nsi,wts,nlags2,scor,thr,sgn,
     3                     dedtrc,JJ,smooth,iord,env,datum,adatum,
     4                     qlin,qhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                     qbytes,live,ipk,freqs,norder,vverbos,verbos,
     6                     recnum,nstk)

            ELSE

c----
c  pick phase rotations
c----
                call pubs  (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                     niter,weight,bigar1,bigar2,
     2                     stor,nsi,wts,nlags2,scor,thr,
     3                     dedtrc,JJ,
     4                     qlin,qhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                     qbytes,live,ipk,freqs,norder,vverbos,verbos)


            ENDIF
 
c-----------------------
                  IF (scor) THEN
                  call sput (ntrc,nsamp,stor,dedtrc,itrhdr,wts,
     1                       nwds,idead,ibad,nhdr,verbos,live,
     2                       ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3                       ifmt_RecNum,l_RecNum,ln_RecNum,
     4                       ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     5                       ifmt_RecInd,l_RecInd,ln_RecInd,
     6                       ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     7                       ifmt_DphInd,l_DphInd,ln_DphInd,
     8                       ifmt_LinInd,l_LinInd,ln_LinInd,
     9                       ITRWRD,SZLNHD,SZSMPD,itr,tri,iunito)
                  ENDIF

                  IF (ptap(1:1) .ne. ' ') THEN
                  call pput (stor,ntrc,nrecc,nsamp,nhdr,xsd,flat,JJ,
     1  start,tdatum,nsi,first,ir,dedtrc,gli,itrhdr,live,
     2  ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC, pick, verbos, wts,
     3  ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     4  ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,ifmt_RecInd,l_RecInd,ln_RecInd,
     5  ifmt_ShtDep,l_ShtDep,ln_ShtDep,ifmt_UphlTm,l_UphlTm,ln_UphlTm,
     6  ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     7  ifmt_GrpElv,l_GrpElv,ln_GrpElv,adatum,
     8  ITRWRD,SZLNHD,SZSMPD,itr)
                  ENDIF
 
900         continue
 
c---------------------
c  extract traces from
c  output array and
c  write output data
            ic = 0
            do 1002 kk = 1, ntrc
 
                  IF (.not. scor) THEN
                  istrc = (kk-1) * nsamp
                  call vmov (bigar1(istrc+1),1,itr(ITHWP1),1, nsamp)
                  ENDIF

                  ishdr = (kk-1) * nhdr
                  call vmov (itrhdr(ishdr+1),1,itr,1,nhdr)
                  
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
                  if (stacor .ne. 30000) then
                     ic = ic + 1
                     if (pick) then
                        stat  = adatum + tdatum - start (kk) - stor (kk)
                        istat = nint (unito * stat)
                        r_stat = unito * stat
                        wrk1 (ic) = unito * stat
                     else
                        istat = nint (unito * stor (kk))
                        r_stat = unito * stor (kk)
                        wrk1 (ic) = unito * stor (kk)
                     endif

cmam.....determine if output word is real or integer
                     if ((ifmt_stawrdo .eq. SAVE_SHORT_DEF) .or.
     :                   (ifmt_stawrdo .eq. sAVE_LONG_DEF)) then
cmam......word if integer
                       call savew2(itr,ifmt_stawrdo,l_stawrdo,
     1                           ln_stawrdo, istat  , TRACEHEADER)
                     else
cmam......word is real or fake float
                       call savew2(itr,ifmt_stawrdo,l_stawrdo,
     1                           ln_stawrdo, r_stat  , TRACEHEADER)
                     endif

                  endif
                  if (etap(1:1) .ne. ' ') then
                     call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                           dphind , TRACEHEADER)
                     call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                           linind , TRACEHEADER)
                     write (luetap,*) linind, dphind, stor(kk)
                  endif
                  if (vverbos) then
                  write(LERR,*)'rec/trc= ',recnum,kk,'  input shifts= ',
     1            start(kk),' residual= ',stor(kk),' pick= ',
     2            stat,' weight= ',wts(kk)
                  endif

                  call wrtape (luout, itr, obytes)
 
 
 1002             continue

                  if (verbos) then
                     do  i = 1, ic
                         wrk1 (i) = wrk1 (i) / unito
                     enddo
                     call stddev (wrk1, sd, ic)
                     if (ipk .eq. 2) then
                     a = (wrk1(2) - wrk1(1)) / (wrk2(2) - wrk2(1))
                     write(LERR,111)currec,linind,dphind,ipk,sd,a
                     write(LER ,111)currec,linind,dphind,ipk,sd,a
                     elseif (ipk .gt. 2) then
                     call lavo (ipk, wrk2, wrk1, a, b, sig)
                     write(LERR,111)currec,linind,dphind,ipk,sd,a
                     write(LER ,111)currec,linind,dphind,ipk,sd,a
111                  format('picker: rec ',i6,' LI/DI ',2i5,' trcs ',i5,
     1                      ' sdev/slope ',2f10.3)
                     endif
                  endif
 
 1000       continue
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      if (qlin .gt. 0) then
         call lbclos ( qlin )
      endif
      if (etap(1:1) .ne. ' ') then
         close (luetap)
      endif
 
            write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
            write(LER ,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      stop
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'picker flattens/picks/computes statics or phase rotations'
        write(LER,*)
     :'        within a window centered on a time'
        write(LER,*)
     :'see manual pages for details ( online by typing uman picker)'
        write(LER,*)' '
        write(LER,*)
     :'execute picker by typing picker and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -P [ptap]    (no file)         : output pick file name'
        write(LER,*)
     :' -Q [qtap]    (no file)         : optional QC ref stk trc file'
        write(LER,*)
     :' -C [etap]    (no file)         : optional QC ascii pick file'
        write(LER,*)
     :' -xsd                       output pick file is xsd format, else'
        write(LER,*)
     :' -gli                       output pick file is gli format, else'
        write(LER,*)
     :'                            output pick file is flat file format'
        write(LER,*)
     :' -rs[irs]     (default = first) : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)  : end record number'
        write(LER,*) ' '
        write(LER,*)
     :' -t[itime]    (default = none)  : window center time (ms)'
        write(LER,*)
     :' -T [ttap]    (no file)         : optional file of rec # - windw'
        write(LER,*)
     :'                                  center times, and optional'
        write(LER,*)
     :' -swr [recwrd](RecNum)          : trace hdr word for these recs'
        write(LER,*)
     :' -D3      window times file is from 3D data (keyed on LI & DI)'
        write(LER,*)
     :'          (header words will be LinInd DphInd)'
        write(LER,*)
     :' -WH      window center times extracted from -swr[] hdr word'
        write(LER,*)
     :' -w[iwind]    (default = none)  : window length (ms)'
        write(LER,*) ' '
        write(LER,*)
     :' -phase compute phase rotations'
        write(LER,*)
        write(LER,*)
     :' -amp   compute trace amplitudes (for surf consist amp correct',
     :'ion)'
        write(LER,*)
     :'        else compute statics/picks'
        write(LER,*)
     :' -scl[scl]   (default = 15)     : % 2047 scale factor'
        write(LER,*)
     :' -maa   for amplitude option flag max abs amplitude (else aaa)'
        write(LER,*) ' '
        write(LER,*)
     :' -i[iter]     (default = 5)     : number iterations'
        write(LER,*)
     :' -l[nlags]    (default = 10)    : number positive (or neg) lags'
        write(LER,*)
     :' -fl[fl]      (default = 1)     : fixed lo-cut frequency (Hz)'
        write(LER,*)
     :' -fc[fc]      (default = fh)    : starting hi-cut freq (Hz)'
        write(LER,*)
     :' -fh[fh]      (default = 1/2Nyq): ending hi-cut freq (Hz)'
        write(LER,*)
     :' -pd    equal period increment; else equal frequency incr.'
        write(LER,*)
     :' -b[thr]      (default = 0.0)   : correlation threshold'
        write(LER,*)
     :' -rmin[rmin]  (default = -Inf)  : minimum range to pick'
        write(LER,*)
     :' -rmax[rmax]  (default = +Inf)  : maximum range to pick'
        write(LER,*)
     :' -swi[stawrdi](default = none)  : input static word mnemonic'
        write(LER,*)
     :'    (float or fake float will be read as a floating pt value)'
        write(LER,*)
     :' -ui[uniti]     (default = 1.0) : scale factor for input static'
        write(LER,*)
     :' -d[tdatum]   (default = 0.0)   : input shift time datum (ms)'
        write(LER,*)
     :' -swo[stawrdo](default = StaCor): static word mnemonic to put ',
     :'shifts'
        write(LER,*)
     :'    (float or fake float is written as a floating pt value)'
        write(LER,*)
     :' -uo[unito]     (default = 1.0) : scale factor for output shifts'
        write(LER,*)
     :' -pick  include on cmd line if total pick is written into trc ',
     :'hdr and pick file, else'
        write(LER,*)
     :'        just shifts about -t[] are written (-pick & -scor are ',
     :'mutually exclusive)'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -scor  include on command line for scor type event file'
        write(LER,*)
     :' -F     follow event across gather using first live trace'
        write(LER,*)
     :' -s[nstk]   (default = 1)  : stack first nstk traces for ref trc'
        write(LER,*)
     :' -S     smooth final picks before writing to headers or files'
        write(LER,*)
     :' -sgn   use sign bit correlation; else use full amplitude'
        write(LER,*)
     :' -o[iord]   (def = #trcs/10)    : smoothing order'
        write(LER,*)
     :' -E     use trace envelope rather than trace'
        write(LER,*)
     :' -D     for vred input compute auto-datum'
        write(LER,*)
     :' -med   use median correlation matrix method; ptherwise use'
        write(LER,*)
     :'        model trace method of residual'
        write(LER,*)
     :' -QCT   output window center times into printout file. Lines'
        write(LER,*)
     :'        will be tagged with the alpha sequence rtldt'
        write(LER,*)
     :' -V     include on cmd line if verbose printout is desired'
        write(LER,*)
     :' -vV    include on cmd line if very verbose printout is desired'
        write(LER,*)
     :'usage:   picker -N[ntap] -O[otap] -rs[rs] -re[re] [ -t[] -T[]'
        write(LER,*)
     :'               -swr[] ] -w[] -i[] -l[] -fl[] -fc[] -fh[] -b[]'
        write(LER,*)
     :'               -rmin[] -rmax[] [ -D3 -pd -pick -scor -med -S -F]'
        write(LER,*)
     :'               [-s[] -o[] -E -D -sign -P[] -swi[] -ui[] -d[]'
        write(LER,*)
     :'               -Q -swo[] -uo[] -phase -amp -maa -scl[] -xsd -gli'
        write(LER,*)
     :'               -WH -C[] -QCT-V -vV ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,fl,fc,fh,stawrdi,uniti,
     1     itime,iwind,nlags,niter,verbos,scor,
     2     stawrdo,unito,ptap,xsd,flat,tdatum,pick,thr,gli,
     3     smooth,iord,env,datum,sgn,qtap,ttap,recwrd,
     4     vverbos,period,norder,model,dmin,dmax,etap,
     5     luetap, phase, D3, tol,medn,
     5     limin, limax, dimin, dimax, pamp, maa, scalef,
     7     winhdr, qctime, track, nstk )
 

c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     itime - I*4      center time of pick window (in ms)
c     iwind - I*4      window length (in ms)
c     ntraces-I*4      ntraces to use for designing model trace
c     nlags  -I*4      number of lags for x-correlation (in samples)
c     niter  -I*4      number of iterations to improve model trace
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), ptap*(*), stawrdi*6, stawrdo*6
      character   qtap*(*), ttap*(*), recwrd*6, etap*(*)
      integer     ns, ne, irs, ire, itime, iwind, nlags, niter
      integer     limin, limax, dimin, dimax
      real        uniti, unito, fl, fc, fh, scalef
      logical     verbos, scor,xsd,flat,gli,smooth, pick,env,datum,sgn
      logical     vverbos
      logical     period
      logical     model
      logical     phase
      logical     D3
      logical     medn
      logical     pamp, maa
      logical     winhdr
      logical     qctime 
      logical     track
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program prgm might be invoked in the following way:
 
c     prgm  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            flat   = .false.
            scor   = .false.
            xsd    = .false.
            gli    = .false.
            env    = .false.
            sgn    = .false.
            datum  = .false.
            model  = .true.
            medn   = .false.
            phase  = .false.
            pamp   = .false.
            maa    = .false.
            D3     = .false.
            winhdr = .false.
            qctime = .false.
            track  = .false.

            pamp   =   (argis('-amp') .gt. 0)

            call argr4 ( '-b', thr , 0.  , 0.    )

            call argstr( '-C', etap  , ' ', ' ' )

            call argi4 ( '-dimin', dimin ,  0  , 0    )
            call argi4 ( '-dimax', dimax ,  0  , 0    )
            D3     =   (argis('-D3') .gt. 0)
            datum  =   (argis('-D') .gt. 0)
            call argr4 ( '-d', tdatum , 0.  , 0.    )

            env    =   (argis('-E') .gt. 0)

            call argr4 ( '-fc', fc ,   0. ,  0.   )
            call argr4 ( '-fh', fh ,  0.  , 0.    )
            call argr4 ( '-fl', fl ,  1.0 , 1.0   )
            track  =   (argis('-F') .gt. 0)

            gli    =   (argis('-gli') .gt. 0)

            call argi4 ( '-i', niter ,   5  ,  5    )

            call argi4 ( '-limax', limax ,  0  , 0    )
            call argi4 ( '-limin', limin ,  0  , 0    )
            call argi4 ( '-l', nlags ,  10  , 10    )

            maa    =   (argis('-maa') .gt. 0)
            medn   =   (argis('-med') .gt. 0)

            call argi4 ( '-no', norder ,   8  ,  8    )
            ns = 0
            ne = 0
            call argstr( '-N', ntap, ' ', ' ' )

            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-o', iord ,  0  , 0    )

            phase  =   (argis('-phase') .gt. 0)
            pick   =   (argis('-pick') .gt. 0)
            period =   (argis('-pd') .gt. 0)
            call argstr( '-P', ptap, ' ', ' ' )

            qctime =   (argis('-QCT') .gt. 0)
            call argstr( '-Q', qtap  , ' ', ' ' )


            call argr4 ( '-rmax', dmax , +999999.  , +999999.    )
            call argr4 ( '-rmin', dmin , -999999.  , -999999.    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )

            scor   =   (argis('-scor') .gt. 0)
            sgn    =   (argis('-sign') .gt. 0)
            call argr4 ( '-scl', scalef , 15.  , 15.    )

            call argstr( '-swi', stawrdi, ' ', ' ' )
            if (stawrdi(1:1) .eq. ' ')
     1           call argstr( '-SWI', stawrdi, ' ', ' ' )

            call argstr( '-swo', stawrdo, ' ', ' ' )
            if (stawrdo(1:1) .eq. ' ')
     1           call argstr( '-SWO', stawrdo, ' ', ' ' )

            call argstr( '-swr', recwrd, 'RecNum', 'RecNum' )
            smooth =   (argis('-S') .gt. 0)
            call argi4 ( '-s', nstk ,  0  , 0    )

            call argr4 ( '-tol', tol ,   0. ,  0.   )
            call argstr( '-T', ttap  , ' ', ' ' )
            call argi4 ( '-t', itime ,   0  ,  0    )

            call argr4 ( '-ui', uniti , 1.  , 1.    )
            call argr4 ( '-uo', unito , 1.  , 1.    )

            vverbos=   (argis('-vV') .gt. 0)
            verbos =   (argis('-V') .gt. 0)

            winhdr =   (argis('-WH') .gt. 0)
            call argi4 ( '-w', iwind , 100  ,100    )

            xsd    =   (argis('-xsd') .gt. 0)





            if (ttap(1:1) .ne. ' ' .AND. recwrd(1:1) .eq. ' ') then

               recwrd = 'RecNum'
            elseif
     1              (winhdr .AND. recwrd(1:1) .eq. ' ') then

               write(LERR,*)' '
               write(LERR,*)'FATAL ERROR in picker cmd line:'
               write(LERR,*)'If window times taken trom trace hdr word'
               write(LERR,*)'then you must supply mnemonic -swr[]'
               write(LER ,*)' '
               write(LER ,*)'FATAL ERROR in picker cmd line:'
               write(LER ,*)'If window times taken trom trace hdr word'
               write(LER ,*)'then you must supply mnemonic -swr[]'
               stop
           endif


            if (winhdr) then
               ttap(1:1) = ' '
               D3 = .false.
            endif

            if ( track ) then
               model = .false.
               norder = 2
               if (nstk .eq. 0) nstk = 1
            endif

            if (medn) then
               model  = .false.
               pamp   = .false.
               phase  = .false.
            endif

            if (phase) then
               model  = .false.
               smooth = .false.
               datum  = .false.
               sgn    = .false.
               pamp   = .false.
               maa    = .false.
               if (stawrdo(1:1) .eq. ' ') stawrdo = 'SGRNum'
            else
               if (stawrdo(1:1) .eq. ' ') stawrdo = 'StaCor'
            endif

            if (pamp) then
               if (itime .eq. 0 .AND. .not.winhdr) then
                 write(LERR,*)' '
                 write(LERR,*)'FATAL ERROR in picker -amp option:'
                 write(LERR,*)'Must supply nonzero -t[] center time'
                 write(LER ,*)' '
                 write(LER ,*)'FATAL ERROR in picker -amp option:'
                 write(LER ,*)'Must supply nonzero -t[] center time'
                 stop 666
               endif
               niter = 1
               model  = .false.
               smooth = .false.
               phase  = .false.
               datum  = .false.
               sgn    = .false.
               pick   = .false.
               scor   = .true.
            endif

            if (.not.medn .AND. .not.phase .AND. .not.pamp
     1          .AND. .not.track) then
               model  = .true.
            endif

            if (niter .gt. 100) then
               write(LERR,*)' '
               write(LERR,*)'Warning from picker:'
               write(LERR,*)'Limited to 100 iterations'
               niter = 100
            endif

            if (.not.xsd .and. .not.gli) flat = .true.

            if (scor .AND. pick) then
               write(LERR,*)' '
               write(LERR,*)'FATAL ERROR in picker:'
               write(LERR,*)'Cannot use both -pick & -scor options'
               write(LER ,*)' '
               write(LER ,*)'FATAL ERROR in picker:'
               write(LER ,*)'Cannot use both -pick & -scor options'
               stop 666
            endif

            if (.not.phase .AND. .not.pamp .AND. .not.track .AND.
     1         (fl .ge. fc) ) then
               write(LERR,*)' '
               write(LERR,*)'FATAL ERROR in picker:'
               write(LERR,*)'Cannot have fc <= fl'
               write(LERR,*)'Change cmd line args and rerun'
               write(LER ,*)' '
               write(LER ,*)'FATAL ERROR in picker:'
               write(LER ,*)'Cannot have fc <= fl'
               write(LER ,*)'Change cmd line args and rerun'
               stop 911
            endif

            if (etap(1:1) .ne. ' ') then
              open (unit=luetap,file=etap,status='unknown',iostat=ierr)
   
              if (ierr .ne. 0) then
                 write(LERR,*)'Could not open output QC file ',etap
                 write(LERR,*)'or pick file already exists.  Remove'
                 write(LERR,*)'old pick file and rerun'
                 write(LER ,*)'Could not open output QC file ',etap
                 write(LER ,*)'or pick file already exists.  Remove'
                 write(LER ,*)'old pick file and rerun'
                 stop
              endif
              rewind luetap
            endif

            if (ptap(1:1) .ne. ' ') then
              open (unit=ludisk,file=ptap,status='unknown',iostat=ierr)
   
              if (ierr .ne. 0) then
                 write(LERR,*)'Could not open output pick file ',ptap
                 write(LERR,*)'or pick file already exists.  Remove'
                 write(LERR,*)'old pick file and rerun'
                 write(LER ,*)'Could not open output pick file ',ptap
                 write(LER ,*)'or pick file already exists.  Remove'
                 write(LER ,*)'old pick file and rerun'
                 stop
              endif
              rewind ludisk
            endif
           if (ttap(1:1) .ne. ' ') then
             open(unit=57, file=ttap, status='old', iostat=ierr)
             if(ierr .ne. 0) then
                write(LERR,*)'Could not open rec-time file'
                write(LERR,*)'Check existence'
                stop
             endif
           endif



c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  itime,iwind,nlags,niter,igate,model,
     2                  ist,ied,icenter,fl,fc,fh,ntap,otap,
     3                  stawrdi,stawrdo,uniti,unito,tdatum,ptap,
     4                  xsd,gli,flat,smooth,iord,datum,sgn,
     5                  ttap,recwrd,freqs,dmin,dmax,phase,D3,
     6                  limin,limax,dimin,dimax,pamp,maa,scalef,
     7                  winhdr,track)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     itime - I*4     center time of pick window (in ms)
c     iwind - I*4     length of pick window (in ms)
c     ntraces-I*4     number of traces composited in model trace
c     nlags  -I*4     number of lags (in samples) for x-correlation
c     niter  -I*4     number of iterations to improve model trace
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      real        freqs(*)
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), stawrdi*6, stawrdo*6, ptap*(*)
      character   ttap*(*), recwrd*6
      logical     xsd, gli, flat, smooth, datum, sgn, phase, D3
      logical     model,pamp,maa,winhdr,track
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*)' '

            if (phase) then

            write(LERR,*) ' Phase rotation computation'

            elseif (pamp) then

            write(LERR,*) ' Amplitude correction computation'
            if (maa) then
            write(LERR,*) '  ... Maximum absolute amplitude'
            else
            write(LERR,*) '  ... Average absolute amplitude'
            endif
            write(LERR,*) ' Amplitude scaler  = ',scalef,' (% 2047)'

            else

            write(LERR,*) ' Static computation...'
            if (model)
     1      write(LERR,*) ' ...using reference model trace method'
            if (.not.model)
     1      write(LERR,*) ' ...using correlation matrix method'

            endif

            write(LERR,*)' '
            write(LERR,*) ' window start sample = ', ist
            write(LERR,*) ' window end sample   = ', ied
            write(LERR,*) ' window length       = ', igate,' samps'
            if (ttap(1:1) .ne. ' ') then
            write(LERR,*) ' window center time from file = ',ttap
            write(LERR,*) ' trc header control word      = ',recwrd
            elseif (winhdr) then
            write(LERR,*) ' window center time from trace header word'
            write(LERR,*) ' trc header word window time  = ',recwrd
            else
            write(LERR,*) ' global window center      = ', itime,' ms'
            endif
            write(LERR,*)' Minimum range to pick= ', dmin
            write(LERR,*)' Maximum range to pick= ', dmax
            write(LERR,*)' '

            if ( track ) then

            write(LERR,*) ' Track event across gather using 1st live'
            write(LERR,*) ' trace. This trace will be reference trc'

            else

            write(LERR,*) ' fixed lo-cut freq   = ', fl,' Hz'
            if (.not. phase)
     1      write(LERR,*) ' start hi-cut freq   = ', fc,' Hz'
            write(LERR,*) ' end hi-cut freq     = ', fh,' Hz'
            if (.not. phase) then
            do  j = 1, niter
            write(LERR,*) ' pass band ',j,' low ',fl,' high ',freqs(j)
            enddo
            endif

            endif
            write(LERR,*)' '
            write(LERR,*) ' input static word   = ', stawrdi
cmam.........
            write(LERR,*) ' ...if a float or fakefloat mnemonic is'
            write(LERR,*) '    used, a floating point no. is read'
cmam.........
            write(LERR,*) ' ...its scale factor = ', uniti
            write(LERR,*) ' ...its time datum   = ', tdatum
            write(LERR,*) ' output static word  = ', stawrdo
cmam.........
            write(LERR,*) ' ...if a float or fakefloat mnemonic is'
            write(LERR,*) '    used, a floating point no. is written'
cmam.........
            write(LERR,*) ' ...its scale factor = ', unito
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (ptap(1:1) .ne. ' ') then
            write(LERR,*) ' output pick file    =  ', ptap
            if (xsd)
     1      write(LERR,*) ' pick file format is xsd'
            if (gli)
     1      write(LERR,*) ' pick file format is gli'
            if (flat)
     1      write(LERR,*) ' pick file format is flat'
            endif
            if (smooth) then
            write(LERR,*) ' smoothing order     = ', iord
            endif
            if (datum) then
            write(LERR,*) ' for vred input compute auto-datum'
            endif
            if (sgn) then
            write(LERR,*) ' use sign bit correlation'
            else
            write(LERR,*) ' correlate full amplitude'
            endif
            if (D3) then
            write(LERR,*) ' tracking time file based on 3D data'
            write(LERR,*) ' min LI = ', limin
            write(LERR,*) ' max LI = ', limax
            write(LERR,*) ' min DI = ', dimin
            write(LERR,*) ' max DI = ', dimax
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
