C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  iterative picking subroutine
 
c  users principle of program "pick"
 
      subroutine pubs (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                 niter,weight,array1,array2,
     2                 stor,nsi,wts,nlags2,scor,thr,
     3                 dedtrc,irec,
     4                 qlin,lhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                 qbytes,live,ipk,freqs,norder,vverbos,verbos)
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c  input:

c    ntrc  - # traces per gather
c   nsamp  - # samples per trace
c     nsi  - sample interval (ms)
c      dt  - sample interval in secs
c  icenter - window center time in samples
c   igate  - total window length in samples
c    nlags - # of x-corr lags (either neg or pos)
c   nlags2 - nlags / 2
c   niter  - # iterations
c     fl   - lowest bandpass frequency allowed (Hz)
c     fc   - starting high cut freq (Hz)
c     fh   - highest freq allowed
c   scor   - flags output as pick-type event tape (for input to scorusp)
c   pick   - flags total pick time is desired (guide function + residual)
c  irec    - current record number being processed
c  dedtrc  - vector of 0s & 1s signifying dead & live traces in rec
c  weight  - vector of window weights (i.e. tapering)
c  array1  - original input gather (ntrc x nsamp)

c output:

c   stor   - vector of residual shifts (ms)
c    wts   - vector of correlation values (for last iteration)
c  array1  - shifted traces in record (i.e. applied residual shifts)


      integer   lhed (*)
      real      array1(nsamp, ntrc)
      real      array2(igate, ntrc)
      real      wts   (ntrc)
      real      freqs (100)
      real      weight(*)
      real      stor(*)
      integer   dedtrc(*)

      real      x(SZLNHD),y(SZLNHD)
      real      work(SZLNHD)
      real      Q(SZLNHD), env(SZLNHD), phz(SZLNHD)
      integer   qlin, qbytes
      logical   scor, vverbos, verbos

      if (live .le. 1) then
         do  j = 1, ntrc
             stor (j) = 0.
             wts  (j) = 0.
             if (dedtrc(j) .eq. 0) dedtrc(j) = 1
         enddo
         return
      endif

c__________	
c build first model trace
c__________	
        iflag   = 0
        init    = 1
	igate2  = igate/2
        nlags1  = nlags + 1
        NG      = nlags + nlags1
        scl     = 1. / float(live)
	i1      =  icenter - igate2
        if (i1 .le. 0) i1 = 1
        i2      = i1 + igate - 1
        if (i2 .gt. nsamp) then
           im = i2 - nsamp
           igatei = igate - im
        else
           igatei = igate
        endif

        call vclr (stor , 1, ntrc)

c----------
c pack live traces within time
c window into holding array

	   do  jj = 1, ntrc
              IF (dedtrc(jj) .eq. 0) then

                 do  i = 1, igatei
                     work (i) = array1(i1+i-1,jj)
                 enddo
                  
                 do  ii = 1, igatei
                     array2(ii,jj) = work (ii)
                 enddo

	      ENDIF
	   enddo
c----------

           call vclr (X, 1, nsamp)
c____________
c compute phase
c rotation, apply rotation.
c____________
	   do jj = 1, ntrc 


              IF (dedtrc(jj) .eq. 0) THEN

                do  ii = 1, igatei
                    Y (ii) = array2 (ii,jj)
                enddo

                call phzrot (Y, Q, env, dt, NG, phz, loc)

                rotd = phz ( loc )

		stor (jj) = stor(jj) + rotd
                wts  (jj) = 1.0


                call rotate (Y, igatei, -rotd)
                do  ii = 1, igatei
                    array2 (ii,jj) = Y (ii)
                enddo

             ELSE

                stor  (jj) = 0.
                wts   (jj) = 0.

             ENDIF

100          continue

	   enddo

200	continue

        do  j = 1, ntrc
            if (dedtrc(j) .eq. 0) then
               ipk = ipk + 1
               do  ii = 1, nsamp
                   Y (ii) = array1 (ii,j)
               enddo
               call rotate (Y, nsamp, stor(j))
               do  ii = 1, nsamp
                   array1 (ii,j) = Y (ii)
               enddo
            endif
        enddo


c----
c  build final reference trace
c----
        do  i = 1, nsamp
            X (i) = 0.
        enddo
        do  j = 1, ntrc
            do  i = 1, igatei

                X (i) = X (i) + array2 (i,j)
            enddo
        enddo
        do  i = 1, igatei
            X (i) = X (i) * weight (i)
        enddo

        if (qlin .gt. 0) then
            call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  irec , 1)
            call vmov (work, 1, lhed(ITHWP1), 1, nsamp)
            call wrtape (qlin, lhed, qbytes)
        endif
		
 
      return
      end
