C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  iterative picking subroutine
 
c  users principle of program "pick"
 
      subroutine subs (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                 niter,omega,expphi,weight,array1,array2,
     2                 stor,fl,fc,fh,nsi,wts,nlags2,scor,thr,sgn,
     3                 dedtrc,irec,smooth,iord,env,datum,adatum,
     4                 qlin,lhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                 qbytes,live,ipk,freqs,norder,vverbos,verbos,
     6                 nstk)
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c  input:

c    ntrc  - # traces per gather
c   nsamp  - # samples per trace
c     nsi  - sample interval (ms)
c      dt  - sample interval in secs
c  icenter - window center time in samples
c   igate  - total window length in samples
c    nlags - # of x-corr lags (either neg or pos)
c   nlags2 - nlags / 2
c   niter  - # iterations
c     fl   - lowest bandpass frequency allowed (Hz)
c     fc   - starting high cut freq (Hz)
c     fh   - highest freq allowed
c   scor   - flags output as pick-type event tape (for input to scorusp)
c   pick   - flags total pick time is desired (guide function + residual)
c smooth   - flags residual picks are to be smoothed
c  iord    - smoothing window (samples)
c   env    - flags trace envelope is used rather then trace
c  irec    - current record number being processed
c  dedtrc  - vector of 0s & 1s signifying dead & live traces in rec
c  weight  - vector of window weights (i.e. tapering)
c  array1  - original input gather (ntrc x nsamp)
c  omega   - vector of circular frequencies (see main program picker or anmo)

c output:

c   stor   - vector of residual shifts (ms)
c    wts   - vector of correlation values (for last iteration)
c  array1  - shifted traces in record (i.e. applied residual shifts)
c  expphi  - work vector of phase rotations for time shifts


      integer   lhed (*)
      real      array1(nsamp, ntrc)
      real      array2(igate, ntrc)
      real      wts   (ntrc)
      real      freqs (100)
      real      weight(*), omega(*)
      real      stor(*)
      complex   expphi(*)
      integer   dedtrc(*)

      real      x(SZLNHD),y(SZLNHD),z(SZLNHD),g(SZLNHD),vp(SZLNHD)
      real      r(SZLNHD), t1(SZLNHD), t2(SZLNHD), work(SZLNHD)
      real      coefs(2,32), wrk1(3), wrk2(96)
      integer   ip(SZLNHD)
      integer   adatum, qlin, qbytes
      logical   scor, smooth, env, datum, sgn, vverbos, verbos

      if (nstk .eq. 0) nstk = ntrc

      if (live .le. 1) then
         do  j = 1, ntrc
             stor (j) = 0.
             wts  (j) = 0.
             if (dedtrc(j) .eq. 0) dedtrc(j) = 1
         enddo
         return
      endif
c__________	
c build first model trace
c compute start and end window times
c__________	
        iflag   = 0
        init    = 1
	igate2  = igate/2
        nlags1  = nlags + 1
        scl     = 1. / float(live)
	i1      =  icenter - igate2
        if (i1 .le. 0) i1 = 1
        i2      = i1 + igate - 1
        if (i2 .gt. nsamp) then
           im = i2 - nsamp
           igatei = igate - im
        else
           igatei = igate
        endif


        lop = 21
        db  = 40

        call vclr (stor , 1, ntrc)


	DO kk = 1, niter

           fhk = freqs (kk)
           call bwcoef (fl, fhk, dt, coefs, xnorm, norder, ift)
           call vclr(X, 1, nsamp)

           ltrc = 0
	   do jj = 1, ntrc

c----------
c live traces
              IF (dedtrc(jj) .eq. 0) then

                    if (sgn) then
                     do  i = 1, igatei
                         worki = array1(i1+i-1,jj)
                         if (worki .gt. 0.) work (i) = +1.0
                         if (worki .le. 0.) work (i) = -1.0
                     enddo
                 else
                     do  i = 1, igatei
                         work (i) = array1(i1+i-1,jj)
                     enddo
                 endif
                  
                 call vclr (wrk1, 1, 3)
                 call vclr (wrk2, 1, 96)
                 call bwfilt ( work, array2(1,jj), wrk1, wrk2,
     1                         coefs, xnorm, norder, igatei, init, 0)

                 if (env) then
                    call envlop (array2(1,jj), igatei, lop, db, dt, fl)
                 endif


                   if (ltrc .lt. nstk) then
                      ltrc = ltrc + 1
                      do  ii = 1, igatei
                          X (ii) = X (ii) + array2(ii,jj)
                      enddo
                   endif

	      ENDIF
c----------
	   enddo

           xx0 = 0.
           if (ltrc .gt. 0) then
              scl = 1. / float(ltrc)
           else
              scl = 0.
           endif

           do  ii = 1, igatei
               wt = weight (ii)
               X (ii) = scl * wt * X (ii)
               xx0 = xx0 + X (ii) * X (ii)
           enddo


c x-correlate model with individual traces, pick max, store & apply shift
c____________
	   do jj = 1, ntrc 


              IF (dedtrc(jj) .eq. 0) THEN

                yy0 = 0.
                do  ii = 1, igatei
                    wt = weight (ii)
                    Y (ii) = wt * array2 (ii,jj)
                    R (ii) = X (ii)
                    yy0 = yy0 + Y (ii) * Y (ii)
                enddo
                xx0yy0 = sqrt (xx0 * yy0)

                if (xx0yy0 .lt. 1.e-30) then
                   dedtrc (jj) = 1
                   wts   (jj) = 0.0
                   stor  (jj) = 0.0
                   go to 100
                endif

                do  ii = 1, nsamp
                    Z (ii) = array1 (ii,jj)
                enddo

                call ccort  (Y, R, T1, nlags1, igatei)
                call ccort  (R, Y, T2, nlags1, igatei)
                do  i = 1, nlags1
                    ii = nlags1 - i + 1
                    G (ii) = T1 (i) / xx0yy0
                enddo
                do  i = 1, nlags
                    ii = nlags1 + i
                    G (ii) = T2 (i+1) / xx0yy0
                enddo


c----
c   find all peaks,
c   then find maximum peak
c----
        	call pkval (G, nlags2, iflag, vp, ip, np) 
        	call maxv  (vp , 1, amaxpk , lc, np)

                if (np .eq. 0 .OR. amaxpk .lt. thr) then
                   if (verbos) then
                   write(LERR,*)'Bad correlation at rec ',irec,
     1             '   trc ',jj,'   iter ',kk,'   Xcorr= ',amaxpk,np
                   endif
                   if (vverbos) then
                      write(LERR,*)'G:'
                      write(LERR,*)(g(ii),ii=1,nlags2)
                   endif
                   dedtrc (jj) = 1
                   go to 100
                endif

                c1 = G (ip(lc)-1)
                c2 = G (ip(lc)  )
                c3 = G (ip(lc)+1)
                call parab (c1, c2, c3, fs, gmax)
                istat = ip(lc) - nlags - 1
                stat      = float(istat) + fs
		stor (jj) = stor(jj) + nsi * stat
                wts  (jj) = amaxpk


                if (stat .ne. 0.0) then
                   call vclr   (expphi, 1, SZLNHD)
                   call rshift (Z(1),nsamp,nsamp2,stat,omega(1),expphi)
                endif

                do  ii = 1, nsamp
                    array1 (ii,jj) = Z (ii)
                enddo
                call vclr (Z, 1, nsamp2)

             ELSE

                stor  (jj) = 0.
                wts   (jj) = 0.

             ENDIF

100          continue

	   enddo


	ENDDO


200	continue

        do  j = 1, ntrc
            if (dedtrc(j) .eq. 0) then
               ipk = ipk + 1
            endif
        enddo

c----
c   do smoothing (if required)
c----
        IF (smooth) THEN

           call SmoothFit ( stor, ntrc, iord)
c          call medsm ( stor, ntrc, iord)
        ENDIF

c----
c  build final reference trace
c----
        do  i = 1, igatei
            X (i) = 0.
        enddo
        do  j = 1, ntrc
            do  i = 1, igatei

                X (i) = X (i) + array1 (i,j)
            enddo
        enddo
        do  i = 1, igatei
            X (i) = X (i) * weight (i)
        enddo

c----
c   compute auto-datum, i.e. for vred input the main lobe
c   will be not be at time zero but a few 10s of ms into
c   the trace.  if we dont know what that is (we cant
c   come up with a -d{tdatum} ) then we can compute it.
c   we compute the final reference trace & then its envelope
c----
        IF (datum) THEN

           call vmov   (X, 1, work, 1, igatei)
           call envlop (X, igatei, lop, db, dt, fl)
           call pkval  (X, igatei, iflag, vp, ip, np) 
           call maxmgv (vp , 1, amaxpk , lc, np)
           call minmgv (vp , 1, aminpk , ld, np)
           adatum =  - nsi * (ip(ld) - igate2)
           X (ip(ld)) = 0.
        ELSE

           adatum = 0

        ENDIF

      if (qlin .gt. 0) then
          call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec , 1)
          call vmov (work, 1, lhed(ITHWP1), 1, nsamp)
          call wrtape (qlin, lhed, qbytes)
      endif
		
 
      return
      end

c----
c  pick peaks (or troughs)
c----

	subroutine pkval(rdata,nsamp,iflag,vp,ip,np)

#include <f77/lhdrsz.h>

	real      vp(SZLNHD), rdata(SZLNHD)
	integer   ip(SZLNHD)

	j = 0
        do  i = 1, nsamp
            vp (i) = 0.
        enddo

	do 100 i = 2,nsamp-1

c----
c   search for all peaks
c   vp = vector of peak values
c   ip = vector of peak positions (in original data)
c----
	if (iflag .eq. 0 ) then
		if (rdata  (i-1) .lt. rdata  (i)
     :		.and. rdata  (i) .gt. rdata  (i+1)) then
			j = j + 1
			vp(j) = rdata(i)
			ip(j) = i
		endif
c----
c   search for all troughs
c----
	else
		if (rdata  (i-1) .gt. rdata  (i)
     :			.and. rdata  (i) .lt. rdata  (i+1)) then
			j = j + 1
			vp(j) = rdata(i)
			ip(j) = i
		elseif (rdata  (i-1) .ge. rdata  (i)
     :                  .and. rdata  (i) .lt. rdata  (i+1)) then
                         j = j + 1
                         vp(j) = rdata(i)
                         ip(j) = i
	        elseif (rdata  (i-1) .gt. rdata  (i)
     :                  .and. rdata  (i) .le. rdata  (i+1)) then
                        j = j + 1
                        vp(j) = rdata(i)
                        ip(j) = i
		endif
	endif
100	continue
	np = j
	return
	end

c----
c   fit parabola to 3 points
c----
      SUBROUTINE PARAB(C1,C2,C3,X,Y)

	x = 0.0
	y = c2
        A  =0.5*(C1+C3-2.*C2)
        B = 0.5*(C3-C1)
        C = C2
        IF(A .EQ. 0.0 ) return
	  X = -B/(2.*A)
          Y = A * X**2 + B * X + C
	if ( abs(x) .gt. 1 ) then
		x = 0.0
		y = c2
	endif
      RETURN
      END
