C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  iterative picking subroutine
 
c  users principle of program "pick"
 
      subroutine subs2 (ntrc,nsamp,nsamp2,dt,icenter,igate,nlags,
     1                 niter,omega,expphi,weight,array1,array2,
     2                 stor,fl,fc,fh,nsi,wts,nlags2,scor,thr,sgn,
     3                 dedtrc,irec,smooth,iord,env,datum,adatum,
     4                 qlin,lhed,ifmt_RecNum,l_RecNum,ln_RecNum,
     5                 qbytes,live,ipk,freqs,norder,corr,acor,
     6                 verbos,vverbos)
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c  input:

c    ntrc  - # traces per gather
c   nsamp  - # samples per trace
c     nsi  - sample interval (ms)
c      dt  - sample interval in secs
c  icenter - window center time in samples
c   igate  - total window length in samples
c    nlags - # of x-corr lags (either neg or pos)
c   nlags2 - nlags / 2
c   niter  - # iterations
c     fl   - lowest bandpass frequency allowed (Hz)
c     fc   - starting high cut freq (Hz)
c     fh   - highest freq allowed
c   scor   - flags output as pick-type event tape (for input to scorusp)
c   pick   - flags total pick time is desired (guide function + residual)
c smooth   - flags residual picks are to be smoothed
c  iord    - smoothing window (samples)
c   env    - flags trace envelope is used rather then trace
c  irec    - current record number being processed
c  dedtrc  - vector of 0s & 1s signifying dead & live traces in rec
c  weight  - vector of window weights (i.e. tapering)
c  array1  - original input gather (ntrc x nsamp)
c  omega   - vector of circular frequencies (see main program picker or anmo)

c output:

c   stor   - vector of residual shifts (ms)
c    wts   - vector of correlation values (for last iteration)
c  array1  - shifted traces in record (i.e. applied residual shifts)
c  expphi  - work vector of phase rotations for time shifts


      integer   lhed (*)
      real      array1(nsamp, ntrc)
      real      array2(igate, ntrc)
      real      corr  (ntrc,  ntrc)
      real      acor  (ntrc,  ntrc)
      real      wts   (ntrc)
      real      freqs (100)
      real      weight(*), omega(*)
      real      stor(*)
      complex   expphi(*)
      integer   dedtrc(*)

      real      x(SZLNHD),y(SZLNHD),z(SZLNHD),g(SZLNHD),vp(SZLNHD)
      real      r(SZLNHD), t1(SZLNHD), t2(SZLNHD), work(SZLNHD)
      real      coefs(2,32), wrk1(3), wrk2(96)
      integer   ip(SZLNHD)
      integer   adatum, qlin, qbytes
      logical   scor, smooth, env, datum, sgn, vverbos, verbos

      if (live .le. 1) then
         do  j = 1, ntrc
             stor (j) = 0.
             wts  (j) = 0.
             if (dedtrc(j) .eq. 0) dedtrc(j) = 1
         enddo
         return
      endif
c__________	
c build first model trace
c__________	
        iflag   = 0
        init    = 1
	igate2  = igate/2
        nlags1  = nlags + 1
        scl     = 1. / float(live)
	i1      =  icenter - igate2
        if (i1 .le. 0) i1 = 1
        i2      = i1 + igate - 1
        if (i2 .gt. nsamp) then
           im = i2 - nsamp
           igatei = igate - im
        else
           igatei = igate
        endif

        lop = 21
        db  = 40

        call vclr (stor , 1, ntrc )
        call vclr (wts  , 1, ntrc )


	DO nn = 1, niter

           fhk = freqs (nn)
           call bwcoef (fl, fhk, dt, coefs, xnorm, norder, ift)
           call vclr(X, 1, nsamp)


           do  jj = 1, ntrc
           do  kk = 1, ntrc
               corr (jj,kk) = 0.0
               acor (jj,kk) = 0.0
           enddo
           enddo

           j = 0
	   do jj = 1, ntrc

c----------
c for each interation:
c filter current static corrected full gather and put live
c traces only into gate array
c----------
              IF (dedtrc(jj) .eq. 0) then

                 j = j + 1
                 if (sgn) then
                     do  i = 1, igatei
                         worki = array1(i1+i-1,jj)
                         if (worki .gt. 0.) work (i) = +1.0
                         if (worki .le. 0.) work (i) = -1.0
                     enddo
                 else
                     do  i = 1, igatei
                         work (i) = array1(i1+i-1,jj)
                     enddo
                 endif

c     write(0,*)(work(ii),ii=1,igatei)
                  
                 call vclr (wrk1, 1, 3)
                 call vclr (wrk2, 1, 96)
                 call bwfilt ( work, array2(1,j), wrk1, wrk2,
     1                         coefs, xnorm, norder, igatei, init, 0)

c---------
c option to compute
c correlations on 
c envelope
c---------
                 if (env) then
                    call envlop (array2(1,j), igatei, lop, db, dt, fl)
                 endif

	      ENDIF
c----------
	   enddo
c-------
c jtrc = # live traces in gather
c-------
           jtrc = j

c     do j = 1, jtrc
c     write(0,*)(array2(ii,j),ii=1,igatei)
c     enddo

c***************************************************
c x-correlate every trace in gather with every other trace. this results
c in a symmetric correlation matrix. we also compute the correlation
c normalization factor xx0yy0
c____________
	   DO jj = 1, jtrc 
           DO kk = 1, jtrc


              IF (dedtrc(jj) .eq. 0 .AND. dedtrc(kk) .eq. 0) THEN

                xx0 = 0.
                yy0 = 0.
                do  ii = 1, igatei
                    wt = weight (ii)
                    Y (ii) = wt * array2 (ii,jj)
                    R (ii) = wt * array2 (ii,kk)
                    xx0 = xx0 + Y (ii) * Y (ii)
                    yy0 = yy0 + R (ii) * R (ii)
                enddo
                xx0yy0 = sqrt (xx0 * yy0)


c----
c built 2-sided correlation for this pair
c----
                call ccort  (Y, R, T1, nlags1, igatei)
                call ccort  (R, Y, T2, nlags1, igatei)
                do  i = 1, nlags1
                    ii = nlags1 - i + 1
                    G (ii) = T1 (i) / xx0yy0
                enddo
                do  i = 1, nlags
                    ii = nlags1 + i
                    G (ii) = T2 (i+1) / xx0yy0
                enddo


c----
c   find all peaks in correlation,
c   then find maximum peak
c----
        	call pkval (G, nlags2, iflag, vp, ip, np) 
        	call maxv  (vp , 1, amaxpk , lc, np)

                if (np .eq. 0 .OR. amaxpk .lt. thr) then
                   if(verbos) then
                   write(LERR,*)'Bad correlation at rec ',irec,
     1             '   trc ',jj,kk,'   iter ',nn,'   Xcorr= ',amaxpk,np
                   endif
                   if (vverbos) then
                   write(LERR,*)'G:'
                   write(LERR,*)(g(ii),ii=1,nlags2)
                   endif
                   acor (jj,kk) = 0.
                   go to 100
                endif

c----
c use parabolic fit to get fractional sample of correlation peak
c----
                c1 = G (ip(lc)-1)
                c2 = G (ip(lc)  )
                c3 = G (ip(lc)+1)
                call parab (c1, c2, c3, fs, gmax)
                istat = ip(lc) - nlags - 1
                stat      = float(istat) + fs
                corr (jj,kk) = -stat
                acor (jj,kk) = amaxpk


             ENDIF

100          continue

	   enddo
	   enddo


c---------
c end jj/kk loop
c***************************************************

c----
c now look at each column of the correlation matrix and extract the
c median shift and its weight for the live traces in the gather
c----
           jj = 0
           do  j = 1, ntrc

               IF (dedtrc(j) .eq. 0) THEN

                  jj = jj + 1
                  do  i = 1, jtrc
                      X (i) = corr (i,jj)
                  enddo
c----
c grab corresponding trace from the full gather
c----
                  do  ii = 1, nsamp
                      Z (ii) = array1 (ii,j)
                  enddo

c----
c compute static shifts and store cummulative shifts
c----
                  jmed = jtrc / 2
                  stat = X (jmed)
                  stor (j) = stor (j) + nsi * stat
                  wts  (j) = acor (jmed,jj)
   
c----
c apply shifts to the gather
c----
                  if (stat .ne. 0.0) then
                     call vclr   (expphi, 1, SZLNHD)
                     call rshift (Z(1), nsamp, nsamp2, stat,
     1			omega(1), expphi)
                  endif

                  do  ii = 1, nsamp
                      array1 (ii,j) = Z (ii)
                  enddo
                  call vclr (Z, 1, nsamp2)

               ENDIF

           enddo



	ENDDO


200	continue

        do  j = 1, ntrc
            if (dedtrc(j) .eq. 0) then
               ipk = ipk + 1
            endif
        enddo

c----
c   do smoothing (if required)
c----
        IF (smooth) THEN

           call SmoothFit ( stor, ntrc, iord)
c          call medsm ( stor, ntrc, iord)
        ENDIF

c----
c   compute auto-datum, i.e. for vred input the main lobe
c   will be not be at time zero but a few 10s of ms into
c   the trace.  if we dont know what that is (we cant
c   come up with a -d{tdatum} ) then we can compute it.
c   we compute the final reference trace & then its envelope
c----
        IF (datum) THEN

           do  i = 1, igatei
               X (i) = 0.
           enddo

           do  j = 1, ntrc
               do  i = 1, igatei

                   X (i) = X (i) + array1 (i,j)
               enddo
           enddo
           do  i = 1, igatei
               X (i) = X (i) * weight (i)
           enddo

           call vmov   (X, 1, work, 1, igatei)
           call envlop (X, igatei, lop, db, dt, fl)
           call pkval  (X, igatei, iflag, vp, ip, np) 
           call maxmgv (vp , 1, amaxpk , lc, np)
           call minmgv (vp , 1, aminpk , ld, np)
           adatum =  - nsi * (ip(ld) - igate2)
           X (ip(ld)) = 0.
        ELSE

           adatum = 0

        ENDIF

      if (qlin .gt. 0) then
          call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec , 1)
          call vmov (work, 1, lhed(ITHWP1), 1, igatei)
          call wrtape (qlin, lhed, qbytes)
      endif
		
 
      return
      end

