C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetTickSample ( ThisTrace, trndx, trndx2, traces, 
     :     samples, TickSample )

      integer ThisTrace, trndx, trndx2, TickSample

c      real traces(*), samples(*)
      real traces(1000), samples(1000)

c initialize variables

      TickSample = 0

c bail if trace not in segment

      if (ThisTrace .lt. nint(traces(trndx+1)) .or. 
     :     ThisTrace .gt. nint(traces(trndx2)) ) return

c check if equal to first sample

      if ( ThisTrace .eq. nint(traces(trndx+1)) .and. 
     :     traces(trndx+1) .lt. 99999. ) then
         TickSample = nint(samples(trndx+1))
         return
      endif

c interpolate mute start time

      do j = trndx + 1, trndx2 

         if ( ThisTrace .le. traces(j) .and. traces(j) .lt. 999999. ) 
     :        then
            TickSample = 
     :           nint ( samples(j-1) + ( samples(j) - samples(j-1) ) / 
     :           abs( traces(j) - traces(j-1) ) 
     :           * abs( float(ThisTrace) - traces(j-1) ) )
            return
         endif

      enddo

      TickSample = 0
      return
      end
      

