C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Tick(RecNum, TrcNum, index, traces, samples, tri, 
     :           Amplitude, nsamp, nseg, nrec, ntrc, count )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from main
      
      integer RecNum, index(2*SZSMPM,2), nsamp, nseg, ntrc, count, nrec
      integer TrcNum

      real traces(*), samples(*), Amplitude, tri(*)

c declare local variables 

      integer TickSample, trndx, trndx2

      logical stack

      stack = .false.
      if ( ntrc .eq. 1 .or. nrec .eq. 1 ) stack = .true.
            
c put a tick at the appropriate sample for each segment

      trndx = 0
      trndx2 = trndx + index(1,1)

      DO i = 1, nseg

         TickSample = 0

         IF ( stack ) then

c interpolate TickSample location from segments covering whole line
c NO extrapolation

            if ( ntrc .eq. 1 ) then
               call GetTickSample ( RecNum, trndx, trndx2, traces,  
     :              samples, TickSample )
            else
               call GetTickSample ( TrcNum, trndx, trndx2, traces,  
     :              samples, TickSample )
            endif

            if ( TickSample .gt. 0 .and. TickSample .le. nsamp-1 ) then 
               tri(TickSample) = Amplitude
               tri(TickSample + 1) = Amplitude
            endif
            

c advance trace array index to next segment

            trndx = trndx2
            if ( i .lt. nseg ) trndx2 = trndx2 + index(i+1,1)

         ELSE

c interpolate TickSample location within this record if segment is 
c present.  Again, NO extrapolation
         
            if ( RecNum .eq. index(i,2) ) then
               call GetTickSample ( TrcNum, trndx, trndx2, traces,   
     :              samples, TickSample )
               if ( TickSample .gt. 0 .and. TickSample .le. nsamp-1 ) 
     :              then 
                  tri(TickSample) = Amplitude
                  tri(TickSample + 1) = Amplitude
               endif
            endif

c advance trace array index to next segment

            trndx = trndx2
            if ( i .lt. nseg ) trndx2 = trndx2 + index(i+1,1)

         ENDIF

       ENDDO

       return
       end
        
