C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE BUILD ( REBILD, REFTR, IBUF, NS, IWSMPL, FOLD, DEAD,
     *                   LWNDW, DATA, LENBYT , TRCARR, iarr ,
     *                   ITRWRD,SZSMPD,KENBYT)
C***********************************************************************
C
C     SUBROUTINE   - BUILD
C     LANGUAGE     - FORTRAN
C     AUTHOR       - ED ANDES
C     DATE WRITTEN - 10/??/85
C     REVISION     - OCTOBER, 1985  - ED ANDES
C                    INITIAL RELEASE.
C
C      AMOCO PRODUCTION CO. PROPRIETARY
C                   TO BE MAINTAINED IN CONFIDENCE.....
C
C     ABSTRACT -
C        THIS ROUTINE WILL BUILD A REFERENCE TRACE.
C
C     PARAMETERS PASSED -
C       REBILD  - L*1 - FLAG TO BUILD A NEW REFERENCE TRACE
C       REFTR   - R*4 - REFERENCE TRACE BUFFER
C       IBUF    - I*2 - TRACE BUFFER
C       NS      - I*4 - NUMBER OF SAMPLES FROM TRACE USABLE
C       IWSMPL  - I*4 - STARTING SAMPLE OF TRACE WINDOW
C       FOLD    - I*4 - PROCESSING FOLD
C       DEAD    - I*4 - CONTAINS DEAD TRACES LI AND DI NUMBER
C       LWNDW   - I*4 - LENGTH OF TRACE WINDOW IN SAMPLES
C       DATA    - R*4 - BUFFER CONTAINING INPUT TRACE DATA
C
C***********************************************************************
c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      REAL        REFTR(*), DATA(*)
C
      INTEGER     FOLD, DEAD(512,2), AMOUNT, ITRWRD,SZSMPD,KENBYT
C
      INTEGER     IBUF(*)
C
      LOGICAL     REBILD
C
      REAL        TRCARR(iarr,fold)
c
C
      CALL MOVE ( 0, REFTR, 0, 3000*SZSMPD )
C
C---- SET UP INDICES FOR GRABBING THE
C---- RIGHT START AND END OF THE TRACE
C---- ON DISK USING WINDOW LENGTH FROM 1PICK CARD...
      ISTART = IWSMPL
         IF ( ISTART .LT. 1 ) ISTART = 1
C
      IEND = ( ISTART + LWNDW ) - 1
         AMOUNT = LWNDW
         IF ( IEND .GT. NS ) AMOUNT = ( NS - ISTART ) + 1
C
C
      DO 100 I = 1, FOLD
C
C---- IS TRACE DEAD ???
         IF ( DEAD(I,2) .NE. 0 ) GO TO 100
Cray       MOVE TRACE FROM TRCARR TO IBUF
      CALL MOVE(1,IBUF,TRCARR(1,I),LENBYT)
      call move (1, DATA, IBUF(ITRWRD+1), KENBYT)
C
C---- SUM TRACE "N" INTO REFERENCE TRACE...
      JJ=ISTART
      DO 50 J=1,AMOUNT
         REFTR(J)=REFTR(J)+DATA(JJ)
   50 JJ=JJ+1
C
C
  100 CONTINUE
C
      REBILD = .FALSE.
      RETURN
      END
C
