C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE PADTR ( LI, DI, RI, TR, OLDLI, OLDDI, OLDRI, OLDTR,
     *                   JFOLD, NTR, LASTRI, MINDI, MAXDI, MINLI,
     *                   REFIN, OTAP, IREC, IPRNTR, obytes,ITRWRD,
     *                   SZSMPD, nwds,
     *ifmt_TrcNum,l_TrcNum,ln_TrcNum,ifmt_RecNum,l_RecNum,ln_RecNum,
     *ifmt_LinInd,l_LinInd,ln_LinInd,ifmt_DphInd,l_DphInd,ln_DphInd,
     *ifmt_RecInd,l_RecInd,ln_RecInd,ifmt_StaCor,l_StaCor,ln_StaCor)
C***********************************************************************
C
C     SUBROUTINE   - PADTR
C     LANGUAGE     - FORTRAN
C     AUTHOR       - JACQUIE VINSON
C     DATE WRITTEN - 04/10/85
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                  TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: CREATES DEAD EVENT RECORDS FOR ANY TRACES THAT
C               ARE MISSING OR SKIPPED AND WRITES THEM OUT.
C
C     PARAMETERS PASSED:
C       LI     - I*4 - CURRENT LINE INDEX
C       DI     - I*4 - CURRENT DEPTH INDEX
C       RI     - I*4 - CURRENT RECORD NUMBER
C       TR     - I*4 - CURRENT TRACE NUMBER
C       OLDLI  - I*4 - LAST LI WRITTEN
C       OLDDI  - I*4 - LAST DI WRITTEN
C       OLDRI  - I*4 - LAST RECORD WRITTEN
C       OLDTR  - I*4 - LAST TRACE WRITTEN
C       JFOLD  - I*4 - FOLD
C       NTR    - I*4 - NUMBER OF TRACES PER RECORD
C       LASTRI - I*4 - LAST RECORD TO PROCESS
C       MINDI  - I*4 - MINIMUM DEPTH INDEX
C       MAXDI  - I*4 - MAXIMUM DEPTH INDEX
C       MINLI  - I*4 - MINIMUM LINE INDEX
C       REFIN  - L*1 - FLAG INDICATING REFERENCE
C                      TRACES WERE INPUT
C       IOTAP  - I*4 - LOGICAL UNIT OF OUTPUT DEVICE
C       IREC   - I*4 - COUNT OF TRACES WRITTEN TO
C                      OUTPUT TAPE
C
C***********************************************************************
#include <save_defs.h>
c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      INTEGER     LI, DI, RI, TR, OLDLI, OLDDI, OLDRI, OLDTR,
     *            JFOLD, NTR, LASTRI, MINDI, MAXDI, MINLI,
     *            OTAP, IREC, DIINCR, obytes, SZSMPD, ITRWRD

      REAL        DATA (1000)
C
      INTEGER     IBUF(1000)
c     INTEGER     IBUF(178)
C
      LOGICAL     REFIN
C
      DATA IDEAD/-10000/

      SAVE

      call move (0, DATA, 0.0, nwds*SZSMPD)
C
      IF ( IREC .NE. 0 ) GO TO 100
           CALL MOVE (0, IBUF, 0, obytes)
c          IBUF(125) = 30000
           call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 30000, 1)

           DATA(1)  = IDEAD
           DATA(2)  =     0
           DATA(3)  = IDEAD
           DATA(4)  =     0
           DATA(5)  = IDEAD
           DATA(6)  =     0
           DATA(21) =     0

           call move (1, IBUF(ITRWRD+1), DATA, nwds*SZSMPD)
C
  100 IF (LASTRI .EQ. OLDRI .AND. OLDTR .EQ. NTR) GO TO 900
      IF (MINLI .EQ. 0)                           GO TO 500
      IF (OLDLI .EQ. LI .AND. OLDDI .EQ. DI)      GO TO 900
      IF (IREC .EQ. 0)                            GO TO 600
C
      MODFNC = MOD((OLDLI - (MINLI - 1)),2)
C
      IF ((.NOT. REFIN) .AND. OLDLI .EQ. LI .AND.
     *    ((MODFNC .EQ. 0 .AND. OLDDI .LT. DI) .OR.
     *     (MODFNC .NE. 0 .AND. OLDDI .GT. DI)))
     *    WRITE (6,200)
  200     FORMAT(/13X,'** M5000 ** ERROR DETECTED BY SUBROUTINE PADTR:',
     *           /25X,'WHEN OPTIONAL REFERENCE TRACE IS NOT INPUT, ',
     *           /25X,'THE INPUT DATA TAPE IS ASSUMED TO BE IN ',
     *           /25X,'SERPENTINE (RT3D-TYPE) FORMAT.  INPUT DATA',
     *           /25X,'DOES NOT REFLECT THIS.',/)
      IF ((.NOT. REFIN) .AND. OLDLI .EQ. LI .AND.
     *    ((MODFNC .EQ. 0 .AND. OLDDI .LT. DI) .OR.
     *     (MODFNC .NE. 0 .AND. OLDDI .GT. DI)))
     *    ICCODE = 100
      IF (ICCODE .EQ. 100) GO TO 900
C
      IF ((.NOT. REFIN) .AND. MODFNC .EQ. 0)
     *  OLDDI = OLDDI - 1
      IF ((REFIN) .OR. MODFNC .NE. 0)
     *  OLDDI = OLDDI + 1
C
      IF (OLDDI .LE. MAXDI .AND. OLDDI .GE. MINDI) GO TO 300
        OLDLI = OLDLI + 1
        MODFNC = MOD((OLDLI - (MINLI - 1)),2)
        IF ((.NOT. REFIN) .AND. MODFNC .EQ. 0)
     *    OLDDI = MAXDI
        IF ((REFIN) .OR. MODFNC .NE. 0)
     *    OLDDI = MINDI
C
  300 IF (OLDLI .EQ. LI .AND. OLDDI .EQ. DI .AND.
     *    LASTRI .EQ. 0)                          GO TO 900
C
c     IBUF(121) = OLDLI
c     IBUF(122) = OLDDI
         call savew2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               OLDDI , 1)
         call savew2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               OLDLI , 1)

      DO 400 I = 1, JFOLD
         IF (LASTRI .EQ. OLDRI .AND. OLDTR .EQ. NTR) GO TO 900
         IF (OLDTR .EQ. NTR) OLDTR = 0
         IF (OLDTR .EQ. 0)   OLDRI = OLDRI + 1
         OLDTR = OLDTR + 1
c        IBUF(106) = OLDRI
c        IBUF(107) = OLDTR
         call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               OLDRI , 1)
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               OLDTR , 1)

         CALL WRTAPE (OTAP, IBUF, obytes) ! Cray

         IREC = IREC + 1
  400 CONTINUE
      GO TO 100
C
  500 DIINCR = 0
      IF (OLDRI .NE. RI) DIINCR = (DI - OLDDI) / (RI - OLDRI)
      IF (RI .EQ. OLDRI .AND. TR .EQ. OLDTR) GO TO 900
      IF (IREC .EQ. 0)                       GO TO 800
      IF (OLDTR .EQ. NTR) OLDTR = 0
      IF (OLDTR .EQ. 0)   OLDRI = OLDRI + 1
      IF (OLDTR .EQ. 0)   OLDDI = OLDDI + DIINCR
      OLDTR = OLDTR + 1
c     IBUF(106) = OLDRI
c     IBUF(107) = OLDTR
c     IBUF(122) = OLDDI
c     IBUF(118) = 0
         call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               OLDRI , 1)
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               OLDTR , 1)
         call savew2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               OLDDI , 1)
         call savew2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1               0      , 1)

C
      IF (RI .EQ. OLDRI .AND. TR .EQ. OLDTR .AND.
     *    LASTRI .EQ. 0)                         GO TO 900
C
      CALL WRTAPE (OTAP, IBUF, obytes) ! Cray

      IREC = IREC + 1
      GO TO 100
C
  600 continue
c     IBUF(121) = OLDLI
c     IBUF(122) = OLDDI
c     IBUF(106) = OLDRI
c     IBUF(107) = OLDTR
         call savew2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               OLDDI , 1)
         call savew2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               OLDLI , 1)
         call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               OLDRI , 1)
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               OLDTR , 1)

      CALL WRTAPE ( OTAP, IBUF, obytes) ! Cray

      IREC = IREC + 1
      DO 700 I = 2, JFOLD
         IF (LASTRI .EQ. OLDRI .AND. OLDTR .EQ. NTR) GO TO 900
         IF (OLDTR .EQ. NTR) OLDTR = 0
         IF (OLDTR .EQ. 0)   OLDRI = OLDRI + 1
         OLDTR = OLDTR + 1
c        IBUF(106) = OLDRI
c        IBUF(107) = OLDTR
         call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               OLDRI , 1)
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               OLDTR , 1)

         CALL WRTAPE ( OTAP, IBUF, obytes) ! Cray

         IREC = IREC + 1
  700 CONTINUE
      GO TO 100
C
  800 continue
c     IBUF(106) = OLDRI
c     IBUF(107) = OLDTR
c     IBUF(121) = OLDLI
c     IBUF(122) = OLDDI
         call savew2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               OLDDI , 1)
         call savew2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               OLDLI , 1)
         call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               OLDRI , 1)
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               OLDTR , 1)

      CALL WRTAPE ( OTAP, IBUF, obytes) ! Cray

      IREC = IREC + 1
      GO TO 100
C
900   continue
      RETURN
      END
C
