C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C
C     PROGRAM      - PICK
C     LANGUAGE     - FORTRAN
C     AUTHOR       - PHIL JOHNSON
C     DATE WRITTEN - NOVEMBER 1976
CCCCC MODIFIED BY A. DOWDY TO RUN ON Cray-2   2-24-88
C     MODIFICATION HISTORY -11/??/76  -  P.J.
C                           INITIAL RELEASE
C                           03/??/78  -  CECIL JONES
C                           SIS DESIGN, CODING, STANDARDIZATION
C                           04/??/78  -  CECIL JONES
C                           DEBUG
C                           05/??/78  -  CECIL JONES
C                           CONVERSION FOR 3838 ARRAY PROCESSOR
C                           09/??/78  -  CECIL JONES
C                           DISK I/O OPTIMIZATION
C                           01/??/79  -  CECIL JONES
C                           CPU OPTIMIZATION
C                           10/07/82  -  JACQUIE VINSON
C                           INCREASE RANGE LIMIT FIELDS FROM 4 TO 5
C                           DIGITS (MINRNG,MAXRNG)
C                           UPDATE ERROR MESSAGES
C                           ADD CALLS TO WRCARD, APOPEN, & CCEXIT
C                           12/03/82  -  JACQUIE VINSON
C                           DAOPEN LOGIC REMOVED UNTIL BLOCKED DISK I/O
C                           AVAILABLE
C                           01/13/83  -  GARY SHIBA
C                          -IMPLEMENT 2-D CDP NUMBERING SCHEME.
C                          -BRIEF WARNING MESSAGES DURING EXECUTION
C                           AND FULL MESSAGE UPON PROGRAM TERMINATION.
C                          -PAD OUTPUT RECORDS TO "TRACES/RECORD" IF
C                           RECORDS ARE SHORT -- START & END OF LINE.
C                          -CORRECT INPUT WINDOWS FOR TIME OF FIRST
C                           SAMPLE CONSIDERATIONS.
C                          -FIX CALCULATION FOR VARIABLE "IDIFF".
C                           08/29/83  -  JACQUIE VINSON
C                          -SPACE VARIANT WINDOW CAPABILITY, I.E.,
C                           MULTIPLE '1PICK' CARDS.
C                          -ALLOW FOR 1NTERPOLATION OF WINDOW START
C                           TIME.
C                          -REMOVE 3000 SAMPLE RESTRICTION ON INPUT
C                           DATA SET.  INCREASE NUMBER OF SAMPLES TO
C                           12000 FORMAT 1 AND 6000 FORMAT 3.
C                          -WRITE ONLY WINDOW OF TRACE DATA TO DISK.
C                           WILL WRITE OUT WINDOW LENGTH PLUS 2*MAXLAG
C                           ON EITHER SIDE.
C                          -RECODE 'FIRST USABLE CDP' LOGIC TO
C                           SEARCH FOR FIRST RECORD TO PROCESS BEFORE
C                           SEARCHING FOR USABLE TRACES.
C                          -GENERATE A 256-BYTE TRACE HEADER EVENT TAPE.
C                           04/10/85  -  JACQUIE VINSON  (PICKKA)
C                          -ALLOW INITIAL REFERENCE TRACES TO BE INPUT
C                           RATHER THAN CALCULATED
C                          -PAD MISSING CELLS FOR 3-D LINES
C                           10/??/85  -  ED ANDES (PICKLA)
C                          -RESTRUCTURE OF PICKKA.
C
C      AMOCO PRODUCTION CO. PROPRIETARY
C                   TO BE MAINTAINED IN CONFIDENCE.....
C
C     ABSTRACT -
C        CALCULATES THE REFLECTION TIME DIFFERENCES OF SEISMIC
C        EVENTS WITHIN A COMMON-DEPTH-POINT.
C
C     INTERNAL SUBROUTINES -
C       NONCON    FRSTIT   OUTREF    SCAWT     FNDREC   INTERP
C       RTAPHD    WRDSK    RDPICK    PADTR     APBLD    CHECK
C       BUILD
C
C     UTILITY SUBROUTINES -
C       GAMOCO    LBOPEN   NACCT     LUCHEK    OPEN     RTAPE
C       ITOFP     MOVE     CRDDSK    APOPEN    WRCARD   ARITFP
C       LBCLOS    NACCT2   CCEXIT    FPTOI     WRTAPE   HLH
C       STRING
C
C***********************************************************************

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      REAL TRCARR
      POINTER (wkaddr, TRCARR(1))
      REAL        REFTR(3000), DATA(12000), XCORR(3000), TRACE(12000),
     *            WEIGHT(512,3),
     *            xtr(12000)
C
      INTEGER     ALIGN, WNDLAG, XLNGTH, FORMAT, OREF, OTAP,
     *            FREC, OLDRI, OLDLI, OLDDI, OLDTR, WSTART,
     *            WEND, ALTRNT(512,2), IRITAB(512),
     *            IHEAD(1500), DEAD(512,2), LHEAD(1500),
     *            ILINE(11), IPICK(25), NDICES(2), PRIMRY, FOLD,
     *            AMOUNT, EXPAND, PRCNT, SHIFT(512,2),
     *            JHEAD(1500), ITRNO
      CHARACTER*4 PICK
C
      INTEGER     IBUF(12128), JBUF(12128), ISTATIC, obytes
C
      INTEGER ARGIS, pipe
      CHARACTER name*4
#include <f77/pid.h>
C
      LOGICAL     LAGZRO, FIRST, REFIN,  M0300,
     *            M0500, M0600, REFOUT, ONCE, REBILD, NOSCAL,
     *            SKIP, FCARD, heap, onepass, cmdln,  EOF_error
C
C ADDED FOR Cray 2-24-88
      CHARACTER NTAPE*120,OTAPE*120,PFILE*120
      CHARACTER*24 WRNING
      CHARACTER*33 TITLE(2)
      DATA ITRNO/0/
      DATA WRNING/'PROGRAM WARNING MESSAGES'/
      DATA TITLE(1)/'                         PICK REF'/,
     1     TITLE(2)/'LECTIONS                         '/
C
      DATA LUERR/0/, LUTMP /99/
      DATA IREADR/25/, IPRNTR/26/, NTAP/7/, OTAP/8/, NREF/9/,
     *     NOREAD/0/, PICK/'PICK'/, OREF/10/, ONCE/.TRUE./,
     *     IEOF/0/, IRISAV/0/, IDEAD/-10000/,
     *     CHARGE/5.5/, REFOUT/.FALSE./, REBILD/.TRUE./, REFIN/.FALSE./,
     *     IPRCNT/999/, LWNDW/0/, M0300/.FALSE./, OLDRI/0/, IREC/0/,
     *     M0500/.FALSE./, M0600/.FALSE./, IDSK/12/, SQW/3.E+30/,
     *     TNTHOW/1.E+31/, SMALL/.1E-30/, NGOOD/0/, ICCODE/0/,
     *     LASTRI/0/, IBAD/-10000/,
     *     NTOTAL/0/

      data kurcdp /0/, pipe/3/
      data name/'PICK'/
      data onepass/.true./, cmdln/.false./
      data EOF_error/.false./
C
c     EQUIVALENCE ( DATA(1),   IBUF(129) ),
      EQUIVALENCE ( JBUF(1),   JHEAD(1)  ),
c    *            ( JBUF(129), ITRACE(1) ),
c    *            ( IBUF(129), OTRACE(1) ),
     *            ( IBUF(1),   IHEAD(1)   , LHEAD(1) )
C

      IPRNTR = LERR
      nwds   = 25

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('ShtDep',ifmt_ShtDep,l_ShtDep,ln_ShtDep,TRACEHEADER)
      call savelu('UphlTm',ifmt_UphlTm,l_UphlTm,ln_UphlTm,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)
      call savelu('DatShf',ifmt_DatShf,l_DatShf,ln_DatShf,TRACEHEADER)
      call savelu('ToTmAU',ifmt_ToTmAU,l_ToTmAU,ln_ToTmAU,TRACEHEADER)
      call savelu('InStUn',ifmt_InStUn,l_InStUn,ln_InStUn,TRACEHEADER)
      call savelu('InStAp',ifmt_InStAp,l_InStAp,ln_InStAp,TRACEHEADER)
      call savelu('ToStAp',ifmt_ToStAp,l_ToStAp,ln_ToStAp,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('RcStUn',ifmt_RcStUn,l_RcStUn,ln_RcStUn,TRACEHEADER)
      call savelu('RcStAp',ifmt_RcStAp,l_RcStAp,ln_RcStAp,TRACEHEADER)
      call savelu('ToTmAA',ifmt_ToTmAA,l_ToTmAA,ln_ToTmAA,TRACEHEADER)

C
      IF (ARGIS('-H') .GT. 0 .OR. ARGIS('-?') .GT. 0) CALL HELP()
C
C             OPEN FILE TO CONTAIN SYSOUT
#include <f77/open.h>

      CALL GAMOCO ( TITLE, 1, IPRNTR )
C
Cray          OPEN INPUT DATA FILE
C
      CALL OPNIN(0,'-N',NTAPE,NTAP,IPRNTR,IRETCD)
C
      IF (IRETCD .NE. 0) THEN
          WRITE (LER,'(A)') 'PICK ERROR: CAN''T OPEN SEISMIC INPUT FILE'
          CALL CCEXIT(1)
      ENDIF 
C
Cray          OPEN OUTPUT EVENT FILE
C
c     CALL OPNOUT(0,'-E',OTAPE,OTAP,IPRNTR,IRETCD)
      IRETCD = 0
      ikp = in_ikp()
      write(LER,*)'pickusp: ikp= ',ikp
 
      if (ikp .eq. 0) then
          call argstr ( '-E', OTAPE, ' ', ' ')
          if (OTAPE(1:1) .ne. ' ') then
              call getln (OTAP, OTAPE, 'w', -1)
          else
              OTAP = 1
          endif
      elseif (ikp .eq. 1) then
          call sisfdfit (OTAP, pipe)
      endif
      if (OTAP .lt. 0) IRETCD = 1

C
      IF (IRETCD .NE. 0) THEN         
          WRITE (LER,'(A)') 'PICK ERROR: CAN''T OPEN OUTPUT EVENT FILE'
          CALL CCEXIT(2)
      ENDIF
 
C
Cray          OPEN PARAMETER CARD FILE
C
      CALL OPNPRM('-C',PFILE,IDSK,IPRNTR,IRETCD,cmdln)
C
      IF (IRETCD .NE. 0) THEN           
          WRITE (LER,'(A)') 'PICK ERROR: A 1PICK CARD FILE IS REQUIRED'
          CALL CCEXIT(3)
      ENDIF
C

C
C---- READ DATA TAPE LINE HEADER...
      CALL RTAPHD ( IHEAD, IBUF, NSAMPS, MSI, FORMAT, NTR, NRPJOB,
     *              JFOLD, MINLI, MAXLI, MINDI, MAXDI, LENGTH, NTAP,
     *              IPRNTR )
C
Cray          LENBYT IS LENGTH OF TRACE IN Cray FORMAT
C

      LENBYT =  (nsamps + ITRWRD) * SZSMPD
      KENBYT = nsamps * SZSMPD
      MENBYT = nwds * SZSMPD
      obytes = (nwds + ITRWRD) * SZSMPD
      write(IPRNTR,*)'LENBYT= ',lenbyt
C
      TFSMPL=0.0
      ITFS = TFSMPL
C
C---- DO WE NEED TO WRITE OUT REFERENCE TRACES ???
Cray   THIS OPTION REMOVED BY A. DOWDY   2-24-88
C
C---- ARE REFERENCE TRACES GOING TO BE INPUT ???
C
C---- WRITE ALL PICK CARDS TO DISK...
Cray    CARD IMAGES ALREADY ARE ON DISK
C
C---- WRITE LINE HEADER...
C     WRITE(IPRNTR,6966)
C6966 FORMAT(//,1X,'ENTERING WTAPHD FROM MAIN')
      CALL WTAPHD ( IHEAD, IBUF, NRPJOB, NSAMPS, OTAP, LENGTH,IPRNTR)
C---- READ 1PICK CARD...
100   continue

      if (cmdln .and. IEOF .eq. 1) go to 5700

      CALL RDPICK ( IHEAD, MINLAG, MAXLAG, IFWS, WEND, FOLD, LW,
     *              ISWMIN, ISWMAX, MINRNG, MAXRNG, IFRI, ILRI,
     *              ILWS, EXPAND, PRCNT, NUMITR, ITFS, NSAMPS,
     *              JFOLD, MSI, LILWS, IDSK, IPRNTR, IEOF, REBILD,
     *              NS, REFIN, LWNDW, cmdln)
 
      if (IEOF .eq. 1) go to 5700
C
C---- ZERO OUT DISTRIBUTION OF ITERATIONS BUFFER...
      CALL MOVE ( 0, IPICK, 0, 25*SZSMPD )
C
      IF ( .NOT. ONCE ) NOREAD = 1
      IF ( .NOT. ONCE ) GO TO 400
C
C---- GET VARIOUS WINDOW LENGTHS...
C---- LWNDW = WINDOW LENGTH FROM PICK CARD
C---- XLNGTH = OUTPUT X-CORR TRACE LENGTH
C---- WNDLAG = WINDOW LENGTH PLUS LAGS ON BOTH SIDES
      LWNDW  = ( ( WEND - IFWS ) / MSI ) + 1
      XLNGTH = ( ( MAXLAG - MINLAG ) / MSI ) + 1
      WNDLAG = ( LWNDW + XLNGTH ) - 1
      MFCOLD = FOLD
      XMIN   = MINLAG
      XSWMIN = ISWMIN
      XSWMAX = ISWMAX
C
      IF ( XLNGTH .LE. 3000 ) GO TO 300
      WRITE(IPRNTR, 200)
  200 FORMAT(/13X,'** M0100 ** ERROR DETECTED BY PROGRAM PICK:',
     *       /25X,'THE OUTPUT CORRELATION LENGTH EXCEEDS THE PROGRAM',
     *       /25X,'LIMIT.  PROGRAM PICK ALLOWS AN OUTPUT CORRELATION',
     *       /25X,'LENGTH OF 3000 SAMPLES.  ADJUST THE LARGE LAG',
     *       /25X,'WINDOW PARAMETERS SUCH THAT THE MAXIMUM LAG MINUS',
     *       /25X,'THE MINIMUM LAG IS LESS THAN OR EQUAL TO 3000',
     *       /25X,'SAMPLES (REMEMBER TO CONVERT MS TO SAMPLES).',/)
      CALL CCEXIT ( 4 )
C
C---- BUILD A.P. CHAIN...
Cray      A.P. CALLS REMOVED FOR Cray
  300 CONTINUE
C
C---- SET LENGTH OF DATA TO BE WRITTEN TO
C---- DISK.  2 * MAXLAG ON EITHER SIDE OF WINDOW...
      NSWIND = LWNDW + ( ( ( 2 * MAXLAG ) / MSI ) * 2 )
      IF ( NSWIND .GT. NSAMPS ) NSWIND = NSAMPS
      ONCE   = .FALSE.
c     LRECL  = ( NSWIND * 4 ) + 256
      LRECL  = ( NSWIND + ITRWRD) * SZSMPD
Cray     DATA WILL RESIDE IN MEMORY BUFFER TRCARR
C
C---- FIND RECORD TO START WITH...
  400 IF ( IFRI .GT. 1 )
     * CALL FNDREC ( IPRNTR, IBUF, NTAP, OTAP, IFRI, NOREAD, LENGTH,
     * ifmt_RecNum,l_RecNum,ln_RecNum, EOF_error)
      if ( EOF_error ) goto 999
      FCARD = .TRUE.
C
  500 KOUNT     =      0
      LOOPS     =      0
      FIRST     =  .TRUE.
      NOSCAL    = .FALSE.
      NDICES(1) =      0
      NDICES(2) =      0
C

      if (onepass) then
c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.
      iarr = LENBYT/SZSMPD
      items = iarr * fold

      call galloc (wkaddr, items*SZSMPD, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 6700
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c---------------------------------------------------
      endif
      onepass = .false.

C---- THIS LOOP WILL WRITE OUT A "FOLD"
C---- NUMBER OF TRACES FOR CORRELATING AND/OR
C---- COMPOSITING A REFERENCE TRACE WITH.  IT
C---- ALSO INITIALIZES ALL LAG INFORMATION BUFFERS
C---- AND BUFFERS DEALING WITH NON-USABLE TRACES...
C
      DO 1700 I = 1,FOLD

         iptr = (I-1) * iarr
         do 1710 j1710 = 1, iarr
            trcarr(iptr+j1710) = 0.0
1710     continue
         istatic = 30000
         call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               istatic , 1)

         call move (1, trcarr(iptr+1), IBUF, ITRWRD)

C
C---- ZERO OUT INFORMATION BUFFERS...
         DEAD(I,1)   = 0
         DEAD(I,2)   = 0
         IRITAB(I)   = 0
         SHIFT(I,1)  = 0
         SHIFT(I,2)  = 0
C
C---- DO WE READ THIS TIME ???
         IF ( NOREAD .EQ. 1 ) GO TO 600
C
         LENGTH = 0
         CALL RTAPE ( NTAP, IBUF, LENGTH )
         IF ( LENGTH .NE. 0 ) GO TO 600
C
C---- WERE THERE ENOUGH TRACES ???
         IF ( KOUNT .GE. 3 ) GO TO 1800
              GO TO 5300
C
  600    NOREAD = 0

c        keep last cdp number for dead traces            
         call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               istatic , 1)
         if (istatic .ge. 30000) then
             call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                   idi , 1)
             if (idi .le. 0)
     1       call savew2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     2                   kurcdp , 1)
         endif 
         call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               kurcdp , 1)
         call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               kurlin , 1)
         call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               irect  , 1)
         call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               itrct  , 1)
         call saver2(IBUF ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1               idist  , 1)

         IF ( ( FCARD ).AND. I .EQ. 1 )
     *                   ITRNO = itrct - 1
         IF ( I .EQ. 1 ) FREC  = irect
C
C---- HAVE WE REACHED LAST RECORD ???
  700    IF ( irect .GT. ILRI ) GO TO 5300
C
C---- SET VARIABLES...
         IF ( OLDRI .NE. 0 ) GO TO 800
              OLDLI = kurlin
              OLDDI = kurcdp
              OLDRI = irect
              OLDTR = itrct
              IFRI  = irect
C
              IF ( MINLI .EQ. 0 ) GO TO 800
                   MODFNC = MOD ( ( OLDLI - ( MINLI - 1 ) ), 2 )
                   OLDDI = MINDI
                   IF ( ( .NOT. REFIN )
     *                        .AND. MODFNC .EQ. 0 ) OLDDI = MAXDI
C
  800    IF ( iabs(idist) .LT. MINRNG
     *                    .OR. iabs(idist) .GT. MAXRNG )
     *        call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                     30000 , 1)
C
C---- IF DEAD, SAVE INFO...
         call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               istatic , 1)
         IF ( istatic .LT. 30000 ) GO TO 900
              DEAD(I,1) = kurlin
              DEAD(I,2) = kurcdp
              IRITAB(I) = irect 
         GO TO 1600
C
C---- CONVERT TO FLOATING POINT IF NECESSARY...
  900    NTOTAL = NTOTAL + 1
C
Cray    DATA FORMAT WILL ALWAYS BE 3
C
                  CALL MOVE ( 1, TRACE(1), IBUF(ITHWP1),NSAMPS * SZSMPD)
C
C---- DEFAULT WINDOW START TIME FOR LAST
C---- RECORD TO START TIME FOR FIRST RECORD
C---- IF NEEDED...
         IF ( ILWS .EQ. 0 ) WSTART = IFWS
C
C---- IF WE HAVEN'T CHANGED RECORDS, WE DON'T
C---- NEED TO RESET ANYTHING...
         IF ( IRISAV .EQ. irect ) GO TO 1400
         IRISAV = irect
         IF ( ILWS .EQ. 0 ) GO TO 1300
C
C---- IF WE'VE CHANGED RECORDS, DO WE NEED
C---- TO INTERPOLATE ???
         IF ( IRISAV .NE. IFRI ) GO TO 1000
              WSTART = IFWS
              GO TO 1300
 1000    IF ( IRISAV .NE. ILRI ) GO TO 1100
              WSTART = ILWS
              GO TO 1200
C
 1100    CALL INTERP ( IFRI, ILRI, IFWS, ILWS, IRISAV, WSTART, NTR,
     *                 JFOLD )
C
C---- SET SOME WINDOW INDICES...
 1200    WEND   = WSTART + ( ( LWNDW - 1 ) * MSI )
 1300    IWSTMP = ( WSTART / MSI ) + 1
         NSTART = ( ( WSTART - ( 2 * MAXLAG ) ) / MSI ) + 1
         IF ( NSTART .LT. 1 ) NSTART = 1
C
C---- IWSMPL IS THE SAMPLE OF THE WINDOW START TIME
C---- AFTER THE PORTION OF THE TRACE IS WRITTEN TO DISK.
         IWSMPL = ( IWSTMP - NSTART ) + 1
C
C---- CHECK WINDOW TIMES FOR VALIDITY...
         CALL CHECK ( WSTART, NSAMPS, MSI, MAXLAG, WEND, IPRNTR,
     *                NTAP, OTAP, REFIN, REFOUT, NREF, OREF )
C
         CALL MOVE ( 0, DATA(1), 0, NSWIND * SZSMPD )
C
 1400    LILWS = WSTART
         CALL MOVE ( 1, DATA(1), TRACE(NSTART), NSWIND * SZSMPD )
C
C---- WRITE TRACE TO DISK AND UPDATE COUNTER...
C
Cray   DATA WILL BE KEPT IN MEMORY.  MOVE IT FROM IBUF TO TRCARR.
C
c     CALL MOVE(1,TRCARR(1,I),IBUF,LENBYT)
      CALL MOVE(1,TRCARR(iptr+1),IBUF,LENBYT)
 1500    KOUNT = KOUNT + 1
 1600    IF ( .NOT. FIRST ) GO TO 1700
              NDICES(1) = kurlin
              NDICES(2) = kurcdp
              FIRST = .FALSE.
 1700 CONTINUE
C
C---- DID WE HAVE ENOUGH GOOD TRACES ???
 1800 IF ( LENGTH .EQ. 0 ) FOLD = I - 1
      IF ( KOUNT .GE. 3 ) GO TO 2100
C
      WRITE(IPRNTR,1900) NDICES(1), NDICES(2)
 1900 FORMAT(/,1X,'** M0500 ** WARNING FROM PROGRAM PICK: ',
     *            'FOR LINE ',I5,' CDP ',I5,' (SEE BELOW)',/)
C
      IF ( FCARD ) GO TO 1950
cmam     IF ( EXPAND .EQ. 1 ) WRITE(IPRNTR,3500) LOOPS
         IF ( EXPAND .ne. 0 ) WRITE(IPRNTR,3500) LOOPS
         CALL NONCON ( DEAD, IRITAB, IBUF, ITRNO, NTR, NEXTLI, MENBYT,
     *                 NEXTDI, NEXTRI, NEXTTR, OLDLI, OLDDI, OLDRI,
     *                 OLDTR, JFOLD, LASTRI, MINDI, MAXDI, MINLI,
     *                 REFIN, OTAP, IREC, EXPAND, FOLD, ILINE, IPRNTR,
     *                 TRCARR,lenbyt,iarr,xtr,ITRWRD,obytes,SZSMPD,nwds,
     *ifmt_TrcNum,l_TrcNum,ln_TrcNum,ifmt_RecNum,l_RecNum,ln_RecNum,
     *ifmt_LinInd,l_LinInd,ln_LinInd,ifmt_DphInd,l_DphInd,ln_DphInd,
     *ifmt_RecInd,l_RecInd,ln_RecInd,ifmt_StaCor,l_StaCor,ln_StaCor,
     *ifmt_DstSgn,l_DstSgn,ln_DstSgn)
 1950 M0500 = .TRUE.
C
      IF ( FREC .LE. ILRI ) GO TO 500
C
C---- ERRRORRR...
      WRITE(IPRNTR,2000) FREC
 2000 FORMAT (/13X,'** M0200 ** ERROR DETECTED IN PICK MAIN:',
     *        /25X,'STARTING WITH RECORD NUMBER ',I5,', LESS THAN',
     *        /25X,'THREE USABLE TRACES WERE FOUND TO BUILD THE',
     *        /25X,'REFERENCE TRACE BEFORE REACHING THE LAST RECORD',
     *        /25X,'TO PROCESS.  VERIFY FIRST AND LAST RECORDS',
     *        /25X,'TO PROCESS, RANGE LIMITS, AND DEAD TRACE FLAGS',
     *        /25X,'(WORD 125).',/)
      CALL CCEXIT ( 5 )
C
C---- DO WE HAVE REFERENCE TRACES INPUT ???
C
 2100 FCARD = .FALSE.
C
Cray   REFERENCE TRACES WILL ALWAYS BE BUILT
C
C
      IF ( REBILD )
     *     CALL BUILD ( REBILD, REFTR, IBUF, NS, IWSMPL, FOLD, DEAD,
     *                  LWNDW, DATA, LENBYT , TRCARR, iarr ,
     *                  ITRWRD,SZSMPD,KENBYT)
C
Cray    REFERENCE TRACE WILL NOT BE WRITTEN TO OUTPUT FILE
C
C
C---- WRITE REFERENCE TRACE IF REQUESTED...
C
      LOOPS = 1
C
C---- IS THIS THE FIRST ITERATION ???
      CALL FRSTIT ( XCORR, TRACE, IBUF, XLNGTH, WNDLAG, MINLAG, MAXLAG,
     *              IWSMPL, MSI, DATA, SHIFT, REFTR, DEAD, LWNDW,
     *              WEIGHT, KOUNT, NSAMPS, NS, FOLD, ISWMIN, ISWMAX,
     *              XMIN, TRCARR, LENBYT, iarr,ITRWRD,SZSMPD,KENBYT )
C
C---- RESET VARIABLES
 2200 LAGZRO      = .TRUE.
      BESTSM      = 0.
      LOOPS       = LOOPS + 1
C
C---- SET SOME WINDOW PARAMETERS...
      ISTRT1 = ( XSWMIN / FLOAT(MSI) ) + SIGN ( 0.5, XSWMIN )
      IEND1  = ( XSWMAX / FLOAT(MSI) ) + SIGN ( 0.5, XSWMAX )
      ILAG   = ( XMIN   / FLOAT(MSI) ) + SIGN ( 0.5, XMIN )
      INUMB  =   IEND1 - ISTRT1
C
C
      DO 3300 I = 1, FOLD
C
C---- SET SOME THINGS...
         ALTRNT(I,1) = -10000
         ALTRNT(I,2) = -10000
         WEIGHT(I,2) =      0.
         WEIGHT(I,3) =      0.
         SKIP        = .FALSE.
C
C---- IS TRACE DEAD ???
         IF ( DEAD(I,2) .NE. 0 ) GO TO 3300
C
Cray        MOVE TRACE FROM TRCARR TO IBUF
C
c     CALL MOVE(1,IBUF,TRCARR(1,I),LENBYT)
      iptr = (I-1) * iarr
      CALL MOVE(1,IBUF,TRCARR(iptr+1),LENBYT)
      CALL MOVE(1,DATA,IBUF(ITHWP1),KENBYT)
C
C---- THIS IS FOR LOCATING LAGS ON EACH TRACE
         ALIGN  = ILAG   - SHIFT(I,1)
         IBEGIN = ISTRT1 - SHIFT(I,1)
C
C---- WHERE ON DATA TRACE DO WE START ???
C---- AND END ???  FOR A LENGTH OF LWNDW
C---- FROM THE 1PICK CARD...
         ISTART = IWSMPL - SHIFT(I,2)
            IF ( ISTART .LT. 1 ) ISTART = 1
C
         IEND = ( ISTART + LWNDW ) - 1
            AMOUNT = LWNDW
            IF ( IEND .GT. NS ) AMOUNT = ( NS - ISTART ) + 1
C
C---- SUBTRACT TRACE "N" FROM COMPOSITE...
C
Cray         SUBTRACT TRACE N FROM COMPOSITE IN DO LOOP
C
      JJ=ISTART
      DO 2250 J=1,AMOUNT
         REFTR(J)=REFTR(J)-DATA(JJ)
 2250 JJ=JJ+1
C
C---- CORRELATE TRACE (TRACE)
C---- WITH REFERENCE TRACE (REFTR)
C---- AND GET OUTPUT X-CORR TRACE (XCORR)
C---- TRACE IS DATA TRACE WITH MINLAG
C---- AND MAXLAG ON EITHER SIDE ADDED...
         CALL MOVE ( 0, TRACE, 0, WNDLAG * SZSMPD )
C
C---- GET ENOUGH IN FRONT OF TRACE WINDOW
C---- TO SATISFY THE MAXLAG PARAMETER
C---- SO THERE WILL BE SOMETHING TO CORRELATE
C---- WITH THE REFERENCE TRACE...
C---- WNDLAG IS LENGTH OF WINDOW INCLUDING LAGS...
         ISTART = ( IWSMPL - ( ( MAXLAG / MSI ) + 1 ) ) + 1
            IF ( ISTART .LT. 1 ) ISTART = 1
C
         IEND = ( ISTART + WNDLAG ) - 1
            AMOUNT = WNDLAG
            IF ( IEND .GT. NS ) AMOUNT = ( NS - ISTART ) + 1
C
C---- LOAD UP DATA TRACE...
         CALL MOVE ( 1, TRACE(1), DATA(ISTART), AMOUNT * SZSMPD )
C
C---- CORRELATE DATA TRACE WITH REFERENCE TRACE...
Cray     CALL APEXC ( TRACE, REFTR, XCORR, WNDLAG, LWNDW, XLNGTH )
         CALL CROSSC(TRACE,WNDLAG,REFTR,LWNDW,XCORR,XLNGTH) ! WAS APEXC
C---- FIND PEAK WITH MAXIMUM CORRELATION COEFFICIENT...
C---- IF TWO PEAKS HAVE SAME COEFFICIENT, CHOOSE
C---- ONE NEAREST ZERO LAG.  SUM OF LAGS CAN'T EXCEED
C---- THE SMALL WINDOW LIMITS...
         PRIMRY      = -10000
         WEIGHT(I,1) =      0.
         IB1         = IABS(ALIGN) + IBEGIN + 1
         IE1         = IB1 + INUMB
C
         DO 2400 IPNT = IB1, IE1
            IF ( XCORR(IPNT) .LT. 0.0 ) GO TO 2400
            IF ( XCORR(IPNT-1) .GE. XCORR(IPNT)
     *                         .OR. XCORR(IPNT) .LT. XCORR(IPNT+1) )
     *                                          GO TO 2400
            IF ( XCORR(IPNT) .LT. WEIGHT(I,1) ) GO TO 2400
            IF ( XCORR(IPNT) .GT. WEIGHT(I,1) ) GO TO 2300
            IF ( IABS(IPNT - 1 + ALIGN) .GE. IABS(PRIMRY) ) GO TO 2400
 2300       PRIMRY      = IPNT - 1 + ALIGN
            WEIGHT(I,1) = XCORR(IPNT)
 2400    CONTINUE
C
C---- IF NOT ZERO LAG, NO NEED TO SEARCH FOR
C---- ALTERNATE PICKS, BECAUSE IF WE DON'T GET
C---- ZERO LAG, WE WON'T PUT OUT A LIVE CDP...
C---- IF NO PEAK IN SMALL WINDOW, USE ALTERNATE
C---- PEAKS TO FIND SMALLEST LAG...
      IF ( PRIMRY .NE. 0
     *            .AND. PRIMRY .NE. -10000 ) GO TO 3100
C
C---- FIND ALTERNATE PICK WITH POSITIVE LAG...
C---- ADD AN EXTRA ONE TO ISTART TO COMPENSATE
C---- WHEN SEARCHING FOR PEAKS.  YOU'RE ALWAYS
C---- SEARCHING FOR PEAKS USING ONE SAMPLE ON EITHER
C---- SIDE OF APPROPRIATE SAMPLE.   IEND WILL END ONE
C---- SAMPLE SOONER ALSO FOR THE SAME REASON...
         IB2         = IABS(ALIGN) + 1
         IE2         = XLNGTH      - 1
C
 2500    DO 2600 IPNT = IB2, IE2
            IF ( XCORR(IPNT) .LT. 0.0 ) GO TO 2600
            IF ( XCORR(IPNT-1) .GE. XCORR(IPNT)
     *                         .OR. XCORR(IPNT) .LT. XCORR(IPNT+1) )
     *                                          GO TO 2600
            IF ( IPNT - 1 + ALIGN
     *                    .EQ. PRIMRY ) GO TO 2600
            ALTRNT(I,1) = IPNT - 1 + ALIGN
            WEIGHT(I,2) = XCORR(IPNT)
            GO TO 2700
 2600    CONTINUE
C
C---- FIND ALTERNATE PICK WITH NEGATIVE LAG...
 2700    IF ( SKIP ) GO TO 3100
         IE3   = IABS(ALIGN)
 2750    IPNT2 = IE3 + 1
C
C---- SIMULATE A NEGATIVE INCREMENT IN THIS LOOP...
         DO 2800 J = 2, IE3
            IPNT2 = IPNT2 - 1
            IF ( XCORR(IPNT2) .LT. 0.0 ) GO TO 2800
            IF ( XCORR(IPNT2-1) .GE. XCORR(IPNT2)
     *                          .OR. XCORR(IPNT2) .LT. XCORR(IPNT2+1) )
     *                                           GO TO 2800
            IF ( IPNT2 - 1 + ALIGN
     *                     .EQ. PRIMRY ) GO TO 2800
            ALTRNT(I,2) = IPNT2 - 1 + ALIGN
            WEIGHT(I,3) = XCORR(IPNT2)
            GO TO 2900
 2800    CONTINUE
C
C---- IF NO PEAK IN SMALL WINDOW, PICK
C---- PEAK NEAREST ZERO LAG USING ALTERNATES,
C---- IF THEY EXIST...
 2900    IF ( SKIP ) GO TO 3100
         IF ( PRIMRY .NE. -10000 ) GO TO 3100
         IF ( ALTRNT(I,1) .EQ. -10000
     *                    .AND. ALTRNT(I,2) .EQ. -10000 ) GO TO 3100
              IF ( IABS(ALTRNT(I,2)) .GT. IABS(ALTRNT(I,1)) )
     *             GO TO 3000
C
C---- IF NO PRIMARY IS FOUND AND BOTH
C---- ALTERNATES HAVE SAME LAG, CHOOSE
C---- ONE WITH HIGHER CORRELATION COEFFICIENT...
              IF ( IABS(ALTRNT(I,2)) .EQ. IABS(ALTRNT(I,1))
     *                  .AND. WEIGHT(I,2) .GT. WEIGHT(I,3) )
     *                        GO TO 3000
                   PRIMRY      = ALTRNT(I,2)
                   WEIGHT(I,1) = WEIGHT(I,3)
                   ALTRNT(I,2) =      -10000
                   WEIGHT(I,3) =           0.
                   IE3         = PRIMRY + 1 - ALIGN
                   SKIP        = .TRUE.
                   GO TO 2750
 3000         IF ( IABS(ALTRNT(I,1)) .GT. IABS(ALTRNT(I,2)) )
     *             GO TO 3100
                   PRIMRY      = ALTRNT(I,1)
                   WEIGHT(I,1) = WEIGHT(I,2)
                   ALTRNT(I,1) =      -10000
                   WEIGHT(I,2) =           0.
                   IB2         = PRIMRY + 1 - ALIGN
                   SKIP        = .TRUE.
                   GO TO 2500
C
 3100    IF ( PRIMRY .NE. 0 ) LAGZRO = .FALSE.
         IF ( PRIMRY .EQ. -10000 ) GO TO 3200
C
C---- ACCUMULATE LAGS AND RESET THINGS...
         SHIFT(I,1) = SHIFT(I,1) + PRIMRY
         SHIFT(I,2) = SHIFT(I,2) + PRIMRY
         BESTSM     = BESTSM     + SHIFT(I,1)
C
C---- SET UP INDICES FOR GRABBING THE
C---- RIGHT START AND END OF THE TRACE
C---- ON DISK USING WINDOW LENGTH FROM 1PICK CARD...
 3200    ISTART = IWSMPL - SHIFT(I,2)
            IF ( ISTART .LT. 1 ) ISTART = 1
C
         IEND = ( ISTART + LWNDW ) - 1
            AMOUNT = LWNDW
            IF ( IEND .GT. NS ) AMOUNT = ( NS - ISTART ) + 1
C
C---- SUM ADJUSTED TRACE "N" BACK INTO REFTR...
C
Cray        SUM ADJUSTED TRACE N BACK INTO REFTR IN DO LOOP
C
      JJ=ISTART
      DO 3250 J=1,AMOUNT
      REFTR(J)=REFTR(J)+DATA(JJ)
 3250 JJ=JJ+1
C
 3300 CONTINUE
C
C---- HAVE WE COMPLETED ITERATIONS ???
      IF ( LOOPS .LT. NUMITR ) GO TO 3400
           IF ( LAGZRO ) GO TO 3400
           LPERR = 1
           GO TO 4300
C
C---- DID WE ACHIEVE ZERO LAG ???
 3400 IF ( .NOT. LAGZRO ) GO TO 2200
      IF ( KOUNT .EQ. 0 ) GO TO 4300
C
C---- COMPUTE AVERAGE...
      IAVGLG = ( BESTSM / FLOAT(KOUNT) ) + SIGN ( 0.5, BESTSM )
      CALL MOVE ( 0, XCORR, 0, 3000*SZSMPD )
C
C---- WRITE OUT HEADER FOR EXPANDED
C---- PRINTOUT IF NEEDED...
cmam  IF ( EXPAND .EQ. 1 ) WRITE(IPRNTR,3500) LOOPS
      IF ( EXPAND .ne. 0 ) WRITE(IPRNTR,3500) LOOPS
 3500 FORMAT(/,2x,'LI',5X,'DI',5X,'GI',3X,'RECORD',3X,'RANGE',3X,
     *          'PRIMARY PICK',1X,'WEIGHT',3X,'POSITIVE ALTERNATE',1X,
     *          'WEIGHT',3X,'NEGATIVE ALTERNATE',1X,'WEIGHT',3X,
     *          'ITERATIONS = ',I2,/,2x,129('-'))
C
      DO 4200 I = 1,FOLD
C
         IF ( DEAD(I,2) .NE. 0 ) GO TO 4200
Cray            MOVE TRACE FROM TRCARR INTO IBUF
c     CALL MOVE(1,IBUF,TRCARR(1,I),LENBYT)
      iptr = (I-1) * iarr
      CALL MOVE(1,IBUF,TRCARR(iptr+1),LENBYT)
      CALL MOVE(1,DATA,IBUF(ITHWP1),KENBYT)
C
C---- INITIALIZE ACCUMULATORS...
         POWR1  = 0.
         POWR2  = 0.
         TPOWER = 0.
         WSUM   = 0.
C
C---- TAKE OUT AVERAGE...
         SHIFT(I,1)  = SHIFT(I,1)  - IAVGLG
C
         IF ( ALTRNT(I,1) .NE. -10000 )
     *                    ALTRNT(I,1) = ALTRNT(I,1) + SHIFT(I,1)
         IF ( ALTRNT(I,2) .NE. -10000 )
     *                    ALTRNT(I,2) = ALTRNT(I,2) + SHIFT(I,1)
C
C---- ONE MORE TIME...
      ISTART = IWSMPL - SHIFT(I,2)
        IF ( ISTART .LT. 1 ) ISTART = 1
C
      IEND = ( ISTART + LWNDW ) - 1
        IF ( IEND .GT. NS ) IEND = NS
C
      IF ( IEND .LE. ISTART ) GO TO 4000
      IDIFF = ISTART - 1
C
C---- SUM SQUARES FOR NORMALIZATION...
      DO 3700 K = ISTART, IEND
         I1        = K - IDIFF
         VALUE1    = DATA(K)
         VALUE2    = REFTR(I1) - VALUE1
         POWR2     = POWR2 + VALUE2 * VALUE2
         VALUE1    = VALUE1 * VALUE1
         POWR1     = POWR1 + VALUE1
         XCORR(I1) = XCORR(I1) + VALUE1
 3700 CONTINUE
C
C---- COMPUTE TOTAL POWER...
      TPOWER = POWR1 * POWR2
C
C---- SUM THE WEIGHTS...
      WSUM = WEIGHT(I,1) + WEIGHT(I,2) + WEIGHT(I,3)
C
C---- WERE WE IN A DEAD ZONE ???
      IF ( TPOWER .LT. SMALL
     *            .AND. TPOWER .GT. -SMALL ) GO TO 4000
      IF ( WSUM   .LT. SMALL
     *            .AND. WSUM   .GT. -SMALL ) GO TO 4000
C
      SQPOWR = SQRT( TPOWER )
C
C---- COMPUTE CORRELATION WEIGHTS...
      DO 3900 J = 1,3
         IF ( ABS(WEIGHT(I,J)) .GT. SQW ) GO TO 3800
         WEIGHT(I,J) = ( WEIGHT(I,J) * WEIGHT(I,J) ) / WSUM
         WEIGHT(I,J) = WEIGHT(I,J) / SQPOWR
         IF ( WEIGHT(I,J) .GT. TNTHOW ) GO TO 3800
         WEIGHT(I,J) = WEIGHT(I,J) * 10000.
 3800    IF ( WEIGHT(I,J) .GT. 10000. ) WEIGHT(I,J) = 0.
 3900 CONTINUE
C
      GO TO 4200
C
 4000 WRITE(IPRNTR,4100) IBUF(121), IBUF(122), IBUF(106), IBUF(107)
 4100 FORMAT(/1X,'** M0300 ** WARNING FROM PROGRAM PICK FOR LINE ',
     *            I5,' CDP ',I5,' RECORD ',I5,' TRACE ',I4,' (SEE ',
     *               'BELOW)')
      M0300 = .TRUE.
C
C---- SET STUFF FOR BAD PICKS...
         WEIGHT(I,1) = 0.
         WEIGHT(I,2) = 0.
         WEIGHT(I,3) = 0.
         SHIFT(I,1)  = IBAD
         ALTRNT(I,1) = IBAD
         ALTRNT(I,2) = IBAD
         IZBAD       = IZBAD + 1
 4200 CONTINUE
C
C---- HOW MANY DO WE HAVE ???
      IF ( ( KOUNT - IZBAD ) .GE. 3 ) GO TO 4400
      IZBAD = 0
C
C---- WE NEED TO PAD FOR NON-CONVERGENT CDP'S...
cmam 4300 IF ( EXPAND .EQ. 1 ) WRITE(IPRNTR,3500) LOOPS
 4300 IF ( EXPAND .ne. 0 ) WRITE(IPRNTR,3500) LOOPS
      CALL NONCON ( DEAD, IRITAB, IBUF, ITRNO, NTR, NEXTLI, MENBYT,
     *              NEXTDI, NEXTRI, NEXTTR, OLDLI, OLDDI, OLDRI, OLDTR,
     *              JFOLD, LASTRI, MINDI, MAXDI, MINLI, REFIN, OTAP,
     *              IREC, EXPAND, FOLD, ILINE, IPRNTR, TRCARR, lenbyt,
     *              iarr,xtr,ITRWRD,obytes,SZSMPD,nwds,
cmam *              iarr,xtr,ITRWRD,obytes,
cmam......above line is incomplete:add SZSMPD,nwds,
     *ifmt_TrcNum,l_TrcNum,ln_TrcNum,ifmt_RecNum,l_RecNum,ln_RecNum,
     *ifmt_LinInd,l_LinInd,ln_LinInd,ifmt_DphInd,l_DphInd,ln_DphInd,
     *ifmt_RecInd,l_RecInd,ln_RecInd,ifmt_StaCor,l_StaCor,ln_StaCor,
     *ifmt_DstSgn,l_DstSgn,ln_DstSgn)

      NOSCAL = .TRUE.
      GO TO 4900
C
 4400 CONTINUE
C
      DO 4800 L = 1,FOLD
C
C---- IS INPUT TRACE DEAD ???
         IF ( DEAD(L,2) .NE. 0 ) GO TO 4500
C
Cray        MOVE TRACE FROM TRCARR TO IBUF
C
c     CALL MOVE(1,IBUF,TRCARR(1,L),LENBYT)
      iptr = (L-1) * iarr
      CALL MOVE(1,IBUF,TRCARR(iptr+1),LENBYT)
c     CALL MOVE(1,DATA,IBUF(ITHWP1),KENBYT)
      do  ii = 1, nwds
          data (ii) = 0.0
      enddo
C

C---- STORE PRIMARY PICK...
         NPICK     = 0
c        IBUF(129) = SHIFT(L,1) * MSI
         DATA(1) = SHIFT(L,1) * MSI
         iflagd  = DATA(1)
         IF ( SHIFT(L,1) .GT. IDEAD ) NPICK = NPICK + 1
cmam     IF ( SHIFT(L,1) .LE. IDEAD ) IBUF(129) = IDEAD
         IF ( SHIFT(L,1) .LE. IDEAD ) data(1) = IDEAD
c        IBUF(130) = WEIGHT(L,1)
         DATA(2) = WEIGHT(L,1)
C
C---- STORE POSITIVE ALTERNATE...
c        IBUF(131) = ALTRNT(L,1) * MSI
         DATA(3) = ALTRNT(L,1) * MSI
         IF ( ALTRNT(L,1) .GT. IDEAD ) NPICK = NPICK + 1
cmam     IF ( ALTRNT(L,1) .LE. IDEAD ) IBUF(131) = IDEAD
         IF ( ALTRNT(L,1) .LE. IDEAD ) data(3) = IDEAD
c        IBUF(132) = WEIGHT(L,2)
         DATA(4) = WEIGHT(L,2)
C
C---- STORE NEGATIVE ALTERNATE...
c        IBUF(133) = ALTRNT(L,2) * MSI
         DATA(5) = ALTRNT(L,2) * MSI
         IF ( ALTRNT(L,2) .GT. IDEAD ) NPICK = NPICK + 1
cmam     IF ( ALTRNT(L,2) .LE. IDEAD ) IBUF(133) = IDEAD
         IF ( ALTRNT(L,2) .LE. IDEAD ) data(5) = IDEAD
c        IBUF(134) = WEIGHT(L,3)
         DATA(6) = WEIGHT(L,3)
C
c        IBUF(149) = NPICK
         DATA(21) = NPICK
C
C---- IF PRIMARY PICK NO GOOD, KILL TRACE...
         IF ( iflagd .EQ. IDEAD )
     1   call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     2               30000 , 1)

         call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               kurcdp , 1)
         call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               kurlin , 1)
         call saver2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1               kurgrp , 1)
         call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               irect  , 1)
         call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               itrct  , 1)
         call saver2(IBUF ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1               idist  , 1)
         call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               istatic, 1)

C
C---- FILL PRINT BUFFER WITH GOOD INFO...
         ILINE(1)  = kurlin
         ILINE(2)  = kurcdp
         ILINE(3)  = kurgrp
         ILINE(4)  = irect
         ILINE(5)  = iabs(idist)
         ILINE(6)  = DATA(1)
         ILINE(7)  = DATA(2)
         ILINE(8)  = DATA(3)
         ILINE(9)  = DATA(4)
         ILINE(10) = DATA(5)
         ILINE(11) = DATA(6)
C
C---- SAVE TOTAL NUMBER OF GOOD TRACES WRITTEN...
         ITRNO = itrct
         IF ( istatic .NE. 30000 )
     *                  NGOOD = NGOOD + 1
         GO TO 4600
C
C---- INPUT TRACE WAS DEAD, MAKE UP SOME STUFF...
4500     continue
         IF ( IRITAB(L) .NE. 0 ) then
c             IBUF(106) = IRITAB(L)
              call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    IRITAB(L) , 1)
         endif
C
C---- STUFF DEAD INFORMATION...
         DATA(1)  = IDEAD
         DATA(2)  =     0
         DATA(3)  = IDEAD
         DATA(4)  =     0
         DATA(5)  = IDEAD
         DATA(6)  =     0
         DATA(21) =     0
c        IBUF(125) = 30000
c        IBUF(121) = DEAD(L,1)
c        IBUF(122) = DEAD(L,2)
         idl1 = DEAD(L,1)
         idl2 = DEAD(L,2)
         call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000  , 1)
         call savew2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               idl1   , 1)
         call savew2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               idl2   , 1)
C
         IF ( ITRNO .GE. NTR ) ITRNO = 0
         ITRNO     = ITRNO + 1
c        IBUF(107) = ITRNO
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               ITRNO  , 1)
C
         call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               kurcdp , 1)
         call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               kurlin , 1)
         call saver2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1               kurgrp , 1)
         call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               irect  , 1)
C---- FILL PRINT BUFFER WITH BAD INFO...
         ILINE(1)  = kurlin
         ILINE(2)  = kurcdp
         ILINE(3)  = kurgrp
         ILINE(4)  = irect
         ILINE(5)  = iabs(idist)
         ILINE(6)  = IDEAD
         ILINE(7)  =     0
         ILINE(8)  = IDEAD
         ILINE(9)  =     0
         ILINE(10) = IDEAD
         ILINE(11) =     0
C
 4600    continue

         call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               kurcdp , 1)
         call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               kurlin , 1)
         call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               irect  , 1)
         call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               itrct  , 1)

         NEXTLI = kurlin
         NEXTDI = kurcdp
         NEXTRI = irect 
         NEXTTR = itrct
C
         IF ( L .EQ. 1 ) then

              CALL PADTR ( NEXTLI, NEXTDI, NEXTRI, NEXTTR, OLDLI,
     *                     OLDDI, OLDRI, OLDTR, JFOLD, NTR, LASTRI,
     *                     MINDI, MAXDI, MINLI, REFIN, OTAP, IREC,
     *                     IPRNTR, obytes,ITRWRD, SZSMPD, nwds,
     *ifmt_TrcNum,l_TrcNum,ln_TrcNum,ifmt_RecNum,l_RecNum,ln_RecNum,
     *ifmt_LinInd,l_LinInd,ln_LinInd,ifmt_DphInd,l_DphInd,ln_DphInd,
     *ifmt_RecInd,l_RecInd,ln_RecInd,ifmt_StaCor,l_StaCor,ln_StaCor)

         endif              
C
         CALL MOVE ( 1, IBUF(ITHWP1), DATA, nwds*SZSMPD)
C
C---- GET CORRECT RECORD NUMBER...
         IF ( OLDRI .NE.  irect
     *              .AND. itrct .EQ. 1 ) irect = OLDRI + 1
         IF ( OLDRI .NE.  irect
     *              .AND. itrct .NE. 1 ) irect = OLDRI

         call savew2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               irect  , 1)
         call savew2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               itrct  , 1)
C
C---- WRITE OUT TRACE...
         CALL WRTAPE ( OTAP, IBUF,  obytes) ! Cray
C
C---- SAVE INFORMATION FOR CHECKS...
c        ITRNO = IBUF(107)
c        OLDLI = IBUF(121)
c        OLDDI = IBUF(122)
c        OLDRI = IBUF(106)
c        OLDTR = IBUF(107)
         call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               OLDDI , 1)
         call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1               OLDLI , 1)
         call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               OLDRI  , 1)
         call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               OLDTR  , 1)
C
C---- KEEP TRACK OF TRACES WRITTEN...
         IREC = IREC + 1
C
C---- LETTUM KNOW WHAT HAPPENED...
cmam     IF ( EXPAND .EQ. 1 ) WRITE(IPRNTR,4700) ILINE
         IF ( EXPAND .ne. 0 ) WRITE(IPRNTR,4700) ILINE
 4700    FORMAT(I5,2X,I5,2X,I5,3X,I5,2X,I6,4X,I6,2X,I10,
     *          10X,I6,2X,I10,10X,I6,2X,I10) 
C
 4800 CONTINUE
C
C---- KEEP TRACK OF DISTRIBUTION OF ITERATIONS...
 4900 IPICK(LOOPS) = IPICK(LOOPS) + 1
C
C---- WRITE APPROPRIATE PROCESSING MESSAGE...
      IF ( EXPAND .EQ. 0 )
     *     WRITE(IPRNTR,5000) NDICES(1), NDICES(2), FREC
 5000      FORMAT(1X,'LINE ',I5,' CDP ',I5,' PROCESSED, ',
     *               'RECORD ',I5,' PROCESSED')
C
      IF ( LPERR .EQ. 0 ) GO TO 5200
           WRITE(IPRNTR,5100) NDICES(1), NDICES(2), LOOPS
 5100      FORMAT(/,1X,'** M0600 ** WARNING FROM PROGRAM PICK: ',
     *                 'FOR LINE ',I5,' CDP ',I5,' NUMBER OF ',
     *                 'ITERATIONS = ',I4,' (SEE BELOW)',/)
           M0600 = .TRUE.
           LPERR = 0
C
C---- IF EOF WAS ENCOUNTERED BEFORE FOLD TRACES
C---- WERE READ, FOLD WAS RESET TO NTR...
 5200 IF ( MFCOLD .NE. FOLD ) GO TO 5300
C
      IF ( KOUNT .EQ. 0
     *           .OR. ( NOSCAL ) ) GO TO 500
C
C---- GO SCALE AND WEIGHT REFERENCE TRACE...
      NSCW = WNDLAG
      IF ( NSCW .GT. 3000 ) NSCW = 3000
C
      CALL SCAWT ( REFTR, XCORR, NSCW, LW, KOUNT, TRACE )
      GO TO 500
C
 5300 IF ( ITRNO .EQ. NTR
     *           .AND. ( ( OLDRI .EQ. IBUF(106))
     *           .OR.  ( OLDRI .EQ. ILRI ) ) )  GO TO 5600
C
      IF ( MFCOLD .EQ. FOLD )
     *     WRITE(IPRNTR,5400)
 5400      FORMAT(/13X,'** M0700 ** WARNING FROM PROGRAM PICK:',
     *            /25X,'END-OF-FILE ENCOUNTERED OR THE LAST RECORD',
     *            /25X,'TO PROCESS WAS READ AND LESS THAN 3',
     *            /25X,'USABLE TRACES WERE FOUND.  THE NO PICK FLAG',
     *            /25X,'WILL BE SET FOR THIS CDP.',/)
C
      IF ( MFCOLD .NE. FOLD )
     *     WRITE(IPRNTR,5500) MFCOLD
 5500      FORMAT(/13X,'** M0800 ** WARNING FROM PROGRAM PICK:',
     *            /25X,'END-OF-FILE ENCOUNTERED BEFORE ANOTHER ',I3,
     *            /25X,'TRACES COULD BE READ, BUT AT LEAST 3',
     *            /25X,'USABLE TRACES WERE FOUND, SO PICK WAS ABLE',
     *            /25X,'TO PROCESS THE DATA.  THE CDP WILL BE PADDED',
     *            /25X,'OUT TO THE NUMBER OF TRACES PER RECORD.',/)
C
 5600 CALL DISTIT ( IPICK, IPRNTR, NUMITR )
      GO TO 100
C
C---- START PADDIN'...
 5700 NEXTLI = MAXLI
c     NEXTDI = IBUF(122)
         call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1               NEXTDI , 1)
      IF ( MINLI .EQ. 0 ) GO TO 5800
           MODFNC = MOD ( ( MAXLI - ( MINLI - 1 ) ), 2 )
           NEXTDI = MAXDI
           IF ( ( .NOT. REFIN )
     *                .AND. MODFNC .EQ. 0 )
     *                        NEXTDI = MINDI
 5800 continue

      IF ( ILRI .EQ. 99999 )
     1   call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     2               NEXTRI , 1)
      IF ( ILRI .NE. 99999 ) NEXTRI = ILRI
      LASTRI = NEXTRI
      NEXTTR = NTR
      CALL PADTR ( NEXTLI, NEXTDI, NEXTRI, NEXTTR, OLDLI, OLDDI,
     *             OLDRI, OLDTR, JFOLD, NTR, LASTRI, MINDI, MAXDI,
     *             MINLI, REFIN, OTAP, IREC, IPRNTR, obytes,ITRWRD,
     *             SZSMPD, nwds,
     *ifmt_TrcNum,l_TrcNum,ln_TrcNum,ifmt_RecNum,l_RecNum,ln_RecNum,
     *ifmt_LinInd,l_LinInd,ln_LinInd,ifmt_DphInd,l_DphInd,ln_DphInd,
     *ifmt_RecInd,l_RecInd,ln_RecInd,ifmt_StaCor,l_StaCor,ln_StaCor)
C
      IF ( ( .NOT. M0300 ) .AND.
     *     ( .NOT. M0500 ) .AND.
     *     ( .NOT. M0600 ) ) GO TO 6200
C
      N24 = 24
C
      IF ( M0600 ) WRITE(IPRNTR,5900)
 5900 FORMAT(/28X,'** M0600 ** WARNING FROM PROGRAM PICK:',
     *       /40X,'AFTER THE GIVEN NUMBER OF ITERATIONS, THE ',
     *       /40X,'CDP DID NOT PRODUCE A CORRELATION SUCH THAT',
     *       /40X,'THE LAGS WERE ZERO.  A NO PICK FLAG WILL BE',
     *       /40X,'SET FOR THIS CDP.',/)
C
      IF ( M0300 ) WRITE(IPRNTR,6000)
 6000 FORMAT(/28X,'** M0300 ** WARNING FROM PROGRAM PICK:',
     *       /40X,'FOR THE INDICATED RECORD, TRACE, AND CDP, THE',
     *       /40X,'CORRELATIONS ARE ALL ZEROS.  ENSURE THE WINDOW',
     *       /40X,'IS NOT IN ANY MUTED OR DEAD ZONES.  THIS INCLUDES',
     *       /40X,'ANY LARGE INTERNAL MUTES.',/)
C
      IF ( M0500 ) WRITE(IPRNTR,6100)
 6100 FORMAT(/28X,'** M0500 ** WARNING FROM PROGRAM PICK:',
     *       /40X,'THERE ARE LESS THAN THREE USABLE TRACES',
     *       /40X,'FOR THE GIVEN CDP.  VERIFY FIRST AND LAST',
     *       /40X,'RECORDS TO PROCESS, RANGE LIMITS, AND',
     *       /40X,'DEAD TRACE FLAGS.  AT LEAST THREE USABLE',
     *       /40X,'TRACES PER CDP ARE REQUIRED, SO THE NO PICK FLAG',
     *       /40X,'WILL BE SET FOR THIS CDP.',/)
C
C---- COMPUTE PERCENT BAD PICKS...
 6200 IF ( NTOTAL .EQ. 0 ) GO TO 6300
      RATIO  = FLOAT( NTOTAL - NGOOD ) / FLOAT( NTOTAL )
      RATIO  = RATIO * 100.0
      IPRCNT = RATIO
C
 6300 IF ( IPRCNT .LT. PRCNT ) GO TO 6500
C
      WRITE (IPRNTR,6400) IPRCNT, PRCNT
 6400 FORMAT(/13X,'** M0900 ** ERROR DETECTED BY PROGRAM PICK:',
     *       /25X,'FURTHER PROCESSING IS PREVENTED BECAUSE ',I3,
     *       /25X,'PERCENT OF THE INPUT DATA CONTAINS NO PICKS.',
     *       /25X,'THIS IS GREATER THAN ',I3,' PERCENT AS WAS',
     *       /25X,'SPECIFIED ON THE 1PICK CARD.  IF THIS IS',
     *       /25X,'ACCEPTABLE, RESUBMIT THE SUBSEQUENT JOBS.',/)
      ICCODE = 100
      GO TO 6700
C
 6500 WRITE (IPRNTR,6600) RATIO
 6600 FORMAT(/13X,'** M1000 ** MESSAGE FROM PROGRAM PICK:',
     *       /25X,'PROCESSING COMPLETED WITH ',F5.1,' PERCENT OF ',
     *            'THE INPUT DATA CONTAINING NO PICKS.',/)
C
 6700 CALL LBCLOS ( NTAP )
      CALL LBCLOS ( OTAP )
C
C---- DO ACCOUNTING AND QUIT WITH
C---- APPROPRIATE CONDITION CODE...
      IREC = IREC / NTR
      IF ( IREC .LE. 0 ) IREC = 1
      CALL CCEXIT ( ICCODE )
      write(LERR,*)' Normal Termination'
      write(LER,*)' '
      write(LER,*)'PICKUSP:  Normal Termination'
      stop

 999  continue
      call lbclos(ntap)
      call lbclos(otap)
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' '
      write(LER,*)'PICKUSP:  Abnormal Termination'
      stop

      END
C
      SUBROUTINE HELP()
#include <f77/iounit.h>

      WRITE (LER,1)
1     FORMAT (/
     *'pick - pick reflections (statics by correlation)'//
     *'Usage: pick -Ninputfile -Eoutputfile -Ccardfile'//
     *'-N   : Input file name. Default is standard input.'//                
     *'-E   : Output file name . Default is standard output.'//           
     *'-C   : Card file. If -C is present with no following name,'/
     *'       the default is pick.crd. -pick.crd may be used with'/
     *'       startjob.  The file should contain 1PICK cards as'/
     *'       required (see pick man page).'///)
      WRITE (LER,2)
2     FORMAT (/
     *'Optional command line argumtent entries:'//
     *'-mnlag[] - min large lag window                          (-120)'/
     *'-mxlag[] - max large lag window                          (+120)'/
     *'-ws[]    - window start time (ms) on first record           (0)'/
     *'-we[]    - window end time:     defines wind length (whole trc)'/
     *'-fld[]   - fold                             (def = line header)'/
     *'-sw[]    - smoothing window(ms)  (def = length of small window)'/
     *'-smn[]   - small window minimum lag (ms)                   -16)'/
     *'-smx[]   - small window maximum lag (ms)                   +16)'/
     *'-rgn[]   - minimum range limit (ft,m)                 (-999999)'/
     *'-rgx[]   - maximum range limit (ft,m)                 (+999999)'/
     *'-rs[]    - start record to pick                         (first)'/
     *'-re[]    - last record to pick                           (last)'/
     *'-st[]    - start window time (ms) at last record  (def = first)'/
     *'-pc[]    - % bad picks to tolerate                        (100)'/
     *'-ni[]    - # iterations                            (def = fold)'/
     *)
      STOP
      END 
