C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE RDPICK ( IHEAD, MINLAG, MAXLAG, IFWS, WEND, FOLD,
     *                    LW, ISWMIN, ISWMAX, MINRNG, MAXRNG, IFRI,
     *                    ILRI, ILWS, EXPAND, PRCNT, NUMITR, ITFS,
     *                    NSAMPS, JFOLD, MSI, LILWS, IDSK, IPRNTR,
     *                    IEOF, REBILD, NS, REFIN, LWNDW, cmdln)
C***********************************************************************
C
C     SUBROUTINE   - RDPICK
C     LANGUAGE     - FORTRAN
C     AUTHOR       - JACQUIE VINSON
C     DATE WRITTEN - 12/06/83
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                  TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: READS THE INPUT PARAMETERS FROM THE 1PICK CARDS
C               CHECKING FOR ERRORS.
C
C     PARAMETERS PASSED:
C       IHEAD  - I*4 - LINE HEADER BUFFER
C       MINLAG - I*4 - MINIMUM LARGE LAG WINDOW
C       MAXLAG - I*4 - MAXIMUM LARGE LAG WINDOW
C       IFWS   - I*4 - WINDOW START TIME OF FIRST REC.
C       WEND   - I*4 - WINDOW END TIME OF FIRST RECORD
C       FOLD   - I*4 - PROCESSING FOLD
C       LW     - I*4 - SMOOTHING WINDOW LENGTH
C       ISWMIN - I*4 - MINIMUM SMALL LAG WINDOW
C       ISWMAX - I*4 - MAXIMUM SMALL LAG WINDOW
C       MINRNG - I*4 - MINIMUM RANGE LIMIT
C       MAXRNG - I*4 - MAXIMUM RANGE LIMIT
C       IFRI   - I*4 - FIRST RECORD TO PROCESS
C       ILRI   - I*4 - LAST RECORD TO PROCESS
C       ILWS   - I*4 - WINDOW START TIME OF LAST REC.
C       EXPAND - I*4 - PRINT FLAG
C       PRCNT  - I*4 - PERCENT BAD PICKS BEFORE ABEND
C       NUMITR - I*4 - NUMBER OF ITERATIONS
C       ITFS   - I*4 - TIME OF FIRST SAMPLE
C       NSAMPS - I*4 - NUMBER OF SAMPLES
C       NS     - I*4 - NUMBER OF SAMPLES TO PROCESS
C       JFOLD  - I*4 - FOLD ON INPUT TAPE
C       MSI    - I*4 - SAMPLE INTERVAL
C       LILWS  - I*4 - WINDOW START TIME OF LAST
C                      RECORD PROCESSED
C       IDSK   - I*4 - DISK DATA SET LOGICAL UNIT
C       IPRNTR - I*4 - PRINTER LOGICAL UNIT
C       IEOF   - I*4 - END-OF-FILE FLAG
C       REBILD - L*1 - FLAG TO DETERMINE IF REFERENCE
C                      TRACE SHOULD BE REBUILT FOR
C                      OTHER THAN THE FIRST '1PICK' CARD
C       REFIN  - L*1 - FLAG FOR REFERENCE TRACES BEING INPUT
C       LWNDW  - I*4 - WINDOW LENGTH IN SAMPLES
C
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

C
      INTEGER     IHEAD(*), PRCNT, WEND, FOLD, EXPAND, argis
C
C
      LOGICAL      REBILD, REFIN, cmdln
      CHARACTER * 1 CARD1(80), CNEW
      CHARACTER*80 CARD
      EQUIVALENCE (CARD,CARD1)
      CHARACTER  CPICK*4, PCRD*4
C
      DATA CNEW/'N'/, CPICK/'PICK'/, ICRDNO/0/, IREFTR/0/

      SAVE
 
      ICCODE = 0
      IF ( ICRDNO .NE. 0 ) GO TO 400
 
      IF (cmdln) THEN         ! ****  cmd line args ************

         call argi4 ('-mnlag', MINLAG, -120, -120)
         call argi4 ('-mxlag', MAXLAG, +120, +120)
         call argi4 ('-ws'   ,   IFWS,    0,    0)
         call argi4 ('-we'   ,   WEND,    0,    0)
         call argi4 ('-fld'  ,   FOLD,    0,    0)
         call argi4 ('-sw'   ,     LW,    0,    0)
         call argi4 ('-smn'  , ISWMIN,  -16,  -16)
         call argi4 ('-smx'  , ISWMAX,  +16,  +16)
         call argi4 ('-rgn'  , MINRNG,    0,    0)
         call argi4 ('-rgx'  , MAXRNG,    0,    0)
         call argi4 ('-rs'   ,   IFRI,    0,    0)
         call argi4 ('-re'   ,   ILRI,    0,    0)
         call argi4 ('-st'   ,   ILWS,    0,    0)
         call argi4 ('-pc'   , IPRCNT,  100,  100)
         call argi4 ('-ni'   , NUMITR,    0,    0)
         EXPAND = argis('-V')

         IF ( REFIN ) IREFTR = 1
         go to 900

      ELSE                    ! ****  card input ***************
C---- READ CARD...
c     IF ( ICRDNO .NE. 0 ) GO TO 400
 
      READ(IDSK,100) CARD1
  100 FORMAT(80A1)
      IF ( REFIN ) IREFTR = 1
C
      CALL WRCARD ( CARD1, 1, IPRNTR )
C
C---- CHECK IF USING NEW CARD FORMAT...
      IF ( CARD1(67) .EQ. CNEW )
     *     READ(CARD,200) M     , PCRD  ,    MINLAG, MAXLAG, IFWS  ,
     *                  WEND  , FOLD  ,    LW    , ISWMIN, ISWMAX,
     *                  MINRNG, MAXRNG,    IFRI  , ILRI  , ILWS  ,
     *                  EXPAND, IPRCNT, NUMITR
  200 FORMAT(           T1,I1 , A4    ,    1X,I4 , 1X,I4 , I5    ,
     *                  I5    , I3    ,    1X,I3 , I4    , 1X,I4 ,
     *                  I5    , I5    ,    I5    , I5    , I5    ,
     *                  9X,I1 , I2    , I2 )
 
      IF ( CARD1(67) .NE. CNEW )
     *     READ(card,300) M     , PCRD  , MINLAG,    MAXLAG, IFWS  ,
     *                  WEND  , FOLD  , LW    ,    ISWMIN, ISWMAX,
     *                  MINRNG, MAXRNG, IFRI  ,    ILRI  , EXPAND ,
     *                  IPRCNT, NUMITR
  300 FORMAT(           T1,I1 , A4    , 1X,I4 ,    1X,I4 , 1X,I4 ,
     *                  1X,I4 , I3    , 1X,I3 ,    1X,I4 , 1X,I4 ,
     *                  I5    , I5    , 2X,I4 ,    I4    , 1X,I1 ,
     *                  I2    , 12X,I2 )

      ENDIF                   ! **********************************

C---- READ NEXT PICK CARD... CHECK FOR
C---- WINDOW LENGTH, RECORD BOUNDARIES, ETC.
  400 IF ( ICRDNO .EQ. 0 ) GO TO 900
      LILRI = ILRI
C     LILWS = ILWS + ITFS

      IF (cmdln) THEN         ! *** pick up next params **********
         call argi4 ('-ws'   ,  IFWS1,    0,    0)
         call argi4 ('-rgn'  ,MINRNG1,    0,    0)
         call argi4 ('-rgx'  ,MAXRNG1,    0,    0)
         call argi4 ('-rs'   ,  IFRI1,    0,    0)
         call argi4 ('-re'   ,  ILRI1,    0,    0)
         call argi4 ('-st'   ,  ILWS1,    0,    0)
         call argi4 ('-ni'   ,NUMITR1,    0,    0)

         if (ifws1.eq.0 .and. minrng1.eq.0 .and. maxrng1.eq.0 .and.
     1      ifri1.eq.0 .and. ilri1.eq.0 .and. ilws1.eq.0 .and. 
     2                                                numitr1.eq.0) then
            go to 4500
         else
            ifws   = ifws1
            minrng = minrng1
            maxrng = maxrng1
            ifri   = ifri1
            ilri   = ilri1
            ilws   = ilws1
            numitr = numitr1
         endif

      ELSE                    ! *** pick up next cards ***********

      READ(IDSK,497,END=4500) CARD1
497   FORMAT (80A1)
      READ(CARD,500)
     *                         M,        PCRD,     IFWS,
     *                         MINRNG,   MAXRNG,   IFRI,    ILRI,
     *                         ILWS,     NUMITR
  500 FORMAT(
     *                         T1,I1,    A4,  11X, I4,     21X,
     *                         I5,       I5,       I5,     I5,
     *                         I5,       12X, I2 )
 
      CALL WRCARD ( CARD1, 1, IPRNTR )

      ENDIF                   ! **********************************
 
      IF ( IFRI .GT. LILRI ) GO TO 700
      NIFRI = LILRI + 1
      WRITE(IPRNTR,600) NIFRI
  600 FORMAT(/13X,'** M4000 ** WARNING FROM SUBROUTINE RDPICK:',
     *       /25X,'THE FIRST RECORD TO PROCESS ON A SUBSEQUENT',
     *       /25X,'1PICK CARD IS LESS THAN OR EQUAL TO THE LAST',
     *       /25X,'RECORD TO PROCESS SPECIFIED ON THE PREVIOUS',
     *       /25X,'1PICK CARD.  THE FIRST RECORD TO PROCESS WILL',
     *       /25X,'BE RESET TO ',I5,' WHICH IS ONE GREATER THAN',
     *       /25X,'THE LAST RECORD TO PROCESS ON THE PREVIOUS CARD.',/)
      IFRI = NIFRI
C
C---- IF IFWS IS NOT SPECIFIED AND ILWS WAS SPECIFIED
C---- ON THE PREVIOUS CARD, DEFAULT IFWS TO ILWS
C---- IF IFRI IS ONE GREATER THAN ILRI FROM THE PREVIOUS CARD
C---- AND IFWS IS EQUAL TO THE PREVIOUS ILWS, SET THE REBILD
C---- FLAG SO THE REFERENCE TRACE WILL NOT BE REBUILT.
  700 IF ( IFWS .EQ. 0
     *          .AND. LILWS .NE. 0 ) IFWS = LILWS
      IF ( ( IFRI .NE. ( LILRI + 1 )
     *            .OR. IFWS .NE. LILWS )
     *            .AND. ( .NOT. REFIN ) ) REBILD = .TRUE.
      IF ( ( REBILD )
     *       .AND. ICRDNO .NE. 0
     *           .AND. ( .NOT. REFIN ) )
     *     WRITE(IPRNTR,800) IFRI
  800      FORMAT(/,  ' ** M4100 ** MESSAGE FROM SUBROUTINE RDPICK:',
     *             2X, 'REFERENCE TRACE WILL BE REBUILT ',
     *                 'STARTING WITH RECORD ',I5,'.',/)
C
      IFWS = IFWS - ITFS
      IF ( IFWS .LE. 0 )  IFWS = IABS(MINLAG)
      WEND = ( LWNDW - 1 ) * MSI + IFWS
C
      IF ( ITFS .EQ. 0 ) GO TO 900
      IFWS = IFWS + ITFS
      WEND = WEND + ITFS
C
  900 IF ( CPICK .EQ. PCRD
     *           .AND. M .EQ. 1 ) GO TO 1100
      WRITE(IPRNTR,1000)
 1000 FORMAT(/13X,'** M4200 ** WARNING ISSUED BY SUBROUTINE RDPICK:',
     *       /25X,'CARD MNEMONIC (CC 1-5) OF THE INPUT PARAMETER',
     *       /25X,'CARD IS NOT SPECIFIED AS 1PICK.',/)
C
C---- DEFAULT IF NEEDED...
 1100 IF ( PRCNT .EQ. 0 ) PRCNT = 100
C
      IF ( MINLAG .EQ. 0 ) MINLAG = -120
      IF ( MAXLAG .EQ. 0 ) MAXLAG = 120
C
C---- CORRECT FOR TIME OF FIRST SAMPLE...
      IF ( ITFS .EQ. 0 ) GO TO 1200
      IFWS = IFWS - ITFS
      WEND = WEND - ITFS
      IF ( ILWS .GT. 0 ) ILWS = ILWS - ITFS
      NSTFS = ( WEND - IFWS ) / MSI  + 1
C
 1200 IF ( IFWS .LE. 0 ) IFWS = IABS(MINLAG)
      NS = NSAMPS
      IF ( ITFS .NE. 0 ) NS = NSTFS
C
C---- SET WINDOW END DEFAULT USING MAXSMP OF 3000
      IF ( WEND .GT. 0 ) GO TO 1300
           IWET = ( NS - 1 ) * MSI - ( 2 * MAXLAG )
           WEND = IFWS + ( 3000 - 1 ) * MSI
           IF ( IWET .LT. WEND ) WEND = IWET
C
C---- SET SMALL LAG WINDOW PARMS IF NEEDED...
 1300 IF ( ISWMIN .EQ. 0 )   ISWMIN = -16
      IF ( ISWMAX .EQ. 0 )   ISWMAX = 16
C
      IF ( FOLD .LT. 1 ) FOLD = JFOLD
      IF ( FOLD .GE. 3
     *         .AND. FOLD .LE. 512 ) GO TO 1500
      WRITE(IPRNTR,1400)
 1400 FORMAT(/13X,'** M4300 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE FOLD PARAMETER MUST BE GREATER THAN OR EQUAL',
     *       /25X,'TO 3 AND LESS THAN OR EQUAL TO 512.  THIS ENTRY',
     *       /25X,'SPECIFIES THE NUMBER OF LIVE TRACES PER CDP',
     *       /25X,'REMAINING AFTER ANY RANGE LIMITING.',/)
      ICCODE = 100
C
 1500 IF ( LW .LE. 0 ) LW = ( 3 * ( ISWMAX - ISWMIN ) / MSI + 1 )
C
      IF ( MAXRNG .EQ. 0 ) MAXRNG = 99999
C
      IF ( ILRI .NE. 0
     *          .OR. ILWS .EQ. 0
     *                    .OR. ILWS .EQ. IFWS ) GO TO 1700
      WRITE(IPRNTR,1600)
 1600 FORMAT(/13X,'** M4400 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE LAST RECORD NUMBER TO PROCESS CANNOT BE',
     *       /25X,'DEFAULTED IF A WINDOW START TIME FOR THIS LAST',
     *       /25X,'RECORD IS GIVEN.',/)
      ICCODE = 100
C
 1700 IF ( NUMITR .EQ. 0 )  NUMITR = ( FOLD / 2 ) + 3
      IF ( NUMITR .GT. 25 ) NUMITR = 25
C
C---- DISPLAY PROCESSING PARAMETERS...
      ICRDNO = ICRDNO + 1
      ILWSPR = ILWS
      IF ( ILWS .EQ. 0 ) ILWSPR = IFWS
      IF ( IFRI .EQ. 0 ) IFRI   = 1
      IF ( ILRI .EQ. 0 ) ILRI   = 99999
C
      WRITE(IPRNTR,1800) ICRDNO
 1800 FORMAT(////33X,'***** PROCESSING PARAMETERS FROM ',
     *               'CARD NUMBER ',I2,' *****')
C
      WRITE(IPRNTR,1900) MINLAG, MINRNG, MAXLAG, MAXRNG
 1900 FORMAT(//13X,'LARGE LAG WINDOW:                       ',5X,
     *          9X,'RANGE LIMITS:                           ',
     *        /13X,'  MINIMUM LAG (MS)......................',I5,
     *          9X,'  MINIMUM (FT OR M).....................',I5,
     *        /13X,'  MAXIMUM LAG (MS)......................',I5,
     *          9X,'  MAXIMUM (FT OR M).....................',I5   )
C
      WRITE(IPRNTR,2000) IFRI, IFWS, WEND, ILRI, FOLD, ILWSPR
 2000 FORMAT( /13X,'TRACE WINDOW LENGTH:                    ',5X,
     *          9X,'FIRST RECORD NUMBER TO PROCESS..........',I5,
     *        /13X,'  START TIME (MS).......................',I5,
     *        /13X,'  END   TIME (MS).......................',I5,
     *          9X,'LAST RECORD NUMBER TO PROCESS...........',I5,
     *       //13X,'FOLD....................................',I5,
     *          9X,'WINDOW START TIME FOR LAST RECORD.......',I5   )
C
      WRITE(IPRNTR,2100) LW, EXPAND, PRCNT, ISWMIN, ISWMAX, NUMITR,
     *                   ITFS, IREFTR
 2100 FORMAT( /13X,'SMOOTHING WINDOW LENGTH (SAMPLES).......',I5,
     *          9X,'PRINT FLAG..............................',I5,
     *       //13X,'SMALL LAG WINDOW:                       ',5X,
     *          9X,'PERCENT BAD PICKS.......................',I5,
     *        /13X,'  MINIMUM LAG (MS)......................',I5,
     *        /13X,'  MAXIMUM LAG (MS)......................',I5,
     *          9X,'NUMBER OF ITERATIONS....................',I5,
     *       //13X,'TIME OF FIRST SAMPLE (MS)...............',I5,
     *          9X,'OPTIONAL REFERENCE TRACE INPUT..........',I5,
     *        /67X,'  0 = NO                                ',
     *        /67X,'  1 = YES                               ',//)
C
      IF ( ILWS .EQ. IFWS ) ILWS = 0
C
C---- DO SOME ERROR CHECKING ON PARMS...
      IF ( ISWMIN .GE. MINLAG ) GO TO 2300
      WRITE(IPRNTR,2200)
 2200 FORMAT(/13X,'** M4500 ** WARNING FROM SUBROUTINE RDPICK:',
     *       /25X,'THE SMALL LAG WINDOW MINIMUM LAG IS SMALLER',
     *       /25X,'THAN THE LARGE LAG WINDOW MINIMUM LAG.  THE LARGE',
     *       /25X,'LAG WINDOW MUST CONTAIN THE SMALL LAG WINDOW.',
     *       /25X,'THEREFORE, THE SMALL LAG HAS BEEN RESET TO THE',
     *       /25X,'LARGE LAG VALUE.',/)
      ISWMIN = MINLAG
C
 2300 ICHECK = ( NSAMPS - 1 ) * MSI - 2 * MAXLAG
      IF ( WEND .LE. ICHECK ) GO TO 2500
      WEND = ICHECK
      WRITE(IPRNTR,2400) WEND
 2400 FORMAT(/13X,'** M4600 ** WARNING FROM SUBROUTINE RDPICK:',
     *      /25X,'THE CORRELATION WINDOW END TIME EXCEEDS THE TRACE',
     *      /25X,'LENGTH LESS TWICE THE LARGE LAG WINDOW MAXIMUM LAG,',
     *      /25X,'THEREFORE THE CORRELATION WINDOW END TIME HAS BEEN',
     *      /25X,'RESET TO THIS NEW TIME.  THE NEW END TIME IS ',I5,
     *      /25X,' MS.',/)
C
 2500 IF ( ISWMAX .LE. MAXLAG ) GO TO 2700
      WRITE(IPRNTR,2600)
 2600 FORMAT(/13X,'** M4700 ** WARNING FROM SUBROUTINE RDPICK:',
     *      /25X,'THE SMALL LAG WINDOW MAXIMUM LAG IS GREATER THAN',
     *      /25X,'THE LARGE LAG WINDOW MAXIMUM LAG.  THE LARGE LAG',
     *      /25X,'WINDOW MUST CONTAIN THE SMALL LAG WINDOW, THEREFORE',
     *      /25X,'THE SMALL WINDOW MAXIMUM LAG HAS BEEN RESET TO THE',
     *      /25X,'LARGE WINDOW MAXIMUM LAG VALUE.',/)
      ISWMAX = MAXLAG
C
 2700 IF ( WEND .GT. IFWS ) GO TO 3200
      WRITE(IPRNTR,3100)
 3100 FORMAT(/13X,'** M4900 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE TRACE WINDOW END TIME IS LESS THAN THE TRACE',
     *       /25X,'WINDOW START TIME.',/)
      ICCODE = 100
C
 3200 IWSCHK = IFWS / MSI + 1
      IF ( IWSCHK .GE. 1
     *            .AND. IWSCHK .LE. NSAMPS ) GO TO 3400
      WRITE(IPRNTR,3300)
 3300 FORMAT(/13X,'** M5000 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE TRACE WINDOW START TIME IS OUTSIDE THE LIMITS',
     *       /25X,'OF THE TRACE.  EITHER THE START TIME IS LESS',
     *       /25X,'THAN ZERO OR EXCEEDS THE TRACE LENGTH.',/)
      ICCODE = 100
C
 3400 IWECHK = WEND / MSI + 1
      IF ( IWECHK .GE. 1
     *            .AND. IWECHK .LE. NSAMPS ) GO TO 3600
      WRITE(IPRNTR,3500)
 3500 FORMAT(/13X,'** M5100 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE TRACE WINDOW END TIME IS OUTSIDE THE LIMITS',
     *       /25X,'OF THE TRACE.   EITHER THE END TIME IS LESS',
     *       /25X,'THAN ZERO OR EXCEEDS THE TRACE LENGTH.',/)
      ICCODE = 100
C
 3600 IF ( ( IWECHK - IWSCHK ) .LE. 3000 ) GO TO 3800
      WEND = ( ( 3000 + IWSCHK ) - 1 ) * MSI
      WRITE(IPRNTR,3700) WEND
 3700 FORMAT(/13X,'** M5200 ** WARNING FROM SUBROUTINE RDPICK:',
     *       /25X,'THE TRACE WINDOW LENGTH EXCEEDS THE PROGRAM ',
     *       /25X,'LIMIT OF 3000 SAMPLES.  THE TRACE WINDOW END TIME',
     *       /25X,'HAS BEEN RESET TO ',I5,' MS SO THAT THE WINDOW',
     *       /25X,'LENGTH WILL CONFORM TO PROGRAM RESTRICTIONS.',/)
C
 3800 IF ( MINLAG .LT. MAXLAG ) GO TO 4000
      WRITE(IPRNTR,3900)
 3900 FORMAT(/13X,'** M5300 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE LARGE LAG WINDOW MINIMUM LAG IS NOT LESS THAN',
     *       /25X,'THE LARGE LAG WINDOW MAXIMUM LAG.  THIS IMPLIES',
     *       /25X,'AN END TIME PRECEDING A START TIME.',/)
      ICCODE = 100
C
 4000 IF ( ISWMIN .LT. ISWMAX ) GO TO 4200
      WRITE(IPRNTR,4100)
 4100 FORMAT(/13X,'** M5400 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE SMALL LAG WINDOW MINIMUM LAG IS NOT LESS THAN',
     *       /25X,'THE SMALL LAG WINDOW MAXIMUM LAG.  THIS IMPLIES',
     *       /25X,'AN END TIME PRECEDING A START TIME.',/)
      ICCODE = 100
C
 4200 IWSSND = ( IFWS + MINLAG ) / MSI + 1
      IF ( IWSSND .GT. 0 ) GO TO 4400
      WRITE(IPRNTR,4300)
 4300 FORMAT(/13X,'** M5500 ** ERROR DETECTED BY SUBROUTINE RDPICK:',
     *       /25X,'THE ADJUSTED WINDOW START TIME IS LESS THAN ZERO.'/,
     *       /25X,'VERIFY THAT THE LARGE LAG WINDOW MINIMUM LAG,',
     *       /25X,'WHEN ADDED TO THE WINDOW START TIME IS NOT LESS',
     *       /25X,'THAN ZERO.',/)
      ICCODE = 100
C
 4400 IF ( ICCODE .EQ. 100 ) CALL CCEXIT ( 100 )
      RETURN
C
 4500 CONTINUE
      IEOF = 1
      RETURN
      END
C
