C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/03/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/03/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      HELP            -                                               *
C      CMDLN           -                                               *
C      GETFLE          -                                               *
C      SWAP            -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MAX     GENERIC -                                               *
C      MOD     GENERIC -                                               *
C      ABS     GENERIC -                                               *
C      MIN     GENERIC -                                               *
C  FILES:                                                              *
C      6             ( OUTPUT SEQUENTIAL ) -                           *
C      CARD1(32:33)  ( OUTPUT INTERNAL   ) -                           *
C      CARD1(35:37)  ( OUTPUT INTERNAL   ) -                           *
C      CARD1(41:45)  ( OUTPUT INTERNAL   ) -                           *
C      CARD1(46:50)  ( OUTPUT INTERNAL   ) -                           *
C      CARD1(56:56)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(11:15)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(16:20)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(16:25)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(21:25)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(26:28)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(29:33)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(29:34)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(34:38)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(39:41)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(49:53)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(54:58)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(59:63)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(64:68)  ( OUTPUT INTERNAL   ) -                           *
C      CARD2(6:10)   ( OUTPUT INTERNAL   ) -                           *
C      LUIREC        ( INPUT  SEQUENTIAL ) -                           *
C      LUOREC        ( OUTPUT SEQUENTIAL ) -                           *
C      RECORD        ( INPUT  INTERNAL   ) -                           *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 7) -                                                 *
C      100      ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      statement out of order :      INTEGER NSEGS(200),ARGIS          *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      character record*80,card1*80,card2*80,blnk80*80
      character blnks(80)*1, order*1
      character nfile*100,ofile*100
      real   recunit,trcunit,timeunit
      real   datarec(200,10),datatrc(200,10),time(200,10)
      real   mint,maxt,mstrc
      logical verbose,query
      equivalence (blnk80,blnks(1))
      data blnks/80*' '/,ierr/0/
      integer nsegs(200),argis
      ofile(1:1)=' '
      luirec=11
      luorec=12
       if(ier.ne.0)then
         write(6,'(a)')'  error returning cwd '
       endif
c     nfile = 'x'
c     ofile = 'x'
C     +--------------------------------+
c     |   check command line to see if |
c     |   help requested.  if so, print|
c     |   the help and quit.           |
C     +--------------------------------+
       query=(argis('-?').gt.0)
       if(query) then
         call help(ipr)
         stop
       endif
       query=(argis('-H').gt.0)
       if(query) then
         call help(ipr)
         stop
       endif
      call cmdln(nfile,ofile,verbose,isi,order,irbias)
c     if(nfile.eq.'x'.or.ofile.eq.'x')stop 100
      if(isi.eq.0)isi=1
      si=isi
      sfact=1.
      write(LER,'(a,i4)')'  si returned is ',isi
      write(LER,'(a,i4)')'  record bias is ',irbias
      call getfle(nfile,luirec,ofile,luorec)
      read(luirec,'(a)',end=500)record
c  expect a "units" record first
      if(record(1:5).eq.'Units')then
         read(record,'(9x,f9.0,2(4x,f9.0))')recunit,trcunit,timeunit
         sfact=si/timeunit
      else
         write(LER,'(a)')'  Expected a units record but none found.'
         write(LER,'(a)')'  ******* Job abended **********'
         stop
      endif
c  expect to read "Segment" records now
      nseg=0
  100 continue
      read(luirec,'(a)',end=500)record
      if(record(1:5).ne.'     ')then
        if(record(1:5).eq.'Segme')then
            nseg=nseg+1
            irec=0
            go to 100
         endif
         irec=irec+1
         nsegs(nseg)=nsegs(nseg)+1
         read(record,'(f12.0,2(1x,f12.0))')datarec(nseg,irec),
     *                            datatrc(nseg,irec),time(nseg,irec)
c  Check the digitizing order and swap trace and record numbers if
c  data digitized in trace order.
      if(order.eq.'t')then
         call swap(datarec(nseg,irec),datatrc(nseg,irec))
      endif
         datarec(nseg,irec) = datarec(nseg,irec) + irbias
         time(nseg,irec)=time(nseg,irec)*sfact
         go to 100
      endif
  500 continue
      isegerr=0
      if(mod(nseg,3).ne.0)then
       write(LER,'(a)')'  Segments must be in sets of 3 '
       write(LER,'(a)')'  ****** Job abended ********* '
       stop
      endif
       do  9 i=1,nseg
          if(nsegs(i).gt.2.and.mod(i,3).ne.0)isegerr=1
    9  continue
      if(nseg.eq.0)go to 600
      if(verbose)then
       write(LER,'(a,i5,a)')'  found ',nseg,' segments consisting of '
       do 10 i=1,nseg-1
          write(LER,'(5x,i5)')nsegs(i)
   10  continue
       write(LER,'(a)')'  and '
       write(LER,'(5x,i5,/,a)')nsegs(nseg),' picks.   '
      endif
      if(isegerr.eq.1)then
       write(LER,'(3x,a)')'  Error found in temporal/spatial segments.'
       write(LER,'(3x,a)')'  Must have 2 and only 2 picks per segment.'
       write(LER,'(3x,a)')'  Re-digitize or edit the input file.'
       write(LER,'(3x,a)')'  ****** Job abended ********* '
       stop
      endif
c Sort each segment into order of increasing record number.
      do 20 i=1,nseg
        if(datarec(i,1).gt.datarec(i,2).and.mod(i,3).ne.0)then
              call swap(datatrc(i,1),datatrc(i,2))
              call swap(datarec(i,1),datarec(i,2))
              call swap(time(i,1),time(i,2))
          endif
   20 continue
c  Take care of some DIPF limitations:
c    - make sure record numbers are within bounds required by DIPF
c    - make sure filtered zones are contiguous when digitized
c      record numbers are within 5 of each other.
c    - make sure filtered zones are at least 26 records wide.
      do 22 i=4,nseg,3
       sdif=datarec(i,1)-datarec(i-3,2)
       if(sdif.le.5.0)then
         datarec(i,1)=datarec(i-3,2)+1
       endif
   22 continue
      do 24 i=2,nseg,3
       if(mod(i,3).ne.2)go to 24
       if(datarec(i,2).gt.datarec(i-1,2))then
         datarec(i,2)=datarec(i-1,2)
       endif
       if(datarec(i,1).lt.datarec(i-1,1))then
         datarec(i,1)=datarec(i-1,1)
       endif
   24 continue
c Now build and write the DIPF cards
      ione=0
      ithree=3
      do 30 i=1,nseg,3
      card1=blnk80
      card2=blnk80
      card1(1:5)='1DIPF'
      card2(1:5)='2DIPF'
      card1(67:69)='N11'
      nchan=25
      npts=257
      write(card1(32:33),'(i2)')nchan
      write(card1(35:37),'(i3)')npts
      write(card1(56:56),'(i1)')ione
      isrec1=datarec(i,1)
      ierec1=datarec(i,2)
      isrec2=datarec(i+1,1)
      ierec2=datarec(i+1,2)
      if(i.gt.3.and.datarec(i,1).le.datarec(i-3,2)+5.)then
        isrec1=datarec(i-3,2)+1
      endif
      write(card1(41:45),'(i5)')isrec1
      write(card1(46:50),'(i5)')ierec1
      write(card2(49:53),'(i5)')isrec2
      write(card2(54:58),'(i5)')ierec2
      ist1=time(i,1)
      iet1=time(i+1,1)
      ist2=time(i,2)
      iet2=time(i+1,2)
      write(card2(6:10),'(i5)')ist1
      write(card2(11:15),'(i5)')iet1
      write(card2(59:63),'(i5)')ist2
      write(card2(64:68),'(i5)')iet2
      if(nsegs(i+2).eq.2)then
       mstrc=(time(i+2,2)-time(i+2,1))/(datarec(i+2,2)-datarec(i+2,1))
       mint=abs(mstrc)-.25
       maxt=abs(mstrc)+.25
       write(LER,'(f7.2)')mint
       write(6,'(f7.2)')maxt
       if(mstrc.ge.0.)then
          write(card2(16:25),'(2f5.2)')mint,maxt
          write(card2(26:28),'(i3)')ithree
       else
          if(abs(mint).lt.10)then
             write(card2(29:33),'(f5.2)')mint
          else
             write(card2(29:33),'(f5.1)')mint
          endif
          if(abs(maxt).lt.10)then
             write(card2(34:38),'(f5.2)')maxt
          else
             write(card2(34:38),'(f5.1)')maxt
          endif
          write(card2(39:41),'(i3)')ithree
       endif
      else
       t1=time(i+2,2)-time(i+2,1)
       tr1=datarec(i+2,2)-datarec(i+2,1)
       tmint=t1/tr1
       t2=time(i+2,2)-time(i+2,3)
       tr2=datarec(i+2,2)-datarec(i+2,3)
       tmaxt=t2/tr2
       mint=min(abs(tmint),abs(tmaxt))
       maxt=max(abs(tmint),abs(tmaxt))
       write(LER,'(f7.2)')mint
       write(LER,'(f7.2)')maxt
       if(tmint.ge.0.0.and.tmaxt.ge.0.0)then
         write(card2(16:25),'(2f5.2)')mint,maxt
         write(card2(26:28),'(i3)')ithree
       endif
       if(tmint.lt.0.0.and.tmaxt.le.0.0)then
          write(card2(29:33),'(f5.2)')mint
          if(abs(maxt).lt.10)then
             write(card2(34:38),'(f5.2)')maxt
          else
             write(card2(34:38),'(f5.1)')maxt
          endif
          write(card2(39:41),'(i3)')ithree
       endif
       if(tmint.lt.0.0.and.tmaxt.ge.0.0)then
          if(abs(tmint).lt.10)then
             write(card2(16:20),'(f5.2)')tmint
          else
             write(card2(16:20),'(f5.1)')tmint
          endif
          write(card2(21:25),'(f5.2)')tmaxt
          write(card2(26:28),'(i3)')ithree
       endif
          if(tmint.ge.0.0.and.tmaxt.lt.0.0)then
              tmint=tmint*(-1.)
              tmaxt=tmaxt*(-1.)
              if(abs(tmint).lt.10)then
                 write(card2(29:34),'(f5.2)')tmint
              else
                 write(card2(29:34),'(f5.1)')tmint
              endif
              write(card2(34:38),'(f5.2)')tmaxt
              write(card2(39:41),'(i3)')ithree
          endif
      endif
      write(luorec,'(a80)')card1
      write(luorec,'(a80)')card2
   30 continue
      stop
  600 continue
      write(LER,*)'       Errors detected. '
      write(LER,*)'     *** Job abended ***'
      stop
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CMDLN                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CMDLN  (NFILE,OFILE,VERBOS,ISI,ORDER,IRBIAS)                    *
C  ARGUMENTS:                                                          *
C      NFILE   CHAR*(*)  ??IOU* -                                      *
C      OFILE   CHAR*(*)  ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C      ISI     INTEGER   ??IOU* -                                      *
C      ORDER   CHAR*1    ??IOU* -                                      *
C      IRBIAS  INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/03/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/03/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR          -                                               *
C      ARGIS   INTEGER -                                               *
C      IARGF           -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE cmdln( NFILE, OFILE,  VERBOS,isi,order,irbias)
c     INCLUDE 'IOUNIT.INC'

#include <f77/iounit.h>

c-------
c     nfile    C*100 - INPUT DATA SET NAME
c     ofile    C*100 - OUTPUT DATA SET NAME
c    VERBOS   L     - VERBOS PRINTOUT
c-------
      CHARACTER  NFILE*(*), Ofile*(*),v*1
      character order*1
      INTEGER    ARGIS
      LOGICAL    VERBOS
 
        CALL ARGSTR('-N',NFILE, ' ', ' ')
        CALL ARGSTR('-O',OFILE, ' ', ' ')
        VERBOS = ( ARGIS('-V') .GT. 0 )
         v='1'
        verbos = (argis('-V').gt.0)
c       call iargf('-s',si)
        call argr4 ('-s',si,0.,0.)
        isi=si
        order = 't'
        call argstr('-o',order,' ',' ')
        if(order.ne.'r')order = 't'
c       rbias = 0
c       call iargf('-b',rbias)
        call argr4 ('-b',rbias,0.0,0.0)
        irbias = rbias
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SWAP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SWAP  (X,Y)                                                     *
C  ARGUMENTS:                                                          *
C      X       REAL  ??IOU* -                                          *
C      Y       REAL  ??IOU* -                                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/03/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/03/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine swap(x,y)
          hold=x
          x=y
          y=hold
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GETFLE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GETFLE  (NFILE,LUIREC,OFILE,LUOREC)                             *
C  ARGUMENTS:                                                          *
C      NFILE   CHAR*(*)  ??IOU* -                                      *
C      LUIREC  INTEGER   ??IOU* -                                      *
C      OFILE   CHAR*(*)  ??IOU* -                                      *
C      LUOREC  INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/03/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/03/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LNBLNK  INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      6  ( OUTPUT SEQUENTIAL ) -                                      *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 4) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine getfle(nfile,luirec,ofile,luorec)

#include <f77/iounit.h>

      character nfile*(*),ofile*(*)
      integer luirec,luorec
      logical ok, there
c
      IF (nfile(1:1) .ne. ' ') THEN
         inquire(file=nfile,exist=there)
         if(.not.there)then
            write(LER,*)'   Requested input file does not exist.'
            write(LER,*)'   Restart with correct input file name.'
            stop
          endif
         open(unit=luirec,file=nfile,status='old')
         inquire(unit=luirec,opened=ok)
         if(.not.ok)then
          write(LER,*)' Unable to open input file.'
          stop
         endif

      ELSE
         luirec = LIN
      ENDIF

      IF (ofile(1:1) .ne. ' ') THEN

         inquire(file=ofile,exist=there)
         last=lenth(ofile)
         if(there)then
           write(6,'(5x,a,a)')ofile(1:last),' already exists.'
           write(6,'(5x,a)')
     *     'Remove the file or select new output file name.'
           stop
         endif
         if(ofile(1:1).ne.' ')then
            open(unit=luorec,file=ofile,status='new')
            inquire(unit=luorec,opened=ok)
            if(.not.ok)then
             write(LER,'(5x,a,a,a)')'Unable to open ',ofile(1:last),
     *       ' for output.'
             write(LER,'(a)')'  ***** Job abended ********'
             stop
            endif
         else
             write(LER,'(a)')'  Output file not defined. '
             write(LER,'(5x,a)')'Restart and define the output file ',
     *   ' with the -O parameter.'
         endif

      ELSE
         luorec = LOT
      ENDIF
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP  (LER)                                                     *
C  ARGUMENTS:                                                          *
C      LER     INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/03/23  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/03/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine help(ler)
          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM pik2dpf.............convert .pik files  '
         write(LER,*)' '
         write(LER,*)
     :' -N [nfile]     (no default)      : Input OPER .pik file'
         write(LER,*)
     :' -O [ofile]     (no default)      : Output DIPF card file'
         write(LER,*)
     :' -V [verbos]    (default=no)      : Verbose output '
         write(LER,*)
     :' -s [si]        (default=1)       : Data sample interval'
         write(LER,*)
     :' -o [order]     (default="t")     : Digitization major order'
         write(LER,*)
     :' -b [bias]      (default=0)       : Record number bias      '
       write(ler,*)' '
       write(ler,*)
     :'The sample interval is used to convert .pik "times" to data'
       write(ler,*)
     :'"times" when the time scale used in OPER was 1.  If the OPER'
       write(ler,*)
     :'picks have the proper time, enter a "1" or use the default.'
       write(ler,*)' '
       write(ler,*)
     :'The digitization major order indicates the order of the data'
       write(ler,*)
     :'digitized in OPER. A "t" means trace number is the most '
       write(ler,*)
     :'rapidly changing index and is used when digitizing offset'
       write(ler,*)
     :'panels.  A "r" means the record number is the most rapidly'
       write(ler,*)
     :'changing index and is used when digitizing other data '
       write(ler,*)
     :'sets, such as stacked data.'
       write(ler,*)
     :'Valid entries are "t" and "r".                             '
       write(ler,*)' '
       write(ler,*)
     :'The record number bias is a positive or negative number'
       write(ler,*)
     :'to be added to input record numbers to compensated for '
       write(ler,*)
     :'record number errors in OPER.                          '
       write(ler,*)' '
       write(LER,*)
     :'Usage:  ',
     :' pik2dpf -N[nfile] -O[ofile] -V -s[si] -o[order] -b[bias]'
       write(LER,*)
     :'***************************************************************'
      return
      end
