C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine appmute ( u, hbegin, nsamp, nz, nbyptr, lenu2,
     1     ntrace, nrec, l_StaCor, l_RecNum, luin, luout, lerr,
     2     w_left, w_right, w_interp, wbuf, pass,
     3     npicks, nsegments, maxpicks, nxtaper, nztaper,
     4     wgt, record, trace, sample, outside,
     5     w_Across, w_Down, verbos, replace, replace_value,
     6     ifmt_RecNum,ln_RecNum,ifmt_StaCor,ln_StaCor, irs, ire)

c variables passed to/from calling routine

      integer    hbegin, nz, nbyptr, lenu2, ntrace, nrec
      integer    nsegments, maxpicks, nxtaper, nztaper
      integer    l_StaCor, l_RecNum, luin, luout, lerr
      integer    npicks(nsegments)

      real       u(hbegin:nsamp,ntrace), pass, replace_value

      real       w_left(ntrace*nz)
      real       w_right(ntrace*nz)
      real       w_interp(ntrace*nz)
      real       w_Across(ntrace*nz)
      real       w_Down(ntrace*nz)

      real       wbuf((ntrace+2*nxtaper)*(nz+2*nztaper))
      real       wgt(-nztaper:+nztaper,-nxtaper:nxtaper)   

      real       record(maxpicks+3,nsegments)
      real       trace(maxpicks+3,nsegments)
      real       sample(maxpicks+3,nsegments)
c      real       record(maxpicks+1,nsegments)
c      real       trace(maxpicks+1,nsegments)
c      real       sample(maxpicks+1,nsegments)

      logical    eod, outside, replace, verbos, sequential

c local varibles

      integer nzmin, nzmax, nxmin, nxmax, irec, irecnum
      integer isegleft, isegright, irs, ire, ircur

      real drec, wgtr, wgtl, recno

c initialize variables

      ircur = 1
      sequential = .false.

c read in first gather to get header information to locate first polygon to
c use in pickfile, old logic assumed that first record would be => first
c polygon.  In practice this is NOT true universally as users are apt to 
c editt data and have a right to expect the mute to be correct in this 
c case.

       call rdgather ( u, u, hbegin, nsamp, lenu2, ntrace, luin, lerr, 
     :        eod, itr, irec, l_StaCor, l_RecNum, irecnum ,
     :        ifmt_RecNum,ln_RecNum,ifmt_StaCor,ln_StaCor)

       if ( irecnum .eq. 0 ) then
          write(LERR,*)'POLYMUTE:'
          write(LERR,*)' RecNum indexing contains zero'
          write(LERR,*)' it will be set to unity on first'
          write(LERR,*)' record and sequential record numbering'
          write(LERR,*)' will be assumed'
          write(LERR,*)'WARNING'
          write(LER,*)' '
          write(LER,*)'POLYMUTE:'
          write(LER,*)' RecNum indexing contains zero'
          write(LER,*)' it will be set to unity on first'
          write(LER,*)' record and sequential record numbering'
          write(LER,*)' will be assumed'
          write(LER,*)'WARNING'
          sequential = .true.
          irecnum = 1
       endif

       recno = float( irecnum )
       ircur = irecnum

       if (verbos) write(lerr,*) 'irec = ',irec,' recno = ',recno
       if (eod) return

c locate polygon and initialize mute weights. 

      isegleft = 1

      IF ( nsegments .eq. 1 ) then

c single segment logic

         isegright = 1
         call bd_winit ( w_left, trace(1,isegleft), sample(1,isegleft),
     :        npicks(isegleft), ntrace, nz, pass, outside,
     :        nzmin, nzmax, nxmin, nxmax, w_Across, w_Down, wbuf)

         call wsmooth ( w_left, wbuf, wgt, nz, nztaper, ntrace, nxtaper,
     :        nzmin, nzmax, nxmin, nxmax )

         call vmov( w_left, 1, w_right, 1, ntrace * nz )

      ELSE 

c multi-segment logic
c determine position of first record wrt pickfile segments

         isegright = 2

         do while ( record(1, isegright) .lt. recno  )
            isegleft = isegleft + 1
            isegright = isegright + 1
         enddo

         call bd_winit ( w_left, trace(1,isegleft), sample(1,isegleft),
     :        npicks(isegleft), ntrace, nz, pass, outside,
     :        nzmin, nzmax, nxmin, nxmax, w_Across, w_Down, wbuf)

         call wsmooth ( w_left, wbuf, wgt, nz, nztaper, ntrace, nxtaper,
     :        nzmin, nzmax, nxmin, nxmax )

         call bd_winit( w_right, trace(1,isegright), sample(1,isegright)
     :        ,npicks(isegright), ntrace, nz, pass, outside,
     :        nzmin, nzmax, nxmin, nxmax, w_Across, w_Down , wbuf)

         call wsmooth ( w_right, wbuf, wgt, nz, nztaper, ntrace, 
     :        nxtaper, nzmin, nzmax, nxmin, nxmax )
      
      ENDIF

c process data

      DO irec = 1, nrec

         IF ( recno .le.  record(1,isegleft) .and. 
     :        isegleft .eq. 1 ) then

c current record lies to the left of the leftmost polygon. 
c no need to interpolate before muting.

            if (verbos) 
     :           write(lerr,*) 'record lies to left of first polygon '
     :           //'defined by segment ',isegleft
            
            if (ircur .ge. irs .AND. ircur .le. ire)
     :      call wmult ( u, hbegin, ntrace, nz, nsamp, w_left,
     :           replace, replace_value )

         ELSEIF( recno .le. record(1,isegleft) ) then

c current record lies to left of current leftmost mute map, assign
c left to right and get a new left mute map before going on

            isegright = isegleft
            isegleft = isegleft - 1
            call vmov ( w_left, 1, w_right, 1, ntrace * nz )

            call bd_winit ( w_left, trace(1,isegleft), 
     :           sample(1,isegleft), npicks(isegleft), ntrace, nz, 
     :           pass, outside, nzmin, nzmax, nxmin, nxmax, w_Across, 
     :           w_Down, wbuf)

            call wsmooth ( w_left, wbuf, wgt, nz, nztaper, ntrace, 
     :           nxtaper, nzmin, nzmax, nxmin, nxmax )

c interpolate before muting.              

            drec = record(1,isegright) - record(1,isegleft)
            wgtr = (recno - record(1,isegleft) ) / drec     
            wgtl = 1.0 - wgtr 
                           
            if (verbos) then
               write(lerr,*) 'record lies in between polygons defined '
     1              //'by segments ',isegleft,isegright        
               write(lerr,*) 'wgtl, wgtr ',wgtl,wgtr
               write(LERR,*)'recr/l= ',record(1,isegright),irec,
     1              record(1,isegleft)
            endif
            
            do j = 1, ntrace * nz
               w_interp(j) = wgtl * w_left(j) + wgtr * w_right(j)
            enddo
            
c mute the gathers

            if (ircur .ge. irs .AND. ircur .le. ire)
     :      call wmult ( u, hbegin, ntrace, nz, nsamp, w_interp,
     :           replace, replace_value )

         ELSEIF ( recno .ge.  record(1,isegright)  .and. 
     :           isegright .eq. nsegments ) then

c current record lies to the right of the rightmost polygon. 
c no need to interpolate before muting.

            if (verbos)
     :           write(lerr,*) 'record lies to right of last'
     :           //' polygon defined by segment ',isegright
            
            if (ircur .ge. irs .AND. ircur .le. ire)
     :      call wmult ( u, hbegin, ntrace, nz, nsamp, w_right,
     :           replace, replace_value )

         ELSE

c current record lies between extremes.

            if ( recno .gt. record(1,isegright) ) then

c current record lies to the right of the current right polygon.
c shift to left. read in the next polygon. calculate weights.  In
c this case we have processed past the initial mute maps and need to
c roll them along

               isegleft = isegright
               call vmov ( w_right, 1, w_left, 1, ntrace * nz )
               isegright = isegleft + 1
               
               call bd_winit ( w_right, trace(1,isegright), 
     :              sample(1,isegright), npicks(isegright), ntrace, nz, 
     :              pass, outside, nzmin, nzmax, nxmin, nxmax, w_Across, 
     :              w_Down, wbuf)

               call wsmooth ( w_right, wbuf, wgt, nz, nztaper, ntrace, 
     :              nxtaper, nzmin, nzmax, nxmin, nxmax )
            endif

c interpolate before muting.              

            drec = record(1,isegright) - record(1,isegleft)
            wgtr = (recno - record(1,isegleft) ) / drec     
            wgtl = 1.0 - wgtr 
                           
            if (verbos) then
               write(lerr,*) 'record lies in between polygons defined '
     1              //'by segments ',isegleft,isegright        
               write(lerr,*) 'wgtl, wgtr ',wgtl,wgtr
               write(LERR,*)'recr/l= ',record(1,isegright),irec,
     1              record(1,isegleft)
            endif
            
            do j = 1, ntrace * nz
               w_interp(j) = wgtl * w_left(j) + wgtr * w_right(j)
            enddo
            
c mute the gathers

            if (ircur .ge. irs .AND. ircur .le. ire)
     :      call wmult ( u, hbegin, ntrace, nz, nsamp, w_interp,
     :           replace, replace_value )
         ENDIF

c write out muted gathers.

         call wrgather ( u, hbegin, nsamp, ntrace, luout, nbyptr )

c read next record and apply mutes according to the RecNum in the trace headers

         if ( irec .lt. nrec ) then
            call rdgather ( u, u, hbegin, nsamp, lenu2, ntrace, luin, 
     :           lerr, eod, itr, irec, l_StaCor, l_RecNum, irecnum ,
     :           ifmt_RecNum,ln_RecNum,ifmt_StaCor,ln_StaCor)
            
            if ( sequential ) then
               irecnum = irec + 1
            else
               if (  irecnum .eq. 0 ) then
                  write(LERR,*)' RecNum indexing has suddenly become'
                  write(LERR,*)' zero valued at sequential record ',irec
                  write(LERR,*)' Fix your indexing and try again'
                  write(LERR,*)'FATAL'

                  write(LER,*)' '
                  write(LER,*)'POLYMUTE: '
                  write(LER,*)' RecNum indexing has suddenly become'
                  write(LER,*)' zero valued at sequential record ',irec
                  write(LER,*)' Fix your indexing and try again'
                  write(LER,*)'FATAL'
                  write(LER,*)' '
                  stop
               endif
            endif
            
            recno = float( irecnum )
            ircur = irecnum

            if (verbos) write(lerr,*) 'irec = ',irec,' recno = ',recno
            if (eod) return
         endif

      ENDDO
      
      return
      end
