C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************polymute***************************************C
c
c updates:
c
c     Jan 28, 2003...Garossino
c
c     Added -partial option to allow multi-valued mute picks to be
c     completed into polygons for muting.  This allows the user to pick
c     a standard mute as might be used for bdmute, except that the mute
c     can double back on itself as many times as required to get around
c     salt features etc.  The routine will take the last pick and extend
c     to the bottom of the record, then across the bottom to the first pick
c     trace then up to the first pick.  I also added a policeman to 
c     watch for the header entry controlling the pick being full of zeroes
c     as this will cause a segmentation fault on the sgis.  Also fixed a 
c     bug in the sorting routine that resulted in extra picks being
c     left in place if pick functions of disparate lengths were swapped
c     during the sort.  Also added code to default to sequential 
c     numbering if no indexing is found in RecNum.
c
c     Dec 20, 2001...Whitmore
c
c     Moved the location of the argis(-replace) to before -re[] to allow
c     for parsing correctly.
c     In the main, forced pass = 0.0 when using replace
c     In bd_winit, changed the vfills to fill arrays with zero instead
c     of pass - to make all of the polygon logic to work on all platforms.

c     Feb 2, 99...Garossino
c      Added -replace -value to allow the user to replace amplitudes
c      in the full mute zone with a user defined amplitude.  This was
c      done for Doug Whitman of Online3D to aid in using subvolume
c      voxel detection to pick faults in core data.
c
c     Mar 15, 95...Garossino
c
c      fixed bug appmute.F which did not handle datasets not corresponding
c      exactly to pickfile limits.  Routine now goes forward, backward
c      upside down etc. always locating itself in the pickfile for the
c      current recno.
c
c     Mar 14, 95...Garossino
c
c      fixed bug in bd_winit.F which did not clear the across and down
c      arrays on entry
c =====================================================================
c routine to mute polygonal shapes from input data.  interpolation of 
c shapes done between records.
c

c USP include files

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c declare variables

      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      integer     argis
      integer     nrc, ntrc, nsmp, nsegments, maxpicks
      integer     nrec, nsamp, ntrace, nsi, irs, ire
      integer     lenhed, hbegin, lenu2, nbyptr
      integer     l_free, lenu, lenbuf, lbyte, lbyout
      integer     luin, luout, lupick
      integer     lens, ierrcd
      integer     nxtaper, nztaper, nz
      integer     l_stacor, l_trcnum, l_recnum, l_u, l_npicks, l_segnum
      integer     l_segcolor, l_trace, l_record, l_sample, l_temp, l_wgt
      integer     l_w_interp, l_w_left, l_w_right, l_wbuf, l_w_Across
      integer     l_w_Down

      integer     sheader(SZLNHD)

      real dtmsec, dt, recunit, trcunit, smpunit, recoff, trcoff, smpoff
      real pass, reject, replace_value

      character*255 ntap, otap, pickfile
      character*256 card
      character*100 segname        
      character*8 name
      character*2 domain
      character   cdum1*5, cdum2*6, cdum3*5

      logical     outside, replace, force, multivalue, verbos 

c initialize variables
 
      data name/'POLYMUTE'/                                 
      data lupick/21/
      data force/.false./

c get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help ()
         call exit(0)
      endif

c open printout file

#include <f77/open.h>

c get command line parameters

      call cmdln ( ntap, otap, pickfile, nztaper, nxtaper, reject, 
     :     outside, force, replace, replace_value, verbos, irs, ire,
     :     multivalue )

c Dan Whitmore: warning! - if you are expecting a hard zero when 
c     reject is 100%, this may not work 
c     (e.g. in linux, on a Pentium with the Absoft compiler)

      reject = 0.01 * reject
      pass = 1.0 - reject

c Dan Whitmore: set pass = 0.0 , if replacing - because setting reject to 
c     100% and then setting the replace value may not work in linux.

      if (replace ) pass = 0.0 

c open input datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

      lbytes = 0
      call rtape ( luin, sheader, lbyte )
      lbytes = lbyte
      if ( lbytes .eq. 0 ) then
         write(LERR,*)'POLYMUTE: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         call exit(666)
      endif

      call hlhprt( sheader, lbyte, name, len(name), lerr )

c read off relevant arguments from line header

      call saver ( sheader, 'NumRec' ,nrec, LINEHEADER )
      call saver ( sheader, 'NumSmp' ,nsamp, LINEHEADER )
      call saver ( sheader, 'NumTrc' ,ntrace, LINEHEADER )
      call saver ( sheader, 'SmpInt' ,nsi, LINEHEADER )
      call saver ( sheader, 'DgTrkS' ,domain, LINEHEADER )
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif

      lenhed=ITRWRD
      hbegin=1-lenhed

c---
c  guarantee the default processing limits encompass any reasonable
c  range of rec numbers
c---
      if (irs .eq. 0) irs = -2000000000
      if (ire .eq. 0) ire = +2000000000

c look for special transform domains stored in line header or if force
c is set on the command line.  If it is then mute the whole record.  If 
c not and fk is true then only allow mute in the amplitude portion of the
c record. force is there to allow muting of 3D (Kx,Ky,Omega) volumes
c output by fft3da | ttds3d

      if ( force ) then

c arbitrary 2D muting (eg, tau-p).                             

         nz=nsamp
      elseif ( domain .eq. 'fk' .or. domain .eq. 'kk' ) then

c apply mutes only to amplitude component of the spectra. 

         nz=nsamp/2
      else

c arbitrary 2D muting (eg, tau-p).                             

         nz=nsamp
      endif

c check to see if samp int is in micro secs

      dt = unitsc * float( nsi )

      dtmsec = 1000 * dt

c save number of traces into original number of traces slot in line header

      call saver ( sheader, 'OrNTRC', ntr, 0 )

c open up the pick file and read them in.

      if ( pickfile .eq. ' ' ) then

         write(LERR,*)' '
         write(lerr,*)'No pickfile entered on command line'
         write(LERR,*)'FATAL '
         write(LER,*)' '
         write(LER,*)'POLYMUTE: '
         write(ler,*)' No pickfile entered on command line'
         write(LER,*)'FATAL '
         stop
      else
         open ( lupick, file = pickfile, status = 'old', err = 99001 )  
      endif

c---
c  alternate read of xsd pick hdr line: first just read characters and then
c  use fsscnf to parse for variables
c---
      rewind (lupick)
      read(lupick,'(a256)') card
      lc = lenth(card)

c     read(lupick,100) recunit, trcunit, smpunit, nrc, ntrc, nsmp, 
c    :     recoff, trcoff, smpoff, nsegments, maxpicks
c100   format( 6x, f12.6, 1x, f12.6, 1x, f12.6, i6, i6, i6, 
c     :7x, f12.6, 1x, f12.6, 1x, f12.6, 8x, i5, 1x, i5 )

      call fsscnf (card,'%s,%f,%f,%f,%d,%d,%d,%s,%f,%f,%f,%s,%d,%d',
     :      cdum1,recunit, trcunit, smpunit, nrc, ntrc, nsmp, cdum2,
     :      recoff, trcoff, smpoff, cdum3, nsegments, maxpicks )

      if ( nsegments .le. 0 .or. maxpicks .le. 0 ) then
         write(lerr,*) 'error in pick file!'
         write(lerr,*) 'nsegments = ',nsegments
         write(lerr,*) 'maxpicks  = ',maxpicks 
         write(lerr,*) 'probable cause: xsd pick file not saved '
     :        //' correctly'
         call exit(10002)
      endif

c calculate length of trace in integer*2 words.
c calculate number of bytes in output trace

      nbyptr = ( nsamp + lenhed ) * szsmpd
      lenu2  = nsamp + lenhed

c print out relevent information.

      write(lerr,*) 
      write(lerr,*) 'files'         
      write(lerr,*) 'ntap     : ',ntap    
      write(lerr,*) 'otap     : ',otap    
      write(lerr,*) 'pickfile : ',pickfile    
      write(LERR,*)
      write(LERR,*)' Values read from input data set line header'
      write(LERR,*)
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' samples to mute       =  ', nz   
      write(lerr,*) ' nxtaper               =   ',nxtaper
      write(lerr,*) ' nztaper               =   ',nztaper
      write(lerr,*) ' nbyptr                =   ',nbyptr 
      write(lerr,*) ' lenu2                 =   ',lenu2  
      write(LERR,*) ' Sample Interval (msec)=  ', dtmsec
      write(LERR,*) ' Traces per Record     =  ', ntrace
      write(LERR,*) ' Records per Line      =  ', nrec
      write(LERR,*) ' Start processing rec  =  ', irs
      write(LERR,*) ' End processing rec    =  ', ire
      write(LERR,*) ' mute rejection factor = ',reject
      write(LERR,*) ' mute pass factor      = ',pass  
      write(lerr,*) ' mute outside polygon?   ',outside
      write(lerr,*) ' verbose output?         ',verbos 
      write(lerr,*) ' force mode?             ',force 
      write(lerr,*) ' multi value extend?     ',mvextend
      if ( replace ) then
         write(lerr,*) ' replace value in mute zone with ',replace_value
      endif
c adjust historical line header & write header

      call savhlh ( sheader, lbyte, lbyout )
      call wrtape ( luout, sheader, lbyout )

c calculate memory requirements
c keep data buffered out to fft sizes, even if we don't need them.

      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)

      l_free = 1
      lenu = ntrace * ( lenhed + nsamp )
      lenbuf = ( ntrace + 2 * nxtaper ) * ( nz * 2 + nztaper )

      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('u',l_u,l_free,lenu,lerr)
      call mapmem('npicks',l_npicks,l_free,nsegments,lerr)
      call mapmem('segnum',l_segnum,l_free,nsegments,lerr)
      call mapmem('segcolor',l_segcolor,l_free,nsegments,lerr)
      call mapmem('trace',l_trace,l_free,nsegments*(maxpicks+3),lerr)
      call mapmem('record',l_record,l_free,nsegments*(maxpicks+3),lerr)
      call mapmem('sample',l_sample,l_free,nsegments*(maxpicks+3),lerr)
      call mapmem('temp',l_temp,l_free,maxpicks+3,lerr)
c      call mapmem('trace',l_trace,l_free,nsegments*(maxpicks+1),lerr)
c      call mapmem('record',l_record,l_free,nsegments*(maxpicks+1),lerr)
c      call mapmem('sample',l_sample,l_free,nsegments*(maxpicks+1),lerr)
c      call mapmem('temp',l_temp,l_free,maxpicks+1,lerr)
      call mapmem('wgt',l_wgt,l_free,(2*nxtaper+1)*(2*nztaper+1),lerr)
      call mapmem('w_interp',l_w_interp,l_free,nz*ntrace,lerr)
      call mapmem('w_left',l_w_left,l_free,nz*ntrace,lerr)
      call mapmem('w_right',l_w_right,l_free,nz*ntrace,lerr)

      call mapmem('w_Across',l_w_Across,l_free,nz*ntrace,lerr)
      call mapmem('w_Down',l_w_Down,l_free,nz*ntrace,lerr)

      call mapmem('wbuf',l_wbuf,l_free,lenbuf,lerr)

c allocate dynamic memory.

      lens = l_free - 1
      write(lerr,'(a20,10x,i10)') 'total vector length', lens
      call galloc ( pntrs, lens * SZSMPD, ierrcd, 0 )
      if ( ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program POLYMUTE aborted'

         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,'(a20,10x,i10)') 'total vector length', lens
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program POLYMUTE aborted'
         call exit(10001)
      endif

c read in the picks.   

      call rdpicks ( segname, s(l_segnum), s(l_segcolor), s(l_npicks), 
     1     s(l_record), s(l_trace), s(l_sample),
     2     recunit, trcunit, smpunit, recoff, trcoff, smpoff,
     3     maxpicks, nsegments, lupick, lerr,
     4     nz, ntrace, nrec, s(l_temp),
     5     nxtaper, nztaper, multivalue, verbos )

c calculate weights needed for 2D tapering/smoothing of mute polygon.

      call getwgt ( s(l_wgt), nxtaper, nztaper )

c calculate trace header position of key variables.

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


c calculate mute mask and apply

      call appmute ( s(l_u), hbegin, nsamp, nz, nbyptr, lenu2,
     1     ntrace, nrec, l_StaCor, l_RecNum, luin, luout, lerr,
     2     s(l_w_left), s(l_w_right), s(l_w_interp), s(l_wbuf),
     3     pass, s(l_npicks), nsegments, maxpicks, nxtaper, nztaper,
     4     s(l_wgt), s(l_record), s(l_trace), s(l_sample), outside,
     5     s(l_w_Across), s(l_w_Down), verbos , replace, replace_value,
     6     ifmt_RecNum,ln_RecNum,ifmt_StaCor,ln_StaCor, irs, ire)

c close files

      call lbclos(luin)
      call lbclos(luout)

      write(lerr,*) 'normal completion of routine POLYMUTE'
      write(ler ,*) 'normal completion of routine POLYMUTE'
      close(lerr)

      call exit(0)

c error messages 

99001 continue

      write(lerr,*) ' '
      write(lerr,*) ' error in opening pick file!'
      write(lerr,*) ' pickfile = ',pickfile
      write(lerr,*) ' please check spelling and/or permissions'
      write(lerr,*) ' and try again'
      write(LER,*) ' '
      write(LER,*) 'POLYMUTE: '
      write(LER,*) ' error in opening pick file!'
      write(LER,*) ' pickfile = ',pickfile
      write(LER,*) ' please check spelling and/or permissions'
      write(LER,*) ' and try again'
      write(LER,*) 'FATAL' 
      stop
      end

      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'************************************************* '
        write(LER,*)'Command Line Arguments for POLYMUTE:  '               
        write(ler,*)'2D muting inside/ouside of polygon with tapers'
        write(LER,*)' '
        write(LER,*)'-Delimeter (def)  :       definition' 
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)'-N (stdin)     :    input data set'
        write(LER,*)'-O (stdout)    :    output data set'
        write(LER,*)'-P (none)      :    input xsd pick file'
        write(LER,*)'-reject (100%) :    rejection in mute zone'
        write(LER,*)'-nxtaper (10)  :    mute taper in traces'
        write(LER,*)'-nztaper (10)  :    mute taper in samples'
        write(LER,*)'-rs[irs] (1st) :    start process record'
        write(LER,*)'-re[ire] (last):    end process record'
        write(LER,*)'-M (out)       :    in =   mute inside polygon'
        write(LER,*)'                    out = mute outside polygon'
        write(LER,*)'-force         :    ignore fk line header flag'
        write(LER,*)'-replace       :    replace mute zone with value'
        write(LER,*)'-value (0.0)   :    replacement value if -replace'
        write(LER,*)'                    is flagged'
        write(LER,*)'-partial       :    create a polygon from the '
        write(LER,*)'                    input mute line'
        write(LER,*)'-V             :    verbose output'
        write(LER,*)'Usage:'
        write(LER,*)'        polymute -N[] -O[] -P[] -M[] -rs[] -re[]' 
        write(LER,*)'                 -reject[] -nxtaper[] -nztaper[]'
        write(LER,*)'                 -replace -value[] '
        write(LER,*)'                 [ -partial -force -V ]'
        write(LER,*)'************************************************* '
        write(LER,*)' '

      return
      end

      subroutine cmdln( ntap, otap, pickfile, nztaper, nxtaper,
     1     reject, outside, force, replace, replace_value, verbos,
     2     irs, ire, multivalue )

      real replace_value
      character*(*) ntap,otap,pickfile
      character*3   response
      integer    argis, irs, ire
      logical    verbos, outside, replace, force, multivalue


c     Dan Whitmore: In linux, the argis did not work for decoding
c                   replace unless it was moved to earlier in this
c                   calling sequence -  go figure??

      replace=( argis('-replace') .gt. 0)
      force = ( argis('-force') .gt. 0)
      multivalue=( argis('-partial') .gt. 0)
      verbos=( argis('-V') .gt. 0)
      call argi4('-nxtaper',nxtaper,10,10) 
      call argi4('-nztaper',nztaper,10,10) 
      call argstr('-N',ntap,' ',' ') 
      call argstr('-M',response,'out','out')
      call argstr('-O',otap,' ',' ') 
      call argstr('-P',pickfile,' ',' ') 
      call argr4('-reject',reject,100.,100.)
      call argi4('-rs',irs,0,0)
      call argi4('-re',ire,0,0)
      call argr4('-value',replace_value, 0.0 ,0.0)
c
      if(response .eq. 'out') then
         outside=.true. 
      else
         outside=.false.
      endif
c
      return
      end
