C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather ( rbuffer, ibuffer, hbegin, maxsamp, lentr2, 
     :     ntr, luin, LERR, eod, itr, irec, l_StaCor,l_RecNum,irecnum,
     :     ifmt_RecNum,ln_RecNum,ifmt_StaCor,ln_StaCor)



c rdgather reads a record of ntr traces into memory, irecnum is returned
c as the last recnum entry in the live traces read.

c variables pass from\to calling routine

      integer   hbegin, maxsamp, lentr2, ntr, luin, LERR, itr, irec
      integer   l_StaCor, l_RecNum, irecnum

c ibuffer and rbuffer are equivalenced by the calling arguments.

      integer   ibuffer(lentr2,ntr)

      real      rbuffer(hbegin:maxsamp,ntr)

      logical   eod

c local variables

      integer nbytes

c initialize variables

      nlive = 0

c process

      do itr = 1, ntr
         nbytes = 0
         call rtape ( luin, rbuffer(hbegin,itr), nbytes )
         if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'  rec= ',irec,'  trace= ',itr
            eod=.true.
            return
         endif

         eod=.false.

         call saver2(ibuffer(1,itr) ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               istatic  , 1)
         call saver2(ibuffer(1,itr) ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               jrecnum  , 1)

         if ( istatic .eq. 30000 ) then
            call vclr ( rbuffer(1,itr), 1, maxsamp )
         elseif(jrecnum .gt. 0) then
            irecnum = jrecnum 
         endif
      enddo

      return
      end

