C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wmult ( u, hbegin, ntrace, nsamp, maxsamp, w,
     :     replace, replace_value )

c wmult applies the weights in w to the data in u

c variables passed to\from calling routine

      integer hbegin, ntrace, nsamp, maxsamp

      real    u(hbegin:maxsamp,ntrace)
      real    w(nsamp,ntrace)
      real    replace_value

      logical replace

c local variables

      integer itrace, isamp

c process

      if ( .not. replace ) then
c replace the value in the mute zone with a hard zero which is 
c done by multiplying the record by the mute mask

         do itrace = 1, ntrace
            do isamp = 1, nsamp
               u(isamp,itrace) = w(isamp,itrace) * u(isamp,itrace)
            enddo
         enddo

      else

c replace the value in the mute zone with a user defined amplitude

         do itrace = 1, ntrace
            do isamp = 1, nsamp
               if ( w(isamp,itrace) .eq. 0.0 ) 
     :              u(isamp,itrace) = replace_value
            enddo
         enddo

      endif
      return
      end

