C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C
C     PROGRAM NAME: PR3D (3-D DESCRIPTIVE DATA PREPROCESSING)
C
C     LANGUAGE: FORTRAN VS
C
C     AUTHORS: GARY RUCKGABER (DESIGN)
C              GARY DONATHAN  (CODING)
C
C     DATE WRITTEN: JANUARY 1977
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: WRITES DESCRIPTIVE DATA INTO THE LINE HEADER
C               AND TRACE HEADERS OF SIS FORMAT TAPES FOR TRACE
C               PROCESSING OF THREE-DIMENSIONAL SEISMIC DATA.
C
C     SUBROUTINES: GAMOCO  LBOPEN   RTAPE    HLH      NACCT
C                  STRING  WRTAPE   MOVE     NACCT2
C                  LBCOLS  CCEXIT
C
C     MODIFICATION HISTORY:
C
C                GARY RUCKGABER        OCT. 1978
C                  (TO READ SPRD CARDS)
C                GARY RUCKGABER        MAR. 1980
C                  (CHANGE X,Y COORDINATE LOCATIONS IN TRACE HEADER
C                GARY RUCKGABER        JUN. 1980
C                  (TO EXPAND LENGTH OF GROUP ARRAYS FROM 3000
C                   TO 5000)
C                DAVID MORRIS          DEC. 1980
C                  (TO EXPAND LENGTH OF GROUP ARRAYS FROM 5000
C                   TO 12000)
C                DAVE KIRK             FEB. 1981
C                  (TO ALLOW INPUT OF ALPHA SUFFIX FOR SP NUMBERS)
C                COLIN BURSTALL        AUG. 1981
C                  (CONVERTED TO P-E SYSTEM)
C                COLIN BURSTALL        SEP. 1981
C                  (TO EXPAND LENGTH OF GROUP ARRAYS FROM 12000
C                   TO 22000)
C                GARY SHIBA            MAY  1982
C                  (IMPLIMENT TRACE OMIT/INVERT OPTIONS)
C                  (INCREASE NO. OF SEGMENTS TO 516)
C                  (UPDATE ERROR MESSAGES USING SIS CONVENTIONS)
C                GARY SHIBA            JULY 1982
C                  (PLACE FREE FORM FIELD HISTORY CARDS INTO LINE
C                   HEADER FOR USE BY PROGRAM 'PLOT')
C                GARY SHIBA            AUG. 1982
C                  (PLACE SHOT-RECEIVER AZIMUTH IN TRACE HEADER
C                   WORD 22 - RADIANS*10000)
C                GARY SHIBA            OCT. 1982
C                  (INCREASE NUMBER OF GROUP LOCATIONS FROM 22000
C                   TO 32000)
C                  (FIX BUG IN FIELD HISTORY OPTION)
C                  (SET AZIMUTH TO ZERO IF SHOT & RECEIVER ARE AT
C                   EXACT SAME LOCATION)
C                DOUGLAS BODDY         JAN. 1984
C                  (ADDED OPTION FOR INDEXING)
C                GARY SHIBA            JULY 1984
C                  (ALLOW USER-SPECIFIED START LI,DI FOR INDEXING)
C                  (CORRECT CELL DIMENSIONS IN LINE HEADER)
C                GARY MURPHY           SEP. 1986
C                   IMPLEMENTED NEW STATICS WORDS.
C                GARY MURPHY           OCT. 1986
C                   MADE KOUNT BUFFER DYNAMIC (FOR INDEXING).
C                GARY MURPHY
C                   IMPLEMENT NEW AND OLD STATICS WORDS BUT KEEP
C                   USING THE OLD STATICS WORDS.  ADDED DRY RUN FLAG.
C                   ADDED SIGNED DISTANCE.  PUT NEAREST GI IN
C                   SOURCE LOCATION INDEX (WORD 109).
C                GARY MURPHY           SEP. 1988
C                   SET LINE HEADER HALF-WORD 75 TO 2
C                   SET LI AND DI LIMITS IN LINE HEADER APPROPRIATE FOR
C                   DMO
C                   SET MIN AND MAX DISTANCE IN LINE HEADER
C                GARY MURPHY           JUL. 1989
C                   FIXED FOLD DIAGRAM
C                GARY MURPHY           JUL. 1989
C                   ADD SHOT POINT ABOVE DEPTH POINT
C                GARY MURPHY           SEP. 1989
C                   ADD 5SPRD CARDS AND MARINE INDEXING
C                GARY MURPHY           OCT. 1989
C                   ADD SOURCE POINT TO DEPTH POINT CONVERSION
C                   PARAMETER
C                JOE WADE		JUL 1994

C                   SWITCHED FROM USE OF LARGER 1E70 CONSTANT TO

C                   USE OF EPEMAX FUNCTION

C
C***********************************************************************
C
C    ARRAYS        TYPE    USAGE
C    ------        ----    -----
C    IGX     -     I*4     CONTAINS X COORDINATE VALUES FOR ALL GROUP
C                          INDICES
C
C    IGY     -     I*4     CONTAINS Y COORDINATE VALUES FOR ALL GROUP
C                          INDICES
C
C    IGE     -     I*4     CONTAINS ELEVATION VALUES FOR ALL GROUP
C                          INDICES
C
C    IGRRS   -     I*4     CONTAINS REGIONAL REFERENCE SURFACE VALUES
C                          FOR ALL GROUP INDICES
C
C    NGI     -     I*4     CONTAINS GROUP INDEX VALUES FOR EACH TRACE
C                          IN THE RECORD INDICATED BY THE 1SORC CARD
C
C-----------------------------------------------------------------------
C
C    VARIABLE      TYPE    USAGE
C    --------      ----    -----
C
C    NOTPSR  -     I*4     NUMBER OF TRACES PER SEISMIC RECORD
C    NOSREC  -     I*4     NUMBER OF SEISMIC RECORDS
C    ITRLEN  -     I*4     TRACE LENGTH IN SAMPLES
C    IFOR    -     I*4     INPUT TAPE DATA FORMAT
C    GISIZE  -     I*4     MAXIMUM SIZE OF THE GROUP INDEX ARRAYS
C
C    SORTYP  -     I*2     SORT TYPE (CHARACTER*2)
C
C    FOLD    -     I*2     FOLD
C
C    GRPINT  -     I*4     GROUP INTERVAL GIVEN IN FEET (CHARACTER*4)
C
C    JRRS    -     I*4     CONSTANT REGIONAL REFERENCE SURFACE
C                          ELEVATION GIVEN IN FEET
C
C    SWVELJ  -     R*4     CONSTANT REPLACEMENT VELOCITY IN FT/SEC
C
C    MAXSPE  -     I*4     MAXIMUM SOURCE POINT ELEVATION
C    MINSPE  -     I*4     MINIMUM SOURCE POINT ELEVATION
C
C    MAXRSE  -     I*4     MAXIMUM REFERENCE SURFACE ELEVATION
C    MINRSE  -     I*4     MINIMUM REFERENCE SURFACE ELEVATION
C
C    MAXGE   -     I*4     MAXIMUM GROUP ELEVATION
C    MINGE   -     I*4     MINIMUM GROUP ELEVATION
C
C    MAXTS   -     I*4     MAXIMUM TRACE STATIC
C    MINTS   -     I*4     MINIMUM TRACE STATIC
C
C    IX      -     I*4     X-COORDINATE OF SEISMOMETER GROUP IF FEET
C                          READ FROM CURRENT 1GRUP CARD
C
C    IY      -     I*4     Y-COORDINATE OF SEISMOMETER GROUP IF FEET
C                          READ FROM CURRENT 1GRUP CARD
C
C    IE      -     I*4     ELEVATION OF SEISMOMETER GROUP IF FEET
C                          READ FROM CURRENT 1GRUP CARD
C
C    IRRS    -     I*4     REGIONAL REFERENCE SURFACE ELEVATION AT
C                          SEISMOMETER GROUP IN FEET. READ FROM
C                          CURRENT 1GRUP CARD
C
C    IG      -     I*4     GROUP INDEX NUMBER FROM CURRENT 1GRUP CARD
C
C-----------------------------------------------------------------------
C
C    I/O DEVICE VARIABLES:
C    ---------------------
C
C    ICR     -     I*4     INPUT CARD DEVICE NUMBER
C    IPR     -     I*4     OUTPUT PRINTER DEVICE NUMBER
C    LUIN    -     I*4     INPUT TAPE DEVICE NUMBER
C    LUOUT   -     I*4     OUTPUT TAPE DEVICE NUMBER
C
C***********************************************************************
C
C-----------------------------------------------------------------------
C     DEFINITIONS & DECLARATIONS
C-----------------------------------------------------------------------
#include <f77/lhdrsz.h>

#include <f77/sisdef.h>

#include <f77/iounit.h>

#include <fu_defs.h>

#include <save_defs.h>

C

	integer refvel

      double precision    SUMX,SUMY,SUMXY,SUMXX
      double precision    DEL,SLOPE,YINT,X,Y
      double precision    XMIN,XMAX,YMIN,YMAX
C
      REAL*4    TRACE ( 6000)
C
      REAL*4    AZMSGN (4)
      REAL*4    AZBIAS (4)
C
      INTEGER*4 I4LHDR( 1500), TRAREC( 6064), I4THDR(   64)

      INTEGER*4 I4LISV( 1500)
C


      INTEGER   IGX   (    1), IGY   (    1), IGE   (    1)
      INTEGER   IGRRS (    1)
c

   	pointer (iigx, igx), (iigy, igy), (iige, ige),

     *		(iigrrs, igrrs)

	integer errcd, abort

	integer ipldir,bnctr(8)

C
      INTEGER*4 TRSEG ( 1028), GISEG ( 1028), NGI   ( 2048)
      INTEGER*4 KTRCS (   12), GIINC ( 1028), NGIINC( 2048)
C
      INTEGER*4 GISIZE, OMTSAV
C
      INTEGER*4 LIBIAS, DIBIAS, LI1   , DI1
C

      INTEGER COUNT(    1)


   	integer KOUNT(1), SPABOV(1), FDATUM(1)

   	pointer (ikount,kount), (ispabv,spabov),


     *		(idatum,fdatum), (icount,count)

      INTEGER ITRACE(12000)
      INTEGER OMTBUF( 4096), INVBUF( 2048)
C
      INTEGER FOLD  , MAXSPE, MINSPE, MAXRSE, MINRSE
      INTEGER MAXGE , MINGE , MAXTS , MINTS
      INTEGER IFLAG , IBIAS
c

	integer I2T19, I2T20

	integer argis

	logical query


C
      CHARACTER*1 CDIR(4)
      CHARACTER*1 CBEAR(4)
      CHARACTER*4 GRPINT,  C4LHDR  (64), IADD,  IADD1, IADD2
      CHARACTER*4 IADD3,   IADD4,        IADD5, IADD6, IADD7
      CHARACTER*1 HLH0(25)
      CHARACTER*1 HLH1(33)
      CHARACTER*1 HLH2(20)
      CHARACTER*1 L1LISV(12000)
      CHARACTER*1 L1LHDR(12000) , ASPNO , TITLE (   66)
	character*48 LHHOLD

	character*4  LHC4

#ifdef CRAYSYSTEM

	character*1 corner(8)

	integer istart

#endif

      LOGICAL*1   INDXNG, EOCC
C
      CHARACTER*2  SORTYP, C2LHDR (128)
      CHARACTER*34 HLHMSG
      CHARACTER*80 CARD

	character ntap*100,otap*100,cardin*100,ocell*100

	character*4 name

C
C
      EQUIVALENCE (I4LISV(1),L1LISV(1))
      EQUIVALENCE (TRAREC(1),I4LHDR(1),L1LHDR(1))
      EQUIVALENCE (TRAREC(1),I4THDR(1),C2LHDR(1),C4LHDR(1))
#ifdef SUNSYSTEM

      EQUIVALENCE (TRACE (1),ITRACE(1),TRAREC(65))
#endif

#ifdef CRAYSYSTEM

      EQUIVALENCE (TRACE (1),ITRACE(1),TRAREC(129))

#endif

C
      EQUIVALENCE (OMTBUF(2049),INVBUF(1))
C
      DATA ICR /99/, IPR /LERR/, ICRD /77/
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
C     DATA IDISK/54/
C     DATA LUIN /14/, LUOUT /24/
C=======================================================================
C=======================================================================
      DATA CDIR   /'N','N','S','S'/
      DATA CBEAR  /'E','W','W','E'/
      DATA AZMSGN /-1.,1.,-1.,1./
      DATA AZBIAS /90.,-90.,270.,-270./
      DATA CHARGE /1.0/
      DATA MAXSEG /1028/

      DATA INDXNG/.FALSE./,EOCC/.FALSE./
      DATA NREC/0/
      DATA MAXFLG/0/
      DATA MAXX/0/
C
C
      DATA  TITLE/17*' ','3','-','D',' ',
     $    'D','E','S','C','R','I','P','T','I','V','E',' ',
     $    'D','A','T','A',' ',
     $    'P','R','O','C','E','S','S','I','N','G',18*' '/
C
      DATA ICC/0/
C
      DATA NHLH0 /25/, HLH0/'P','R','3','D',' ',
     $ '(','P','R','E','P','R','O','C','E','S','S','I','N','G',' ',
     $ 'O','N','L','Y',')'/
      DATA NHLH1 /33/, HLH1/'P','R','3','D',' ',
     $ '(','P','R','E','P','R','O','C','E','S','S','I','N','G',' ',
     $ 'A','N','D',' ',
     $ 'I','N','D','E','X','I','N','G',')'/
      DATA NHLH2 /20/, HLH2/'P','R','3','D',' ',
     $ '(','I','N','D','E','X','I','N','G',' ','O','N','L','Y',')'/
      DATA ITRCS/0/
      DATA IDREC/0/
      DATA MINLI   /999999999/
      DATA MINDI   /999999999/
      DATA MINSLI  /999999999/
      DATA MINSDI  /999999999/
      DATA MINRLI  /999999999/
      DATA MINRRI  /999999999/
      DATA MINDST  /999999999/
      DATA MNLI    /999999999/
      DATA MNDI    /999999999/
      DATA MNSLI   /999999999/
      DATA MNSDI   /999999999/
      DATA MNRLI   /999999999/
      DATA MNRDI   /999999999/
      DATA MNHLI   /999999999/
      DATA MNHDI   /999999999/
      DATA MNDST   /999999999/
      DATA MNHDST  /999999999/
      DATA MAXLI  /-999999999/
      DATA MAXDI  /-999999999/
      DATA MAXSLI /-999999999/
      DATA MAXSDI /-999999999/
      DATA MAXRLI /-999999999/
      DATA MAXRDI /-999999999/
      DATA MXHDST /         0/
      DATA MAXDST /         0/
      DATA MXLI   /-999999999/
      DATA MXDI   /-999999999/
      DATA MXSLI  /-999999999/
      DATA MXSDI  /-999999999/
      DATA MXRLI  /-999999999/
      DATA MXRDI  /-999999999/
      DATA MXHLI  /-999999999/
      DATA MXHDI  /-999999999/
      DATA MXDST  /         0/
      DATA I5SPRD  /0/
      DATA IADD, IADD1,IADD2,IADD3 /4*'ABOV'/
      DATA IADD4,IADD5,IADD6,IADD7 /4*'ABOV'/
	data name/'PR3D'/

cc.................................................................cc

cc       check for help flag



      query = ( argis ( '-?' ) .gt. 0 )

      if ( query ) then

         call help1()

         stop

      endif

C
C-----------------------------------------------------------------------
C     TORCH & OVAL
C     OPEN THE I/O DEVICES
C-----------------------------------------------------------------------
C
C--
C---- open printout file

C--
#include <f77/open.h>

	call cmdln(ntap, otap, cardin, idry, ocell)

cmam	call cmdln(ntap, otap, cardin, idry)

      CALL GAMOCO (TITLE,1,IPR)
      IF (IDRY .EQ. 1) GO TO 11
cmam  IF (IDRY .EQ. 1) GO TO 350
C *------------------------------------------------------------------* C
C *  If ntap specified, open it, otherwise set luin to standard

C *  input (= pipe in)

C *------------------------------------------------------------------* C
        call getln (luin , ntap, 'r', 0)

       if (luin .lt. 0) then

         write (LERR,*) 'Could not open input ',ntap

         call ccexit(100)

      endif

C *------------------------------------------------------------------* C
C *  If otap specified, open it, otherwise set luout to standard

C *  output (= pipe out)

C *------------------------------------------------------------------* C
        call getln (luout, otap, 'w', 1)

C
C-----------------------------------------------------------------------
C     READ THE INPUT LINE HEADER & CHECK FOR ERROR
C     UPDATE THE PROCESS HISTORY
C     START ACCOUNTING PROCEDURE
C-----------------------------------------------------------------------
C
cmam...set up pointers to lineheader values...
cmam..............keyword, format,  index,   length..........
   11 continue
      call savelu('NumTrc',j_NumTrc,i_NumTrc,l_NumTrc,LINHED)
      call savelu('NumRec',j_NumRec,i_NumRec,l_NumRec,LINHED)
      call savelu('Format',j_Format,i_Format,l_Format,LINHED)
      call savelu('NumSmp',j_NumSmp,i_NumSmp,l_NumSmp,LINHED)
      call savelu('EqpCod',j_EqpCod,i_EqpCod,l_EqpCod,LINHED)
      call savelu('CrwNam',j_CrwNam,i_CrwNam,l_CrwNam,LINHED)
      call savelu('DatTyp',j_DatTyp,i_DatTyp,l_DatTyp,LINHED)
      call savelu('DgTrkS',j_DgTrkS,i_DgTrkS,l_DgTrkS,LINHED)
      call savelu('PrcNam',j_PrcNam,i_PrcNam,l_PrcNam,LINHED)
      call savelu('PrcDat',j_PrcDat,i_PrcDat,l_PrcDat,LINHED)
      call savelu('OACLin',j_OACLin,i_OACLin,l_OACLin,LINHED)
      call savelu('JobNum',j_JobNum,i_JobNum,l_JobNum,LINHED)
      call savelu('CDPFld',j_CDPFld,i_CDPFld,l_CDPFld,LINHED)
      call savelu('SrtTyp',j_SrtTyp,i_SrtTyp,l_SrtTyp,LINHED)
      call savelu('GrpInt',j_GrpInt,i_GrpInt,l_GrpInt,LINHED)
      call savelu('MxSPEl',j_MxSPEl,i_MxSPEl,l_MxSPEl,LINHED)
      call savelu('MnSPEl',j_MnSPEl,i_MnSPEl,l_MnSPEl,LINHED)
      call savelu('MxRSEL',j_MxRSEL,i_MxRSEL,l_MxRSEL,LINHED)
      call savelu('MnRSEL',j_MnRSEL,i_MnRSEL,l_MnRSEL,LINHED)
      call savelu('MxGrEl',j_MxGrEl,i_MxGrEl,l_MxGrEl,LINHED)
      call savelu('MnGrEl',j_MnGrEl,i_MnGrEl,l_MnGrEl,LINHED)
      call savelu('MxTrSt',j_MxTrSt,i_MxTrSt,l_MxTrSt,LINHED)
      call savelu('MnTrSt',j_MnTrSt,i_MnTrSt,l_MnTrSt,LINHED)
      call savelu('MxShDp',j_MxShDp,i_MxShDp,l_MxShDp,LINHED)
      call savelu('MnShDp',j_MnShDp,i_MnShDp,l_MnShDp,LINHED)
      call savelu('MxUHTm',j_MxUHTm,i_MxUHTm,l_MxUHTm,LINHED)
      call savelu('MnUHTm',j_MnUHTm,i_MnUHTm,l_MnUHTm,LINHED)
      call savelu('UnitFl',j_UnitFl,i_UnitFl,l_UnitFl,LINHED)
      call savelu('StWdFl',j_StWdFl,i_StWdFl,l_StWdFl,LINHED)
      call savelu('RefVel',j_RefVel,i_RefVel,l_RefVel,LINHED)
      call savelu('FrstSP',j_FrstSP,i_FrstSP,l_FrstSP,LINHED)
      call savelu('DpN1SP',j_DpN1SP,i_DpN1SP,l_DpN1SP,LINHED)
      call savelu('NmDpIn',j_NmDpIn,i_NmDpIn,l_NmDpIn,LINHED)
      call savelu('MnLnIn',j_MnLnIn,i_MnLnIn,l_MnLnIn,LINHED)
      call savelu('MxLnIn',j_MxLnIn,i_MxLnIn,l_MxLnIn,LINHED)
      call savelu('MnDpIn',j_MnDpIn,i_MnDpIn,l_MnDpIn,LINHED)
      call savelu('MxDpIn',j_MxDpIn,i_MxDpIn,l_MxDpIn,LINHED)
      call savelu('DptInt',j_DptInt,i_DptInt,l_DptInt,LINHED)
      call savelu('PltDir',j_PltDir,i_PltDir,l_PltDir,LINHED)
      call savelu('LinDir',j_LinDir,i_LinDir,l_LinDir,LINHED)
      call savelu('ILClIn',j_ILClIn,i_ILClIn,l_ILClIn,LINHED)
      call savelu('CLClIn',j_CLClIn,i_CLClIn,l_CLClIn,LINHED)
      call savelu('MutFlg',j_MutFlg,i_MutFlg,l_MutFlg,LINHED)
      call savelu('MxTrOf',j_MxTrOf,i_MxTrOf,l_MxTrOf,LINHED)
      call savelu('MnTrOf',j_MnTrOf,i_MnTrOf,l_MnTrOf,LINHED)
      call savelu('NTrLnS',j_NTrLnS,i_NTrLnS,l_NTrLnS,LINHED)
      call savelu('SmpInt',j_SmpInt,i_SmpInt,l_SmpInt,LINHED)
      call savelu('HlhEnt',j_HlhEnt,i_HlhEnt,l_HlhEnt,LINHED)
      call savelu('HlhByt',j_HlhByt,i_HlhByt,l_HlhByt,LINHED)
cmam..........................................
cmam...set up pointers to traceheader values...
      call savelu('StaCor',j_StaCor,i_StaCor,l_StaCor,TRCHED)
      call savelu('RecNum',j_RecNum,i_RecNum,l_RecNum,TRCHED)
      call savelu('TrcNum',j_TrcNum,i_TrcNum,l_TrcNum,TRCHED)
      call savelu('SrRcMX',j_SrRcMX,i_SrRcMX,l_SrRcMX,TRCHED)
      call savelu('SrRcMY',j_SrRcMY,i_SrRcMY,l_SrRcMY,TRCHED)
      call savelu('SrPtXC',j_SrPtXC,i_SrPtXC,l_SrPtXC,TRCHED)
      call savelu('SrPtYC',j_SrPtYC,i_SrPtYC,l_SrPtYC,TRCHED)
      call savelu('RcPtXC',j_RcPtXC,i_RcPtXC,l_RcPtXC,TRCHED)
      call savelu('RcPtYC',j_RcPtYC,i_RcPtYC,l_RcPtYC,TRCHED)
      call savelu('ShtDep',j_ShtDep,i_ShtDep,l_ShtDep,TRCHED)
      call savelu('UphlTm',j_UphlTm,i_UphlTm,l_UphlTm,TRCHED)
      call savelu('SrcLoc',j_SrcLoc,i_SrcLoc,l_SrcLoc,TRCHED)
      call savelu('PrRcNm',j_PrRcNm,i_PrRcNm,l_PrRcNm,TRCHED)
      call savelu('PrTrNm',j_PrTrNm,i_PrTrNm,l_PrTrNm,TRCHED)
      call savelu('SrPtEl',j_SrPtEl,i_SrPtEl,l_SrPtEl,TRCHED)
      call savelu('DstUsg',j_DstUsg,i_DstUsg,l_DstUsg,TRCHED)
      call savelu('SrRcAz',j_SrRcAz,i_SrRcAz,l_SrRcAz,TRCHED)
      call savelu('RecInd',j_RecInd,i_RecInd,l_RecInd,TRCHED)
      call savelu('DstSgn',j_DstSgn,i_DstSgn,l_DstSgn,TRCHED)
      call savelu('GrpElv',j_GrpElv,i_GrpElv,l_GrpElv,TRCHED)
      call savelu('DePtEl',j_DePtEl,i_DePtEl,l_DePtEl,TRCHED)
      call savelu('RfSrEl',j_RfSrEl,i_RfSrEl,l_RfSrEl,TRCHED)
      call savelu('CabDep',j_CabDep,i_CabDep,l_CabDep,TRCHED)
      call savelu('InStUn',j_InStUn,i_InStUn,l_InStUn,TRCHED)
      call savelu('RcStUn',j_RcStUn,i_RcStUn,l_RcStUn,TRCHED)
      call savelu('ToStUn',j_ToStUn,i_ToStUn,l_ToStUn,TRCHED)
      call savelu('InStAp',j_InStAp,i_InStAp,l_InStAp,TRCHED)
      call savelu('RcStAp',j_RcStAp,i_RcStAp,l_RcStAp,TRCHED)
      call savelu('ToStAp',j_ToStAp,i_ToStAp,l_ToStAp,TRCHED)
      call savelu('FlDtEl',j_FlDtEl,i_FlDtEl,l_FlDtEl,TRCHED)
      call savelu('DatShf',j_DatShf,i_DatShf,l_DatShf,TRCHED)
      call savelu('SoPtNm',j_SoPtNm,i_SoPtNm,l_SoPtNm,TRCHED)
      call savelu('SoPtAl',j_SoPtAl,i_SoPtAl,l_SoPtAl,TRCHED)
      call savelu('LinInd',j_LinInd,i_LinInd,l_LinInd,TRCHED)
      call savelu('DphInd',j_DphInd,i_DphInd,l_DphInd,TRCHED)
      call savelu('CDPBCX',j_CDPBCX,i_CDPBCX,l_CDPBCX,TRCHED)
      call savelu('CDPBCY',j_CDPBCY,i_CDPBCY,l_CDPBCY,TRCHED)
      call savelu('FoldNm',j_FoldNm,i_FoldNm,l_FoldNm,TRCHED)
      call savelu('SrcPnt',j_SrcPnt,i_SrcPnt,l_SrcPnt,TRCHED)
      IF (IDRY .EQ. 1) GO TO 350
cmam..........................................
      NUMBYT            = 0
      CALL RTAPE (LUIN,I4LHDR,NUMBYT)
      IF (NUMBYT .NE. 0) GO TO 100
      WRITE (IPR, 50)
   50 FORMAT ('0** M3001 ** ERROR DETECTED BY PROGRAM PR3D:'         /
     $         13X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ '   ,
     $              'INPUT DATA SET LINE HEADER'                    /
     $         13X, 'VERIFY THE DATA SET NAME' /)
      ICC = 100
      GO TO 9400
C
 100  CALL SETFLG (1000,IPR)
C
C-----------------------------------------------------------------------
C cmamFETCH # TR/REC & CHECK FOR ERROR  (MAX = 1024)
C     FETCH # TR/REC & CHECK FOR ERROR  (MAX = 2048)

C-----------------------------------------------------------------------
C
cmam  call saver(I4LHDR, 'NumTrc', notpsr, LINHED)
	call saver2(I4LHDR,j_NumTrc,i_NumTrc,l_NumTrc,notpsr,LINHED)

cmam  IF (NOTPSR .LE. 1024) GO TO 200
      IF (NOTPSR .LE. 2048) GO TO 200

      WRITE (IPR,150)
  150 FORMAT ('0** M3002 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $         13X, 'THE NUMBER OF TRACES PER RECORD AS FILED IN '  ,
     $              'THE INPUT DATA SET LINE'                       /
cmam $         13X, 'HEADER EXCEEDS THE PROGRAM LIMIT OF 1024'      /
     $         13X, 'HEADER EXCEEDS THE PROGRAM LIMIT OF 2048'      /

     $         13X, 'VERIFY THE LINE HEADER ENTRY FOR NUMBER OF '   ,
     $              'TRACES PER RECORD'                             /)
      ICC = 100
C
C-----------------------------------------------------------------------
C     FETCH # REC/JOB
C     FETCH INPUT DATA SET FORMAT CODE & CHECK FOR ERROR (1 OR 3)
C     FETCH NUMBER OF SAMPLES ENTRY & ERROR CHECK (12000/6000)
C     COMPUTE NUMBER OF BYTES TO BE OUTPUT
C-----------------------------------------------------------------------
C
cmam  200 call saver(I4LHDR, 'NumRec', nosrec, LINHED)
  200	call saver2(I4LHDR,j_NumRec,i_NumRec,l_NumRec,nosrec,LINHED)
C
	call saver (I4LHDR, 'Format', ifor, LINHED)
	call saver2(I4LHDR,j_Format,i_Format,l_Format,ifor,LINHED)

      IF (IFOR .EQ. 1 .OR. IFOR .EQ. 3) GO TO 300
      WRITE (IPR,250)
  250 FORMAT ('0** M3003 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $         13X, 'THE FORMAT CODE FILED IN THE INPUT DATA SET '  ,
     $              'LINE HEADER IS NOT 1 OR 3'                     /
     $         13X, 'VERIFY THE FORMAT CODE FOR THIS DATA SET, '    ,
     $              'AMEND THIS ENTRY AND/OR'                       /
     $         13X, 'CONVERT THE DATA TO AN ACCEPTABLE FORMAT'      /)
      ICC = 100
C
cmam  300 call saver(I4LHDR, 'NumSmp', itrlen, LINHED)
  300	call saver2(I4LHDR,j_NumSmp,i_NumSmp,l_NumSmp,itrlen,LINHED)

      IF (ITRLEN .LE.  6000) GO TO 350
      IF (ITRLEN .LE. 12000 .AND. IFOR .EQ. 1) GO TO 350
      WRITE (IPR,340)
  340 FORMAT ('0** M3027 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $         13X, 'THE NUMBER OF SAMPLES ENTRY FILED IN THE '     ,
     $              'INPUT DATA SET LINE HEADER'                    /
     $         13X, 'EXCEEDS THE PROGRAM LIMIT'                     /
     $         13X, 'PROGRAM PR3D ACCEPTS A MAXIMUM OF 12000 '      ,
     $              'FORMAT 1 SAMPLES AND ACCEPTS'                  /
     $         13X, 'A MAXIMUM OF 6000 FORMAT 3 SAMPLES'            /
     $         13X, 'VERIFY THE LINE HEADER ENTRY AND AMEND IF '    ,
     $              'NECESSARY, AND/OR, WINDOW'                     /
     $         13X, 'THAT PORTION OF DATA OF INTEREST SUCH THAT '   ,
     $              'THE NUMBER OF SAMPLES'                         /
     $         13X, 'CONFORMS TO PROGRAM RESTRICTIONS'              /)
      ICC = 100
C
  350 NBO = ITRLEN * SZSMPD + SZTRHD

C
C-----------------------------------------------------------------------
C      READ & VERIFY THE 1PR3D PARAMETER CARD
C     TRANSFER CHARACTER DATA FROM 1PR3D CARD DIRECTLY TO LINE HEADER
C-----------------------------------------------------------------------
C
      NSORC = 0
      SUMX = 0.
      SUMY = 0.
      SUMXY = 0.
      SUMXX = 0.
      NCDPS = 0
c-----------------------------------------

c	open input card dataset file as logical unit 99

c-----------------------------------------

         open (unit=99, file= cardin, status='old',

     1         form='formatted',access='sequential')



  355 CONTINUE
      READ (ICR,356,END=357)  CARD
  356 FORMAT (A80)
      IF (CARD(1:5) .EQ. '1PR3D') THEN
         READ (CARD,361,END=9000) MODE,ISRECO,NDREC,INCREC,NTRCS,
     $                   IMETER,LHHOLD

c.c  $                   IMETER,(ahold(I),I=1,48)

  361    FORMAT (T7,I1,4I5,T48,I1,T28,A48)

c.361    FORMAT (T7,I1,4I5,T48,I1,T28,48A1)
      END IF
      IF (CARD(1:5) .EQ. '2PR3D') THEN
         READ (CARD,900)   SORTYP, FOLD  , GRPINT, JRRS  , SWVELJ,
     $                     MAXSPE, MINSPE, MAXRSE, MINRSE, MAXGE ,
     $                     MINGE , MAXTS , MINTS , JBRIEF, IBRIEF
      END IF
      IF (CARD(1:5) .EQ. '3PR3D') THEN
         READ (CARD,1040)   IX1,IY1, IX2,IY2, DY, DX
      END IF
      IF (CARD(1:5) .EQ. '1GRUP') THEN
         READ  (CARD,1400) IX  , IY  ,   IE, IRRS ,  IG
         IF (IRRS .EQ. 0) IRRS = JRRS
         IF (IG .EQ. 1) THEN
            IEMAX = IE
            IEMIN = IE
            MAXRRS = IRRS
            MINRRS = IRRS
         END IF
      END IF
      IF (CARD(1:5) .EQ. '1SORC') THEN
         NSORC  = NSORC + 1
         READ (CARD,2300)   ISX   , ISY   , IXO   , IYO   , ISE   ,
     $                      ISRRS , ISD   , IUT   , ISPNO , ASPNO ,
     $                      NSEG  , IRI
         NCDPS = NCDPS + 1
         X = ISX
         Y = ISY
         IF (NSORC .EQ. 1) THEN
            X1 = X
            Y1 = Y
            ISX1 = ISX
            ISY1 = ISY
            ISEMAX = ISE
            ISDMAX = ISD
            IUTMAX = IUT
            ISEMIN = ISE
            ISDMIN = ISD
            IUTMIN = IUT
            IF (ISPNO .EQ. 0) THEN
               IFSPNO = IRI
            ELSE
               IFSPNO = ISPNO
            END IF
         ELSE IF (NSORC .EQ. 2) THEN
            X2 = X
            Y2 = Y
         END IF
         SUMX = SUMX + X
         SUMY = SUMY + Y
         SUMXY = SUMXY + X*Y
         SUMXX = SUMXX + X*X
      END IF
      IF (CARD(1:5) .EQ. '5SPRD') I5SPRD = 1
      GO TO 355
  357 CONTINUE
      REWIND ICR
C
C *** SAVE LARGEST GI NUMBER
C
      GISIZE = IG
C
C *** COMPUTE SLOPE AND Y-INTERCEPT
C
      DEL   = FLOAT(NCDPS)*SUMXX - SUMX*SUMX
      IF (DEL .NE. 0.) THEN
         SLOPE = (FLOAT(NCDPS)*SUMXY - SUMY*SUMX) / DEL
         YINT  = (SUMY*SUMXX - SUMXY*SUMXX)       / DEL
      ELSE
         SLOPE = 0.
         YINT  = 0.
      END IF
C
C *** COMPUTE THETA
C
      THETA = ATAN(SLOPE)
C
C *** SET UP ROTATIONAL MATRIX
C
      COSANG = COS(THETA)
      SINANG = SIN(THETA)
C
C *** ROTATE THE COORDINATES AND COMPUTE MINS AND MAXS
C
      XMIN = COSANG*X1 - SINANG*Y1
      YMIN = SINANG*X1 + COSANG*Y1
      XMAX = COSANG*X2 - SINANG*Y2
      YMAX = SINANG*X2 + COSANG*Y2
      X1   = XMIN
      Y1   = YMIN
      X2   = XMAX
      Y2   = YMAX
      XMAX = X1
      YMAX = Y1
 3355 CONTINUE
      READ (ICR,356,END=3357)  CARD
      IF (CARD(1:5) .EQ. '1GRUP') THEN
         READ  (CARD,1400) IX  , IY  ,   IE, IRRS ,  IG
         IF ((I5SPRD .EQ. 0) .OR.
     &       (IG .LE. NTRCS         .AND. IG .GT. 0) .OR.
     &       (IG .GT. GISIZE-NTRCS  .AND. IG .LE. GISIZE)) THEN
            X = IX
            Y = IY
            IF (IRRS .EQ. 0) IRRS = JRRS
            XMIN = MIN (XMIN, COSANG*X - SINANG*Y)
            YMIN = MIN (YMIN, SINANG*X + COSANG*Y)
            XMAX = MAX (XMAX, COSANG*X - SINANG*Y)
            YMAX = MAX (YMAX, SINANG*X + COSANG*Y)
            IEMAX = MAX (IE, IEMAX)
            IEMIN = MIN (IE, IEMIN)
            MAXRRS = MAX (IRRS, MAXRRS)
            MINRRS = MIN (IRRS, MINRRS)
         END IF
      END IF
      IF (CARD(1:5) .EQ. '1SORC') THEN
         READ (CARD,2300)   ISX   , ISY   , IXO   , IYO   , ISE   ,
     $                      ISRRS , ISD   , IUT   , ISPNO , ASPNO ,
     $                      NSEG  , IRI
         X = ISX
         Y = ISY
         IF (ISRRS .EQ. 0) ISRRS = JRRS
         XMIN = MIN (XMIN, COSANG*X - SINANG*Y)
         YMIN = MIN (YMIN, SINANG*X + COSANG*Y)
         XMAX = MAX (XMAX, COSANG*X - SINANG*Y)
         YMAX = MAX (YMAX, SINANG*X + COSANG*Y)
         ISEMAX = MAX (ISE, ISEMAX)
         ISDMAX = MAX (ISD, ISDMAX)
         IUTMAX = MAX (IUT, IUTMAX)
         ISEMIN = MIN (ISE, ISEMIN)
         ISDMIN = MIN (ISD, ISDMIN)
         IUTMIN = MIN (IUT, IUTMIN)
         MAXRRS = MAX (ISRRS, MAXRRS)
         MINRRS = MIN (ISRRS, MINRRS)
      END IF
      GO TO 3355
 3357 CONTINUE
      REWIND ICR
C
C *** COMPUTE SOURCE POINT AND CDP SPACING
C
      DIST = SQRT ((X2-X1)*(X2-X1) + (Y2-Y1)*(Y2-Y1))
      IF (DX .LE. 0.) THEN
         IF (I5SPRD .EQ. 1) THEN
C
C *** 5SPRD CARDS IMPLY MARINE INDEXING (SLI = DI)
C
            DX = DIST
         ELSE
            DX = DIST / 2.
         END IF
      END IF
      IF (DY .LE. 0.) THEN
         DY = DX
      END IF
      IDP2SP = DIST * 100 / DX + 0.5
C
C *** X DIRECTION INCREASES WITH DI
C
      IF (XMAX - XMIN .GE. YMAX - YMIN) THEN
         XMIN = XMIN - DX/2
         XMAX = XMAX + DX/2
         YMIN = YMIN - DY/2
         YMAX = YMAX + DY/2
         IF (DY .GT. 0.) NLIS = (YMAX - YMIN) / DY + 1.5
         IF (DX .GT. 0.) NDIS = (XMAX - XMIN) / DX + 1.5
C
C *** SHOT POINTS INCREASING WITH X
C
         IF (X2 .GE. X1) THEN
            WRITE (IPR, 3365)
 3365       FORMAT(//, 18X, '*** SHOT POINTS INCREASING WITH X) ***'//)
            LX1 = COSANG*XMIN + SINANG*YMIN + 0.5
            LY1 =-SINANG*XMIN + COSANG*YMIN + 0.5
            LX2 = COSANG*XMIN + SINANG*YMAX + 0.5
            LY2 =-SINANG*XMIN + COSANG*YMAX + 0.5
            LX3 = COSANG*XMAX + SINANG*YMAX + 0.5
            LY3 =-SINANG*XMAX + COSANG*YMAX + 0.5
            LX4 = COSANG*XMAX + SINANG*YMIN + 0.5
            LY4 =-SINANG*XMAX + COSANG*YMIN + 0.5
C
C *** SHOT POINTS DECREASING WITH X
C
         ELSE
            WRITE (IPR, 3366)
 3366       FORMAT(//, 18X, '*** SHOT POINTS DECREASING WITH X) ***'//)
            LX4 = COSANG*XMIN + SINANG*YMIN + 0.5
            LY4 =-SINANG*XMIN + COSANG*YMIN + 0.5
            LX3 = COSANG*XMIN + SINANG*YMAX + 0.5
            LY3 =-SINANG*XMIN + COSANG*YMAX + 0.5
            LX2 = COSANG*XMAX + SINANG*YMAX + 0.5
            LY2 =-SINANG*XMAX + COSANG*YMAX + 0.5
            LX1 = COSANG*XMAX + SINANG*YMIN + 0.5
            LY1 =-SINANG*XMAX + COSANG*YMIN + 0.5
         END IF
C
C *** Y DIRECTION INCREASES WITH DI
C
      ELSE
         XMIN = XMIN - DY/2
         XMAX = XMAX + DY/2
         YMIN = YMIN - DX/2
         YMAX = YMAX + DX/2
         IF (DY .GT. 0.) NDIS = (YMAX - YMIN) / DY + 1.5
         IF (DX .GT. 0.) NLIS = (XMAX - XMIN) / DX + 1.5
C
C *** SHOT POINTS INCREASING WITH Y
C
         IF (Y2 .GE. Y1) THEN
            WRITE (IPR, 3367)
 3367       FORMAT(//, 18X, '*** SHOT POINTS INCREASING WITH Y) ***'//)
            LX1 = COSANG*XMIN + SINANG*YMIN + 0.5
            LY1 =-SINANG*XMIN + COSANG*YMIN + 0.5
            LX4 = COSANG*XMIN + SINANG*YMAX + 0.5
            LY4 =-SINANG*XMIN + COSANG*YMAX + 0.5
            LX3 = COSANG*XMAX + SINANG*YMAX + 0.5
            LY3 =-SINANG*XMAX + COSANG*YMAX + 0.5
            LX2 = COSANG*XMAX + SINANG*YMIN + 0.5
            LY2 =-SINANG*XMAX + COSANG*YMIN + 0.5
C
C *** SHOT POINTS DECREASING WITH Y
C
         ELSE
            WRITE (IPR, 3368)
 3368       FORMAT(//, 18X, '*** SHOT POINTS DECREASING WITH Y) ***'//)
            LX4 = COSANG*XMIN + SINANG*YMIN + 0.5
            LY4 =-SINANG*XMIN + COSANG*YMIN + 0.5
            LX1 = COSANG*XMIN + SINANG*YMAX + 0.5
            LY1 =-SINANG*XMIN + COSANG*YMAX + 0.5
            LX2 = COSANG*XMAX + SINANG*YMAX + 0.5
            LY2 =-SINANG*XMAX + COSANG*YMAX + 0.5
            LX3 = COSANG*XMAX + SINANG*YMIN + 0.5
            LY3 =-SINANG*XMAX + COSANG*YMIN + 0.5
         END IF
      END IF
C
C *** PRINT COMPUTED CORNERS
C
      WRITE (IPR, 310) LX1,LY1,LX2,LY2,LX3,LY3,LX4,LY4,NLIS,NDIS,DX,DY,
     &                 GISIZE, NTRCS, IFSPNO, IDP2SP
  310 FORMAT (//, 10X,'COMPUTED GRID CORNERS FOR LINE',/,
     &         /, 23X, '  X FOR CORNER 1. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 1. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 2. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 2. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 3. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 3. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 4. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 4. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  NUMBER OF LINE INDEXES. . . . .',1X,I9  ,
     &         /, 23X, '  NUMBER OF DEPTH INDEXES . . . .',1X,I9  ,
     &         /, 23X, '  INLINE SPACING. . . . . . . . .',1X,F9.4,
     &         /, 23X, '  CROSSLINE SPACING . . . . . . .',1X,F9.4,
     &         /, 23X, '  LARGEST GI NUMBER . . . . . . .',1X,I9  ,
     &         /, 23X, '  NUMBER OF TRACES PER RECORD . .',1X,I9  ,
     &         /, 23X, '  FIRST SOURCE POINT NUMBER . . .',1X,I9  ,
     &         /, 23X, '  NUMBER OF DIS PER S.P. INC. . .',1X,I9  )
C
C *** ALLOCATE BUFFERS FOR GI NUMBERS, FOLD DIAGRAM, SP ABOVE DI,
C *** FLOATING DATUM.
C
c---------------------------------------------

c	allocate memory for needed buffers

c---------------------------------------------

	iget = gisize * SZSMPD

        call galloc (iigx, iget, errcd, abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for IGX'

           write(LERR,*) 'FATAL'

           stop 999

        endif

        call galloc (iigy, iget, errcd, abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for IGY'

           write(LERR,*) 'FATAL'

           stop 999

        endif

        call galloc (iige, iget, errcd, abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for IGE'

           write(LERR,*) 'FATAL'

           stop 999

        endif

        call galloc (iigrrs, iget, errcd, abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for IGRRS'

           write(LERR,*) 'FATAL'

           stop 999

        endif

c-----------------------------------------------

c	clear allocated memory buffers to zero

c-----------------------------------------------

	call move (0, igx, 0, iget)

	call move (0, igy, 0, iget)

	call move (0, ige, 0, iget)

	call move (0, igrrs, 0, iget)

C
C *** READ 1PR3D CARD
C
      READ (ICR,360,END=9000) CARD,MODE,ISRECO,NDREC,INCREC,NTRCS,
     $                IMETER,LHHOLD

c.c  $                IMETER,(I4LHDR(I),I=1,12)
c.360 FORMAT (A80,T7,I1,4I5,T48,I1,T28,12A4)
  360 FORMAT (A80,T7,I1,4I5,T48,I1,T28,A48)

cmam	call savew(I4LHDR, 'EqpCod', LHHOLD(1:1), LINHED)
	call savew2(I4LHDR,j_EqpCod,i_EqpCod,l_EqpCod,LHHOLD(1:1),
     *			LINHED)

cmam	call savew(I4LHDR, 'CrwNam', LHHOLD(2:7), LINHED)
	call savew2(I4LHDR,j_CrwNam,i_CrwNam,l_CrwNam,LHHOLD(2:7),
     *			LINHED)

cmam	call savew(I4LHDR, 'DatTyp', LHHOLD(8:8), LINHED)
	call savew2(I4LHDR,j_DatTyp,i_DatTyp,l_DatTyp,LHHOLD(8:8),
     *			LINHED)

cmam	call savew(I4LHDR, 'DgTrkS', LHHOLD(9:10), LINHED)
	call savew2(I4LHDR,j_DgTrkS,i_DgTrkS,l_DgTrkS,LHHOLD(9:10),
     *			LINHED)

cmam	call savew(I4LHDR, 'PrcNam', LHHOLD(11:20), LINHED)
	call savew2(I4LHDR,j_PrcNam,i_PrcNam,l_PrcNam,LHHOLD(11:20),
     *			LINHED)

cmam	call savew(I4LHDR, 'PrcDat', LHHOLD(25:32), LINHED)
	call savew2(I4LHDR,j_PrcDat,i_PrcDat,l_PrcDat,LHHOLD(25:32),
     *			LINHED)

cmam	call savew(I4LHDR, 'OACLin', LHHOLD(33:40), LINHED)
	call savew2(I4LHDR,j_OACLin,i_OACLin,l_OACLin,LHHOLD(33:40),
     *			LINHED)

cmam	call savew(I4LHDR, 'JobNum', LHHOLD(41:48), LINHED)
	call savew2(I4LHDR,j_JobNum,i_JobNum,l_JobNum,LHHOLD(41:48),
     *			LINHED)

C
      IF (IDRY .EQ. 0) THEN
         IF (MODE .EQ. 0) CALL HLHprt (I4LHDR,NUMBYT,HLH0,NHLH0,LERR)

         IF (MODE .EQ. 1) CALL HLHprt (I4LHDR,NUMBYT,HLH1,NHLH1,LERR)

         IF (MODE .EQ. 2) CALL HLHprt (I4LHDR,NUMBYT,HLH2,NHLH2,LERR)

      ELSE
         IF (ISRECO .EQ. 0) ISRECO = 1
         IF (NDREC  .LE. 0) NDREC  = NSORC
         IF (INCREC .EQ. 0) INCREC = 1
         IF (NTRCS  .LE. 0) NTRCS  = 1
         ISREC = ISRECO
cmam     IF (NTRCS .GT. 1024) THEN
         IF (NTRCS .GT. 2048) THEN

            WRITE (IPR, 363) NTRCS
  363       FORMAT ('0** M3069 ERROR DETECTED BY PROGRAM PR3D:',/,
cmam $       13X,'NUMBER OF TRACES (',I4,'EXCEEDS 1024',/,
     $       13X,'NUMBER OF TRACES (',I4,'EXCEEDS 2048',/,

     $       13X,'CHECK CC 24-27 ON THE 1PR3D CARD AND RETRY',/)
            ICC = 100
         END IF
         WRITE (IPR, 365) ISREC,NDREC,INCREC,NTRCS
  365    FORMAT(//, 18X, '*** DRY RUN (NO INPUT/OUTPUT DATASET) ***',
     $        /, 10X, 'STARTING RECORD NUMBER . . . . . . ', 1X,  I5,
     $        /, 10X, 'NUMBER OF RECORDS. . . . . . . . . ', 2X,  I4,
     $        /, 10X, 'RECORD NUMBER INCREMENT. . . . . . ', 1X,  I5,
     $        /, 10X, 'NUMBER OF TRACES PER RECORD. . . . ', 2X,  I4,//)
         NOTPSR = NTRCS
         NOSREC = NDREC
         IFOR   = 3
         ITRLEN = 100
         NBO    = 0
         NUMBYT = 0
      END IF
C
  400 FORMAT (A80)
      CALL WRCARD (CARD,1,IPR)
C
      IF (CARD(1:5) .EQ. '1PR3D') GO TO 500
      WRITE (IPR,450)
  450 FORMAT('0** M3004 ** ERROR DETECTED BY PROGRAM PR3D:'         /
     $         13X, 'THE CARD MNEMONIC (CC 1-5) OF THE FIRST '      ,
     $              'INPUT PARAMETER CARD IS NOT'                   /
     $         13X, 'SPECIFIED AS 1PR3D'                            /)
      ICC = 100
      IF (IMETER .LT. 0. .OR. IMETER .GT. 1) THEN
         WRITE (IPR,460)
  460    FORMAT('0** M0460 ** ERROR DETECTED BY PROGRAM PR3D:'   /
     $         13X, 'THE FEET/METERS FLAG IS INVALID'            ,
     $              'THE MINIMUM IS 0 AND THE MAXIMUM IS 1'      /
     $         13X, 'CHECK CC 48 OF THE 1PR3D AND RETRY.'        /)
         ICC = 100
      END IF
C
  500 IF (MODE.EQ.0) GO TO 770
      IF (MODE.EQ.1.OR.MODE.EQ.2) GO TO 760
      WRITE (IPR,750) MODE
  750 FORMAT ('0** M3031 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $ 13X,'AN INVALID MODE (',I1,') WAS SPECIFIED IN COLUMN 7 ' ,
     $     'OF THE 1PR3D CARD')
      ICC = 100
C
  760 INDXNG = .TRUE.
C
C-----------------------------------------------------------------------
C     READ & VERIFY THE 2PR3D PARAMETER CARD
C-----------------------------------------------------------------------
C
  770 READ (ICR,400,END=9000) CARD
      CALL WRCARD (CARD,3,IPR)
C
      IF (CARD(1:5) .EQ. '2PR3D') GO TO 800
      WRITE (IPR,780)
  780 FORMAT('0** M3005 ** ERROR DETECTED BY PROGRAM PR3D:'         /
     $         13X, 'THE CARD MNEMONIC (CC 1-5) OF THE SECOND '     ,
     $              'INPUT PARAMETER CARD IS NOT'                   /
     $         13X, 'SPECIFIED AS 2PR3D'                            /)
      ICC = 100
C
  800 IF (ICC .NE. 0) GO TO 9400
C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
C     CALL STRING (CARD,80)
      READ (CARD,900)   SORTYP, FOLD  , GRPINT, JRRS  , SWVELJ,
     $                  MAXSPE, MINSPE, MAXRSE, MINRSE, MAXGE ,
     $                  MINGE , MAXTS , MINTS , JBRIEF, IBRIEF
C     DECODE (CARD,900) SORTYP, FOLD  , GRPINT, JRRS  , SWVELJ,
C    $                  MAXSPE, MINSPE, MAXRSE, MINRSE, MAXGE ,
C    $                  MINGE , MAXTS , MINTS , JBRIEF, IBRIEF
C=======================================================================
C=======================================================================
  900 FORMAT (          6X,A2 , I3    , A4    , I5    , F5.0  ,
     $                  1X,I4 , I4    , I4    , I4    , I4    ,
     $                  I4    , I5    , I5    , 18X,I1, I1    )
C
      IF (GRPINT.EQ.'    ') THEN
         WRITE (GRPINT, 895) DIST
  895    FORMAT (F4.1)
      END IF
C
C-----------------------------------------------------------------------
C     INSERT VALUES READ FROM 2PR3D CARD INTO LINE HEADER
C-----------------------------------------------------------------------
C
cmam	call savew(I2LHDR,'CDPFld',fold,0)
	call savew2(I4LHDR,j_CDPFld,i_CDPFld,l_CDPFld,fold,LINHED)

C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
cmam	call savew(I2LHDR,'SrtTyp',SORTYP,0)
	call savew2(I4LHDR,j_SrtTyp,i_SrtTyp,l_SrtTyp,sortyp,LINHED)

cmam	call savew(I2LHDR,'GrpInt',GRPINT,0)
	call savew2(I4LHDR,j_GrpInt,i_GrpInt,l_GrpInt,grpint,LINHED)

C     CALL ASCEBC (SORTYP,0,I2LHDR(37),0,2,IER)
C     IF (IER.EQ.0) GO TO 920
C     WRITE (IPR,910) IER
C 910 FORMAT ('0** M3098 ** ERROR DETECTED BY PROGRAM PR3D:'/
C    $ 13X,'ERROR ATTEMPTING TO CONVERT SORT TYPE ',
C    $     'ON 2PR3D CARD TO EBCDIC'/
C    $ 13X,'RETURN CODE FROM ASCEBC =',I3)
C     ICC = 100
C 920 CALL ASCEBC (GRPINT,0,I4LHDR(20),0,4,IER)
C     IF (IER.EQ.0) GO TO 940
C     WRITE (IPR,930) IER
C 930 FORMAT ('0** M3099 ** ERROR DETECTED BY PROGRAM PR3D:'/
C    $ 13X,'ERROR ATTEMPTING TO CONVERT GROUP INTERVAL ',
C    $     'ON 2PR3D CARD TO EBCDIC'/
C    $ 13X,'RETURN CODE FROM ASCEBC =',I3)
C     ICC = 100
C 940 CONTINUE
C=======================================================================
C=======================================================================
C
C
      IF (MAXSPE .EQ. 0)  MAXSPE = ISEMAX
      IF (MINSPE .EQ. 0)  MINSPE = ISEMIN
      IF (MAXGE  .EQ. 0)  MAXGE  = IEMAX
      IF (MINGE  .EQ. 0)  MINGE  = IEMIN
      IF (MAXRSE .EQ. 0)  MAXRSE = MAXRRS
      IF (MINRSE .EQ. 0)  MINRSE = MINRRS
      IF (SWVELJ .LE. 0) THEN
         IF (IMETER .EQ. 1) THEN
            SWVELJ = 1478
         ELSE
            SWVELJ = 4850
         END IF
      END IF
      IF (MAXTS  .EQ. 0)  MAXTS  = NINT
     &                           ( FLOAT (MAXRSE - MIN(MINSPE,MINGE))
     &                           / SWVELJ * 1000.)
      IF (MINTS  .EQ. 0)  MINTS  = NINT
     &                           ( FLOAT (MINRSE - MAX(MAXSPE,MAXGE))
     &                           / SWVELJ * 1000.)
cmam	call savew(I2LHDR,'MxSPEl',MAXSPE,0)
	call savew2(I4LHDR,j_MxSPEl,i_MxSPEl,l_MxSPEl,MAXSPE,LINHED)

cmam	call savew(I2LHDR,'MnSPEl',MINSPE,0)
	call savew2(I4LHDR,j_MnSPEl,i_MnSPEl,l_MnSPEl,MINSPE,LINHED)

cmam	call savew(I2LHDR,'MxRSEL',MAXRSE,0)
	call savew2(I4LHDR,j_MxRSEL,i_MxRSEL,l_MxRSEL,MAXRSE,LINHED)

cmam	call savew(I2LHDR,'MnRSEL',MINRSE,0)
	call savew2(I4LHDR,j_MnRSEL,i_MnRSEL,l_MnRSEL,MINRSE,LINHED)

cmam	call savew(I2LHDR,'MxGrEl',MAXGE, 0)
	call savew2(I4LHDR,j_MxGrEl,i_MxGrEl,l_MxGrEl,MAXGE,LINHED)

cmam	call savew(I2LHDR,'MnGrEl',MINGE, 0)
	call savew2(I4LHDR,j_MnGrEl,i_MnGrEl,l_MnGrEl,MINGE,LINHED)

cmam	call savew(I2LHDR,'MxTrSt',MAXTS, 0)
	call savew2(I4LHDR,j_MxTrSt,i_MxTrSt,l_MxTrSt,MAXTS,LINHED)

cmam	call savew(I2LHDR,'MnTrSt',MINTS, 0)
	call savew2(I4LHDR,j_MnTrSt,i_MnTrSt,l_MnTrSt,MINTS,LINHED)

cmam	call savew(I2LHDR,'MxShDp',ISDMAX,0)
	call savew2(I4LHDR,j_MxShDp,i_MxShDp,l_MxShDp,ISDMAX,LINHED)

cmam	call savew(I2LHDR,'MnShDp',ISDMIN,0)
	call savew2(I4LHDR,j_MnShDp,i_MnShDp,l_MnShDp,ISDMIN,LINHED)

cmam	call savew(I2LHDR,'MxUHTm',IUTMAX,0)
	call savew2(I4LHDR,j_MxUHTm,i_MxUHTm,l_MxUHTm,IUTMAX,LINHED)

cmam	call savew(I2LHDR,'MnUHTm',IUTMIN,0)
	call savew2(I4LHDR,j_MnUHTm,i_MnUHTm,l_MnUHTm,IUTMIN,LINHED)

cmam	call savew(I2LHDR,'UnitFl',IMETER,0)
	call savew2(I4LHDR,j_UnitFl,i_UnitFl,l_UnitFl,IMETER,LINHED)

cmam	call savew(I2LHDR,'StWdFl',2,     0)
	call savew2(I4LHDR,j_StWdFl,i_StWdFl,l_StWdFl,2,LINHED)

      IF (SWVELJ .LE. 0) THEN
         IF (IMETER .EQ. 1) THEN
            SWVELJ = 1478
         ELSE
            SWVELJ = 4850
         END IF
      END IF
	refvel = SWVELJ + .5

cmam	call savew(I4LHDR,'RefVel',refvel,0)
	call savew2(I4LHDR,j_RefVel,i_RefVel,l_RefVel,refvel,LINHED)

C
C-----------------------------------------------------------------------
C     PRINT USER PARAMETERS FROM THE 2PR3D CARD
C-----------------------------------------------------------------------
C
C     CALL STRING (SORTYP, 2)
      READ (SORTYP, 955) I
  955 FORMAT (I2)
      WRITE (IPR,950) I     , MAXSPE, MINSPE, MAXRSE, MINRSE,
     $                FOLD  , MAXGE , GRPINT, MINGE , JRRS  ,
     $                MAXTS , SWVELJ, MINTS , MODE
  950 FORMAT(//  18X, 'SORT TYPE  . . . . . . . . . . . . ', 4X,  I2,
     $           10X, 'MAX SOURCEPOINT ELEVATION  . . . . ', 2X,  I4  /
     $           18X, '   0 = FIRST IN - FIRST OUT        ',
     $           16X, 'MIN SOURCEPOINT ELEVATION  . . . . ', 2X,  I4  /
     $           18X, '   1 = LARGE ARROWHEAD             ',
     $           16X, 'MAX REGIONAL REFERENCE SURFACE . . ', 2X,  I4  /
     $           18X, '   2 = ECHELON                     ',
     $           16X, 'MIN REGIONAL REFERENCE SURFACE . . ', 2X,  I4  /
     $           18X, 'FOLD . . . . . . . . . . . . . . . ', 2X,  I4,
     $           10X, 'MAX GROUP ELEVATION  . . . . . . . ', 2X,  I4  /
     $           18X, 'GROUP INTERVAL . . . . . . . . . . ', 2X,  A4,
     $           10X, 'MIN GROUP ELEVATION  . . . . . . . ', 2X,  I4  /
     $           18X, 'REGIONAL REFERENCE SURFACE . . . . ',      I6,
     $           10X, 'MAX TRACE STATIC . . . . . . . . . ', 1X,  I5  /
     $           18X, 'SUBWEATHERING VELOCITY . . . . . . ', 1X,F6.0,
     $            9X, 'MIN TRACE STATIC . . . . . . . . . ', 1X,  I5  /
     $           18X, 'MODE . . . . . . . . . . . . . . . ', 2X,  I4  /
     $           18X, '   0 = PREPROCESSING ONLY'/
     $           18X, '   1 = PREPROCESSING WITH INDEXING'/
     $           18X, '   2 = INDEXING ONLY'//)
C
      SWVELJ = 4000.0 / SWVELJ
C
      READ (ICR,400,END=9000) CARD
      IF (INDXNG) GO TO 1000
      IF (CARD(1:5).NE.'3PR3D') GO TO 1055
      CALL WRCARD (CARD,5,IPR)
      GO TO 1050
C
 1000 CALL WRCARD (CARD,1,IPR)
      IF (CARD(1:5).EQ.'3PR3D') GO TO 1030
      WRITE (IPR,1020)
 1020 FORMAT ('0** M3032 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $ 13X,'WHEN INDEXING (MODE = 1 OR 2), 3PR3D AND 4PR3D CARDS '  ,
     $     'ARE REQUIRED'/
     $ 13X,'PLEASE CORRECT YOUR INPUT CARD DECK BEFORE RESUBMITTING'/)
      ICC = 100
      GO TO 9400
C
 1030 CONTINUE
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
C     CALL STRING (CARD,80)
      READ (CARD,1040)   IX1,IY1, IX2,IY2, DY, DX
C     DECODE (CARD,1040) IX1,IY1, IX2,IY2, DY, DX
C=======================================================================
C=======================================================================
 1040 FORMAT (14X,I8, I8,2X,I8, I8,2X,F6.0,F6.0)
C
 1050 READ (ICR,400,END=9000) CARD
 1055 IF (INDXNG) GO TO 1057
      IF (CARD(1:5).NE.'4PR3D') GO TO 1100
      CALL WRCARD (CARD,3,IPR)
      GO TO 1090
C
 1057 CALL WRCARD (CARD,3,IPR)
      IF (CARD(1:5).EQ.'4PR3D') GO TO 1070
      WRITE (IPR,1060)
 1060 FORMAT ('0** M3029 ** ERROR DETECTED BY PROGRAM PR3D:'         /
     $ 13X,'WHEN INDEXING (MODE = 1 OR 2), A 3PR3D MUST BE FOLLOWED ',
     $     'BY A 4PR3D CARD'/
     $ 13X,'PLEASE CORRECT YOUR INPUT CARD DECK BEFORE RESUBMITTING' /)
      ICC = 100
      GO TO 9400
C
 1070 CONTINUE
 1071 FORMAT (14X,   I8, I8,2X,I8, I8, 2X,I5,I5)
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
      READ (CARD,1071)   IX3,IY3,IX4,IY4,LI1,DI1
      IF (IX1 .EQ. 0) IX1 = LX1
      IF (IY1 .EQ. 0) IY1 = LY1
      IF (IX2 .EQ. 0) IX2 = LX2
      IF (IY2 .EQ. 0) IY2 = LY2
      IF (IX3 .EQ. 0) IX3 = LX3
      IF (IY3 .EQ. 0) IY3 = LY3
      IF (IX4 .EQ. 0)
     $   IX4 = IX1 + IX3 - IX2
      IF (IY4 .EQ. 0)
     $   IY4 = IY1 + IY3 - IY2
      WRITE  (HLHMSG,1072) IX1,IY1
C=======================================================================
C=======================================================================
      IF (IDRY .EQ. 0)
     $CALL HLHprt (I4LHDR,NUMBYT,HLHMSG,34,LERR)

C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
      WRITE  (HLHMSG,1074) IX2,IY2
C=======================================================================
C=======================================================================
      IF (IDRY .EQ. 0)
     $CALL HLHprt (I4LHDR,NUMBYT,HLHMSG,34,LERR)

C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
      WRITE (HLHMSG,1076) IX3,IY3
C=======================================================================
C=======================================================================
      IF (IDRY .EQ. 0)
     $CALL HLHprt (I4LHDR,NUMBYT,HLHMSG,34,LERR)

C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
      WRITE  (HLHMSG,1078) IX4,IY4
C=======================================================================
C=======================================================================
      IF (IDRY .EQ. 0)
     $CALL HLHprt (I4LHDR,NUMBYT,HLHMSG,34,LERR)

C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
      WRITE  (HLHMSG,1079) DX,DY
C=======================================================================
C=======================================================================
      IF (IDRY .EQ. 0)
     $CALL HLHprt (I4LHDR,NUMBYT,HLHMSG,26,LERR)

 1072 FORMAT ('     (CORNER 1: ',I8,',',I8,')')
 1074 FORMAT ('     (CORNER 2: ',I8,',',I8,')')
 1076 FORMAT ('     (CORNER 3: ',I8,',',I8,')')
 1078 FORMAT ('     (CORNER 4: ',I8,',',I8,')')
 1079 FORMAT ('     (DX=',F6.1,' DY=',F6.1,')')
C
      IF(LI1 .EQ. 0) LI1 = 1
      IF(DI1 .EQ. 0) DI1 = 1
C
      WRITE (IPR,1080) DY,DX,IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,LI1,DI1
 1080 FORMAT (// ,
     $        18X,'CELL INCREMENTS'                              /
     $        18X,'   SIDE 1-2 . . . . . . . . . . . . ',2X,F6.1 /
     $        18X,'   SIDE 2-3 . . . . . . . . . . . . ',2X,F6.1 /
     $        18X,'CORNER COORDINATES'                           /
     $        18X,'   CORNER 1 - X . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 1 - Y . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 2 - X . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 2 - Y . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 3 - X . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 3 - Y . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 4 - X . . . . . . . . . . ',I8      /
     $        18X,'   CORNER 4 - Y . . . . . . . . . . ',I8      /
     $        18X,'STARTING INDEX NUMBERS'                       /
     $        18X,'   LINE  INDEX  . . . . . . . . . . ',I8      /
     $        18X,'   DEPTH INDEX  . . . . . . . . . . ',I8      )
C
      CALL XFMI (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,ISIGN,
     $           IPR,ICC)
      IF (ICC.NE.0) GO TO 9400
      CALL ILIDI (ISX1,ISY1,ISLI1,ISDI1,IWARN)
      NXY = NX * NY
      WRITE (IPR,1086) NXY,NX,NY,ISDI1
 1086 FORMAT ('0** M3028 ** MESSAGE FROM PROGRAM PR3D:'          /
     $ 13X,'THE GRID CONTAINS',I10,' CELLS WITH ',
     $  I7,' DEPTH INDEXES AND ',
     $  I7,' LINE INDEXES AND ',                                 /
     & 13X,'THE DEPTH POINT BELOW THE FIRST SOURCE POINT IS ', I10,'.'/)
C
cmam	call savew(I2LHDR,'FrstSP',IFSPNO,0)
	call savew2(I4LHDR,j_FrstSP,i_FrstSP,l_FrstSP,IFSPNO,LINHED)

cmam	call savew(I2LHDR,'DpN1SP',ISDI1, 0)
	call savew2(I4LHDR,j_DpN1SP,i_DpN1SP,l_DpN1SP,ISDI1,LINHED)

cmam	call savew(I2LHDR,'NmDpIn',IDP2SP,0)
	call savew2(I4LHDR,j_NmDpIn,i_NmDpIn,l_NmDpIn,IDP2SP,LINHED)

cmam	call savew(I2LHDR,'MnLnIn',LI1,   0)
	call savew2(I4LHDR,j_MnLnIn,i_MnLnIn,l_MnLnIn,LI1,LINHED)

	li1ny = LI1 + NY - 1

cmam	call savew(I2LHDR,'MxLnIn',li1ny, 0)
	call savew2(I4LHDR,j_MxLnIn,i_MxLnIn,l_MxLnIn,li1ny,LINHED)

cmam	call savew(I2LHDR,'MnDpIn',DI1,   0)
	call savew2(I4LHDR,j_MnDpIn,i_MnDpIn,l_MnDpIn,DI1,LINHED)

	idi1nx = DI1 + NX - 1

cmam	call savew(I2LHDR,'MxDpIn',idi1nx,0)
	call savew2(I4LHDR,j_MxDpIn,i_MxDpIn,l_MxDpIn,idi1nx,LINHED)

	idxp5 = DX + .5

cmam	call savew(I2LHDR,'DptInt',idxp5, 0)
	call savew2(I4LHDR,j_DptInt,i_DptInt,l_DptInt,idxp5,LINHED)

      X9 = IX1 - IX4
      Y9 = IY1 - IY4
      AZMUTH            = 0.0
      IF (X9.NE.0.0 .OR. Y9.NE.0.0) AZMUTH = ATAN2(Y9,X9)*57.29577951
      IF (AZMUTH+45. .GE. 0. .AND. AZMUTH+45. .LE. 180.) THEN
	 ipldir = 0

      ELSE
	 ipldir = 1

      END IF
cmam	call savew(I2LHDR,'PltDir',ipldir,0)
	call savew2(I4LHDR,j_PltDir,i_PltDir,l_PltDir,ipldir,LINHED)

      IF (AZMUTH .LT. 0.) AZMUTH = AZMUTH + 360.
      IAZ = AZMUTH / 90. + 1.
      IAZM = AZMUTH * AZMSGN(IAZ) + AZBIAS(IAZ) + 0.5
c.c.c.c.......check this.....line direction aaaa < aiia.

      WRITE (LHC4,1089) CDIR(IAZ), IAZM, CBEAR(IAZ)
c.c   WRITE (C4LHDR(26),1089) CDIR(IAZ), IAZM, CBEAR(IAZ)
 1089 FORMAT (A1,I2, A1)
cmam	call savew(I4LHDR, 'LinDir', LHC4, LINHED)
	call savew2(I4LHDR,j_LinDIr,i_LinDIr,l_LinDIr,LHC4,LINHED)

cmam	call savew(I4LHDR,'ILClIn',DX,0)
	call savew2(I4LHDR,j_ILClIn,i_ILClIn,l_ILClIn,DX,LINHED)

cmam	call savew(I4LHDR,'CLClIn',DY,0)
	call savew2(I4LHDR,j_CLClIn,i_CLClIn,l_CLClIn,DY,LINHED)

      LIBIAS     = LI1 - 1
      DIBIAS     = DI1 - 1
	iget = NXY * SZSMPD

c---------------------------------------------

c       allocate memory for needed buffers

c---------------------------------------------

	if(iget.lt.1) iget = 16

   	call galloc(ikount,iget,errcd,abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for KOUNT'

           write(LERR,*) 'FATAL'

           stop 999

        endif

        call galloc(idatum,iget,errcd,abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for FDATUM'

           write(LERR,*) 'FATAL'

           stop 999

        endif

        call galloc(ispabv,iget,errcd,abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for SPABOV'

           write(LERR,*) 'FATAL'

           stop 999

        endif

c-----------------------------------------------

c       clear allocated memory buffers to zero

c-----------------------------------------------

        call move (0, KOUNT,  0, iget)

        call move (0, FDATUM, 0, iget)

        call move (0, SPABOV, 0, iget)

C
C=======================================================================
C     UPDATE LINE HEADER FIELD HISTORY INFORMATION IF REQUESTED
C=======================================================================
C
C-----------------------------------------------------------------------
C     READ A PARAMETER CARD & CHECK FOR FIELD HISTORY CARD
C-----------------------------------------------------------------------
C
 1090 READ  (ICR,400,END=9000) CARD
 1100 IF (CARD(1:5) .NE. '1FLDH') GO TO 1180
C
      CALL FLDH (CARD,L1LHDR,I4LHDR,ICR,IPR,NUMBYT,*9000)
 1180 IF (.NOT.INDXNG) GO TO 1190
      CALL MOVE (1,I4LISV,I4LHDR,NUMBYT)
      IBTCNT = NUMBYT
      GO TO 1220
C
 1190 CONTINUE
      IF (IDRY .EQ. 0)
     $CALL WRTAPE (LUOUT,I4LHDR,NUMBYT)
C
c.c   WRITE (IPR,1200) NUMBYT,( L1LHDR(I),I=1,NUMBYT)
c1200 FORMAT(/   6X, 'OUTPUT LINE HEADER (', I4, ' BYTES LONG):',
c.c  $      // (5X,20(1X,4a1)))
C
 1220 WRITE (IPR,1230)
 1230 FORMAT('1')
C
C=======================================================================
C     PROCESS GROUP LOCATIONS
C=======================================================================
C
C-----------------------------------------------------------------------
C     READ & VERIFY THE 1GRUP PARAMETER CARD
C-----------------------------------------------------------------------
C
      NG                = 1
      IF((I5SPRD .EQ. 0) .AND.
     &   (JBRIEF .EQ. 0)) CALL WRCARD (CARD,2,IPR)
      GO TO 1350
C
 1300 READ  (ICR,400,END=9000) CARD
C
 1350 IF (CARD(1:5) .NE. '1GRUP') GO TO 2030
      IF((I5SPRD .EQ. 0) .AND.
     &   (JBRIEF .EQ. 0)) CALL WRCARD (CARD,3,IPR)
C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
      READ  (CARD,1400) IX  , IY  ,   IE, IRRS ,  IG
C=======================================================================
C=======================================================================
 1400 FORMAT(         T7,I8 , I8, T33,I5, I5, T71,I10)
C
C-----------------------------------------------------------------------
C     GI ON FIRST 1GRUP CARD MUST BE 1, OTHERWISE, ERROR
C     GI MAGNITUDE MUST CONFORM TO PROGRAM RESTRICTION (MAX = 32000)
C-----------------------------------------------------------------------
C
      IF ((NG .NE. 1) .OR. (IG .EQ. 1)) GO TO 1500
      WRITE (IPR,1450)
 1450 FORMAT('0** M3006 ** ERROR DETECTED BY PROGRAM PR3D:'         /
     $         13X, 'THE GROUP INDEX NUMBER (CC 76-80) ON THE '     ,
     $              'FIRST 1GRUP PARAMETER CARD'                    /
     $         13X, 'IS NOT SPECIFIED AS 1'                         /
     $         13X, 'VERIFY THIS ENTRY, AND AMEND IF NECESSARY'     /)
      ICC = 100
      GO TO 9400
C
 1500 IF (IG .LE. GISIZE) GO TO 1600
      WRITE (IPR,1550) GISIZE
 1550 FORMAT('0** M3007 ** ERROR DETECTED BY PROGRAM PR3D:'         /
     $         13X, 'A 1GRUP PARAMETER CARD HAS A GROUP INDEX '     ,
     $              'EXCEEDING THE PROGRAM LIMIT'                   /
     $         13X, 'PROGRAM PR3D CAN ACCEPT GROUP INDEX NUMBERS '  ,
     $              'UP TO A MAXIMUM OF ', I5                       /)
      ICC = 100
      GO TO 9400
C
C-----------------------------------------------------------------------
C     FILL REGIONAL REFERENCE SURFACE WITH DEFAULT VALUE
C     FILL GI BUFFERS WITH SURFACE STATION INFORMATION
C          1- X-COORDINATE
C          2- Y-COORDINATE
C          3- GROUP ELEVATION
C          4- GROUP REGIONAL REFERENCE SURFACE
C-----------------------------------------------------------------------
C
 1600 IF (IRRS .EQ. 0) IRRS = JRRS
C
      IGX  (IG)  = IX

      IGY  (IG)  = IY

      IGE  (IG)  = IE

      IGRRS(IG)= IRRS

C
C-----------------------------------------------------------------------
C     INTERPOLATE GROUP INFORMATION IF NEEDED
C-----------------------------------------------------------------------
C
      IF (NG .EQ. IG) GO TO 1800
C
      LG                = NG - 1
      N                 = IG - NG
      DIF               = N + 1
C
      DO 1700 I = 1,N
C
         IIG            = LG + I
         R              = I  / DIF
C
         IGX  (IIG) =

     &   IGX  (LG ) + R *

     &  (IGX  (IG ) -

     &   IGX  (LG ))+ 0.5

         IGY  (IIG) =

     &   IGY  (LG ) + R *

     &  (IGY  (IG ) -

     &   IGY  (LG ))+ 0.5

         IGE  (IIG) =

     &   IGE  (LG ) + R *

     &  (IGE  (IG ) -

     &   IGE  (LG ))+ 0.5

         IGRRS(IIG) =

     &   IGRRS(LG ) + R *

     &  (IGRRS(IG ) -

     &   IGRRS(LG ))+ 0.5

C
 1700 CONTINUE
C
C-----------------------------------------------------------------------
C     KEEP TRACK OF LAST GROUP PROCESSED
C     GO READ ANOTHER CARD
C-----------------------------------------------------------------------
C
 1800 NG                = IG + 1
      GO TO 1300
C
C-----------------------------------------------------------------------
C     PRINT INFORMATION ABOUT GROUP LOCATIONS IN TABLE FORM
C-----------------------------------------------------------------------
C
 2030 NG                = NG - 1
C
      WRITE (IPR,1230)
      IF (JBRIEF .EQ.  0) GO TO 2050
      WRITE (IPR,2040)
 2040 FORMAT(1X, '** DETAILED GROUP INFORMATION HAS BEEN SUPPRESSED **')
	write(IPR,1230)

	go to 2075

C
 2050 IF (I5SPRD .EQ. 0) THEN
      WRITE (IPR,2060) (I,IGX  (I),

     &                    IGY  (I),

     &                    IGE  (I),

     &                    IGRRS(I),I=1,NG)

 2060 FORMAT(/ 1X,  'GROUP          X              Y                  ',
     $          5X, 'REFERENCE',
     $       / 1X,  'INDEX     COORDINATE     COORDINATE     ELEVATION',
     $          5X, ' SURFACE '  /                                     ,
     $      (   1X, I5, 6X, I8, 7X, I8, 8X, I5, 9X, I5   )             )
C
 2070 WRITE (IPR,1230)
      END IF
 2075 continue

C
C=======================================================================
C     PROCESS SOURCE LOCATIONS & ASSOCIATED SPREAD CONFIGURATIONS
C=======================================================================
C
      IF (.NOT.INDXNG) GO TO 4810
C
c.c	jcrd = 76

c.c	kcrd = 75

c.c     open(unit=jcrd, form='formatted', status='scratch',

c.c  *          access='sequential',iostat=istat)

c.c     open(unit=kcrd, form='formatted', status='scratch',

c.c  *          access='sequential',iostat=istat)



	open(unit=icrd, form='formatted', status='scratch',

     *		access='sequential',iostat=istat)

c.c	inquire(icrd, name=fn1,iostat=istat)

c.c	inquire(jcrd, name=fn2,iostat=istat)

c.c	inquire(kcrd, name=fn3,iostat=istat)

c.c	print *,'icrd fn1=',fn1

c.c	print *,'jcrd fn2=',fn2

c.c	print *,'kcrd fn3=',fn3



C
c.c   WRITE (JCRD,2080) CARD
c.c   WRITE (KCRD,2080) CARD
      WRITE (ICRD,2080) CARD
 2080 FORMAT (A80)
C
      DO 4800 IR = 1,NOSREC
C
C-----------------------------------------------------------------------
C            VERIFY THE 1SORC PARAMETER CARD
C-----------------------------------------------------------------------
C
         IF (EOCC) GO TO 9280
C
         IF (CARD(1:5) .NE. '1SORC') GO TO 4807
C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
         READ (CARD,2300)   ISX   , ISY   , IXO   , IYO   , ISE   ,
     $                      ISRRS , ISD   , IUT   , ISPNO , ASPNO ,
     $                      NSEG  , IRI
C=======================================================================
C=======================================================================
 2300    FORMAT(            T7,I8 , I8    , 1X,I4 , I4    , 1X,I5 ,
     $                      I5    , 1X,I4 , I4    , I5    , A1    ,
     $                      I5    , T71,I10)
C
C-----------------------------------------------------------------------
C     FILL SOURCE REGIONAL REFERENCE SURFACE IF DEFAULTED
C     CALCULATE X-COORDINATE & Y-COORDINATE IF GIVEN AN OFFSET
C-----------------------------------------------------------------------
C
         IF (ISPNO .EQ. 0) ISPNO = IRI
         IF (ISRRS .EQ. 0) ISRRS = JRRS
C
         ISX                     = ISX + IXO
         ISY                     = ISY + IYO
C
C-----------------------------------------------------------------------
C     NUMBER OF SPREAD SEGMENTS MUST NOT BE ZERO
Ccmam NUMBER OF SPREAD SEGMENTS MUST NOT EXCEED PROGRAM MAXIMUM OF 516
C     NUMBER OF SPREAD SEGMENTS MUST NOT EXCEED PROGRAM MAXIMUM OF 1028

C-----------------------------------------------------------------------
C
         IF (NSEG .EQ. 0) GO TO 4807
C
         NSEGC                          = NSEG  / 6
         IF (MOD (NSEG,6) .NE. 0) NSEGC = NSEGC + 1
C
         IF (NSEGC .GT. MAXSEG) GO TO 4807
C
C-----------------------------------------------------------------------
C     PROCESS THE NSPRD PARAMETER CARDS
C-----------------------------------------------------------------------
C
         DO 3100 NC = 1,NSEGC
C
C-----------------------------------------------------------------------
C     READ & VERIFY THE NSPRD PARAMETER CARDS
C-----------------------------------------------------------------------
C
            READ  (ICR,400,END=4807) CARD
            WRITE (ICRD,2080) CARD
c.c         WRITE (JCRD,2080) CARD
c.c         WRITE (KCRD,2080) CARD
C
            IF ((CARD(1:5) .EQ. '1SPRD') .OR.
     $          (CARD(1:5) .EQ. '2SPRD') .OR.
     $          (CARD(1:5) .EQ. '3SPRD') .OR.
     $          (CARD(1:5) .EQ. '4SPRD') .OR.
     $          (CARD(1:5) .EQ. '5SPRD')     ) GO TO 2700
            GO TO 4807
C
 2700       CONTINUE
            IF (CARD(1:5) .EQ. '5SPRD') THEN
               NSTART   = (3 * (NC - 1)) + 1
               NSTOP    = NSTART + 2
               READ  (CARD,2800) (TRSEG(N), GISEG(N),
     $                            N=NSTART,NSTOP), JRI
 2800          FORMAT(5X, 3(5X, I5,I10), 5X, I10)
               DO 2850 ICHK = NSTART, NSTOP
                  IF (GISEG(ICHK) .LT. 0) THEN
                     GIINC(ICHK) = 1
                     GISEG(ICHK) = -GISEG(ICHK)
                  ELSE
                     GIINC(ICHK) = 0
                  END IF
 2850          CONTINUE
            ELSE
               NSTART      = (6 * (NC - 1)) + 1
               NSTOP       = NSTART + 5
C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
               READ  (CARD,5800) (TRSEG(N), GISEG(N), GIINC(N),
     $                            N=NSTART,NSTOP), JRI
C=======================================================================
C=======================================================================
            END IF
C
            IF (JRI .NE. IRI) GO TO 4807
C
C-----------------------------------------------------------------------
C     GROUP INDICES GIVEN ON NSPRD CARDS MUST BE WITHIN PROGRAM LIMITS
C     (MAX = 32000)
C-----------------------------------------------------------------------
C
            DO 3000 ICHK = NSTART,NSTOP
C
               IF (GISEG(ICHK) .GT. GISIZE) GO TO 4807
               IF (GIINC(ICHK) .EQ. 1) GIINC(ICHK) = -1
               IF (GIINC(ICHK) .NE.-1) GIINC(ICHK) =  1
C
 3000       CONTINUE
C
 3100    CONTINUE
C
C-----------------------------------------------------------------------
C     FIRST TRACE NUMBER ON 1SPRD CARD MUST BE A 1
C-----------------------------------------------------------------------
C
         IF (TRSEG(1) .NE. 1) GO TO 4807
C
C-----------------------------------------------------------------------
C     TRACE NUMBERS & GROUP INDEX NUMBERS MUST BE POSITIVE
C     TRACE NUMBERS MUST NOT EXCEED LINE HEADER # TR/REC
C     TRACE NUMBERS MUST SUCCESSIVELY INCREASE ON NSPRD CARDS
C-----------------------------------------------------------------------
C
         DO 3800 N = 1,NSEG
C
            IF ((TRSEG(N) .LE. 0) .OR. (GISEG(N) .LE. 0)) GO TO 4807
            IF (TRSEG(N) .GT. NOTPSR) GO TO 4807
            IF (N .EQ. 1) GO TO 3800
            IF ((TRSEG(N) - TRSEG(N- 1)) .LE. 0) GO TO 4807
C
 3800    CONTINUE
C
C-----------------------------------------------------------------------
C     CLEAR THE BUFFER HOLDING GROUP NUMBER FOR A PARTICULAR TRACE
C     STUFF BUFFER WITH GROUP NUMBERS
C-----------------------------------------------------------------------
C
cmam	ival = 1024 * SZSMPD

	ival = 2048 * SZSMPD

         CALL MOVE (0,NGI,0,ival)
         CALL MOVE (0,NGIINC,0,ival)
C
         DO 3900 N = 1,NSEG
            NGI    (TRSEG(N)) = GISEG(N)
            NGIINC (TRSEG(N)) = GIINC(N)
 3900    CONTINUE
C
         INC    = NGIINC (1)
         DO 4000 N = 2,NOTPSR
            IF (NGIINC (N) .NE. 0) INC    = NGIINC (N)
            IF (NGI    (N) .EQ. 0) NGI(N) = NGI    (N - 1) + INC
 4000    CONTINUE
C
         IF (NGI(NOTPSR) .GT. NG) GO TO 4807
C
C=======================================================================
C     PROCESS THE TRACE EDITTING CARDS ('OMIT' & 'NVRT')
C=======================================================================
C
         OMTSAV = 1
         NVTSAV = 1
cmam	ival = 2048 * HLHINT

	ival = 2*2048 * SZSMPD
cmam	ival = 2*2048 * HLHINT

c.c	ival = 1024 * HLHINT

ccc	ival = 1024 * SZSMPD

         CALL MOVE (0,OMTBUF,0,ival)
C
C-----------------------------------------------------------------------
C
C     READ A PARAMETER CARD
C
C-----------------------------------------------------------------------
C
 4030    READ  (ICR,4040,END=4180) CARD, KRI
 4040    FORMAT(                       A80, T71,I10)
c.c      WRITE (KCRD,2080) CARD
         WRITE (ICRD,2080) CARD
c.c      WRITE (JCRD,2080) CARD
C
C-----------------------------------------------------------------------
C     DETERMINE THE TYPE OF CARD ('OMIT' OR 'NVRT')
C     DECODE THE CARD'S PARAMETERS
C-----------------------------------------------------------------------
C
         IF (CARD(1:4) .NE. 'OMIT') GO TO 4080
 4060    IBIAS  = 0
         IFLAG  = 30000
         KTRSAV = OMTSAV
         IF (KRI .EQ. IRI) GO TO 4100
         GO TO 4030
C
 4080    IF (CARD(1:4) .NE. 'NVRT') GO TO 4175
cmam     IBIAS  = 1024
         IBIAS  = 2048

         IFLAG  = -1
         KTRSAV = NVTSAV
         IF (KRI .NE. IRI) GO TO 4030
C
 4100    CONTINUE
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
         READ  (CARD,4110) (KTRCS(K),K=1,12), KRI
C=======================================================================
C=======================================================================
 4110    FORMAT(5X,              12I5     , 5X,I10)
C
C-----------------------------------------------------------------------
C     FILL FLAG BUFFER TO OMIT (30000) OR INVERT (-1)
C     IF TRACE NUMBER ON PARAMETER CARD IS:
C         > 0 : ONLY THAT TRACE WILL BE EDITTED
C         = 0 : END OF THIS PARAMETER CARD
C         < 0 : ALL TRACES FROM LAST SPECIFIED TRACE THRU THIS TRACE
C               WILL BE EDITTED
C-----------------------------------------------------------------------
C
         DO 4170 K = 1,12
C
            IF (IABS(KTRCS(K)) .LE. NOTPSR) GO TO 4115
            GO TO 4170
C
 4115       IF (KTRCS(K)) 4130, 4030, 4120
C
 4120       OMTBUF(KTRCS(K)+IBIAS) = IFLAG
            GO TO 4160
C
 4130       CONTINUE
            MSTART = KTRSAV
            MSTOP  = IABS(KTRCS(K  ))
C
            DO 4150 KK = MSTART,MSTOP
               OMTBUF(KK+IBIAS) = IFLAG
 4150       CONTINUE
C
 4160       IF (IFLAG .LT. 0) GO TO 4165
            OMTSAV = IABS(KTRCS(K))
            KTRSAV = OMTSAV
            GO TO 4170
C
 4165       NVTSAV = IABS(KTRCS(K))
            KTRSAV = NVTSAV
C
 4170    CONTINUE
C
C-----------------------------------------------------------------------
C     FINISHED PROCESSING PARAMETER CARD; GO READ ANOTHER
C-----------------------------------------------------------------------
C
         GO TO 4030
C
C-----------------------------------------------------------------------
C     CHECK CARD MNEMONIC ONE MORE TIME FOR CASE; OMIT-NVRT-OMIT
C-----------------------------------------------------------------------
C
 4175    IF (CARD(1:4) .EQ. 'OMIT') GO TO 4060
         GO TO 4195
C
 4180    EOCC = .TRUE.
C
C-----------------------------------------------------------------------
C     PROCESS AN INPUT RECORD ASSOCIATED WITH THIS 1SORC CARD
C-----------------------------------------------------------------------
C
 4195    DO 4700 IT = 1,NOTPSR
C
C-----------------------------------------------------------------------
C                 READ A TRACE
C-----------------------------------------------------------------------
C
            NUMBYT         = 0
            IF (IDRY .EQ. 0) THEN
               CALL RTAPE (LUIN,TRAREC,NUMBYT)
               IF (NUMBYT .EQ. 0) GO TO 4807
            ELSE
               ITRCS = ITRCS + 1
               IF (ITRCS .GT. NTRCS) THEN
                  ISREC = ISREC + INCREC
                  ITRCS = 1
               END IF
cmam		call savew(I4THDR,'StaCor',0,1)
	call savew2(I4THDR,j_StaCor,i_StaCor,l_StaCor,0,TRCHED)

cmam		call savew(I4THDR,'RecNum',ISREC,1)
	call savew2(I4THDR,j_RecNum,i_RecNum,l_RecNum,ISREC,TRCHED)

cmam		call savew(I4THDR,'TrcNum',ITRCS,1)
	call savew2(I4THDR,j_TrcNum,i_TrcNum,l_TrcNum,ITRCS,TRCHED)

            END IF
C
            IG                = NGI(IT)
C
cmam		call saver(I4THDR,'StaCor',istat,1)
	call saver2(I4THDR,j_StaCor,i_StaCor,l_StaCor,istat,TRCHED)

            IF (istat.EQ.30000) GO TO 4700
cmam		call saver(I4THDR,'RecNum',irec, 1)
	call saver2(I4THDR,j_RecNum,i_RecNum,l_RecNum,irec,TRCHED)

ccc	    call savew(I4THDR,'RecNum',irec, 1)

            IF (OMTBUF(irec).EQ.30000) GO TO 4700
C
            I4T16 = 0.5 * (ISX + IGX(IG)) + 0.5

            I4T17 = 0.5 * (ISY + IGY(IG)) + 0.5

cmam		call savew(I4THDR,'SrRcMX',I4T16,1)
	call savew2(I4THDR,j_SrRcMX,i_SrRcMX,l_SrRcMX,I4T16,TRCHED)

cmam		call savew(I4THDR,'SrRcMY',I4T17,1)
	call savew2(I4THDR,j_SrRcMY,i_SrRcMY,l_SrRcMY,I4T17,TRCHED)

C
            CALL ILIDI (I4T16,I4T17,ILI,IDI,IWARN)

ccc         CALL ILIDI (I4THDR(16),I4THDR(17),ILI,IDI,IWARN)
            IF (IWARN.EQ.0) THEN
               X9 = ISX - IGX(IG)

               Y9 = ISY - IGY(IG)

               IDIST = SQRT (X9 * X9 + Y9 * Y9) + 0.5
               MNHDST = MIN (MNHDST, IDIST)
               MXHDST = MAX (MXHDST, IDIST)
               MNHLI = MIN (MNHLI, ILI)
               MNHDI = MIN (MNHDI, IDI)
               MXHLI = MAX (MXHLI, ILI)
               MXHDI = MAX (MXHDI, IDI)
               IFO = (ILI - 1) * NX + IDI
               KOUNT (IFO) = KOUNT (IFO) + 1

               FDATUM(IFO) = FDATUM(IFO) + ISE  + IGE(IG)

            END IF
            CALL ILIDI (ISX,ISY,ISLI,ISDI,IWARN)
            IF (IWARN.EQ.0) THEN
               MNHLI = MIN (MNHLI, ISLI)
               MNHDI = MIN (MNHDI, ISDI)
               MXHLI = MAX (MXHLI, ISLI)
               MXHDI = MAX (MXHDI, ISDI)
               ISPFO = (ISLI - 1) * NX + ISDI
               SPABOV(ISPFO) = ISPNO

            END IF
            CALL ILIDI (IGX(IG),IGY(IG),IRLI,IRDI,IWARN)

            IF (IWARN.EQ.0) THEN
               MNHLI = MIN (MNHLI, IRLI)
               MNHDI = MIN (MNHDI, IRDI)
               MXHLI = MAX (MXHLI, IRLI)
               MXHDI = MAX (MXHDI, IRDI)
            END IF
C
 4700    CONTINUE
C
 4800 CONTINUE
C
      MAXX = 0
C
      DO 4804 IXX =1,NXY
         IFOLD = KOUNT(IXX)

         IF (IFOLD.GT.MAXX) MAXX = IFOLD
         IF (IFOLD .NE. 0) THEN
            FDATUM(IXX) = FDATUM(IXX) / (2*IFOLD) + .5

         END IF
 4804 CONTINUE
C
c.c.c...................check this out to see what is really going on

c.c........I4LHDR has been moved into I4LISV, so need to	

c.c........change all this to savew to I2LISV,I4LISV

cmam	call saver(I2LISV,'CDPFld',kfold,0)
	call saver2(I4LISV,j_CDPFld,i_CDPFld,l_CDPFld,kfold,LINHED)

cmam	if(kfold .eq. 0) call savew(I2LISV,'CDPFld',MAXX,0)
	if(kfold .eq. 0) call savew2(I4LISV,j_CDPFld,i_CDPFld,
     *					l_CDPFld,MAXX,LINHED)

	ival = MNHLI + LIBIAS

cmam	call savew(I2LISV,'MnLnIn',ival,0)
	call savew2(I4LISV,j_MnLnIn,i_MnLnIn,l_MnLnIn,ival,LINHED)

	ival = MXHLI + LIBIAS

cmam	call savew(I2LISV,'MxLnIn',ival,0)
	call savew2(I4LISV,j_MxLnIn,i_MxLnIn,l_MxLnIn,ival,LINHED)

	ival = MNHDI + DIBIAS

cmam    call savew(I2LISV,'MnDpIn',ival,0)
	call savew2(I4LISV,j_MnDpIn,i_MnDpIn,l_MnDpIn,ival,LINHED)

	ival = MXHDI + DIBIAS

cmam	call savew(I2LISV,'MxDpIn',ival,0)
	call savew2(I4LISV,j_MxDpIn,i_MxDpIn,l_MxDpIn,ival,LINHED)

cmam	call savew(I2LISV,'MutFlg',1,0)
	call savew2(I4LISV,j_MutFlg,i_MutFlg,l_MutFlg,1,LINHED)

cmam	call savew(I2LISV,'MxTrOf',MNHDST,0)
	call savew2(I4LISV,j_MxTrOf,i_MxTrOf,l_MxTrOf,MNHDST,LINHED)

cmam	call savew(I2LISV,'MnTrOf',MXHDST,0)
	call savew2(I4LISV,j_MnTrOf,i_MnTrOf,l_MnTrOf,MXHDST,LINHED)

	ival = MAXX * NX

cmam	call savew(I4LISV,'NTrLnS',ival,0)
	call savew2(I4LISV,j_NTrLnS,i_NTrLnS,l_NTrLnS,ival,LINHED)

      BTX1 = DX / 2.
      BTY1 = DY / 2.
      BTX2 = DX / 2.
      BTY2 = NY*DY - DY / 2.
      BTX3 = NX*DX - DX / 2.
      BTY3 = NY*DY - DY / 2.
      BTX4 = NX*DX - DX / 2.
      BTY4 = DY / 2.
      IDUM = 0
      CALL XFMINV (IDUM,IDUM,BTX1,BTY1,BX1,BY1,BTX1,BTY1,IWARN)
      CALL XFMINV (IDUM,IDUM,BTX2,BTY2,BX2,BY2,BTX2,BTY2,IWARN)
      CALL XFMINV (IDUM,IDUM,BTX3,BTY3,BX3,BY3,BTX3,BTY3,IWARN)
      CALL XFMINV (IDUM,IDUM,BTX4,BTY4,BX4,BY4,BTX4,BTY4,IWARN)
c.c.c.c.........................need definition for these words

ccc........these are just used for printing out the bin centers,

ccc.............but grid corners are stored later

	bnctr(1) = NINT(BX1)

	bnctr(2) = NINT(BY1)

	bnctr(3) = NINT(BX2)

	bnctr(4) = NINT(BY2)

	bnctr(5) = NINT(BX3)

	bnctr(6) = NINT(BY3)

	bnctr(7) = NINT(BX4)

	bnctr(8) = NINT(BY4)

      WRITE (IPR,4805) (bnctr(I),I=1,8)

c.c.c.c.................................................to here

 4805 FORMAT (// ,
     $        18X,'BIN-CENTER COORDINATES'                 ,     /,
     $        18X,'   CORNER 1 - X . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 1 - Y . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 2 - X . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 2 - Y . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 3 - X . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 3 - Y . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 4 - X . . . . . . . . . . ',I8,     /,
     $        18X,'   CORNER 4 - Y . . . . . . . . . . ',I8,     //)
 1299 FORMAT(/   6X, 'OUTPUT LINE HEADER before(', I4, ' BYTES LONG):',

     $      // (5X,20(1X,4a1)))

C

cmam...........there is no way to do this using keywords and the save
cmam			functions, so we will eliminate it.  I cannot
cmam			find any programs that read it anyway.
cmam...........4-19-95...............................................
cmam#ifdef SUNSYSTEM
cmam
cmam      I4LISV(61) = IX1
cmam      I4LISV(62) = IY1
cmam      I4LISV(63) = IX2
cmam      I4LISV(64) = IY2
cmam      I4LISV(65) = IX3
cmam      I4LISV(66) = IY3
cmam      I4LISV(67) = IX4
cmam      I4LISV(68) = IY4
cmam#endif
cmam
cmam#ifdef CRAYSYSTEM
cmam
cmam	istart = 617
cmam
cmam	call move (1,corner(1),IX1,8)
cmam
cmam	call move (1,L1LISV(istart),corner(5),4)
cmam
cmam	istart = istart + 4
cmam
cmam     call move (1,corner(1),IY1,8)
cmam
cmam     call move (1,L1LISV(istart),corner(5),4)
cmam
cmam        istart = istart + 4
cmam
cmam        call move (1,corner(1),IX2,8)
cmam
cmam        call move (1,L1LISV(istart),corner(5),4)
cmam
cmam        istart = istart + 4
cmam
cmam        call move (1,corner(1),IY2,8)
cmam
cmam        call move (1,L1LISV(istart),corner(5),4)
cmam
cmam        istart = istart + 4
cmam
cmam        call move (1,corner(1),IX3,8)
cmam
cmam        call move (1,L1LISV(istart),corner(5),4)
cmam
cmam        istart = istart + 4
cmam
cmam        call move (1,corner(1),IY3,8)
cmam
cmam        call move (1,L1LISV(istart),corner(5),4)
cmam
cmam        istart = istart + 4
cmam
cmam        call move (1,corner(1),IX4,8)
cmam
cmam        call move (1,L1LISV(istart),corner(5),4)
cmam
cmam        istart = istart + 4
cmam
cmam        call move (1,corner(1),IY4,8)
cmam
cmam        call move (1,L1LISV(istart),corner(5),4)
cmam
cmam#endif
cmam...........4-19-95...............................................

 4806 CONTINUE
C
      IF (IDRY .EQ. 0) THEN
         CALL WRTAPE (LUOUT,I4LISV,IBTCNT)
         CALL RWD (LUIN)
         NUMBYT = 0
         CALL RTAPE (LUIN,TRAREC,NUMBYT)
      ELSE
         ISREC=ISRECO
         ITRCS=0
      END IF
C
      EOCC = .FALSE.
      REWIND ICRD
      READ  (ICRD,400,END=4808) CARD
      GO TO 4810
C
 4807 ICC = 100
cmam........obviously, this one slipped by before.  should be CDPFld
        call savew2(I4LISV,j_CDPFld,i_CDPFld,l_CDPFld,0,LINHED)
cmam  I2LISV(38) = 0
      GO TO 4806
C
 4808 WRITE (IPR,4809)
 4809 FORMAT('0** M3079 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $    13X, 'PREMATURE END OF FILE ON TEMPORARY DISK FILE'/
     $    13X, 'CARDS FROM CARD DECK SHOULD HAVE BEEN WRITTEN TO DISK')
      ICC = 100
      GO TO 9400
C
 4810 NREC              = 0
C
      DO 8800 IR = 1,NOSREC
C
C-----------------------------------------------------------------------
C     READ & VERIFY THE 1SORC PARAMETER CARD
C-----------------------------------------------------------------------
C
         IF (EOCC) GO TO 9280
         IF (I5SPRD .EQ. 0)
     &   CALL WRCARD (CARD,1,IPR)
C
         IF (CARD(1:5) .EQ. '1SORC') GO TO 5100
         WRITE (IPR,5090)
 5090    FORMAT('0** M3048 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE CARD MNEMONIC (CC 1-5) OF THE INPUT '     ,
     $                 'PARAMETER CARD IS NOT'                        /
     $            13X, 'SPECIFIED AS 1SORC'                           /)
         ICC = 100
         GO TO 9400
C
 5100    NREC           = NREC + 1
C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
         READ (CARD,5300)   ISX   , ISY   , IXO   , IYO   , ISE   ,
     $                      ISRRS , ISD   , IUT   , ISPNO , ASPNO ,
     $                      NSEG  , IRI
C=======================================================================
C=======================================================================
 5300    FORMAT(            T7,I8 , I8    , 1X,I4 , I4    , 1X,I5 ,
     $                      I5    , 1X,I4 , I4    , I5    , A1    ,
     $                      I5    , T71,I10)
C
C-----------------------------------------------------------------------
C     FILL SOURCE REGIONAL REFERENCE SURFACE IF DEFAULTED
C     CALCULATE X-COORDINATE & Y-COORDINATE IF GIVEN AN OFFSET
C-----------------------------------------------------------------------
C
         IF (ISPNO .EQ. 0) ISPNO = IRI
         IF (ISRRS .EQ. 0) ISRRS = JRRS
C
         ISX                     = ISX + IXO
         ISY                     = ISY + IYO
         IF (I5SPRD .EQ. 0) THEN
c           TST = 1.E70
	    TST = REPEMAX()

            IGLI= 0
            DO 5310 I = 1, NG
               D1 = ISX - IGX(I)

               D2 = ISY - IGY(I)

               DST = D1*D1 + D2*D2
               IF (DST .LT. TST) THEN
                  TST = DST
                  IGLI = I * 10
                  IF (IGLI .GT. 32767) IGLI = - IGLI / 10
               END IF
 5310       CONTINUE
         END IF
C
C-----------------------------------------------------------------------
C     NUMBER OF SPREAD SEGMENTS MUST NOT BE ZERO
Ccmam NUMBER OF SPREAD SEGMENTS MUST NOT EXCEED PROGRAM MAXIMUM OF 516
C     NUMBER OF SPREAD SEGMENTS MUST NOT EXCEED PROGRAM MAXIMUM OF 1028

C-----------------------------------------------------------------------
C
         IF (NSEG .NE. 0) GO TO 5500
         WRITE (IPR,5450) IRI
 5450    FORMAT('0** M3049 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE NUMBER OF SPREAD SEGMENTS (1SORC CC '     ,
     $                 '60-62) FOR RECORD INDEX ',I10                 /
     $            13X, 'IS ZERO OR IS DEFAULTED'                      /
     $            13X, 'VERIFY THAT THIS ENTRY CONTAINS A NON-ZERO '  ,
     $                 'VALUE'                                        /)
         ICC = 100
         GO TO 9400
C
 5500    NSEGC                          = NSEG  / 6
         IF (MOD (NSEG,6) .NE. 0) NSEGC = NSEGC + 1
C
         IF (NSEGC .LE. MAXSEG) GO TO 5600
         WRITE (IPR,5550) IRI, MAXSEG
 5550    FORMAT('0** M3050 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE NUMBER OF SPREAD SEGMENTS (1SORC CC '     ,
     $                 '60-62) FOR RECORD INDEX ', I10                /
     $            13X, 'EXCEEDS THE PROGRAM LIMIT OF ', I3            /
     $            13X, 'VERIFY THIS ENTRY, AND AMEND IF NECESSARY'    /)
         ICC = 100
         GO TO 9400
C
C-----------------------------------------------------------------------
C     PROCESS THE NSPRD PARAMETER CARDS
C-----------------------------------------------------------------------
C
 5600    DO 6100 NC = 1,NSEGC
C
C-----------------------------------------------------------------------
C     READ & VERIFY THE NSPRD PARAMETER CARDS
C-----------------------------------------------------------------------
C
            READ  (ICRD,400,END=5660) CARD
            IF (I5SPRD .EQ. 0)
     &      CALL WRCARD (CARD,3,IPR)
C
            IF ((CARD(1:5) .EQ. '1SPRD') .OR.
     $          (CARD(1:5) .EQ. '2SPRD') .OR.
     $          (CARD(1:5) .EQ. '3SPRD') .OR.
     $          (CARD(1:5) .EQ. '4SPRD') .OR.
     $          (CARD(1:5) .EQ. '5SPRD')     ) GO TO 5700
            WRITE (IPR,5650) IRI
 5650       FORMAT('0** M3051 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $               13X, 'THE CARD MNEMONIC (CC 1-5) OF THE INPUT '  ,
     $                    'PARAMETER CARD IS NOT'                     /
     $               13X, 'SPECIFIED AS NSPRD (N = 1,...,5) FOR '     ,
     $                    'RECORD NUMBER ', I10,                     /)
            ICC = 100
            GO TO 9400
C
 5660       WRITE (IPR,5670) IRI
 5670       FORMAT('0** M3068 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $               13X, 'PREMATURE END OF FILE ON CARD READER WHILE',
     $               13X, ' PROCESSING RECORD NUMBER ',I10            /
     $               13X, 'THE CARD MNEMONIC (CC 1-5) OF THE EXPECTED',
     $                    ' PARAMETER CARD SHOULD BE'                 /
     $               13X, 'SPECIFIED AS NSPRD (N = 1,...,4)'         /)
            ICC = 100
            GO TO 9400
C
 5700       CONTINUE
            IF (CARD(1:5) .EQ. '5SPRD') THEN
               NSTART   = (3 * (NC - 1)) + 1
               NSTOP    = NSTART + 2
               READ  (CARD,2800) (TRSEG(N), GISEG(N),
     $                            N=NSTART,NSTOP), JRI
               DO 5850 ICHK = NSTART, NSTOP
                  IF (GISEG(ICHK) .LT. 0) THEN
                     GIINC(ICHK) = 1
                     GISEG(ICHK) = -GISEG(ICHK)
                  ELSE
                     GIINC(ICHK) = 0
                  END IF
 5850          CONTINUE
            ELSE
               NSTART      = (6 * (NC - 1)) + 1
               NSTOP       = NSTART + 5
C
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
               READ  (CARD,5800) (TRSEG(N), GISEG(N), GIINC(N),
     $                            N=NSTART,NSTOP), JRI
C=======================================================================
C=======================================================================
 5800          FORMAT(  8X,               6(I4,I5,I1),          2X,I10)
            END IF
C
            IF (JRI .EQ. IRI) GO TO 5900
            WRITE (IPR,5860) IRI
 5860       FORMAT('0** M3052 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $               13X, 'THE RECORD NUMBER (CC 77-80) SPECIFIED '   ,
     $                    'ON THE NSPRD PARAMETER CARD'               /
     $               13X, 'FOR RECORD INDEX ',I10, ' DOES NOT MATCH ' ,
     $                    'THE RECORD INDEX INPUT ON'                 /
     $               13X, 'THE 1SORC CARD (CC 77-80)'                 /)
            ICC = 100
            GO TO 9400
C
C-----------------------------------------------------------------------
C     GROUP INDICES GIVEN ON NSPRD CARDS MUST BE WITHIN PROGRAM LIMITS
C     (MAX = 32000)
C-----------------------------------------------------------------------
C
 5900       DO 6000 ICHK = NSTART,NSTOP
C
               IF (GISEG(ICHK) .LE. GISIZE) GO TO 5960
               WRITE (IPR,5950) IRI      , GISIZE
 5950          FORMAT('0** M3053 ** ERROR DETECTED BY PROGRAM PR3D:'  /
     $               13X, 'A GROUP INDEX NUMBER ON A NSPRD PARAMETER ',
     $                    'CARD FOR RECORD INDEX ', I10               /
     $               13X, 'EXCEEDS THE PROGRAM LIMIT OF ', I5         /
     $               13X, 'VERIFY THE GROUP INDEX ENTRIES ON THE '    ,
     $                    'NSPRD (N = 1,...,4) PARAMETER'             /
     $               13X, 'CARDS, AND AMEND IF NECESSARY'             /)
               ICC = 100
               GO TO 9400
 5960          IF (GIINC(ICHK) .EQ. 1) GIINC(ICHK) = -1
               IF (GIINC(ICHK) .NE.-1) GIINC(ICHK) =  1
C
 6000       CONTINUE
C
 6100    CONTINUE
C
C-----------------------------------------------------------------------
C     FIRST TRACE NUMBER ON 1SPRD CARD MUST BE A 1
C-----------------------------------------------------------------------
C
         IF (TRSEG(1) .EQ. 1) GO TO 6500
         WRITE (IPR,6450) IRI
 6450    FORMAT('0** M3054 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE TRACE NUMBER (CC 9-12) OF THE 1SPRD '     ,
     $                 'PARAMETER CARD FOR RECORD'                    /
     $            13X, 'INDEX ',I10, ' IS NOT SPECIFIED AS 1'         /
     $            13X, 'VERIFY THIS ENTRY, AND AMEND IF NECESSARY'    /)
         ICC = 100
         GO TO 9400
C
C-----------------------------------------------------------------------
C     TRACE NUMBERS & GROUP INDEX NUMBERS MUST BE POSITIVE
C     TRACE NUMBERS MUST NOT EXCEED LINE HEADER # TR/REC
C     TRACE NUMBERS MUST SUCCESSIVELY INCREASE ON NSPRD CARDS
C-----------------------------------------------------------------------
C
 6500    DO 6800 N = 1,NSEG
C
            IF ((TRSEG(N) .GT. 0) .AND. (GISEG(N) .GT. 0)) GO TO 6600
            WRITE (IPR,6550) IRI
 6550       FORMAT('0** M3055 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $               13X, 'EITHER A TRACE NUMBER OR A GROUP INDEX '   ,
     $                    'OF A NSPRD PARAMETER CARD'                 /
     $               13X, 'FOR RECORD INDEX',I10, ' IS SPECIFIED '   ,
     $                    'LESS THAN ZERO'                            /
     $               13X, 'VERIFY THE ENTRIES ON THE NSPRD PARAMETER ',
     $                    'CARDS FOR THIS RECORD,'                    /
     $               13X, 'AND AMEND IF NECESSARY'                    /)
            ICC = 100
            GO TO 9400
C
 6600       IF (TRSEG(N) .LE. NOTPSR) GO TO 6700
            WRITE (IPR,6650) IRI
 6650       FORMAT('0** M3056 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $               13X, 'A TRACE NUMBER OF A NSPRD PARAMETER CARD ' ,
     $                    'FOR RECORD INDEX ', I10                    /
     $               13X, 'IS GREATER THAN THE NUMBER OF TRACES PER ' ,
     $                    'RECORD FILED IN THE INPUT'                 /
     $               13X, 'DATA SET LINE HEADER'                      /
     $               13X, 'VERIFY THE TRACE NUMBER ENTRIES AND THE '  ,
     $                    'TRACES PER RECORD ENTRY'                   /
     $             / 45X, 'IN THE LINE HEADER'                       /)
            ICC = 100
            GO TO 9400
C
 6700       IF (N .EQ. 1) GO TO 6800
C
            IF ((TRSEG(N) - TRSEG(N- 1)) .GT. 0) GO TO 6800
            WRITE (IPR,6750) IRI
 6750       FORMAT('0** M3057 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $               13X, 'THE TRACE NUMBERS OF THE NSPRD PARAMETER ' ,
     $                    'CARDS FOR RECORD INDEX ', I10              /
     $               13X, 'ARE NOT IN ASCENDING ORDER'                /
     $               13X, 'VERIFY THE TRACE NUMBER ENTRIES AND AMEND ',
     $                    'IF NECESSARY'                             /)
            ICC = 100
            GO TO 9400
C
 6800    CONTINUE
C
C-----------------------------------------------------------------------
C     CLEAR THE BUFFER HOLDING GROUP NUMBER FOR A PARTICULAR TRACE
C     STUFF BUFFER WITH GROUP NUMBERS
C-----------------------------------------------------------------------
C
cmam	ival = 1024 * SZSMPD

	ival = 2048 * SZSMPD

         CALL MOVE (0,NGI,0,ival)
         CALL MOVE (0,NGIINC,0,ival)
C
         DO 6900 N = 1,NSEG
            NGI    (TRSEG(N)) = GISEG(N)
            NGIINC (TRSEG(N)) = GIINC(N)
 6900    CONTINUE
C
         INC       = NGIINC (1)
         DO 8000 N = 2,NOTPSR
            IF (NGIINC (N) .NE. 0) INC    = NGIINC (N)
            IF (NGI    (N) .EQ. 0) NGI(N) = NGI    (N - 1) + INC
 8000    CONTINUE
C
         IF (NGI(NOTPSR) .LE. NG) GO TO 8020
         WRITE (IPR,8010) IRI, NGI(NOTPSR), NG, INC
 8010    FORMAT('0** M3058 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE GROUP INDEX ASSOCIATED WITH THE LAST '    ,
     $                 'TRACE NUMBER FOR RECORD'                      /
     $            13X, 'INDEX ',I10, ' EXCEEDS THE LAST GROUP '       ,
     $                 'INDEX DEFINED FOR THIS LINE'                  /
     $            13X, 'THE LAST GROUP INDEX FOR THE RECORD IS '      ,
     $                 I5                                             /
     $            13X, 'THE LAST GROUP INDEX FOR THIS LINE IS '       ,
     $                 I5                                             /
     $            13X, 'THE GI INCREMENT FROM TRACE TO TRACE IS '     ,
     $                 I5                                             /
     $            13X, 'VERIFY THE TRACE NUMBER AND GROUP INDEX '     ,
     $                 'ENTRIES ON THE NSPRD'                         /
     $            13X, 'PARAMETER CARD AND/OR EXAMINE 1GRUP CARDS '   ,
     $                 'FOR ERRONEOUS OR MISSING CARDS'               /)
         ICC = 100
         GO TO 9400
C
C=======================================================================
C     PROCESS THE TRACE EDITTING CARDS ('OMIT' & 'NVRT')
C=======================================================================
C
 8020    OMTSAV = 1
         NVTSAV = 1
c.c.c...............................check for cray

cmam	ival = 1024 * SZSMPD

	ival = 2048 * SZSMPD

         CALL MOVE (0,OMTBUF,0,ival)
C
C-----------------------------------------------------------------------
C
C     READ A PARAMETER CARD
C
C-----------------------------------------------------------------------
C
 8030    READ  (ICRD,4040,END=8180) CARD, KRI
C
C-----------------------------------------------------------------------
C
C     DETERMINE THE TYPE OF CARD ('OMIT' OR 'NVRT')
C     DECODE THE CARD'S PARAMETERS
C
C-----------------------------------------------------------------------
C
         IF (CARD(1:4) .NE. 'OMIT') GO TO 8080
 8060    IBIAS  = 0
         IFLAG  = 30000
         KTRSAV = OMTSAV
         IF (KRI .EQ. IRI) GO TO 8100
         IF (.NOT.INDXNG) WRITE (IPR,8070) IRI
 8070    FORMAT('0** M3064 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE RECORD NUMBER (CC 77-80) SPECIFIED ON '   ,
     $                 'THE OMIT CARD DOES NOT'                       /
     $            13X, 'MATCH THE RECORD NUMBER CURRENTLY BEING '     ,
     $                 'PROCESSED'                                    /
     $            13X, 'VERIFY THIS ENTRY FOR RECORD NUMBER ', I10    ,
     $                 ' ON THE OMIT CARD(S), AS WELL'                /
     $            13X, 'AS THE 1SORC CARD'                            /
     $            13X, 'THE OMITS FOR THIS RECORD WILL BE IGNORED '   /)
         GO TO 8030
C
 8080    IF (CARD(1:4) .NE. 'NVRT') GO TO 8175
cmam     IBIAS  = 1024
         IBIAS  = 2048

         IFLAG  = -1
         KTRSAV = NVTSAV
         IF (KRI .EQ. IRI) GO TO 8100
         IF (.NOT.INDXNG) WRITE (IPR,8090) IRI
 8090    FORMAT('0** M3065 ** ERROR DETECTED BY PROGRAM PR3D:'        /
     $            13X, 'THE RECORD NUMBER (CC 77-80) SPECIFIED ON '   ,
     $                 'THE NVRT CARD DOES NOT'                       /
     $            13X, 'MATCH THE RECORD NUMBER CURRENTLY BEING '     ,
     $                 'PROCESSED'                                    /
     $            13X, 'VERIFY THIS ENTRY FOR RECORD NUMBER ', I10    ,
     $                 ' ON THE NVRT CARD(S), AS WELL'                /
     $            13X, 'AS THE 1SORC CARD'                            /
     $            13X, 'THE INVERTS FOR THIS RECORD WILL BE IGNORED'  /)
         GO TO 8030
C
 8100    CONTINUE
C=======================================================================
C======= CODE CHANGES FOLLOW TO CONVERT FROM IBM TO PERKIN-ELMER =======
C=============================           ===============================
         READ  (CARD,8110) (KTRCS(K),K=1,12), KRI
C=======================================================================
C=======================================================================
 8110    FORMAT(5X,              12I5     , 10X,I5)
C
         CALL WRCARD(CARD,3,IPR)
C
C-----------------------------------------------------------------------
C     FILL FLAG BUFFER TO OMIT (30000) OR INVERT (-1)
C     IF TRACE NUMBER ON PARAMETER CARD IS:
C         > 0 : ONLY THAT TRACE WILL BE EDITTED
C         = 0 : END OF THIS PARAMETER CARD
C         < 0 : ALL TRACES FROM LAST SPECIFIED TRACE THRU THIS TRACE
C               WILL BE EDITTED
C-----------------------------------------------------------------------
C
         DO 8170 K = 1,12
C
            IF (IABS(KTRCS(K)) .LE. NOTPSR) GO TO 8115
            IF (.NOT.INDXNG) WRITE (IPR,8114) KRI
 8114       FORMAT('0** M3066 ** WARNING FROM PROGRAM PR3D:'          /
     $               13X, 'A TRACE NUMBER ON A OMIT OR NVRT PARA'     ,
     $                    'METER CARD FOR RECORD'                     /
     $               13X, 'NUMBER ', I5, ' IS GREATER THAN THE '      ,
     $                    'NUMBER OF TRACES PER'                      /
     $               13X, 'RECORD ENTRY FILED IN THE INPUT DATA '     ,
     $                    'SET LINE HEADER'                           /
     $               13X, 'THIS ENTRY WILL BE IGNORED, BUT ERRORS '   ,
     $                    'MAY BE GENERATED DUE'                      /
     $               13X, 'TO THIS ERRONEOUS ENTRY'                   /)
            GO TO 8170
C
 8115       IF (KTRCS(K)) 8130, 8030, 8120
C
 8120       OMTBUF(KTRCS(K)+IBIAS) = IFLAG
            GO TO 8160
C
 8130       CONTINUE
            MSTART = KTRSAV
            MSTOP  = IABS(KTRCS(K  ))
C
            DO 8150 KK = MSTART,MSTOP
               OMTBUF(KK+IBIAS) = IFLAG
 8150       CONTINUE
C
 8160       IF (IFLAG .LT. 0) GO TO 8165
            OMTSAV = IABS(KTRCS(K))
            KTRSAV = OMTSAV
            GO TO 8170
C
 8165       NVTSAV = IABS(KTRCS(K))
            KTRSAV = NVTSAV
C
 8170    CONTINUE
C
C-----------------------------------------------------------------------
C     FINISHED PROCESSING PARAMETER CARD; GO READ ANOTHER
C-----------------------------------------------------------------------
C
         GO TO 8030
C
C-----------------------------------------------------------------------
C     CHECK CARD MNEMONIC ONE MORE TIME FOR CASE; OMIT-NVRT-OMIT
C-----------------------------------------------------------------------
C
 8175    IF (CARD(1:4) .EQ. 'OMIT') GO TO 8060
         GO TO 8185
C
 8180    EOCC = .TRUE.
C
C-----------------------------------------------------------------------
C     PRINT USER INPUT PARAMETERS FROM 1SORC CARD
C-----------------------------------------------------------------------
C
 8185    CONTINUE
         IF (I5SPRD .EQ. 0) THEN
         WRITE (IPR,8190)  ISPNO, ASPNO , IRI      , ISX   , ISE   ,
     $                       ISY   , ISRRS , IXO   , ISD   , IYO   ,
     $                       IUT
 8190    FORMAT(/  1X, 'SHOT NUMBER:  ',     I8, A1, 4X,
     $                                 'RECORD NUMBER:     '   , I8,
     $          /  1X, 'X-COORDINATE: ',     I8,     5X,
     $                                 'ELEVATION:         ', 3X,I5,
     $          /  1X, 'Y-COORDINATE: ',     I8,     5X,
     $                                 'REFERENCE SURFACE: ', 3X,I5,
     $          /  1X, 'X-OFFSET:     ', 4X, I4,     5X,
     $                                 'DEPTH OF SHOT:     ', 4X,I4,
     $          /  1X, 'Y-OFFSET:     ', 4X, I4,     5X,
     $                                 'UPHOLE TIME:       ', 4X,I4,
     $          /)
C
C-----------------------------------------------------------------------
C     PROCESS AN INPUT RECORD ASSOCIATED WITH THIS 1SORC CARD
C-----------------------------------------------------------------------
C
         IF (MODE.EQ.0) WRITE (IPR,8191)
 8191    FORMAT(1X, '                         GROUP-X     GROUP-Y  '  ,
     $          2X, '  GROUP     REFERENCE            CDP-X   '       ,
     $          2X, '  CDP-Y        CDP      REFERENCE'               /
     $          1X, 'TRACE  GROUP  DISTANCE  COORDINATE  COORDINATE'  ,
     $          2X, 'ELEVATION    SURFACE   STATIC  COORDINATE'       ,
     $          2X, 'COORDINATE  ELEVATION    SURFACE'                /)
C
         IF (MODE.NE.0) WRITE (IPR,8192)
 8192    FORMAT(1X, '                   GROUP-X  GROUP-Y' ,
     $              ' GROUP REFERENCE          CDP-X'     ,
     $              '    CDP-Y   CDP REFERENCE'           ,
     $              ' LINE DEPTH   X-BIN    Y-BIN'        /
     $          1X, 'TRACE GROUP  DIST    COORD    COORD' ,
     $              '  ELEV SURFACE  STATIC    COORD'     ,
     $              '    COORD  ELEV SURFACE'             ,
     $              '  INDEX INDEX  CENTER   CENTER  FOLD')
         END IF
C
         JSEG           = 1
C


         DO 8700 IT = 1,NOTPSR
C
C-----------------------------------------------------------------------
C     READ A TRACE & VERIFY THE # OF SAMPLES
C-----------------------------------------------------------------------
C
            IF (IDRY .EQ. 0) THEN
               NUMBYT         = 0
               CALL RTAPE (LUIN,TRAREC,NUMBYT)
cmam	call saver(I4THDR,'RecNum',irec,1)
        call saver2(I4THDR,j_RecNum,i_RecNum,l_RecNum,irec,TRCHED)

cmam	call saver(I4THDR,'TrcNum',itrc,1)
        call saver2(I4THDR,j_TrcNum,i_TrcNum,l_TrcNum,itrc,TRCHED)

               IF (NUMBYT .NE. 0) GO TO 8200
               WRITE (IPR,8199) irec, itrc

 8199          FORMAT('0** M3059 ** ERROR DETECTED BY PROGRAM PR3D:',/,
     $            13X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ '  ,
     $                 'RECORD NUMBER ', I5                         ,/,
     $            13X, 'TRACE NUMBER ', I5                          ,/,
     $            13X, 'VERIFY THE NUMBER OF RECORDS ENTRY AND THE '  ,
     $                 'NUMBER OF TRACES PER RECORD'                ,/,
     $            13X, 'ENTRY OF THE INPUT DATA SET LINE HEADER, '    ,
     $                 'AND/OR CHECK FOR PREVIOUS'                  ,/,
     $            13X, 'PROCESSING IRREGULARITIES'                   /)
               ICC = 100
               GO TO 9400
            ELSE
               ITRCS = ITRCS + 1
               IF (ITRCS .GT. NOTPSR) THEN
                  ISREC = ISREC + INCREC
                  ITRCS = 1
               END IF
		irec = ISREC

		itrc = ITRCS

cmam		call savew(I4THDR,'StaCor',0,1)
        call savew2(I4THDR,j_StaCor,i_StaCor,l_StaCor,0,TRCHED)

cmam		call savew(I4THDR,'RecNum',ISREC,1)
        call savew2(I4THDR,j_RecNum,i_RecNum,l_RecNum,ISREC,TRCHED)

cmam		call savew(I4THDR,'TrcNum',ITRCS,1)
        call savew2(I4THDR,j_TrcNum,i_TrcNum,l_TrcNum,ITRCS,TRCHED)

            END IF
C
 8200       IF (IDRY .EQ. 1 .OR. NUMBYT .EQ. NBO) GO TO 8300
            WRITE (IPR,8250) irec, itrc

 8250       FORMAT('0** M3060 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $            13X, 'RECORD NUMBER ', I5, ' TRACE NUMBER ', I5     ,
     $                 ' DOES NOT CONTAIN THE'                        /
     $            13X, 'NUMBER OF SAMPLES AS FILED IN THE INPUT '     ,
     $                 'DATA SET LINE HEADER'                         /
     $            13X, 'VERIFY THE LINE HEADER ENTRIES FOR NUMBER '   ,
     $                 'OF SAMPLES AND FORMAT CODE'                   /)
            ICC = 100
            GO TO 9400
C
C-----------------------------------------------------------------------
C     DO WE HAVE THE CORRECT RECORD & TRACE NUMBER FOR PROCESSING
C-----------------------------------------------------------------------
C
 8300   continue

c8300       call saver(I4THDR,'RecNum',irec,1)

            IF (irec .EQ. IRI .OR. IRI .GT. 32767) GO TO 8400

            WRITE (IPR,8350) irec, IRI

c.c         WRITE (IPR,8350) I4THDR(106), IRI
 8350       FORMAT('0** M3061 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $            13X, 'THE INPUT RECORD NUMBER ', I5, ' DOES NOT '   ,
     $                 'CORRESPOND TO THE RECORD'                     /
     $            13X, 'NUMBER ',I10, ' SPECIFIED ON THE 1SORC '      ,
     $                 'PARAMETER CARD'                               /
     $            13X, 'CHECK FOR ERRONEOUS OR MISSING 1SORC CARDS '  ,
     $                 'AND/OR PREVIOUS PROCESSING IRREGULARITIES'    /)
            ICC = 100
            IF (IDRY .EQ. 0)
     $      GO TO 9400
C
 8400  continue

c8400       call saver(I4THDR,'TrcNum',itrc,1)

            IF (itrc .EQ. IT) GO TO 8500

            WRITE (IPR,8450) itrc, IT

c.c         WRITE (IPR,8450) I4THDR(107), I4THDR(107)
 8450       FORMAT('0** M3062 ** ERROR DETECTED BY PROGRAM PR3D:'     /
     $            13X, 'THE INPUT TRACE NUMBER ', I5, ' FOR INPUT '   ,
     $                 'RECORD NUMBER ', I5, ' DOES'                  /
     $            13X, 'NOT CORRESPOND TO THE TRACE NUMBER EXPECTED'  /
     $            13X, 'VERIFY THE LINE HEADER ENTRY FOR NUMBER OF '  ,
     $                 'TRACES PER RECORD AND CHECK'                  /
     $            13X, 'FOR PREVIOUS PROCESSING IRREGULARITIES'       /)
            ICC = 100
            GO TO 9400
C
C=======================================================================
C
C     FILL THE TRACE HEADERS WITH DESCRIPTIVE INFORMATION
C          1- SOURCE X-COORDINATE & Y-COORDINATE
C          2- GROUP  X-COORDINATE & Y-COORDINATE
C          3- CDP    X-COORDINATE & Y-COORDINATE
C          4- SHOT DEPTH
C          5- UPHOLE TIME
C          6- RECORD NUMBER & TRACE NUMBER
C          7- SOURCE ELEVATION
C          8- SOURCE-TO-RECEIVER DISTANCE (SIGNED & UNSIGNED)
C          9- SOURCE-TO-RECEIVER AZIMUTH  (RADIANS*10000)
C         10- GROUP LOCATION
C         11- GROUP ELEVATION
C         12- DEPTH POINT ELEVATION
C         13- REGIONAL REFERENCE SURFACE
C         14- SOURCE POINT NUMBER
C         15- STATIC
C
C=======================================================================
C
 8500       IG                = NGI(IT)
C
            I4T16       = 0.5 * (ISX + IGX(IG)) + 0.5

            I4T17       = 0.5 * (ISY + IGY(IG)) + 0.5

cmam	call savew(I4THDR,'SrRcMX',I4T16,1)
        call savew2(I4THDR,j_SrRcMY,i_SrRcMY,l_SrRcMY,I4T16,TRCHED)

cmam	call savew(I4THDR,'SrRcMY',I4T17,1)
        call savew2(I4THDR,j_SrRcMY,i_SrRcMY,l_SrRcMY,I4T17,TRCHED)

C
            IF (MODE.EQ.2) GO TO 8555
C
cmam	call savew(I4THDR,'SrPtXC',ISX,1)
        call savew2(I4THDR,j_SrPtXC,i_SrPtXC,l_SrPtXC,ISX,TRCHED)

cmam	call savew(I4THDR,'SrPtYC',ISY,1)
        call savew2(I4THDR,j_SrPtYC,i_SrPtYC,l_SrPtYC,ISY,TRCHED)

C
cmam	call savew(I4THDR,'RcPtXC',IGX(IG),1)
        call savew2(I4THDR,j_RcPtXC,i_RcPtXC,l_RcPtXC,IGX(IG),TRCHED)
cmam     1         2         3         4         5         6         7         8

cmam	call savew(I4THDr,'RcPtYC',IGY(IG),1)
        call savew2(I4THDR,j_RcPtYC,i_RcPtYC,l_RcPtYC,IGY(IG),TRCHED)

C
cmam	call savew(I4THDR,'ShtDep',ISD,1)
        call savew2(I4THDR,j_ShtDep,i_ShtDep,l_ShtDep,ISD,TRCHED)

cmam	call savew(I4THDR,'UphlTm',IUT,1)
        call savew2(I4THDR,j_UphlTm,i_UphlTm,l_UphlTm,IUT,TRCHED)

cmam	call savew(I4THDR,'SrcLoc',IGLI,1)
        call savew2(I4THDR,j_SrcLoc,i_SrcLoc,l_SrcLoc,IGLI,TRCHED)

cmam	call saver(I4THDR,'RecNum',irec,1)
        call saver2(I4THDR,j_RecNum,i_RecNum,l_RecNum,irec,TRCHED)

cmam	call savew(I4THDR,'PrRcNm',irec,1)
        call savew2(I4THDR,j_PrRcNm,i_PrRcNm,l_PrRcNm,irec,TRCHED)

cmam	call saver(I4THDR,'TrcNum',itrc,1)
        call saver2(I4THDR,j_TrcNum,i_TrcNum,l_TrcNum,itrc,TRCHED)

cmam	call savew(I4THDR,'PrTrNm',itrc,1)
        call savew2(I4THDR,j_PrTrNm,i_PrTrNm,l_PrTrNm,itrc,TRCHED)

cmam	call savew(I4THDR,'SrPtEl',ISE,1)
        call savew2(I4THDR,j_SrPtEl,i_SrPtEl,l_SrPtEl,ISE,TRCHED)

C
            X9                = IGX(IG) - ISX

            Y9                = IGY(IG) - ISY

C
            IDIST             = SQRT (X9 * X9 + Y9 * Y9) + 0.5
cmam	call savew(I4THDR,'DstUsg',IDIST,1)
        call savew2(I4THDR,j_DstUsg,i_DstUsg,l_DstUsg,IDIST,TRCHED)

C
            AZMUTH            = 0.0
            IF (X9 .NE. 0.0 .OR. Y9 .NE. 0.0) AZMUTH = ATAN2(Y9,X9)
	    iazm = (AZMUTH + SIGN(0.00005,AZMUTH)) * 10000

cmam	call savew(I4THDR,'SrRcAz',iazm,1)
        call savew2(I4THDR,j_SrRcAz,i_SrRcAz,l_SrRcAz,iazm,TRCHED)

C
cmam	call savew(I4THDR,'RecInd',IG,1)
        call savew2(I4THDR,j_RecInd,i_RecInd,l_RecInd,IG,TRCHED)

cmam	call savew(I4THDR,'DstSgn',IDIST,1)
        call savew2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,IDIST,TRCHED)

cmam	call savew(I4THDR,'GrpElv',IGE(IG),1)
        call savew2(I4THDR,j_GrpELv,i_GrpELv,l_GrpELv,IGE(IG),TRCHED)

C
	    I2T123 = 0.5 * (ISE + IGE  (IG)) + 0.5

cmam	call savew(I4THDR,'DePtEl',I2T123,1)
        call savew2(I4THDR,j_DePtEl,i_DePtEl,l_DePtEl,I2T123,TRCHED)

	    I2T124 = 0.5 * (ISRRS+IGRRS(IG)) + 0.5

cmam	call savew(I4THDR,'RfSrEl',I2T124,1)
        call savew2(I4THDR,j_RfSrEl,i_RfSrEl,l_RfSrEl,I2T124,TRCHED)

C
C *** COMPUTE CABLE DEPTH IF DATA IS PROBABLY MARINE
C
            IF (I5SPRD .EQ. 1)
cmam	*		call savew(I4THDR,'CabDep',IGE(IG),1)
     *		call savew2(I4THDR,j_CabDep,i_CabDep,l_CabDep,
     *		IGE(IG),TRCHED)

C
c.c	    call saver(I4THDR,'TrcNum',itrc,1)

            IF (OMTBUF(itrc) .EQ. 30000)

cmam	*		call savew(I4THDR,'StaCor',30000,1)
     *		call savew2(I4THDR,j_StaCor,i_StaCor,l_StaCor,
     *		30000,TRCHED)

C
cmam	call saver(I4THDR,'StaCor',istat,1)
        call saver2(I4THDR,j_StaCor,i_StaCor,l_StaCor,istat,TRCHED)

            IF (istat .EQ. 30000)GOTO 8509

	   	I2T8 = NINT ((ISRRS - ISE + ISD)  * SWVELJ)

cmam	call savew(I4THDR,'InStUn',I2T8,1)
        call savew2(I4THDR,j_InStUn,i_InStUn,l_InStUn,I2T8,TRCHED)

		I2T11 = NINT ((IGRRS(IG) -IGE(IG)) * SWVELJ)

cmam	call savew(I4THDR,'RcStUn',I2T11,1)
        call savew2(I4THDR,j_RcStUn,i_RcStUn,l_RcStUn,I2T11,TRCHED)

		I2T15 = I2T8 + I2T11

cmam	call savew(I4THDR,'ToStUn',I2T15,1)
        call savew2(I4THDR,j_ToStUn,i_ToStUn,l_ToStUn,I2T15,TRCHED)

cmam	call savew(I4THDR,'InStAp',0,1)
        call savew2(I4THDR,j_InStAp,i_InStAp,l_InStAp,0,TRCHED)

cmam	call savew(I4THDR,'RcStAp',0,1)
        call savew2(I4THDR,j_RcStAp,i_RcStAp,l_RcStAp,0,TRCHED)

cmam	call savew(I4THDR,'ToStAp',0,1)
        call savew2(I4THDR,j_ToStAp,i_ToStAp,l_ToStAp,0,TRCHED)

                I4THDR( 19) = 0
                I4THDR( 20) = 0
cmam	call savew(I4THDR,'FlDtEl',0,1)
        call savew2(I4THDR,j_FlDtEl,i_FlDtEl,l_FlDtEl,0,TRCHED)

		I2T125 = NINT (I2T15 * 0.25)

cmam	call savew(I4THDR,'StaCor',I2T125,1)
        call savew2(I4THDR,j_StaCor,i_StaCor,l_StaCor,I2T125,TRCHED)

cmam	call savew(I4THDR,'DatShf',0,1)
        call savew2(I4THDR,j_DatShf,i_DatShf,l_DatShf,0,TRCHED)

 8509       CONTINUE
C
cmam	call savew(I4THDR,'SoPtNm',ISPNO,1)
        call savew2(I4THDR,j_SoPtNm,i_SoPtNm,l_SoPtNm,ISPNO,TRCHED)

cmam	call savew(I4THDR,'SoPtAl',ASPNO,1)
        call savew2(I4THDR,j_SoPtAl,i_SoPtAl,l_SoPtAl,ASPNO,TRCHED)

c.c         CALL MOVE (1,I4THDR(128),ASPNO,1)
C
 8515	continue

c8515	    call saver(I4THDR,'TrcNum',itrc,1)

            IF (INVBUF(itrc) .EQ. 0) GO TO 8550

C
C
C
 8530	    xneg1 = -1.

     	    call vsmul(trace,1,xneg1,trace,1,itrlen)

C
 8550       IF (.NOT.INDXNG) GO TO 8580
 8555       CALL BINCTR (I4T16,I4T17,DX,DY,ILI,IDI,

     $                   IBINX,IBINY,IWARN)
            ILIB        = ILI + LIBIAS
cmam	call savew(I4THDR,'LinInd',ILIB,1)
        call savew2(I4THDR,j_LinInd,i_LinInd,l_LinInd,ILIB,TRCHED)

            IDIB        = IDI + DIBIAS
cmam	call savew(I4THDR,'DphInd',IDIB,1)
        call savew2(I4THDR,j_DphInd,i_DphInd,l_DphInd,IDIB,TRCHED)

cmam	call savew(I4THDR,'CDPBCX',IBINX,1)
        call savew2(I4THDR,j_CDPBCX,i_CDPBCX,l_CDPBCX,IBINX,TRCHED)

cmam	call savew(I4THDR,'CDPBCY',IBINY,1)
        call savew2(I4THDR,j_CDPBCY,i_CDPBCY,l_CDPBCY,IBINY,TRCHED)

            IFO = (ILI - 1) * NX + IDI
C
C-----------------------------------------------------------------------
C     ASSIGN NEGATIVE SIGNED DISTANCE IF DI FOR SOURCE IS
C     GREATER THEN DI FOR RECEIVER. IF THEY HAVE THE SAME DI,
C     ASSIGN NEGATIVE SIGNED DISTANCE
C     IF LI FOR SOURCE IS GREATER THAN LI FOR RECEIVER.
C-----------------------------------------------------------------------
C
cmam	call saver(I4THDR,'SrPtXC',I4T12,1)
        call saver2(I4THDR,j_SrPtXC,i_SrPtXC,l_SrPtXC,I4T12,TRCHED)

cmam	call saver(I4THDR,'SrPtYC',I4T13,1)
        call saver2(I4THDR,j_SrPtYC,i_SrPtYC,l_SrPtYC,I4T13,TRCHED)

            CALL ILIDI (I4T12,I4T13,ISLI,ISDI,IDUM)
cmamtest	write(LERR,*)'computed isli,isdi=',isli,isdi

cmam	call saver(I4THDR,'RcPtXC',I4T14,1)
        call saver2(I4THDR,j_RcPtXC,i_RcPtXC,l_RcPtXC,I4T14,TRCHED)

cmam	call saver(I4THDR,'RcPtYC',I4T15,1)
        call saver2(I4THDR,j_RcPtYC,i_RcPtYC,l_RcPtYC,I4T15,TRCHED)

            CALL ILIDI (I4T14,I4T15,IRLI,IRDI,IDUM)

c.c         CALL ILIDI (I4THDR(12),I4THDR(13),ISLI,ISDI,IDUM)
c.c         CALL ILIDI (I4THDR(14),I4THDR(15),IRLI,IRDI,IDUM)
            IF (I5SPRD .EQ. 1) THEN
               IGLI = ISDI * 10
               IF (IGLI .GT. 32767) IGLI = - IGLI / 10
cmam	call savew(I4THDR,'SrcLoc',IGLI,1)
        call savew2(I4THDR,j_SrcLoc,i_SrcLoc,l_SrcLoc,IGLI,TRCHED)

cmam	call savew(I4THDR,'RecInd',IRDI,1)
        call savew2(I4THDR,j_RecInd,i_RecInd,l_RecInd,IRDI,TRCHED)

            END IF
            IF (ISDI .GT. IRDI) THEN
cmam	call saver(I4THDR,'DstSgn',idstsg,1)
        call saver2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,idstsg,TRCHED)

		idstsg = -idstsg

cmam	call savew(I4THDR,'DstSgn',idstsg,1)
        call savew2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,idstsg,TRCHED)

            ELSE IF (ISDI .EQ. IRDI) THEN
               IF (ISLI .GT. IRLI) THEN
cmam	call saver(I4THDR,'DstSgn',idstsg,1)
        call saver2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,idstsg,TRCHED)

		idstsg = -idstsg

cmam	call savew(I4THDR,'DstSgn',idstsg,1)
        call savew2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,idstsg,TRCHED)

               END IF
            END IF
            IF (IWARN.EQ.0) THEN
cmam	call savew(I4THDR,'FoldNm',KOUNT(IFO),1)
        call savew2(I4THDR,j_FoldNm,i_FoldNm,l_FoldNm,
     *		KOUNT(IFO),TRCHED)

cmam	call savew(I4THDR,'SrcPnt',SPABOV(IFO),1)
        call savew2(I4THDR,j_SrcPnt,i_SrcPnt,l_SrcPnt,
     *		SPABOV(IFO),TRCHED)

cmam	call savew(I4THDR,'FlDtEl',FDATUM(IFO),1)
        call savew2(I4THDR,j_FlDtEl,i_FlDtEl,l_FlDtEl,
     *		FDATUM(IFO),TRCHED)

		idat = fdatum(ifo)

		I2T19 =  NINT ((idat - ISE + ISD)   * SWVELJ)

		I2T20 = NINT ((idat-IGE(IG))* SWVELJ)

c.c.c.....i don't know about this.....................

cmam......4019095....cannot set this using keywords and the save functions.
cmam			originally defined as binary zeros, and no keywords
cmam			have been assigned to these positions.
cmam			therefore, we will eliminate it.
cmam		I4THDR(19) = I2T19

cmam		I4THDR(20) = I2T20
cmam.......................................................................

               GO TO 8580
            END IF
cmam		call saver(I4THDR,'StaCor',istat,1)
        call saver2(I4THDR,j_StaCor,i_StaCor,l_StaCor,istat,TRCHED)

            IF (istat.EQ.30000) GO TO 8580

            CALL WRNLIM (MAXFLG)
cmam		call savew(I4THDR,'StaCor',30000,1)
        call savew2(I4THDR,j_StaCor,i_StaCor,l_StaCor,30000,TRCHED)

            IF (MAXFLG.EQ.0) then

cmam		call saver(I4THDR,'RecNum',irec,1)
        call saver2(I4THDR,j_RecNum,i_RecNum,l_RecNum,irec,TRCHED)

cmam		call saver(I4THDR,'TrcNum',itrc,1)
        call saver2(I4THDR,j_TrcNum,i_TrcNum,l_TrcNum,itrc,TRCHED)

                WRITE (IPR,8560) irec,itrc,ILIB,IDIB

	    endif

 8560       FORMAT (' ** WARNING ** RI',I5,' TRACE',I5,
     $              ' OUTSIDE GRID ',
     $              'BOUNDARIES:  LINE INDEX =',I5,' DEPTH INDEX =',I5,
     $              '.  TRACE FLAGGED DEAD.')
C
 8580       CONTINUE
cmam		call saver(I4THDR,'StaCor',istat,1)
        call saver2(I4THDR,j_StaCor,i_StaCor,l_StaCor,istat,TRCHED)

cmam		call saver(I4THDR,'DstSgn',idstsg,1)
        call saver2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,idstsg,TRCHED)

            IF (istat .NE. 30000) THEN

               MINLI  = MIN (MINLI,  ILI)
               MINDI  = MIN (MINDI,  IDI)
               MINSLI = MIN (MINSLI, ISLI)
               MINSDI = MIN (MINSDI, ISDI)
               MINRLI = MIN (MINRLI, IRLI)
               MINRDI = MIN (MINRDI, IRDI)
               IF (IDIST .LT. IABS(MINDST)) MINDST = idstsg

               MAXLI  = MAX (MAXLI,  ILI)
               MAXDI  = MAX (MAXDI,  IDI)
               MAXSLI = MAX (MAXSLI, ISLI)
               MAXSDI = MAX (MAXSDI, ISDI)
               MAXRLI = MAX (MAXRLI, IRLI)
               MAXRDI = MAX (MAXRDI, IRDI)
               IF (IDIST .GT. IABS(MAXDST)) MAXDST = idstsg

            END IF
            MNLI     = MIN (MNLI,  ILI)
            MNDI     = MIN (MNDI,  IDI)
            MNSLI = MIN (MNSLI, ISLI)
cmamtest	write(LERR,*)'mnsli,isli=',mnsli,isli
            MNSDI = MIN (MNSDI, ISDI)
cmamtest	write(LERR,*)'mnsdi,isdi=',mnsdi,isdi
            MNRLI = MIN (MNRLI, IRLI)
            MNRDI = MIN (MNRDI, IRDI)
            IF (IDIST .LT. IABS(MNDST)) MNDST = idstsg

            MXLI     = MAX (MAXLI, ILI)
            MXDI     = MAX (MAXDI, IDI)
            MXSLI = MAX (MAXSLI, ISLI)
            MXSDI = MAX (MAXSDI, ISDI)
            MXRLI = MAX (MAXRLI, IRLI)
            MXRDI = MAX (MAXRDI, IRDI)
            IF (IDIST .GT. IABS(MXDST)) MXDST = idstsg

            IF (IDRY .EQ. 0)
     $      CALL WRTAPE (LUOUT,TRAREC,NBO)
C
C-----------------------------------------------------------------------
C     PRINT DESCRIPTIVE INFORMATION FOR TRACES
C-----------------------------------------------------------------------
C
            IF (IBRIEF .NE. 0) GO TO 8590
C
            IF (JSEG .GT. NSEG        .OR.
     $          IT   .NE. TRSEG(JSEG)     ) GO TO 8700
            JSEG              = JSEG + 1
            GO TO 8595
C
 8590       IF (IT .NE. 1 .AND. IT .NE. NOTPSR) GO TO 8700
C
 8595       CONTINUE
            IF (I5SPRD .EQ. 1) GO TO 8700
cmam	call saver(I4THDR,'ToStUn',itotst,1)
        call saver2(I4THDR,j_ToStUn,i_ToStUn,l_ToStUn,itotst,TRCHED)

            IST=itotst*0.25

cmam	call saver(I4THDR,'StaCor',istat,1)
        call saver2(I4THDR,j_StaCOr,i_StaCOr,l_StaCOr,istat,TRCHED)

            IF(istat.EQ.30000)IST=30000

	if(MODE.eq.0) then

cmam	call saver(I4THDR,'PrTrNm',i2t111,1)
        call saver2(I4THDR,j_PrTrNm,i_PrTrNm,l_PrTrNm,i2t111,TRCHED)

cmam	call saver(I4THDR,'RecInd',i2t118,1)
        call saver2(I4THDR,j_RecInd,i_RecInd,l_RecInd,i2t118,TRCHED)

cmam	call saver(I4THDR,'DstSgn',i2t119,1)
        call saver2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,i2t119,TRCHED)

cmam	call saver(I4THDR,'RcPtXC',i4t14,1)
        call saver2(I4THDR,j_RcPtXC,i_RcPtXC,l_RcPtXC,i4t14,TRCHED)

cmam	call saver(I4THDR,'RcPtYC',i4t15,1)
        call saver2(I4THDR,j_RcPtYC,i_RcPtYC,l_RcPtYC,i4t15,TRCHED)

cmam	call saver(I4THDR,'GrpElv',i2t120,1)
        call saver2(I4THDR,j_GrpElv,i_GrpElv,l_GrpElv,i2t120,TRCHED)

cmam	call saver(I4THDR,'SrRcMX',i4t16,1)
        call saver2(I4THDR,j_SrRcMX,i_SrRcMX,l_SrRcMX,i4t16,TRCHED)

cmam	call saver(I4THDR,'SrRcMY',i4t17,1)
        call saver2(I4THDR,j_SrRcMY,i_SrRcMY,l_SrRcMY,i4t17,TRCHED)

cmam	call saver(I4THDR,'DePtEl',i2t123,1)
        call saver2(I4THDR,j_DePtEL,i_DePtEL,l_DePtEL,i2t123,TRCHED)

cmam	call saver(I4THDR,'RfSrEl',i2t124,1)
        call saver2(I4THDR,j_RfSrEl,i_RfSrEl,l_RfSrEl,i2t124,TRCHED)

                write(IPR,8600) i2t111,i2t118,i2t119,

     $		i4t14,i4t15,i2t120,

     $          IGRRS (IG), IST, I4T16,

     $		i4t17,i2t123,i2t124

	endif

C.....

	if(MODE.ne.0) then

cmam	call saver(I4THDR,'PrTrNm',i2t111,1)
        call saver2(I4THDR,j_PrTrNm,i_PrTrNm,l_PrTrNm,i2t111,TRCHED)

cmam	call saver(I4THDR,'RecInd',i2t118,1)
        call saver2(I4THDR,j_RecInd,i_RecInd,l_RecInd,i2t118,TRCHED)

cmam	call saver(I4THDR,'DstSgn',i2t119,1)
        call saver2(I4THDR,j_DstSgn,i_DstSgn,l_DstSgn,i2t119,TRCHED)

cmam	call saver(I4THDR,'RcPtXC',i4t14,1)
        call saver2(I4THDR,j_RcPtXC,i_RcPtXC,l_RcPtXC,i4t14,TRCHED)

cmam	call saver(I4THDR,'RcPtYC',i4t15,1)
        call saver2(I4THDR,j_RcPtYC,i_RcPtYC,l_RcPtYC,i4t15,TRCHED)

cmam	call saver(I4THDR,'GrpElv',i2t120,1)
        call saver2(I4THDR,j_GrpElv,i_GrpElv,l_GrpElv,i2t120,TRCHED)

cmam	call saver(I4THDR,'SrRcMX',i4t16,1)
        call saver2(I4THDR,j_SrRcMX,i_SrRcMX,l_SrRcMX,i4t16,TRCHED)

cmam	call saver(I4THDR,'SrRcMY',i4t17,1)
        call saver2(I4THDR,j_SrRcMY,i_SrRcMY,l_SrRcMY,i4t17,TRCHED)

cmam	call saver(I4THDR,'DePtEl',i2t123,1)
        call saver2(I4THDR,j_DePtEl,i_DePtEl,l_DePtEl,i2t123,TRCHED)

cmam	call saver(I4THDR,'RfSrEl',i2t124,1)
        call saver2(I4THDR,j_RfSrEl,i_RfSrEl,l_RfSrEl,i2t124,TRCHED)

cmam	call saver(I4THDR,'LinInd',i2t121,1)
        call saver2(I4THDR,j_LinInd,i_LinInd,l_LinInd,i2t121,TRCHED)

cmam	call saver(I4THDR,'DphInd',i2t122,1)
        call saver2(I4THDR,j_DphInd,i_DphInd,l_DphInd,i2t122,TRCHED)

cmam	call saver(I4THDR,'CDPBCX',i4t18,1)
        call saver2(I4THDR,j_CDPBCX,i_CDPBCX,l_CDPBCX,i4t18,TRCHED)

cmam	call saver(I4THDR,'CDPBCY',i4t19,1)
        call saver2(I4THDR,j_CDPBCY,i_CDPBCY,l_CDPBCY,i4t19,TRCHED)

cmam	call saver(I4THDR,'FoldNm',i2t105,1)
        call saver2(I4THDR,j_FoldNm,i_FoldNm,l_FoldNm,i2t105,TRCHED)

cmam..used wrong format number....write(IPR,8600) i2t111,i2t118,i2t119,

                write(IPR,8610) i2t111,i2t118,i2t119,

     $          i4t14,i4t15,i2t120,

     $          IGRRS (IG), IST, I4T16,

     $          i4t17,i2t123,i2t124,

     $		i2t121,i2t122,

     $		i4t18,i4t19,i2t105

	endif

C
 8600       FORMAT(1X,                I5,       2X,I5,       3X,I6,
     $                             4X,I8,       4X,I8,       5X,I5,
     $                             7X,I5,       5X,I5,       3X,I8,
     $                             4X,I8,       5X,I5,       7X,I5)
C
 8610       FORMAT(1X,                I5,       1X,I5,          I6,
     $                             1X,I8,       1X,I8,       1X,I5,
     $                             3X,I5,       3X,I5,       1X,I8,
     $                             1X,I8,       1X,I5,       3X,I5,
     $                             1X,I5,       1X,I5,
     $                             1X,I8,       1X,I8,       1X,I5)
C
 8700    CONTINUE
C
 8800 CONTINUE


C
      WRITE (IPR, 8850) MINLI,MAXLI,MINDI,MAXDI,
     $                  MINSLI,MAXSLI,MINSDI,MAXSDI,
     $                  MINRLI,MAXRLI,MINRDI,MAXRDI,
     $                  MINDST,MAXDST
C
      IF (MODE.EQ.1.OR.MODE.EQ.2) THEN
         NLI        = MAXLI - MINLI + 1
         NDI        = MAXDI - MINDI + 1
         NLIDI      = NLI  * NDI
        iget = NLIDI * SZSMPD
cmam    iget = NLIDI * HLHINT

c---------------------------------------------

c       allocate memory for needed buffers

c---------------------------------------------

        call galloc(icount,iget,errcd,abort)

        if(errcd .ne. 0) then

           write(LERR,*) ' '

           write(LERR,*) 'Unable to allocate workspace for COUNT'

           write(LERR,*) 'FATAL'

           stop 999

        endif

c-----------------------------------------------

c       clear allocated memory buffers to zero

c-----------------------------------------------

        call move (0, COUNT,  0, iget)

         DO 8825 IXX = 1, NXY
            IFOLD = KOUNT(IXX)

            ILI = (IXX + NX  - 1) / NX
            IDI = IXX - (ILI - 1) * NX
            ILI = ILI - MINLI + 1
            IDI = IDI - MINDI + 1
            IF (ILI .GT. 0 .AND. ILI .LE. NLI .AND.
     &          IDI .GT. 0 .AND. IDI .LE. NDI)THEN
               IFO = (ILI - 1) * NDI + IDI
               COUNT(IFO)  = IFOLD

            END IF
 8825    CONTINUE
         CALL CELLPR(IPR,ISIGN,NDI,NLI,NLIDI,COUNT(1))

cmam.....added this for cell count output dataset

C *------------------------------------------------------------------* C
C *  If ocell specified, open it, otherwise omit this part

C *------------------------------------------------------------------* C
        if(ocell(1:1) .ne. ' ') then

          call getln (lucell, ocell, 'w', 1)

cmam	call savew( i4lhdr, 'NumTrc', nli  , LINHED)
        call savew2(I4LHDR,j_NumTrc,i_NumTrc,l_NumTrc,nli,LINHED)

cmam	call savew( i4lhdr, 'NumRec', 1    , LINHED)
        call savew2(I4LHDR,j_NumRec,i_NumRec,l_NumRec,1,LINHED)

cmam	call savew( i4lhdr, 'SmpInt', 1    , LINHED)
        call savew2(I4LHDR,j_SmpInt,i_SmpInt,l_SmpInt,1,LINHED)

cmam	call savew( i4lhdr, 'NumSmp', ndi  , LINHED)
        call savew2(I4LHDR,j_NumSmp,i_NumSmp,l_NumSmp,ndi,LINHED)

cmam	call savew( i4lhdr, 'Format', 3    , LINHED)
        call savew2(I4LHDR,j_Format,i_Format,l_Format,3,LINHED)

          lbytes = HSTOFF

          nbyt = 2 * SZHFWD

cmam	call savew( i4lhdr, 'HlhEnt',  0   , LINHED)
        call savew2(I4LHDR,j_HlhEnt,i_HlhEnt,l_HlhEnt,0,LINHED)

cmam	call savew( i4lhdr, 'HlhByt', nbyt , LINHED)
        call savew2(I4LHDR,j_HlhByt,i_HlhByt,l_HlhByt,nbyt,LINHED)

          call savhlh( i4lhdr, lbytes, lbyout )

          CALL WRTAPE ( LUCELL, i4lhdr, LBYOUT                 )

c     TRACEHEADER is a value in the include file <sisdef.h> that

c     refers to the trace header



          lobyts = SZTRHD + SZSMPD*ndi

cmam    print *,'nxy,nx,lobyts=',nxy,nx,lobyts

	ktrc = 0

	kxy = ndi*nli

          do 8830 ixx = 1,kxy,ndi

          ktrc = ktrc + 1

          kli = (ixx+ndi-1)/ndi

          kdi = ixx-(kli-1)*ndi

cmam	call savew(trarec,'RecNum',1,1)
        call savew2(I4LHDR,j_RecNum,i_RecNum,l_RecNum,1,TRCHED)

cmam	call savew(trarec,'TrcNum',ktrc,1)
        call savew2(I4LHDR,j_TrcNum,i_TrcNum,l_TrcNum,ktrc,TRCHED)

cmam	call savew(trarec,'DphInd',kdi,1)
        call savew2(I4LHDR,j_DphInd,i_DphInd,l_DphInd,kdi,TRCHED)

cmam	call savew(trarec,'LinInd',kli,1)
        call savew2(I4LHDR,j_LinInd,i_LinInd,l_LinInd,kli,TRCHED)

          do 8829 ii = 1,ndi

 8829     trace(ii) = count(ixx+ii-1)

          call wrtape(lucell,trarec,lobyts)

 8830     continue

          call lbclos(lucell)

        endif

cmam..............................................................

      END IF
C
      WRITE (IPR, 8860) MNLI,MXLI,MNDI,MXDI,
     $                  MNSLI,MXSLI,MNSDI,MXSDI,
     $                  MNRLI,MXRLI,MNRDI,MXRDI,
     $                  MNDST,MXDST
C
 8850 FORMAT (//,' LIMITS ON LIVE TRACES ',/,
     $           10X,'MINIMUM LI. . . . . . . . . . . .',I10,/,
     $           10X,'MAXIMUM LI. . . . . . . . . . . .',I10,/,
     $           10X,'MINIMUM DI. . . . . . . . . . . .',I10,/,
     $           10X,'MAXIMUM DI. . . . . . . . . . . .',I10,/,
     $           10X,'MINIMUM LI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MAXIMUM LI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MINIMUM DI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MAXIMUM DI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MINIMUM LI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MAXIMUM LI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MINIMUM DI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MAXIMUM DI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MINIMUM DISTANCE. . . . . . . . .',I10,/,
     $           10X,'MAXIMUM DISTANCE. . . . . . . . .',I10,//)
 8860 FORMAT (//,' LIMITS ON ALL TRACES ',/,
     $           10X,'MINIMUM LI. . . . . . . . . . . .',I10,/,
     $           10X,'MAXIMUM LI. . . . . . . . . . . .',I10,/,
     $           10X,'MINIMUM DI. . . . . . . . . . . .',I10,/,
     $           10X,'MAXIMUM DI. . . . . . . . . . . .',I10,/,
     $           10X,'MINIMUM LI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MAXIMUM LI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MINIMUM DI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MAXIMUM DI AT SOURCE. . . . . . .',I10,/,
     $           10X,'MINIMUM LI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MAXIMUM LI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MINIMUM DI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MAXIMUM DI AT RECEIVER. . . . . .',I10,/,
     $           10X,'MINIMUM DISTANCE. . . . . . . . .',I10,/,
     $           10X,'MAXIMUM DISTANCE. . . . . . . . .',I10,//)
      GO TO 9500
C
C-----------------------------------------------------------------------
C     END-OF-DECK ENCOUNTERED BEFORE NUMBER OF RECORDS PROCESSED
C-----------------------------------------------------------------------
C
 9000 WRITE (IPR,9010)
 9010 FORMAT('0** M3067 ** ERROR DETECTED BY PROGRAM PR3D:'          /
     $         13X, 'PREMATURE END-OF-CARD-DECK'/)
      ICC = 100
      GO TO 9400
C
 9280 WRITE (IPR,9290)
 9290 FORMAT('0** M3063 ** WARNING FROM PROGRAM PR3D:'               /
     $         13X, 'END-OF-DECK ENCOUNTERED BEFORE THE SPECIFIED '  ,
     $              'NUMBER OF RECORDS WERE PROCESSED'               /
     $         13X, 'THE RECORDS SPECIFIED ON THE 1SORC PARAMETER '  ,
     $              'CARDS HAVE BEEN SUCCESSFULLY'                   /
     $         13X, 'PROCESSED BUT ANY REMAINING RECORDS ON THE '    ,
     $              'INPUT DATA SET HAVE NOT BEEN OUTPUT'            /
     $         13X, 'VERIFY THE LINE HEADER ENTRY FOR NUMBER OF '    ,
     $              'RECORDS, CHECK PARAMETER CARDS'                 /
     $         13X, 'FOR MISSING CARDS, AND CHECK FOR PREVIOUS '     ,
     $              'PROCESSING IRREGULARITIES'                      /)
C
 9400 NOSREC = NREC
C
C-----------------------------------------------------------------------
C     DO THE ACCOUNTING
C     CLOSE THE I/O DEVICES
C-----------------------------------------------------------------------
C
 9500 continue

      IF (IDRY .EQ. 0) THEN
	call lbclos (luin)

	call lbclos (luout)

      END IF
 9510 format(a10)

	close(icrd,status='delete')

      CALL CCEXIT (ICC)
      END
CPROG FLDH
      SUBROUTINE FLDH (KARD,LINHD1,LINHD2,IRD,IPR,N,*)
C
C***********************************************************************
C
C     SUBROUTINE - FLDH
C
C     AUTHOR - DOUGLAS BODDY
C
C     DATE WRITTEN - NOVEMBER, 1983
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT - PROCESS 1FLDH CARDS
C
C***********************************************************************
C
#include <f77/lhdrsz.h>

#include <f77/sisdef.h>

#include <f77/iounit.h>

      INTEGER LINHD2(*)
cmam  INTEGER*2 LINHD2(3000)
C
        character*1 LINHD1(*), pkard(35)

      CHARACTER*80 KARD
	logical EOC

C
	data EOC/.FALSE./

C
C
      CALL WRCARD (KARD,1,IPR)
        call DEFLDH(linhd2,n,linhd1)

C
C     +---------------------------------------------------------------+
C
      GO TO 60
C
 30   EOC = .TRUE.
      GO TO 100
C
c40   READ (IRD,50,END=30) KARD
cmam...............................072893

 40   READ(IRD,50,END=30)KARD,(pkard(jj),jj=1,35)

 50   FORMAT (A80,T11,35a1)

cmam...............................072893

c50   FORMAT (A80)
      IF (KARD(1:5).NE.'1FLDH') GO TO 100
      CALL WRCARD (KARD,3,IPR)
C
C     +----------------------------------------------------+
C     +----------------------------------------------------+
C
C
   60 nchar = leng2(KARD(11:11), 35)

        if(nchar.lt.1) nchar = 1

        call INFLDH(linhd2,n,kard,nchar,linhd1)

        go to 40

  100 RETURN

      END


CPROG WRNLIM
      SUBROUTINE WRNLIM (MAXFLG)
C
C***********************************************************************
C
C     SUBROUTINE - WRNLIM         ENTRY POINTS - WRNLIM, SETFLG
C                                                RESLIM, GETWRN
C
C     AUTHOR - DOUGLAS BODDY
C
C     DATE WRITTEN - NOVEMBER, 1983
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT - CHECK IF NUMBER OF ALLOWABLE WARNINGS HAS BEEN REACHED
C
C***********************************************************************
C
      DATA MAXWRN/1000/
      DATA NUMWRN/0/
      DATA MAXXWN/50000/
      DATA IPR/6/
C
      NUMWRN = NUMWRN + 1
      IF (NUMWRN.LE.MAXWRN) GO TO 30
      IF (NUMWRN.GT.MAXXWN) GO TO 30
      MAXXWN = NUMWRN
      IF (MAXWRN.EQ.0) GO TO 20
      WRITE (IPR,10) MAXWRN
 10   FORMAT ('0** M0801 ** NOTE FROM SUBROUTINE WRNLIM:'/
     $ 13X,'NUMBER OF WARNING MESSAGES HAS EXCEEDED THE LIMIT OF',I6/
     $ 13X,'NO MORE WARNING MESSAGES WILL BE LISTED FOR THIS ',
     $     'PROCESSING GROUP')
 20   MAXFLG = 1
C
 30   RETURN
C
      ENTRY SETFLG (NEWLIM,NPR)
C
      MAXWRN = NEWLIM
      IPR = NPR
      RETURN
C
      ENTRY RESLIM
C
      NUMWRN = 0
      RETURN
C
      ENTRY GETWRN (NBRWRN)
C
      NBRWRN = NUMWRN
      RETURN
      END


      subroutine cmdln(ntap, otap, cardin, idry, ocell)

cmam  subroutine cmdln(ntap, otap, cardin, idry)



#include <f77/iounit.h>



c-----

c     get command arguments

c

c__________________________________________________________________

      character*(*)  ntap, otap, cardin, ocell

	integer idry, argis

	logical dry

      ierror=0

	idry = 1

	dry = .FALSE.



c		check for dry run flag

	dry = (argis( '-dry' ) .gt. 0)

c

	if(.not.dry) then

c		dry run not specified

          idry = 0

c		get ntap, otap

          call argstr('-N',ntap,' ',' ')

          call argstr('-O',otap,' ',' ')

c

          if(ntap .eq. ' ') then

             write(lerr,*) 'No input dataset specified.'

             write(lerr,*) 'Input assumed from stdin as pipe'

          endif

c

          if(otap .eq. ' ') then

             write(lerr,*) 'No output dataset specified.'

             write(lerr,*) 'Output will be written to stdout as pipe'

          endif

c

	endif

c

cmam...........add this for cell count output dataset.......

        call argstr('-G',ocell,' ',' ')

cmam........................................................

c		get cardin

      call argstr('-C',cardin,' ',' ')

      if(cardin .eq. ' ') then

         write(lerr,*) 'Command Line Error:'

         write(lerr,*) 'must enter input card image file after'

         write(lerr,*) 'keyword -C'

         ierror=ierror+1

      endif

c

	if(idry .eq. 1) return

      if(ierror .gt. 0) then

         write(lerr,*) 'program PR3D aborted'

         write(lerr,*)

         write(lerr,*) 'usage:'

cmam     write(lerr,*) '       pr3d -N[] -O[] -C[]     .....or....'

         write(lerr,*) '       pr3d -N[] -O[] -C[] -G[] ....or....'

         write(lerr,*) '       pr3d -dry -C[] -G[]'

	stop 666

       endif

c

      return

      end



      subroutine help1

#include <f77/iounit.h>



        print*,'inside subr. help1'

          write(LER,*)

     :'***************************************************************'

         write(LER,*)'PROGRAM pr3d.....3-D Descriptive Data Processing'

         write(LER,*)' '

         write(LER,*)

     :' -N [ntap]      (default=stdin)         : Input data file name'

         write(LER,*)

     :' -O [otap]      (default=stdout)        : Output data file name'

         write(LER,*)

     :' -C [cardin]    (no default, required)  : Card data file name'

cmam........added this for cell count output dataset......

         write(LER,*)

     :' -G [ocell]     (no default, optional)  : Output Fold/Cell',

     :' data file name'

cmam......................................................

         write(LER,*)

     :' -dry    (If present, no input/output dataset used.  This is'

         write(LER,*)

     :'          only for checking out the card deck in file cardin)'

         write(LER,*)

     :'   the file cardin must contain these card images:'

         write(LER,*)

     :'    1PR3D : required'

         write(LER,*)

     :'    2PR3D : required'

         write(LER,*)

     :'    3PR3D : optional'

         write(LER,*)

     :'    4PR3D : optional'

         write(LER,*)

     :'    1FLDH : optional'

         write(LER,*)

     :'    1GRUP : required'

         write(LER,*)

     :'    1SORC : required'

         write(LER,*)

     :'    1SPRD : required'

         write(LER,*)

     :'    OMIT : optional'

         write(LER,*)

     :'    NVRT : optional'

       write(LER,*)

     :'Usage:  ',

     :' pr3d -N[ntap] -O[otap] -C[cardin] -G[ocell] ..or..'

       write(LER,*)

     :' pr3d -dry -C[cardin] -G[ocell]'

       write(LER,*)

     :'***************************************************************'

        print*,'returning from help1'

      return

      end

cmam............072893.....the following two routines added

cmam............072893.....LHDRSZ no longer exists in lhdrsz.h

cmam............072893.....changed subr.FLDH to be like laip

C***********************************************************************
C----------------------------------------------------------------------C
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C
C----------------------------------------------------------------------C
C-- DEFLDH - DELETE FIELD HISTORY INFORMATION FROM SEISMIC LINE      --C
C--          HEADER.                                                 --C
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C
C----------------------------------------------------------------------C
      SUBROUTINE DEFLDH ( IHEAD , HDRLEN, HEADER )
      IMPLICIT   INTEGER*4 (A-Z)
#include <f77/lhdrsz.h>

#include <f77/sisdef.h>

#include <save_defs.h>

        integer IHEAD(*)

      character*1  HEADER(*), HEX5A

      INTEGER  TOTAL, COUNT

#ifndef CRAYSYSTEM

        integer*2 length

#else

        integer length

#endif

        DATA HEX5A / '!' /



        FLDHIS = HLHOFF + 1

        POINT = HSTOFF + 1

        INFO = POINT + HLHINT

C--
C--------------------------------------------------------------
C-- MOVE HISTORICAL HEADER ENTRY COUNTER AND LENGTH INTO WORKSPACE
C--
        call saver(IHEAD , 'HlhEnt', COUNT, 0)

        call saver(IHEAD , 'HlhByt', TOTAL, 0)

C--
C--------------------------------------------------------------
C-- CHECK BOUNDARY CONDITION (NO HISTORICAL INFO...)
C--
   10 IF (COUNT.LE.0) GOTO 20
C--
C--------------------------------------------------------------
C-- OBTAIN LENGTH OF THIS ENTRY AND ADDRESS OF NEXT ENTRY
C--
         CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)
#ifndef CRAYSYSTEM

         NEXT = INFO + LENGTH
#else

        LENGTH = (INT((LENGTH + 7) / 8) * 8)

        NEXT = INFO + LENGTH

#endif

C--
C--------------------------------------------------------------
C-- IF THIS ENTRY IS FLAGGED AS HISTORICAL, THEN DELETE THE ENTRY
C--    ALSO UPDATE OVERALL LENGTH OF LINE HEADER
C--
         IF (HEADER(INFO).NE.HEX5A) GOTO 20
            LENGTH = LENGTH + HLHINT
            TOTAL = TOTAL - LENGTH
            COUNT = COUNT - 1
            HDRLEN = HDRLEN - LENGTH
            LEN4 = TOTAL
            CALL MOVE ( 4, HEADER(POINT), HEADER(NEXT), LEN4 )
            GOTO 10
C--
C--------------------------------------------------------------
C-- UPDATE HEADER...
C--
   20 call savew(IHEAD , 'HlhEnt', COUNT, 0)

      call savew(IHEAD , 'HlhByt', TOTAL, 0)



      RETURN
      END
C----------------------------------------------------------------------C
C-- AMOCO PRODUCTION, PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE   --C
C----------------------------------------------------------------------C
C-- INFLDH - INSERT FIELD HISTORY INFORMATION INTO SEISMIC LINE      --C
C--          HEADER.                                                 --C
C----------------------------------------------------------------------C
C-- RUSSELL L. WILSON - 960 SOUTH (TDC)                     09/10/82 --C
C----------------------------------------------------------------------C
C-- CATALOGUED AND TESTED - 10/25/82 9:00 AM                         --C
C----------------------------------------------------------------------C
C-- ABSTRACT - INSERT ONE (1) LINE OF FIELD HISTORY INFORMATION INTO --C
C--            A SEISMIC LINE HEADER.  ENTRY IS PLACED AT END OF     --C
C--            "FIELD" INFORMATION IMMEDIATELY BEFORE "PROCESSING"   --C
C--            INFORMATION.  LENGTH OF OVERALL HEADER IS ALSO RESET. --C
C----------------------------------------------------------------------C
      SUBROUTINE INFLDH ( IHEAD , HDRLEN, FLD, FLDLEN, HEADER )
      IMPLICIT   INTEGER*4 (A-Z)
#include <f77/lhdrsz.h>

#include <f77/sisdef.h>

#include <save_defs.h>

        integer IHEAD(*)

      character*1  HEADER(*), HEX5A, FLD(*)

        integer kount,ktot

#ifndef CRAYSYSTEM

      INTEGER*2 WORKSP(2),LENGTH,TOTAL,COUNT

#else

      INTEGER WORKSP(2),LENGTH,TOTAL,COUNT

#endif

      EQUIVALENCE (WORKSP(1),COUNT),
     $            (WORKSP(2),TOTAL)
        DATA HEX5A / '!' /

        FLDHIS = HLHOFF + 1

        START = HSTOFF + 1

        iNFO = START + HLHINT

C--
C--------------------------------------------------------------
C-- MOVE ITEM COUNT AND LENGTH INTO WORKSPACE
C--
        call saver(IHEAD , 'HlhEnt', KOUNT, 0)

        call saver(IHEAD , 'HlhByt', KTOT, 0)

        count = kount

        total = ktot



C--
C--------------------------------------------------------------
C-- INITIALIZE POINTERS...
C--
      POINT = START
      ENTRY = INFO
C--
C--------------------------------------------------------------
C-- IF THE HISTORY IS EMPTY, THEN DON'T BOTHER WITH A SEARCH
C--
      IF (COUNT.LE.0) GOTO 20
C--
C--------------------------------------------------------------
C--     GET NEXT ITEM LENGTH...
C--
   10    CALL MOVE ( 1, LENGTH, HEADER(POINT), HLHINT)
#ifdef CRAYSYSTEM

        LENGTH = (INT((LENGTH + 7) / 8) * 8)

#endif

C--
C--------------------------------------------------------------
C-- IF THIS ENTRY IS A FIELD HISTORY ENTRY, THEN WE SKIP BY IT.
C--    AND POINT TO THE NEXT ITEM
C--
         IF (HEADER(ENTRY).NE.HEX5A) GOTO 20
            POINT = ENTRY + LENGTH
            ENTRY = POINT + HLHINT
            GOTO 10
C--
C--------------------------------------------------------------
C-- COMPUTE LENGTH OF REMAINING HEADER INFO AND TARGET ADDRESS
C--     THEN MOVE THE HEADER ON DOWN INTO POSTION TO MAKE ROOM
C--     FOR THE NEW HISTORY ENTRY.
C-- (PROVIDED THERE ACTUALLY IS SOMETHING TO BE MOVED)
C--
   20 continue

        leng1 = FLDLEN + 1

#ifdef CRAYSYSTEM

        leng1 = (INT((leng1 + 7) / 8) * 8)

#endif

      MOVLEN = START + TOTAL - POINT
      NEWLOC = POINT + leng1 + HLHINT
      IF (MOVLEN.GT.0) then
        call move(4,HEADER(NEWLOC),HEADER(POINT),MOVLEN)

        endif

C--
C--------------------------------------------------------------
C-- FLAG THIS ENTRY AS HISTORY
C--
      HEADER(ENTRY) = HEX5A
C--
C--------------------------------------------------------------
C-- MOVE THE ENTRY INTO POSITION (WE DON'T CARE HOW LONG IT IS)
C--
      ENTRY = ENTRY + 1
      CALL MOVE ( 1, HEADER(ENTRY), FLD, FLDLEN )
C--
C--------------------------------------------------------------
C-- SET THE LENGTH OF THE ENTRY...
C--
       LENGTH = FLDLEN + 1
      CALL MOVE ( 1, HEADER(POINT), LENGTH, HLHINT)
C--
C--------------------------------------------------------------
C-- UPDATE ENTRY COUNT AND TOTAL BYTE LENGTH OF HISTORY HEADER
C--    THEN GO HOME
C--
      COUNT = COUNT + 1
      TOTAL = TOTAL + leng1  + HLHINT
      HDRLEN = HDRLEN + leng1  + HLHINT
        kount = count

        ktot = total

        call savew(IHEAD , 'HlhEnt', KOUNT, 0)

        call savew(IHEAD , 'HlhByt', KTOT, 0)



      RETURN
      END
