CPROG XFORM
C***********************************************************************
C     SUBROUTINE NAME: XFORM  (TRANSFORM COORDINATE SYSTEMS)
C     ENTRY POINTS:    XFMI   (INITIALIZATION)
C                      XFMFWD (COMPUTE NEW COORDINATES - FORWARD)
C                      BINCTR (COMPUTE BIN CENTER COORDINATES)
C                      ILIDI  (COMPUTE LINE AND DEPTH INDECES ONLY)
C                      XFMINV (COMPUTE NEW COORDINATES - INVERSE)
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: ?????
C
C     DATE WRITTEN: ??/??/??
C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C
C     ABSTRACT: COMPUTE THE CONSTANTS NEEDED TO PERFORM THE FOLLOWING
C               TRANSFORMATION OF A PARALLELOGRAM TO A RECTANGLE:
C                 1- MAP CORNER 1 ONTO ORIGIN
C                 2- MAP CORNER 2 ONTO POSITIVE Y-AXIS
C                 3- MAP CORNER 3 ONTO QUADRANT 1
C                 4- MAP CORNER 4 ONTO POSITIVE X-AXIS
C               AND, GIVEN A PARTICULAR (X,Y), NEW COORDINATES (IN
C               LINE INDEX, DEPTH INDEX FORM) ARE RETURNED.
C
C     CALLING SEQUENCE: CALL XFMI  (IX1,  IY1, IX2, IY2, IX3, IY3,
C                                   IX4,  IY4, DY , DX , NX , NY ,
C                                   ISIGN,IPR, ICC)
C                WHERE: IX1 - X-COORDINATE OF CORNER 1
C                       IY1 - Y-COORDINATE OF CORNER 1
C                       IX2 - X-COORDINATE OF CORNER 2
C                       IY2 - Y-COORDINATE OF CORNER 2
C                       IX3 - X-COORDINATE OF CORNER 3
C                       IY3 - Y-COORDINATE OF CORNER 3
C                       IX4 - X-COORDINATE OF CORNER 4
C                       IY4 - Y-COORDINATE OF CORNER 4
C                       DY  - CELL DIMENSION  ALONG SIDE 1-2
C                       DX  - CELL DIMENSION  ALONG SIDE 2-3
C                       NX  - NUMBER OF CELLS ALONG SIDE 2-3
C                       NY  - NUMBER OF CELLS ALONG SIDE 1-2
C                       ISIGN-
C                       IPR - LOGICAL UNIT OF PRINTER
C                       ICC - ERROR STATUS
C                             IF NO ERRORS, VALUE REMAINS UNCHANGED.
C
C     CALLING SEQUENCE: CALL XFMFWD (XC  , YC  , ILI, IDI, XT , YT)
C                                    XTBC, YTBC, IWARN)
C            WHERE: XC    R*4 - X-COORDINATE OF POINT IN QUESTION
C                   YC    R*4 - Y-COORDINATE OF POINT IN QUESTION
C                   ILI   I*4 - LINE INDEX OF (XC,YC)
C                   IDI   I*4 - DEPTH INDEX OF (XC,YC)
C                   XT    R*4 - TRANSFORMED X-COORDINATE
C                   YT    R*4 - TRANSFORMED Y-COORDINATE
C                   XTBC  R*4 - TRANSFORMED X-COORDINATE BIN CENTER
C                   YTBC  R*4 - TRANSFORMED Y-COORDINATE BIN CENTER
C                   IWARN I*4 - WARNING FLAG
C                               0 = ALL OK
C                               1 = POINT NOT WITHIN GRID BOUNDARIES
C
C    CALLING SEQUENCE: CALL BINCTR (MIDX,MIDY,DX,DY,ILI,IDI,
C                                   IBINX,IBINY,IWARN)
C            WHERE: MIDX  I*4 - X-COORDINATE OF POINT IN QUESTION
C                   MIDY  I*4 - Y-COORDINATE OF POINT IN QUESTION
C                   DY    R*4 - CELL INCREMENT ALONG SIDE 1-2
C                   DX    R*4 - CELL INCREMENT ALONG SIDE 2-3
C                   ILI   I*4 - LINE  INDEX OF (XC,YC)
C                   IDI   I*4 - DEPTH INDEX OF (XC,YC)
C                   IBINX I*4 - BIN CENTER OF (XC,YC)
C                   IBINY I*4 - BIN CENTER OF (XC,YC)
C                   IWARN I*4 - WARNING FLAG
C                               0 = ALL OK
C                               1 = POINT NOT WITHIN GRID BOUNDARIES
C
C     CALLING SEQUENCE: CALL XFMINV(XC  , YC  , XT  , YT  ,
C                                   XBC , YBC , XTBC, YTBC, JERR)
C                WHERE: XC   - INVERSED X-COORDINATE
C                       YC   - INVERSED Y-COORDINATE
C                       XT   - X-COORDINATE IN QUESTION
C                       YT   - Y-COORDINATE IN QUESTION
C                       XBC  - INVERSED X-COORDINATE BIN CENTER
C                       YBC  - INVERSED Y-COORDINATE BIN CENTER
C                       XTBC - X-COORDINATE BIN CENTER IN QUESTION
C                       YTBC - Y-COORDINATE BIN CENTER IN QUESTION
C                       JERR - ERROR FLAG
C                                 0 = NO ERRORS
C                                 1 = ERRORS ENCOUNTERED - MATRIX IS
C                                     SINGULAR
C
C***********************************************************************
C
      SUBROUTINE XFORM
C
C-----------------------------------------------------------------------
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS
C-----------------------------------------------------------------------
C
      DOUBLE PRECISION   P41L

      DOUBLE PRECISION   COS0  , SIN0  , SCOS0 , SSIN0

      DOUBLE PRECISION   TANPHI, DYCPHI, CPHI

      DOUBLE PRECISION   X , Y , XX, XY, YX, YY

      DOUBLE PRECISION       XXT   , XYT   , YXT , YYT

      DOUBLE PRECISION   DE,DF

      DOUBLE PRECISION   E,F,XYYXXY

	DOUBLE PRECISION aval, bval

	character*100 fn

	save

c.c	save ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,nx,ny

c.c	save xx,xy,yx,yy

c.c	save xxt,xyt,yxt,yyt

C
ccc   ENTRY XFMI  (IX1   , IY1   , IX2   , IY2   , IX3   , IY3   ,
ccc  $             IX4   , IY4   , DY    , DX    , NX    , NY    ,
      ENTRY XFMI  (JX1   , JY1   , JX2   , JY2   , JX3   , JY3   ,
     $             JX4   , JY4   , DY    , DX    ,JNX    ,JNY    ,
     $             ISIGN , IPR   , ICC   )
C
C-----------------------------------------------------------------------
C     ENSURE THE COORDINATES DEFINE A PARALLELOGRAM
C-----------------------------------------------------------------------
C
	ix1 = jx1

	iy1 = jy1

	ix2 = jx2

	iy2 = jy2

	ix3 = jx3

	iy3 = jy3

	ix4 = jx4

	iy4 = jy4

	nx = jnx

	ny = jny

      COS0              = IX4  - IX1
      SIN0              = IY4  - IY1
      P41L              = COS0 * COS0  +  SIN0 * SIN0
      XX                = IX2  - IX1
      YY                = IY2  - IY1
cmam  IX                = P41L + 0.5
cmam  IY                = XX   * XX    +  YY   * YY    +  0.5
C
cmam  IF (IX .EQ. (IX3-IX2) * (IX3-IX2) +  (IY3-IY2) * (IY3-IY2)  .AND.
cmam $    IY .EQ. (IX4-IX3) * (IX4-IX3) +  (IY4-IY3) * (IY4-IY3)    )
cmam $    GO TO 10
	if((ix4-ix1)*(ix4-ix1)+(iy4-iy1)*(iy4-iy1) .eq.

     *     (ix3-ix2)*(ix3-ix2)+(iy3-iy2)*(iy3-iy2) .and.

     *     (ix2-ix1)*(ix2-ix1)+(iy2-iy1)*(iy2-iy1) .eq.

     *     (ix4-ix3)*(ix4-ix3)+(iy4-iy3)*(iy4-iy3)) go to 10

C
      WRITE (IPR,5)
 5    FORMAT ('0** M0401 ** ERROR DETECTED BY SUBROUTINE XFORM (ENTRY XF
     $MI):'/
     $ 13X,'THE COORDINATES SPECIFIED FOR THE FOUR CORNERS'/
     $ 13X,'OF THE SORTING GRID DOES NOT DEFINE A PARALLELOGRAM')
      ICC = 100
      GO TO 20
C
C-----------------------------------------------------------------------
C     COMPUTE THE CONSTANTS TO PERFORM THE TRANSFORMATION
C-----------------------------------------------------------------------
C
 10   P41L              = DSQRT(P41L)
      COS0              = COS0 / P41L
      SIN0              = SIN0 / P41L
C
      ISIGN             = 1
      IF (XX*SIN0 .GT. YY*COS0) ISIGN = -1
C
      SCOS0             = ISIGN * COS0
      SSIN0             = ISIGN * SIN0
C
      X                 = YY * SIN0   +  XX * COS0
      Y                 = YY * SCOS0  -  XX * SSIN0
C
      TANPHI            = X / Y
      CPHI              =       DABS(Y)  / DSQRT(X*X  + Y*Y)
      DYCPHI            = DY  * CPHI
C
      XXT               = (COS0 + SSIN0 * TANPHI)
      XYT               = (SIN0 - SCOS0 * TANPHI)
      YXT               = -SSIN0        / CPHI
      YYT               =  SCOS0        / CPHI
C
	aval = IX1

	bval = IY1

	DE = aval * XXT + bval * XYT

	DF = aval * YXT + bval * YYT

ccc   DE                = DFLOAT(IX1) * XXT + DFLOAT(IY1) * XYT
ccc   DF                = DFLOAT(IX1) * YXT + DFLOAT(IY1) * YYT
C
      XX                = XXT   / DX
      XY                = XYT   / DX
      YX                =-SSIN0 / DYCPHI
      YY                = SCOS0 / DYCPHI
C
C-----------------------------------------------------------------------
C     COMPUTE THE NUMBER OF IN-LINE CELLS & CROSS-LINE CELLS
C-----------------------------------------------------------------------
C
      X                 = (IX4 - IX1) * XX  +  (IY4 - IY1) * XY  + 1.
      JNX                =  X

      IF (X-JNX .LT. 0.5)   JNX = JNX  - 1

      Y                 = (IX2 - IX1) * YX  +  (IY2 - IY1) * YY  + 1.
      JNY                =  Y

      IF (Y-NY .LT. 0.5)   JNY = JNY  - 1

	nx = jnx

	ny = jny

C
 20   RETURN
C
C***********************************************************************
C
      ENTRY XFMFWD (XC  , YC  , ILI,   IDI, XT, YT,
     $              XTBC, YTBC, IWARN )
C
      IWARN             = 0
C
      IXC               = XC + SIGN(0.5,XC)
      IYC               = YC + SIGN(0.5,YC)
C
      IDI               = (IXC-IX1) * XX  +  (IYC-IY1) * XY  + 0.999999
      ILI               = (IXC-IX1) * YX  +  (IYC-IY1) * YY  + 0.999999
C
      XT                = (IXC-IX1) * XXT +  (IYC-IY1) * XYT
      YT                = (IXC-IX1) * YXT +  (IYC-IY1) * YYT
C
      XTBC              = XT
      YTBC              = YT
C
C-----------------------------------------------------------------------
C     SEE IF POINT IS WITHIN GRID BOUNDARIES
C-----------------------------------------------------------------------
C
      IF (ILI .LT. 1 .OR. ILI .GT. NY) IWARN = 1
      IF (IDI .LT. 1 .OR. IDI .GT. NX) IWARN = 1
C
      RETURN
C
C***********************************************************************
C
      ENTRY BINCTR (MIDX,MIDY,DX,DY,ILI,IDI,IBINX,IBINY,IWARN)
C
      IWARN = 0
C
	aval = MIDX - IX1

	bval = MIDY - IY1

	IDI = aval * XX + bval * XY + 0.999999

	ILI = aval * YX + bval * YY + 0.999999

ccc   IDI = DFLOAT(MIDX - IX1) * XX + DFLOAT(MIDY - IY1) * XY + 0.999999
ccc   ILI = DFLOAT(MIDX - IX1) * YX + DFLOAT(MIDY - IY1) * YY + 0.999999
C
      IF (IDI .LT. 1 .OR. IDI .GT. NX) IWARN = 1
      IF (ILI .LT. 1 .OR. ILI .GT. NY) IWARN = 1
C
      E      = (DBLE(FLOAT(IDI)) - 0.5) * DX + DE
      F      = (DBLE(FLOAT(ILI)) - 0.5) * DY + DF
      XYYXXY = XYT * YXT - XXT * YYT
      IF (XYYXXY.NE.0) GO TO 40
      WRITE (IPR,30)
 30   FORMAT ('0** M0402 ** ERROR DETECTED BY SUBROUTINE XFORM (ENTRY BI
     $NCTR):'/
     $ 13X,'ATTEMPTED TO SOLVE A PAIR OF EQUATIONS WHICH HAVE NO ',
     $     'UNIQUE SOLUTION')
      ICC = 100
      GO TO 60
C
 40   IBINX = (F * XYT - E * YYT) / XYYXXY
      IF (XYT.NE.0.0) GO TO 50
C
      IBINY = (F - IBINX * YXT) / YYT
      GO TO 60
C
 50   IBINY = (E - IBINX * XXT) / XYT
C
 60   RETURN
C
C***********************************************************************
C
      ENTRY ILIDI (MIDX,MIDY,ILI,IDI,IWARN)
C
      IWARN = 0
	aval = MIDX - IX1

	bval = MIDY - IY1

	IDI = aval * XX + bval * XY + 0.999999

	ILI = aval * YX + bval * YY + 0.999999

ccc   IDI = DFLOAT(MIDX - IX1) * XX + DFLOAT(MIDY - IY1) * XY + 0.999999
ccc   ILI = DFLOAT(MIDX - IX1) * YX + DFLOAT(MIDY - IY1) * YY + 0.999999
      IF (IDI .LT. 1 .OR. IDI .GT. NX) IWARN = 1
      IF (ILI .LT. 1 .OR. ILI .GT. NY) IWARN = 1
      RETURN
C
C
C=======================================================================
C
C
      ENTRY XFMINV(XC    , YC    , XT    , YT    ,
     *             XBC   , YBC   , XTBC  , YTBC  , JERR)
C
C
C=======================================================================
C
      JERR              = 0
C
      A                 = XTBC
      B                 = IX1
      C                 = IY1
      D                 = YTBC
C     E                 = XTBC + (IX1 * XXT) + (IY1 * XYT)
C     F                 = YTBC + (IX1 * YXT) + (IY1 * YYT)
      E                 = A    + (B   * XXT) + (C   * XYT)
      F                 = D    + (B   * YXT) + (C   * YYT)
C
      CALL SIMLEQ(XXT   , XYT   , E     ,
     *            YXT   , YYT   , F     , XBC   , YBC   , JERR)
C
      A                 = XT
      D                 = YT
C     E                 = XT   + (IX1 * XXT) + (IY1 * XYT)
C     F                 = YT   + (IX1 * YXT) + (IY1 * XYT)
      E                 = A    + (B   * XXT) + (C   * XYT)
      F                 = D    + (B   * YXT) + (C   * YYT)
C
      CALL SIMLEQ(XXT   , XYT   , E     ,
     *            YXT   , YYT   , F     , XC    , YC    , JERR)
C
C-----------------------------------------------------------------------
C
C     THAT'S ALL -- RETURN TO CALLING ROUTINE
C
C-----------------------------------------------------------------------
C
      RETURN
      END
C***********************************************************************
C
C     SUBROUTINE NAME: SIMLEQ  (SIMULTANEOUS EQUATIONS)
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: ?.?????
C
C     DATE WRITTEN: ??/??/??
C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C
C |               copyright 2001, Amoco Production Company             |
C |                           All Rights Reserved                      |
C |                   an affiliate of BP America Inc.                  |
C
C     ABSTRACT: GIVEN TWO LINEAR EQUATIONS IN TWO UNKNOWNS, SOLVE
C               FOR THE TWO UNKNOWNS SIMULTANEOUSLY.
C
C                               AX + BY = E
C                               CX + DY = F
C
C     CALLING SEQUENCE: CALL SIMLEQ(A , B , E , C , D , F , X , Y)
C
C                WHERE: A - COEFFICIENT OF FIRST  UNKNOWN IN FIRST  EQ.
C                       B - COEFFICIENT OF SECOND UNKNOWN IN FIRST  EQ.
C                       E - CONSTANT TERM OF FIRST  EQ.
C                       C - COEFFICIENT OF FIRST  UNKNOWN IN SECOND EQ.
C                       D - COEFFICIENT OF SECOND UNKNOWN IN SECOND EQ.
C                       F - CONSTANT TERM OF SECOND EQ.
C                       X - FIRST  UNKNOWN
C                       Y - SECOND UNKNOWN
C                    IERR - ERROR FLAG
C                              0 = NO ERRORS
C                              1 = ERROR DETECTED - MATRIX IS SINGULAR
C
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE
C
C***********************************************************************
C
C
      SUBROUTINE SIMLEQ(A, B, E, C, D, F, X, Y, IERR)
C
C
C-----------------------------------------------------------------------
C
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS
C
C-----------------------------------------------------------------------
C
      DOUBLE PRECISION   A , B , C , D , E , F

      DOUBLE PRECISION   XX    , YY

C
      REAL*4    X     , Y
C
      IERR              = 0
C
C-----------------------------------------------------------------------
C
C     SEE IF MATRIX IS SINGULAR
C
C-----------------------------------------------------------------------
C
      IF((A*D) .NE. (B*C)) GO TO 100
      IERR              = 1
      GO TO 200
C
C-----------------------------------------------------------------------
C
C     COMPUTE X & Y
C
C-----------------------------------------------------------------------
C
  100 XX                = ((B*F) -  (D*E)) / ((B*C) - (A*D))
C
      IF(B .EQ. 0.0D0)      GO TO 150
      YY                =  (E    - (A*XX)) /   B
      GO TO 160
C
  150 YY                =  (F    - (C*XX)) /   D
C
  160 X                 = XX
      Y                 = YY
C
C-----------------------------------------------------------------------
C
C     THAT'S ALL -- RETURN TO CALLING ROUTINE
C
C-----------------------------------------------------------------------
C
  200 RETURN
      END
