C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wtapp (xtr, weight, ytr, nmax, nk,
     1                  work, tp, cost, bart)
#include <f77/iounit.h>

c  Apply preconstructed weights to a data vector
c  input:
c     xtr  - data in
c     nmax - maximum possible length for xtr
c     nk   - current length of xtr (usually nk = nmax)
c     tp   - fraction to taper each end
c     cost - cosine taper
c     bart - bartlett taper
c output:
c     ytr  - tapered data

      real    xtr(nmax), ytr(nmax), weight(nmax), work(*)
      real    tp
      integer nmax, nk, nw, nw2
      logical cost, bart

c  if we're tapering with 1's then just copy the data and return

      if (.not. cost .AND. .not. bart) then
         do  i = 1, nk
             ytr (i) = xtr (i)
         enddo
         return
      endif

c  if the length of the data window has changed we must re-compute weights
c  and then apply, oherwise...

      IF (nk .ne. nmax) THEN

         nw  = nk
         tpk = .5 * tp / 100
         nw2 = tpk * nw
         if (nw2 .lt. 3) then
            write(LERR,*)'WARNING from wtapp:'
            write(LERR,*)'Length of taper= ',nw2,' < 3'
            write(LERR,*)'No taper applied'
            cost = .false.
            bart = .false.
         endif

         call vfill (1.0, work, 1, nk)
   
         if    (cost)  then
             do  i = 1, nw2
                 ang = 3.14159265 * float(nw2-i)/float(nw2)
                 work(i) = .5 * (1. + cos ( ang ))
                 work(nk-i+1) = work(i)
             enddo
         elseif (bart) then
             do  i = 1, nw2
                 work(i) = float(i)/ float(nw2)
                 work(nk-i+1) = work(i)
             enddo
         endif

         do  i = 1, nk
   
             ytr (i) = work (i) * xtr (i)
         enddo


c  ... if the length of the input data remains the same we just apply the
c  pre-computed wieghts

      ELSE

         do  i = 1, nmax
   
             ytr (i) = weight (i) * xtr (i)
         enddo

      ENDIF

      return
      end
