C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
**********************************************************************c
c
c     program module presort3d
c
c     CHANGES: 

c     Sept 19/95 - added control to watch for i*2 trace header entry
c                  overflow and warn the user of first occurance of 
c                  each.  This is not a FATAL condition at present.
c                  [Garossino]
c
c**********************************************************************c
c
c     presort reads seismic traces from the standard input,
c     or from the command line and compiles a list
c     of RecInd, SoPtNm, DphInd, and DstSgn indices for use by the
c     program sisort3d.  Alternately the user can specify the trace header
c     mnemonics to use for the various primary, secondary sort variables
c
c**********************************************************************c
c
c     declare variables
c-----

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc(100), nrec(100), iform 
      integer     luin(100), luout, lbytes, nbytes

      character name * 9,   ntap(100) * 256, otap * 256

      logical   verbos

c  dynamic memory

      integer   inrec, insrc, incdp, indst
      integer   jnrec, jntrc, jndst, srttmp
      integer   kyrec, kysrc, kycdp, kydst, kygi
      integer   iunit

      pointer   (wkunit, iunit(1))
      pointer   (ainrec, inrec(1))
      pointer   (ainsrc, insrc(1))
      pointer   (aincdp, incdp(1))
      pointer   (aindst, indst(1))
      pointer   (ajnrec, jnrec(1))
      pointer   (ajntrc, jntrc(1))
      pointer   (ajndst, jndst(1))
      pointer   (asrtmp, srttmp(1))
      pointer   (akyrec, kyrec(1))
      pointer   (akysrc, kysrc(1))
      pointer   (akycdp, kycdp(1))
      pointer   (akydst, kydst(1))
      pointer   (akygi , kygi (1))

c static memory

      integer   ic, NumberOfNtaps

      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, SrPtXC
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, SrPtYC
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC, RcPtXC
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, RcPtYC
      integer ifmt_SrRcMX, l_SrRcMX, ln_SrRcMX, SrRcMX
      integer ifmt_SrRcMY, l_SrRcMY, ln_SrRcMY, SrRcMY
      integer ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, CDPBCX
      integer ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, CDPBCY

      integer ifmt_TrWrd1, l_TrWrd1, ln_TrWrd1, RecInd
      integer ifmt_TrWrd2, l_TrWrd2, ln_TrWrd2, SoPtNm
      integer ifmt_TrWrd3, l_TrWrd3, ln_TrWrd3, DphInd
      integer ifmt_TrWrd4, l_TrWrd4, ln_TrWrd4, DstSgn

      integer   argis, pipes(100), pmax, pipcnt

      real      off, grp
      real      spread ( SZSMPM )
      real srptxmax, srptxmin, srptymax, srptymin
      real rcptxmax, rcptxmin, rcptymax, rcptymin
      real srrcxmax, srrcxmin, srrcymax, srrcymin
      real cdpbxmax, cdpbxmin, cdpbymax, cdpbymin
      real dismax, dismin

      character TrWrd1 * 6, TrWrd2 * 6, TrWrd3 * 6, TrWrd4 * 6

      logical   round, model, renum, ten, keep, heap, heapin
      logical   warn1, warn2, warn3, warn4, warn5, warn6, warn7
      logical   first_live_trace

c set up useful hooks

      equivalence ( itr(1), lhed(1) )

c initialize variables

      data name /'PRESORT3D'/
      data lbytes / 0 /
      data nbytes / 0 /
      data keep/.false./
      data warn1/.false./
      data warn2/.false./
      data warn3/.false./
      data warn4/.false./
      data warn5/.false./
      data warn6/.false./
      data warn7/.false./
      data first_live_trace/.true./

c read program parameters from command line card image file

      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
            call help()
            stop
      endif

c open printout file

#include <f77/open.h>

c parse command line

      call gcmdln ( ntap, otap, verbos, renum, ten, keep, round, model, 
     :     off, grp, NumberOfNtaps, pmax, TrWrd1, TrWrd2, TrWrd3,TrWrd4)

c check if runnint in XIKP

      ikp = in_ikp()

      pipes(1) = 0
      luin(1)  = 0

      if (pmax .ge. 2) then
         do  i = 2, pmax
            pipes(i) = i + 1
         enddo
      endif

c get logical unit numbers for input and output

      IF (NumberOfNtaps .ne. 0) THEN
         do   i = 1, NumberOfNtaps
            call getln(luin(i),ntap(i),'r',0)
            if(luin(i) .eq. 0) then
               write(LERR,*)'Data set cannot be a pipe'
               write(LERR,*)'check command line args & rerun'
               stop
            endif
         enddo
      ELSE
         if (ikp .eq. 1) then
            
            NumberOfNtaps = pipcnt (pipes,pmax)
            write(LER,*)'presort3d: pmax= ',pmax,' # pipes= ',NumberOfNtaps

c if pmax was unlimited, program printout also got counted

            if (pmax .eq. 100) NumberOfNtaps = NumberOfNtaps - 1
            write(LER,*)'Number of pipes found= ',NumberOfNtaps
            write(LER,*)'socket numbers:'
            write(LER,*)(pipes(i),i=1,NumberOfNtaps)
            if (NumberOfNtaps .gt. 100) then
               write(LERR,*)'Cannot have more then 100 inputs'
               write(LERR,*)'You have  ',NumberOfNtaps,'  inputs'
               stop
            endif

            do 2 i = 1, NumberOfNtaps
               if ( pipes(i) .eq. 0) then
                  luin(i) = 0
               else
                  call sisfdfit (luin(i), pipes(i))
               endif
               write(LERR,*)'presort3d: got fortran unit number= ',
     :              luin(i),', socket = ',pipes(i)
 2          continue

         else

            NumberOfNtaps = 1
            luin (1) = 0

         endif
      ENDIF

      call getln(luout, otap,'w', 1)

c read line header of input save certain parameters

      nrect = 0

      do  i = 1, NumberOfNtaps
         call rtape  ( luin(i), itr, lbytes                  )
         if(lbytes .eq. 0) then
            write(LOT,*)'presort: no header read from unit ',luin(i)
            write(LOT,*)'FATAL'
            stop
         endif
         call saver(itr, 'NumTrc', ntrc(i) , LINHED)
         call saver(itr, 'NumRec', nrec(i) , LINHED)
         nrect = nrect + nrec(i)
      enddo

c print historical line header to printout file

      call hlhprt ( itr, lbytes, name, 9, LERR )

c save global line header parameters
 
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c build pointers to trace header entries used for sorting

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      call savelu(TrWrd1,ifmt_TrWrd1,l_TrWrd1,ln_TrWrd1,TRACEHEADER)
      call savelu(TrWrd2,ifmt_TrWrd2,l_TrWrd2,ln_TrWrd2,TRACEHEADER)
      call savelu(TrWrd3,ifmt_TrWrd3,l_TrWrd3,ln_TrWrd3,TRACEHEADER)
      call savelu(TrWrd4,ifmt_TrWrd4,l_TrWrd4,ln_TrWrd4,TRACEHEADER)
      
      if(luout.eq.1)then
         luns = LOT
      else
         call lbclos(luout)
         luns = 26
         open(luns,file=otap,status='unknown',form='formatted',
     1        access='sequential')
         rewind luns
      endif

c output of all pertinent information before processing begins

      call verbal( nsamp, nsi, ntrc(1), nrect, iform, NumberOfNtaps,
     :     ntap, otap, renum, ten, nrec, TrWrd1, TrWrd2, TrWrd3, TrWrd4,
     :     TrWrd5, TrWrd6, TrWrd7 )

c do dynamic memory allocation

      heap   = .true.
      heapin = .true.
      items = ntrc(1)*nrect

      call galloc (wkunit, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("iunit index vector  ", heapin, heap)

      call galloc (ainrec, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("inrec index vector  ", heapin, heap)

      call galloc (ainsrc, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("insrc index vector  ", heapin, heap)

      call galloc (aincdp, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("incdp index vector  ", heapin, heap)

      call galloc (aindst, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("indst index vector  ", heapin, heap)

      call galloc (ajnrec, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("jnrec index vector  ", heapin, heap)

      call galloc (ajntrc, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("jntrc index vector  ", heapin, heap)

      call galloc (ajndst, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("jndst index vector  ", heapin, heap)

      call galloc (asrtmp, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("srtmp index vector  ", heapin, heap)

      call galloc (akyrec, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kyrec index vector  ", heapin, heap)

      call galloc (akysrc, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kysrc index vector  ", heapin, heap)

      call galloc (akycdp, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kycdp index vector  ", heapin, heap)

      call galloc (akydst, items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kydst index vector  ", heapin, heap)

      call galloc (akygi , items * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kygi  index vector  ", heapin, heap)

      if (.not.heap) then
         write(LERR,*)' '
         write(LERR,*)'Memory allocation failure -- FATAL'
         write(LERR,*)'Data set contains ',items,' traces'
         write(LERR,*)'Is this maybe too large for this'
         write(LERR,*)'machine?'
         write(LER,*)' '
         write(LER,*)'presort_big: Memory allocation failure'
         write(LER,*)'Data set contains ',items,' traces'
         write(LER,*)'Is this maybe too large for this'
         write(LER,*)'machine?????  Try a machine with more'          
         write(LER,*)'memory'
         write(LER,*)'FATAL'
         go to 999
      endif

c model trace distances if asked

      off = off + grp

      IF (model) then
         x = 0.
         do  20  j = 1, SZSMPM

            x = x + grp
            if (x .gt. off) then
               ngrp2 = j-1
               go to 21
            else
               spread(j) = x
            endif
 20      continue
 21      continue

         x = 0.
         do  24  j = 1, ngrp2
            x = x - grp
            spread(ngrp2 + j) = x
 24      continue

         ngrp = 2 * ngrp2
         call rsort (spread, srttmp, ngrp)
         call vrvrs (spread, 1, ngrp)

         write(LERR,*)' '
         write(LERR,*)'Modeled Trace DIstances'
         write(LERR,*)(spread(i),i=1,ngrp)
         write(LERR,*)' '
      ENDIF

c BEGIN PROCESSING - process entire input data set

      ic = 0
      it = 0

      DO  IU = 1, NumberOfNtaps

         DO  JJ = 1, nrec(iu)

            do  kk = 1, ntrc(iu)

               nbytes = 0
               call rtape(luin(iu), itr, nbytes)

               if(nbytes .eq. 0) then
                  write(LERR,*)' '
                  write(LERR,*)'End of file on input ',iu,' :'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  write(LERR,*)'Last rec# on data set=  ',RecNum
                  write(LERR,*)'Last trc# on data set=  ',TrcNum
                  if (iu .eq. NumberOfNtaps) then
                     go to 1002
                  else
                     go to 1001
                  endif
               endif
               
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              StaCor , TRACEHEADER)
               
               IF ( StaCor .ne. 30000 .or. keep ) THEN

c if keep is true then want to keep dead traces in the sort table.  In this
c case they had better be prepped correctly.  While we read these in check for
c any 2byte entries that get > 32767 and warn the user of the first occurance of
c same.  This is usually bad for the sort table but not always as the user may
c not be using that field for anything.  When the overflow occurs the result is
c usually a negative number.  Since negative indexing is seldom seen in USP I will
c check for that and report that something bad MAY be occuring.
                  
                  call saver2(lhed,ifmt_TrWrd1,l_TrWrd1, ln_TrWrd1,
     1                 RecInd , TRACEHEADER)

                  if ( RecInd .lt. 0 .and. 
     :                 ifmt_TrWrd1 .eq. SAVE_SHORT_DEF .and. 
     :                 .not. warn1) then
                     write(LERR,*)' '
                     write(LERR,*)' You may have exceeded the capacity'
                     write(LERR,*)' of ',TrWrd1
                     write(LERR,*)' in dataset ',ntap(IU)
                     write(LERR,*)' at sequential record ',JJ
                     write(LERR,*)' , sequential trace ',kk
                     write(LER,*)' '
                     write(LER,*)'presort_big '
                     write(LER,*)' You may have exceeded the capacity'
                     write(LER,*)' of ',TrWrd1
                     write(LER,*)' in dataset ',ntap(IU)
                     write(LER,*)' sequential record ',JJ
                     write(LER,*)' sequential trace ',kk
                     write(LER,*)'WARNING '
                     warn1 = .true.
                  endif

                  call saver2(lhed,ifmt_TrWrd2,l_TrWrd2, ln_TrWrd2,
     1                 SoPtNm , TRACEHEADER)

                  if ( SoPtNm .lt. 0 .and. 
     :                 ifmt_TrWrd2 .eq. SAVE_SHORT_DEF .and. 
     :                 .not. warn2) then
                     write(LERR,*)' '
                     write(LERR,*)' You may have exceeded the capacity'
                     write(LERR,*)' of ',TrWrd2
                     write(LERR,*)' in dataset ',ntap(IU)
                     write(LERR,*)' sequential record ',JJ
                     write(LERR,*)' sequential trace ',kk
                     write(LER,*)' '
                     write(LER,*)'presort_big '
                     write(LER,*)' You may have exceeded the capacity'
                     write(LER,*)' of ',TrWrd2
                     write(LER,*)' in dataset ',ntap(IU)
                     write(LER,*)' sequential record ',JJ
                     write(LER,*)' sequential trace ',kk
                     write(LER,*)'WARNING '
                     warn2 = .true.
                  endif

                  call saver2(lhed,ifmt_TrWrd3,l_TrWrd3, ln_TrWrd3,
     1                 DphInd , TRACEHEADER)

                  if ( DphInd .lt. 0 .and. 
     :                 ifmt_TrWrd3 .eq. SAVE_SHORT_DEF .and. 
     :                 .not. warn3) then
                     write(LERR,*)' '
                     write(LERR,*)' You may have exceeded the capacity'
                     write(LERR,*)' of ',TrWrd3
                     write(LERR,*)' in dataset ',ntap(IU)
                     write(LERR,*)' sequential record ',JJ
                     write(LERR,*)' sequential trace ',kk
                     write(LER,*)' '
                     write(LER,*)'presort_big '
                     write(LER,*)' You may have exceeded the capacity'
                     write(LER,*)' of ',TrWrd3
                     write(LER,*)' in dataset ',ntap(IU)
                     write(LER,*)' sequential record ',JJ
                     write(LER,*)' sequential trace ',kk
                     write(LER,*)'WARNING '
                     warn3 = .true.
                  endif

                  call saver2(lhed,ifmt_TrWrd4,l_TrWrd4, ln_TrWrd4,
     1                 DstSgn , TRACEHEADER)

                  if ( DstSgn .lt. 0 .and. 
     :                 ifmt_TrWrd5 .eq. SAVE_SHORT_DEF .and. 
     :                 .not. warn5) then
                     write(LERR,*)' '
                     write(LERR,*)' You may have exceeded the capacity'
                     write(LERR,*)' of ',TrWrd4
                     write(LERR,*)' in dataset ',ntap(IU)
                     write(LERR,*)' sequential record ',JJ
                     write(LERR,*)' sequential trace ',kk
                     write(LER,*)' '
                     write(LER,*)'presort_big '
                     write(LER,*)' You may have exceeded the capacity'
                     write(LER,*)' of ',TrWrd4
                     write(LER,*)' in dataset ',ntap(IU)
                     write(LER,*)' sequential record ',JJ
                     write(LER,*)' sequential trace ',kk
                     write(LER,*)'WARNING '
                     warn5 = .true.
                  endif

c  find maximum src, rcvr, & mid point bin X & Y coords

                  call saver2(lhed,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                 SrPtXC, TRACEHEADER)
                  val = float(SrPtXC)
                  if (val .ge. srptxmax) srptxmax = val
                  if (val .le. srptxmin) srptxmin = val

                  call saver2(lhed,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                 SrPtYC, TRACEHEADER)
                  val = float(SrPtYC)
                  if (val .ge. srptymax) srptymax = val
                  if (val .le. srptymin) srptymin = val

                  call saver2(lhed,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                 RcPtXC, TRACEHEADER)
                  val = float(RcPtXC)
                  if (val .ge. rcptxmax) rcptxmax = val
                  if (val .le. rcptxmin) rcptxmin = val

                  call saver2(lhed,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                 RcPtYC, TRACEHEADER)
                  val = float(RcPtYC)
                  if (val .ge. rcptymax) rcptymax = val
                  if (val .le. rcptymin) rcptymin = val

                  call saver2(lhed,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                 SrRcMX, TRACEHEADER)
                  val = float(SrRcMX)
                  if (val .ge. srrcxmax) srrcxmax = val
                  if (val .le. srrcxmin) srrcxmin = val

                  call saver2(lhed,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                 SrRcMY, TRACEHEADER)
                  val = float(SrRcMY)
                  if (val .ge. srrcymax) srrcymax = val
                  if (val .le. srrcymin) srrcymin = val

                  call saver2(lhed,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                 CDPBCX, TRACEHEADER)
                  val = float(CDPBCX)
                  if (val .ge. cdpbxmax) cdpbxmax = val
                  if (val .le. cdpbxmin) cdpbxmin = val

                  call saver2(lhed,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                 CDPBCY, TRACEHEADER)
                  val = float(CDPBCY)
                  if (val .ge. cdpbymax) cdpbymax = val
                  if (val .le. cdpbymin) cdpbymin = val

c set the limits to something appropriate for the dataset

                  if ( first_live_trace ) then
                     srptxmax = float(SrPtXC)
                     srptxmin = float(SrPtXC)
                     srptymax = float(SrPtYC)
                     srptymin = float(SrPtYC)
                     rcptxmax = float(RcPtXC)
                     rcptxmin = float(RcPtXC)
                     rcptymax = float(RcPtYC)
                     rcptymin = float(RcPtYC)
                     srrcxmax = float(SrRcMX)
                     srrcxmin = float(SrRcMX)
                     srrcymax = float(SrRcMY)
                     srrcymin = float(SrRcMY)
                     cdpbxmax = float(CDPBCX)
                     cdpbxmin = float(CDPBCX)
                     cdpbymax = float(CDPBCY)
                     cdpbymin = float(CDPBCY)
                     first_live_trace = .false.
                  endif

c-------------------------------------
c we're going to check to see if
c 2 of the primary indices are non 0
c & if so call it a valid indexed trc
c & update our live sorted trc count

                  IF(RecInd.ne.0 .and. SoPtNm.ne.0 .OR.
     1               RecInd.ne.0 .and. DphInd.ne.0 .OR.
     2               SoPtNm.ne.0 .and. DphInd.ne.0      ) THEN

                     ic = ic + 1
                     call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    RecNum , TRACEHEADER)

                     if ( RecNum .lt. 0 .and. 
     :                    ifmt_RecNum .eq. SAVE_SHORT_DEF .and. 
     :                    .not. warn1) then
                        write(LERR,*)' '
                        write(LERR,*)' You may have exceeded the capacit
     :y'
                        write(LERR,*)' of RecNum'
                        write(LERR,*)' in dataset ',ntap(IU)
                        write(LERR,*)' sequential record ',JJ
                        write(LERR,*)' sequential trace ',kk
                        write(LER,*)' '
                        write(LER,*)'presort_big '
                        write(LER,*)' You may have exceeded the capacity
     :'
                        write(LER,*)' of RecNum'
                        write(LER,*)' in dataset ',ntap(IU)
                        write(LER,*)' sequential record ',JJ
                        write(LER,*)' sequential trace ',kk
                        write(LER,*)'WARNING '
                        warn1 = .true.
                     endif

                     call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    TrcNum , TRACEHEADER)

                     if ( TrcNum .lt. 0 .and. 
     :                    ifmt_TrcNum .eq. SAVE_SHORT_DEF .and. 
     :                    .not. warn1) then
                        write(LERR,*)' '
                        write(LERR,*)' You may have exceeded the capacit
     :y'
                        write(LERR,*)' of TrcNum'
                        write(LERR,*)' in dataset ',ntap(IU)
                        write(LERR,*)' sequential record ',JJ
                        write(LERR,*)' sequential trace ',kk
                        write(LER,*)' '
                        write(LER,*)'presort_big '
                        write(LER,*)' You may have exceeded the capacity
     :'
                        write(LER,*)' of TrcNum'
                        write(LER,*)' in dataset ',ntap(IU)
                        write(LER,*)' sequential record ',JJ
                        write(LER,*)' sequential trace ',kk
                        write(LER,*)'WARNING '
                        warn2 = .true.
                     endif

                     if (DstSgn .ge. dismax) dismax = DstSgn
                     if (DstSgn .le. dismin) dismin = DstSgn

                     if ( round ) then
                        DstSgna = abs (DstSgn)
                        if (DstSgn .ne. 0.0) then
                           sgn = 1.001 * DstSgn / DstSgna
                           idx = 10 * int (DstSgna/10. + 0.50)
                           idx = int(sgn) * int(idx)
                        else
                           idx = 0
                        endif
                        DstSgn = float (int(idx))
                     endif

                     if (model) then
                        do  22  J = 2, ngrp
                           x1 = spread(j-1)
                           x2 = spread(j)
                           if (DstSgn .le. x1 .AND. DstSgn .gt. x2) then
                              DstSgn = x1
                              go to 23
                           endif
 22                     continue
 23                     continue
                     endif

                     if (verbos) then
                        it = it + 1
                        if (kk .eq. 1)
     1                       write(LERR,666)
 666                    format('Tot Trc Cnt',5x,'GI',8x,
     1                       'SI',8x,'DI',8x,'LI',7x,'DIST',5x,'rec #',
     1                       5x,'HW6',7x,'Hw7',7x,'rec #',5x,
     2                       'trc #',5x,'static')
                        write(LERR,777)it,RecInd,SoPtNm,
     1                       DphInd,LinInd,
     1                       DstSgn,ihwrd5,
     1                       ihwrd7,
     2                       RecNum,TrcNum,
     3                       StaCor
 777                    format(11(i8,2x))
                     endif

c-----
c      indices to sort on
c      note:  we can sort on src pt # or 10 x src pt #
c-----
                     iunit(ic) = iu
                     inrec(ic) = RecInd
                     if (ten) then
                        insrc(ic) = SoPtNm/10
                     else
                        insrc(ic) = SoPtNm
                     endif
                     incdp(ic) = DphInd
                     indst(ic) = DstSgn
                     jndst(ic) = DstSgn
c-----
c      permanent trace identification
c-----
                     if(renum)then
                        jntrc(ic)=kk
                        jnrec(ic)=jj
                     else
                        jnrec(ic)=RecNum
                        jntrc(ic)=TrcNum
                     endif
                     
                  ENDIF
               ENDIF

            enddo
         ENDDO

 1001    continue

      ENDDO

 1002 continue
      ndat = ic

c sort the data set

      call trsort( items, ndat, inrec, insrc, incdp, indst, jnrec, 
     :     jntrc, jndst, kyrec, kysrc, kycdp, kydst, kygi, srttmp, 
     :     luns, iunit )

c terminate the program

 999  continue

      write(LERR,*)' '
      write(LERR,*)'Maximum source point X-coordinate      = ',srptxmax
      write(LERR,*)'Minimum source point X-coordinate      = ',srptxmin
      write(LERR,*)'Maximum source point Y-coordinate      = ',srptymax
      write(LERR,*)'Minimum source point Y-coordinate      = ',srptymin
      write(LERR,*)' '
      write(LERR,*)'Maximum receiver point X-coordinate    = ',rcptxmax
      write(LERR,*)'Minimum receiver point X-coordinate    = ',rcptxmin
      write(LERR,*)'Maximum receiver point Y-coordinate    = ',rcptymax
      write(LERR,*)'Minimum receiver point Y-coordinate    = ',rcptymin
      write(LERR,*)' '
      write(LERR,*)'Maximum src/rcvr midpoint X-coordinate = ',srrcxmax
      write(LERR,*)'Minimum src/rcvr midpoint X-coordinate = ',srrcxmin
      write(LERR,*)'Maximum src/rcvr midpoint Y-coordinate = ',srrcymax
      write(LERR,*)'Minimum src/rcvr midpoint Y-coordinate = ',srrcymin
      write(LERR,*)' '
      write(LERR,*)'Maximum CDP bin center X-coordinate    = ',cdpbxmax
      write(LERR,*)'Minimum CDP bin center X-coordinate    = ',cdpbxmin
      write(LERR,*)'Maximum CDP bin center Y-coordinate    = ',cdpbymax
      write(LERR,*)'Minimum CDP bin center Y-coordinate    = ',cdpbymin
      write(LERR,*)' '
      write(LERR,*)'Maximum trace distance = ', dismax
      write(LERR,*)'Minimum trace distance = ', dismin
      write(LERR,*)' '
      
      do  i = 1, NumberOfNtaps
         call lbclos( luin(i) )
      enddo

      if(luns .eq. 1)close (luns)
      close (LERR)
      stop
      end
      
      subroutine trsort( size, ndat, inrec, insrc, incdp, indst, jnrec, 
     :     jntrc, jnwd6, kyrec, kysrc, kycdp, kydst, kygi, srttmp, 
     :     luns, iunit)

c-----
c     subroutine to do sorting of indices
c
c     the object of the sort routine is
c     to order these for use with  the gsort program
c
c     the table output will consist of 13 columns, of which
c     12 have useful information. In order of output, they are:
c
c      COLUMN NAME       DESCRIPTION
c
c      1      inrec      The (rec,trc) pair in columns 5,6 have
c                        this receiver index
c      2      insrc      The (rec,trc) pair in columns 7,8 have
c                        this source index
c      3      incdp      The (rec,trc) pair in columns 9,10 have
c                        this cdp index
c      3      inlin      The (rec,trc) pair in columns 10,11 have
c                        this line index
c      4      rec        Record corresponding to the sorted receiver
c                        index
c      5      trc        Trace  corresponding to the sorted receiver
c                        index
c      6      rec        Record corresponding to the sorted source
c                        index
c      7      trc        Trace  corresponding to the sorted source
c                        index
c      8      rec        Record corresponding to the sorted cdp
c                        index
c      9      trc        Trace  corresponding to the sorted cdp
c                        index
c     10      indst      The (rec,trc) pair in columns 11,12 have
c                        this distance index
c     11      rec        Record corresponding to the sorted distance
c                        index
c     12      trc        Trace  corresponding to the sorted distance
c                        index
c     13      dist       Actual signed distance corresponding to
c                        the (rec,trc) pair in columns 11,12
c                        Note the sort in done on the quantity
c                        RecInd - SoPtNm/10 
c
c-----
c      ndat      I*4      - total number of points in the arrays
c      nrec      I*4      - number of records in original data set
c      ntrc      I*4      - number of traces  in original data set
c      luns       I*4      - FORTRAN output logical unit number
c
c-----

#include <f77/iounit.h>

      integer size, ndat, luns, reccnt, trccnt

      integer   inrec(size), insrc(size), incdp(size), indst(size)
      integer   jnrec(size), jntrc(size), kygi(size)
      integer   kyrec(size), kysrc(size), kycdp(size), kydst(size)
      integer   srttmp(size)
      integer   iunit(size)
      integer   rec(4), trc(4), fld(4)

c-----
c     note that I sort real numbers rather than integers
c     for compatibility with the subroutine sort -- this
c     could be easily changed
c-----
            do 100 j=1,4
                  do 200 i=1,ndat
                        if(j.eq.1)then
                              srttmp(i) = inrec(i)
                        elseif(j.eq.2)then
                              srttmp(i) = insrc(i)
                        elseif(j.eq.3)then
                              srttmp(i) = incdp(i)
                        elseif(j.eq.4)then
                              srttmp(i) = indst(i)
                        endif
  200                  continue
                  if(j.eq.1)then
                        call sort(srttmp,kyrec,ndat)
                  elseif(j.eq.2)then
                        call sort(srttmp,kysrc,ndat)
                  elseif(j.eq.3)then
                        call sort(srttmp,kycdp,ndat)
                  elseif(j.eq.4)then
                        call sort(srttmp,kydst,ndat)
                  endif
  100            continue

c-----
c      go through the sorted data set to determine
c      the effective number of records and traces
c      corresponding to each unique sort
c-----
       write(LERR,*)' '
       write(LERR,*)' '
       do 2000 n=1,4

             write(LERR,*)' '
             write(LERR,*)' '
              if     (n .eq. 1) then
                 write(LERR,*)'Receiver or First Primary Index: '
              elseif (n .eq. 2) then
                 write(LERR,*)'Source or Second Primary Index: '
              elseif (n .eq. 3) then
                 write(LERR,*)'Depth or Third Primary Index: '
              endif
              write(LERR,*)' '
              write(LERR,*)'gather index             # trcs/gath'
              write(LERR,*)' '

              reccnt = 0
              trccnt = 0
              maxcnt = 0
              do 2010 i=1,ndat
                     if(n.eq.1)then
                            j = inrec(kyrec(i))
                     elseif(n.eq.2)then
                            j = insrc(kysrc(i))
                     elseif(n.eq.3)then
                            j = incdp(kycdp(i))
                     elseif(n.eq.4)then
                            j = indst(kydst(i))
                     endif
                     call dif(reccnt,trccnt,i,j,jump,ndat)
                     if (trccnt .ge. maxcnt .and. jump .eq. 1) then
                        maxcnt = trccnt
                     endif
                     if (jump .eq. 1)
     1               write(LERR,*)j,'                        ',trccnt
 2010         continue
              if (maxcnt .eq. 0) maxcnt = trccnt
              write(LERR,*)' '
              write(LERR,*)'Max number trcs/gather =  ',maxcnt
              rec(n) = reccnt
              trc(n) = maxcnt

              if (reccnt .eq. 0 .OR. maxcnt .eq. 0) then

                 write(LERR,*)' '
                 write(LERR,*)'presort:  FATAL ERROR'
                 write(LER,*)'presort:  FATAL ERROR: check printout'
                 if (n .eq. 1)
     1           write(LERR,*)'in receiver (group) primary sort ---'
                 if (n .eq. 2)
     1           write(LERR,*)'in shot primary sort ---'
                 if (n .eq. 3)
     1           write(LERR,*)'in common depth primary sort ---'
                 if (n .eq. 4)
     1           write(LERR,*)'in offset primary sort ---'
                 if (reccnt .eq. 0)
     1           write(LERR,*)'zero gathers found'
                 if (trccnt .eq. 0)
     1           write(LERR,*)'zero length gather found'
                 write(LERR,*)'Check indexing of data or rerun presort'
                 write(LERR,*)'with -V and look at indeces read.'
                 write(LERR,*)' '
                 stop 666

              endif

 2000  continue

c-----
c  note that as of 4/91 dif() now has ndat as an argument
c  this is to make sure that the end of the data are treated
c  properly
c-----

c-----
c      for use by common offset receiver statics
c      output the very first GI in the data set
c      and also the GI difference
c-----

       do 1000 n=1,4
              reccnt = 0
              kold = 1
              do 1100 i=1,ndat
                     if(n.eq.1)then
                            j = inrec(kyrec(i))
                     elseif(n.eq.2)then
                            j = insrc(kysrc(i))
                     elseif(n.eq.3)then
                            j = incdp(kycdp(i))
                     elseif(n.eq.4)then
                            j = indst(kydst(i))
                     endif
                     call dif(reccnt,trccnt,i,j,jump,ndat)
                     if(i.eq.ndat .and. jump.eq.0)then
                            knew = i 
                     else
                            knew = i - 1
                     endif
                     if( jump.eq.1 .or. i.eq.ndat)then
                     do 1101 k=kold,knew
                            ii = k - kold +1
                            if(n.eq.1)then
                                   ll=indst(kyrec(k))
                            elseif(n.eq.2)then
                                   ll=indst(kysrc(k))
                            elseif(n.eq.3)then
                                   ll=indst(kycdp(k))
                            elseif(n.eq.4)then
                                   ll=inrec(kydst(k))
                            endif
                            srttmp(ii)=ll
 1101                continue
                     call sort(srttmp,kygi,knew-kold+1)
                     do 1102 k=kold,knew
                            ii = k - kold +1
                            if(n.eq.1)then
                                   ll=kyrec(k)
                            elseif(n.eq.2)then
                                   ll=kysrc(k)
                            elseif(n.eq.3)then
                                   ll=kycdp(k)
                            elseif(n.eq.4)then
                                   ll=kydst(k)
                            endif
                            srttmp(ii)=ll
 1102                continue
                     do 1103 k=kold,knew
                            ii = k - kold +1
                            if(n.eq.1)then
                                   kyrec(k) = srttmp(kygi(ii))
                            elseif(n.eq.2)then
                                   kysrc(k) = srttmp(kygi(ii))
                            elseif(n.eq.3)then
                                   kycdp(k) = srttmp(kygi(ii))
                            elseif(n.eq.4)then
                                   kydst(k) = srttmp(kygi(ii))
                            endif
 1103                continue
                     kold = i
                     endif
 1100         continue
 1000  continue

       write(luns,'(i10)')ndat
       write(luns,'(15i7)')(rec(i),trc(i),fld(i),i=1,4)

       write(luns,'(i7,1x,i7)')inrec(kyrec(1)),inrec(kydst(2))-
     1                         inrec(kydst(1))
c-----
c     output the sorted information
c-----
            do 400 i=1,ndat
                  j = kyrec(i)
                  k = kysrc(i)
                  l = kycdp(i)
                  n = kydst(i)
                  write(luns,'(20(i7,1x))')
     1                  inrec(j),insrc(k),incdp(l),indst(n),
     2               iunit(j),jnrec(j),jntrc(j),
     3               iunit(k),jnrec(k),jntrc(k),
     4               iunit(l),jnrec(l),jntrc(l),
     6               iunit(n),jnrec(n),jntrc(n)
  400            continue
      return
      end

      subroutine dif(ir,it,i,j,jump,ndat)
c-----
c     increment record count (ir) and trace count (it)
c     whenever j changes
c     i is the initialization flag
c     jump indicates that a transition to a new record has occurred
c
c     for i = 1 we initialize the counters ir,it,nr,nt,oldj,jump

c     for 1<i<ndat we check to see if the sorted index j  changes
c         if it does we set jump=0, check to see if the cummulative
c         # traces for this index is the largest so far (set "it" if so),
c         set ir to be the new sequential gather counter, reset nt=1, &
c         reset oldj to be the new sorted index

c     for i=ndat we have reached the end of the data and we must make sure
c         1) there is suddenly a new index starting, or 2) still the last indx
c         for (2) we need to bump nt by one (one more trc in the current gather
c            and check to see if this is now the largest gather
c         for (1) we bump the gather counter by 1 & reset the trc counter to 1
c-----
      save oldj, nt, nr
      if(i .eq. 1)then
            ir = 1
            it = 1
            nt = 1
            nr = 1
                  oldj = j
                  jump = 0
      elseif (i .gt. 1 .and. i .lt. ndat) then
                  if    (j .eq. oldj) then
                         nt = nt + 1
                         jump = 0
                  elseif(j .ne. oldj) then
                         nr = nr + 1
                         if(nt .gt. it) it = nt
                         nt = 1
                         ir = nr
                         oldj = j
                         jump = 1
                  endif
      elseif (i .eq. ndat) then
                  if    (j .eq. oldj) then
                         jump = 0
                  elseif(j .ne. oldj) then
                         jump = 1
                  endif
                  if     (jump .eq. 0) then
                         nt = nt + 1
                         if (nt .ne. it) it = nt
                         nt = 1
                  elseif (jump .eq. 1) then
                         nt = 1
                         nr = nr + 1
                         ir = nr
                  endif
      endif

      return
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     1'***************************************************************'
      write(LER,*)
     1'execute presort_big by typing presort_big and the cmd line args'
      write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)
     1'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     1' -N [ntap]    (default = stdin)  : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout) : output data file name'
        write(LER,*)' '
      write(LER,*)
     1' -Hw1 [TrWrd1] (def = RecInd [rcvr])  : primary sort word 1'
      write(LER,*)
     1' -Hw2 [TrWrd2] (def = SrcLoc [src])   : primary sort word 2'
      write(LER,*)
     1' -Hw3 [TrWrd3] (def = DphInd [cdp])   : primary sort word 3'
      write(LER,*)
     1' -Hw4 [TrWrd4] (def = DstSgn [offset]): secondary sort word'
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)' '
      write(LER,*)
     1' -M           (default = false)  : model spread (i.e. bin)'
      write(LER,*)
     1' -off [off]   (default = none)   : largest absolute offset'
      write(LER,*)
     1' -grp [grp]   (default = none)   : group interval (ft,m)'
        write(LER,*)' '
      write(LER,*)
     1' -R           (default = false)  : round distances to 10'
      write(LER,*)
     1' -X           (default = true)   : use PRI not record order'
      write(LER,*)
     1'Note: this is NOT recommended for normal processing'
      write(LER,*)
     1' -S           (default = false)  : sort on src pt number/10'
      write(LER,*)
     1' -K           (default = false)  : keep dead traces in table'
      write(LER,*)
     1'Note: dead traces MUST have proper indices in headers'
      write(LER,*)
     1' -V           (default = false)  : verbose diagnostics'
        write(LER,*)' '
         write(LER,*)
     1'usage:   presort_big -N[ntap] -O[otap]'
         write(LER,*)
     1'                 -Hw[1,2,3,4][TrWrd[1,2,3,4]]'
         write(LER,*)
     1'                 [-M -off[] -grp[] -R -X -S -K -V]'
         write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln( ntap, otap, verbos, renum, ten, keep, round, 
     :     model, off, grp, NumberOfNtaps, pmax, TrWrd1, TrWrd2, TrWrd3, 
     :     TrWrd4)

c get command arguments

#include <f77/iounit.h>

c declare variables passed from the calling routine

      integer   pmax, NumberOfNtaps

      real      off, grp

      character ntap(*)*256, otap*256
      character TrWrd1*6, TrWrd2*6, TrWrd3*6, TrWrd4*6
      character TrWrd5*6, TrWrd6*6, TrWrd7*6

      logical   verbos, renum, ten, keep, round, model

c declare local variables

      integer   argis

c initialize variables

      NumberOfNtaps = 0

c process command line

      call argstr( '-Hw1', TrWrd1, 'RecInd', 'RecInd')
      call argstr( '-Hw2', TrWrd2, 'SoPtNm', 'SoPtNm')
      call argstr( '-Hw3', TrWrd3, 'DphInd', 'DphInd')
      call argstr( '-Hw4', TrWrd4, 'DstSgn', 'DstSgn')
      call argstr( '-Hw5', TrWrd5, 'DstSgn', 'DstSgn')
      call argstr( '-Hw6', TrWrd6, 'DphInd', 'DphInd')
      call argstr( '-Hw7', TrWrd7, 'DstSgn', 'DstSgn')

      do  i = 1, 100
         call argstr( '-N', ntap(i), ' ', ' ' )
         if (ntap(i) .eq. ' ') go to 1
         NumberOfNtaps = NumberOfNtaps + 1
      enddo

 1    continue
      
      call argstr( '-O', otap, ' ', ' ' )

      call argi4('-P', pmax, 100, 100)

      round  = ( argis( '-R' ) .gt. 0 )
      ten    = ( argis( '-S' ) .gt. 0 )
      keep   = ( argis( '-K' ) .gt. 0 )
      renum  = ( argis( '-X' ) .eq. 0 )
      verbos = ( argis( '-V' ) .gt. 0 )
      model  = ( argis( '-M' ) .gt. 0 )

      if (model) then
         call argr4 ( '-off',off, 0., 0.)
         call argr4 ( '-grp',grp, 0., 0.)
         if (off .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'presort_big:'
            write(LERR,*)'  You must enter maximum absolute offset'
            write(LERR,*)'  Enter using -off[] on cms line & rerun'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'presort_big:'
            write(LER,*)'  You must enter maximum absolute offset'
            write(LER,*)'  Enter using -off[] on cms line & rerun'
            write(LER,*)'FATAL'
            stop
         endif
         if (grp .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'presort_big:'
            write(LERR,*)'  You must enter group interval'
            write(LERR,*)'  Enter using -grp[] on cms line & rerun'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'presort_big:'
            write(LER,*)'  You must enter group interval'
            write(LER,*)'  Enter using -grp[] on cms line & rerun'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      return
      end

      subroutine verbal( nsamp, nsi, ntrc, nrect, iform, 
     :     NumberOfNtaps, ntap, otap, renum, ten, nrec, TrWrd1, TrWrd2, 
     :     TrWrd3, TrWrd4, TrWrd5, TrWrd6, TrWrd7 )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer    nsamp, nsi, ntrc, nrect, iform, nrec(*)

      logical    renum, ten

      character  ntap(*) * 256, otap * 256
      character TrWrd1*6, TrWrd2*6, TrWrd3*6, TrWrd4*6, TrWrd5*6
      character TrWrd6*6, TrWrd7*6

      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*) ' # of samples/trace  =  ', nsamp
      write(LERR,*) ' sample interval     =  ', nsi
      write(LERR,*) ' traces per record   =  ', ntrc
      write(LERR,*) ' total # records     =  ', nrect
      write(LERR,*) ' input data set names=  ', (ntap(i),
     1     i=1,NumberOfNtaps)
      write(LERR,*) ' records per data set=  ', (nrec(i),
     1     i=1,NumberOfNtaps)
      write(LERR,*) ' output data set name=  ', otap
      write(LERR,*) ' use relative record indx=',renum
      write(LERR,*) ' sort on src pt. number/10 =  ',ten
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'First primary sort mnemonic   = ',TrWrd1
      write(LERR,*)'Second primary sort mnemonic  = ',TrWrd2
      write(LERR,*)'Third primary sort mnemonic   = ',TrWrd3
      write(LERR,*)'Fourth primary sort mnemonic  = ',TrWrd4
      write(LERR,*)'Fifth primary sort mnemonic   = ',TrWrd5
      write(LERR,*)'First secondary sort mnemonic = ',TrWrd6
      write(LERR,*)'First tertiary sort mnemonic  = ',TrWrd7
      write(LERR,*)' '

      return
      end

      subroutine heaps ( msg, heapin, heap )
      character  msg*21
      logical    heap, heapin

#include <f77/iounit.h>

      if (heapin) then

         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)msg

      else

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)msg
         heap = .false.

      endif


      return
      end
