c -----------------  Main Routine -----------------------
c
c     copyright 2001, Amoco Production Company 
c              All rights reserved
c        an affiliate of BP America Inc.
c
c -----------------  ------------ -----------------------

c     Program Changes:

c      - original written: June 26, 2001

c     Program Description:

c      - template for record processing in USP.  This is a very basic version
c     and contains only the bare minimum of functionality.  For a complete
c     picture see ~usp/src/cmd/prgm.F

      implicit none

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis, jerr

      real        UnitSc, dt

      character   ntap*255, otap*255, name*4

      logical     verbos

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, errcd1, errcd2, errcd3, abort
      integer Headers

      real    Record, Record_WorkSpace

      pointer (mem_Record, Record(2))
      pointer (mem_Space, Record_WorkSpace(2))
      pointer (mem_Headers, Headers(2))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer hdr_index, tr_index, JJ, KK, lenth, length

c Initialize variables

      data abort/0/
      data name/"PRGM"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         length = lenth(ntap)
         write(LERR,*)'PRGM: no line header on input dataset',
     :        ntap(1:length)
         write(LER,*)' '
         write(LER,*)'PRGM: '
         write(LER,*)' no line header on input dataset',ntap(1:length)
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c POLICEMAN: check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are 
c assumed and loaded to the header for further processing.

      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr, 'UnitSc', UnitSc, LINHED)
      endif

c compute delta T in seconds

      dt = real (nsi) * UnitSc

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

c this parameterization assumes input in units of the dataset

      ist = nint ( float(ist) / float(nsi) ) + 1
      if ( ist .eq. 0 ) ist = 1

      if ( iend .eq. -99999 ) then
         iend = nsamp
      else
         iend = nint ( float(iend) / float(nsi) ) + 1
         if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp
      endif

      nreco = ire - irs + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, verbos)

c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 

      call galloc (mem_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (mem_Space, RecordSize * SZSMPD, errcd2, abort)
      call galloc (mem_Headers, HeaderSize * SZSMPD, errcd3, abort)
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call move ( 0, Record, 1, RecordSize*SZSMPD )
      call move ( 0, Record_WorkSpace, 1, RecordSize*SZSMPD )
      call move ( 0, Headers, 1, HeaderSize*SZSMPD )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

          DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call move ( 1, Record(tr_index), itr(ITHWP1), nsamp*SZSMPD )

           else
              call move ( 0, Record(tr_index), 0, nsamp*SZSMPD )
           endif

c load trace header to array Headers[]

            call move ( 1, Headers(hdr_index), itr, ITRWRD*SZSMPD )

         ENDDO

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]

         call subs ( Record, Headers, Record_WorkSpace, nsamp, ntrc, 
     :        ist, iend )

c reset array load points for this trace 

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

c write output data

         DO KK = 1, ntrc

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

            call move ( 1, itr(ITHWP1), Record(tr_index), nsamp*SZSMPD )
            call move ( 1, itr(1), Headers(hdr_index), ITRWRD*SZSMPD )
            call wrtape (luout, itr, obytes)
 
         ENDDO
      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'prgm: Normal Termination'
      write(LER,*)'prgm: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'prgm: ABNORMAL Termination'
      write(LER,*)'prgm: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for PRGM: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       prgm -N[] -O[] -s[] -e[] -rs[] -re[] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos )

      implicit none

#include <f77/iounit.h>

      integer    ist, iend, irs, ire, argis

      character  ntap*(*), otap*(*), name*(*)

      logical    verbos

           call argi4 ( '-e', iend, -99999, -99999 )

           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi

      character  ntap*(*), otap*(*)

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





