C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  putsis: chunk a bunch of numbers is a file or 
C                             stdin into sis trace format (with header)
C
C**********************************************************************C
C
C READ INPUT NUMBERS, ATTACH LINE & TRACE HEADER, AND
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C - modified Aug 10, 2001 to dynamically allocate space for data
C   eliminated references to LHED & HEAD   - Joe M. Wade 
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c     INTEGER     ITR ( SZLNHD )
      INTEGER     ITR
c     INTEGER     LHED( SZLNHD )
c     REAL        HEAD( SZLNHD )
      INTEGER     NSAMP, NSI, NCOL, NREC, IFORM
      INTEGER     LUOUT, LBYTES,obytes
      integer     argis
#include <f77/pid.h>
      REAL        work ( 1 ),ami(1)
      CHARACTER   NAME * 6, otap * 256, ntap * 256
      logical     verbos, query, fill, col
      pointer     (pw,work)
      pointer     (pam,ami)
      pointer     (mem_itr,itr(1))
 
c     EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )
      DATA NAME     /'PUTSIS'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./

c--------------------------------
c  get online help if necesssary
c--------------------------------
      query = ( argis( '-?' ) .gt. 0 .OR. argis( '-h' ) .gt. 0 .OR.
     1        argis( '-help' ) .gt. 0 )
      if ( query ) then
           call help()
           stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,nsi,nsamp,ntrc,verbos,fill,val,col)

C**********************************************************************C
C     open output data set; build line header
C**********************************************************************C
      if (.not. fill) then

         if (ntap .ne. ' ') then
             LUVAL = LUCARD
             open (LUVAL, file = ntap)
             rewind LUVAL
         else
             LUVAL = LIN
         endif

      endif

      call getln( luout, otap, 'w', 1)

      if (nsamp .eq. 0) nsamp = 2*SZLNHD
      nrec  = 1
      iform = 3
      unitsc = .001
      iget = nsamp * ntrc * SZSMPD
      iab=0
      ier=0
      call galloc(pw, iget,ier,iab)
      iget = ntrc * SZSMPD
      call galloc(pam,iget,ier,iab)
      if(ier.ne.0)then
       write(LER ,*)'PUTSIS ERROR: Memory allocation error.'
       write(LER,*) '              attempt to allocate ',iget,
     :    ' bytes.'
       write(LER, *) ' FATAL!'
       write(LERR ,*)'ERROR: Memory allocation error.'
       write(LERR,*) '              attempt to allocate ',iget,
     :    ' bytes.'
       write(LERR, *) ' FATAL!'
       stop 1
      endif

      iget = SZLNHD
      call galloc(mem_itr,iget,ier,iab)
      if(ier.ne.0)then
       write(LER ,*)'PUTSIS ERROR: Memory allocation error.'
       write(LER,*) '              attempt to allocate ',iget,
     :    ' bytes.'
       write(LER, *) ' FATAL!'
       write(LERR ,*)'ERROR: Memory allocation error.'
       write(LERR,*) '              attempt to allocate ',iget,
     :    ' bytes.'
       write(LERR, *) ' FATAL!'
       stop 2
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)


      call savew( itr, 'NumTrc', ntrc  , LINHED)
      call savew( itr, 'NumRec', nrec  , LINHED)
      call savew( itr, 'SmpInt',  nsi  , LINHED)
      call savew( itr, 'NumSmp', nsamp , LINHED)
      call savew( itr, 'Format', iform , LINHED)
      call savew( itr, 'UnitSc', unitsc, LINHED)
c-------------------------------------
c  update line header; historical LH
c-------------------------------------
      write(LERR,*)' '
      write(LERR,*)'Number samples      =  ',nsamp
      write(LERR,*)'Number records      =  ',nrec
      write(LERR,*)'Number traces       =  ',ncol
      write(LERR,*)'Sample interval     =  ',nsi
      write(LERR,*)' '

      obytes = SZTRHD + SZSMPD*nsamp
      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      call savew( itr, 'HlhEnt',  0   , LINHED)
      call savew( itr, 'HlhByt', nbyt , LINHED)
      call savhlh( itr, lbytes, lbyout )
c------------------------
c write line hdr, trace
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

      call grealloc(mem_itr,obytes,ier,iab)
      if(ier.ne.0)then
       write(LER ,*)'PUTSIS ERROR: Memory allocation error.'
       write(LER,*) '              attempt to allocate ',obytes,
     :    ' bytes.'
       write(LER, *) ' FATAL!'
       write(LERR ,*)'ERROR: Memory allocation error.'
       write(LERR,*) '              attempt to allocate ',obytes,
     :    ' bytes.'
       write(LERR, *) ' FATAL!'
       stop 3
      endif

      call vclr (work, 1, ncol*nsamp)

      IF ( fill ) THEN

        do  k = 1, ntrc
            m = (k-1) * nsamp
            do  i = 1, nsamp
                work (m+i) = val
            enddo
        end do
        nsampo = nsamp

      ELSE

        if ( col ) then
            do  k = 1, nsamp
                read(LUVAL,*,end=100)(ami(i),i=1,ntrc)
                call vmov(ami,1,work(k),nsamp,ntrc)
            enddo
            nsampo = nsamp
            go to 101
100         nsampo = i-1
101         continue

        else

            do  i = 1, ntrc
                k = (i-1) * nsamp
                read(LUVAL,*,end=200)(work(m),m=k+1,k+nsamp)
            end do
            nsampo = nsamp
            go to 201
200         nsampo = m - k
201         continue

        endif

        if (nsampo .eq. 0) then
            write(LERR,*)'WARNING from putsis:'
            write(LERR,*)'End of data sensed prematurely at trc= ',
     1                    i,'  sample= ',k
            write(LERR,*)'Perhaps no problem; terminating execution'
            go to 999
         endif

      ENDIF

      if (verbos) then
            write(LERR,*)'Trc= ',J,' Number samples read= ',nsampo
            write(LERR,*)(work(i), i=1, nsampo)
      endif

c     call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
c    1            1 , TRACEHEADER)
      call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            1 , TRACEHEADER)


      DO  i = 1, ntrc

         indx = (i-1) * nsamp + 1
c        call savew2(lhed,ifmt_TrcNum,l_TrcNum,ln_TrcNum,i,TRACEHEADER)
c        call vmov (work(indx), 1, lhed(ITHWP1), 1, nsamp)
         call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,i,TRACEHEADER)
         call vmov (work(indx), 1, itr(ITHWP1), 1, nsamp)
         call wrtape(luout,itr,obytes)

      ENDDO
c------------------------

999   continue

      call lbclos(luout)

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for putsis: put numbers in'
        write(LER,*)'sis trace format'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name (stdin)'
        write(LER,*)'-O[otap]   -- output data set name (stdout)'
        write(LER,*)'-ns[nsamp] -- number input/output samples  (none)'
        write(LER,*)'-nt[ntrc]  -- number input records   (none)'
        write(LER,*)'-si[nsi]   -- output sample interval, ms (1)'
        write(LER,*)'-C         -- traces in column format, else trcs'
        write(LER,*)'              one after another with blank lines'
        write(LER,*)'-F         -- fill trace with -v[] value'
        write(LER,*)'-v[val]    -- fill value'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      putsis -N[] [ -F -v[] ] -O[] -ns[] -nt[]'
        write(LER,*)'             -si[] -C -V'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,nsi,nsamp,ntrc,verbos,fill,val,col)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis, nsi, nsamp, ntrc
      real       val
      logical    verbos, fill, col

            call argstr('-N',ntap,' ',' ')
            call argstr('-O',otap,' ',' ')
            call argi4('-ns',nsamp,0,0)
            call argi4('-nt',ntrc,1,1)
            call argi4('-si',nsi,1,1)
            call argr4('-v',val,0.,0.)
            col    = ( argis( '-C' ) .gt. 0 )
            fill   = ( argis( '-F' ) .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )

      if (nsamp .eq. 0) then
         write(LERR,*)'FATAL ERROR in putsis:'
         write(LERR,*)'Must enter number samples -ns[]'
         write(LER ,*)'FATAL ERROR in putsis:'
         write(LER ,*)'Must enter number samples -ns[]'
         stop 666
      endif

      return
      end
