C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C     PROGRAM MODULE  qdchop
C
c CHANGES:
c
c     Feb 2, 1999:  Fixed memory bust in subroutine qdsub.F
c                   where if user declared -ns -ne on command
c                   line; data was assigned outside of declared
c                   memory in subroutine.   Also got rid of lhed
c                   added -help and cleaned up some documentation
c     Garossino
c
C**********************************************************************C
C
C qdchop READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C treating each record like a matrix it does a transpose replacing time
C with range, does a 1-d hilbert transform, another transpose folowed
c by another 1-d hilbert transform.
c this accomplishes a quadrant dip chop
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>


      INTEGER     ITR ( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis, nrst, nred, ns, ne
      INTEGER     mutezn ( SZLNHD )
      REAL        xtr(SZLNHD)
      integer     itrh
      pointer     (wkitrh, itrh(1))
      real        work,works,workt,fs,ft
      pointer     (wkadrfs,  fs(1))         
      pointer     (wkadrft,  ft(1))         
      pointer     (wkadr1, work(1))
      pointer     (wkadrs,works(1))
      pointer     (wkadrt,workt(1))
      CHARACTER   NAME * 6, ntap * 256, otap * 256

      logical     verbos
      logical     up,eof
 
      DATA NAME     /'QDCHOP'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /

c---------------------------------
c  get online help if necessary
c---------------------------------
      if ( argis('-?') .gt. 0 .or.
     :     argis('-h') .gt. 0 .or.
     :     argis('-help') .gt. 0 ) then
         call help ()
         stop
      endif

c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,wc,dip,nrst,nred,verbos,
     1            lfshalf,lfthalf,up,ns,ne,wb)
      lfs=2*lfshalf+1
      lft=2*lfthalf+1

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE  ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'QDCHOP: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt ( ITR , LBYTES, NAME, 6, LERR        )

c---------------------------------
c  save key header values
#include <f77/saveh.h>
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
c----------------------------------
c  check default values

      write(LERR,*)'cmdln: ns,ne,rs,re= ',ns,ne,nrst,nred
      call cmdchk(ns,ne,nrst,nred,ntrc,nrec)
      write(LERR,*)'cmdchk: ns,ne,rs,re= ',ns,ne,nrst,nred

      nrecc = nred-nrst+1
      ntrcc = ne - ns + 1
      ist   = ist/nsi
      iend  = iend/nsi
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
      nsampo = nsamp
c___________________________________________________________________
c     pull off water column velocity
c___________________________________________________________________
      call saver(itr,'WatVel',ivw,LINEHEADER)
      vw=ivw
      if(wb .gt. 0. .and. ivw .eq. 0) then
         write(lerr,*) 'error in routine qdchop!'
         write(lerr,*) 'application of filter to begin at ',
     1                  wb,' times the water depth'
         write(lerr,*) ' WatVel in line header = ',ivw      
         write(lerr,*) ' run utop -h0WatVel=1480 or equivalent'
         call exit(666)
      endif 
      write(lerr,*) ' WatVel in line header = ',vw      
      write(lerr,*) ' water bottom multiplier = ',wb    
c___________________________________________________________________
c     pull off index for water column depth.
c     pull off index for static correction/dead traces.
c___________________________________________________________________
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c___________________________________________________________________
c     update output lineheader
c___________________________________________________________________
      call savew( itr, 'NumSmp', nsampo, LINEHEADER)
      call savew( itr, 'NumRec', nrec  , LINEHEADER)
c----------------------------------------------------------------
c  change output bytes to reflect change from time to # traces
      obytes = SZTRHD + SZSMPD * nsampo
c---------------------------------
c  verbos printout
c     if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Process traces     =  ', ntrcc
        write(LERR,*) ' Process records    =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Output # samples   =  ',nsampo
        write(LERR,*) ' Hilbert filter length (x) = ',lfs,' points'
        write(LERR,*) ' Hilbert filter length (t) = ',lft,' points'
        write(LERR,*) ' Ross weight           = ',wc
        if(dip .gt. 0.) then
           write(LERR,*)' Chop events dipping up from src'
        elseif(dip .lt. 0.) then
           write(LERR,*)' Chop events dipping down from src'
        endif
c     endif
      write(lerr,*) ' luout = ',luout
c---------------------------------------------------
c  malloc only space we're going to use
      iheaperr=0
      itemi = ntrcc * ITRWRD
      items = ntrcc * nsamp
      lent  = ntrcc*(nsampo+2*lfthalf)
      call galloc (wkitrh, itemi*SZSMPD, errcd, abort1)
      if (errcd .ne. 0.) iheaperr=iheaperr+1
      call galloc (wkadr1, items*SZSMPD, errcd, abort1)
      if (errcd .ne. 0.) iheaperr=iheaperr+1
      call galloc (wkadrs, items*SZSMPD, errcd, abort2)
      if (errcd .ne. 0.) iheaperr=iheaperr+1
      call galloc (wkadrt, lent*SZSMPD , errcd, abort2)
      if (errcd .ne. 0.) iheaperr=iheaperr+1
      call galloc (wkadrfs, lfs*SZSMPD , errcd, abort2)
      if (errcd .ne. 0.) iheaperr=iheaperr+1
      call galloc (wkadrft, lft*SZSMPD , errcd, abort2)
      if (errcd .ne. 0.) iheaperr=iheaperr+1
      if (iheaperr .gt. 0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) lent*SZSMPD,'  bytes'
         write(LERR,*) lfs*SZSMPD,'  bytes'
         write(LERR,*) lft*SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemi*SZSMPD,'  bytes'
         write(LER ,*) items*SZSMPD,'  bytes'
         write(LER ,*) items*SZSMPD,'  bytes'
         write(LER ,*) lent*SZSMPD,'  bytes'
         write(LER ,*) lfs*SZSMPD,'  bytes'
         write(LER ,*) lft*SZSMPD,'  bytes'
         write(LER ,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) lent*SZSMPD,'  bytes'
         write(LERR,*) lfs*SZSMPD,'  bytes'
         write(LERR,*) lft*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c-----
      write(lerr,*) ' luout = ',luout

c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbytes, lbyout )
      call wrtape(luout,itr,lbyout)
c------------------------------------------------
c  pass data down to start record
c------------------------------------------------

      nbytes = obytes
      call recrw (1,nrst-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999

c---------------------
c  compute hilbert transform filters for space & time
c---------------------
      wcs = wc
      wct = 2. * wc + 1.0
      call hilbert(1.,wcs,lfshalf,fs)
      call hilbert(1.,wct,lfthalf,ft)
C**********************************************************************C
C
C     READ RECORD, 
c     do spatial and temporal hilbert transformation
c     combine with original data to enhance up or downdip events
C     WRITE RECORD
C
C**********************************************************************C
      DO 100 irec = NRST, NRED
       call qdsub(itr,xtr,itrh,fs,ft,lfshalf,lfthalf,
     1            work,works,workt,mutezn,nsampo,ntrc,
     2            luin,luout,obytes,
     3            dip,eof,irec,ist,iend,ns,ne,ntrcc,
     4            wb,vw,nsi,
     5            ifmt_WDepDP,l_WDepDP,ln_WDepDP,
     6            ifmt_StaCor,l_StaCor,ln_StaCor,
     7            TRACEHEADER)

       if(eof) go to 999

  100 CONTINUE

c------------------------
c  pass remainder of recs
      nbytes = obytes
      call recrw (nred+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999

      call lbclos(luin)
      call lbclos(luout)
      write(LERR,*) 'qdchop: Normal Termination'
      write(LER,*) 'qdchop: Normal Termination'
      stop

  999 continue

      call lbclos(luin)
      call lbclos(luout)
      write(LERR,*) 'qdchop: Abnormal Termination'
      write(LER,*) 'qdchop: Abnormal Termination'
      stop
      END

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for QDCHOP: quadrant chop'
        write(LER,*)'                           dipping events'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-w[wc]     -- ross weight: 0 = no weight     ( 2 )'
        write(LER,*)'-l[lfs]    -- length of hilbert filter      ( 63 )'
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-ns[ns]    -- start process trace          (first)'
        write(LER,*)'-ne[ne]    -- end process trace             (last)'
        write(LER,*)'-rs[nrst]  -- start process record         (first)'
        write(LER,*)'-re[nred]  -- end process record            (last)'
        write(LER,*)'-Wb[wb]    -- start time =                        '
        write(ler,*)'                   wb*time to water bottom    (0.)'
        write(ler,*)'                  (uses WatVel and WDepDP headers)'
        write(LER,*)'-U         -- if present, chop up-dip events'
        write(LER,*)'              else, chop down dip events'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        qdchop -N[] -O[] -s[] -e[] -w[] -l[] '
        write(LER,*)'               -ns[] -ne[] -rs[] -re[] -Wb[] '
        write(ler,*)'               -U -V'
        write(LER,*)' '

      return
      end

      subroutine cmdln (ntap,otap,ist,iend,wc,dip,nrst,nred,verbos,
     1                  lfshalf,lfthalf,up,ns,ne,wb)
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      wc   - R      ross weight
c      lf   - I      length of hilbert filter
c     dip   - R      +- dip chop
c     ist   - I      start sample
c    iend   - I      stop sample
c    nrst   - I      start record
c    nred   - I      stop end record
c    verbos - L      verbose output or not
c-----
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      real       wc
      integer    argis,ist,iend,nrst,nred,lfs,lft,lfshalf,lfthalf
      integer    ns, ne
      logical    verbos, up

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argr4('-w',wc,2.,2.)
          call argi4('-l',lfs,63,63)
          call argi4('-s',ist,1,1)
          call argi4('-e',iend,0,0)
          call argi4('-ns',ns,1,1)
          call argi4('-ne',ne,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          call argr4('-Wb',wb,0.,0.)
          up = (argis('-U') .gt. 0)
          verbos = (argis('-V') .gt. 0)
          if( up ) then
              dip = +1.0
          else
              dip = -1.0
          endif
          lfshalf=lfs/2
          if(mod(lfshalf,2) .eq. 0) then
c_______________________________________
c            make lfshalf odd to allow for stride of 2 convolution
c            on nonzero hilbert components only.
c_______________________________________
             lfshalf=lfshalf+1
           endif
           lfs=2*lfshalf+1  
           lfthalf=2*lfshalf+1
           lft=2*lfthalf+1
      return
      end
