/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
double linearFit(int fitDataNum, double *data)
{
  int i, j;
  double b=0.0, sum1=0.0, sum2=0.0;
  if ( fitDataNum < 2 ) return(b);
  for (i=0;i<=fitDataNum;i++)
  {   sum1 += data[i];
      sum2 += i*data[i];
  }
  b = 6.0*(2.0*sum2/fitDataNum-sum1)/((double) fitDataNum+1)/((double) fitDataNum+2);
  return(b);
}

double slopeFit(int fitDataNum, double *data)
{
  int i;
  double b=0.0, sum, x=0.0;
  if ( fitDataNum < 2 ) return(b);
  sum = data[0];
  for (i=1;i<fitDataNum;i++)
  {
      x += 2.0*i*data[i]-2.0*sum;
      sum += data[i];
  }
  b = 3.0/(fitDataNum*(fitDataNum-1)*(fitDataNum+1))*x;
  return(b);
}

double peakFit(int dataLength, double *data)
{
    int i, *peakIndex, peakNum=0;
    double leftDiff=-1.0, rightDiff, *peakValue;
    double a, slope=0.0, a11, a12=0.0, a22=0.0, b1=0.0, b2=0.0;

    peakIndex=(int *)malloc((dataLength)*sizeof(int));
    peakValue=(double *)malloc((dataLength)*sizeof(double));

    /* Locate the peaks of the given data sequence */
    for (i=0;i<dataLength-1;i++)
    {   rightDiff=data[i+1]-data[i];
        if ((leftDiff>=0) & (rightDiff<=0))
        {  peakIndex[peakNum]=i;
           peakValue[peakNum]=data[i];
           peakNum++;
        }
        leftDiff=rightDiff;
    }

    /* if single peak occurs at start of spectrum fit everything */
 
    if (peakNum < 2 )
    {  for (i=0;i<dataLength-1;i++)
       { peakIndex[i] = i;
         peakValue[i] = data[i];
       }
       peakNum = dataLength-1;
    }
 
    /* Least square fitting */

    a11=peakNum;
    for (i=0;i<peakNum;i++)
    {   a12 += peakIndex[i];
        a22 += peakIndex[i]*peakIndex[i];
        b1 += peakValue[i];
        b2 += peakIndex[i]*peakValue[i];
    }
    a = a11*a22-a12*a12;
    if ( a != 0.0 )
       slope=(-a12*b1+a11*b2)/a;
    else
       slope=0.0;
    return(slope);
}

/*      linearInt:      perform linear integration
 *      (       times:          integration times
 *              fitDataNum:     the number of the frequency samples used
 *                              for slope estimation;
 *              data:           absolute value of DFT.
 *      )
 */
 
int linearInt(int times, int fitDataNum, double *data) {
  int i, j;
  for (j=1;j<=times;j++)
  {   for (i=1;i<fitDataNum;i++)
          data[i]=(data[i-1]*i+data[i])/(i+1);
  }
}
